/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.echo.http.EchoServerHandler;
import org.mockserver.echo.http.ErrorHandler;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.server.netty.codec.MockServerServerCodec;
import org.mockserver.socket.NettySslContextFactory;
import org.slf4j.event.Level;

public class EchoServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final MockServerLogger mockServerLogger;
    private final boolean secure;
    private final EchoServer.Error error;

    public EchoServerInitializer(MockServerLogger mockServerLogger, boolean secure, EchoServer.Error error) {
        if (!secure && error == EchoServer.Error.CLOSE_CONNECTION) {
            throw new IllegalArgumentException("Error type CLOSE_CONNECTION is not supported in non-secure mode");
        }
        this.mockServerLogger = mockServerLogger;
        this.secure = secure;
        this.error = error;
    }

    @Override
    public void initChannel(SocketChannel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.error != null) {
            pipeline.addLast(new ErrorHandler(this.error));
        }
        if (this.secure) {
            pipeline.addLast(NettySslContextFactory.nettySslContextFactory().createServerSslContext().newHandler(channel.alloc()));
        }
        if (this.mockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new LoggingHandler("EchoServer <-->"));
        }
        pipeline.addLast(new HttpServerCodec());
        pipeline.addLast(new HttpContentDecompressor());
        pipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
        pipeline.addLast(new MockServerServerCodec(this.mockServerLogger, this.secure));
        if (!this.secure && this.error == EchoServer.Error.CLOSE_CONNECTION) {
            throw new IllegalArgumentException("Error type CLOSE_CONNECTION is not supported in non-secure mode");
        }
        pipeline.addLast(new EchoServerHandler(this.mockServerLogger, this.error, channel.attr(EchoServer.LOG_FILTER).get(), channel.attr(EchoServer.NEXT_RESPONSE).get(), channel.attr(EchoServer.ONLY_RESPONSE).get()));
    }
}

