# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server import util


class Plmn(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, mcc: str=None, mnc: str=None):  # noqa: E501
        """Plmn - a model defined in Swagger

        :param mcc: The mcc of this Plmn.  # noqa: E501
        :type mcc: str
        :param mnc: The mnc of this Plmn.  # noqa: E501
        :type mnc: str
        """
        self.swagger_types = {
            'mcc': str,
            'mnc': str
        }

        self.attribute_map = {
            'mcc': 'mcc',
            'mnc': 'mnc'
        }
        self._mcc = mcc
        self._mnc = mnc

    @classmethod
    def from_dict(cls, dikt) -> 'Plmn':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Plmn of this Plmn.  # noqa: E501
        :rtype: Plmn
        """
        return util.deserialize_model(dikt, cls)

    @property
    def mcc(self) -> str:
        """Gets the mcc of this Plmn.

        The Mobile Country Code part of PLMN Identity as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :return: The mcc of this Plmn.
        :rtype: str
        """
        return self._mcc

    @mcc.setter
    def mcc(self, mcc: str):
        """Sets the mcc of this Plmn.

        The Mobile Country Code part of PLMN Identity as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :param mcc: The mcc of this Plmn.
        :type mcc: str
        """
        if mcc is None:
            raise ValueError("Invalid value for `mcc`, must not be `None`")  # noqa: E501

        self._mcc = mcc

    @property
    def mnc(self) -> str:
        """Gets the mnc of this Plmn.

        The Mobile Network Code part of PLMN Identity as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :return: The mnc of this Plmn.
        :rtype: str
        """
        return self._mnc

    @mnc.setter
    def mnc(self, mnc: str):
        """Sets the mnc of this Plmn.

        The Mobile Network Code part of PLMN Identity as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :param mnc: The mnc of this Plmn.
        :type mnc: str
        """
        if mnc is None:
            raise ValueError("Invalid value for `mnc`, must not be `None`")  # noqa: E501

        self._mnc = mnc
