# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server import util


class S1BearerInfoEnbInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, ip_address: str=None, tunnel_id: str=None):  # noqa: E501
        """S1BearerInfoEnbInfo - a model defined in Swagger

        :param ip_address: The ip_address of this S1BearerInfoEnbInfo.  # noqa: E501
        :type ip_address: str
        :param tunnel_id: The tunnel_id of this S1BearerInfoEnbInfo.  # noqa: E501
        :type tunnel_id: str
        """
        self.swagger_types = {
            'ip_address': str,
            'tunnel_id': str
        }

        self.attribute_map = {
            'ip_address': 'ipAddress',
            'tunnel_id': 'tunnelId'
        }
        self._ip_address = ip_address
        self._tunnel_id = tunnel_id

    @classmethod
    def from_dict(cls, dikt) -> 'S1BearerInfoEnbInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The S1BearerInfo_enbInfo of this S1BearerInfoEnbInfo.  # noqa: E501
        :rtype: S1BearerInfoEnbInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ip_address(self) -> str:
        """Gets the ip_address of this S1BearerInfoEnbInfo.

        eNB transport layer address of this S1 bearer.  # noqa: E501

        :return: The ip_address of this S1BearerInfoEnbInfo.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str):
        """Sets the ip_address of this S1BearerInfoEnbInfo.

        eNB transport layer address of this S1 bearer.  # noqa: E501

        :param ip_address: The ip_address of this S1BearerInfoEnbInfo.
        :type ip_address: str
        """
        if ip_address is None:
            raise ValueError("Invalid value for `ip_address`, must not be `None`")  # noqa: E501

        self._ip_address = ip_address

    @property
    def tunnel_id(self) -> str:
        """Gets the tunnel_id of this S1BearerInfoEnbInfo.

        eNB GTP-U TEID of this S1 bearer.  # noqa: E501

        :return: The tunnel_id of this S1BearerInfoEnbInfo.
        :rtype: str
        """
        return self._tunnel_id

    @tunnel_id.setter
    def tunnel_id(self, tunnel_id: str):
        """Sets the tunnel_id of this S1BearerInfoEnbInfo.

        eNB GTP-U TEID of this S1 bearer.  # noqa: E501

        :param tunnel_id: The tunnel_id of this S1BearerInfoEnbInfo.
        :type tunnel_id: str
        """
        if tunnel_id is None:
            raise ValueError("Invalid value for `tunnel_id`, must not be `None`")  # noqa: E501

        self._tunnel_id = tunnel_id
