/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;

final class ValidationHandler
implements ErrorHandler {
    private List<ValidationProblem> problems = new LinkedList<ValidationProblem>();
    private boolean valid = true;
    private SAXParseException lastFatalError = null;

    ValidationHandler() {
    }

    @Override
    public void error(SAXParseException e) {
        if (e != this.lastFatalError) {
            this.valid = false;
            this.problems.add(ValidationProblem.fromException(e, ValidationProblem.ProblemType.ERROR));
        }
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.valid = false;
        this.lastFatalError = e;
        this.problems.add(ValidationProblem.fromException(e, ValidationProblem.ProblemType.ERROR));
    }

    @Override
    public void warning(SAXParseException e) {
        this.problems.add(ValidationProblem.fromException(e, ValidationProblem.ProblemType.WARNING));
    }

    ValidationResult getResult() {
        return new ValidationResult(this.valid, Collections.unmodifiableList(this.problems));
    }
}

