# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.associate_id import AssociateId  # noqa: F401,E501
from swagger_server.models.rab_info_erab_info import RabInfoErabInfo  # noqa: F401,E501
from swagger_server import util


class RabInfoUeInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, associate_id: List[AssociateId]=None, erab_info: List[RabInfoErabInfo]=None):  # noqa: E501
        """RabInfoUeInfo - a model defined in Swagger

        :param associate_id: The associate_id of this RabInfoUeInfo.  # noqa: E501
        :type associate_id: List[AssociateId]
        :param erab_info: The erab_info of this RabInfoUeInfo.  # noqa: E501
        :type erab_info: List[RabInfoErabInfo]
        """
        self.swagger_types = {
            'associate_id': List[AssociateId],
            'erab_info': List[RabInfoErabInfo]
        }

        self.attribute_map = {
            'associate_id': 'associateId',
            'erab_info': 'erabInfo'
        }
        self._associate_id = associate_id
        self._erab_info = erab_info

    @classmethod
    def from_dict(cls, dikt) -> 'RabInfoUeInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RabInfo_ueInfo of this RabInfoUeInfo.  # noqa: E501
        :rtype: RabInfoUeInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def associate_id(self) -> List[AssociateId]:
        """Gets the associate_id of this RabInfoUeInfo.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :return: The associate_id of this RabInfoUeInfo.
        :rtype: List[AssociateId]
        """
        return self._associate_id

    @associate_id.setter
    def associate_id(self, associate_id: List[AssociateId]):
        """Sets the associate_id of this RabInfoUeInfo.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :param associate_id: The associate_id of this RabInfoUeInfo.
        :type associate_id: List[AssociateId]
        """

        self._associate_id = associate_id

    @property
    def erab_info(self) -> List[RabInfoErabInfo]:
        """Gets the erab_info of this RabInfoUeInfo.

        Information on E-RAB as defined below.  # noqa: E501

        :return: The erab_info of this RabInfoUeInfo.
        :rtype: List[RabInfoErabInfo]
        """
        return self._erab_info

    @erab_info.setter
    def erab_info(self, erab_info: List[RabInfoErabInfo]):
        """Sets the erab_info of this RabInfoUeInfo.

        Information on E-RAB as defined below.  # noqa: E501

        :param erab_info: The erab_info of this RabInfoUeInfo.
        :type erab_info: List[RabInfoErabInfo]
        """

        self._erab_info = erab_info
