# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.associate_id import AssociateId  # noqa: F401,E501
from swagger_server.models.cell_change_notification_temp_ue_id import CellChangeNotificationTempUeId  # noqa: F401,E501
from swagger_server.models.ecgi import Ecgi  # noqa: F401,E501
from swagger_server.models.time_stamp import TimeStamp  # noqa: F401,E501
from swagger_server import util


class CellChangeNotification(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, associate_id: List[AssociateId]=None, ho_status: int=None, notification_type: str=None, src_ecgi: Ecgi=None, temp_ue_id: CellChangeNotificationTempUeId=None, time_stamp: TimeStamp=None, trg_ecgi: List[Ecgi]=None):  # noqa: E501
        """CellChangeNotification - a model defined in Swagger

        :param associate_id: The associate_id of this CellChangeNotification.  # noqa: E501
        :type associate_id: List[AssociateId]
        :param ho_status: The ho_status of this CellChangeNotification.  # noqa: E501
        :type ho_status: int
        :param notification_type: The notification_type of this CellChangeNotification.  # noqa: E501
        :type notification_type: str
        :param src_ecgi: The src_ecgi of this CellChangeNotification.  # noqa: E501
        :type src_ecgi: Ecgi
        :param temp_ue_id: The temp_ue_id of this CellChangeNotification.  # noqa: E501
        :type temp_ue_id: CellChangeNotificationTempUeId
        :param time_stamp: The time_stamp of this CellChangeNotification.  # noqa: E501
        :type time_stamp: TimeStamp
        :param trg_ecgi: The trg_ecgi of this CellChangeNotification.  # noqa: E501
        :type trg_ecgi: List[Ecgi]
        """
        self.swagger_types = {
            'associate_id': List[AssociateId],
            'ho_status': int,
            'notification_type': str,
            'src_ecgi': Ecgi,
            'temp_ue_id': CellChangeNotificationTempUeId,
            'time_stamp': TimeStamp,
            'trg_ecgi': List[Ecgi]
        }

        self.attribute_map = {
            'associate_id': 'associateId',
            'ho_status': 'hoStatus',
            'notification_type': 'notificationType',
            'src_ecgi': 'srcEcgi',
            'temp_ue_id': 'tempUeId',
            'time_stamp': 'timeStamp',
            'trg_ecgi': 'trgEcgi'
        }
        self._associate_id = associate_id
        self._ho_status = ho_status
        self._notification_type = notification_type
        self._src_ecgi = src_ecgi
        self._temp_ue_id = temp_ue_id
        self._time_stamp = time_stamp
        self._trg_ecgi = trg_ecgi

    @classmethod
    def from_dict(cls, dikt) -> 'CellChangeNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The CellChangeNotification of this CellChangeNotification.  # noqa: E501
        :rtype: CellChangeNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def associate_id(self) -> List[AssociateId]:
        """Gets the associate_id of this CellChangeNotification.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :return: The associate_id of this CellChangeNotification.
        :rtype: List[AssociateId]
        """
        return self._associate_id

    @associate_id.setter
    def associate_id(self, associate_id: List[AssociateId]):
        """Sets the associate_id of this CellChangeNotification.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :param associate_id: The associate_id of this CellChangeNotification.
        :type associate_id: List[AssociateId]
        """

        self._associate_id = associate_id

    @property
    def ho_status(self) -> int:
        """Gets the ho_status of this CellChangeNotification.

        Indicate the status of the UE handover procedure. Values are defined as following: <p>1 = IN_PREPARATION. <p>2 = IN_EXECUTION. <p>3 = COMPLETED. <p>4 = REJECTED. <p>5 = CANCELLED.  # noqa: E501

        :return: The ho_status of this CellChangeNotification.
        :rtype: int
        """
        return self._ho_status

    @ho_status.setter
    def ho_status(self, ho_status: int):
        """Sets the ho_status of this CellChangeNotification.

        Indicate the status of the UE handover procedure. Values are defined as following: <p>1 = IN_PREPARATION. <p>2 = IN_EXECUTION. <p>3 = COMPLETED. <p>4 = REJECTED. <p>5 = CANCELLED.  # noqa: E501

        :param ho_status: The ho_status of this CellChangeNotification.
        :type ho_status: int
        """
        allowed_values = ["1", "2", "3", "4", "5"]  # noqa: E501
        if ho_status not in allowed_values:
            raise ValueError(
                "Invalid value for `ho_status` ({0}), must be one of {1}"
                .format(ho_status, allowed_values)
            )

        self._ho_status = ho_status

    @property
    def notification_type(self) -> str:
        """Gets the notification_type of this CellChangeNotification.

        Shall be set to \"CellChangeNotification\".  # noqa: E501

        :return: The notification_type of this CellChangeNotification.
        :rtype: str
        """
        return self._notification_type

    @notification_type.setter
    def notification_type(self, notification_type: str):
        """Sets the notification_type of this CellChangeNotification.

        Shall be set to \"CellChangeNotification\".  # noqa: E501

        :param notification_type: The notification_type of this CellChangeNotification.
        :type notification_type: str
        """
        if notification_type is None:
            raise ValueError("Invalid value for `notification_type`, must not be `None`")  # noqa: E501

        self._notification_type = notification_type

    @property
    def src_ecgi(self) -> Ecgi:
        """Gets the src_ecgi of this CellChangeNotification.


        :return: The src_ecgi of this CellChangeNotification.
        :rtype: Ecgi
        """
        return self._src_ecgi

    @src_ecgi.setter
    def src_ecgi(self, src_ecgi: Ecgi):
        """Sets the src_ecgi of this CellChangeNotification.


        :param src_ecgi: The src_ecgi of this CellChangeNotification.
        :type src_ecgi: Ecgi
        """
        if src_ecgi is None:
            raise ValueError("Invalid value for `src_ecgi`, must not be `None`")  # noqa: E501

        self._src_ecgi = src_ecgi

    @property
    def temp_ue_id(self) -> CellChangeNotificationTempUeId:
        """Gets the temp_ue_id of this CellChangeNotification.


        :return: The temp_ue_id of this CellChangeNotification.
        :rtype: CellChangeNotificationTempUeId
        """
        return self._temp_ue_id

    @temp_ue_id.setter
    def temp_ue_id(self, temp_ue_id: CellChangeNotificationTempUeId):
        """Sets the temp_ue_id of this CellChangeNotification.


        :param temp_ue_id: The temp_ue_id of this CellChangeNotification.
        :type temp_ue_id: CellChangeNotificationTempUeId
        """

        self._temp_ue_id = temp_ue_id

    @property
    def time_stamp(self) -> TimeStamp:
        """Gets the time_stamp of this CellChangeNotification.


        :return: The time_stamp of this CellChangeNotification.
        :rtype: TimeStamp
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp: TimeStamp):
        """Sets the time_stamp of this CellChangeNotification.


        :param time_stamp: The time_stamp of this CellChangeNotification.
        :type time_stamp: TimeStamp
        """

        self._time_stamp = time_stamp

    @property
    def trg_ecgi(self) -> List[Ecgi]:
        """Gets the trg_ecgi of this CellChangeNotification.

        E-UTRAN Cell Global Identifier of the target cell. NOTE: Cardinality N is valid only in case of statuses IN_PREPARATION, REJECTED and CANCELLED.  # noqa: E501

        :return: The trg_ecgi of this CellChangeNotification.
        :rtype: List[Ecgi]
        """
        return self._trg_ecgi

    @trg_ecgi.setter
    def trg_ecgi(self, trg_ecgi: List[Ecgi]):
        """Sets the trg_ecgi of this CellChangeNotification.

        E-UTRAN Cell Global Identifier of the target cell. NOTE: Cardinality N is valid only in case of statuses IN_PREPARATION, REJECTED and CANCELLED.  # noqa: E501

        :param trg_ecgi: The trg_ecgi of this CellChangeNotification.
        :type trg_ecgi: List[Ecgi]
        """
        if trg_ecgi is None:
            raise ValueError("Invalid value for `trg_ecgi`, must not be `None`")  # noqa: E501

        self._trg_ecgi = trg_ecgi
