/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.mockserver.model.HttpRequest;

public class XPathStringMatcher
extends BodyMatcher<String> {
    private static final String[] excludedFields = new String[]{"mockServerLogger", "xpathExpression"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private final StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();
    private XPathExpression xpathExpression = null;

    public XPathStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        if (StringUtils.isNotEmpty(matcher)) {
            try {
                this.xpathExpression = XPathFactory.newInstance().newXPath().compile(matcher);
            }
            catch (XPathExpressionException e) {
                mockServerLogger.trace("Error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean matches(final HttpRequest context, String matched) {
        boolean result = false;
        if (this.xpathExpression == null) {
            this.mockServerLogger.trace(context, "Attempting match against null XPath Expression for [" + matched + "]" + new RuntimeException("Attempting match against null XPath Expression for [" + matched + "]"), new Object[0]);
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                result = (Boolean)this.xpathExpression.evaluate(this.stringToXmlDocumentParser.buildDocument(matched, new StringToXmlDocumentParser.ErrorLogger(){

                    @Override
                    public void logError(String matched, Exception exception) {
                        XPathStringMatcher.this.mockServerLogger.warn(context, "SAXParseException while performing match between [" + XPathStringMatcher.this.matcher + "] and [" + matched + "]", exception);
                    }
                }), XPathConstants.BOOLEAN);
            }
            catch (Exception e) {
                this.mockServerLogger.trace(context, "Error while matching xpath [" + this.matcher + "] against string [" + matched + "] assuming no match - " + e.getMessage(), new Object[0]);
            }
        }
        if (!result) {
            this.mockServerLogger.trace("Failed to match [{}] with [{}]", matched, this.matcher);
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

