# gPRC for mec012

The ETSI MEC ISG MEC012 Radio Network Information API described using OpenAPI.

## Overview
These files were generated by the [OpenAPI Generator](https://openapi-generator.tech) project.

- API version: 2.2.1
- Package version: 
- Build package: org.openapitools.codegen.languages.ProtobufSchemaCodegen
For more information, please visit [https://forge.etsi.org/rep/mec/gs012-rnis-api](https://forge.etsi.org/rep/mec/gs012-rnis-api)

## Usage

Below are some usage examples for Python, Go and Ruby. For other languages, please refer to https://grpc.io/docs/quickstart/.


### Python

1. Install the grpcio-tools package
    ```sh
    $ pip install grpcio-tools
    ```

2. Create a directory for generated Python stubs
    ```sh
    $ mkdir python-stubs 
    ```

3. Run the following commands from the root of the directory containing this README that you are reading.

   - Models:
  
        ```sh
        $ python3 -m grpc_tools.protoc -I./proto3 --python_out=./python-stubs ./proto3/models/*
        ```
    
        The above command will generate .py files for all the data models in the ./models directory

   - Services:

        ```sh
        $ python3 -m grpc_tools.protoc -I./proto3 --python_out=./python-stubs --grpc_python_out=./python-stubs ./proto3/services/rni-service.proto
        ```

        The above command will generate two files for the RNI service:
        - _rni_service_pb2.py_: containing the python data models used in the RNI service file
        - _rni_service_pb2_grpc.py_: containing all the classes and functions needed for the supported HTTP methods in the RNI API

### Go

1. Install protocol buffer compiler
    ```sh
    $ apt install -y protobuf-compiler
    ```
2. Install Go plugins for `protoc`
    ```sh
    $ go install google.golang.org/protobuf/cmd/protoc-gen-go@v1.26
    ```
    ```sh
    $ go install google.golang.org/grpc/cmd/protoc-gen-go-grpc@v1.1
    ```
3. Update `PATH` so `protoc` can find the plugins
    ```sh
    $ export PATH="$PATH:$(go env GOPATH)/bin"
    ```
4. Define a go package by appending `option go_package = "./mec012";` in all .proto files like this:

    ```Go
    ...

    syntax = "proto3";

    package mec012;

    option go_package = "./mec012";

    import public "models/<xyz>.proto";

    ...
    ```
5. Generate Go code for models and services
    ```sh 
    $ mkdir go-stubs
    $ protoc --go_out=./go-stubs ./proto3/models/* -I./proto3
    $ protoc --go_out=./go-stubs ./proto3/services/* --go-grpc_out=go-stubs -I./proto3
    ```
    > The generated `<data_model>.pb.go` files will contain all the protocol buffer code to populate, serialize, and retrieve request and response message types defined in the `models` folder.
    > And the `rni_service_grpc.pb.go` will contain the stubs for the methods defined in the `rni_service.proto` file.


### Ruby

1. Install gRPC Ruby Plugin and required tools
   ```sh
   $ gem install grpc
   $ sudo apt install ruby-grpc-tools
   ```

2. Generate code
    ```sh
    $ mkdir ruby-stubs
    ```
    
    Run the following command to create Ruby modules for all the data models defined in the proto files.

    ```sh
    $ grpc_tools_ruby_protoc -I./proto3 --ruby_out=ruby-stubs ./proto3/models/*
    ```
    Run the following command to generate `rni_service_pb.rb` and `rni_service_services_pb.rb` files, containing stub and service classes for the endpoints and methods defined in MEC012 RNI service.

    ```sh
    $ grpc_tools_ruby_protoc -I./proto3 --ruby_out=ruby-stubs --grpc_out=ruby-stubs ./proto3/services/*
    ```