import logging
from compile_asn import *


if __name__ == '__main__':
    log = logging.getLogger()
    log.setLevel(logging.INFO)
    parseErrors, compileErrors, parser = validateAllASN1FilesInPath("./")
    parseErrorCount = 0
    print ("ASN.1 Parser checks:")
    print ("-----------------------------")
    for filename, errors in parseErrors.items():
        if len(errors) > 0:
            parseErrorCount += len(errors)
            print (f"{filename}: {len(errors)} errors")
            for error in errors:
                print ("  " + str(error))
        else:
            print (f"{filename}: OK")
    print ("-----------------------------")
    print ("ASN.1 Compilation:")
    print ("-----------------------------")
    if len(compileErrors) > 0:
        for error in compileErrors:            
            print ("  " + str(error))
    else:
        print ("Compilation OK")
    print ("-----------------------------")
    print (f"{parseErrorCount} parse errors, {len(compileErrors)} compile errors")
    exit (parseErrorCount + len(compileErrors))

