import glob
import sys
from pathlib import Path
from pprint import pprint

if __name__ == '__main__':

    if sys.version_info <= (3, 5):
        sys.exit('ERROR: You need at least Python 3.5 to run this tool')

    try:
        from lxml import etree
    except ImportError:
        sys.exit('ERROR: You need to install the Python lxml library')

    try:
        import xmlschema
    except ImportError:
        sys.exit('ERROR: You need to install the xml schema library')


    locations = []
    schemaFiles = glob.glob('schema/*.xsd')
    for schemaFile in schemaFiles:
        xs = xmlschema.XMLSchema(schemaFile, validation='skip')
        locations.append((xs.default_namespace, str(Path(schemaFile))[7:]))

    coreSchema = xmlschema.XMLSchema('schema/ts_103120v010501p0_Core.xsd', locations=locations)

    for schema in schemaFiles:
        newSchema = xmlschema.XMLSchema(schema, locations=locations)
        coreSchema.import_schema(newSchema.default_namespace, schema)

    examples = glob.glob('examples/*.xml')
    for example in examples:
        try:
            coreSchema.validate(example)
            print ("{0} passed validation".format(example))
        except Exception as ex:
            print ("{0} failed validation: {1}".format(example, ex))

    print ('Done')