import glob
import sys
from pathlib import Path
from pprint import pprint

if __name__ == '__main__':

    if sys.version_info <= (3, 5):
        sys.exit('ERROR: You need at least Python 3.5 to run this tool')

    try:
        from lxml import etree
    except ImportError:
        sys.exit('ERROR: You need to install the Python lxml library')

    try:
        import xmlschema
    except ImportError:
        sys.exit('ERROR: You need to install the xml schema library')


    extraSchemas = [
        'examples/FooServiceSchema.xsd',
        'TS_103_280_v020301.xsd'
    ]

    locations = []
    for schemaFile in extraSchemas:
        xs = xmlschema.XMLSchema(schemaFile, validation='skip')
        locations.append((xs.default_namespace, str(Path(schemaFile))))

    coreSchema = xmlschema.XMLSchema('TS_103_707_v010201.xsd', locations=locations)

    for schema in extraSchemas:
        newSchema = xmlschema.XMLSchema(schema)
        coreSchema.import_schema(newSchema.default_namespace, schema)

    examples = glob.glob('examples/*.xml')
    for example in examples:
        try:
            coreSchema.validate(example)
            print ("{0} passed validation".format(example))
        except Exception as ex:
            print ("{0} failed validation: {1}".format(example, ex))

    print ('Done')