#!/bin/bash
# Prepare environment for the build
#set -e # Exit with non 0 if any command fails
#set -vx

# Update system
sudo DEBIAN_FRONTEND=noninteractive apt-get update
sudo DEBIAN_FRONTEND=noninteractive apt-get dist-upgrade -y
sudo DEBIAN_FRONTEND=noninteractive apt-get install software-properties-common -y
sudo DEBIAN_FRONTEND=noninteractive apt-get update
sudo DEBIAN_FRONTEND=noninteractive apt-get --allow-unauthenticated install emacs openjdk-11-jre gcc-9 g++-9 git subversion lsof ntp gdb make cmake flex bison autoconf doxygen graphviz libedit2 libedit-dev libtool libncurses5-dev expect libssl-dev libgcrypt-dev libxml2-dev xutils-dev tcpdump libpcap-dev libwireshark-dev wget tree unzip sshpass kubuntu-desktop valgrind qt5-default qttools5-dev qtmultimedia5-dev libqt5svg5-dev vim tzdata dos2unix xsltproc -y
#sudo DEBIAN_FRONTEND=noninteractive apt --fix-broken install -y
sudo DEBIAN_FRONTEND=noninteractive apt-get autoremove --purge -y
sudo DEBIAN_FRONTEND=noninteractive apt-get clean

gcc --version
g++ --version
valgrind --version

export HOME=/home/vagrant

export PATH_DEV=${HOME}/dev
export HOME_FRAMEWORKS=${HOME}/frameworks
export HOME_LIB=${HOME}/lib
export HOME_BIN=${HOME}/bin
export HOME_ETC=${HOME}/etc
export HOME_INC=${HOME}/include
export HOME_TMP=${HOME}/tmp
export HOME_DOCS=${HOME}/docs
export PATH=${HOME_BIN}:${PATH}
export LD_LIBRARY_PATH=${HOME_LIB}:/usr/local/lib:${LD_LIBRARY_PATH}

OLD_PWD=`pwd`
# Create directories
mkdir -p ${HOME_LIB}
if [ ! -d ${HOME_LIB} ]
then
    exit -1
fi
mkdir -p ${HOME_INC}
if [ ! -d ${HOME_INC} ]
then
    exit -1
fi
mkdir -p ${HOME_BIN}
if [ ! -d ${HOME_BIN} ]
then
    exit -1
fi
mkdir -p ${HOME_TMP}
if [ ! -d ${HOME_TMP} ]
then
    exit -1
fi
mkdir -p ${HOME_DOCS}
if [ ! -d ${HOME_DOCS} ]
then
    exit -1
fi
mkdir -p ${HOME_FRAMEWORKS}
if [ ! -d ${HOME_FRAMEWORKS} ]
then
    exit -1
fi
mkdir -p ${PATH_DEV}
if [ ! -d ${PATH_DEV} ]
then
    exit -1
fi

cd /home/vagrant
echo "" >> /home/vagrant/.bashrc
echo "export LD_LIBRARY_PATH=/home/vagrant/dev/emergency-iop/lib:$LD_LIBRARY_PATH" >> /home/vagrant/.bashrc
echo "export PATH=/home/vagrant/bin:$PATH" >> /home/vagrant/.bashrc
echo ". ~/devenv.bash" >> /home/vagrant/.bashrc

cd /home/vagrant/dev
git clone --recurse-submodules --branch=devel https://forge.etsi.org/rep/int/vxlte/emergency-iop.git
cd /home/vagrant/dev/emergency-iop
./install.sh

# Install all frameworks

# Install osip
cd ${HOME_FRAMEWORKS}
git clone git://git.savannah.gnu.org/osip.git ./osip
cd ./osip
./autogen.sh
./configure --prefix=/home/vagrant
make && make install

# Install GoogleTest
cd ${HOME_FRAMEWORKS}
git clone https://github.com/google/googletest.git googletest
cd ${HOME_FRAMEWORKS}/googletest/
cmake .
make CXX=g++
sudo make install

# Install latest LCOV
cd ${HOME_FRAMEWORKS}
mkdir -p ${HOME_FRAMEWORKS}/lcov
cd ${HOME_FRAMEWORKS}/lcov
wget http://ftp.de.debian.org/debian/pool/main/l/lcov/lcov_1.13.orig.tar.gz
tar xf lcov_1.13.orig.tar.gz
sudo make -C lcov-1.13/ install

# Install lcov to coveralls conversion
sudo gem install coveralls-lcov

lcov --version
coveralls-lcov -h

# Build TITAN
cd /home/vagrant/dev/emergency-iop/scripts
./build_titan.bash
. /home/vagrant/devenv.bash

# Build the AtsLIS
cd /home/vagrant/dev/emergency-iop
export ATS=AtsLIS
make

# Change user in cfg files
cd ${HOME}/dev/emergency-iop/scripts
./update_user_name.sh emergency-iop

cd ${OLD_PWD}

sudo init 6

exit 0
