#!/usr/bin/env bash

set -euo pipefail

usage() {
	echo "No command specified. Available commands:"
	for i in $(echo $commands | sed "s/,/ /g")
	do
		echo "  $i"
	done
}

commands="help,build,clean,list,modulepar,rebuild,run,version"

if [ $# == 0 ]; then
  usage
	exit 1
fi

if [ $# == 2 ]; then 
  if [ "$2" != "" ]; then
    export ATS=Ats$2
    cli="${GEN_DIR}/bin/$ATS"
    echo "cli: $cli"
  fi
fi


case "$1" in
  build)
    cd ${GEN_DIR} && make
    ;;
  clean)
    cd ${GEN_DIR} && make clean
    ;;
  list)
    ${cli} -l
    ;;
  modulepar)
    ${cli} -p
    ;;
  rebuild)
    cd ${GEN_DIR} && rm -fr ./bin ./build ; make
    ;;
  run)
    cd ${GEN_DIR}/scripts && ./run_all.bash
    ;;
  version)
    compiler -v
    ;;
  *)
    usage
    exit 1
    ;;
esac

unset ATS
exit 0