#!/bin/bash

#set -e
set -vx

echo -e "*****************************\n* Checkout TTF T012 sources\n*****************************\n"
mkdir -p ${HOME}/dev && cd ${HOME}/dev || exit 1

git clone --branch devel --recurse-submodules --single-branch https://forge.etsi.org/rep/int/vxlte/emergency-iop.git || exit 1

echo -e "*****************************\n* Set up environment\n*****************************\n"
cd /home/etsi/dev/emergency-iop/scripts || exit 1
ln -sf /home/etsi/dev/emergency-iop/scripts/devenv.bash.ubuntu /home/etsi/devenv.bash || exit 1
. /home/etsi/devenv.bash || exit 1

echo -e "*****************************\n* Apply patched \n*****************************\n"
cd /home/etsi/dev/emergency-iop || exit 1
./install.sh || exit 1

echo -e "*****************************\n* Build test suites\n*****************************\n"
ATS_LIST="AtsLIS AtsECRF AtsESRP AtsPSAP AtsBCF"
for i in ${ATS_LIST}
do
    export ATS=$i
    make
done

echo -e "*****************************\n* Init Eclipse Workspace\n*****************************\n"

echo -e "*****************************\n* Setup a configuration file\n*****************************\n"
cd ./etc/AtsImsIot
ln -sf AtsImsIot.cfg_ AtsImsIot.cfg
cd -

echo -e "*****************************\n* Change sudo in command line\n*****************************\n"
cd /home/etsi/dev/emergency-iop/scripts
export ATS=AtsLIS
#sed --in-place 's/sudo/echo "etsi" \| sudo -S/' ./run_all.bash

cd /home/etsi/dev/emergency-iop

