#!/bin/bash

#set -e
set -vx

BASE_PATH=`pwd`

git checkout devel
git submodule update --init --recursive --remote

if [ ! -f ./titan-test-system-framework ]
then
    git clone --recurse-submodules --branch devel https://labs.etsi.org/rep/cti-tools/titan-test-system-framework.git
    cd ./titan-test-system-framework
else
    cd ./titan-test-system-framework
    git checkout devel
fi
cd ./ttcn/LibHttp
ln -sf module_emtel.mk module.mk

cd $BASE_PATH/ttcn/LibSip
git checkout TTF016

cd $BASE_PATH/ttcn/LibMsrp
git checkout TTF006

cd $BASE_PATH/ttcn/LibIms
git checkout TTF006

cd $BASE_PATH
ln -f ./ttcn/patch_lib_common_titan/module.mk ./ttcn/LibCommon/
ln -f ./ttcn/patch_lib_ims_titan/module.mk ./ttcn/LibIms/
ln -f ./ttcn/patch_lib_sip_titan/module.mk ./ttcn/LibSip/
ln -f ./ttcn/patch_lib_diameter_titan/module.mk ./ttcn/LibDiameter
ln -f ./ttcn/patch_lib_msrp_titan/module.mk ./ttcn/LibMsrp
ln -f ./ttcn/patch_lib_iot_titan/module.mk ./ttcn/LibIot
ln -f ./ttcn/patch_lib_config_and_trigger_titan/module.mk ./ttcn/LibIms_ConfigAndTrigger
ln -f ./ttcn/patch_lib_upper_tester_titan/module.mk ./ttcn/LibUpperTester
ln -f ./ttcn/patch_ats_ims_iot/module.mk ./ttcn/AtsImsIot

exit 0
