#include "LibIot_TestInterface.hh"
#include "LibUpperTester.hh"

#include "upper_tester_layer_factory.hh"

#include "loggers.hh"

#include "converter.hh"

upper_tester_layer::upper_tester_layer(const std::string & p_type, const std::string & p_param) : t_layer<LibIot__TestInterface::EquipmentAccessPort>(p_type), _params() {
  loggers::get_instance().log(">>> upper_tester_layer::upper_tester_layer: %s, %s", to_string().c_str(), p_param.c_str());
  // Setup parameters
  params::convert(_params, p_param);
}

void upper_tester_layer::sendMsg(const LibUpperTester::EquipmentOperationReq& p_equipment_operation_req, params& p_param) {
  loggers::get_instance().log_msg(">>> upper_tester_layer::sendMsg: ", p_equipment_operation_req);

  // Encode DiameterMessage
  OCTETSTRING data;
  //_codec_register.encode(p_equipment_operation_req, data);
  //send_data(data, _params);
}

void upper_tester_layer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> upper_tester_layer::send_data: ", data);

  send_to_all_layers(data, p_params);
}

void upper_tester_layer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> upper_tester_layer::receive_data: ", data);

  // Decode Diameter message
}

upper_tester_layer_factory upper_tester_layer_factory::_f;

