/*!
 * \file      sip_layer.hh
 * \brief     Header file for ITS HTTP protocol layer.
 * \author    ETSI STF549
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include <memory>

#include "t_layer.hh"

#include "sip_codec_request.hh"
#include "sip_codec_response.hh"
#include "sip_codec_register_request.hh"
#include "sip_codec_invite_request.hh"
#include "sip_codec_ack_request.hh"
#include "sip_codec_subscribe_request.hh"
#include "sip_codec_message_request.hh"
#include "sip_codec_options_request.hh"
#include "sip_codec_notify_request.hh"
#include "sip_codec_cancel_request.hh"
#include "sip_codec_info_request.hh"
#include "sip_codec_bye_request.hh"

namespace LibSip__Interface {
  class SipPort; //! Forward declaration of TITAN class
}

namespace LibSip__SIPTypesAndValues {
  class REGISTER__Request; //! Forward declaration of TITAN class
  class INVITE__Request;   //! Forward declaration of TITAN class
  class ACK__Request;   //! Forward declaration of TITAN class
  class SUSCRIBE__Request; //! Forward declaration of TITAN class
  class MESSAGE__Request;  //! Forward declaration of TITAN class
  class OPTIONS__Request;   //! Forward declaration of TITAN class
  class CANCEL__Request;   //! Forward declaration of TITAN class
  class NOTIFY__Request;   //! Forward declaration of TITAN class
  class INFO__Request;   //! Forward declaration of TITAN class
  class BYE__Request;   //! Forward declaration of TITAN class
  class Resquest;          //! Forward declaration of TITAN class
  class Response;          //! Forward declaration of TITAN class
}

class OCTETSTRING; //! Forward declaration of TITAN class

/*!
 * \class sip_layer
 * \brief  This class provides a factory class to create an sip_layer class instance
 */
class sip_layer : public t_layer<LibSip__Interface::SipPort> {
  params _params;
  sip_codec_request _codec_request;
  sip_codec_response _codec_response;
  sip_codec_register_request _codec_register;
  sip_codec_invite_request _codec_invite;
  sip_codec_ack_request _codec_ack;
  sip_codec_subscribe_request _codec_subscribe;
  sip_codec_message_request _codec_message;
  sip_codec_options_request _codec_options;
  sip_codec_cancel_request _codec_cancel;
  sip_codec_notify_request _codec_notify;
  sip_codec_info_request _codec_info;
  sip_codec_bye_request _codec_bye;

public: //! \publicsection
  /*!
   * \brief Specialised constructor
   *        Create a new instance of the sip_layer class
   * \param[in] p_type \todo
   * \param[in] p_param \todo
   */
  sip_layer() : t_layer<LibSip__Interface::SipPort>(), _params(), _codec_request(), _codec_response(), _codec_register(), _codec_invite(), _codec_ack(), _codec_subscribe(), _codec_message(), _codec_options(), _codec_cancel(), _codec_notify(), _codec_info(), _codec_bye() {};
  /*!
   * \brief Specialised constructor
   *        Create a new instance of the sip_layer class
   * \param[in] p_type \todo
   * \param[in] p_param \todo
   */
  sip_layer(const std::string& p_type, const std::string& p_param);
  /*!
   * \brief Default destructor
   */
  virtual ~sip_layer() { };

  void sendMsg(const LibSip__SIPTypesAndValues::REGISTER__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::INVITE__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::ACK__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::SUBSCRIBE__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::MESSAGE__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::OPTIONS__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::BYE__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::CANCEL__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::NOTIFY__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::INFO__Request& p_sip_message, params& p_param);
  
  void sendMsg(const LibSip__SIPTypesAndValues::Response& p_sip_message, params& p_param);
  
  /*!
   * \virtual
   * \fn void send_data(OCTETSTRING& data, params& p_params);
   * \brief Send bytes formated data to the lower layers
   * \param[in] p_data The data to be sent
   * \param[in] p_params Some parameters to overwrite default value of the lower layers parameters
   */
  virtual void send_data(OCTETSTRING& data, params& p_params);
  /*!
   * \virtual
   * \fn void receive_data(OCTETSTRING& data, params& p_params);
   * \brief Receive bytes formated data from the lower layers
   * \param[in] p_data The bytes formated data received
   * \param[in] p_params Some lower layers parameters values when data was received
   */
  virtual void receive_data(OCTETSTRING& data, params& info);
}; // End of class sip_layer

