#pragma once

#include "codec_gen.hh"
#include "params.hh"

#include "osipparser2/osip_parser.h"
#include "osipparser2/sdp_message.h"

namespace LibSip__MessageBodyTypes {
  class MessageBody;
}

namespace LibSip__SDPTypes {
  class SDP__Messag;
}

namespace LibSip__XMLTypes {
  class XmlBody;
}

class sip_codec_message_body: public codec_gen <
LibSip__MessageBodyTypes::MessageBody,
LibSip__MessageBodyTypes::MessageBody>
{
public:
  explicit sip_codec_message_body() { };
  virtual ~sip_codec_message_body() { };

  virtual int encode (const LibSip__MessageBodyTypes::MessageBody& msg, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, LibSip__MessageBodyTypes::MessageBody& msg, params* p_params = NULL);

  virtual int encode_message_body(const LibSip__MessageBodyTypes::MessageBody& p_message_body, osip_message_t* p_sip_message);
  virtual void decode_message_body(const osip_message_t* p_sip_message, OPTIONAL<LibSip__MessageBodyTypes::MessageBody>& p_message_body);

private:
  int encode_sdp(const LibSip__SDPTypes::SDP__Message& p_message_body, sdp_message_t** p_sdp_body);
  int decode_sdp(const osip_body_t* p_body, LibSip__SDPTypes::SDP__Message& p_sdp_header);
  int encode_xml(const LibSip__XMLTypes::XmlBody& p_message_body, osip_body_t** p_body);
  int decode_xml(const osip_body_t* p_body, LibSip__XMLTypes::XmlBody& p_xml_header);

}; // End of class sip_codec_message_body
