#include "LibSip_SIPTypesAndValues.hh"

#include "sip_codec_cancel_request.hh"
#include "loggers.hh"

int sip_codec_cancel_request::encode (const LibSip__SIPTypesAndValues::CANCEL__Request& msg, OCTETSTRING& data)
{
  loggers::get_instance().log_msg(">>> sip_codec_cancel_request::encode: ", (const Base_Type&)msg);

  if (_codec.encode((LibSip__SIPTypesAndValues::Request&)msg, data) == -1) {
    loggers::get_instance().warning("sip_codec_cancel_request::encode: Failed to encode message");
    return -1;
  }
  
  loggers::get_instance().log_msg("<<< sip_codec_cancel_request::encode: data=", data);
  return 0;
}

int sip_codec_cancel_request::decode (const OCTETSTRING& data, LibSip__SIPTypesAndValues::CANCEL__Request& msg, params* p_params)
{
  loggers::get_instance().log_msg(">>> sip_codec_cancel_request::decode: data=", data);

  // Sanity checks
  if (data.lengthof() == 0) {
    loggers::get_instance().warning("sip_codec_cancel_request::decode: Wrong parameters");
    return -1;
  }

  //  LibSip__SIPTypesAndValues::Request request;
  if (_codec.decode(data, (LibSip__SIPTypesAndValues::Request&)msg) == -1) {
    //  if (_codec.decode(data, request) == -1) {
    loggers::get_instance().warning("sip_codec_cancel_request::decode: Failed to decode message");
    return -1;
  }
  // msg.requestLine() = request.requestLine();
  // msg.msgHeader() = request.msgHeader();
  // msg.messageBody() = request.messageBody();
  // msg.payload() = request.payload();

  if (msg.requestLine().method() != LibSip__SIPTypesAndValues::Method::CANCEL__E) {
    loggers::get_instance().warning("sip_codec_cancel_request::decode: Wrong SIP Method, expected CANCEL");
    return -1;
  }
  
  return 0;
}
