#include "AtsImsIot_TypesAndValues.hh"

#include "naptrPort_layer_factory.hh"

#include "loggers.hh"

#include "converter.hh"

naptr_layer::naptr_layer(const std::string & p_type, const std::string & p_param) : t_layer<AtsImsIot__TestSystem::NaptrPort>(p_type), _params() {
  loggers::get_instance().log(">>> naptr_layer::naptr_layer: %s, %s", to_string().c_str(), p_param.c_str());
  // Setup parameters
  params::convert(_params, p_param);
}

void naptr_layer::sendMsg(const AtsImsIot__TypesAndValues::NAPTRmessage& p_diameter_message, params& p_param) {
  loggers::get_instance().log_msg(">>> naptr_layer::sendMsg: ", p_diameter_message);

  // Encode DiameterMessage
  OCTETSTRING data;
  // _codec_register.encode(p_diameter_message, data);
  // send_data(data, _params);
}

void naptr_layer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> naptr_layer::send_data: ", data);

  send_to_all_layers(data, p_params);
}

void naptr_layer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> naptr_layer::receive_data: ", data);

  // Decode Diameter message
}

naptrPort_layer_factory naptrPort_layer_factory::_f;

