/*!
 * \file      lower_layer_pport_layer.hh
 * \brief     Header file for ITS HTTP protocol layer.
 * \author    ETSI STF549
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include <memory>

#include "t_layer.hh"

namespace LibDiameter__Interface {
  class LowerLayerPPort; //! Forward declaration of TITAN class
}

namespace LibDiameter__TypesAndValues {
  class Lower__Layer__Primitive; //! Forward declaration of TITAN class
}

class OCTETSTRING; //! Forward declaration of TITAN class

/*!
 * \class lower_layer_pport_layer
 * \brief  This class provides a factory class to create an lower_layer_pport_layer class instance
 */
class lower_layer_pport_layer : public t_layer<LibDiameter__Interface::LowerLayerPPort> {
  params _params;

public: //! \publicsection
  /*!
   * \brief Specialised constructor
   *        Create a new instance of the lower_layer_pport_layer class
   * \param[in] p_type \todo
   * \param[in] p_param \todo
   */
  lower_layer_pport_layer() : t_layer<LibDiameter__Interface::LowerLayerPPort>(), _params() {};
  /*!
   * \brief Specialised constructor
   *        Create a new instance of the lower_layer_pport_layer class
   * \param[in] p_type \todo
   * \param[in] p_param \todo
   */
  lower_layer_pport_layer(const std::string& p_type, const std::string& p_param);
  /*!
   * \brief Default destructor
   */
  virtual ~lower_layer_pport_layer() { };

  void sendMsg(const LibDiameter__TypesAndValues::Lower__Layer__Primitive& p_diameter_message, params& p_param);

  /*!
   * \virtual
   * \fn void send_data(OCTETSTRING& data, params& p_params);
   * \brief Send bytes formated data to the lower layers
   * \param[in] p_data The data to be sent
   * \param[in] p_params Some parameters to overwrite default value of the lower layers parameters
   */
  virtual void send_data(OCTETSTRING& data, params& p_params);
  /*!
   * \virtual
   * \fn void receive_data(OCTETSTRING& data, params& p_params);
   * \brief Receive bytes formated data from the lower layers
   * \param[in] p_data The bytes formated data received
   * \param[in] p_params Some lower layers parameters values when data was received
   */
  virtual void receive_data(OCTETSTRING& data, params& info);
}; // End of class lower_layer_pport_layer

