#include "LibDiameter_Interface.hh"
#include "LibDiameter_TypesAndValues.hh"

#include "lower_layer_pport_layer_factory.hh"

#include "loggers.hh"

#include "converter.hh"

lower_layer_pport_layer::lower_layer_pport_layer(const std::string & p_type, const std::string & p_param) : t_layer<LibDiameter__Interface::LowerLayerPPort>(p_type), _params() {
  loggers::get_instance().log(">>> lower_layer_pport_layer::lower_layer_pport_layer: %s, %s", to_string().c_str(), p_param.c_str());
  // Setup parameters
  params::convert(_params, p_param);
}

void lower_layer_pport_layer::sendMsg(const LibDiameter__TypesAndValues::Lower__Layer__Primitive& p_diameter_message, params& p_param) {
  loggers::get_instance().log_msg(">>> lower_layer_pport_layer::sendMsg: ", p_diameter_message);

  // Encode DiameterMessage
  OCTETSTRING data;
  // _codec_register.encode(p_diameter_message, data);
  // send_data(data, _params);
}

void lower_layer_pport_layer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> lower_layer_pport_layer::send_data: ", data);

  send_to_all_layers(data, p_params);
}

void lower_layer_pport_layer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> lower_layer_pport_layer::receive_data: ", data);

  // Decode Diameter message
}

lower_layer_pport_layer_factory lower_layer_pport_layer_factory::_f;

