#pragma once

#include "http_codec.hh"

#include "LibHttp_MessageBodyTypes.hh"

class http_codec_emtel : public http_codec {

public:
  explicit http_codec_emtel() : http_codec(){};
  virtual ~http_codec_emtel(){};

protected: //! \protectedsection
  bool encode_body_xml(const LibHttp__XmlMessageBodyTypes::XmlBody &p_xml_body, OCTETSTRING &p_encoding_buffer, const std::string &p_content_type);
  bool decode_body_xml(const OCTETSTRING &p_data, LibHttp__XmlMessageBodyTypes::XmlBody &p_xml_body, const std::string &p_content_type, params* p_params);
  bool encode_body_json(const LibHttp__JsonMessageBodyTypes::JsonBody &p_json_body, OCTETSTRING &p_encoding_buffer, const std::string &p_content_type);
  bool decode_body_json(const OCTETSTRING &p_data, LibHttp__JsonMessageBodyTypes::JsonBody &p_json_body, const std::string &p_content_type, params* p_params);
}; // End of class http_codec_emtel
