#pragma once

#include <vector>

#include "codec_gen.hh"
#include "params.hh"

#include "avp.hh" 
#include "diameter_codec.hh" 

class Base_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibDiameter__TypesAndValues {
  class UAR__MSG; //! Forward declaration of TITAN class
}

class diameter_uar_codec: public codec_gen <
  LibDiameter__TypesAndValues::UAR__MSG,
  LibDiameter__TypesAndValues::UAR__MSG>
{
  std::vector<avp> avps;
  diameter_codec   _codec;

public:
  diameter_uar_codec() : codec_gen<LibDiameter__TypesAndValues::UAR__MSG, LibDiameter__TypesAndValues::UAR__MSG>(), avps(), _codec() { };
  virtual ~diameter_uar_codec() { };

  virtual int encode (const LibDiameter__TypesAndValues::UAR__MSG& p_uar_msg, OCTETSTRING& p_data);
  virtual int decode (const OCTETSTRING& p_data, LibDiameter__TypesAndValues::UAR__MSG& p_uar_msg, params* p_params = NULL);

private:
  int encode_avps(const LibDiameter__TypesAndValues::UAR__MSG& p_uar_msg, TTCN_Buffer p_encoding_buffer);

  int decode_session_id(LibDiameter__Types__Base__AVPs::Session__Id__AVP& p_avp);
  int decode_auth_session_state(LibDiameter__Types__Base__AVPs::Auth__Session__State__AVP& p_avp);
  int decode_origin_host(LibDiameter__Types__Base__AVPs::Origin__Host__AVP& p_avp);
  int decode_destination_host(LibDiameter__Types__Base__AVPs::Destination__Host__AVP& p_avp);
  int decode_origin_realm(LibDiameter__Types__Base__AVPs::Origin__Realm__AVP& p_avp);
  int decode_destination_realm(LibDiameter__Types__Base__AVPs::Destination__Realm__AVP& p_avp);
  
}; // End of class diameter_uar_codec
