#include "LibDiameter_Interface.hh"
#include "LibDiameter_TypesAndValues.hh"

#include "diameter_layer_factory.hh"

#include "loggers.hh"

#include "converter.hh"

diameter_layer::diameter_layer(const std::string & p_type, const std::string & p_param) : t_layer<LibDiameter__Interface::DiameterPort>(p_type), _params() {
  loggers::get_instance().log(">>> diameter_layer::diameter_layer: %s, %s", to_string().c_str(), p_param.c_str());
  // Setup parameters
  params::convert(_params, p_param);
}

void diameter_layer::sendMsg(const LibDiameter__TypesAndValues::DIAMETER__MSG& p_diameter_message, params& p_param) {
  loggers::get_instance().log_msg(">>> diameter_layer::sendMsg: ", p_diameter_message);

  // Encode DiameterMessage
  OCTETSTRING data;
  // _codec_register.encode(p_diameter_message, data);
  // send_data(data, _params);
}

void diameter_layer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> diameter_layer::send_data: ", data);

  send_to_all_layers(data, p_params);
}

void diameter_layer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> diameter_layer::receive_data: ", data);

  // Decode Diameter message
}

diameter_layer_factory diameter_layer_factory::_f;

