#pragma once

#include <vector>
#include <memory>


#include "LibDiameter_TypesAndValues.hh"

class avp {
    const int _code;
    const unsigned char _vendor_specific;
    const unsigned char _mandatory;
    const unsigned char _protected_;
    const int _length;
    const int _vendor_id;
    const int _encoded_length;
    const std::vector<unsigned char> _payload;
    const OCTETSTRING _enc_avp;
    const LibDiameter__Types__Base__AVPs::AVP__Header _avp_header;
public:
  avp(const int p_code, const unsigned char p_vendor_specific, const unsigned char p_mandatory, const unsigned char p_protected_, const int p_length, const int p_vendor_id, const int p_encoded_length, const std::vector<unsigned char> p_payload);
  avp(const int p_code, const unsigned char p_vendor_specific, const unsigned char p_mandatory, const unsigned char p_protected_, const int p_length, const int p_vendor_id, const int p_encoded_length, const std::vector<unsigned char> p_payload, const OCTETSTRING& p_enc_avp);
  virtual ~avp() {};

  int get_code() const;

  int encode_auth_session_state(const LibDiameter__Types__Base__AVPs::Auth__Session__State__AVP& p_avp, std::unique_ptr<avp>& p_encoded_avp);

  int decode_session_id(LibDiameter__Types__Base__AVPs::Session__Id__AVP& p_avp) const;
  int decode_auth_session_state(LibDiameter__Types__Base__AVPs::Auth__Session__State__AVP& p_avp) const;
  int decode_origin_host(LibDiameter__Types__Base__AVPs::Origin__Host__AVP& p_avp) const;
  int decode_origin_realm(LibDiameter__Types__Base__AVPs::Origin__Realm__AVP& p_avp) const;
  int decode_destination_host(LibDiameter__Types__Base__AVPs::Destination__Host__AVP& p_avp) const;
  int decode_destination_realm(LibDiameter__Types__Base__AVPs::Destination__Realm__AVP& p_avp) const;

}; // End of class avp