#include "SgiPort.hh"
#include "loggers.hh"

namespace AtsImsIot__TestSystem {

  SgiPort::SgiPort(const char *par_port_name): SgiPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(nullptr), _time_key("SgiPort::outgoing_send") {
    // Nothing to do
  } // End of constructor

  SgiPort::~SgiPort() {
    loggers::get_instance().log(">>> SgiPort::~SgiPort");

    if (_layer != nullptr) {
      delete _layer;
    }
  } // End of destructor

  void SgiPort::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("SgiPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void SgiPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void SgiPort::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void SgiPort::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void SgiPort::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void SgiPort::Handle_Timeout(double time_since_last_call) {}*/

  void SgiPort::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> SgiPort::user_map: %s", system_port);
  } // End of user_map method

  void SgiPort::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> SgiPort::user_unmap: %s", system_port);

    // Reset layers
    if (_layer != nullptr) {
      delete _layer;
      _layer = nullptr;
    }
  } // End of user_unmap method

  void SgiPort::user_start()
  {
    loggers::get_instance().log(">>> SgiPort::user_start");

  } // End of user_start method

  void SgiPort::user_stop()
  {
    loggers::get_instance().log(">>> SgiPort::user_stop");

  } // End of user_stop method
  
}

