#pragma once

#include "AtsImsIot_TestSystem.hh"

#include "layer.hh"
#include "params.hh"

namespace AtsImsIot__TestSystem {

  class NaptrPort : public NaptrPort_BASE {
    params _cfg_params;
    params _layer_params;
    layer* _layer;
    std::string _time_key;
  public:
    NaptrPort(const char *par_port_name);
    ~NaptrPort();

    void set_parameter(const char *parameter_name, const char *parameter_value);
    
    void receiveMsg (const AtsImsIot__TypesAndValues::NAPTRmessage& p_ind, const params& p_params);

  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
       boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */

  protected:
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

  protected:
    virtual void outgoing_send(const AtsImsIot__TypesAndValues::NAPTRmessage& send_par);
  }; // End of class NaptrPort

}

