#pragma once

#include "LibSip_Interface.hh"

#include "layer.hh"
#include "params.hh"

namespace LibSip__SIPTypesAndValues {
  class REGISTER__Request;
}

namespace LibSip__Interface {

  class SipPort : public SipPort_BASE {
    params _cfg_params;
    params _layer_params;
    layer* _layer;
    std::string _time_key;
  public:
    SipPort(const char *par_port_name);
    ~SipPort();

    void set_parameter(const char *parameter_name, const char *parameter_value);
    
    void receiveMsg (const LibSip__SIPTypesAndValues::Request& p_ind, const params& p_params);
    void receiveMsg (const LibSip__SIPTypesAndValues::Response& p_ind, const params& p_params);

  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
       boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */

  protected:
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

  protected:
    virtual void outgoing_send(const LibSip__SIPTypesAndValues::Request& send_par, const Address4SIP *destination_address) { };
    void outgoing_send(const LibSip__SIPTypesAndValues::REGISTER__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::INVITE__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::OPTIONS__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::BYE__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::CANCEL__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::ACK__Request& send_par, const Address4SIP *destination_address);
    virtual void outgoing_send(const LibSip__SIPTypesAndValues::PRACK__Request& send_par, const Address4SIP *destination_address) { };
    void outgoing_send(const LibSip__SIPTypesAndValues::NOTIFY__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::SUBSCRIBE__Request& send_par, const Address4SIP *destination_address);
    virtual void outgoing_send(const LibSip__SIPTypesAndValues::PUBLISH__Request& send_par, const Address4SIP *destination_address) { };
    virtual void outgoing_send(const LibSip__SIPTypesAndValues::UPDATE__Request& send_par, const Address4SIP *destination_address) { };
    virtual void outgoing_send(const LibSip__SIPTypesAndValues::REFER__Request& send_par, const Address4SIP *destination_address) { };
    void outgoing_send(const LibSip__SIPTypesAndValues::MESSAGE__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::INFO__Request& send_par, const Address4SIP *destination_address);
    void outgoing_send(const LibSip__SIPTypesAndValues::Response& send_par, const Address4SIP *destination_address);
    virtual void outgoing_send(const CHARSTRING& send_par, const Address4SIP *destination_address) { };
  }; // End of class SipPort

}

