#pragma once

#include "LibIot_TestInterface.hh"

#include "layer.hh"
#include "params.hh"

namespace LibIot__TestInterface {

  class EquipmentAccessPort : public EquipmentAccessPort_BASE {
    params _cfg_params;
    params _layer_params;
    layer* _layer;
    std::string _time_key;
  public:
    EquipmentAccessPort(const char *par_port_name);
    ~EquipmentAccessPort();

    void set_parameter(const char *parameter_name, const char *parameter_value);
    
    void receiveMsg (const LibUpperTester::EquipmentOperationRsp& p_ind, const params& p_params);

  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
       boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */

  protected:
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

  protected:
    virtual void outgoing_send(const LibUpperTester::EquipmentOperationReq& send_par);
  }; // End of class EquipmentAccessPort

}

