#include "EquipmentAccessPort.hh"
#include "upper_tester_layer_factory.hh"
#include "loggers.hh"

namespace LibIot__TestInterface {

  EquipmentAccessPort::EquipmentAccessPort(const char *par_port_name): EquipmentAccessPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(nullptr), _time_key("EquipmentAccessPort::outgoing_send") {
    // Nothing to do
  } // End of constructor

  EquipmentAccessPort::~EquipmentAccessPort() {
    loggers::get_instance().log(">>> EquipmentAccessPort::~EquipmentAccessPort");

    if (_layer != nullptr) {
      delete _layer;
    }
  } // End of destructor

  void EquipmentAccessPort::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("EquipmentAccessPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void EquipmentAccessPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void EquipmentAccessPort::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void EquipmentAccessPort::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void EquipmentAccessPort::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void EquipmentAccessPort::Handle_Timeout(double time_since_last_call) {}*/

  void EquipmentAccessPort::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> EquipmentAccessPort::user_map: %s", system_port);
    // Build layer stack
    params::iterator it = _cfg_params.find(std::string("params"));
    if (it != _cfg_params.end()) {
      loggers::get_instance().log("EquipmentAccessPort::user_map: %s", it->second.c_str());
      // Setup parameters
      params::convert(_layer_params, it->second); // TODO This _layer_params seems to be useless
      // Create layer
      _layer = layer_stack_builder::get_instance()->create_layer_stack(it->second.c_str());
      if (static_cast<upper_tester_layer *>(_layer) == nullptr) {
        loggers::get_instance().error("EquipmentAccessPort::user_map: Invalid stack configuration: %s", it->second.c_str());
      }
      static_cast<upper_tester_layer *>(_layer)->add_upper_port(this);

    } else {
      loggers::get_instance().error("EquipmentAccessPort::user_map: No layers defined in configuration file");
    }
  } // End of user_map method

  void EquipmentAccessPort::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> EquipmentAccessPort::user_unmap: %s", system_port);

    // Reset layers
    if (_layer != nullptr) {
      delete _layer;
      _layer = nullptr;
    }
  } // End of user_unmap method

  void EquipmentAccessPort::user_start()
  {
    loggers::get_instance().log(">>> EquipmentAccessPort::user_start");

  } // End of user_start method

  void EquipmentAccessPort::user_stop()
  {
    loggers::get_instance().log(">>> EquipmentAccessPort::user_stop");

  } // End of user_stop method

  void EquipmentAccessPort::receiveMsg (const LibUpperTester::EquipmentOperationRsp& p_ind, const params& p_params) {
    loggers::get_instance().log_msg(">>> EquipmentAccessPort::receive_msg: ", p_ind);
    
    // Sanity check
    if (!p_ind.is_bound()) {
      return;
    }

      incoming_message(p_ind);
    
  } // End of method receiveMsg
  
  void EquipmentAccessPort::outgoing_send(const LibUpperTester::EquipmentOperationReq& send_par)
  {
    loggers::get_instance().log_msg(">>> EquipmentAccessPort::outgoing_send: ", send_par);

    float duration;
    loggers::get_instance().set_start_time(_time_key);
    params params;
    static_cast<upper_tester_layer*>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  } // End of outgoing_send
  
}

