#pragma once

#include "LibIot_TestInterface.hh"

#include "params.hh"

namespace LibIot__TestInterface {

  class AdapterConfigPort : public AdapterConfigPort_BASE {
    params _params;

  public:
    AdapterConfigPort(const char *par_port_name = NULL);
    ~AdapterConfigPort();

    void set_parameter(const char *parameter_name, const char *parameter_value);

  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
            boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */
  protected:
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

    void outgoing_send(const LibIot__TypesAndValues::GeneralConfigurationReq &send_par);

    void outgoing_send(const LibIot__TypesAndValues::SetFilterReq &send_par);

    void outgoing_send(const LibIot__TypesAndValues::StartTrafficCaptureReq &send_par);

    void outgoing_send(const LibIot__TypesAndValues::StopTrafficCaptureReq &send_par);
  };

} // namespace LibIot__TestInterface

