#include "ImsMonitorDiameterPort.hh"
#include "diameter_layer_factory.hh"
#include "loggers.hh"

namespace AtsImsIot__TestSystem {

  ImsMonitorDiameterPort::ImsMonitorDiameterPort(const char *par_port_name): ImsMonitorDiameterPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(nullptr), _time_key("ImsMonitorDiameterPort::outgoing_send") {
    // Nothing to do
  } // End of constructor

  ImsMonitorDiameterPort::~ImsMonitorDiameterPort() {
    loggers::get_instance().log(">>> ImsMonitorDiameterPort::~ImsMonitorDiameterPort");

    if (_layer != nullptr) {
      delete _layer;
    }
  } // End of destructor

  void ImsMonitorDiameterPort::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("ImsMonitorDiameterPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void ImsMonitorDiameterPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void ImsMonitorDiameterPort::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void ImsMonitorDiameterPort::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void ImsMonitorDiameterPort::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void ImsMonitorDiameterPort::Handle_Timeout(double time_since_last_call) {}*/

  void ImsMonitorDiameterPort::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> ImsMonitorDiameterPort::user_map: %s", system_port);
    // Build layer stack
    /*params::iterator it = _cfg_params.find(std::string("params"));
    if (it != _cfg_params.end()) {
      loggers::get_instance().log("ImsMonitorDiameterPort::user_map: %s", it->second.c_str());
      // Setup parameters
      params::convert(_layer_params, it->second); // TODO This _layer_params seems to be useless
      // Create layer
      _layer = layer_stack_builder::get_instance()->create_layer_stack(it->second.c_str());
      if (static_cast<diameter_layer *>(_layer) == nullptr) {
        loggers::get_instance().error("ImsMonitorDiameterPort::user_map: Invalid stack configuration: %s", it->second.c_str());
      }
      static_cast<diameter_layer *>(_layer)->add_upper_port(this);

    } else {*/
      loggers::get_instance().error("ImsMonitorDiameterPort::user_map: No layers defined in configuration file");
    /*}*/
  } // End of user_map method

  void ImsMonitorDiameterPort::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> ImsMonitorDiameterPort::user_unmap: %s", system_port);

    // Reset layers
    if (_layer != nullptr) {
      delete _layer;
      _layer = nullptr;
    }
  } // End of user_unmap method

  void ImsMonitorDiameterPort::user_start()
  {
    loggers::get_instance().log(">>> ImsMonitorDiameterPort::user_start");

  } // End of user_start method

  void ImsMonitorDiameterPort::user_stop()
  {
    loggers::get_instance().log(">>> ImsMonitorDiameterPort::user_stop");

  } // End of user_stop method

  void ImsMonitorDiameterPort::receiveMsg (const LibDiameter__TypesAndValues::DIAMETER__MSG& p_ind, const params& p_params) {
    loggers::get_instance().log_msg(">>> ImsMonitorDiameterPort::receive_msg: ", p_ind);
    
    // Sanity check
    if (!p_ind.is_bound()) {
      return;
    }

      incoming_message(p_ind);
    
  } // End of method receiveMsg

}

