#include "DataPort.hh"
#include "loggers.hh"

namespace AtsImsIot__TestSystem {

  DataPort::DataPort(const char *par_port_name): DataPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(nullptr), _time_key("DataPort::outgoing_send") {
    // Nothing to do
  } // End of constructor

  DataPort::~DataPort() {
    loggers::get_instance().log(">>> DataPort::~DataPort");

    if (_layer != nullptr) {
      delete _layer;
    }
  } // End of destructor

  void DataPort::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("DataPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void DataPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void DataPort::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void DataPort::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void DataPort::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void DataPort::Handle_Timeout(double time_since_last_call) {}*/

  void DataPort::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> DataPort::user_map: %s", system_port);
  } // End of user_map method

  void DataPort::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> DataPort::user_unmap: %s", system_port);

    // Reset layers
    if (_layer != nullptr) {
      delete _layer;
      _layer = nullptr;
    }
  } // End of user_unmap method

  void DataPort::user_start()
  {
    loggers::get_instance().log(">>> DataPort::user_start");

  } // End of user_start method

  void DataPort::user_stop()
  {
    loggers::get_instance().log(">>> DataPort::user_stop");

  } // End of user_stop method
  
}

