
#include "LibDiameter_EncdecDeclarations.hh"

#include "loggers.hh"

#include "diameter_uar_codec.hh"

namespace LibDiameter__EncdecDeclarations {

  BITSTRING fx__enc__CER__MSG(const LibDiameter__TypesAndValues::CER__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os); 
  }
  
  INTEGER fx__dec__CER__MSG(BITSTRING&, LibDiameter__TypesAndValues::CER__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__CEA__MSG(const LibDiameter__TypesAndValues::CEA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__CEA__MSG(BITSTRING&, LibDiameter__TypesAndValues::CEA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__RAR__MSG(const LibDiameter__TypesAndValues::RAR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__RAR__MSG(BITSTRING&, LibDiameter__TypesAndValues::RAR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__RAA__MSG(const LibDiameter__TypesAndValues::RAA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__RAA__MSG(BITSTRING&, LibDiameter__TypesAndValues::RAA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__ACR__MSG(const LibDiameter__TypesAndValues::ACR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__ACR__MSG(BITSTRING&, LibDiameter__TypesAndValues::ACR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__ACA__MSG(const LibDiameter__TypesAndValues::ACA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__ACA__MSG(BITSTRING&, LibDiameter__TypesAndValues::ACA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__ASR__MSG(const LibDiameter__TypesAndValues::ASR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__ASR__MSG(BITSTRING&, LibDiameter__TypesAndValues::ASR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__ASA__MSG(const LibDiameter__TypesAndValues::ASA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__ASA__MSG(BITSTRING&, LibDiameter__TypesAndValues::ASA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__STR__MSG(const LibDiameter__TypesAndValues::STR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__STR__MSG(BITSTRING&, LibDiameter__TypesAndValues::STR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__STA__MSG(const LibDiameter__TypesAndValues::STA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__STA__MSG(BITSTRING&, LibDiameter__TypesAndValues::STA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__DWR__MSG(const LibDiameter__TypesAndValues::DWR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__DWR__MSG(BITSTRING&, LibDiameter__TypesAndValues::DWR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__DWA__MSG(const LibDiameter__TypesAndValues::DWA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__DWA__MSG(BITSTRING&, LibDiameter__TypesAndValues::DWA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__DPR__MSG(const LibDiameter__TypesAndValues::DPR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__DPR__MSG(BITSTRING&, LibDiameter__TypesAndValues::DPR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__DPA__MSG(const LibDiameter__TypesAndValues::DPA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__DPA__MSG(BITSTRING&, LibDiameter__TypesAndValues::DPA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__UAR__MSG(const LibDiameter__TypesAndValues::UAR__MSG& p) {
    loggers::get_instance().log_msg(">>> fx__enc__UAR__MSG: ", p);

    float duration;
    std::string tag("fx__enc__UAR__MSG");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    diameter_uar_codec codec;
    if (codec.encode(p, os) == -1) {
      loggers::get_instance().warning("fx__enc__UAR__MSG: -1 result code was returned");
      return int2bit(0, 1);
    }
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__UAR__MSG(BITSTRING& pdu, LibDiameter__TypesAndValues::UAR__MSG& p) {

    OCTETSTRING os = bit2oct(pdu);
    diameter_uar_codec codec;
    codec.decode(os, p);

    return INTEGER(0);
 }

  BITSTRING fx__enc__UAA__MSG(const LibDiameter__TypesAndValues::UAA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__UAR__MSG: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__UAR__MSG");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__UAA__MSG(BITSTRING&, LibDiameter__TypesAndValues::UAA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__SAR__MSG(const LibDiameter__TypesAndValues::SAR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__SAR__MSG(BITSTRING&, LibDiameter__TypesAndValues::SAR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__SAA__MSG(const LibDiameter__TypesAndValues::SAA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__SAA__MSG(BITSTRING&, LibDiameter__TypesAndValues::SAA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__LIR__MSG(const LibDiameter__TypesAndValues::LIR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__LIR__MSG(BITSTRING&, LibDiameter__TypesAndValues::LIR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__LIA__MSG(const LibDiameter__TypesAndValues::LIA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__LIA__MSG(BITSTRING&, LibDiameter__TypesAndValues::LIA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__MAR__MSG(const LibDiameter__TypesAndValues::MAR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__MAR__MSG(BITSTRING&, LibDiameter__TypesAndValues::MAR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__MAA__MSG(const LibDiameter__TypesAndValues::MAA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__MAA__MSG(BITSTRING&, LibDiameter__TypesAndValues::MAA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__RTR__MSG(const LibDiameter__TypesAndValues::RTR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__RTR__MSG(BITSTRING&, LibDiameter__TypesAndValues::RTR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__RTA__MSG(const LibDiameter__TypesAndValues::RTA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__RTA__MSG(BITSTRING&, LibDiameter__TypesAndValues::RTA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PPR__MSG(const LibDiameter__TypesAndValues::PPR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PPR__MSG(BITSTRING&, LibDiameter__TypesAndValues::PPR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PPA__MSG(const LibDiameter__TypesAndValues::PPA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PPA__MSG(BITSTRING&, LibDiameter__TypesAndValues::PPA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__UDR__MSG(const LibDiameter__TypesAndValues::UDR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__UDR__MSG(BITSTRING&, LibDiameter__TypesAndValues::UDR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__UDA__MSG(const LibDiameter__TypesAndValues::UDA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__UDA__MSG(BITSTRING&, LibDiameter__TypesAndValues::UDA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PUR__MSG(const LibDiameter__TypesAndValues::PUR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PUR__MSG(BITSTRING&, LibDiameter__TypesAndValues::PUR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PUA__MSG(const LibDiameter__TypesAndValues::PUA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PUA__MSG(BITSTRING&, LibDiameter__TypesAndValues::PUA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__SNR__MSG(const LibDiameter__TypesAndValues::SNR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__SNR__MSG(BITSTRING&, LibDiameter__TypesAndValues::SNR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__SNA__MSG(const LibDiameter__TypesAndValues::SNA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__SNA__MSG(BITSTRING&, LibDiameter__TypesAndValues::SNA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PNR__MSG(const LibDiameter__TypesAndValues::PNR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PNR__MSG(BITSTRING&, LibDiameter__TypesAndValues::PNR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PNA__MSG(const LibDiameter__TypesAndValues::PNA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PNA__MSG(BITSTRING&, LibDiameter__TypesAndValues::PNA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__CCR__MSG(const LibDiameter__TypesAndValues::CCR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__CCR__MSG(BITSTRING&, LibDiameter__TypesAndValues::CCR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__CCA__MSG(const LibDiameter__TypesAndValues::CCA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__CCA__MSG(BITSTRING&, LibDiameter__TypesAndValues::CCA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__AAR__MSG(const LibDiameter__TypesAndValues::AAR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__AAR__MSG(BITSTRING&, LibDiameter__TypesAndValues::AAR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__AAA__MSG(const LibDiameter__TypesAndValues::AAA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__AAA__MSG(BITSTRING&, LibDiameter__TypesAndValues::AAA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__ULR__MSG(const LibDiameter__TypesAndValues::ULR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__ULR__MSG(BITSTRING&, LibDiameter__TypesAndValues::ULR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__ULA__MSG(const LibDiameter__TypesAndValues::ULA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__ULA__MSG(BITSTRING&, LibDiameter__TypesAndValues::ULA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__AIR__MSG(const LibDiameter__TypesAndValues::AIR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__AIR__MSG(BITSTRING&, LibDiameter__TypesAndValues::AIR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__AIA__MSG(const LibDiameter__TypesAndValues::AIA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__AIA__MSG(BITSTRING&, LibDiameter__TypesAndValues::AIA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__CLR__MSG(const LibDiameter__TypesAndValues::CLR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__CLR__MSG(BITSTRING&, LibDiameter__TypesAndValues::CLR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__CLA__MSG(const LibDiameter__TypesAndValues::CLA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__CLA__MSG(BITSTRING&, LibDiameter__TypesAndValues::CLA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__IDR__MSG(const LibDiameter__TypesAndValues::IDR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__IDR__MSG(BITSTRING&, LibDiameter__TypesAndValues::IDR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__IDA__MSG(const LibDiameter__TypesAndValues::IDA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__IDA__MSG(BITSTRING&, LibDiameter__TypesAndValues::IDA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__DSR__MSG(const LibDiameter__TypesAndValues::DSR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__DSR__MSG(BITSTRING&, LibDiameter__TypesAndValues::DSR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__DSA__MSG(const LibDiameter__TypesAndValues::DSA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__DSA__MSG(BITSTRING&, LibDiameter__TypesAndValues::DSA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__RSR__MSG(const LibDiameter__TypesAndValues::RSR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__RSR__MSG(BITSTRING&, LibDiameter__TypesAndValues::RSR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__RSA__MSG(const LibDiameter__TypesAndValues::RSA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__RSA__MSG(BITSTRING&, LibDiameter__TypesAndValues::RSA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__NOR__MSG(const LibDiameter__TypesAndValues::NOR__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__NOR__MSG(BITSTRING&, LibDiameter__TypesAndValues::NOR__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__NOA__MSG(const LibDiameter__TypesAndValues::NOA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__NOA__MSG(BITSTRING&, LibDiameter__TypesAndValues::NOA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PUER__MSG(const LibDiameter__TypesAndValues::PUER__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PUER__MSG(BITSTRING&, LibDiameter__TypesAndValues::PUER__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__PUEA__MSG(const LibDiameter__TypesAndValues::PUEA__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__PUEA__MSG(BITSTRING&, LibDiameter__TypesAndValues::PUEA__MSG& p) { return INTEGER(0); }

  BITSTRING fx__enc__UNKNOWN__MSG(const LibDiameter__TypesAndValues::UNKNOWN__MSG& p) {
    loggers::get_instance().log_msg(">>>   BITSTRING fx__enc__Request: ", p);

    float duration;
    std::string tag("  BITSTRING fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    // TODO
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  INTEGER fx__dec__UNKNOWN__MSG(BITSTRING&, LibDiameter__TypesAndValues::UNKNOWN__MSG& p) { return INTEGER(0); }

} // End of namespace LibDiameter__EncdecDeclarations
