# Voice and Video over LTE/Emergency VoLTE Interoperability Tests

## Introduction
This repositories contains the test specifications and test adapter code
for interoprability tests to ETSI TS 1037 950-2 (Core Network and Interoperability Testing (INT); Network Interoperability Test Description for emergency services over VoLTE; (3GPP™ Release 15); Part 2: Test Descriptions).

## Contact information
Email at cti_support at etsi dot org

## License
The content of this repository and the files contained are released under the BSD-3-Clause License.
See the attached LICENSE file or visit
https://forge.etsi.org/legal-matters

## Standard links
- ETSI TS 103 795-1: "Core Network and Interoperability Testing (INT); Network Interoperability Test Description for emergency services over VoLTE; (3GPP™ Release 15); Part 1: Test Purposes (TP)"
- ETSI TS 124 229: "Digital cellular telecommunications system (Phase 2+) (GSM); Universal Mobile Telecommunications System (UMTS); LTE; 5G; IP multimedia call control protocol based on Session Initiation Protocol (SIP) and Session Description Protocol (SDP); Stage 3 (3GPP TS 24.229 Release 15)"
- ETSI TS 129 165: "Digital cellular telecommunications system (Phase 2+) (GSM); Universal Mobile Telecommunications System (UMTS); LTE; 5G; Inter-IMS Network to Network Interface (NNI) (3GPP TS 29.165 Release 15)"
- ETSI TS 129 228: "Digital cellular telecommunications system (Phase 2+) (GSM); Universal Mobile Telecommunications System (UMTS); LTE; IP Multimedia (IM) Subsystem Cx and Dx Interfaces; Signalling flows and message contents (3GPP TS 29.228 Release 15)".
- ETSI TS 129 229: "Digital cellular telecommunications system (Phase 2+) (GSM); Universal Mobile Telecommunications System (UMTS); LTE; Cx and Dx interfaces based on the Diameter protocol; Protocol details (3GPP TS 29.229 Release 15)"

## RFC links
- 

NOTE All draft can be found in the 'IETF XML Registry', accessible [here](https://www.iana.org/assignments/xml-registry/xml-registry.xhtml)

# Installation

The ETSI Emergency VoLTE Interoperability Tests project builds and tests regularly on the following platforms:

  - Linux (Ubuntu)

Note: The [OpenSSL](https://www.openssl.org) version > 1.1.x is also required.

## How to do it?

They are two different methods:
- Using [Vagrant](https://www.vagrantup.com/)
- Using [Docker](https://www.docker.com/)

How to choose one of these methods is depending of your host system.

NOTE: In all case, if you want to setup an continuous integration process (e.g. Jenkins), Docker is the best choice. 


### The host system is Windows
The both methods require a virtual machine. You can use either VirtualBox or WMware.
In this case, the easiest way is to use Vagrant.


### The host system is Linux
Vagrant requires a virtual machine. You can use either VirtualBox or WMware.
Docker does not need a virtual machine, so it is the more efficant way.


## Using TITAN compiler on a Docker image

In this configuration, TITAN compiler is located on a Docker image and the sources and the outputs are located on the host.

Pre-requisites on your host machine:
- Install Docker

Procedure on the host machine:
- Open a Terminal
- Clone the ETSI Emergency VoLTE Interoperability Test System
- From the ETSI Emergency VoLTE Interoperability Test System root directory, build the Docker image executing the following commands:

```sh
$ cd ./virtualization/docker
$ docker build --no-cache --tag alpine-emergency-iop -f Dockerfile --force-rm .
$ docker images
```

To build the Emergency VoLTE Interoperability Test Suite, execute the following command:

```sh
$ ./docker-run.sh build
```

Possble other options are 'clean' to remove all the build outputs or 'rebuild' to force a build of the Test Suite after a 'clean'.

To retrieve the list of the available test cases, execute the following command:

```sh
$ ./docker-run.sh list
```

Before to execute the Emergency VoLTE Interoperability Test Suite, prepare, edit and update the configuration file:

```sh
$ ln -sf ../../etc/AtsXxx/AtsXxx_yyy.cf_ ../../etc/AtsXxx/AtsXxx.cfg
$ vi ../../etc/AtsXxx/AtsXxx.cfg # To update it
```

To execute the Emergency VoLTE Interoperability Test Suite, execute the following command:

```sh
$ ./docker-run.sh run
```

<b>Notes</b>:
- The Emergency VoLTE Interoperability Test System is listening on port 443
- Updating the file etc/AtsXxx/AtsXxx.cfg is about (e.g. etc/AtsBCF/AtsBCF.cfg):
. Selecting the test(s) to be executed
. Updating value of PICs and PIXITs
. Updating HTTP port setting

## Using development Docker image

In this configuration, the TITAN compiler, the sources and the outputs are located on the Docker image.

Pre-requisites on your host machine:
- Install Docker

Procedure for a Windows host machine:
- On your host machine, open a the Docker Quickstart Terminal
- On your host machine, clone the ETSI EEmergency Communications project. NOTE that only Docker folder and .jenkins.sh script file are required
- From the ETSI Emergency VoLTE Interoperability Tests project root directory, execute the following commands:

```sh
$ ./.jenkins.sh
...
```

NOTE The creation and the installations will take some time to achieve
- Start the container

```sh
$ ./docker/run-container.sh
...
```

- Switch to the next clause (Usage)


## Using Vagrant

Pre-requisites on your host machine:
- Install [Virtualbox](https://www.virtualbox.org/manual/ch01.html)
- Install [Vagrant](https://www.vagrantup.com/intro/getting-started/)
- Install Vagrant plugin vagrant-vbguest
- Credentials to access [ETSI forge](https://forge.etsi.org/gitlab/users/sign_in)
    - Set the environment variable USERNAME to your ETSI EOL account user name
    - Set the environment variable PASSWORD to your ETSI EOL account password

Procedure:
- On your host machine, open a command line session (PuTTY, DOS window...)
- From the ETSI Emergency VoLTE Interoperability Tests project, clone the Vagrant folder
- In the file Vagrantfile, modify the tag config.vm.provision replacing <username> & <password> strings by your ETSI credentials
- In the Vagrant folder, execute the following commands:

```sh
$ vagrant up --provider virtualbox --provision
...
```

NOTE The creation and the installations will take some time to achieve
- Stop vagrant virtual machine

```sh
$ vagrant halt
...
```

- Update the file 'Vagrantfile' to match with your networks configuration
- Re-start the vagrant virtual machine and log to to the machine

```sh
$ vagrant up
...
$ vagrant ssh
```

- Switch to the next clause (Usage)

NOTE The user password is vagrant.


## From scratch

Pre-requisites:
- Install Virtualbox

Procedure:
- Install a new Linux Virtual machine (Mint, Debian...)
- Update your system with the latest version of kernel and security packages
- Install the following packages (According to the Linux chosen, the package naming can be different)
    autoconf
    bison
    build-essential
    cmake
    curl
    dos2unix
    doxygen
    emacs
    expect
    flex
    g++:latest
    gcc:latest
    graphviz
    gdb 
    git-core
    gnutls-bin
    libglib2.0-dev
    libpcap-dev
    libgcrypt-dev
    libncurses5-dev
    libssl-dev
    libtool-bin
    libtool
    libwireshark-dev
    libxml2-dev
    lsof
    ntp
    pkg-config
    qt5-default
    qtmultimedia5-dev
    libqt5svg5-dev
    subversion
    sudo
    sshpass
    tcpdump
    texlive-font-utils
    tshark
    valgrind
    vim
    vsftpd
    xutils-dev 
    tree
    tzdata
    unzip
    wget
    xsltproc
- In your home directory, create the following folders: 
    - $HOME/frameworks, 
    - $HOME/dev
    - $HOME/lib

- In $HOME/frameworks, build the following package:
    - Eclipse IDE for C/C++ Developers, according the procedure specified [here](https://www.eclipse.org/cdt/)
    - TITAN, according the procedure specified [here](https://github.com/eclipse/titan.core)
    - Import the TITAN plugin into your Eclipse IDE, according the procedure specified [here](https://github.com/eclipse/titan.core)

- Install LibOSIP framework
```sh
$ cd ${HOME}/frameworks
$ git clone https://git.savannah.gnu.org/git/osip.git ./osip
$ cd osip
$ ./autogen.sh
$ ./configure --prefix=/home/etsi
$ make && make install
```

- Clone the ETSI Emergency VoLTE Interoperability Tests project into $HOME/dev folder

```sh
$ git clone --recurse-submodules --branch devel https://forge.etsi.org/rep/int/vxlte/emergency-iop.git
```

- Apply patches
```sh
$ cd /home/etsi/dev/emergency-iop/
$ ./install.sh
```

- Update your default environment with the content of the script $HOME/dev/emergency-iop/scripts/devenv.bash.ubuntu

- Switch to the next clause (Usage)


# Generate certificates for TLS and Emergency VoLTE Interoperability security support 

This clause describes how generate certificates desrived from Let's encrypt certificate. These certificate will be used for TS mutual authentication.
<b>NOTE:</b>
- Certficates shall be renewed every 3 months
- The port 80 shall be vailable for standalone validation

Pre-requisites:
- You need to install python and [certbot](https://manpages.ubuntu.com/manpages/impish/en/man1/certbot.1.html).

To generate certifcates, execute the following command:

```sh
$ export REQUESTS_CA_BUNDLE=$(dirname `python -c "import certifi; print(certifi.where())"`)
$ mkdir -p $HOME/var/ssl
$ sudo certbot certonly --debug --emergency-iop-tls-cert --config-dir $HOME/var/ssl --work-dir $HOME/var/ssl  --logs-dir $HOME/var/ssl --standalone --agree-tos --email <your email> -d <your domain> -w $HOME/var/ssl/
```

<b>NOTE:</b> For testing certificate generation and renewal, use the certbot's --dry-run option.


# Usage

This clause describes how to compile and execute an Abstract Test Suite.
The procedures below illustrate how to run the CAM test suite. The same procedures will apply for any other ETSI Emergency Communications test suite.


Pre-requisites:
- Your machine is installed following one of the installation method describes in the previous clause
- Your are logged as 'etsi' or 'vagrant' user

Procedure in TITAN command line:
- Open several SSH session (PuTTY...)
- Change to the directory ~/dev/emergency-iop/
- Build the test suite you want to exectue (e.g. LIS test suite)

```sh
$ cd ~/dev/emergency-iop/
$ export ATS=AtsImsIot
$ make
...
```

- Edit the file ../etc/AtsImsIot/AtsImsIot.cfg
- Update the following fields:
    - system.httpPort.params
    - system.SIPP.params
    - system.DIAMETER.params

- To run the test suitem, execute the following command:

```sh
$ cd ~/dev/emergency-iop/scripts
$ ./run-all.bash
...
```

- The log files are located in ../logs/AtsImsIot folder. You can edit them using any editor or using the Eclipse TITAN log plugins


# How to Report a Bug

The ETSI Emergency VoLTE Interoperability Tests project is under constant development, so it is possible that you will
encounter a bug while using it. Please report bugs at cti_support at etsi dot org.
