/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.legacy;

import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.nwdiag.legacy.Footprint;
import net.sourceforge.plantuml.nwdiag.legacy.GridTextBlockSimple;
import net.sourceforge.plantuml.nwdiag.legacy.LinkedElement;
import net.sourceforge.plantuml.nwdiag.legacy.NetworkLegacy;
import net.sourceforge.plantuml.nwdiag.legacy.NwGroupLegacy;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GridTextBlockDecorated
extends GridTextBlockSimple {
    public static final int NETWORK_THIN = 5;
    private final List<NwGroupLegacy> groups;
    private final List<NetworkLegacy> networks;

    public GridTextBlockDecorated(int lines, int cols, List<NwGroupLegacy> groups, List<NetworkLegacy> networks, ISkinParam skinparam) {
        super(lines, cols, skinparam);
        this.groups = groups;
        this.networks = networks;
    }

    @Override
    protected void drawGrid(UGraphic ug) {
        for (NwGroupLegacy group : this.groups) {
            this.drawGroups(ug, group, this.skinparam);
        }
        this.drawNetworkTube(ug);
        this.drawLinks(ug);
    }

    private void drawLinks(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            double lineHeight = this.lineHeight(stringBounder, i);
            double x = 0.0;
            for (int j = 0; j < this.data.getNbCols(); ++j) {
                double colWidth = this.colWidth(stringBounder, j);
                if (this.data.get(i, j) != null) {
                    this.data.get(i, j).drawLinks(ug, x, colWidth, lineHeight);
                }
                x += colWidth;
            }
        }
    }

    private void drawGroups(UGraphic ug, NwGroupLegacy group, ISkinParam skinParam) {
        StringBounder stringBounder = ug.getStringBounder();
        MinMax size = null;
        double y = 0.0;
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            double lineHeight = this.lineHeight(stringBounder, i);
            double x = 0.0;
            for (int j = 0; j < this.data.getNbCols(); ++j) {
                double colWidth = this.colWidth(stringBounder, j);
                LinkedElement element = this.data.get(i, j);
                if (element != null && group.matches(element)) {
                    MinMax minMax = element.getMinMax(stringBounder, colWidth, lineHeight).translate(new UTranslate(x, y));
                    size = size == null ? minMax : size.addMinMax(minMax);
                }
                x += colWidth;
            }
            y += lineHeight;
        }
        if (size != null) {
            group.drawGroup(ug, size, skinParam);
        }
    }

    private boolean isThereALink(int j, NetworkLegacy network) {
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            LinkedElement element = this.data.get(i, j);
            if (element == null || !element.isLinkedTo(network)) continue;
            return true;
        }
        return false;
    }

    private void drawNetworkTube(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double y = 0.0;
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            NetworkLegacy network = this.getNetwork(i);
            this.computeMixMax(this.data.getLine(i), stringBounder, network);
            URectangle rect = new URectangle(network.getXmax() - network.getXmin(), 5.0);
            rect.setDeltaShadow(1.0);
            UGraphic ug2 = ug.apply(new UTranslate(network.getXmin(), y));
            if (network != null && network.getColor() != null) {
                ug2 = ug2.apply(network.getColor().bg());
            }
            if (network != null) {
                network.setY(y);
            }
            if (network.isVisible()) {
                ug2.draw(rect);
            }
            y += this.lineHeight(stringBounder, i);
        }
    }

    private void computeMixMax(LinkedElement[] line, StringBounder stringBounder, NetworkLegacy network) {
        double x = 0.0;
        double xmin = network.isFullWidth() ? 0.0 : -1.0;
        double xmax = 0.0;
        for (int j = 0; j < line.length; ++j) {
            boolean hline = this.isThereALink(j, network);
            if (hline && xmin < 0.0) {
                xmin = x;
            }
            x += this.colWidth(stringBounder, j);
            if (!hline && !network.isFullWidth()) continue;
            xmax = x;
        }
        network.setMinMax(xmin, xmax);
    }

    private NetworkLegacy getNetwork(int i) {
        return this.networks.get(i);
    }

    public void checkGroups() {
        for (int i = 0; i < this.groups.size(); ++i) {
            for (int j = i + 1; j < this.groups.size(); ++j) {
                Footprint footprint2;
                Footprint footprint1;
                Footprint inter;
                NwGroupLegacy group1 = this.groups.get(i);
                NwGroupLegacy group2 = this.groups.get(j);
                if (group1.size() == 0 || group2.size() == 0 || group1.getNetwork() != group2.getNetwork() || (inter = (footprint1 = this.getFootprint(group1)).intersection(footprint2 = this.getFootprint(group2))) == null) continue;
                this.data.swapCols(inter.getMin(), inter.getMax());
                return;
            }
        }
    }
}

