/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.mindmap.Finger;
import net.sourceforge.plantuml.mindmap.FingerImpl;
import net.sourceforge.plantuml.mindmap.Idea;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class MindMapDiagram
extends UmlDiagram {
    private Branch left = new Branch();
    private Branch right = new Branch();
    private Direction defaultDirection = Direction.RIGHT;
    private String first;

    public final void setDefaultDirection(Direction defaultDirection) {
        this.defaultDirection = defaultDirection;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("MindMap");
    }

    public MindMapDiagram(UmlSource source) {
        super(source, UmlDiagramType.MINDMAP);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                MindMapDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                MindMapDiagram.this.computeFinger();
                double y1 = MindMapDiagram.this.right.finger == null ? 0.0 : MindMapDiagram.this.right.finger.getFullThickness(stringBounder) / 2.0;
                double y2 = MindMapDiagram.this.left.finger == null ? 0.0 : MindMapDiagram.this.left.finger.getFullThickness(stringBounder) / 2.0;
                double y = Math.max(y1, y2);
                double x = MindMapDiagram.this.left.finger == null ? 0.0 : MindMapDiagram.this.left.finger.getFullElongation(stringBounder);
                double width = MindMapDiagram.this.right.finger == null ? x : x + MindMapDiagram.this.right.finger.getFullElongation(stringBounder);
                double height = y + Math.max(MindMapDiagram.this.left.finger == null ? 0.0 : MindMapDiagram.this.left.finger.getFullThickness(stringBounder) / 2.0, MindMapDiagram.this.right.finger == null ? 0.0 : MindMapDiagram.this.right.finger.getFullThickness(stringBounder) / 2.0);
                return new Dimension2DDouble(width, height);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        double x;
        if (this.left.root == null && this.right.root == null) {
            return;
        }
        this.computeFinger();
        StringBounder stringBounder = ug.getStringBounder();
        double y1 = this.right.finger == null ? 0.0 : this.right.finger.getFullThickness(stringBounder) / 2.0;
        double y2 = this.left.finger == null ? 0.0 : this.left.finger.getFullThickness(stringBounder) / 2.0;
        double y = Math.max(y1, y2);
        double d = x = this.left.finger == null ? 0.0 : this.left.finger.getFullElongation(stringBounder) + ((FingerImpl)this.left.finger).getX12();
        if (this.right.finger != null) {
            this.right.finger.drawU(ug.apply(new UTranslate(x, y)));
        }
        if (this.left.finger != null) {
            this.left.finger.drawU(ug.apply(new UTranslate(x, y)));
        }
    }

    private void computeFinger() {
        if (this.left.finger == null && this.right.finger == null) {
            if (this.left.root.hasChildren()) {
                this.left.finger = FingerImpl.build(this.left.root, this.getSkinParam(), Direction.LEFT);
            }
            if (this.left.finger == null || this.right.root.hasChildren()) {
                this.right.finger = FingerImpl.build(this.right.root, this.getSkinParam(), Direction.RIGHT);
            }
            if (this.left.finger != null && this.right.finger != null) {
                this.left.finger.doNotDrawFirstPhalanx();
            }
        }
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, Display label, IdeaShape shape) {
        return this.addIdea(backColor, level, label, shape, this.defaultDirection);
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, Display label, IdeaShape shape, Direction direction) {
        String stereotype = label.getEndingStereotype();
        if (stereotype != null) {
            label = label.removeEndingStereotype();
        }
        return this.addIdeaInternal(stereotype, backColor, level, label, shape, direction);
    }

    public CommandExecutionResult addIdea(String stereotype, HColor backColor, int level, Display label, IdeaShape shape) {
        return this.addIdeaInternal(stereotype, backColor, level, label, shape, this.defaultDirection);
    }

    private CommandExecutionResult addIdeaInternal(String stereotype, HColor backColor, int level, Display label, IdeaShape shape, Direction direction) {
        try {
            if (this.left.root == null && this.right.root == null) {
                level = 0;
            }
            if (level == 0) {
                if (this.right.root != null) {
                    return CommandExecutionResult.error("I don't know how to draw multi-root diagram. You should suggest an image so that the PlantUML team implements it :-)");
                }
                this.right.initRoot(this.getSkinParam().getCurrentStyleBuilder(), backColor, label, shape, stereotype);
                this.left.initRoot(this.getSkinParam().getCurrentStyleBuilder(), backColor, label, shape, stereotype);
                return CommandExecutionResult.ok();
            }
            if (direction == Direction.LEFT) {
                return this.left.add(this.getSkinParam().getCurrentStyleBuilder(), backColor, level, label, shape, stereotype);
            }
            return this.right.add(this.getSkinParam().getCurrentStyleBuilder(), backColor, level, label, shape, stereotype);
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }

    public int getSmartLevel(String type) {
        if (this.first == null) {
            this.first = type;
        }
        if (type.endsWith("**")) {
            type = type.replace('\t', ' ').trim();
        }
        if (!(type = type.replace('\t', ' ')).contains(" ")) {
            return type.length() - 1;
        }
        if (type.endsWith(this.first)) {
            return type.length() - this.first.length();
        }
        if (type.trim().length() == 1) {
            return type.length() - 1;
        }
        if (type.startsWith(this.first)) {
            return type.length() - this.first.length();
        }
        throw new UnsupportedOperationException("type=<" + type + ">[" + this.first + "]");
    }

    static class Branch {
        private Idea root;
        private Idea last;
        private Finger finger;

        Branch() {
        }

        private void initRoot(StyleBuilder styleBuilder, HColor backColor, Display label, IdeaShape shape, String stereotype) {
            this.last = this.root = new Idea(styleBuilder, backColor, label, shape, stereotype);
        }

        private Idea getParentOfLast(int nb) {
            Idea result = this.last;
            for (int i = 0; i < nb; ++i) {
                result = result.getParent();
            }
            return result;
        }

        private CommandExecutionResult add(StyleBuilder styleBuilder, HColor backColor, int level, Display label, IdeaShape shape, String stereotype) {
            if (this.last == null) {
                return CommandExecutionResult.error("Check your indentation ?");
            }
            if (level == this.last.getLevel() + 1) {
                Idea newIdea;
                this.last = newIdea = this.last.createIdea(styleBuilder, backColor, level, label, shape, stereotype);
                return CommandExecutionResult.ok();
            }
            if (level <= this.last.getLevel()) {
                Idea newIdea;
                int diff = this.last.getLevel() - level + 1;
                this.last = newIdea = this.getParentOfLast(diff).createIdea(styleBuilder, backColor, level, label, shape, stereotype);
                return CommandExecutionResult.ok();
            }
            return CommandExecutionResult.error("error42L");
        }
    }
}

