-- © 2025 Nokia
-- Licensed under the BSD 3-Clause License
-- SPDX-License-Identifier: BSD-3-Clause

local function mscgenToPng(mscgen, charttype)
	local fname = "tmp.png"
	local png = pandoc.pipe("mscgen", {"-T", "png", "-q", "-o", fname, "-S", charttype, "--nocopyright"}, mscgen) -- skip the copyright watermark in the mscgen generated figures
	local f = io.open(fname, "rb")
	local contents = f:read "*a"
	f:close()
	return contents
end


function CodeBlock(block)
	if block.classes[1] == "mscgen" then
		local img = mscgenToPng(block.text, "signalling")
		local fname = pandoc.sha1(img) .. ".png"
		local mimetype = "image/png"
		pandoc.mediabag.insert(fname, mimetype, img)
		return pandoc.Para{ pandoc.Image({pandoc.Str("")}, fname) }
	end
	if block.classes[1] == "mscgenblock" then
		local img = mscgenToPng(block.text, "block")
		local fname = pandoc.sha1(img) .. ".png"
		local mimetype = "image/png"
		pandoc.mediabag.insert(fname, mimetype, img)
		return pandoc.Para{ pandoc.Image({pandoc.Str("")}, fname) }
	end
end
