REM © 2025 NokiaREM 
REM Licensed under tREM he BSD 3-Clause License
REM SPDX-License-IdentifREM ier: BSD-3-Clause

REM Load configuration file
call config.bat

set CSS_PATH=print_style_px.css

REM Equation rendering not enabled: -L equation_render.lua 
REM Equation rendering done natively for now, with a mix of text and images

REM * Remove old temporary media directory if it exists.
if exist .\media (
    rmdir /s .\media
)

if exist %OUTPUT_DIR%\media (
    rmdir /s %OUTPUT_DIR%\media
)

REM * Create new temporary media directory.
mkdir .\media

REM * Copy images from source image directory.
if exist %IMAGES_PATH%\ (
    copy %IMAGES_PATH%\* .\media\
)

%PANDOC_PATH% -f markdown+pipe_tables -t html -L asn_render.lua -L msc_to_img.lua -L indent_procedural.lua -L toc.lua -L cover_page.lua --metadata=cover_page_path:"%COVER_PAGE_PATH%"  -o %HTML_PATH% --standalone --resource-path=. --extract-media=.\media --metadata title=%HTML_TITLE% --css=%CSS_FILE% %MD_PATH%

REM if exist %RESOURCE_PATH%\ (
REM    rmdir /s %RESOURCE_PATH%
REM )

REM * Move media resources to output directory.
move media %OUTPUT_DIR%\media

REM * Copy the CSS stylesheet to the output directory
copy %CSS_PATH% %OUTPUT_DIR%

REM Cleanup MSC temporary output
del tmp.png
