-- © 2025 Nokia
-- Licensed under the BSD 3-Clause License
-- SPDX-License-Identifier: BSD-3-Clause

local function isProceduralString(inlines)
	if string.find(tostring(inlines[1]), "%d+>") then
		return true
	else
		return false
	end
end


local function getProceduralLevel(str)
	_, _, level = string.find(str, "(%d+)>")
	return level
end

local function applyProceduralIndent(inlines)

	local result = pandoc.Inlines{}
	
	level = getProceduralLevel(tostring(inlines[1]))
	openTag = string.format('<div class="b%d">', level)
	closeTag = "</div>"
	
	result:insert(pandoc.RawInline('html', openTag))
	result:extend(inlines)
	result:insert(pandoc.RawInline('html', closeTag))
	return pandoc.Inlines(result)
end

function Para(elem)
	if isProceduralString(elem.content) then
		return pandoc.Para(applyProceduralIndent(elem.content))
	else
		return elem
	end
end