-- © 2025 Nokia
-- Licensed under the BSD 3-Clause License
-- SPDX-License-Identifier: BSD-3-Clause

local coverPagePath = nil

function Meta(meta)
    -- Get command line argument for the cover page path
    coverPagePath = meta.cover_page_path

end   

function Pandoc(doc)
      
    if coverPagePath ~= nil then
        -- Read cover page into memory
        local f = io.open(coverPagePath, "rb")
        local coverHTML = f:read "*a"
        f:close()
        
        -- Prepend cover page as raw HTML
        local coverHTMLBlock = pandoc.RawBlock("html", coverHTML)
        table.insert(doc.blocks, 1, coverHTMLBlock)
        return doc
    end

end