# Foreword

This Technical Specification has been produced by the 3^rd^ Generation Partnership Project (3GPP).

The contents of the present document are subject to continuing work within the TSG and may change following formal TSG approval. Should the TSG modify the contents of the present document, it will be re-released by the TSG with an identifying change of release date and an increase in version number as follows:

Version x.y.z

where:

x the first digit:

1 presented to TSG for information;

2 presented to TSG for approval;

3 or greater indicates TSG approved document under change control.

y the second digit is incremented for all changes of substance, i.e. technical enhancements, corrections, updates, etc.

z the third digit is incremented when editorial only changes have been incorporated in the document.
`<div class="pagebreak"> </div>`{=html}

#  1 Scope

The present document specifies the Radio Resource Control protocol for the radio interface between UE and NG-RAN.

The scope of the present document also includes:

- the radio related information transported in a transparent container between source gNB and target gNB upon inter gNB handover;

- the radio related information transported in a transparent container between a source or target gNB and another system upon inter RAT handover.

- the radio related information transported in a transparent container between a source eNB and target gNB during E-UTRA-NR Dual Connectivity.

The RRC protocol is also used to configure the radio interface between an IAB-node and its parent node \[2\].

# 2 References

The following documents contain provisions which, through reference in this text, constitute provisions of the present document.

- References are either specific (identified by date of publication, edition number, version number, etc.) or non‑specific.

- For a specific reference, subsequent revisions do not apply.

- For a non-specific reference, the latest version applies. In the case of a reference to a 3GPP document (including a GSM document), a non-specific reference implicitly refers to the latest version of that document *in the same Release as the present document*.

\[1\] 3GPP TR 21.905: \"Vocabulary for 3GPP Specifications\".

\[2\] 3GPP TS 38.300: \"NR; Overall description; Stage 2\".

\[3\] 3GPP TS 38.321: \"NR; Medium Access Control (MAC); Protocol specification\".

\[4\] 3GPP TS 38.322: \"NR; Radio Link Control (RLC) protocol specification\".

\[5\] 3GPP TS 38.323: \"NR; Packet Data Convergence Protocol (PDCP) protocol specification\".

\[6\] ITU-T Recommendation X.680 (08/2015) \"Information Technology -- Abstract Syntax Notation One (ASN.1): Specification of basic notation\" (Same as the ISO/IEC International Standard 8824-1).

\[7\] ITU-T Recommendation X.681 (08/2015) \"Information Technology -- Abstract Syntax Notation One (ASN.1): Information object specification\" (Same as the ISO/IEC International Standard 8824-2).

\[8\] ITU-T Recommendation X.691 (08/2015) \"Information technology -- ASN.1 encoding rules: Specification of Packed Encoding Rules (PER)\" (Same as the ISO/IEC International Standard 8825-2).

\[9\] 3GPP TS 38.215: \"NR; Physical layer measurements\".

\[10\] 3GPP TS 36.331: \"Evolved Universal Terrestrial Radio Access (E-UTRA) Radio Resource Control (RRC); Protocol Specification\".

\[11\] 3GPP TS 33.501: \"Security Architecture and Procedures for 5G System\".

\[12\] 3GPP TS 38.104: \"NR; Base Station (BS) radio transmission and reception\".

\[13\] 3GPP TS 38.213: \"NR; Physical layer procedures for control\".

\[14\] 3GPP TS 38.133: \"NR; Requirements for support of radio resource management\".

\[15\] 3GPP TS 38.101-1: \"NR; User Equipment (UE) radio transmission and reception; Part 1: Range 1 Standalone\".

\[16\] 3GPP TS 38.211: \"NR; Physical channels and modulation\".

\[17\] 3GPP TS 38.212: \"NR; Multiplexing and channel coding\".

\[18\] ITU-T Recommendation X.683 (08/2015) \"Information Technology -- Abstract Syntax Notation One (ASN.1): Parameterization of ASN.1 specifications\" (Same as the ISO/IEC International Standard 8824-4).

\[19\] 3GPP TS 38.214: \"NR; Physical layer procedures for data\".

\[20\] 3GPP TS 38.304: \"NR; User Equipment (UE) procedures in Idle mode and RRC Inactive state\".

\[21\] 3GPP TS 23.003: \"Numbering, addressing and identification\".

\[22\] 3GPP TS 36.101: \"E-UTRA; User Equipment (UE) radio transmission and reception\".

\[23\] 3GPP TS 24.501: \"Non-Access-Stratum (NAS) protocol for 5G System (5GS); Stage 3\".

\[24\] 3GPP TS 37.324: \"Service Data Adaptation Protocol (SDAP) specification\".

\[25\] 3GPP TS 22.261: \"Service requirements for the 5G System\".

\[26\] 3GPP TS 38.306: \"User Equipment (UE) radio access capabilities\".

\[27\] 3GPP TS 36.304: \"E-UTRA; User Equipment (UE) procedures in idle mode\".

\[28\] ATIS 0700041: \"WEA 3.0: Device-Based Geo-Fencing\".

\[29\] 3GPP TS 23.041: \"Technical realization of Cell Broadcast Service (CBS)\".

\[30\] 3GPP TS 33.401: \"3GPP System Architecture Evolution (SAE); Security architecture\".

\[31\] 3GPP TS 36.211: \"E-UTRA; Physical channels and modulation\".

\[32\] 3GPP TS 23.501: \"System Architecture for the 5G System; Stage 2\".

\[33\] 3GPP TS 36.104:\"E-UTRA; Base Station (BS) radio transmission and reception\".

\[34\] 3GPP TS 38.101-3 \"NR; User Equipment (UE) radio transmission and reception; Part 3: Range 1 and Range 2 Interworking operation with other radios\".

\[35\] 3GPP TS 38.423: \"NG-RAN, Xn application protocol (XnAP)\".

\[36\] 3GPP TS 38.473: \"NG-RAN; F1 application protocol (F1AP)\".

\[37\] 3GPP TS 36.423: \"E-UTRA; X2 application protocol (X2AP)\".

\[38\] 3GPP TS 24.008: \"Mobile radio interface layer 3 specification; Core network protocols; Stage 3\".

\[39\] 3GPP TS 38.101-2 \"NR; User Equipment (UE) radio transmission and reception; Part 2: Range 2 Standalone\".

\[40\] 3GPP TS 36.133:\"E-UTRA; Requirements for support of radio resource management\".

\[41\] 3GPP TS 37.340: \"E-UTRA and NR; Multi-connectivity; Stage 2\".

\[42\] 3GPP TS 38.413: \"NG-RAN, NG Application Protocol (NGAP)\".

\[43\] 3GPP TS 23.502: \"Procedures for the 5G System; Stage 2\".

\[44\] 3GPP TR 36.816: \"Evolved Universal Terrestrial Radio Access (E-UTRA); Study on signalling and procedure for interference avoidance for in-device coexistence \".

\[45\] 3GPP TS 25.331: \"Universal Terrestrial Radio Access (UTRA); Radio Resource Control (RRC); Protocol specification\".

\[46\] 3GPP TS 25.133: \"Requirements for Support of Radio Resource Management (FDD)\".

\[47\] 3GPP TS 38.340: \"Backhaul Adaptation Protocol (BAP) specification\"

\[48\] 3GPP TS 37.213: \"Physical layer procedures for shared spectrum channel access\".

\[49\] 3GPP TS 37.355: \"LTE Positioning Protocol (LPP)\".

\[50\] IEEE 802.11-2012, Part 11: Wireless LAN Medium Access Control (MAC) and Physical Layer (PHY) specifications, IEEE Std.

\[51\] Bluetooth Special Interest Group: \"Bluetooth Core Specification v5.0\", December 2016.

\[52\] 3GPP TS 32.422: \"Telecommunication management; Subscriber and equipment trace; Trace control and configuration management\".

\[53\] 3GPP TS 38.314: \"NR; layer 2 measurements\".

\[54\] Void.

\[55\] 3GPP TS 23.287: \"Architecture enhancements for 5G System (5GS) to support Vehicle-to-Everything (V2X) services\".

\[56\] 3GPP TS 23.285: \"Technical Specification Group Services and System Aspects; Architecture enhancements for V2X services\".

\[57\] 3GPP TS 24.587: \" Technical Specification Group Core Network and Terminals; Vehicle-to-Everything (V2X) services in 5G System (5GS)\".

\[58\] Military Standard WGS84 Metric MIL-STD-2401 (11 January 1994): \"Military Standard Department of Defence World Geodetic System (WGS)\".

\[59\] 3GPP TS 38.101-4 \"NR; User Equipment (UE) radio transmission and reception; Part 4: Performance Requirements\".

\[60\] 3GPP TS 33.536: \"Technical Specification Group Services and System Aspects; Security aspects of 3GPP support for advanced Vehicle-to-Everything (V2X) services\".

\[61\] 3GPP TS 37.320: \"Radio measurement collection for Minimization of Drive Tests (MDT); Overall description; Stage 2\".

\[62\] 3GPP TS 36.306: \"User Equipment (UE) radio access capabilities\".

\[63\] 3GPP TS 38.174: \"NR; Integrated Access and Backhaul (IAB) radio transmission and reception\".

\[64\] 3GPP TS 38.472: \"NG-RAN; F1 signalling transport\".

\[65\] 3GPP TS 23.304: \"Proximity based Services (ProSe) in the 5G System (5GS)\".

\[66\] 3GPP TS 38.351: \"NR; Sidelink Relay Adaptation Protocol (SRAP) Specification\".

\[67\] 3GPP TS 23.247: \"Architectural enhancements for 5G multicast-broadcast services; Stage 2\"

\[68\] 3GPP TS 26.247: \"Transparent end-to-end Packet-switched Streaming Service (PSS); Progressive Download and Dynamic Adaptive Streaming over HTTP (3GP-DASH)\".

\[69\] 3GPP TS 26.114: \"IP Multimedia Subsystem (IMS); Multimedia Telephony; Media handling and interaction\".

\[70\] 3GPP TS 26.118: \"Virtual Reality (VR) profiles for streaming applications\".

\[71\] NIMA TR 8350.2, Third Edition, Amendment 1, 3 January 2000: \"DEPARTMENT OF DEFENSE WORLD GEODETIC SYSTEM 1984\".

\[72\] 3GPP TS 24.554: \"Technical Specification Group Core Network and Terminals; Proximity-services (ProSe) in 5G System (5GS) protocol\".

\[73\] 3GPP TS 38.305: \"NG Radio Access Network (NG-RAN); Stage 2 functional specification of User Equipment (UE) positioning in NG-RAN\".

\[74\] 3GPP TS 23.122: \"Non-Access-Stratum (NAS) functions related to Mobile Station (MS) in idle mode\".

\[75\] 3GPP TS 38.101-5: \"User Equipment (UE) radio transmission and reception; Part 5: Satellite access Radio Frequency (RF) and performance requirements\".

\[76\] 3GPP TS 23.256: \"Support of Uncrewed Aerial Systems (UAS) connectivity, identification and tracking; Stage 2\".

\[77\] 3GPP TS 38.355: \"NR; Sidelink Positioning Protocol (SLPP); Protocol Specification\".

# 3 Definitions, symbols and abbreviations

## 3.1 Definitions

For the purposes of the present document, the terms and definitions given in TR 21.905 \[1\] and the following apply. A term defined in the present document takes precedence over the definition of the same term, if any, in TR 21.905 \[1\].

**A2X communication:** A communication to support A2X services leveraging PC5 reference points, as defined in TS 23.256 \[76\]. A2X services are realized by various types of A2X applications, e.g., BRID or DAA.

**Aerial UE:** UE performing Aerial UE communication, as defined in TS 38.300 \[2\], clause 16.18 and TS 23.256 \[76\].

**AM MRB:** An MRB associated with at least an AM RLC bearer for PTP transmission.

**BH RLC channel:** An RLC channel between two nodes, which is used to transport backhaul packets.

**Broadcast MRB:** A radio bearer configured for MBS broadcast delivery.

**CEIL:** Mathematical function used to \'round up\' i.e. to the nearest integer having a higher or equal value.

**DAPS bearer:** a bearer whose radio protocols are located in both the source gNB and the target gNB during DAPS handover to use both source gNB and target gNB resources.

**Data Burst:** A set of multiple PDUs generated and sent by the application in a short period of time, as defined in TS 23.501 \[32\].

**Dedicated signalling:** Signalling sent on DCCH logical channel between the network and a single UE.

**Dormant BWP:** The dormant BWP is one of downlink BWPs configured by the network via dedicated RRC signalling. In the dormant BWP, the UE stops monitoring PDCCH on/for the SCell, but continues performing CSI measurements, Automatic Gain Control (AGC) and beam management, if configured. For each serving cell other than the SpCell or PUCCH SCell, the network may configure one BWP as a dormant BWP.

**eRedCap UE:** A UE with enhanced reduced capabilities as specified in clause 4.2.22.1 in TS 38.306 \[26\].

**Field:** The individual contents of an information element are referred to as fields.

**FLOOR:** Mathematical function used to \'round down\' i.e. to the nearest integer having a lower or equal value.

**Frequency Selection Area ID:** An identity used for broadcast MBS session to guide the frequency selection of the UE as defined in TS 23.247 \[67\].

**Global cell identity:** An identity to uniquely identifying an NR cell. It is consisted of *cellIdentity* and *plmn-Identity* of the first *PLMN-Identity* in *plmn-IdentityList* in SIB1.

**Information element:** A structural element containing single or multiple fields is referred as information element.

**Candidate configuration:** A configuration part of an *RRCReconfiguration* message associated with a candidate cell, e.g., for LTM or subsequent CPAC. A candidate configuration can be a complete candidate configuration or a delta configuration relatively to a reference configuration.

**Reference configuration:** A configuration provided by the network to the UE that is common, within the same cell group, to a group of configured non-complete candidate configurations.

**MBS Radio Bearer:** A radio bearer that is configured for MBS delivery.

**Mobile IAB-MT**: mobile IAB-node function that terminates the Uu interface to the parent node using the procedures and behaviours specified for UEs unless stated otherwise.

**Mobile IAB-node**: RAN node that supports NR access links to UEs and an NR backhaul link to a parent node, and that can conduct physical mobility across the RAN area. The mobile IAB-node function used in 38-series of 3GPP Specifications corresponds to the MBSR function defined in TS 23.501 \[32\].

**Multicast/Broadcast Service:** A point-to-multipoint service as defined in TS 23.247 \[67\].

**Multicast MRB:** A radio bearer configured for MBS multicast delivery.

**MUSIM gap:** Period that the UE may use to perform MUSIM operations.

**Multi-path:** Mode of operation of a UE in RRC_CONNECTED configured with one direct path on which the UE connects to gNB using NR Uu, and one indirect path on which the UE connects to the same gNB via another UE using PC5 unicast link or Non-3GPP Connection.

**MP remote UE:** A UE configured with Multi-path. When the connectivity of indirect path is PC5 unicast link, the MP remote UE is acting as a L2 U2N Remote UE. When the connectivity of indirect path is Non-3GPP Connection, the MP remote UE is acting as a N3C remote UE.

**MP relay UE:** A UE that provides connectivity of indirect path to a MP remote UE. When the connectivity is PC5 unicast link, the MP relay UE is acting as a L2 U2N Relay UE. When the connectivity is Non-3GPP Connection, the MP relay UE is acting as a N3C relay UE.

**NCSG:** Network controlled small gap as defined in TS 38.133 \[14\].

**NPN-only Cell**: A cell that is only available for normal service for NPNs\' subscriber. An NPN-capable UE determines that a cell is NPN-only Cell by detecting that the *cellReservedForOtherUse* IE is set to true while the *npn-IdentityInfoList* IE is present in *CellAccessRelatedInfo*.

**N3C indirect path:** In Multi-path, the indirect path using Non-3GPP Connection between remote UE and relay UE.

**NR sidelink communication**: AS functionality enabling at least V2X Communication as defined in TS 23.287 \[55\] and ProSe Communication (including ProSe UE-to-Network Relay, non-Relay communication and ProSe UE-to-UE Relay Communication) as defined in TS 23.304 \[65\] between two or more nearby UEs, using NR technology but not traversing any network node.

**NR sidelink discovery**: AS functionality enabling ProSe non-Relay Discovery, ProSe UE-to-Network Relay discovery and ProSe UE-to-UE Relay discovery for Proximity based Services as defined in TS 23.304 \[65\] between two or more nearby UEs, using NR technology but not traversing any network node.

**NR sidelink positioning:** AS functionality enabling absolute positioning of a target UE or ranging via PC5 interface using SL-PRS transmission and reception as defined in TS 38.305 \[73\] and TS 38.355 \[77\].

**PNI-NPN identity:** an identifier of a PNI-NPN comprising of a PLMN ID and a CAG-ID combination.

**Primary Cell**: The MCG cell, operating on the primary frequency, in which the UE either performs the initial connection establishment procedure or initiates the connection re-establishment procedure.

**PC5 Relay RLC channel**: An RLC channel between L2 U2N Remote UE and L2 U2N Relay UE, or between L2 U2U Remote UE and L2 U2U Relay UE, which is used to transport packets over PC5 for L2 UE-to-Network relay or L2 UE-to-UE relay.

**Primary SCG Cell**: For dual connectivity operation, the SCG cell in which the UE performs random access when performing the Reconfiguration with Sync procedure.

**Primary Timing Advance Group**: Timing Advance Group containing the SpCell.

**PUCCH SCell:** An SCell configured with PUCCH by *PUCCH-Config*.

**PUSCH-Less SCell:** An SCell configured without PUSCH.

**RedCap UE:** A UE with reduced capabilities as specified in clause 4.2.21.1 in TS 38.306 \[26\].

**RLC bearer configuration:** The lower layer part of the radio bearer configuration comprising the RLC and logical channel configurations.

**Secondary Cell**: For a UE configured with CA, a cell providing additional radio resources on top of Special Cell.

**Secondary Cell Group**: For a UE configured with dual connectivity, the subset of serving cells comprising of the PSCell and zero or more secondary cells.

**Serving Cell**: For a UE in RRC_CONNECTED not configured with CA/DC there is only one serving cell comprising of the primary cell. For a UE in RRC_CONNECTED configured with CA/ DC the term \'serving cells\' is used to denote the set of cells comprising of the Special Cell(s) and all secondary cells.

**Small Data Transmission**: A procedure used for transmission of data and/or signalling over allowed radio bearers in RRC_INACTIVE state (i.e. without the UE transitioning to RRC_CONNECTED state).

**SNPN identity:** an identifier of an SNPN comprising of a PLMN ID and an NID combination.

**SL indirect path:** In Multi-path, the indirect path using PC5 unicast link between remote UE and relay UE.

**Special Cell:** For Dual Connectivity operation the term Special Cell refers to the PCell of the MCG or the PSCell of the SCG, otherwise the term Special Cell refers to the PCell.

**Split DRB:** In MR-DC or MP, a DRB that supports transmission via MCG and SCG/indirect path in MP, as well as duplication of PDCP PDUs as defined in TS 37.340 \[41\].

**Split SRB**: In MR-DC or MP, an SRB that supports transmission via MCG and SCG/indirect path in MP as well as duplication of RRC PDUs as defined in TS 37.340 \[41\].

**SSB Frequency**: Frequency referring to the position of resource element RE=#0 (subcarrier #0) of resource block RB#10 of the SS block.

**U2N Relay UE**: A UE that provides functionality to support connectivity to the network for U2N Remote UE(s).

**U2N Remote UE**: A UE that communicates with the network via a U2N Relay UE.

**U2U Relay UE:** A UE that provides functionality to support connectivity between U2U Remote UEs.

**U2U Remote UE:** A UE that communicates with another UE via a U2U Relay UE.

**Uu Relay RLC channel**: An RLC channel between L2 U2N Relay UE and gNB, which is used to transport packets over Uu for L2 UE-to-Network relay or for indirect path in case of MP**.**

**UE Inactive AS Context**: UE Inactive AS Context is stored when the connection is suspended and restored when the connection is resumed. It includes information as defined in clause 5.3.8.3.

**V2X sidelink communication**: AS functionality enabling V2X Communication as defined in TS 23.285 \[56\], between nearby UEs, using E-UTRA technology but not traversing any network node.

## 3.2 Abbreviations

For the purposes of the present document, the abbreviations given in TR 21.905 \[1\] and the following apply. An abbreviation defined in the present document takes precedence over the definition of the same abbreviation, if any, in TR 21.905 \[1\].

5GC 5G Core Network

A2X Aircraft-to-Everything

ACK Acknowledgement

AM Acknowledged Mode

ARQ Automatic Repeat Request

AS Access Stratum

ASN.1 Abstract Syntax Notation One

ATG Air to Ground

BAP Backhaul Adaptation Protocol

BCD Binary Coded Decimal

BFD Beam Failure Detection

BH Backhaul

BLER Block Error Rate

BRID Broadcast Remote Identification

BSR Buffer Status Report

BWP Bandwidth Part

CA Carrier Aggregation

CAG Closed Access Group

CAG-ID Closed Access Group Identifier

CAPC Channel Access Priority Class

CBR Channel Busy Ratio

CCCH Common Control Channel

CFR Common Frequency Resources

CG Cell Group

CHO Conditional Handover

CLI Cross Link Interference

CMAS Commercial Mobile Alert Service

CP Control Plane

CPA Conditional PSCell Addition

CPAC Conditional PSCell Addition or Change

CPC Conditional PSCell Change

C-RNTI Cell RNTI

CSI Channel State Information

DAA Detect And Avoid

DAPS Dual Active Protocol Stack

DC Dual Connectivity

DCCH Dedicated Control Channel

DCI Downlink Control Information

DCP DCI with CRC scrambled by PS-RNTI

DFN Direct Frame Number

DL Downlink

DL-PRS Downlink Positioning Reference Signal

DL-SCH Downlink Shared Channel

DM-RS Demodulation Reference Signal

DRB (user) Data Radio Bearer

DRX Discontinuous Reception

DSR Delay Status Report

DTCH Dedicated Traffic Channel

DTX Discontinuous Transmission

ECEF Earth-Centered, Earth-Fixed

ECI Earth-Centered Inertial

EN-DC E-UTRA NR Dual Connectivity with E-UTRA connected to EPC

EPC Evolved Packet Core

EPS Evolved Packet System

ETWS Earthquake and Tsunami Warning System

E-UTRA Evolved Universal Terrestrial Radio Access

E-UTRA/5GC E-UTRA connected to 5GC

E-UTRA/EPC E-UTRA connected to EPC

E-UTRAN Evolved Universal Terrestrial Radio Access Network

FDD Frequency Division Duplex

FFS For Further Study

G-CS-RNTI Group Configured Scheduling RNTI

GERAN GSM/EDGE Radio Access Network

GIN Group ID for Network selection

GNSS Global Navigation Satellite System

G-RNTI Group RNTI

GSM Global System for Mobile Communications

HARQ Hybrid Automatic Repeat Request

HRNN Human Readable Network Name

HSDN High Speed Dedicated Network

H-SFN Hyper SFN

HST High Speed Train

IAB Integrated Access and Backhaul

IAB-DU IAB-node DU

IAB-MT IAB Mobile Termination

IDC In-Device Coexistence

IE Information element

IMSI International Mobile Subscriber Identity

kB Kilobyte (1000 bytes)

L1 Layer 1

L2 Layer 2

L3 Layer 3

LBT Listen Before Talk

LEO Low Earth Orbit

LTM L1/L2 Triggered Mobility

MAC Medium Access Control

MBS Multicast/Broadcast Service

MBS FSAI MBS Frequency Selection Area Identity

MCCH MBS Control Channel

MCG Master Cell Group

MDT Minimization of Drive Tests

MIB Master Information Block

MO-SDT Mobile Originated SDT

MPE Maximum Permissible Exposure

MP Multi-path

MRB MBS Radio Bearer

MR-DC Multi-Radio Dual Connectivity

MTCH MBS Traffic Channel

MT-SDT Mobile Terminated SDT

MTSI Multimedia Telephony Service for IMS

MUSIM Multi-Universal Subscriber Identity Module

N3C Non-3GPP Connection

N/A Not Applicable

NCR Network-Controlled Repeater

NCR-Fwd NCR Forwarding

NCR-MT NCR Mobile Termination

NE-DC NR E-UTRA Dual Connectivity

NES Network Energy Savings

(NG)EN-DC E-UTRA NR Dual Connectivity (covering E-UTRA connected to EPC or 5GC)

NGEN-DC E-UTRA NR Dual Connectivity with E-UTRA connected to 5GC

NID Network Identifier

NPN Non-Public Network

NR-DC NR-NR Dual Connectivity

NR/5GC NR connected to 5GC

NSAG Network Slice AS Group

NTN Non-Terrestrial Network

PCell Primary Cell

PDCP Packet Data Convergence Protocol

PDU Protocol Data Unit

PEI Paging Early Indication

PEI-O Paging Early Indication-Occasion

PLMN Public Land Mobile Network

PNI-NPN Public Network Integrated Non-Public Network

posSIB Positioning SIB

PPW PRS Processing Window

PRS Positioning Reference Signal

PSCell Primary SCG Cell

PSI PDU Set Importance

PTM Point to Multipoint

PTP Point to Point

PWS Public Warning System

QoE Quality of Experience

QoS Quality of Service

RAN Radio Access Network

RAT Radio Access Technology

RLC Radio Link Control

RLM Radio Link Monitoring

RMTC RSSI Measurement Timing Configuration

RNA RAN-based Notification Area

RNTI Radio Network Temporary Identifier

ROHC Robust Header Compression

RPLMN Registered Public Land Mobile Network

RRC Radio Resource Control

RS Reference Signal

SBAS Satellite Based Augmentation System

SCell Secondary Cell

SCG Secondary Cell Group

SCS Subcarrier Spacing

SD-RSRP Sidelink Discovery RSRP

SDT Small Data Transmission

SFN Single Frequency Network

SFN System Frame Number

SFTD SFN and Frame Timing Difference

SI System Information

SIB System Information Block

SL Sidelink

SL-PRS Sidelink Positioning Reference Signal

SLSS Sidelink Synchronisation Signal

SNPN Stand-alone Non-Public Network

SpCell Special Cell

SRAP Sidelink Relay Adaptation Protocol

SRB Signalling Radio Bearer

SRS Sounding Reference Signal

SSB Synchronization Signal Block

TAG Timing Advance Group

TDCP Time Domain Channel Property

TDD Time Division Duplex

TEG Timing Error Group

TM Transparent Mode

TMGI Temporary Mobile Group Identity

TN Terrestrial Network

U2N UE-to-Network

U2U UE-to-UE

UDC Uplink Data Compression

UE User Equipment

UL Uplink

UM Unacknowledged Mode

UP User Plane

VR Virtual Reality

XR eXtended Reality

In the ASN.1, lower case may be used for some (parts) of the above abbreviations e.g. c-RNTI.

# 4 General

## 4.1 Introduction

This specification is organised as follows:

- clause 4.2 describes the RRC protocol model;

- clause 4.3 specifies the services provided to upper layers as well as the services expected from lower layers;

- clause 4.4 lists the RRC functions;

- clause 5 specifies RRC procedures, including UE state transitions;

- clause 6 specifies the RRC messages in ASN.1 and description;

- clause 7 specifies the variables (including protocol timers and constants) and counters to be used by the UE;

- clause 8 specifies the encoding of the RRC messages;

- clause 9 specifies the specified and default radio configurations;

- clause 10 specifies generic error handling;

- clause 11 specifies the RRC messages transferred across network nodes;

- clause 12 specifies the UE capability related constraints and performance requirements.

## 4.2 Architecture

### 4.2.1 UE states and state transitions including inter RAT

A UE is either in RRC_CONNECTED state or in RRC_INACTIVE state when an RRC connection has been established. If this is not the case, i.e. no RRC connection is established, the UE is in RRC_IDLE state. The RRC states can further be characterised as follows:

- **RRC_IDLE**:

- A UE specific DRX may be configured by upper layers;

- At lower layers, the UE may be configured with a DRX for PTM transmission of MBS broadcast;

- UE controlled mobility based on network configuration;

- The UE:

- Monitors Short Messages transmitted with P-RNTI over DCI (see clause 6.5);

- Monitors a Paging channel for CN paging using 5G-S-TMSI, except if the UE is acting as a L2 U2N Remote UE;

- If configured by upper layers for MBS multicast reception, monitors a Paging channel for CN paging using TMGI;

- Performs neighbouring cell measurements and cell (re-)selection;

- Acquires system information and can send SI request (if configured);

- Performs logging of available measurements together with location and time for logged measurement configured UEs;

- Performs idle/inactive measurements for idle/inactive measurement configured UEs;

- If configured by upper layers for MBS broadcast reception, acquires MCCH change notification and MBS broadcast control information and data.

- **RRC_INACTIVE**:

- A UE specific DRX may be configured by upper layers or by RRC layer;

- At lower layers, the UE may be configured with a DRX for PTM transmission of MBS broadcast and/or a DRX for PTM transmission of MBS multicast;

- UE controlled mobility based on network configuration;

- The UE stores the UE Inactive AS context;

- A RAN-based notification area is configured by RRC layer;

- Transfer of unicast data and/or signalling to/from UE over radio bearers configured for SDT.

- The UE:

- Monitors Short Messages transmitted with P-RNTI over DCI (see clause 6.5);

- While T319a is running, monitors control channels associated with the shared data channel to determine if data is scheduled for it;

- While T319a is not running, monitors a Paging channel for CN paging using 5G-S-TMSI and RAN paging using fullI-RNTI, except if the UE is acting as a L2 U2N Remote UE;

- If configured by upper layers for MBS multicast reception, while T319a is not running, monitors a Paging channel for paging using TMGI;

- Performs neighbouring cell measurements and cell (re-)selection;

- Performs RAN-based notification area updates periodically and when moving outside the configured RAN-based notification area;

- Acquires system information and, while SDT procedure is not ongoing, can send SI request (if configured);

- While SDT procedure is not ongoing, performs logging of available measurements together with location and time for logged measurement configured UEs;

- While SDT procedure is not ongoing, performs idle/inactive measurements for idle/inactive measurement configured UEs;

- If configured by upper layers for MBS broadcast reception, acquires MCCH change notification and MBS broadcast control information and data;

- If configured for MBS multicast reception in RRC_INACTIVE, acquires multicast MCCH change notification and MBS multicast control information and data;

- Transmits SRS for Positioning.

- **RRC_CONNECTED:**

- The UE stores the AS context;

- Transfer of unicast data to/from UE;

- Transfer of MBS multicast data to UE;

- At lower layers, the UE may be configured with a UE specific DRX;

- At lower layers, the UE may be configured with a DRX for PTM transmission of MBS broadcast and/or a DRX for MBS multicast;

- At lower layers, the UE may be configured with a cell specific cell DTX/DRX;

- For UEs supporting CA, use of one or more SCells, aggregated with the SpCell, for increased bandwidth;

- For UEs supporting DC, use of one SCG, aggregated with the MCG, for increased bandwidth;

- Network controlled mobility within NR, to/from E-UTRA, and to UTRA-FDD;

- Network controlled mobility (path switch) between a serving cell and a L2 U2N Relay UE, or vice versa.

- The UE:

- Monitors Short Messages transmitted with P-RNTI over DCI (see clause 6.5), if configured;

- Monitors control channels associated with the shared data channel to determine if data is scheduled for it;

- Provides channel quality and feedback information;

- Performs neighbouring cell measurements and measurement reporting;

- Acquires system information;

- Performs immediate MDT measurement together with available location reporting;

- If configured by upper layers for MBS broadcast reception, acquires MCCH change notification and MBS broadcast control information and data.

Figure 4.2.1-1 illustrates an overview of UE RRC state machine and state transitions in NR. A UE has only one RRC state in NR at one time.

~~~ mscgenblock
col {
box A: NR RRC_CONNECTED [line.corner=round, width=300];
space 100;
box B: NR RRC_INACTIVE [line.corner=round, mleft=A@mleft];
space 100;
box C: NR RRC_IDLE [line.corner=round, mleft=A@mleft, width=A];
};

A<->B [routing=vertical, text.ident=left, label.align=middle, label.pos=left]: Resume / Release
 with Suspend;
B->C [routing=vertical, text.ident=left, label.pos=right]: Release;

(A@80%, A@bottom)<->(C@80%, C@top) [label.pos=right, label.align=middle, text.ident=left]: Establish /
  Release;
~~~

Figure 4.2.1-1: UE state machine and state transitions in NR

Figure 4.2.1-2 illustrates an overview of UE state machine and state transitions in NR as well as the mobility procedures supported between NR/5GC, E-UTRA/EPC and E-UTRA/5GC.

~~~ mscgenblock
row {
col EUTRA {
box A: EUTRA
   RRC_CONNECTED[line.corner=round, width=300];
space 100;
box B: EUTRA
   RRC_INACTIVE [line.corner=round, width=150, mright=A@mright];
space 100;
box C: EUTRA
   RRC_IDLE [line.corner=round, width=A, mleft=A@mleft];
};

A<->B [routing=vertical];
B->C [routing=vertical];
(A@20%, A@bottom)<->(C@20%, C@top) [label.align=middle,
text.ident=left, 
label.pos=left]:
  Establish /
  Release;

space 150;

col NR {
box D: NR
   RRC_CONNECTED [line.corner=round, width=A];
space 100;
box E: NR
   RRC_INACTIVE [line.corner=round, width=150, mleft=D@mleft];
space 100;
box F: NR
   RRC_IDLE [line.corner=round, width=A, mleft=D@mleft];
};

D<->E [routing=vertical, label.align=middle,
  text.ident=left, label.pos=left]: Resume / Release
with Suspend;
   
E->F [routing=vertical, label.align=middle,
 text.ident=left, label.pos=right]: Release;
(D@80%, D@bottom)<->(F@80%, F@top) [label.align=middle,
text.ident=left, 
label.pos=right]:
  Establish /
  Release;

A<->D: Handover;
C<->F: Reselection;
B->(F@10%, F@top) [label.pos=above, label.align=70]: Reselection;
E->(C@90%, C@top) [label.pos=above, label.align=70]: Reselection;

};
~~~

Figure 4.2.1-2: UE state machine and state transitions between NR/5GC, E-UTRA/EPC and E-UTRA/5GC

Figure 4.2.1-3 illustrates the mobility procedure supported between NR/5GC and UTRA-FDD.

~~~ mscgenblock
box A: NR
   RRC_CONNECTED[line.corner=round, width=300];
space 100;
box B: UTRA-FDD
   CELL_DCH[line.corner=round, width=300];
A->B: Handover;
~~~

Figure 4.2.1-3: Mobility procedure supported between NR/5GC and UTRA-FDD

### 4.2.2 Signalling radio bearers

\"Signalling Radio Bearers\" (SRBs) are defined as Radio Bearers (RBs) that are used only for the transmission of RRC and NAS messages. More specifically, the following SRBs are defined:

- SRB0 is for RRC messages using the CCCH logical channel;

- SRB1 is for RRC messages (which may include a piggybacked NAS message) as well as for NAS messages prior to the establishment of SRB2, all using DCCH logical channel;

- SRB2 is for NAS messages and for RRC messages which include logged measurement information, all using DCCH logical channel. SRB2 has a lower priority than SRB1 and may be configured by the network after AS security activation;

- SRB3 is for specific RRC messages when UE is in (NG)EN-DC or NR-DC, all using DCCH logical channel;

- SRB4 is for RRC messages which include application layer measurement report information, all using DCCH logical channel. SRB4 has a lower priority than SRB1 and can only be configured by the network after AS security activation.

- SRB5 is for RRC messages which include application layer measurement report information, all using DCCH logical channel. SRB5 has a lower priority than SRB1 and SRB3 and can only be configured by the SN serving the SCG when the UE is in NR-DC, after AS security activation.

In downlink, piggybacking of NAS messages is used only for one dependant (i.e. with joint success/failure) procedure: bearer establishment/modification/release. In uplink piggybacking of NAS message is used only for transferring the initial NAS message during connection setup and connection resume.

NOTE 1: The NAS messages transferred via SRB2 are also contained in RRC messages, which however do not include any RRC protocol control information.

Once AS security is activated, all RRC messages on SRB1, SRB2, SRB3, SRB4 and SRB5, including those containing NAS messages, are integrity protected and ciphered by PDCP. NAS independently applies integrity protection and ciphering to the NAS messages, see TS 24.501 \[23\].

Split SRB is supported for all the MR-DC options as well as MP in both SRB1 and SRB2 (split SRB is not supported for SRB0, SRB3, SRB4 and SRB5).

For operation with shared spectrum channel access in FR1, SRB0, SRB1 and SRB3 are assigned with the highest priority Channel Access Priority Class (CAPC), (i.e. CAPC = 1) while CAPC for SRB2 is configurable.

## 4.3 Services

### 4.3.1 Services provided to upper layers

The RRC protocol offers the following services to upper layers:

- Broadcast of common control information;

- Notification of UEs in RRC_IDLE, e.g. about a mobile terminating call;

- Notification of UEs about ETWS and/or CMAS;

- Transfer of dedicated signalling;

- Broadcast of positioning assistance data;

- Transfer of application layer measurement configuration and reporting.

### 4.3.2 Services expected from lower layers

In brief, the following are the main services that RRC expects from lower layers:

- Integrity protection, ciphering and loss-less in-sequence delivery of information without duplication;

## 4.4 Functions

The RRC protocol includes the following main functions:

- Broadcast of system information:

- Including NAS common information;

- Information applicable for UEs in RRC_IDLE and RRC_INACTIVE (e.g. cell (re-)selection parameters, neighbouring cell information) and information (also) applicable for UEs in RRC_CONNECTED (e.g. common channel configuration information);

- Including ETWS notification, CMAS notification;

- Including positioning assistance data.

- RRC connection control:

- Paging;

- Establishment/modification/suspension/resumption/release of RRC connection, including e.g. assignment/modification of UE identity (C-RNTI, fullI-RNTI, etc.), establishment/modification/suspension/resumption/release of SRBs (except for SRB0);

- Access barring;

- Initial AS security activation, i.e. initial configuration of AS integrity protection (SRBs, DRBs) and AS ciphering (SRBs, DRBs);

- RRC connection mobility including e.g. intra-frequency and inter-frequency handover, path switch from a PCell to a target L2 U2N Relay UE or from a L2 U2N Relay UE to a target PCell or from a source L2 U2N Relay UE to a target L2 U2N Relay UE, associated AS security handling, i.e. key/algorithm change, specification of RRC context information transferred between network nodes;

- Establishment/modification/suspension/resumption/release of RBs carrying user data (DRBs/MRBs);

- Radio configuration control including e.g. assignment/modification of ARQ configuration, HARQ configuration, DRX configuration;

- In case of DC, cell management including e.g. change of PSCell, addition/modification/release of SCG cell(s);

- In case of CA, cell management including e.g. addition/modification/release of SCell(s);

- In case of MP, path management including e.g. addition/modification/release of indirect path;

- QoS control including assignment/ modification of semi-persistent scheduling (SPS) configuration and configured grant configuration for DL and UL respectively, assignment/ modification of parameters for UL rate control in the UE, i.e. allocation of a priority and a prioritised bit rate (PBR) for each RB of UE and logical channel of IAB-MT.

- Recovery from radio link failure.

- Inter-RAT mobility including e.g. AS security activation, transfer of RRC context information;

- Measurement configuration and reporting:

- Establishment/modification/release of measurement configuration (e.g. intra-frequency, inter-frequency and inter- RAT measurements);

- Setup and release of measurement gaps;

- Measurement reporting.

- Configuration of BAP entity and BH RLC channels for the support of IAB-node.

- Configuration of SRAP entity and Uu/PC5 Relay RLC channels for the support of L2 U2N relay.

- Other functions including e.g. generic protocol error handling, transfer of dedicated NAS information, transfer of UE radio access capability information.

- Support of self-configuration and self-optimisation.

- Support of measurement logging and reporting for network performance optimisation, as specified in TS 37.320 \[61\];

- Support of transfer of application layer measurement configuration and reporting.

- Configuration of side control information for NCR-node.

# 5 Procedures

## 5.1 General

### 5.1.1 Introduction

This clause covers the general requirements.

### 5.1.2 General requirements

The UE shall:

1\> process the received messages in order of reception by RRC, i.e. the processing of a message shall be completed before starting the processing of a subsequent message;

NOTE: Network may initiate a subsequent procedure prior to receiving the UE\'s response of a previously initiated procedure.

1\> within a clause execute the steps according to the order specified in the procedural description;

1\> consider the term \'radio bearer\' (RB) to cover SRBs, DRBs and MRBs unless explicitly stated otherwise;

1\> set the *rrc-TransactionIdentifier* in the response message, if included, to the same value as included in the message received from the network that triggered the response message;

1\> upon receiving a choice value set to *setup*:

2\> apply the corresponding received configuration and start using the associated resources, unless explicitly specified otherwise;

1\> upon receiving a choice value set to *release*:

2\> clear the corresponding configuration and stop using the associated resources;

1\> in case the size of a list is extended, upon receiving an extension field comprising the entries in addition to the ones carried by the original field (regardless of whether the network signals more entries in total); apply the following generic behaviour unless explicitly stated otherwise:

2\> create a combined list by concatenating the additional entries included in the extension field to the original field while maintaining the order among both the original and the additional entries;

2\> for the combined list, created according to the previous, apply the same behaviour as defined for the original field.

### 5.1.3 Requirements for UE in MR-DC

In this specification, the UE considers itself to be in:

- EN-DC, if and only if it is configured with *nr-SecondaryCellGroupConfig* according to TS 36.331\[10\], and it is connected to EPC,

- NGEN-DC, if and only if it is configured with *nr-SecondaryCellGroupConfig* according to TS 36.331\[10\], and it is connected to 5GC,

- NE-DC, if and only if it is configured with *mrdc-SecondaryCellGroup* set to *eutra-SCG*,

- NR-DC, if and only if it is configured with *mrdc-SecondaryCellGroup* set to *nr-SCG*,

- MR-DC, if and only if it is in (NG)EN-DC, NE-DC or NR-DC.

NOTE: This use of these terms deviates from the definition in TS 37.340 \[41\] and other specifications. In TS 37.340, these terms include also the case where the UE is configured with E-UTRA or NR MCG only (i.e. no NR or E-UTRA SCG) but with one or more bearers terminated in a secondary node (i.e. using NR PDCP).

The UE in (NG)EN-DC only executes a subclause of clause 5 in this specification when the subclause:

- is referred to from a subclause under execution, either in this specification or in TS 36.331 \[10\]; or

- applies to a message received on SRB3 (if SRB3 is established); or

- applies to field(s), IE(s), UE variable(s) or timer(s) in this specification that the UE is configured with.

When executing a subclause of clause 5 in this specification, the UE follows the requirements in clause 5.1.2 and in all subclauses of this specification applicable to the messages (including processing time requirements), fields, IEs, timers and UE variables indicated in the subclause under execution.

## 5.2 System information

### 5.2.1 Introduction

System Information (SI) is divided into the *MIB* and a number of SIBs and posSIBs where:

- the *MIB* is always transmitted on the BCH with a periodicity of 80 ms and repetitions made within 80 ms (TS 38.212 \[17\], clause 7.1) and it includes parameters that are needed to acquire *SIB1* from the cell. The first transmission of the *MIB* is scheduled in subframes as defined in TS 38.213 \[13\], clause 4.1 and repetitions are scheduled according to the period of SSB;

NOTE 1: If the period of SSB is larger than 80 ms, the MIB is transmitted with the same periodicity as that of SSB.

- the *SIB1* is transmitted on the DL-SCH with a periodicity of 160 ms and variable transmission repetition periodicity within 160 ms as specified in TS 38.213 \[13\], clause 13. The default transmission repetition periodicity of *SIB1* is 20 ms but the actual transmission repetition periodicity is up to network implementation. For SSB and CORESET multiplexing pattern 1, *SIB1* repetition transmission period is 20 ms. For SSB and CORESET multiplexing pattern 2/3, *SIB1* transmission repetition period is the same as the SSB period (TS 38.213 \[13\], clause 13). *SIB1* includes information regarding the availability and scheduling (e.g. mapping of SIBs to SI message, periodicity, SI-window size) of other SIBs with an indication whether one or more SIBs are only provided on-demand and, in that case, the configuration needed by the UE to perform the SI request. *SIB1* is cell-specific SIB;

- SIBs other than *SIB1* and posSIBs are carried in *SystemInformation* (SI) messages, which are transmitted on the DL-SCH. Only SIBs or posSIBs having the same periodicity can be mapped to the same SI message. SIBs and posSIBs are mapped to different SI messages, i.e. an SI message contains either only SIBs or only posSIBs. Each SI message is transmitted within periodically occurring time domain windows (referred to as SI-windows with same length for all SI messages). Each SI message is associated with an SI-window and the SI-windows of different SI messages do not overlap. That is, within one SI-window only the corresponding SI message is transmitted. An SI message may be repeated with the same content a number of times within the SI-window. Any SIB or posSIB except *SIB1* can be configured to be cell specific or area specific, using an indication in *SIB1*. The cell specific SIB is applicable only within a cell that provides the SIB while the area specific SIB is applicable within an area referred to as SI area, which consists of one or several cells and is identified by s*ystemInformationAreaID*;

- The mapping of SIBs to SI messages is configured in *schedulingInfoList* and *schedulingInfoList2*, while the mapping of posSIBs to SI messages is configured in *posSchedulingInfoList* and *schedulingInfoList2.\
*Each SIB and each posSIB is mapped to a single SI message. posSIBs of the same *posSibType* carrying GNSS Generic Assistance Data for different GNSS/SBAS (identified by *gnss-id/sbas-id*, see TS 37.355 \[49\]) are mapped to different SI messages.\
Each SIB and posSIB is contained at most once in an SI message.\
For SIBs and posSIBs with segments, the segments contained in SI messages are transmitted according to the SI message periodicity, with one segment of a particular *sibType*/*posSibType* in each SI message;

- For a UE in RRC_CONNECTED, the network can provide system information through dedicated signalling using the *RRCReconfiguration* message, e.g. if the UE has an active BWP with no common search space configured to monitor system information, paging, or upon request from the UE.

- For PSCell and SCells, the network provides the required SI by dedicated signalling, i.e. within an *RRCReconfiguration* message. Nevertheless, the UE shall acquire *MIB* of the PSCell to get SFN timing of the SCG (which may be different from MCG). Upon change of relevant SI for SCell, the network releases and adds the concerned SCell. For PSCell, the required SI can only be changed with Reconfiguration with Sync.

NOTE 2: The physical layer imposes a limit to the maximum size a SIB can take. The maximum *SIB1* or *SI message* size is 2976 bits.

### 5.2.2 System information acquisition

#### 5.2.2.1 General UE requirements

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

U: UE;
N: Network;

|||;
U<-N:MIB [au];
U<N:SIB1 [au];
U>N:SystemInformationRequest [au];
U<N:SystemInformation messages [au];
U<N;
|||;
~~~

Figure 5.2.2.1-1: System information acquisition

The UE applies the SI acquisition procedure to acquire the AS, NAS- and positioning assistance data information. The procedure applies to UEs in RRC_IDLE, in RRC_INACTIVE and in RRC_CONNECTED.

The UE in RRC_IDLE and RRC_INACTIVE shall ensure having a valid version of (at least) the *MIB*, *SIB1* through *SIB4,* *SIB5* (if the UE supports E-UTRA), *SIB11* (if the UE is configured for idle/inactive measurements), *SIB12* (if UE is capable of NR sidelink communication/discovery and is configured by upper layers to receive or transmit NR sidelink communication/discovery), and *SIB13*, *SIB14* (if UE is capable of V2X sidelink communication and is configured by upper layers to receive or transmit V2X sidelink communication), *SIB15* (if UE is configured by upper layers to report disaster roaming related information), *SIB16* (if the UE is capable of slice-based cell reselection and the UE receives NSAG information for cell reselection from upper layer), *SIB17* (if the UE is using TRS resources for power saving in RRC_IDLE and RRC_INACTIVE), *SIB19* (if UE is accessing NR via NTN access) and *SIB22* (for ATG access).

The UE capable of MBS broadcast which is receiving or interested to receive MBS broadcast service(s) via a broadcast MRB shall ensure having a valid version of *SIB20*, regardless of the RRC state the UE is in.

The UE shall ensure having a valid version of the posSIB requested by upper layers.

#### 5.2.2.2 SIB validity and need to (re)-acquire SIB

##### 5.2.2.2.1 SIB validity

The UE shall apply the SI acquisition procedure as defined in clause 5.2.2.3 upon cell selection (e.g. upon power on), cell-reselection, return from out of coverage, after reconfiguration with sync completion, after entering the network from another RAT, upon receiving an indication that the system information has changed, upon receiving a PWS notification, upon receiving request (e.g., a positioning request) from upper layers; and whenever the UE does not have a valid version of a stored SIB or posSIB or a valid version of a requested SIB.

When the UE acquires a *MIB* or a *SIB1* or an SI message in a serving cell as described in clause 5.2.2.3, and if the UE stores the acquired SIB, then the UE shall store the associated *areaScope*, if present, the first *PLMN-Identity* in the *PLMN-IdentityInfoList* for non-NPN-only cells or the first NPN identity (SNPN identity in case of SNPN, or PNI-NPN identity in case of PNI-NPN) in the *NPN-IdentityInfoList* for NPN-only cells, the *cellIdentity*, the *systemInformationAreaID*, if present, and the *valueTag*, if present, as indicated in the *si-SchedulingInfo* for the SIB. If the UE stores the acquired posSIB, then the UE shall store the associated *areaScope*, if present, the *cellIdentity*, the *systemInformationAreaID*, if present, the *valueTag*, if provided in *assistanceDataSIB-Element*, and the *expirationTime* if provided in *assistanceDataSIB-Element*. The UE may use a valid stored version of the SI except *MIB*, *SIB1*, *SIB6*, *SIB7* or *SIB8* e.g. after cell re-selection, upon return from out of coverage or after the reception of SI change indication. The *valueTag* and *expirationTime* for posSIB is optionally provided in *assistanceDataSIB-Element*, as specified in TS 37.355 \[49\].

A L2 U2N Remote UE in RRC_IDLE or RRC_INACTIVE can inform the interested SIB(s) to the connected L2 U2N Relay UE as defined in clause 5.8.9.8.2 and receive the SIB(s) from the L2 U2N Relay UE as defined in clause 5.8.9.9.3. A L2 U2N Remote UE in RRC_CONNECTED receives SIB1 and other SIB(s) in *RRCReconfiguration* message and performs on-demand SI request if required, as defined in clause 5.2.2.3.5 and 5.2.2.3.6. The L2 U2N Remote UE in RRC_IDLE or RRC_INACTIVE or RRC_CONNECTED is not required to obtain SI over Uu interface, but it may decide to perform the SI acquisition procedure over Uu interface as defined in clause 5.2.2.3 by UE implementation.

NOTE: The storage and management of the stored SIBs in addition to the SIBs valid for the current serving cell is left to UE implementation.

The UE shall:

1\> delete any stored version of a SIB after 3 hours from the moment it was successfully confirmed as valid;

1\> for each stored version of a SIB:

2\> if the *areaScope* is associated and its value for the stored version of the SIB is the same as the value received in the *si-SchedulingInfo* for that SIB from the serving cell:

3\> if the UE is NPN capable and the cell is an NPN-only cell:

4\> if the first NPN identity included in the *NPN-IdentityInfoList*, the *systemInformationAreaID* and the v*alueTag* that are included in the *si-SchedulingInfo* for the SIB received from the serving cell are identical to the NPN identity, the *systemInformationAreaID* and the *valueTag* associated with the stored version of that SIB:

5\> consider the stored SIB as valid for the cell;

3\> else if the first *PLMN-Identity* included in the *PLMN-IdentityInfoList*, the *systemInformationAreaID* and the v*alueTag* that are included in the *si-SchedulingInfo* for the SIB received from the serving cell are identical to the *PLMN-Identity*, the *systemInformationAreaID* and the *valueTag* associated with the stored version of that SIB:

4\> consider the stored SIB as valid for the cell;

2\> if the *areaScope* is not present for the stored version of the SIB and the *areaScope* value is not included in the *si-SchedulingInfo* for that SIB from the serving cell:

3\> if the UE is NPN capable and the cell is an NPN-only cell:

4\> if the first NPN identity in the *NPN-IdentityInfoList,* the *cellIdentity* and *valueTag* that are included in the *si-SchedulingInfo* for the SIB received from the serving cell are identical to the NPN identity*,* the *cellIdentity* and the *valueTag* associated with the stored version of that SIB:

5\> consider the stored SIB as valid for the cell;

3\> else if the first *PLMN-Identity* in the *PLMN-IdentityInfoList,* the *cellIdentity* and *valueTag* that are included in the *si-SchedulingInfo* for the SIB received from the serving cell are identical to the *PLMN-Identity,* the *cellIdentity* and the *valueTag* associated with the stored version of that SIB:

4\> consider the stored SIB as valid for the cell;

1\> for each stored version of a posSIB:

2\> if the *areaScope* is associated and its value for the stored version of the posSIB is the same as the value received in the *posSIB-MappingInfo* for that posSIB from the serving cell and the *systemInformationAreaID* included in the *si-SchedulingInfo* is identical to the *systemInformationAreaID* associated with the stored version of that posSIB:

3\> if the *valueTag* (see TS 37.355 \[49\]) for the posSIB received from the serving cell is identical to the *valueTag* associated with the stored version of that posSIB; or if the *expirationTime* (see TS 37.355 \[49\]) associated with the stored posSIB has not been expired:

4\> consider the stored posSIB as valid for the cell;

2\> if the *areaScope* is not present for the stored version of the posSIB and the *areaScope* value is not included in the *posSIB-MappingInfo* for that posSIB from the serving cell and the *cellIdentity* for the posSIB received from the serving cell is identical to the *cellIdentity* associated with the stored version of that posSIB:

3\> if the *valueTag* (see TS 37.355 \[49\]) for the posSIB received from the serving cell is identical to the *valueTag* associated with the stored version of that posSIB; or if the *expirationTime* (see TS 37.355 \[49\]) associated with the stored posSIB has not been expired:

4\> consider the stored posSIB as valid for the cell;

##### 5.2.2.2.2 SI change indication and PWS notification

A modification period is used, i.e. updated SI message (other than SI message for ETWS, CMAS, positioning assistance data, and some NTN-specific information as specified in the field descriptions ) is broadcasted in the modification period following the one where SI change indication is transmitted. The modification period boundaries are defined by SFN values for which SFN mod m = 0, where m is the number of radio frames comprising the modification period. The modification period is configured by system information. If H-SFN is provided in *SIB1*, and UE is configured with eDRX, modification period boundaries are defined by SFN values for which (H-SFN \* 1024 + SFN) mod *m* = 0.

For UEs in RRC_IDLE or RRC_INACTIVE configured to use an IDLE eDRX cycle longer than the modification period, an eDRX acquisition period is defined. The boundaries of the eDRX acquisition period are determined by H-SFN values for which H-SFN mod 1024 = 0.

The UE receives indications about SI modifications and/or PWS notifications using Short Message transmitted with P-RNTI over DCI (see clause 6.5). Repetitions of SI change indication may occur within preceding modification period or within preceding eDRX acquisition period. SI change indication is not applicable for SI messages containing posSIBs.

UEs in RRC_IDLE or in RRC_INACTIVE while SDT procedure is not ongoing shall monitor for SI change indication in its own paging occasion(s) that the UE monitors as specified in TS 38.304 \[20\]. UEs in RRC_CONNECTED shall monitor for SI change indication in any paging occasion at least once per modification period if the UE is provided with common search space, including *pagingSearchSpace*, *searchSpaceSIB1* and *searchSpaceOtherSystemInformation*, on the active BWP to monitor paging, as specified in TS 38.213 \[13\], clause 13.

UEs in RRC_INACTIVE while SDT procedure is ongoing shall monitor for SI change indication in any paging occasion at least once per modification period, if the initial downlink BWP on which the SDT procedure is ongoing is associated with a CD-SSB.

During a modification period where ETWS or CMAS transmission is started or stopped, the SI messages carrying the posSIBs scheduled in *posSchedulingInfoList* may change, so the UE might not be able to successfully receive those posSIBs in the remainder of the current modification period and next modification period according to the scheduling information received prior to the change.

ETWS or CMAS capable UEs in RRC_IDLE or in RRC_INACTIVE while SDT procedure is not ongoing shall monitor for indications about PWS notification in its own paging occasion(s) that the UE monitors as specified in TS 38.304 \[20\]. ETWS or CMAS capable UEs in RRC_CONNECTED shall monitor for indication about PWS notification in any paging occasion at least once every *defaultPagingCycle* if the UE is provided with common search space, including *pagingSearchSpace*, *searchSpaceSIB1* and *searchSpaceOtherSystemInformation,* on the active BWP to monitor paging.

ETWS or CMAS capable UEs in RRC_INACTIVE while SDT procedure is ongoing shall monitor for indication about PWS notification in any paging occasion at least once every *defaultPagingCycle*, if the initial downlink BWP on which the SDT procedure is ongoing is associated with a CD-SSB*.*

For Short Message reception in a paging occasion, the UE monitors the PDCCH monitoring occasion(s) for paging as specified in TS 38.304 \[20\] and TS 38.213 \[13\].

A L2 U2N Remote UE is not required to monitor paging occasion for SI modifications and/or PWS notifications. It obtains the updated system information and SIB6/7/8 from the connected L2 U2N Relay UE as defined in clause 5.8.9.9.3.

If the UE receives a Short Message, the UE shall:

1\> if the UE is ETWS capable or CMAS capable, the *etwsAndCmasIndication* bit of Short Message is set, and the UE is provided with *searchSpaceSIB1* and *searchSpaceOtherSystemInformation* on the active BWP or the initial BWP:

2\> immediately re-acquire the *SIB1*;

2\> if the UE is ETWS capable and *si-SchedulingInfo* includes scheduling information for *SIB6*:

3\> acquire *SIB6*, as specified in clause 5.2.2.3.2, immediately;

2\> if the UE is ETWS capable and *si-SchedulingInfo* includes scheduling information for *SIB7*:

3\> acquire *SIB7*, as specified in clause 5.2.2.3.2, immediately;

2\> if the UE is CMAS capable and *si-SchedulingInfo* includes scheduling information for *SIB8*:

3\> acquire *SIB8*, as specified in clause 5.2.2.3.2, immediately;

NOTE: In case *SIB6*, *SIB7*, or *SIB8* overlap with a measurement gap it is left to UE implementation how to immediately acquire *SIB6*, *SIB7*, or *SIB8*.

1\> if the UE does not operate an IDLE eDRX cycle longer than the modification period and the *systemInfoModification* bit of Short Message is set:

2\> apply the SI acquisition procedure as defined in clause 5.2.2.3 from the start of the next modification period;

1\> if the UE operates an IDLE eDRX cycle longer than the modification period and the *systemInfoModification-eDRX* bit of Short Message is set:

2\> apply the SI acquisition procedure as defined in clause 5.2.2.3 from the start of the next eDRX acquisition period boundary.

#### 5.2.2.3 Acquisition of System Information

##### 5.2.2.3.1 Acquisition of *MIB* and *SIB1*

The UE shall:

1\> apply the specified BCCH configuration defined in 9.1.1.1;

1\> if the UE is in RRC_IDLE or in RRC_INACTIVE; or

1\> if the UE is in RRC_CONNECTED while T311 is running:

2\> acquire the *MIB,* which is scheduled as specified in TS 38.213 \[13\];

2\> if the UE is unable to acquire the *MIB*;

3\> perform the actions as specified in clause 5.2.2.5;

2\> else:

3\> perform the actions specified in clause 5.2.2.4.1.

1\> if the UE is in RRC_CONNECTED with an active BWP with common search space configured by *searchSpaceSIB1* and *pagingSearchSpace* and has received an indication about change of system information; or

1\> if the UE is in RRC_CONNECTED with an active BWP with common search space configured by *searchSpaceSIB1* and the UE has not stored a valid version of a SIB or posSIB, in accordance with clause 5.2.2.2.1, of one or several required SIB(s) or posSIB(s) in accordance with clause 5.2.2.1, and, UE has not acquired SIB1 in current modification period; or

1\> if the UE is in RRC_CONNECTED with an active BWP with common search space configured by *searchSpaceSIB1*, and, the UE has not stored a valid version of a SIB or posSIB, in accordance with clause 5.2.2.2.1, of one or several required SIB(s) or posSIB(s) in accordance with clause 5.2.2.1, and, *si-BroadcastStatus* for the required SIB(s) or *posSI-BroadcastStatus* for the required posSIB(s) is set to *notBroadcasting* in acquired *SIB1* in current modification period; or

1\> if the UE is in RRC_IDLE or in RRC_INACTIVE; or

1\> if the UE is in RRC_CONNECTED while T311 is running:

2\> if *ssb-SubcarrierOffset* indicates *SIB1* is transmitted in the cell (TS 38.213 \[13\]) and if *SIB1* acquisition is required for the UE:

3\> acquire the *SIB1,* which is scheduled as specified in TS 38.213 \[13\];

3\> if the UE is unable to acquire the *SIB1*:

4\> perform the actions as specified in clause 5.2.2.5;

3\> else:

4\> upon acquiring *SIB1*, perform the actions specified in clause 5.2.2.4.2.

2\> else if *SIB1* acquisition is required for the UE and *ssb-SubcarrierOffset* indicates that *SIB1* is not scheduled in the cell:

3\> perform the actions as specified in clause 5.2.2.5.

NOTE 1: The UE in RRC_CONNECTED is only required to acquire broadcasted *SIB1* and MBS broadcast if the UE can acquire it without disrupting unicast or MBS multicast data reception, i.e., the broadcast and unicast/MBS multicast beams are quasi co-located. The UE in RRC_INACTIVE state while SDT procedure is ongoing, is only required to acquire broadcasted *SIB1* and *MIB* if the UE can acquire them without disrupting unicast data reception, i.e. the broadcast and unicast beams are quasi co-located.

NOTE 2: UE in RRC_INACTIVE that does not support *inactiveStateNTN-r17* enters RRC_IDLE upon cell reselection between TN cell and NTN cell, and initiates the NAS signalling connection recovery (see TS 24.501 \[23\]).

##### 5.2.2.3.2 Acquisition of an SI message

For SI message acquisition PDCCH monitoring occasion(s) are determined according to *searchSpaceOtherSystemInformation*. If *searchSpaceOtherSystemInformation* is set to zero, PDCCH monitoring occasions for SI message reception in SI-window are same as PDCCH monitoring occasions for *SIB1* where the mapping between PDCCH monitoring occasions and SSBs is specified in TS 38.213\[13\]. If *searchSpaceOtherSystemInformation* is not set to zero, PDCCH monitoring occasions for SI message are determined based on search space indicated by *searchSpaceOtherSystemInformation*. PDCCH monitoring occasions for SI message which are not overlapping with UL symbols (determined according to *tdd-UL-DL-ConfigurationCommon*) are sequentially numbered from one in the SI window. The \[x×N+K\]^th^ PDCCH monitoring occasion (s) for SI message in SI-window corresponds to the K^th^ transmitted SSB, where x = 0, 1, \...X-1, K = 1, 2, ...N, N is the number of actual transmitted SSBs determined according to *ssb-PositionsInBurst* in *SIB1* and X is equal to CEIL(number of PDCCH monitoring occasions in SI-window/N). The actual transmitted SSBs are sequentially numbered from one in ascending order of their SSB indexes. The UE assumes that, in the SI window, PDCCH for an SI message is transmitted in at least one PDCCH monitoring occasion corresponding to each transmitted SSB and thus the selection of SSB for the reception SI messages is up to UE implementation.

When acquiring an SI message, the UE shall:

1\> determine the start of the SI-window for the concerned SI message as follows:

2\> if the concerned SI message is configured in the *schedulingInfoList*:

3\> for the concerned SI message, determine the number *n* which corresponds to the order of entry in the list of SI messages configured by *schedulingInfoList* in *si-SchedulingInfo* in *SIB1*;

3\> determine the integer value *x = (n -- 1) × w*, where *w* is the *si-WindowLength*;

3\> the SI-window starts at the slot \#*a*, where *a* = *x* mod N, in the radio frame for which SFN mod *T* = FLOOR(*x*/N), where *T* is the *si-Periodicity* of the concerned SI message and N is the number of slots in a radio frame as specified in TS 38.213 \[13\];

2\> else if the concerned SI message is configured in the *schedulingInfoList2*;

3\> determine the integer value *x = (si-WindowPosition -1) × w*, where *w* is the *si-WindowLength*;

3\> the SI-window starts at the slot \#*a*, where *a* = *x* mod N, in the radio frame for which SFN mod *T* = FLOOR(*x*/N), where *T* is the *si-Periodicity* of the concerned SI message and N is the number of slots in a radio frame as specified in TS 38.213 \[13\];

2\> else if the concerned SI message is configured in the *posSchedulingInfoList* and *offsetToSI-Used* is not configured:

3\> create a concatenated list of SI messages by appending the *posSchedulingInfoList* in *posSI-SchedulingInfo* in *SIB1* to *schedulingInfoList* in *si-SchedulingInfo* in *SIB1*;

3\> for the concerned SI message, determine the number *n* which corresponds to the order of entry in the concatenated list;

3\> determine the integer value *x = (n -- 1) × w*, where *w* is the *si-WindowLength*;

3\> the SI-window starts at the slot \#*a*, where *a* = *x* mod N, in the radio frame for which SFN mod *T* = FLOOR(*x*/N), where *T* is the *posSI-Periodicity* of the concerned SI message and N is the number of slots in a radio frame as specified in TS 38.213 \[13\];

2\> else if the concerned SI message is configured by the *posSchedulingInfoList* and *offsetToSI-Used* is configured:

3\> determine the number *m* which corresponds to the number of SI messages with an associated *si-Periodicity* of 8 radio frames (80 ms), configured by *schedulingInfoList* in *SIB1*;

3\> for the concerned SI message, determine the number *n* which corresponds to the order of entry in the list of SI messages configured by *posSchedulingInfoList* in *SIB1*;

3\> determine the integer value *x* = *m* *× w +* (*n* -- 1*)* *× w*, where *w* is the *si-WindowLength;*

3\> the SI-window starts at the slot \#*a*, where *a* = *x* mod N, in the radio frame for which SFN mod *T* = FLOOR(*x*/N) +8, where *T* is the *posSI-Periodicity* of the concerned SI message and N is the number of slots in a radio frame as specified in TS 38.213 \[13\];

1\> receive the PDCCH containing the scheduling RNTI, i.e. SI-RNTI in the PDCCH monitoring occasion(s) for SI message acquisition, from the start of the SI-window and continue until the end of the SI-window whose absolute length in time is given by *si-WindowLength*, or until the SI message was received;

1\> if the SI message was not received by the end of the SI-window, repeat reception at the next SI-window occasion for the concerned SI message in the current modification period;

1\> if all the SIB(s) and/or posSIB(s) requested in *DedicatedSIBRequest* message have been acquired:

2\> stop timer T350, if running;

NOTE 1: The UE is only required to acquire broadcasted SI message if the UE can acquire it without disrupting unicast or MBS multicast data reception, i.e. the broadcast and unicast/MBS multicast beams are quasi co-located.

NOTE 2: The UE is not required to monitor PDCCH monitoring occasion(s) corresponding to each transmitted SSB in SI-window.

NOTE 3: If the concerned SI message was not received in the current modification period, handling of SI message acquisition is left to UE implementation.

NOTE 4: A UE in RRC_CONNECTED may stop the PDCCH monitoring during the SI window for the concerned SI message when the requested SIB(s) are acquired.

NOTE 5: A UE capable of NR sidelink communication/discovery and configured by upper layers to perform NR sidelink communication/discovery on a frequency, may acquire *SIB12* or *SystemInformationBlockType28* from a cell other than current serving cell (for RRC_INACTIVE or RRC_IDLE) or current PCell (for RRC_CONNECTED), if *SIB12* of current serving cell (for RRC_INACTIVE or RRC_IDLE) or current PCell (for RRC_CONNECTED) does not provide configuration for NR sidelink communication/discovery for the frequency, and if the other cell providing configuration for NR sidelink communication/discovery for the frequency meets the S-criteria as defined in TS 38.304 \[20\] or TS 36.304 \[27\].

1\> perform the actions for the acquired SI message as specified in clause 5.2.2.4.

##### 5.2.2.3.3 Request for on demand system information
 
The UE shall, while SDT procedure is not ongoing:

1\> if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfigSUL-MSG1-Repetition* and criteria to select supplementary uplink as defined in TS 38.321\[3\], clause 5.1.1 is met and if criteria to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *si-RequestConfigSUL-MSG1-Repetition* is met:

2\> trigger the lower layer to initiate the Random Access procedure on supplementary uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) associated with the applicable MSG1 repetition number in *si-RequestConfigSUL-MSG1-Repetition* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else if the UE is a RedCap UE and if *initialUplinkBWP-RedCap* is configured in *UplinkConfigCommonSIB* and if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfigRedCap-MSG1-Repetition* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met and if criteria to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *si-RequestConfigRedCap-MSG1-Repetition* is met:

2\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) associated with the applicable MSG1 repetition number in *si-RequestConfigRedCap-MSG1-Repetition* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfigSUL* and criteria to select supplementary uplink as defined in TS 38.321\[3\], clause 5.1.1 is met:

2\> trigger the lower layer to initiate the Random Access procedure on supplementary uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) in *si-RequestConfigSUL* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else if the UE is an (e)RedCap UE and if *initialUplinkBWP-RedCap* is configured in *UplinkConfigCommonSIB* and if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfigRedCap* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met:

2\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) in *si-RequestConfigRedcap* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else:

2\> if the UE is not a RedCap UE and if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfigMSG1-Repetition* and criteria to select normal uplink and to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *si-RequestConfigMSG1-Repetition* are met; or

2\> if the UE is a RedCap UE and if *initialUplinkBWP-RedCap* is not configured in *UplinkConfigCommonSIB* and if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfigMSG1-Repetition* and criteria to select normal uplink and to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *si-RequestConfigMSG1-Repetition* are met:

3\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) associated with the applicable MSG1 repetition number in corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

3\> if acknowledgement for SI request is received from lower layers:

4\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

2\> else if the UE is neither a RedCap nor an eRedCap UE and if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfig* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met; or

2\> if the UE is an (e)RedCap UE and if *initialUplinkBWP-RedCap* is not configured in *UplinkConfigCommonSIB* and if *SIB1* includes *si-SchedulingInfo* containing *si-RequestConfig* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met:

3\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) in *si-RequestConfig* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

3\> if acknowledgement for SI request is received from lower layers:

4\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

2\> else:

3\> apply the default L1 parameter values as specified in corresponding physical layer specifications except for the parameters for which values are provided in *SIB1*;

3\> apply the default MAC Cell Group configuration as specified in 9.2.2;

3\> apply the *timeAlignmentTimerCommon* included in *SIB1*;

3\> apply the CCCH configuration as specified in 9.1.1.2;

3\> initiate transmission of the *RRCSystemInfoRequest* message with *rrcSystemInfoRequest* in accordance with 5.2.2.3.4;

3\> if acknowledgement for *RRCSystemInfoRequest* message with *rrcSystemInfoRequest* is received from lower layers:

4\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> if cell reselection occurs while waiting for the acknowledgment for SI request from lower layers:

2\> reset MAC;

2\> if SI request is based on *RRCSystemInfoRequest* message with *rrcSystemInfoRequest*:

3\> release RLC entity for SRB0.

NOTE: After RACH failure for SI request it is up to UE implementation when to retry the SI request.

##### 5.2.2.3.3a Request for on demand positioning system information

The UE shall, while SDT procedure is not ongoing:

1\> if *SIB1* includes *si-SchedulingInfo* containing *posSI-RequestConfigSUL-MSG1-Repetition* and criteria to select supplementary uplink as defined in TS 38.321\[3\], clause 5.1.1 is met and if criteria to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *posSI-RequestConfigSUL-MSG1-Repetition* is met:

2\> trigger the lower layer to initiate the Random Access procedure on supplementary uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) associated with the applicable MSG1 repetition number in *posSI-RequestConfigSUL-MSG1-Repetition* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else if the UE is a RedCap UE and if *initialUplinkBWP-RedCap* is configured in *UplinkConfigCommonSIB* and if *SIB1* includes *si-SchedulingInfo* containing *posSI-RequestConfigRedCap-MSG1-Repetition* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met and if criteria to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *posSI-RequestConfigRedCap-MSG1-Repetition* is met:

2\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) associated with the applicable MSG1 repetition number in *posSI-RequestConfigRedCap-MSG1-Repetition* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else if *SIB1* includes *posSI-SchedulingInfo* containing *posSI-RequestConfigSUL* and criteria to select supplementary uplink as defined in TS 38.321\[3\], clause 5.1.1 is met:

2\> trigger the lower layer to initiate the Random Access procedure on supplementary uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) in *posSI-RequestConfigSUL* corresponding to the SI message(s) that the UE upper layers require for positioning operations, and for which *posSI-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else if the UE is an (e)RedCap UE and if *initialUplinkBWP-RedCap* is configured in *UplinkConfigCommonSIB* and if *SIB1* includes *posSI-SchedulingInfo* containing *posSI-RequestConfigRedCap* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met:

2\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) in *posSI-RequestConfigRedCap* corresponding to the SI message(s) that the UE upper layers require for positioning operations, and for which *posSI-BroadcastStatus* is set to *notBroadcasting*;

2\> if acknowledgement for SI request is received from lower layers:

3\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> else:

2\> if the UE is not a RedCap UE and if *SIB1* includes *si-SchedulingInfo* containing *posSI-RequestConfigMSG1-Repetition* and criteria to select normal uplink and to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *posSI-RequestConfigMSG1-Repetition* are met; or

2\> if the UE is a RedCap UE and if *initialUplinkBWP-RedCap* is not configured in *UplinkConfigCommonSIB* and if *SIB1* includes *si-SchedulingInfo* containing *posSI-RequestConfigMSG1-Repetition* and criteria to select normal uplink and to apply MSG1 repetition as defined in TS 38.321\[3\], clause 5.1.1e for the concerned *posSI-RequestConfigMSG1-Repetition* are met:

3\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) associated with the applicable MSG1 repetition number in *posSI-RequestConfigMSG1-Repetition* corresponding to the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

3\> if acknowledgement for SI request is received from lower layers:

4\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

2\> else if the UE is not an (e)RedCap UE and if *SIB1* includes *posSI-SchedulingInfo* containing *posSI-RequestConfig* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met; or

2\> if the UE is an (e)RedCap UE and if *initialUplinkBWP-RedCap* is not configured in *UplinkConfigCommonSIB* and if *SIB1* includes *posSI-SchedulingInfo* containing *posSI-RequestConfig* and criteria to select normal uplink as defined in TS 38.321\[3\], clause 5.1.1 is met:

3\> trigger the lower layer to initiate the Random Access procedure on normal uplink in accordance with TS 38.321 \[3\] using the PRACH preamble(s) and PRACH resource(s) in *posSI-RequestConfig* corresponding to the SI message(s) that the UE upper layers require for positioning operations , and for which *posSI-BroadcastStatus* is set to *notBroadcasting*;

3\> if acknowledgement for SI request is received from lower layers:

4\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

2\> else:

3\> apply the default L1 parameter values as specified in corresponding physical layer specifications except for the parameters for which values are provided in *SIB1*;

3\> apply the default MAC Cell Group configuration as specified in 9.2.2;

3\> apply the *timeAlignmentTimerCommon* included in *SIB1*;

3\> apply the CCCH configuration as specified in 9.1.1.2;

3\> initiate transmission of the *RRCSystemInfoRequest* message with *rrcPosSystemInfoRequest* in accordance with 5.2.2.3.4;

3\> if acknowledgement for *RRCSystemInfoRequest* message with *rrcPosSystemInfoRequest* is received from lower layers:

4\> acquire the requested SI message(s) as defined in clause 5.2.2.3.2, immediately;

1\> if cell reselection occurs while waiting for the acknowledgment for SI request from lower layers:

2\> reset MAC;

2\> if SI request is based on *RRCSystemInfoRequest* message with *rrcPosSystemInfoRequest*:

3\> release RLC entity for SRB0.

NOTE: After RACH failure for SI request it is up to UE implementation when to retry the SI request.

##### 5.2.2.3.4 Actions related to transmission of *RRCSystemInfoRequest* message

The UE shall set the contents of *RRCSystemInfoRequest* message as follows:

1\> if the procedure is triggered to request the required SI message(s) other than positioning:

2\> set the *requested-SI-List* to indicate the SI message(s) that the UE requires to operate within the cell, and for which *si-BroadcastStatus* is set to *notBroadcasting*;

1\> else if the procedure is triggered to request the required SI message(s) for positioning:

2\> set the *requestedPosSI-List* to indicate the SI message(s) that the UE upper layers require for positioning operations, and for which *posSI-BroadcastStatus* is set to *notBroadcasting*.

The UE shall submit the *RRCSystemInfoRequest* message to lower layers for transmission.

##### 5.2.2.3.5 Acquisition of SIB(s) or posSIB(s) in RRC_CONNECTED

The UE shall:

1\> if the UE is in RRC_CONNECTED with an active BWP not configured with common search space with the field *searchSpaceOtherSystemInformation* and the UE has not stored a valid version of a SIB or posSIB, in accordance with clause 5.2.2.2.1, of one or several required SIB(s) or posSIB(s) in accordance with clause 5.2.2.1, or

1\> if the UE is in RRC_CONNECTED and acting as a L2 U2N Remote UE and the UE has not stored a valid version of a SIB, in accordance with clause 5.2.2.2.1, of one or several required SIB(s) in accordance with clause 5.2.2.1:

2\> for the SI message(s) that, according to the *si-SchedulingInfo* or *posSI-SchedulingInfo* in the stored SIB1, contain at least one required SIB or requested posSIB:

3\> if *onDemandSIB-Request* is configured and timer T350 is not running:

4\> initiate transmission of the *DedicatedSIBRequest* message in accordance with 5.2.2.3.6;

4\> start timer T350 with the timer value set to the *onDemandSIB-RequestProhibitTimer*;

1\> else if the UE is in RRC_CONNECTED with an active BWP configured with common search space with the field *searchSpaceOtherSystemInformation* and the UE has not stored a valid version of a SIB or posSIB, in accordance with clause 5.2.2.2.1, of one or several required SIB(s) or posSIB(s) in accordance with clause 5.2.2.1:

2\> for the SI message(s) that, according to the *si-SchedulingInfo* in the stored SIB1, contain at least one required SIB and for which *si-BroadcastStatus* is set to *broadcasting*:

3\> acquire the SI message(s) as defined in clause 5.2.2.3.2;

2\> for the SI message(s) that, according to the *si-SchedulingInfo* in the stored SIB1, contain at least one required SIB and for which *si-BroadcastStatus* is set to *notBroadcasting*:

3\> if *onDemandSIB-Request* is configured and timer T350 is not running:

4\> initiate transmission of the *DedicatedSIBRequest* message in accordance with 5.2.2.3.6;

4\> start timer T350 with the timer value set to the *onDemandSIB-RequestProhibitTimer*;

4\> acquire the requested SI message(s) corresponding to the requested SIB(s) as defined in clause 5.2.2.3.2.

2\> for the SI message(s) that, according to the *posSI-SchedulingInfo* in the stored SIB1, contain at least one requested posSIB and for which *posSI-BroadcastStatus* is set to *broadcasting*:

3\> acquire the SI message(s) as defined in clause 5.2.2.3.2;

2\> for the SI message(s) that, according to the *posSI-SchedulingInfo* in the stored SIB1, contain at least one requested posSIB and for which *posSI-BroadcastStatus* is set to *notBroadcasting*:

3\> if *onDemandSIB-Request* is configured and timer T350 is not running:

4\> initiate transmission of the *DedicatedSIBRequest* message in accordance with 5.2.2.3.6;

4\> start timer T350 with the timer value set to the *onDemandSIB-RequestProhibitTimer*;

4\> acquire the requested SI message(s) corresponding to the requested posSIB(s) as defined in clause 5.2.2.3.2.

NOTE: UE may include on demand request for SIB and/or posSIB(s) in the same *DedicatedSIBRequest* message.

##### 5.2.2.3.6 Actions related to transmission of *DedicatedSIBRequest* message

The UE shall set the contents of *DedicatedSIBRequest* message as follows:

1\> if the procedure is triggered to request the required SIB(s):

2\> include *requestedSIB-List* in the *onDemandSIB-RequestList* to indicate the requested SIB(s);

1\> if the procedure is triggered to request the required posSIB(s):

2\> include *requestedPosSIB-List* in the *onDemandSIB-RequestList* to indicate the requested posSIB(s).

The UE shall submit the *DedicatedSIBRequest* message to lower layers for transmission.

#### 5.2.2.4 Actions upon receipt of System Information

##### 5.2.2.4.1 Actions upon reception of the *MIB*

Upon receiving the *MIB* the UE shall:

1\> store the acquired *MIB*;

1\> if the UE is in RRC_IDLE or in RRC_INACTIVE, or if the UE is in RRC_CONNECTED while *T311* is running:

2\> if the access is not for NTN or the UE is not capable of NTN or the UE is not capable of NES cell DTX/DRX; and

2\> if the access is not for ATG or the UE is not capable of ATG; and

2\> if the *cellBarred* in the acquired *MIB* is set to *barred*:

3\> if the UE is an (e)RedCap UE and *ssb-SubcarrierOffset* indicates *SIB1* is transmitted in the cell (TS 38.213 \[13\]):

4\> acquire the *SIB1,* which is scheduled as specified in TS 38.213 \[13\];

3\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> perform cell re-selection to other cells on the same frequency as the barred cell as specified in TS 38.304 \[20\];

2\> else:

3\> apply the received *systemFrameNumber*, *pdcch-ConfigSIB1*, *subCarrierSpacingCommon*, *ssb-SubcarrierOffset* and *dmrs-TypeA-Position*.

NOTE 1: A UE capable of NTN access should acquire SIB1 to determine whether the cell is an NTN cell.

NOTE 2: A UE capable of ATG access should acquire SIB1 to determine whether the cell is an ATG cell.

NOTE 3: A UE capable of NES cell DTX/DRX should acquire SIB1 to determine the cell barring status when the *cellBarred* in MIB is set to *barred*.

##### 5.2.2.4.2 Actions upon reception of the *SIB1*

Upon receiving the *SIB1* the UE shall:

1\> store the acquired *SIB1*;

> 1\> if the access is for NTN:

2\> if the UE is in RRC_IDLE or in RRC_INACTIVE, or if the UE is in RRC_CONNECTED while *T311* is running; and

2\> if the *cellBarredNTN* in the acquired *SIB1* is set to *barred* or the *cellBarredNTN* is not included in the acquired *SIB1*:

3\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> perform cell re-selection to other cells on the same frequency as the barred cell as specified in TS 38.304 \[20\], upon which the procedure ends;

1\> if the access is for ATG:

2\> if the UE is in RRC_IDLE or in RRC_INACTIVE, or if the UE is in RRC_CONNECTED while *T311* is running; and

2\> if the *cellBarredNTN* in the acquired *SIB1* is set to *barred* or the *cellBarredNTN* is not included in the acquired *SIB1*:

3\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> perform cell re-selection to other cells on the same frequency as the barred cell as specified in TS 38.304 \[20\];

1\> if the UE is a RedCap UE and it is in RRC_IDLE or in RRC_INACTIVE, or if the RedCap UE is in RRC_CONNECTED while *T311* is running:

2\> if *intraFreqReselectionRedCap* is not present in *SIB1*:

3\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> perform barring as if *intraFreqReselectionRedCap* is set to allowed, upon which the procedure ends;

2\> else:

3\> if the *cellBarredRedCap1Rx* is present in the acquired *SIB1* and is set to *barred* and the UE is equipped with 1 Rx branch; or

3\> if the *cellBarredRedCap2Rx* is present in the acquired *SIB1* and is set to *barred* and the UE is equipped with 2 Rx branches; or

3\> if the *halfDuplexRedCapAllowed* is not present in the acquired *SIB1* and the UE supports only half-duplex FDD operation:

4\> consider the cell as barred in accordance with TS 38.304 \[20\];

4\> perform barring based on *intraFreqReselectionRedCap* as specified in TS 38.304 \[20\], upon which the procedure ends;

1\> if the UE supports NES cell DTX/DRX and it is in RRC_IDLE or in RRC_INACTIVE, or if the UE supporting NES cell DTX/DRX is in RRC_CONNECTED while *T311* is running:

2\> if *cellBarred* in the acquired *MIB* is set to *barred*:

3\> if *cellBarredNES* is absent in the acquired *SIB1:*

4\> consider the cell as barred in accordance with TS 38.304 \[20\];

4\> perform cell re-selection to other cells on the same frequency as the barred cell as specified in TS 38.304 \[20\];

1\> if the UE is an eRedCap UE and it is in RRC_IDLE or in RRC_INACTIVE, or if the eRedCap UE is in RRC_CONNECTED while *T311* is running:

2\> if *intraFreqReselection-eRedCap* is not present in *SIB1*:

3\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> perform barring as if *intraFreqReselection-eRedCap* is set to allowed upon which the procedure ends;

2\> else:

3\> if the *cellBarred-eRedCap1Rx* is present in the acquired *SIB1* and is set to *barred* and the UE is equipped with 1 Rx branch; or

3\> if the *cellBarred-eRedCap2Rx* is present in the acquired *SIB1* and is set to *barred* and the UE is equipped with 2 Rx branches; or

3\> if the *halfDuplexRedCapAllowed* is not present in the acquired *SIB1* and the UE supports only half-duplex FDD operation:

4\> consider the cell as barred in accordance with TS 38.304 \[20\];

4\> perform barring based on *intraFreqReselection-eRedCap* as specified in TS 38.304 \[20\] upon which the procedure ends;

1\> if the *cellAccessRelatedInfo* contains an entry of a selected SNPN or PLMN and in case of PLMN the UE is either allowed or instructed to access the PLMN via a cell for which at least one CAG ID is broadcast:

2\> in the remainder of the procedures use *npn-IdentityList, trackingAreaCode,* and *cellIdentity* for the cell as received in the corresponding entry of *npn-IdentityInfoList* containing the selected PLMN or SNPN;

1\> else if the *cellAccessRelatedInfo* contains an entry with the *PLMN-Identity* of the selected PLMN:

2\> in the remainder of the procedures use *plmn-IdentityList*, *trackingAreaCode*, *trackingAreaList,* and *cellIdentity* for the cell as received in the corresponding *PLMN-IdentityInfo* containing the selected PLMN;

1\> if the UE in RRC_INACTIVE is configured for feature(s) that it does not support in current serving cell:

2\> not use the corresponding configuration in current serving cell;

NOTE 0: The requirement above applies only to UE that indicates different support of UE capabilities for TN and NTN.

1\> if in RRC_CONNECTED while T311 is not running:

2\> disregard the *frequencyBandList*, if received, while in RRC_CONNECTED;

2\> forward the *cellIdentity* to upper layers;

2\> forward the *trackingAreaCode* to upper layers, if included;

2\> forward the *trackingAreaList* to upper layers, if included;

2\> forward the received *posSIB-MappingInfo* to upper layers, if included;

2\> apply the configuration included in the *servingCellConfigCommon*;

2\> if the UE has a stored valid version of a SIB or posSIB, in accordance with clause 5.2.2.2.1, that the UE requires to operate within the cell in accordance with clause 5.2.2.1:

3\> use the stored version of the required SIB or posSIB;

2\> else:

3\> acquire the required SIB or posSIB requested by upper layer as defined in clause 5.2.2.3.5;

NOTE 1: Void.

1\> else:

2\> if the UE supports one or more of the frequency bands indicated in the *frequencyBandList or frequencyBandListAerial* for downlink for TDD, or one or more of the frequency bands indicated in the *frequencyBandList* or *frequencyBandListAerial* for uplink for FDD, and they are not downlink only bands, and

2\> if the UE is IAB-MT or supports at least one *additionalSpectrumEmission* in the *nr-NS-PmaxList* or *nr-NS-PmaxListAerial* for a supported band in the downlink for TDD, or a supported band in uplink for FDD, and

2\> if the UE supports an uplink channel bandwidth with a maximum transmission bandwidth configuration (see TS 38.101-1 \[15\], TS 38.101-2 \[39\], and TS 38.101-5 \[75\]) which

- is smaller than or equal to the *carrierBandwidth* (indicated in *uplinkConfigCommon* for the SCS of the initial uplink BWP or, for (e)RedCap UE, of the (e)RedCap-specific initial uplink BWP if configured), and which

- is wider than or equal to the bandwidth of the initial uplink BWP or, for (e)RedCap UE, of the (e)RedCap-specific initial uplink BWP if configured, and

2\> if the UE supports a downlink channel bandwidth with a maximum transmission bandwidth configuration (see TS 38.101-1 \[15\], TS 38.101-2 \[39\], and TS 38.101-5 \[75\]) which

- is smaller than or equal to the *carrierBandwidth* (indicated in *downlinkConfigCommon* for the SCS of the initial downlink BWP or, for (e)RedCap UE, of the (e)RedCap-specific initial downlink BWP if configured), and which

- is wider than or equal to the bandwidth of the initial downlink BWP or, for (e)RedCap UE, of the (e)RedCap-specific initial downlink BWP if configured, and

> 2\> if *frequencyShift7p5khz* is present and the UE supports corresponding 7.5kHz frequency shift on this band; or *frequencyShift7p5khz* is not present, and

2\> if the UE is not a RedCap UE, or if the UE is a RedCap UE and *halfDuplexRedCapAllowed* is present, or if the UE is a RedCap UE and the RedCap UE supports full-duplex FDD operation on this band:

3\> if neither *trackingAreaCode* nor *trackingAreaList* is provided for the selected PLMN nor the registered PLMN nor PLMN of the equivalent PLMN list:

4\> consider the cell as barred in accordance with TS 38.304 \[20\];

4\> perform cell re-selection to other cells on the same frequency as the barred cell as specified in TS 38.304 \[20\];

3\> else if UE is IAB-MT and if *iab-Support* is not provided for the selected PLMN nor the registered PLMN nor PLMN of the equivalent PLMN list nor the selected SNPN nor the registered SNPN nor SNPN of the equivalent SNPN list:

4\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> else if UE is NCR-MT and if *ncr-Support* is not provided:

4\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> else if UE is a mobile IAB-MT and if *mobileIAB-Support* is not provided for the selected PLMN nor the registered PLMN nor PLMN of the equivalent PLMN list nor the selected SNPN nor the registered SNPN nor SNPN of the equivalent SNPN list:

4\> consider the cell as barred in accordance with TS 38.304 \[20\];

*Editor\'s Note: FFS whether a cell can be barred for a mobile IAB-MT.*

3\> else:

4\> apply a supported uplink channel bandwidth with a maximum transmission bandwidth which

- is contained within the *carrierBandwidth* indicated in *uplinkConfigCommon* for the SCS of the initial uplink BWP or, for (e)RedCap UEs, (e)RedCap-specific initial uplink BWP, if configured, and which

- is wider than or equal to the bandwidth of the initial BWP for the uplink or, for a (e)RedCap UE, of the (e)RedCap-specific initial uplink BWP if configured;

4\> apply a supported downlink channel bandwidth with a maximum transmission bandwidth which

- is contained within the *carrierBandwidth* indicated in *downlinkConfigCommon* for the SCS of the initial downlink BWP or, for (e)RedCap UEs, (e)RedCap-specific initial downlink BWP, if configured, and which

- is wider than or equal to the bandwidth of the initial BWP for the downlink or, for a (e)RedCap UE, of the (e)RedCap-specific initial downlink BWP if configured;

4\> if the UE is aerial UE and it supports at least one frequency band in the *frequencyBandListAerial*, for FDD from *frequencyBandListAerial* for uplink, or for TDD from *frequencyBandListAerial* for downlink, for which the UE supports at least one of the *additionalSpectrumEmission* values in *nr-NS-PmaxListAerial*, if present:

5\> select the first frequency band in the *frequencyBandListAerial*, for FDD from *frequencyBandListAerial* for uplink, or for TDD from *frequencyBandListAerial* for downlink, which the UE supports and for which the UE supports at least one of the *additionalSpectrumEmission* values in *nr-NS-PmaxListAerial*;

4\> else:

5\> select the first frequency band in the *frequencyBandList*, for FDD from *frequencyBandList* for uplink, or for TDD from *frequencyBandList* for downlink, which the UE supports and for which the UE supports at least one of the *additionalSpectrumEmission* values in *nr-NS-PmaxList*, if present, and for RedCap UEs if the *halfDuplexRedCapAllowed* is not present, for which the UE supports full-duplex FDD operation;

4\> forward the *cellIdentity* to upper layers;

4\> forward the *trackingAreaCode* to upper layers;

4\> forward the *trackingAreaList* to upper layers, if included;

4\> forward the received *posSIB-MappingInfo* to upper layers, if included;

4\> forward the PLMN identity or SNPN identity or PNI-NPN identity to upper layers;

4\> if in RRC_INACTIVE and the forwarded information does not trigger message transmission by upper layers:

5\> if the serving cell does not belong to the configured *ran-NotificationAreaInfo*:

6\> initiate an RNA update as specified in 5.3.13.8;

5\> if configured to receive MBS multicast in RRC_INACTIVE and not indicated to stop monitoring G-RNTI for at least one MBS multicast session:

6\> if SIB24 is not scheduled in SIB1 in the cell after cell selection or cell reselection:

7\> initiate an RRC connection resume procedure for multicast reception as specified in 5.3.13.1d;

4\> forward the *ims-EmergencySupport* to upper layers, if present;

4\> forward the *eCallOverIMS-Support* to upper layers, if present;

4\> forward the *UAC-AccessCategory1-SelectionAssistanceInfo* or *UAC-AC1-SelectAssistInfo* for the selected PLMN/SNPN to upper layers, if present and set to *a*, *b* or *c*;

4\> if the UE is in SNPN access mode:

5\> forward the *imsEmergencySupportForSNPN* indicators with the corresponding SNPN identities to upper layers, if present;

4\> apply the configuration included in the *servingCellConfigCommon*;

4\> apply the specified PCCH configuration defined in 9.1.1.3;

4\> if the UE has a stored valid version of a SIB, in accordance with clause 5.2.2.2.1, that the UE requires to operate within the cell in accordance with clause 5.2.2.1:

5\> use the stored version of the required SIB;

4\> if the UE has not stored a valid version of a SIB, in accordance with clause 5.2.2.2.1, of one or several required SIB(s), in accordance with clause 5.2.2.1:

5\> for the SI message(s) that, according to the *si-SchedulingInfo*, contain at least one required SIB and for which *si-BroadcastStatus* is set to broadcasting:

6\> acquire the SI message(s) as defined in clause 5.2.2.3.2;

5\> for the SI message(s) that, according to the *si-SchedulingInfo*, contain at least one required SIB and for which *si-BroadcastStatus* is set to *notBroadcasting*:

6\> trigger a request to acquire the SI message(s) as defined in clause 5.2.2.3.3;

4\> if the UE has a stored valid version of a posSIB, in accordance with clause 5.2.2.2.1, of one or several required posSIB(s), in accordance with clause 5.2.2.1:

5\> use the stored version of the required posSIB;

4\> if the UE has not stored a valid version of a posSIB, in accordance with clause 5.2.2.2.1, of one or several posSIB(s) in accordance with clause 5.2.2.1:

5\> for the SI message(s) that, according to the *posSI-SchedulingInfo*, contain at least one requested posSIB and for which *posSI-BroadcastStatus* is set to *broadcasting*:

6\> acquire the SI message(s) as defined in clause 5.2.2.3.2;

5\> for the SI message(s) that, according to the *posSI-SchedulingInfo*, contain at least one requested posSIB for which *posSI-BroadcastStatus* is set to *notBroadcasting*:

6\> trigger a request to acquire the SI message(s) as defined in clause 5.2.2.3.3a;

4\> if the UE is aerial UE and it supports at least one *additionalSpectrumEmission* values in *nr-NS-PmaxListAerial* within *frequencyBandListAerial* in *uplinkConfigCommon* for FDD or in *downlinkConfigCommon* for TDD:

5\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxListAerial* within *frequencyBandListAerial* in *uplinkConfigCommon* for FDD or in *downlinkConfigCommon* for TDD;

4\> else:

5\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxList* within *frequencyBandList* in *uplinkConfigCommon* for FDD or in *downlinkConfigCommon* for TDD;

4\> if the *additionalPmax* is present in the same entry of the selected *additionalSpectrumEmission* within *nr-NS-PmaxList* or *nr-NS-PmaxListAerial*:

5\> apply the *additionalPmax* for UL;

4\> else:

5\> apply the *p-Max* in *uplinkConfigCommon* for UL;

4\> if *supplementaryUplink* is present in *servingCellConfigCommon*; and

4\> if the UE supports one or more of the frequency bands indicated in the *frequencyBandList* for the *supplementaryUplink*; and

4\> if the UE supports at least one *additionalSpectrumEmission* in the *nr-NS-PmaxList* for a supported supplementary uplink band; and

4\> if the UE is not a RedCap UE, or if the UE is a RedCap UE and *halfDuplexRedCapAllowed* is present, or if the UE is a RedCap UE and the RedCap UE supports full-duplex FDD operation on the frequency bands indicated in the *frequencyBandList* for the *supplementaryUplink*; and

4\> if the UE supports an uplink channel bandwidth with a maximum transmission bandwidth configuration (see TS 38.101-1 \[15\] and TS 38.101-2 \[39\]) which

- is smaller than or equal to the *carrierBandwidth* (indicated in *supplementaryUplink* for the SCS of the initial uplink BWP), and which

- is wider than or equal to the bandwidth of the initial uplink BWP of the SUL:

5\> consider supplementary uplink as configured in the serving cell;

5\> select the first frequency band in the *frequencyBandList* for the *supplementaryUplink* which the UE supports and for which the UE supports at least one of the *additionalSpectrumEmission* values in *nr-NS-PmaxList*, if present, and for RedCap UEs if the *halfDuplexRedCapAllowed* is not present, for which the UE supports full-duplex FDD operation;

5\> apply a supported supplementary uplink channel bandwidth with a maximum transmission bandwidth which

- is contained within the *carrierBandwidth* (indicated in *supplementaryUplink* for the SCS of the initial uplink BWP), and which

- is wider than or equal to the bandwidth of the initial BWP of the SUL;

5\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxList* within *frequencyBandList* for the *supplementaryUplink*;

5\> if the *additionalPmax* is present in the same entry of the selected *additionalSpectrumEmission* within *nr-NS-PmaxList* for the *supplementaryUplink*:

6\> apply the *additionalPmax* in *supplementaryUplink* for SUL;

5\> else:

6\> apply the *p-Max* in *supplementaryUplink* for SUL;

NOTE 2: For an out of coverage L2 U2N Remote UE in RRC_IDLE or RRC_INACTIVE receiving SIB1 from its connected L2 U2N Relay UE, it is up to Remote UE implementation whether to consider and apply the following parameters: *frequencyBandList*, *carrierBandwidth*, *frequencyShift7p5khz*, frequency band, channel bandwidth, the configuration included in the *servingCellConfigCommon*, the specified PCCH configuration, *additionalSpectrumEmission*, *additionalPmax*, and *p-Max*.

2\> else:

3\> consider the cell as barred in accordance with TS 38.304 \[20\]; and

3\> perform barring as if *intraFreqReselection*, or *intraFreqReselectionRedCap* for RedCap UEs, or *intraFreqReselection-eRedCap* for eRedCap UEs, is set to *notAllowed*;

##### 5.2.2.4.3 Actions upon reception of *SIB2*

Upon receiving *SIB2*, the UE shall:

1\> if in RRC_IDLE or in RRC_INACTIVE or in RRC_CONNECTED while T311 is running:

2\> if, for the entry in *frequencyBandList* with the same index as the frequency band selected in clause 5.2.2.4.2, the UE supports at least one *additionalSpectrumEmission* in the *nr-NS-PmaxList* within the *frequencyBandList* or

2\> if, for the entry in *frequencyBandListAerial* with the same index as the frequency band selected in clause 5.2.2.4.2, the UE supports at least one *additionalSpectrumEmission* in the *nr-Ns-PmaxListAerial* within the *frequencyBandListAerial*:

3\> if the UE is aerial UE and it supports at least one *additionalSpectrumEmission* values in *nr-NS-PmaxListAerial* within the *frequencyBandListAerial*:

4\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxListAerial* within *frequencyBandListAerial*;

3\> else:

4\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxList* within *frequencyBandList*;

3\> if the *additionalPmax* is present in the same entry of the selected *additionalSpectrumEmission* within *nr-NS-PmaxList* or *nr-NS-PmaxListAerial*:

4\> apply the *additionalPmax*;

3\> else:

4\> apply the *p-Max*;

3\> if the UE selects a frequency band (from the procedure in clause 5.2.2.4.2) for the supplementary uplink:

4\> if, for the entry in *frequencyBandListSUL* with the same index as the frequency band selected in clause 5.2.2.4.2, the UE supports at least one *additionalSpectrumEmission* in the *nr-NS-PmaxList* within the *frequencyBandListSUL*:

5\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxList* within *frequencyBandListSUL*;

5\> if the *additionalPmax* is present in the same entry of the selected *additionalSpectrumEmission* within *nr-NS-PmaxList*:

6\> apply the *additionalPmax*;

5\> else:

6\> apply the *p-Max*;

4\> else:

5\> apply the *p-Max.*

2\> else:

3\> apply the *p-Max*;

##### 5.2.2.4.4 Actions upon reception of *SIB3*

No UE requirements related to the contents of this *SIB3* apply other than those specified elsewhere e.g. within procedures using the concerned system information, and/ or within the corresponding field descriptions.

##### 5.2.2.4.5 Actions upon reception of *SIB4*

Upon receiving *SIB4* the UE shall:

1\> if in RRC_IDLE, or in RRC_INACTIVE or in RRC_CONNECTED while T311 is running:

2\> for each entry in the *interFreqCarrierFreqList*:

3\> if the UE is neither a RedCap nor an eRedCap UE; or

3\> if the UE is a RedCap UE and the *interFreqCarrierFreqList-v1700* is absent; or

3\> if the UE is an eRedCap UE and the *interFreqCarrierFreqList-v1800* is absent; or

3\> if the UE is a RedCap UE and *redCapAccessAllowed* is present in *interFreqCarrierFreqList-v1700;* or

3\> if the UE is an eRedCap UE and e*RedCapAccessAllowed* is present in *interFreqCarrierFreqList-v1800*:

4\> select the first frequency band in the *frequencyBandList* (or for aerial UE *frequencyBandListAerial*), and *frequencyBandListSUL*, if present, which the UE supports and for which the UE supports at least one of the *additionalSpectrumEmission* values in *nr-NS-PmaxList* (or for aerial UE *nr-NS-PmaxListAerial*), if present:

4\> if, the frequency band selected by the UE in *frequencyBandList* or *frequencyBandListAerial* to represent a non-serving NR carrier frequency is not a downlink only band:

5\> if, for the selected frequency band, the UE supports at least one *additionalSpectrumEmission* in the *nr-NS-PmaxList* within the *frequencyBandList*; or

5\> if, for the selected frequency band, the UE supports at least one *additionalSpectrumEmission* in the *nr-NS-PmaxListAerial* within the *frequencyBandListAerial*:

6\> if the UE is aerial UE and it supports at least one *additionalSpectrumEmission* values in *nr-NS-PmaxListAerial* within the *frequencyBandListAerial*:

7\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxListAerial* within *frequencyBandListAerial*;

6\> else:

7\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxList* within *frequencyBandList*;

6\> if the *additionalPmax* is present in the same entry of the selected *additionalSpectrumEmission* within *nr-NS-PmaxList* or *nr-NS-PmaxListAerial*:

7\> apply the *additionalPmax*;

6\> else:

7\> apply the *p-Max*;

6\> if frequencyBandListSUL is present in SIB4 and, for the frequency band selected in frequencyBandListSUL, the UE supports at least one *additionalSpectrumEmission* in the *nr-NS-PmaxList* within *FrequencyBandListSUL*:

7\> apply the first listed *additionalSpectrumEmission* which it supports among the values included in *nr-NS-PmaxList* within *frequencyBandListSUL*;

7\> if the *additionalPmax* is present in the same entry of the selected *additionalSpectrumEmission* within *nr-NS-PmaxList*:

8\> apply the *additionalPmax*;

7\> else:

8\> apply the *p-Max*;

6\> else:

7\> apply the *p-Max*;

5\> else:

6\> apply the *p-Max*;

1\> if in RRC_IDLE or RRC_INACTIVE, and T331 is running:

2\> perform the actions as specified in 5.7.8.1a;

##### 5.2.2.4.6 Actions upon reception of *SIB5*

No UE requirements related to the contents of this *SIB5* apply other than those specified elsewhere e.g. within procedures using the concerned system information, and/ or within the corresponding field descriptions.

##### 5.2.2.4.7 Actions upon reception of *SIB6*

Upon receiving the *SIB6* the UE shall:

1\> forward the received *warningType*, *messageIdentifier* and *serialNumber* to upper layers;

##### 5.2.2.4.8 Actions upon reception of *SIB7*

Upon receiving the *SIB7* the UE shall:

1\> if there is no current value for *messageIdentifier* and *serialNumber* for *SIB7*; or

1\> if either the received value of *messageIdentifier* or of s*erialNumber,* or of both *messageIdentifier* and s*erialNumber* are different from the current values of *messageIdentifier* and *serialNumber* for *SIB7*:

2\> use the received values of *messageIdentifier* and *serialNumber* for *SIB7* as the current values of *messageIdentifier* and *serialNumber* for *SIB7*;

2\> discard any previously buffered *warningMessageSegment*;

2\> if all segments of a warning message have been received:

3\> assemble the warning message from the received *warningMessageSegment(s)*;

3\> forward the received warning message, *messageIdentifier*, *serialNumber* and *dataCodingScheme* to upper layers;

3\> stop reception of *SIB7*;

3\> discard the current values of *messageIdentifier* and *serialNumber* for *SIB7*;

2\> else:

3\> store the received *warningMessageSegment*;

3\> continue reception of *SIB7*;

1\> else if all segments of a warning message have been received:

2\> assemble the warning message from the received *warningMessageSegment(s)*;

2\> forward the received complete warning message, *messageIdentifier*, *serialNumber* and *dataCodingScheme* to upper layers;

2\> stop reception of *SIB7*;

2\> discard the current values of *messageIdentifier* and *serialNumber* for *SIB7*;

1\> else:

2\> store the received *warningMessageSegment*;

2\> continue reception of *SIB7*;

The UE should discard any stored *warningMessageSegment* and the current value of *messageIdentifier* and *serialNumber* for *SIB7* if the complete warning message has not been assembled within a period of 3 hours.

##### 5.2.2.4.9 Actions upon reception of *SIB8*

Upon receiving the *SIB8* the UE shall:

1\> if the *SIB8* contains a complete warning message and the complete geographical area coordinates (if any):

2\> forward the received warning message, *messageIdentifier*, *serialNumber*, *dataCodingScheme* and the geographical area coordinates (if any) to upper layers;

2\> continue reception of *SIB8*;

1\> else:

2\> if the received values of *messageIdentifier* and *serialNumber* are the same (each value is the same) as a pair for which a warning message and the geographical area coordinates (if any) are currently being assembled:

3\> store the received *warningMessageSegment*;

3\> store the received *warningAreaCoordinatesSegment* (if any);

3\> if all segments of a warning message and geographical area coordinates (if any) have been received:

4\> assemble the warning message from the received *warningMessageSegment*;

4\> assemble the geographical area coordinates from the received *warningAreaCoordinatesSegment* (if any);

4\> forward the received warning message, *messageIdentifier*, *serialNumber*, *dataCodingScheme* and geographical area coordinates (if any) to upper layers;

4\> stop assembling a warning message and geographical area coordinates (if any) for this *messageIdentifier* and *serialNumber* and delete all stored information held for it;

3\> continue reception of *SIB8*;

2\> else if the received values of *messageIdentifier* and/or *serialNumber* are not the same as any of the pairs for which a warning message is currently being assembled:

3\> start assembling a warning message for this *messageIdentifier* and *serialNumber* pair;

3\> start assembling the geographical area coordinates (if any) for this *messageIdentifier* and *serialNumber* pair;

3\> store the received *warningMessageSegment*;

3\> store the received *warningAreaCoordinatesSegment* (if any);

3\> continue reception of *SIB8*;

The UE should discard *warningMessageSegment* and *warningAreaCoordinatesSegment* (if any) and the associated values of *messageIdentifier* and *serialNumber* for *SIB8* if the complete warning message and the geographical area coordinates (if any) have not been assembled within a period of 3 hours.

NOTE: The number of warning messages that a UE can re-assemble simultaneously is a function of UE implementation.

##### 5.2.2.4.10 Actions upon reception of *SIB9*

Upon receiving *SIB9* with r*eferenceTimeInfo*, the UE may perform the related actions except for the action of ignoring all further *referenceTimeInfo* received in SIB9 as specified in clause 5.7.1.3.

Upon receiving *SIB9* with *eventID-TSS,* the UE shall perform the related actions if requested by upper layers:

1\> if *VarEventID* has an entry with a *storedEventID* value:

2\> if the *storedEventID* value within *VarEventID* is different from the *eventID-TSS* value received within *SIB9*:

3\> consider that the content of *clockQualityDetailsLevel* may have changed;

3\> notify upper layers that *clockQualityDetailsLevel* may have changed;

3\> replace the *storedEventID* value within *VarEventID* with the *eventID-TSS* value received within *SIB9*;

3\> replace the *storedGnbID* value within *VarGnbID* with the gNB identity value received within *SIB1*;

2\> else:

3\> if the *VarGnbID* has an entry with a *storedGnbID* value:

4\> if the *storedGnbID* value within *VarGnbID* is different from the gNB identity value received within *SIB1*:

5\> consider that the content of *clockQualityDetailsLevel* may have changed;

5\> notify upper layers that *clockQualityDetailsLevel* may have changed;

5\> replace the *storedGnbID* value within *VarGnbID* with the gNB identity value received within *SIB1*;

NOTE: The UE should calculate the value of the gNB identity as the value of *gNB-ID-Length* leftmost bits of the 36-bit long *cellIdentity* in the first *PLMN-IdentityInfo* IE of *PLMN-IdentityInfoList* in *SIB1*.

1\> else:

2\> add a new entry of *storedEventID* within the *VarEventID* with the *eventID-TSS* value received within *SIB9*;

2\> add a new entry of *storedGnbID* within the *VarGnbID* with the gNB identity value received within *SIB1*;

2\> notify upper layers that *clockQualityDetailsLevel* may have changed;

##### 5.2.2.4.11 Actions upon reception of *SIB10*

Upon receiving *SIB10*, the UE shall:

> 1\> Forward the *HRNN-list* entries with the corresponding PNI-NPN and SNPN identities to upper layers;

##### 5.2.2.4.12 Actions upon reception of *SIB11*

Upon receiving *SIB11*, the UE shall:

1\> if in RRC_IDLE or RRC_INACTIVE, and T331 is running:

2\> perform the actions as specified in 5.7.8.1a;

##### 5.2.2.4.13 Actions upon reception of *SIB12*

Upon receiving *SIB12*, the UE shall:

1\> if the UE has stored at least one segment of *SIB12* and the value tag of *SIB12* has changed since a previous segment was stored:

2\> discard all stored segments;

1\> store the segment;

1\> if all segments have been received:

2\> assemble *SIB12-IEs* from the received segments;

2\> if *sl-FreqInfoList*/*sl-FreqInfoListSizeExt* is included in *SIB12-IEs*:

3\> if configured to receive NR sidelink communication:

4\> use the resource pool(s) indicated by *sl-RxPool* for NR sidelink communication reception, as specified in 5.8.7;

3\> if configured to transmit NR sidelink communication:

4\> use the resource pool(s) indicated by *sl-TxPoolSelectedNormal*, or *sl-TxPoolExceptional* for NR sidelink communication transmission, as specified in 5.8.8;

4\> perform CBR measurement on the transmission resource pool(s) indicated by *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* for NR sidelink communication transmission, as specified in 5.5.3.1;

4\> use the synchronization configuration parameters for NR sidelink communication on frequencies included in *sl-FreqInfoList*/*sl-FreqInfoListSizeExt*, as specified in 5.8.5;

3\> if configured to receive NR sidelink discovery:

4\> use the resource pool(s) indicated by *sl-DiscRxPool* or *sl-RxPool* for NR sidelink discovery reception, as specified in 5.8.13.2;

3\> if configured to transmit NR sidelink discovery:

4\> if the UE is configured by upper layers to transmit NR sidelink L2 U2N relay discovery messages and *sl-L2U2N-Relay* is included in SIB12; or

4\> if the UE is configured by upper layers to transmit NR sidelink L3 U2N relay discovery messages and *sl-L3U2N-RelayDiscovery* is included in SIB12; or

4\> if the UE is configured by upper layers to transmit NR sidelink non-relay discovery messages and *sl-NonRelayDiscovery* is included in SIB12:

5\> use the resource pool(s) indicated by *sl-DiscTxPoolSelected*, *sl-TxPoolExceptional* or *sl-TxPoolSelectedNormal* for NR sidelink discovery transmission, as specified in 5.8.13.3;

5\> perform CBR measurement on the transmission resource pool(s) indicated by *sl-TxPoolSelectedNormal*, *sl-DiscTxPoolSelected* or *sl-TxPoolExceptional* for NR sidelink discovery transmission, as specified in 5.5.3.1;

5\> use the synchronization configuration parameters for NR sidelink discovery on frequencies included in *sl-FreqInfoList*, as specified in 5.8.5;

2\> if *sl-RadioBearerConfigList* or *sl-RLC-BearerConfigList* is included in *sl-ConfigCommonNR*:

3\> perform sidelink DRB addition/modification/release as specified in 5.8.9.1a.1/5.8.9.1a.2;

3\> if *sl-RLC-BearerConfigListSizeExt* is included in *SIB12-IEs*:

4\> perform additional sidelink RLC bearer addition/modification/release as specified in 5.8.9.1a.5/5.8.9.1a.6;

2\> if *sl-MeasConfigCommon* is included in *sl-ConfigCommonNR*:

3\> store the NR sidelink measurement configuration;

2\> if *sl-DRX-ConfigCommonGC-BC* is included in *SIB12-IEs*:

3\> store the NR sidelink DRX configuration and configure lower layers to perform sidelink DRX operation for groupcast and broadcast as specified in TS 38.321 \[3\];

1\> if the UE is acting as L2 U2N Remote UE:

2\> if the *sl-TimersAndConstantsRemoteUE* is included in *SIB12*:

3\> use values for timers T300, T301 and T319 as included in the *sl-TimersAndConstantsRemoteUE* received in *SIB12*;

2\> else:

3\> use values for timers T300, T301 and T319 as included in the *ue-TimersAndConstants* received in *SIB1*;

The UE should discard any stored segments for *SIB12* if the complete *SIB12* has not been assembled within a period of 3 hours. The UE shall discard any stored segments for *SIB12* upon cell (re-)selection.

##### 5.2.2.4.14 Actions upon reception of *SIB13*

Upon receiving *SIB13*, the UE shall perform the actions upon reception of *SystemInformationBlockType21* as specified in 5.2.2.28 in TS 36.331 \[10\].

##### 5.2.2.4.15 Actions upon reception of *SIB14*

Upon receiving *SIB14*, the UE shall perform the actions upon reception of *SystemInformationBlockType26* as specified in 5.2.2.33 in TS 36.331 \[10\].

##### 5.2.2.4.16 Actions upon reception of *SIBpos*

No UE requirements related to the contents of the *SIBpos* apply other than those specified elsewhere e.g. within TS 37.355 \[49\], and/or within the corresponding field descriptions.

##### 5.2.2.4.17 Actions upon reception of *SIB15*

Upon receiving *SIB15*, the UE shall:

1\> forward the applicable disaster roaming information for each PLMN sharing the cell to upper layers.

##### 5.2.2.4.18 Actions upon reception of *SIB16*

Upon receiving *SIB16* with cell reselection priorities for slicing, the UE shall perform the actions as specified in TS 38.304 \[20\].

##### 5.2.2.4.19 Actions upon reception of *SIB17*

Upon receiving *SIB17*, the UE shall:

1\> if the UE has stored at least one segment of *SIB17* and the value tag of *SIB17* has changed since a previous segment was stored:

2\> discard all stored segments;

1\> store the segment;

1\> if all segments have been received:

2\> assemble *SIB17-IEs* from the received segments.

The UE should discard any stored segments for *SIB17* if the complete *SIB17* has not been assembled within a period of 3 hours. The UE shall discard any stored segments for *SIB17* upon cell (re-) selection.

##### 5.2.2.4.20 Actions upon reception of *SIB18*

Upon receiving *SIB18*, the UE shall:

1\> forward the Group IDs for Network selection (GINs) in *SIB18* with the corresponding SNPN identities to upper layers;

##### 5.2.2.4.21 Actions upon reception of *SIB19*

Upon receiving *SIB19* in an NTN cell, the UE in RRC_CONNECTED shall:

1\> start or restart T430 for serving cell with the timer value set to *ntn-UlSyncValidityDuration* for the serving cell from the subframe indicated by *epochTime* for the serving cell;

1\> if *SatSwitchWithReSync* and *t-Service* are included, and the UE supports hard satellite switch with resynchronization;

2\> if *t-ServiceStart* is included and the UE supports soft satellite switch with resynchronization:

3\> perform the satellite switch with resynchronization as specified in 5.7.19 between the time indicated by *t-ServiceStart* and the time indicated by *t-Service* for the serving cell.

2\> else:

3\> perform the satellite switch with resynchronization as specified in 5.7.19 at the time indicated by *t-Service* for the serving cell.

NOTE: UE should attempt to re-acquire *SIB19* before the end of the duration indicated by *ntn-UlSyncValidityDuration* and *epochTime* by UE implementation.

##### 5.2.2.4.22 Actions upon reception of *SIB20*

No UE requirements related to the contents of *SIB20* apply other than those specified elsewhere e.g. within procedures using the concerned system information, and/or within the corresponding field descriptions.

##### 5.2.2.4.23 Actions upon reception of *SIB21*

No UE requirements related to the contents of *SIB21* apply other than those specified elsewhere e.g. within procedures using the concerned system information, and/or within the corresponding field descriptions.

##### 5.2.2.4.24 Actions upon reception of *SIB22*

No UE requirements related to the contents of *SIB22* apply other than those specified elsewhere e.g. within procedures using the concerned system information, and/or within the corresponding field descriptions.

5.2.2.4.25 Actions upon reception of *SIB23*

Upon receiving *SIB23*, the UE shall:

> 1\> if *sl-FreqInfoList* is included in *sl-PosConfigCommonNR*:
>
> 2\> if configured to receive sidelink control information for SL-PRS measurement:
>
> 3\> use the resource pool(s) indicated by *sl-RxPool* and/or *sl-PRS-RxPool* for sidelink control information reception for SL-PRS , as specified in 5.8.18.2;
>
> 2\> if configured to transmit SL-PRS:

3\> use the resource pool(s) indicated by *sl-TxPoolSelectedNormal*, *sl-TxPoolExceptional, sl-PRS-TxPoolSelectedNormal* or *sl-PRS-TxPoolExceptional* for SL-PRS transmission, as specified in 5.8.18.3;

> 3\> perform CBR measurement on the transmission resource pool(s) indicated by *sl-TxPoolSelectedNormal*, *sl-TxPoolExceptional, sl-PRS-TxPoolSelectedNormal* or *sl-PRS-TxPoolExceptional* for SL-PRS transmission, as specified in 5.5.3.1;
>
> 3\> use the synchronization configuration parameters for NR sidelink positioning on frequencies included in *sl-FreqInfoList*, as specified in 5.8.5;

The UE should discard any stored segments for *SIB23* if the complete *SIB23* has not been assembled within a period of 3 hours. The UE shall discard any stored segments for *SIB23* upon cell (re-)selection.

##### 5.2.2.4.26 Actions upon reception of *SIB24*

No UE requirements related to the contents of *SIB24* apply other than those specified elsewhere e.g., within procedures using the concerned system information, and/or within the corresponding field descriptions.

##### 5.2.2.4.27 Actions upon reception of *SIB25*

No UE requirements related to the contents of *SIB25* apply other than those specified elsewhere e.g. within procedures using the concerned system information, and/or within the corresponding field descriptions.

#### 5.2.2.5 Essential system information missing

The UE shall:

1\> if in RRC_IDLE or in RRC_INACTIVE or in RRC_CONNECTED while T311 is running:

2\> if the UE is unable to acquire the *MIB*:

3\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> perform barring as if *intraFreqReselection*, or *intraFreqReselectionRedCap* for RedCap UEs, or *intraFreqReselection-eRedCap* for eRedCap UEs, is set to *allowed*;

2\> else if the UE is unable to acquire the *SIB1*:

3\> consider the cell as barred in accordance with TS 38.304 \[20\];

3\> if the UE is a RedCap UE:

4\> perform barring as if *intraFreqReselectionRedCap* is set to *allowed*;

3\> else if the UE is an eRedCap UE:

4\> perform barring as if *intraFreqReselection-eRedCap* is set to *allowed*;

3\> else:

4\> perform cell re-selection to other cells on the same frequency as the barred cell as specified in TS 38.304 \[20\].

NOTE 1: The *SIB19* is essential for NTN access. If UE is unable to acquire the *SIB19* for NTN access, the action is up to UE implementation (e.g., cell re-selection to other cells).

NOTE 2: The *SIB22* is essential for ATG access. If UE is unable to acquire the *SIB22* for ATG access, the action is up to UE implementation (e.g., cell re-selection to other cells).

#### 5.2.2.6 T430 expiry

The UE shall:

1\> if T430 for serving cell expires and if in RRC_CONNECTED:

2\> inform lower layers that UL synchronisation is lost;

2\> acquire *SIB19* as defined in clause 5.2.2.3.2;

2\> upon successful acquisition of *SIB19*:

3\> inform lower layers when UL synchronisation is obtained;

NOTE: The exact time when UL synchronisation is obtained (after SIB19 is acquired) is left to UE implementation, which can be from the subframe indicated by *epochTime* and optionally before the subframe indicated by *epochTime*.

## 5.3 Connection control

### 5.3.1 Introduction

#### 5.3.1.1 RRC connection control

RRC connection establishment involves the establishment of SRB1. The network completes RRC connection establishment prior to completing the establishment of the NG connection, i.e. prior to receiving the UE context information from the 5GC. Consequently, AS security is not activated during the initial phase of the RRC connection. During this initial phase of the RRC connection, the network may configure the UE to perform measurement reporting, but the UE only sends the corresponding measurement reports after successful AS security activation. However, the UE only accepts a re-configuration with sync message when AS security has been activated.

Upon receiving the UE context from the 5GC, the RAN activates AS security (both ciphering and integrity protection) using the initial AS security activation procedure. The RRC messages to activate AS security (command and successful response) are integrity protected, while ciphering is started only after completion of the procedure. That is, the response to the message used to activate AS security is not ciphered, while the subsequent messages (e.g. used to establish SRB2, DRBs and multicast MRBs) are both integrity protected and ciphered. After having initiated the initial AS security activation procedure, the network may initiate the establishment of SRB2 and DRBs and/or multicast MRBs, i.e. the network may do this prior to receiving the confirmation of the initial AS security activation from the UE. In any case, the network will apply both ciphering and integrity protection for the RRC reconfiguration messages used to establish SRB2, DRBs and/or multicast MRBs. The network should release the RRC connection if the initial AS security activation and/ or the radio bearer establishment fails. A configuration with SRB2 without DRB or multicast MRB, or with DRB or multicast MRB without SRB2 is not supported (i.e., SRB2 and at least one DRB or multicast MRB must be configured in the same RRC Reconfiguration message, and it is not allowed to release all the DRBs and multicast MRBs without releasing the RRC Connection). For IAB-MT and NCR-MT, a configuration with SRB2 without any DRB/MRB is supported.

The release of the RRC connection normally is initiated by the network. The procedure may be used to re-direct the UE to an NR frequency or an E-UTRA carrier frequency.

The suspension of the RRC connection is initiated by the network. When the RRC connection is suspended, the UE stores the UE Inactive AS context and any configuration received from the network, and transits to RRC_INACTIVE state. The RRC message to suspend the RRC connection is integrity protected and ciphered.

The resumption of a suspended RRC connection is initiated by upper layers when the UE needs to transit from RRC_INACTIVE state to RRC_CONNECTED state or by RRC layer to perform a RNA update or by RAN paging from NG-RAN or for SDT. When the RRC connection is resumed, network configures the UE according to the RRC connection resume procedure based on the stored UE Inactive AS context and any RRC configuration received from the network. The RRC connection resume procedure re-activates AS security and re-establishes SRB(s) and DRB(s) and/or multicast MRB(s), if configured.

Upon initiating the resume procedure for SDT, AS security (both ciphering and integrity protection) is re-activated for SRB2 (if configured for SDT) and for SRB1. In addition, AS security is also re-activated (if security is configured) for all the DRBs configured for SDT. Further, the PDCP entities of SRB1 and PDCP entities of the radio bearers configured for SDT are re-established and resumed whilst the UE remains in RRC_INACTIVE state. Transmission and reception of data and/or signalling messages over radio bearers configured for SDT can happen whilst the UE is in RRC_INACTIVE state and SDT procedure is ongoing.

In response to a request to resume the RRC connection or in response to a resume procedure initiated for SDT, the network may resume the suspended RRC connection and send UE to RRC_CONNECTED, or reject the request to resume and send UE to RRC_INACTIVE (with a wait timer), or directly re-suspend the RRC connection and send UE to RRC_INACTIVE, or directly release the RRC connection and send UE to RRC_IDLE, or instruct the UE to initiate NAS level recovery (in this case the network sends an RRC setup message).

NOTE: In case the UE receives the configurations for NR sidelink communication via the E-UTRA, the configurations for NR sidelink communication in *SIB12* and *sl-ConfigDedicatedNR* within *RRCReconfiguration* used in clause 5.3 are provided by the configurations in *SystemInformationBlockType28* and *sl-ConfigDedicatedForNR* within *RRCConnectionReconfiguration* as specified in TS 36.331\[10\], respectively.

#### 5.3.1.2 AS Security

AS security comprises of the integrity protection and ciphering of RRC signalling (SRBs) and user data (DRBs).

RRC handles the configuration of the AS security parameters which are part of the AS configuration: the integrity protection algorithm, the ciphering algorithm, if integrity protection and/or ciphering is enabled for a DRB and two parameters, namely the *keySetChangeIndicator* and the *nextHopChainingCount*, which are used by the UE to determine the AS security keys upon reconfiguration with sync (with key change), connection re-establishment and/or connection resume.

The integrity protection algorithm is common for SRB1, SRB2, SRB3 (if configured), SRB4 (if configured), SRB5 (if configured) and DRBs configured with integrity protection, with the same *keyToUse* value. The ciphering algorithm is common for SRB1, SRB2, SRB3 (if configured), SRB4 (if configured), SRB5 (if configured) and DRBs configured with the same *keyToUse* value. Neither integrity protection nor ciphering applies for SRB0.

NOTE 0: All DRBs related to the same PDU session have the same enable/disable setting for ciphering and the same enable/disable setting for integrity protection, as specified in TS 33.501 \[11\].

RRC integrity protection and ciphering are always activated together, i.e. in one message/procedure. RRC integrity protection and ciphering for SRBs are never de-activated. However, it is possible to switch to a \'*NULL*\' ciphering algorithm (*nea0*).

The \'*NULL*\' integrity protection algorithm (*nia0*) is used only for SRBs and for the UE in limited service mode, see TS 33.501 \[11\] and when used for SRBs, integrity protection is disabled for DRBs. In case the ′*NULL*\' integrity protection algorithm is used, \'*NULL*\' ciphering algorithm is also used.

NOTE 1: Lower layers discard RRC messages for which the integrity protection check has failed and indicate the integrity protection verification check failure to RRC.

The AS applies four different security keys: one for the integrity protection of RRC signalling (K~RRCint~), one for the ciphering of RRC signalling (K~RRCenc~), one for integrity protection of user data (K~UPint~) and one for the ciphering of user data (K~UPenc~). All four AS keys are derived from the K~gNB~ key. The K~gNB~ key is based on the K~AMF~ key (as specified in TS 33.501 \[11\]), which is handled by upper layers.

The integrity protection and ciphering algorithms can only be changed with reconfiguration with sync. The AS keys (K~gNB~, K~RRCint~, K~RRCenc~, K~UPint~ and K~UPenc~) change upon reconfiguration with sync (if *masterKeyUpdate* is included), and upon connection re-establishment and connection resume.

For each radio bearer an independent counter (*COUNT*, as specified in TS 38.323 \[5\]) is maintained for each direction. For each radio bearer, the *COUNT* is used as input for ciphering and integrity protection.

It is not allowed to use the same *COUNT* value more than once for a given security key. As specified in TS 33.501 clause 6.9.4.1 \[11\], the network is responsible for avoiding reuse of the *COUNT* with the same RB identity and with the same key, e.g. due to the transfer of large volumes of data, release and establishment of new RBs, and multiple termination point changes for RLC-UM bearers and multiple termination point changes for RLC-AM bearer with SN terminated PDCP re-establishment (COUNT reset) due to SN only full configuration whilst the key stream inputs (i.e. bearer ID, security key) at MN have not been updated. In order to avoid such re-use, the network may e.g. use different RB identities for RB establishments, change the AS security key, or an RRC_CONNECTED to RRC_IDLE/RRC_INACTIVE and then to RRC_CONNECTED transition.

In order to limit the signalling overhead, individual messages/ packets include a short sequence number (PDCP SN, as specified in TS 38.323 \[5\]). In addition, an overflow counter mechanism is used: the hyper frame number (*HFN*, as specified in TS 38.323 \[5\]). The HFN needs to be synchronized between the UE and the network.

For each SRB, the value provided by RRC to lower layers to derive the 5-bit BEARER parameter used as input for ciphering and for integrity protection is the value of the corresponding *srb-Identity* with the MSBs padded with zeroes.

For a UE provided with an *sk-counter*, *keyToUse* indicates whether the UE uses the master key (K~gNB~) or the secondary key (S-K~eNB~ or S-K~gNB~) for a particular DRB. The secondary key is derived from the master key and *sk-Counter*, as defined in TS 33.501\[11\]. Whenever there is a need to refresh the secondary key, e.g. upon change of MN with K~gNB~ change or to avoid COUNT reuse, the security key update is used (see 5.3.5.7). When the UE is in NR-DC, the network may provide a UE configured with an SCG with an *sk-Counter* even when no DRB is setup using the secondary key (S-K~gNB~) in order to allow the configuration of SRB3. The network can also provide the UE with an *sk-Counter*, even if no SCG is configured, when using SN terminated MCG bearers.

### 5.3.2 Paging

#### 5.3.2.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: Paging [ac];
|||;
~~~

Figure 5.3.2.1-1: Paging

The purpose of this procedure is:

- to transmit paging information to a UE in RRC_IDLE or RRC_INACTIVE.

- to transmit paging information for a L2 U2N Remote UE in RRC_IDLE or RRC_INACTIVE to its serving L2 U2N Relay UE in any RRC state.

#### 5.3.2.2 Initiation

The network initiates the paging procedure by transmitting the *Paging* message at the UE\'s paging occasion as specified in TS 38.304 \[20\]. The network may address multiple UEs within a *Paging* message by including one *PagingRecord* for each UE. The network may also include one or multiple TMGI(s) in the *Paging* message to page UEs for specific MBS multicast session(s).

#### 5.3.2.3 Reception of the *Paging* *message* by the UE or *PagingRecord* by the L2 U2N Remote UE

Upon receiving the *Paging* message by the UE or receiving *PagingRecord* from its connected L2 U2N Relay UE by a L2 U2N Remote UE, the UE shall:

1\> if in RRC_IDLE, for each of the *PagingRecord*, if any, included in the *Paging* message, or

1\> if in RRC_IDLE, for the *PagingRecord*, if any, included in the *UuMessageTransferSidelink* message received from the connected L2 U2N Relay UE:

2\> if the *ue-Identity* included in the *PagingRecord* matches the UE identity allocated by upper layers:

3\> if upper layers indicate the support of paging cause:

4\> forward the *ue-Identity,* *accessType* (if present) and paging cause (if determined) to the upper layers;

3\> else:

4\> forward the *ue-Identity* and *accessType* (if present) to the upper layers;

> NOTE 1: If the L2 U2N Relay UE supports the MUSIM feature, it can forward the paging cause to the connected L2 U2N Remote UE.

1\> if in RRC_INACTIVE, for each of the *PagingRecord*, if any, included in the *Paging* message, or

1\> if in RRC_INACTIVE, for the *PagingRecord*, if any, included in the *UuMessageTransferSidelink* message received from the connected L2 U2N Relay UE:

2\> if the *ue-Identity* included in the *PagingRecord* matches the UE\'s stored *fullI-RNTI*:

3\> if the UE is configured by upper layers with Access Identity 1:

4\> initiate the RRC connection resumption procedure according to 5.3.13 with *resumeCause* set to *mps-PriorityAccess*;

3\> else if the UE is configured by upper layers with Access Identity 2:

4\> initiate the RRC connection resumption procedure according to 5.3.13 with *resumeCause* set to *mcs-PriorityAccess*;

3\> else if the UE is configured by upper layers with one or more Access Identities equal to 11-15:

4\> initiate the RRC connection resumption procedure according to 5.3.13 with *resumeCause* set to *highPriorityAccess*;

3\> else if *mt-SDT* indication was included in the paging message and if the conditions for initiating SDT for a resume procedure initiated in response to RAN paging according to 5.3.13.1b are fulfilled:

4\> initiate the RRC connection resumption procedure according to 5.3.13 with *resumeCause* set to *mt-SDT*:

3\> else:

4\> initiate the RRC connection resumption procedure according to 5.3.13 with *resumeCause* set to *mt-Access*;

NOTE 2: If both conditions for initiating MT-SDT and MO-SDT according to 5.3.13.1b are fulfilled, UE may initiate RRC connection resumption procedure for MT-SDT or MO-SDT based on implementation.

NOTE 3: A MUSIM UE may not initiate the RRC connection resumption procedure, e.g. when it decides not to respond to the *Paging* message due to UE implementation constraints as specified in TS 24.501 \[23\].

2\> else if the *ue-Identity* included in the *PagingRecord* matches the UE identity allocated by upper layers:

3\> if upper layers indicate the support of paging cause:

4\> forward the *ue-Identity*, *accessType* (if present) and paging cause (if determined) to the upper layers;

3\> else:

4\> forward the *ue-Identity* and *accessType* (if present) to the upper layers;

3\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause \'other\';

1\> if in RRC_IDLE, for each *TMGI* included in *pagingGroupList*, if any, included in the *Paging* message:

2\> if the UE has joined an MBS session indicated by the *TMGI* included in the *pagingGroupList*:

3\> forward the *TMGI* to the upper layers;

1\> if in RRC_INACTIVE and the UE has joined one or more MBS session(s) indicated by the *TMGI(s)* included in the *pagingGroupList*:

2\> if the UE is not configured to receive multicast in RRC_INACTIVE or if *inactiveReceptionAllowed* is not included for at least one of the MBS session (s) indicated by the *TMGI(s)* that the UE has joined:

3\> if *PagingRecordList* is not included in the *Paging* message; or

3\> if none of the *ue-Identity* included in any of the *PagingRecord* matches the UE identity allocated by upper layers or the UE\'s stored *fullI-RNTI*:

4\> initiate the RRC connection resumption procedure according to 5.3.13 with *resumeCause* set as below:

5\> if the UE is configured by upper layers with Access Identity 1:

6\> set *resumeCause* to *mps-PriorityAccess*;

5\> else if the UE is configured by upper layers with Access Identity 2:

6\> set *resumeCause* to *mcs-PriorityAccess*;

5\> else if the UE is configured by upper layers with one or more Access Identities equal to 11-15:

6\> set *resumeCause* to *highPriorityAcces*s;

5\> else:

6\> set *resumeCause* to *mt-Access*;

3\> else if the *ue-Identity* included in any of the *PagingRecord* matches the UE identity allocated by upper layers:

4\> forward the *TMGI(s)* to the upper layers;

2\> else:

3\> start monitoring the G-RNTI(s) corresponding to the *TMGI(s),* if configured;

3\> if the UE was notified to stop monitoring the G-RNTI(s) for all the joined multicast sessions that are configured for reception in RRC_INACTIVE:

4\> start monitoring the Multicast MCCH-RNTI;

4\> acquire the *MBSMulticastConfiguration* message on multicast MCCH, if present;

3\> else if the UE was notified to stop monitoring the G-RNTI for at least one multicast session for which the PTM configuration was not included in *RRCRelease* message:

4\> acquire the *MBSMulticastConfiguration* message on multicast MCCH;

1\> if the UE is acting as a L2 U2N Relay UE, for each of the *PagingRecord*, if any, included in the *Paging* message:

2\> if the *ue-Identity* included in the *PagingRecord* in the *Paging* message matches the UE identity in *sl-PagingIdentityRemoteUE* included in *sl-PagingInfo-RemoteUE* received in *RemoteUEInformationSidelink* message from a L2 U2N Remote UE:

3\> inititate the Uu Message transfer in sidelink to that UE as specified in 5.8.9.9;

### 5.3.3 RRC connection establishment

#### 5.3.3.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCSetupRequest [ac];
u<-n: RRCSetup [ac];
u->n: RRCSetupComplete [ac];
|||;
~~~

Figure 5.3.3.1-1: RRC connection establishment, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCSetupRequest [ac];
u<-n: RRCReject [ac];
|||;
~~~

Figure 5.3.3.1-2: RRC connection establishment, network reject

The purpose of this procedure is to establish an RRC connection. RRC connection establishment involves SRB1 establishment. The procedure is also used to transfer the initial NAS dedicated information/ message from the UE to the network.

The network applies the procedure e.g.as follows:

- When establishing an RRC connection;

- When UE is resuming or re-establishing an RRC connection, and the network is not able to retrieve or verify the UE context. In this case, UE receives *RRCSetup* and responds with *RRCSetupComplete*.

#### 5.3.3.1a Conditions for establishing RRC Connection for NR sidelink communication/discovery/V2X sidelink communication

For NR sidelink communication/discovery, an RRC connection establishment is initiated only in the following cases:

1\> if configured by upper layers to transmit NR sidelink communication and related data is available for transmission:

2\> if the frequency on which the UE is configured to transmit NR sidelink communication is included in *sl-FreqInfoList*/*sl-FreqInfoListSizeExt* within *SIB12* provided by the cell on which the UE camps; and if the valid version of *SIB12* does not include *sl-TxPoolSelectedNormal* for the concerned frequency;

1\> if configured by upper layers to transmit NR sidelink discovery and related data is available for transmission:

2\> if the UE is configured by upper layers to transmit NR sidelink L2 U2N relay discovery messages and *sl-L2U2N-Relay* is included in *SIB12*; or

2\> if the UE is configured by upper layers to transmit NR sidelink L3 U2N relay discovery messages and *sl-L3U2N-RelayDiscovery* is included in *SIB12*; or

2\> if the UE is configured by upper layers to transmit NR sidelink non-relay discovery messages and *sl-NonRelayDiscovery* is included in *SIB12*:

3\> if the frequency on which the UE is configured to transmit NR sidelink discovery is included in *sl-FreqInfoList/sl-FreqInfoListSizeExt* within *SIB12* provided by the cell on which the UE camps; and if the valid version of *SIB12* includes neither *sl-DiscTxPoolSelected* nor *sl-TxPoolSelectedNormal* for the concerned frequency;

For L2 U2N Relay UE in RRC_IDLE, an RRC connection establishment is initiated in the following cases:

1\> if any message is received from a L2 U2N Remote UE via SL-RLC0 as specified in 9.1.1.4 or SL-RLC1 as specified in 9.2.4; or

1\> if *RemoteUEInformationSidelink* containing the *connectionForMP* is received from a L2 U2N Remote UE as specified in 5.8.9.8.3;

For V2X sidelink communication, an RRC connection is initiated only when the conditions specified for V2X sidelink communication in clause 5.3.3.1a of TS 36.331 \[10\] are met.

NOTE: Upper layers initiate an RRC connection (except if the RRC connection is initiated at the L2 U2N Relay UE upon reception of a message from a L2 U2N Remote UE via SL-RLC0 or SL-RLC1). The interaction with NAS is left to UE implementation.

#### 5.3.3.1b Conditions for establishing RRC Connection for NR sidelink Positioning

For NR sidelink positioning an RRC connection is established only in the following cases:

1\> if SL-PRS transmission is triggered:

2\> if the frequency on which the UE is configured to transmit NR sidelink positioning is included in *sl-FreqInfoList* within *SIB23* provided by the cell on which the UE camps; and if the valid version of *SIB23* does not include *sl-PRS-TxPoolSelectedNormal* for the concerned frequency.

#### 5.3.3.2 Initiation

The UE initiates the procedure when upper layers request establishment of an RRC connection while the UE is in RRC_IDLE and it has acquired essential system information, or for sidelink communication as specified in clause 5.3.3.1a.

The UE shall ensure having valid and up to date essential system information as specified in clause 5.2.2.2 before initiating this procedure.

Upon initiation of the procedure, the UE shall:

1\> if the upper layers provide an Access Category and one or more Access Identities upon requesting establishment of an RRC connection:

2\> perform the unified access control procedure as specified in 5.3.14 using the Access Category and Access Identities provided by upper layers;

3\> if the access attempt is barred, the procedure ends;

1\> if the upper layers provide NSAG information and one or more S-NSSAI(s) triggering the access attempt (TS 23.501 \[32\] and TS 24.501 \[23\]):

2\> apply the NSAG with highest NSAG priority among the NSAGs that are included in *SIB1* (i.e., in *FeatureCombination* and/or in *RA-PrioritizationSliceInfo*)*,* and that are associated with the S-NSSAI(s) triggering the access attempt, in the Random Access procedure (TS 38.321 \[3\], clause 5.1);

NOTE: If there are multiple NSAGs with the same highest NAS-provided NSAG priority identified for access attempt as above, it is left to UE implementation to select the NSAG to be applied in the Random Access procedure.

1\> if the UE is acting as L2 U2N Remote UE:

2\> establish a SRAP entity as specified in TS 38.351 \[66\], if no SRAP entity has been established;

2\> apply the specified configuration of SL-RLC0 as specified in 9.1.1.4;

2\> apply the SDAP configuration and PDCP configuration as specified in 9.1.1.2 for SRB0;

1\> else:

2\> apply the default L1 parameter values as specified in corresponding physical layer specifications except for the parameters for which values are provided in *SIB1*;

2\> apply the default MAC Cell Group configuration as specified in 9.2.2;

2\> apply the CCCH configuration as specified in 9.1.1.2;

2\> apply the *timeAlignmentTimerCommon* included in *SIB1*;

1\> start timer T300;

1\> initiate transmission of the *RRCSetupRequest* message in accordance with 5.3.3.3;

#### 5.3.3.3 Actions related to transmission of *RRCSetupRequest* message

The UE shall set the contents of *RRCSetupRequest* message as follows:

1\> set the *ue-Identity* as follows:

2\> if upper layers provide a 5G-S-TMSI:

3\> set the *ue-Identity* to *ng-5G-S-TMSI-Part1*;

2\> else:

3\> draw a 39-bit random value in the range 0..2^39^-1 and set the *ue-Identity* to this value;

NOTE 1: Upper layers provide the *5G-S-TMSI* if the UE is registered in the TA of the current cell.

1\> if the establishment of the RRC connection is the result of release with redirect with *mpsPriorityIndication* (either in NR or E-UTRAN):

2\> set the *establishmentCause* to *mps-PriorityAccess*;

1\> else:

2\> set the *establishmentCause* in accordance with the information received from upper layers;

NOTE 2: In case the L2 U2N Relay UE initiates RRC connection establishment triggered by reception of message from a L2 U2N Remote UE via SL-RLC0 or SL-RLC1 as specified in 5.3.3.1a, the L2 U2N Relay UE sets the *establishmentCause* by implementation, but it can only set the *emergency*, *mps-PriorityAccess*, or *mcs-PriorityAccess* as *establishmentCause* if the same cause value is in the message received from the L2 U2N Remote UE via SL-RLC0.

1\> if *ta-Report* or *ta-ReportATG* is configured with value *enabled* and the UE supports TA reporting:

2\> indicate TA report initiation to lower layers;

The UE shall submit the *RRCSetupRequest* message to lower layers for transmission.

If the UE is an (e)RedCap UE and the (e)RedCap-specific initial downlink BWP is not associated with CD-SSB, the UE may continue cell re-selection related measurements as well as cell re-selection evaluation, otherwise the UE shall continue cell re-selection related measurements as well as cell re-selection evaluation. If the conditions for cell re-selection are fulfilled, the UE shall perform cell re-selection as specified in 5.3.3.6.

NOTE 3: For L2 U2N Remote UE in RRC_IDLE, the cell (re)selection procedure as specified in TS 38.304 \[20\] and relay (re)selection procedure as specified in 5.8.15.3 are performed independently and up to UE implementation to select either a cell or a L2 U2N Relay UE.

#### 5.3.3.4 Reception of the *RRCSetup* by the UE

The UE shall perform the following actions upon reception of the *RRCSetup*:

1\> if the *RRCSetup* is received in response to an *RRCReestablishmentRequest*; or

1\> if the *RRCSetup* is received in response to an *RRCResumeRequest* or *RRCResumeRequest1*:

2\> if the UE is NCR-MT:

3\> indicate to NCR-Fwd to cease forwarding;

2\> if *sdt-MAC-PHY-CG-Config* is configured:

3\> instruct the MAC entity to stop the *cg-SDT-TimeAlignmentTimer*, if it is running;

3\> instruct the MAC entity to start the *timeAlignmentTimer* associated with the PTAG*,* if it is not running;

2\> if *srs-PosRRC-Inactive* is configured:

3\> instruct the MAC entity to stop the *inactivePosSRS-TimeAlignmentTimer*, if it is running;

2\> if *srs-PosRRC-InactiveValidityAreaConfig* is configured:

3\> instruct the MAC entity to stop the *inactivePosSRS-ValidityAreaTAT*, if it is running;

2\> discard any stored UE Inactive AS context and *suspendConfig*;

2\> discard any current AS security context including the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key;

2\> release radio resources for all established RBs except SRB0 and broadcast MRBs, including release of the RLC entities, of the associated PDCP entities and of SDAP;

2\> release the RRC configuration except for the default L1 parameter values, default MAC Cell Group configuration, CCCH configuration and broadcast MRBs;

2\> indicate to upper layers fallback of the RRC connection;

2\> for each application layer measurement configuration with *configForRRC-IdleInactive* absent or not set to *true*:

3\> discard any application layer measurement reports which were not transmitted yet;

3\> inform upper layers about the release of all application layer measurement configurations;

2\> stop timer T380, if running;

1\> perform the cell group configuration procedure in accordance with the received *masterCellGroup* and as specified in 5.3.5.5;

1\> perform the radio bearer configuration procedure in accordance with the received *radioBearerConfig* and as specified in 5.3.5.6;

1\> if stored, discard the cell reselection priority information provided by the *cellReselectionPriorities* or inherited from another RAT;

1\> stop timer T300, T301, T319;

1\> if T319a is running:

2\> stop T319a;

2\> consider SDT procedure is not ongoing;

1\> if T390 is running:

2\> stop timer T390 for all access categories;

2\> perform the actions as specified in 5.3.14.4;

1\> if T302 is running:

2\> stop timer T302;

2\> perform the actions as specified in 5.3.14.4;

1\> stop timer T320, if running;

1\> if the *RRCSetup* is received in response to an *RRCResumeRequest*, *RRCResumeRequest1* or *RRCSetupRequest*:

2\> if T331 is running:

3\> stop timer T331;

3\> perform the actions as specified in 5.7.8.3;

2\> enter RRC_CONNECTED;

2\> stop the cell re-selection procedure;

2\> stop relay (re)selection procedure if any for L2 U2N Remote UE;

1\> consider the current cell to be the PCell;

1\> perform the L2 U2N Remote UE configuration procedure in accordance with the received *sl-L2RemoteUE-Config* as specified in 5.3.5.16;

1\> perform the sidelink dedicated configuration procedure in accordance with the received *sl-ConfigDedicatedNR* as specified in 5.3.5.14;

1\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report*:

2\> if *reconnectCellId* in *VarRLF-Report* is not set after failing to perform reestablishment and if this is the first *RRCSetup* received by the UE after declaring the failure:

3\> if the UE supports RLF-Report for conditional handover and if *choCellId* in *VarRLF-Report* is set:

4\> set *timeUntilReconnection* in *VarRLF-Report* to the time that elapsed since the radio link failure or handover failure experienced in the *failedPCellId* stored in *VarRLF-Report*;

3\> else:

4\> set *timeUntilReconnection* in *VarRLF-Report* to the time that elapsed since the last radio link failure or handover failure;

3\> set *nrReconnectCellId* in *reconnectCellId* in *VarRLF-Report* to the global cell identity and the tracking area code of the PCell;

1\> if the UE supports RLF report for inter-RAT MRO NR as defined in TS 36.306 \[62\], and if the UE has radio link failure or handover failure information available in *VarRLF-Report* of TS 36.331 \[10\] and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report* of TS 36.331 \[10\]:

2\> if *reconnectCellId* in *VarRLF-Report* of TS 36.331\[10\] is not set after failing to perform reestablishment and if this is the first *RRCSetup* received by the UE after declaring the failure:

3\> set *timeUntilReconnection* in *VarRLF-Report* of TS 36.331\[10\] to the time that elapsed since the last radio link failure or handover failure in LTE;

3\> set *nrReconnectCellId* in *reconnectCellId* in *VarRLF-Report* of TS 36.331\[10\] to the global cell identity and the tracking area code of the PCell;

1\> set the content of *RRCSetupComplete* message as follows:

2\> if upper layers provide a 5G-S-TMSI:

3\> if the *RRCSetup* is received in response to an *RRCSetupRequest*:

4\> set the *ng-5G-S-TMSI-Value* to *ng-5G-S-TMSI-Part2*;

3\> else:

4\> set the *ng-5G-S-TMSI-Value* to *ng-5G-S-TMSI*;

2\> if upper layers selected an SNPN or a PLMN and in case of PLMN UE is either allowed or instructed to access the PLMN via a cell for which at least one CAG ID is broadcast:

3\> set the *selectedPLMN-Identity* from the *npn-IdentityInfoList*;

2\> else:

3\> set the *selectedPLMN-Identity* to the PLMN selected by upper layers from the *plmn-IdentityInfoList*;

2\> if upper layers provide the \'Registered AMF\':

3\> include and set the *registeredAMF* as follows:

4\> if the PLMN identity of the \'Registered AMF\' is different from the PLMN selected by the upper layers:

5\> include the *plmnIdentity* in the *registeredAMF* and set it to the value of the PLMN identity in the \'Registered AMF\' received from upper layers;

4\> set the *amf-Identifier* to the value received from upper layers;

3\> include and set the *guami-Type* to the value provided by the upper layers;

2\> if upper layers provide one or more S-NSSAI (see TS 23.003 \[21\]):

3\> include the *s-NSSAI-List* and set the content to the values provided by the upper layers;

2\> if upper layers provide onboarding request indication:

3\> include the *onboardingRequest*;

2\> set the *dedicatedNAS-Message* to include the information received from upper layers;

2\> if connecting as an IAB-node:

3\> include the *iab-NodeIndication*;

2\> else if connecting as a mobile IAB-node:

3\> include the *mobileIAB-NodeIndication*;

2\> if connecting as an NCR-node:

3\> include the *ncr-NodeIndication*;

2\> if the SIB1 contains *idleModeMeasurementsNR* and the UE has NR idle/inactive measurement information concerning cells other than the PCell available in *VarMeasIdleReport*; or

2\> if the SIB1 contains *idleModeMeasurementsEUTRA* and the UE has E-UTRA idle/inactive measurement information available in *VarMeasIdleReport*:

3\> include the *idleMeasAvailable*;

2\> if the UE has logged measurements available for NR and if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*; or

2\> if the UE has logged measurements available for NR and if the current registered SNPN is included in *snpn-ConfigIDList* stored in *VarLogMeasReport*:

3\> include the *logMeasAvailable* in the *RRCSetupComplete* message;

3\> if Bluetooth measurement results are included in the logged measurements the UE has available for NR:

4\> include the *logMeasAvailableBT* in the *RRCSetupComplete* message;

3\> if WLAN measurement results are included in the logged measurements the UE has available for NR:

4\> include the *logMeasAvailableWLAN* in the *RRCSetupComplete* message;

2\> if the *sigLoggedMeasType* in *VarLogMeasReport* is included; or

2\> if the UE is capable of reporting availability of signalling based logged MDT for inter-RAT (i.e. LTE to NR), and if the *sigLoggedMeasType* in *VarLogMeasReport* of TS 36.331 \[10\] is included:

3\> if T330 timer is running (associated to the logged measurement configuration for NR or for LTE):

4\> set *sigLogMeasConfigAvailable* to *true* in the *RRCSetupComplete* message;

3\> else:

4\> if the UE has logged measurements:

5\> set *sigLogMeasConfigAvailable* to *false* in the *RRCSetupComplete* message;

2\> if the UE has connection establishment failure or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the RPLMN is equal to *plmn-Identity* stored in *VarConnEstFailReport* or in at least one of the entries of *VarConnEstFailReportList*; or

2\> if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the current registered SNPN identity is equal to *snpn-identity* stored in *VarConnEstFailReport* or any entry of *VarConnEstFailReportList*:

3\> include *connEstFailInfoAvailable* in the *RRCSetupComplete* message;

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report*, or

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* of TS 36.331 \[10\], and if the UE is capable of cross-RAT RLF reporting and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report* of TS 36.331 \[10\]; or

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarRLF-Report*:

3\> include *rlf-InfoAvailable* in the *RRCSetupComplete* message;

2\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessHO-Report; or*

2\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessHO-Report*:

3\> include *successHO-InfoAvailable* in the *RRCSetupComplete* message;

2\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessPSCell-Report*; or

2\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessPSCell-Report*:

3\> include *successPSCell-InfoAvailable* in the *RRCSetupComplete* message;

2\> if the UE supports storage of mobility history information and the UE has mobility history information available in *VarMobilityHistoryReport*:

3\> include the *mobilityHistoryAvail* in the *RRCSetupComplete* message;

2\> if the UE is configured with at least one application layer measurement with *configForRRC-IdleInactive* set to *true*:

3\> for each application layer measurement configuration with *configForRRC-IdleInactive* set to *true*:

4\> if the RPLMN is not included in *plmn-IdentityList* in *VarAppLayerPLMN-ListConfig*:

5\> forward the *measConfigAppLayerId* and inform upper layers about the release of the application layer measurement configuration;

5\> discard any application layer measurement reports which were not yet submitted to lower layers for transmission;

5\> release the application layer measurement configuration in UE variables *VarAppLayerIdleConfig* and *VarAppLayerPLMN-ListConfig*;

5\> consider itself not to be configured to send application layer measurement report for the *measConfigAppLayerId*;

3\> if at least one stored application layer measurement configuration or application layer measurement report container has not been released:

4\> include *measConfigReportAppLayerAvailable* in the *RRCSetupComplete* message;

2\> if the UE supports uplink RRC message segmentation of *UECapabilityInformation*:

3\> may include the *ul-RRC-Segmentation* in the *RRCSetupComplete* message;

2\> if the *RRCSetup* is received in response to an *RRCResumeRequest*, *RRCResumeRequest1* or *RRCSetupRequest*:

3\> if *speedStateReselectionPars* is configured in the *SIB2*:

4\> include the *mobilityState* in the *RRCSetupComplete* message and set it to the mobility state (as specified in TS 38.304 \[20\]) of the UE just prior to entering RRC_CONNECTED state;

2\> if the SIB1 contains *musim-CapRestrictionAllowed* and the UE capability is restricted for MUSIM operation:

3\> if supported, include the *musim-CapRestrictionInd* in the *RRCSetupComplete* message upon determining it has temporary capability restriction;

2\> if the UE has flight path information available:

3\> include *flightPathInfoAvailable*;

1\> submit the *RRCSetupComplete* message to lower layers for transmission, upon which the procedure ends.

#### 5.3.3.5 Reception of the *RRCReject* by the UE

The UE shall:

1\> perform the actions as specified in 5.3.15;

#### 5.3.3.6 Cell re-selection or cell selection or relay (re)selection while T390, T300 or T302 is running (UE in RRC_IDLE)

The UE shall:

1\> if cell reselection occurs while T300 or T302 is running; or

1\> if relay reselection occurs while T300 is running; or

1\> if cell changes due to relay reselection while T302 is running:

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause \'RRC connection failure\';

1\> else:

2\> if cell selection or reselection occurs while T390 is running; or

2\> cell change due to relay selection or reselection occurs while T390 is running:

3\> stop T390 for all access categories;

3\> perform the actions as specified in 5.3.14.4.

#### 5.3.3.7 T300 expiry

The UE shall:

1\> if timer T300 expires:

2\> reset MAC, release the MAC configuration and re-establish RLC for all RBs that are established (except broadcast MRBs);

2\> if the UE supports RRC Connection Establishment failure with temporary offset and the T300 has expired a consecutive *connEstFailCount* times on the same cell for which *connEstFailureControl* is included in *SIB1*:

3\> for a period as indicated by *connEstFailOffsetValidity*:

4\> use *connEstFailOffset* for the parameter *Qoffsettemp* for the concerned cell when performing cell selection and reselection according to TS 38.304 \[20\] and TS 36.304 \[27\];

NOTE 1: When performing cell selection, if no suitable or acceptable cell can be found, it is up to UE implementation whether to stop using *connEstFailOffset* for the parameter *Qoffsettemp* during *connEstFailOffsetValidity* for the concerned cell.

2\> if the UE supports multiple CEF report:

3\> if the UE is not registered in SNPN and if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* and if the RPLMN is equal to *plmn-identity* in *network-Identity* stored in *VarConnEstFailReport*; or

3\> if the UE is registered in SNPN and if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* and if the registered SNPN identity is not equal to *snpn-identity* in *network-Identity* stored in any entry of *VarConnEstFailReportList*:

4\> if the cell identity of current cell is not equal to the cell identity stored in *measResultFailedCell* in *VarConnEstFailReport* and if the *maxCEFReport-r17* has not been reached:

5\> append the *VarConnEstFailReport* as a new entry in the *VarConnEstFailReportList*;

2\> if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* and if the RPLMN is not equal to *plmn-identity* in *network-Identity* stored in *VarConnEstFailReport*; or

2\> if the UE is registered in SNPN and if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* and if the registered SNPN identity is not equal to *snpn-identity* in *network-Identity* stored in any entry of *VarConnEstFailReportList*:

2\> if the cell identity of current cell is not equal to the cell identity stored in *measResultFailedCell* in *VarConnEstFailReport*:

3\> reset the *numberOfConnFail* to 0;

2\> if the UE supports multiple CEF report and if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReportList* and if the RPLMN is not equal to *plmn-identity* in *network-Identity* stored in any entry of *VarConnEstFailReportList*;or

2\> if the UE supports multiple CEF report and if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReportList* and if the registered SNPN identity is not equal to *snpn-identity* in *network-Identity* stored in any entry of *VarConnEstFailReportList*:

3\> clear the content included in *VarConnEstFailReportList*;

2\> clear the content included in *VarConnEstFailReport* except for the *numberOfConnFail*, if any;

2\> store the following connection establishment failure information in the *VarConnEstFailReport* by setting its fields as follows:

3\> if the UE is not in SNPN access mode:

4\> set the *plmn-Identity* in *network-Identity* to the PLMN selected by upper layers (see TS 24.501 \[23\]) from the PLMN(s) included in the *plmn-IdentityInfoList* in *SIB1*;

3\> else if the UE is in SNPN access mode:

4\> set the *snpn-Identity* in *network-Identity* to include the SNPN identity selected by upper layers (see TS 24.501 \[23\]) from the list of SNPN(s) included in the *npn-IdentityInfoList* in *SIB1*;

3\> set the *measResultFailedCell* to include the global cell identity, tracking area code, the cell level and SS/PBCH block level RSRP, and RSRQ, and SS/PBCH block indexes, of the failed cell based on the available SSB measurements collected up to the moment the UE detected connection establishment failure;

3\> if available, set the *measResultNeighCells*, in order of decreasing ranking-criterion as used for cell re-selection, to include neighbouring cell measurements for at most the following number of neighbouring cells: 6 intra-frequency and 3 inter-frequency neighbours per frequency as well as 3 inter-RAT neighbours, per frequency/ set of frequencies per RAT and according to the following:

4\> for each neighbour cell included, include the optional fields that are available;

NOTE 2: The UE includes the latest results of the available measurements as used for cell reselection evaluation, which are performed in accordance with the performance requirements as specified in TS 38.133 \[14\].

3\> if available, set the *locationInfo* as follows:

4\> if available, set the *commonLocationInfo* to include the detailed location information;

4\> if available, set the *bt-LocationInfo* to include the Bluetooth measurement results, in order of decreasing RSSI for Bluetooth beacons;

4\> if available, set the *wlan-LocationInfo* to include the WLAN measurement results, in order of decreasing RSSI for WLAN APs;

4\> if available, set the *sensor-LocationInfo* to include the sensor measurement results as follows;

5\> if available, include the *sensor-MeasurementInformation*;

5\> if available, include the *sensor-MotionInformation*;

NOTE 3: Which location information related configuration is used by the UE to make the *locationInfo* available for inclusion in the *VarConnEstFailReport* is left to UE implementation.

3\> set *perRAInfoList* to indicate the performed random access procedure related information as specified in 5.7.10.5;

3\> if the *numberOfConnFail* is smaller than 8:

4\> increment the *numberOfConnFail* by 1;

2\> inform upper layers about the failure to establish the RRC connection, upon which the procedure ends;

The UE may discard the connection establishment failure or connection resume failure information, i.e. release the UE variable *VarConnEstFailReport* and the UE variable *VarConnEstFailReportList*, 48 hours after the last connection establishment failure is detected.

The L2 U2N Relay UE either indicates to upper layers (to trigger PC5 unicast link release) or sends *NotificationMessageSidelink* message to the connected L2 U2N Remote UE(s) in accordance with 5.8.9.10.

#### 5.3.3.8 Abortion of RRC connection establishment

If upper layers abort the RRC connection establishment procedure, due to a NAS procedure being aborted as specified in TS 24.501 \[23\], while the UE has not yet entered RRC_CONNECTED, the UE shall:

1\> stop timer T300, if running;

1\> reset MAC, release the MAC configuration and re-establish RLC for all RBs that are established (except broadcast MRBs).

The L2 U2N Relay UE either indicates to upper layers (to trigger PC5 unicast link release) or sends *NotificationMessageSidelink* message to the connected L2 U2N Remote UE(s) in accordance with 5.8.9.10.

The L2 U2N Remote UE indicates to upper layers to trigger PC5 unicast link release with its connected L2 U2N Relay UE.

### 5.3.4 Initial AS security activation

#### 5.3.4.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: SecurityModeCommand [ac];
u->n: SecurityModeComplete [ac];
|||;
~~~

Figure 5.3.4.1-1: Security mode command, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: SecurityModeCommand [ac];
u->n: SecurityModeFailure [ac];
|||;
~~~

Figure 5.3.4.1-2: Security mode command, failure

The purpose of this procedure is to activate AS security upon RRC connection establishment.

#### 5.3.4.2 Initiation

The network initiates the security mode command procedure to a UE in RRC_CONNECTED. Moreover, the network applies the procedure as follows:

- when only SRB1 is established, i.e. prior to establishment of SRB2, multicast MRBs and/ or DRBs.

#### 5.3.4.3 Reception of the *SecurityModeCommand* by the UE

The UE shall:

1\> derive the K~gNB~ key, as specified in TS 33.501 \[11\];

1\> derive the K~RRCint~ key associated with the *integrityProtAlgorithm* indicated in the *SecurityModeCommand* message, as specified in TS 33.501 \[11\];

1\> request lower layers to verify the integrity protection of the *SecurityModeCommand* message, using the algorithm indicated by the *integrityProtAlgorithm* as included in the *SecurityModeCommand* message and the K~RRCint~ key;

1\> if the *SecurityModeCommand* message passes the integrity protection check:

2\> derive the K~RRCenc~ key and the K~UPenc~ key associated with the *cipheringAlgorithm* indicated in the *SecurityModeCommand* message, as specified in TS 33.501 \[11\];

2\> derive the K~UPint~ key associated with the *integrityProtAlgorithm* indicated in the *SecurityModeCommand* message, as specified in TS 33.501 \[11\];

2\> configure lower layers to apply SRB integrity protection using the indicated algorithm and the K~RRCint~ key immediately, i.e. integrity protection shall be applied to all subsequent messages received and sent by the UE, including the *SecurityModeComplete* message;

2\> configure lower layers to apply SRB ciphering using the indicated algorithm, the K~RRCenc~ keyafter completing the procedure, i.e. ciphering shall be applied to all subsequent messages received and sent by the UE, except for the *SecurityModeComplete* message which is sent unciphered;

2\> consider AS security to be activated;

2\> submit the *SecurityModeComplete* message to lower layers for transmission, upon which the procedure ends;

1\> else:

2\> continue using the configuration used prior to the reception of the *SecurityModeCommand* message, i.e. neither apply integrity protection nor ciphering.

2\> submit the *SecurityModeFailure* message to lower layers for transmission, upon which the procedure ends.

### 5.3.5 RRC reconfiguration

#### 5.3.5.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: RRCReconfiguration [ac];
u->n: RRCReconfigurationComplete [ac];
|||;
~~~

Figure 5.3.5.1-1: RRC reconfiguration, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: RRCReconfiguration [ac];
u<->n: RRC connection re-establishment [au];
|||;
~~~

Figure 5.3.5.1-2: RRC reconfiguration, failure

The purpose of this procedure is to modify an RRC connection, e.g. to establish/modify/release RBs/BH RLC channels/Uu Relay RLC channels/PC5 Relay RLC channels, to perform reconfiguration with sync, to setup/modify/release measurements, to add/modify/release SCells and cell groups, to add/modify/release conditional handover configuration, to add/modify/release conditional PSCell change or conditional PSCell addition configuration, to add/modify/release LTM configuration. As part of the procedure, NAS dedicated information may be transferred from the Network to the UE.

RRC reconfiguration to perform reconfiguration with sync includes, but is not limited to, the following cases:

- reconfiguration with sync and security key refresh, involving RA to the PCell/PSCell, MAC reset, refresh of security and re-establishment of RLC and PDCP triggered by explicit indicators;

- reconfiguration with sync but without security key refresh, involving RA to the PCell/PSCell, MAC reset and RLC re-establishment and PDCP data recovery (for AM DRB or AM MRB) triggered by explicit indicators.

- reconfiguration with sync for DAPS and security key refresh, involving RA to the target PCell, establishment of target MAC, and

- for non-DAPS bearer: refresh of security and re-establishment of RLC and PDCP triggered by explicit indicators;

- for DAPS bearer: establishment of RLC for the target PCell, refresh of security and reconfiguration of PDCP to add the ciphering function, the integrity protection function and ROHC function of the target PCell;

- for SRB: refresh of security and establishment of RLC and PDCP for the target PCell;

- reconfiguration with sync for DAPS but without security key refresh, involving RA to the target PCell, establishment of target MAC, and

- for non-DAPS bearer: RLC re-establishment and PDCP data recovery (for AM DRB or AM MRB) triggered by explicit indicators.

- for DAPS bearer: establishment of RLC for target PCell, reconfiguration of PDCP to add the ciphering function, the integrity protection function and ROHC function of the target PCell;

- for SRB: establishment of RLC and PDCP for the target PCell.

- reconfiguration with sync for direct-to-indirect path switch, not involving RA at target side, involving re-establishment of PDCP /PDCP data recovery (for AM DRB) triggered by explicit indicators, and

- reconfiguration with sync for LTM cell switch (without security key refresh), and

- involving or not involving RA to the target LTM candidate SpCell according to a network indication;

- MAC reset;

- depending on a network indication, re-establishment of RLC and PDCP data recovery (for AM DRB).

- reconfiguration with sync for LTM cell switch (without security key refresh), and

- involving or not involving RA to the target LTM candidate SpCell according to a network indication;

- MAC reset;

- depending on a network indication, no re-establishment of RLC.

In (NG)EN-DC and NR-DC, SRB3 can be used for measurement configuration and reporting, for UE assistance (re-)configuration and reporting for power savings, for IP address (re-)configuration and reporting for IAB-nodes, to (re-)configure MAC, RLC, BAP, physical layer and RLF timers and constants of the SCG configuration, to reconfigure PDCP for DRBs associated with the S-K~gNB~ or SRB3, to reconfigure SDAP for DRBs associated with S-K~gNB~ in NGEN-DC and NR-DC, to add/modify/release conditional PSCell change configuration, and (re-)configure the LTM configuration associated with the SCG (only in NR-DC), provided that the (re-)configuration does not require any MN involvement, and to transmit RRC messages between the MN and the UE during fast MCG link recovery. In (NG)EN-DC and NR-DC, only *measConfig*, *radioBearerConfig, conditionalReconfiguration, ltm-Config* (only in NR-DC)*, bap-Config*, *iab-IP-AddressConfigurationList, otherConfig, appLayerMeasConfig* and/or *secondaryCellGroup* are included in *RRCReconfiguration* received via SRB3, except when *RRCReconfiguration* is received within *DLInformationTransferMRDC*.

When a clause of 5.3.5 is executed due to an LTM cell switch execution (i.e., as specified in 5.3.5.18.6) or due to a conditional reconfiguration execution for subsequent CPAC (i.e., as specified in 5.3.5.13.8), every appearance of \"the received\" before *RRCReconfiguration*, before a field name, or before an IE name, refers to the *RRCReconfiguration*, to the field name or to the IE, respectively, that was generated and stored by the UE as specified in 5.3.5.18.6 or 5.3.5.13.8.

#### 5.3.5.2 Initiation

The Network may initiate the RRC reconfiguration procedure to a UE in RRC_CONNECTED. The Network applies the procedure as follows:

- the establishment of RBs (other than SRB1, that is established during RRC connection establishment) is performed only when AS security has been activated;

- the establishment of BH RLC Channels for IAB is performed only when AS security has been activated;

- the configuration of NCR-Fwd is performed only when AS security has been activated;

- the establishment of Uu Relay RLC channels and PC5 Relay RLC channels (other than SL-RLC0 and SL-RLC1) for L2 U2N Relay UE is performed only when AS security has been activated, and the establishment of PC5 Relay RLC channels for L2 U2N Remote UE (other than SL-RLC0 and SL-RLC1) is performed only when AS security has been activated;

- the establishment of PC5 Relay RLC channels for L2 U2U Relay UE and L2 U2U Remote UE is performed only when AS security has been activated;

- the addition of Secondary Cell Group and SCells is performed only when AS security has been activated;

- the *reconfigurationWithSync* is included in *secondaryCellGroup* only when at least one RLC bearer or BH RLC channel is setup in SCG;

- the *reconfigurationWithSync* is included in *masterCellGroup* only when AS security has been activated, and SRB2 with at least one DRB or multicast MRB or, for IAB and NCR, SRB2, are setup and not suspended;

- the *conditionalReconfiguration* for CPC is included only when at least one RLC bearer is setup in SCG;

- the *conditionalReconfiguration* for CHO or CPA is included only when AS security has been activated, and SRB2 with at least one DRB or multicast MRB or, for IAB, SRB2, are setup and not suspended;

- the addition of indirect path for MP is performed only when AS security has been activated;

- the *ltm-Config* for LTM on the MCG is included only when AS security has been activated, and SRB2 with at least one DRB are setup and not suspended;

- the *ltm-Config* for LTM on the SCG is included only when at least one RLC bearer is setup in SCG.

*Editor\'s Note: Coexistance of LTM with other features is addressed during the ASN.1 review or maintainance.*

#### 5.3.5.3 Reception of an *RRCReconfiguration* by the UE

The UE shall perform the following actions upon reception of the *RRCReconfiguration,* upon execution of the conditional reconfiguration (CHO, CPA or CPC), or upon execution of an LTM cell switch:

1\> if the *RRCReconfiguration* is applied due to a conditional reconfiguration execution upon cell selection performed while timer T311 was running, as defined in 5.3.7.3:

2\> remove all the entries within the MCG and the SCG *VarConditionalReconfig*, if any;

1\> if the *RRCReconfiguration* includes the *daps-SourceRelease*:

2\> reset the source MAC and release the source MAC configuration;

2\> for each DAPS bearer:

3\> release the RLC entity or entities as specified in TS 38.322 \[4\], clause 5.1.3, and the associated logical channel for the source SpCell;

3\> reconfigure the PDCP entity to release DAPS as specified in TS 38.323 \[5\];

2\> for each SRB:

3\> release the PDCP entity for the source SpCell;

3\> release the RLC entity as specified in TS 38.322 \[4\], clause 5.1.3, and the associated logical channel for the source SpCell;

2\> release the physical channel configuration for the source SpCell;

2\> discard the keys used in the source SpCell (the K~gNB~ key, the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key), if any;

1\> if the *RRCReconfiguration* is received via other RAT (i.e., inter-RAT handover to NR):

2\> if the *RRCReconfiguration* does not include the *fullConfig* and the UE is connected to 5GC (i.e., delta signalling during intra 5GC handover):

3\> re-use the source RAT SDAP and PDCP configurations if available (i.e., current SDAP/PDCP configurations for all RBs from source E-UTRA RAT prior to the reception of the inter-RAT HO *RRCReconfiguration* message);

1\> else:

2\> if the RRCReconfiguration includes the fullConfig:

3\> perform the full configuration procedure as specified in 5.3.5.11;

1\> if the *RRCReconfiguration* includes the *masterCellGroup*:

2\> perform the cell group configuration for the received *masterCellGroup* according to 5.3.5.5;

1\> if the *RRCReconfiguration* includes the *masterKeyUpdate*:

2\> perform AS security key update procedure as specified in 5.3.5.7;

1\> if the *RRCReconfiguration* includes the *sk-Counter*:

2\> perform security key update procedure as specified in 5.3.5.7;

1\> if the *RRCReconfiguration* includes the *secondaryCellGroup*:

2\> perform the cell group configuration for the SCG according to 5.3.5.5;

1\> if the *RRCReconfiguration* includes the *mrdc-SecondaryCellGroupConfig:*

2\> if the *mrdc-SecondaryCellGroupConfig* is set to *setup*:

3\> if the *mrdc-SecondaryCellGroupConfig* includes *mrdc-ReleaseAndAdd*:

4\> perform MR-DC release as specified in clause 5.3.5.10;

3\> if the received *mrdc-SecondaryCellGroup* is set to *nr-SCG*:

4\> perform the RRC reconfiguration according to 5.3.5.3 for the *RRCReconfiguration* message included in *nr-SCG*;

3\> if the received *mrdc-SecondaryCellGroup* is set to *eutra-SCG*:

4\> perform the RRC connection reconfiguration as specified in TS 36.331 \[10\], clause 5.3.5.3 for the *RRCConnectionReconfiguration* message included in *eutra-SCG*;

2\> else (*mrdc-SecondaryCellGroupConfig* is set to *release*):

3\> perform MR-DC release as specified in clause 5.3.5.10;

1\> if the *RRCReconfiguration* message includes the *radioBearerConfig*:

2\> perform the radio bearer configuration according to 5.3.5.6;

1\> if the *RRCReconfiguration* message includes the *radioBearerConfig2*:

2\> perform the radio bearer configuration according to 5.3.5.6;

1\> if the *RRCReconfiguration* message includes the *measConfig*:

2\> perform the measurement configuration procedure as specified in 5.5.2;

1\> if the *RRCReconfiguration* message includes the *dedicatedNAS-MessageList*:

2\> forward each element of the *dedicatedNAS-MessageList* to upper layers in the same order as listed;

1\> if the *RRCReconfiguration* message includes the *dedicatedSIB1-Delivery*:

2\> perform the action upon reception of *SIB1* as specified in 5.2.2.4.2;

NOTE 0: If this *RRCReconfiguration* is associated to the MCG and includes *reconfigurationWithSync* in *spCellConfig* and *dedicatedSIB1-Delivery*, the UE initiates (if needed) the request to acquire required SIBs, according to clause 5.2.2.3.5, only after the random access procedure or the LTM cell switch execution towards the target SpCell is completed.

1\> if the *RRCReconfiguration* message includes the *dedicatedSystemInformationDelivery*:

2\> perform the action upon reception of System Information as specified in 5.2.2.4;

2\> if all the SIB(s) and/or posSIB(s) requested in *DedicatedSIBRequest* message have been acquired:

3\> stop timer T350, if running;

1\> if the *RRCReconfiguration* message includes the *dedicatedPosSysInfoDelivery*:

2\> perform the action upon reception of the contained posSIB(s), as specified in clause 5.2.2.4.16;

2\> if all the SIB(s) and/or posSIB(s) requested in *DedicatedSIBRequest* message have been acquired:

3\> stop timer T350, if running;

1\> if the *RRCReconfiguration* message includes the *otherConfig*:

2\> perform the other configuration procedure as specified in 5.3.5.9;

1\> if the *RRCReconfiguration* message includes the *bap-Config*:

2\> perform the BAP configuration procedure as specified in 5.3.5.12;

1\> if the *RRCReconfiguration* message includes the *iab-IP-AddressConfigurationList*:

2\> if *iab-IP-AddressToReleaseList* is included:

3\> perform release of IP address as specified in 5.3.5.12a.1.1;

2\> if *iab-IP-AddressToAddModList* is included:

3\> perform IAB IP address addition/update as specified in 5.3.5.12a.1.2;

1\> if the *RRCReconfiguration* message includes the *conditionalReconfiguration*:

2\> perform conditional reconfiguration as specified in 5.3.5.13;

1\> if the *RRCReconfiguration* message includes the *needForGapsConfigNR*:

2\> if *needForGapsConfigNR* is set to *setup*:

3\> consider itself to be configured to provide the measurement gap requirement information of NR target bands;

2\> else:

3\> consider itself not to be configured to provide the measurement gap requirement information of NR target bands;

1\> if the *RRCReconfiguration* message includes the *needForGapNCSG-ConfigNR*:

2\> if *needForGapNCSG-ConfigNR* is set to *setup*:

3\> consider itself to be configured to provide the measurement gap and NCSG requirement information of NR target bands;

2\> else:

3\> consider itself not to be configured to provide the measurement gap and NCSG requirement information of NR target bands;

1\> if the *RRCReconfiguration* message includes the *needForGapNCSG-ConfigEUTRA*:

2\> if *needForGapNCSG-ConfigEUTRA* is set to *setup*:

3\> consider itself to be configured to provide the measurement gap and NCSG requirement information of E‑UTRA target bands;

2\> else:

3\> consider itself not to be configured to provide the measurement gap and NCSG requirement information of E‑UTRA target bands;

1\> if the *RRCReconfiguration* message includes the *onDemandSIB-Request*:

2\> if *onDemandSIB-Request* is set to *setup*:

3\> consider itself to be configured to request SIB(s) or posSIB(s) in RRC_CONNECTED in accordance with clause 5.2.2.3.5;

2\> else:

3\> consider itself not to be configured to request SIB(s) or posSIB(s) in RRC_CONNECTED in accordance with clause 5.2.2.3.5;

3\> stop timer T350, if running;

1\> if the *RRCReconfiguration* message includes the *sl-ConfigDedicatedNR*:

2\> perform the sidelink dedicated configuration procedure as specified in 5.3.5.14;

NOTE 0a: If the *sl-ConfigDedicatedNR* was received embedded within an E-UTRA *RRCConnectionReconfiguration* message, the UE does not build an NR *RRCReconfigurationComplete* message for the received *sl-ConfigDedicatedNR*.

1\> if the *RRCReconfiguration* message includes the *sl-L2RelayUE-Config*:

2\> perform the L2 U2N or U2U Relay UE configuration procedure as specified in 5.3.5.15;

1\> if the *RRCReconfiguration* message includes the *sl-L2RemoteUE-Config*:

2\> perform the L2 U2N or U2U Remote UE configuration procedure as specified in 5.3.5.16;

1\> if the *RRCReconfiguration* message includes the *dedicatedPagingDelivery*:

2\> perform the *Paging* message reception procedure as specified in 5.3.2.3;

1\> if the *RRCReconfiguration* message includes the *sl-ConfigDedicatedEUTRA-Info*:

2\> perform related procedures for V2X sidelink communication in accordance with TS 36.331 \[10\], clause 5.3.10 and clause 5.5.2;

1\> if the *RRCReconfiguration* message includes the *ul-GapFR2-Config*:

2\> perform the FR2 UL gap configuration procedure as specified in 5.3.5.13c;

1\> if the *RRCReconfiguration* message includes the *musim-GapConfig*:

2\> perform the MUSIM gap configuration procedure as specified in 5.3.5.9a;

1\> if *idleInactiveReportAllowed* is not included in the *RRCReconfiguration* message:

2\> for each application layer measurement configuration with *configforRRC-IdleInactive* set to *true*:

3\> forward the *measConfigAppLayerId* and inform upper layers about the release of the application layer measurement configuration;

3\> discard any application layer measurement reports which were not yet submitted to lower layers for transmission;

3\> if stored, release the application layer measurement configuration in UE variables *VarAppLayerIdleConfig* and *VarAppLayerPLMN-ListConfig*;

3\> consider itself not to be configured to send application layer measurement report for the *measConfigAppLayerId*;

1\> if the *RRCReconfiguration* message includes the *appLayerMeasConfig*:

2\> perform the application layer measurement configuration procedure as specified in 5.3.5.13d;

1\> if the *RRCReconfiguration* message includes the *ue-TxTEG-RequestUL-TDOA-Config*:

2\> if *ue-TxTEG-RequestUL-TDOA-Config* is set to *setup*:

3\> perform the UE positioning assistance information procedure as specified in 5.7.14;

2\> else:

3\> release the configuration of UE positioning assistance information;

1\> if the *RRCReconfiguration* message includes the *uav-Config*:

2\> (re)configure the UAV parameters in accordance with the included *uav-Config*;

1\> if the *RRCReconfiguration* message includes the *sl-IndirectPathAddChange*:

2\> perform the SL indirect path specific configuration procedure as specified in 5.3.5.17.2.2;

1\> if the *RRCReconfiguration* message includes the *n3c-IndirectPathAddChange*:

2\> perform configuration procedure for the remote UE part of N3C indirect path as specified in 5.3.5.17.3.2;

1\> if the *RRCReconfiguration* message includes the *n3c-IndirectPathConfigRelay*:

2\> perform the configuration procedure for the relay UE part of N3C indirect path as specified in 5.3.5.17.3.3;

1\> if the *RRCReconfiguration* message includes the *ltm-Config*:

2\> if the *ltm-Config* is set to *setup*:

3\> perform the LTM configuration procedure as specified in 5.3.5.18.1;

2\> else:

3\> perform the LTM configuration release procedure as specified in clause 5.3.5.18.7;

1\> set the content of the *RRCReconfigurationComplete* message as follows:

2\> if the *RRCReconfiguration* includes the *masterCellGroup* containing the *reportUplinkTxDirectCurrent*:

3\> include the *uplinkTxDirectCurrentList* for each MCG serving cell with UL;

3\> include *uplinkDirectCurrentBWP-SUL* for each MCG serving cell configured with SUL carrier, if any, within the *uplinkTxDirectCurrentList*;

2\> if the *RRCReconfiguration* includes the *masterCellGroup* containing the *reportUplinkTxDirectCurrentTwoCarrier*:

3\> include in the *uplinkTxDirectCurrentTwoCarrierList* the list of uplink Tx DC locations for the configured intra-band uplink carrier aggregation in the MCG;

2\> if the *RRCReconfiguration* includes the *masterCellGroup* containing the *reportUplinkTxDirectCurrentMoreCarrier*:

3\> include in the *uplinkTxDirectCurrentMoreCarrierList* the list of uplink Tx DC locations for the configured intra-band uplink carrier aggregation in the MCG;

2\> if the *RRCReconfiguration* includes the *secondaryCellGroup* containing the *reportUplinkTxDirectCurrent*:

3\> include the *uplinkTxDirectCurrentList* for each SCG serving cell with UL;

3\> include *uplinkDirectCurrentBWP-SUL* for each SCG serving cell configured with SUL carrier, if any, within the *uplinkTxDirectCurrentList*;

2\> if the *RRCReconfiguration* includes the *secondaryCellGroup* containing the *reportUplinkTxDirectCurrentTwoCarrier*:

3\> include in the *uplinkTxDirectCurrentTwoCarrierList* the list of uplink Tx DC locations for the configured intra-band uplink carrier aggregation in the SCG;

2\> if the *RRCReconfiguration* includes the *secondaryCellGroup* containing the *reportUplinkTxDirectCurrentMoreCarrier*:

3\> include in the *uplinkTxDirectCurrentMoreCarrierList* the list of uplink Tx DC locations for the configured intra-band uplink carrier aggregation in the SCG;

NOTE 0b: The UE does not expect that the *reportUplinkTxDirectCurrentTwoCarrier* or *reportUplinkTxDirectCurrentMoreCarrier* is received in both *masterCellGroup* and in *secondaryCellGroup*. Network only configures at most one of *reportUplinkTxDirectCurrent, reportUplinkTxDirectCurrentTwoCarrier* or *reportUplinkTxDirectCurrentMoreCarrier* in one RRC message*.*

2\> if the *RRCReconfiguration* message includes the *mrdc-SecondaryCellGroupConfig* with *mrdc-SecondaryCellGroup* set to *eutra-SCG*:

3\> include in the *eutra-SCG-Response* the E-UTRA *RRCConnectionReconfigurationComplete* message in accordance with TS 36.331 \[10\] clause 5.3.5.3;

2\> if the *RRCReconfiguration* message includes the *mrdc-SecondaryCellGroupConfig* with *mrdc-SecondaryCellGroup* set to *nr-SCG*:

3\> include in the *nr-SCG-Response* the SCG *RRCReconfigurationComplete* message;

3\> if the *RRCReconfiguration* message is applied due to conditional reconfiguration execution and the *RRCReconfiguration* message does not include the *reconfigurationWithSync* in the *masterCellGroup*:

4\> include in the *selectedCondRRCReconfig* the *condReconfigId* for the selected cell of conditional reconfiguration execution;

4\> if a new *sk-Counter* value has been selected due to the conditional reconfiguration execution for subsequent CPAC:

5\> include *selectedSK-Counter* and set its value to the selected *sk-Counter* value;

3\> if the *RRCReconfiguration* message is applied due to conditional reconfiguration execution and *condExecutionCondPSCell* is configured for the selected PSCell:

4\> include in the *selectedPSCellForCHO-WithSCG* and set it to the information of the selected PSCell;

2\> if the *RRCReconfiguration* includes the *reconfigurationWithSync* in *spCellConfig* of an MCG:

3\> if the UE has logged measurements available for NR and if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*; or

3\> if the UE has logged measurements available for NR and if the current registered SNPN is included in *snpn-ConfigIDList* stored in the *VarLogMeasReport*:

4\> include the *logMeasAvailable* in the *RRCReconfigurationComplete* message;

4\> if Bluetooth measurement results are included in the logged measurements the UE has available for NR:

5\> include the *logMeasAvailableBT* in the *RRCReconfigurationComplete* message;

4\> if WLAN measurement results are included in the logged measurements the UE has available for NR:

5\> include the *logMeasAvailableWLAN* in the *RRCReconfigurationComplete* message;

3\> if the *sigLoggedMeasType* in *VarLogMeasReport* is included; or

3\> if the UE is capable of reporting availability of signalling based logged MDT for inter-RAT (i.e. LTE to NR), and if the *sigLoggedMeasType* in *VarLogMeasReport* of TS 36.331 \[10\] is included:

4\> if T330 timer is running (associated to the logged measurement configuration for NR or for LTE):

5\> set *sigLogMeasConfigAvailable* to *true* in the *RRCReconfigurationComplete* message;

4\> else:

5\> if the UE has logged measurements:

6\> set *sigLogMeasConfigAvailable* to *false* in the *RRCReconfigurationComplete* message;

3\> if the UE has connection establishment failure or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the RPLMN is equal to *plmn-Identity* stored in *VarConnEstFailReport* or in at least one of the entries of *VarConnEstFailReportList*; or

3\> if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the registered SNPN identity is equal to *snpn-identity* stored in *VarConnEstFailReport* or any entry of *VarConnEstFailReportList*:

4\> include *connEstFailInfoAvailable* in the *RRCReconfigurationComplete* message;

3\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report*; or

3\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* of TS 36.331 \[10\] and if the UE is capable of cross-RAT RLF reporting and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report* of TS 36.331 \[10\]; or

3\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in *VarRLF-Report*:

4\> include *rlf-InfoAvailable* in the *RRCReconfigurationComplete* message;

3\> if the UE was configured with *successHO-Config* when connected to the source PCell; and

3\> if the applied *RRCReconfiguration* is not due to a conditional reconfiguration execution upon cell selection performed while timer T311 was running, as defined in 5.3.7.3:

4\> perform the actions for the successful handover report determination as specified in clause 5.7.10.6, upon successfully completing the Random Access procedure triggered for the *reconfigurationWithSync* in *spCellConfig* of the MCG;

3\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessHO-Report*; or

3\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessHO-Report*:

4\> include *successHO-InfoAvailable* in the *RRCReconfigurationComplete* message;

3\> if the UE supports logging the successful PSCell change or addition information, release *successPSCell-Config* configured by the source PCell, if available;

3\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessPSCell-Report*; or

3\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessPSCell-Report*:

4\> include *successPSCell-InfoAvailable* in the *RRCReconfigurationComplete* message;

2\> if the *RRCReconfiguration* message was received via SRB1, but not within *mrdc-SecondaryCellGroup* or E-UTRA *RRCConnectionReconfiguration* or E-UTRA *RRCConnectionResume*:

3\> if the UE is configured to provide the measurement gap requirement information of NR target bands:

4\> if the *RRCReconfiguration* message includes the *needForGapsConfigNR*; or

4\> if the *NeedForGapsInfoNR* information is changed compared to last time the UE reported this information; or

4\> if the *RRCReconfiguration* message includes the *needForInterruptionConfigNR* and set it to *enabled*; or

4\> if the *needForInterruptionConfigNR* is enabled and the *NeedForInterruptionInfoNR* information is changed compared to last time the UE reported this information:

5\> include the *NeedForGapsInfoNR* and set the contents as follows:

6\> include *intraFreq-needForGap* and set the gap requirement information of intra-frequency measurement for each NR serving cell;

6\> if *requestedTargetBandFilterNR* is configured:

7\> for each supported NR band that is also included in *requestedTargetBandFilterNR*, include an entry in *interFreq-needForGap* and set the gap requirement information for that band;

6\> else:

7\> include an entry in *interFreq-needForGap* and set the corresponding gap requirement information for each supported NR band;

5\> if the *needForInterruptionConfigNR* is enabled:

6\> include the *needForInterruptionInfoNR* and set the contents as follows:

7\> include *intraFreq-needForInterruption* with the same number of entries, and listed in the same order, as in *intraFreq-needForGap*;

7\> for each entry in *intraFreq-needForInterruption*, include *interruptionIndication* and set the interruption requirement information if the corresponding entry in *intraFreq-needForGap* is set to *no-gap;*

7\> include *interFreq-needForInterruption* with the same number of entries, and listed in the same order, as in *interFreq-needForGap*;

7\> for each entry in *interFreq-needForInterruption*, include *interruptionIndication* and set the interruption requirement information if the corresponding entry in *interFreq-needForGap* is set to *no-gap*;

3\> if the UE is configured to provide the measurement gap and NCSG requirement information of NR target bands:

4\> if the *RRCReconfiguration* message includes the *needForGapNCSG-ConfigNR*; or

4\> if the *needForGapNCSG-InfoNR* information is changed compared to last time the UE reported this information:

5\> include the *NeedForGapNCSG-InfoNR* and set the contents as follows:

6\> include *intraFreq-needForNCSG* and set the gap and NCSG requirement information of intra-frequency measurement for each NR serving cell;

6\> if *requestedTargetBandFilterNCSG-NR* is configured:

7\> for each supported NR band included in *requestedTargetBandFilterNCSG-NR*, include an entry in *interFreq-needForNCSG* and set the NCSG requirement information for that band;

6\> else:

7\> include an entry for each supported NR band in *interFreq-needForNCSG* and set the corresponding NCSG requirement information;

3\> if the UE is configured to provide the measurement gap and NCSG requirement information of E‑UTRA target bands:

4\> if the *RRCReconfiguration* message includes the *needForGapNCSG-ConfigEUTRA*; or

4\> if the *needForGapNCSG-InfoEUTRA* information is changed compared to last time the UE reported this information:

5\> include the *NeedForGapNCSG-InfoEUTRA* and set the contents as follows:

6\> if *requestedTargetBandFilterNCSG-EUTRA* is configured, for each supported E-UTRA band included in *requestedTargetBandFilterNCSG-EUTRA*, include an entry in *needForNCSG-EUTRA* and set the NCSG requirement information for that band; otherwise, include an entry for each supported E-UTRA band in *needForNCSG-EUTRA* and set the corresponding NCSG requirement information;

2\> if the UE has flight path information available:

3\> if the UE had not previously provided a flight path information since last entering RRC_CONNECTED state; or

3\> if at least one waypoint was not previously provided since last entering RRC_CONNECTED state is available; or

3\> if at least one upcoming waypoint that was previously provided is being removed; or

3\> if *flightPathUpdateDistanceThr* is configured and for at least one waypoint, the 3D distance between the previously provided location and the new location is more than or equal to the distance threshold configured by *flightPathUpdateDistanceThr*; or

3\> if *flightPathUpdateTimeThr* is configured and for at least one waypoint, the timestamp was not previously provided but is now available, or the time between the previously provided timestamp and the new timestamp, if available, is more than or equal to the time threshold configured by *flightPathUpdateTimeThr*:

4\> include *flightPathInfoAvailable*;

NOTE 0c: If neither *flightPathUpdateDistanceThr* nor *flightPathUpdateTimeThr* is configured, it is up to UE implementation whether to include *flightPathInfoAvailable* when updated flight path information is available.

1\> if the UE is configured with E-UTRA *nr-SecondaryCellGroupConfig* (UE in (NG)EN-DC):

2\> if the *RRCReconfiguration* message was received via E-UTRA SRB1 as specified in TS 36.331 \[10\]; or

2\> if the *RRCReconfiguration* message was received via E-UTRA RRC message *RRCConnectionReconfiguration* within *MobilityFromNRCommand* (handover from NR standalone to (NG)EN-DC);

3\> if the *RRCReconfiguration* is applied due to a conditional reconfiguration execution for CPC which is configured via *conditionalReconfiguration* contained in *nr-SecondaryCellGroupConfig* specified in TS 36.331 \[10\]:

4\> submit the *RRCReconfigurationComplete* message via the E-UTRA MCG embedded in E-UTRA RRC message *ULInformationTransferMRDC* as specified in TS 36.331 \[10\], clause 5.6.2a.

3\> else if the *RRCReconfiguration* message was included in E-UTRA *RRCConnectionResume* message:

4\> submit the *RRCReconfigurationComplete* message via E-UTRA embedded in E-UTRA RRC message *RRCConnectionResumeComplete* as specified in TS 36.331 \[10\], clause 5.3.3.4a;

3\> else:

4\> submit the *RRCReconfigurationComplete* via E-UTRA embedded in E-UTRA RRC message *RRCConnectionReconfigurationComplete* as specified in TS 36.331 \[10\], clause 5.3.5.3/5.3.5.4/5.4.2.3;

3\> if the *scg-State* is not included in the E-UTRA message (*RRCConnectionReconfiguration* or *RRCConnectionResume*) containing the *RRCReconfiguration* message:

4\> perform SCG activation as specified in 5.3.5.13a;

4\> if *reconfigurationWithSync* was included in *spCellConfig* of an SCG:

5\> initiate the Random Access procedure on the PSCell, as specified in TS 38.321 \[3\];

4\> else if the SCG was deactivated before the reception of the E-UTRA RRC message containing the *RRCReconfiguration* message:

5\> if *bfd-and-RLM* was not configured to *true* before the reception of the E-UTRA *RRCConnectionReconfiguration* or *RRCConnectionResume* message containing the *RRCReconfiguration* message or if lower layers indicate that a Random Access procedure is needed for SCG activation:

6\> initiate the Random Access procedure on the SpCell, as specified in TS 38.321 \[3\];

5\> else the procedure ends;

4\> else the procedure ends;

3\> else:

4\> perform SCG deactivation as specified in 5.3.5.13b;

4\> the procedure ends;

2\> if the *RRCReconfiguration* message was received within *nr-SecondaryCellGroupConfig* in *RRCConnectionReconfiguration* message received via SRB3 within *DLInformationTransferMRDC*:

3\> submit the *RRCReconfigurationComplete* via E-UTRA embedded in E-UTRA RRC message *RRCConnectionReconfigurationComplete* as specified in TS 36.331 \[10\], clause 5.3.5.3/5.3.5.4;

3\> if the *scg-State* is not included in the *RRCConnectionReconfiguration*:

4\> if *reconfigurationWithSync* was included in *spCellConfig* of an SCG:

5\> initiate the Random Access procedure on the SpCell, as specified in TS 38.321 \[3\];

4\> else the procedure ends;

3\> else:

4\> perform SCG deactivation as specified in 5.3.5.13b;

4\> the procedure ends;

NOTE 1: The order the UE sends the *RRCConnectionReconfigurationComplete* message and performs the Random Access procedure towards the SCG is left to UE implementation.

2\> else (*RRCReconfiguration* was received via SRB3) but not within *DLInformationTransferMRDC*:

3\> submit the *RRCReconfigurationComplete* message via SRB3 to lower layers for transmission using the new configuration;

NOTE 2: In (NG)EN-DC and NR-DC, in the case *RRCReconfiguration* is received via SRB1 or within *DLInformationTransferMRDC* via SRB3, the random access is triggered by RRC layer itself as there is not necessarily other UL transmission. In the case *RRCReconfiguration* is received via SRB3 but not within *DLInformationTransferMRDC*, the random access is triggered by the MAC layer due to arrival of *RRCReconfigurationComplete*.

1\> else if the *RRCReconfiguration* message was received via SRB1 within the *nr-SCG* within *mrdc-SecondaryCellGroup* (UE in NR-DC, *mrdc-SecondaryCellGroup* was received in *RRCReconfiguration* or *RRCResume* via SRB1):

2\> if the *RRCReconfiguration* is applied due to a conditional reconfiguration execution for CPC which is configured via *conditionalReconfiguration* contained in *nr-SCG* within *mrdc-SecondaryCellGroup*; or

2\> if the *RRCReconfiguration* is applied due to an LTM cell switch execution:

3\> submit the *RRCReconfigurationComplete* message via the NR MCG embedded in NR RRC message *ULInformationTransferMRDC* as specified in clause 5.7.2a.3.

2\> if the *scg-State* is not included in the *RRCReconfiguration* or *RRCResume* message containing the *RRCReconfiguration* message:

3\> perform SCG activation as specified in 5.3.5.13a;

3\> if *reconfigurationWithSync* was included in *spCellConfig* in nr-SCG:

4\> if the *RRCReconfiguration* message is not applied due to an LTM cell switch execution for which lower layer indicate to skip the Random Access procedure:

5\> initiate the Random Access procedure on the PSCell, as specified in TS 38.321 \[3\];

4\> if the UE was configured with *successPSCell-Config* when connected to the source PSCell (for PSCell change) or to the PCell (for PSCell addition or change):

5\> perform the actions for the successful PSCell change or addition report determination as specified in clause 5.7.10.7, upon successfully completing the Random Access procedure triggered for the *reconfigurationWithSync* in *spCellConfig* of the SCG;

3\> else if the SCG was deactivated before the reception of the NR RRC message containing the *RRCReconfiguration* message:

4\> if *bfd-and-RLM* was not configured to *true* before the reception of the *RRCReconfiguration* or *RRCResume* message containing the *RRCReconfiguration* message; or

4\> if lower layers indicate that a Random Access procedure is needed for SCG activation:

5\> initiate the Random Access procedure on the PSCell, as specified in TS 38.321 \[3\];

4\> else the procedure ends;

3\> else the procedure ends;

2\> else

3\> perform SCG deactivation as specified in 5.3.5.13b;

3\> the procedure ends;

NOTE 2a: The order in which the UE sends the *RRCReconfigurationComplete* message and performs the Random Access procedure towards the SCG is left to UE implementation.

1\> else if the *RRCReconfiguration* message was received via SRB3 (UE in NR-DC):

2\> if the *RRCReconfiguration* message was received within *DLInformationTransferMRDC*:

3\> if the *RRCReconfiguration* message was received within the *nr-SCG* within *mrdc-SecondaryCellGroup* (NR SCG RRC Reconfiguration):

4\> if the *scg-State* is not included in the *RRCReconfiguration* message containing the *RRCReconfiguration* message:

5\> if *reconfigurationWithSync* was included in spCellConfig in nr-SCG:

6\> initiate the Random Access procedure on the PSCell, as specified in TS 38.321 \[3\];

6\> if the UE was configured with *successPSCell-Config* by the PCell or by the source PSCell:

7\> perform the actions for the successful PSCell change report determination as specified in clause 5.7.10.7, upon successfully completing the Random Access procedure triggered for the *reconfigurationWithSync* in *spCellConfig* of the SCG;

5\> else:

6\> the procedure ends;

4\> else:

5\> perform SCG deactivation as specified in 5.3.5.13b;

5\> the procedure ends;

3\> else:

4\> if the *RRCReconfiguration* does not include the *mrdc-SecondaryCellGroupConfig*:

5\> if the *RRCReconfiguration* includes the *scg-State*:

6\> perform SCG deactivation as specified in 5.3.5.13b;

4\> submit the *RRCReconfigurationComplete* message via SRB1 to lower layers for transmission using the new configuration;

2\> else:

3\> if the *RRCReconfiguration* includes the *reconfigurationWithSync* in *spCellConfig* for the SCG; and

3\> if the UE was configured with *successPSCell-Config*:

4\> perform the actions for the successful PSCell change report determination as specified in clause 5.7.10.7, upon successfully completing the Random Access procedure triggered for the *reconfigurationWithSync* in *spCellConfig* of the SCG;

3\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessPSCell-Report*; or

3\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessPSCell-Report*:

4\> include *successPSCell-InfoAvailable* in the *RRCReconfigurationComplete* message;

3\> submit the *RRCReconfigurationComplete* message via SRB3 to lower layers for transmission using the new configuration;

1\> else (*RRCReconfiguration* was received via SRB1):

2\> if the UE is in NR-DC and;

2\> if the *RRCReconfiguration* does not include the *mrdc-SecondaryCellGroupConfig*:

3\> if the *RRCReconfiguration* includes the *scg-State*:

4\> perform SCG deactivation as specified in 5.3.5.13b;

3\> else:

4\> perform SCG activation without SN message as specified in 5.3.5.13b1;

2\> if the *reconfigurationWithSync* was included in *spCellConfig* of an MCG:

3\> if *ta-Report* or *ta-ReportATG* is configured with value *enabled* and the UE supports TA reporting:

4\> indicate TA report initiation to lower layers;

2\> submit the *RRCReconfigurationComplete* message via SRB1 to lower layers for transmission using the new configuration;

2\> if this is the first *RRCReconfiguration* message after successful completion of the RRC re-establishment procedure:

3\> resume SRB2, SRB4, DRBs, multicast MRB, and BH RLC channels for IAB-MT, and Uu Relay RLC channels for L2 U2N Relay UE, that are suspended;

1\> if *sl-IndirectPathAddChange* was included in *RRCReconfiguration* message and if SRB1 is configured as split SRB and *pdcp-Duplication* is configured:

2\> when successfully sending *RRCReconfigurationComplete* message via SL indirect path (i.e., PC5 RLC acknowledgement is received from target L2 U2N Relay UE):

3\> stop timer T421;

1\> if *reconfigurationWithSync* was included in *spCellConfig* of an MCG or SCG and when MAC of an NR cell group successfully completes a Random Access procedure triggered above; or,

1\> if *sl-PathSwitchConfig* was included in *reconfigurationWithSync* included in *spCellConfig* of an MCG, and when successfully sending *RRCReconfigurationComplete* message (i.e., PC5 RLC acknowledgement is received from target L2 U2N Relay UE); or,

1\> if *rach-LessHO* was included in *reconfigurationWithSync* included in *spCellConfig* of an MCG, and upon indication from lower layers that the RACH-less handover has been successfully completed; or,

1\> if *reconfigurationWithSync* was included in *spCellConfig* of an MCG or SCG and the *RRCReconfiguration* message is applied due to an LTM cell switch execution and upon an indication from lower layer that the LTM cell switch execution has been successfully completed:

2\> stop timer T304 for that cell group if running;

2\> if *sl-PathSwitchConfig* was included in *reconfigurationWithSync*:

3\> stop timer T420;

3\> release all radio resources, including release of the RLC entities and the MAC configuration at the source side;

3\> reset MAC used in the source cell;

2\> if *rach-LessHO* was included in *reconfigurationWithSync* and *cg-NTN-RACH-Less-Configuration* was configured:

3\> release the uplink grant configured for RACH-less handover in *cg-NTN-RACH-Less-Configuration*;

NOTE 2b: PDCP and SDAP configured by the source prior to the path switch that are reconfigured and re-used by target when delta signalling is used, are not released as part of this procedure.

2\> stop timer T310 for source SpCell if running;

2\> apply the parts of the CSI reporting configuration, the scheduling request configuration and the sounding RS configuration that do not require the UE to know the SFN of the respective target SpCell, if any;

2\> apply the parts of the measurement and the radio resource configuration that require the UE to know the SFN of the respective target SpCell (e.g. measurement gaps, periodic CQI reporting, scheduling request configuration, sounding RS configuration), if any, upon acquiring the SFN of that target SpCell;

2\> for each DRB configured as DAPS bearer, request uplink data switching to the PDCP entity, as specified in TS 38.323 \[5\];

2\> if the *reconfigurationWithSync* was included in *spCellConfig* of an MCG:

3\> if T390 is running:

4\> stop timer T390 for all access categories;

4\> perform the actions as specified in 5.3.14.4.

3\> if T350 is running:

4\> stop timer T350;

3\> if *RRCReconfiguration* does not include *dedicatedSIB1-Delivery* and

3\> if the active downlink BWP, which is indicated by the *firstActiveDownlinkBWP-Id* for the target SpCell of the MCG, has a common search space configured by *searchSpaceSIB1*:

4\> acquire the *SIB1*, which is scheduled as specified in TS 38.213 \[13\], of the target SpCell of the MCG;

4\> upon acquiring *SIB1*, perform the actions specified in clause 5.2.2.4.2;

2\> if the *RRCReconfiguration* message is applied due to a conditional reconfiguration execution and the *subsequentCondReconfig* is included in the entry in *VarConditionalReconfig* containing the *RRCReconfiguration* message:

3\> for each *condReconfigId* included in *condExecutionCondToAddModList* within *subsequentCondReconfig*:

4\> replace within *VarConditionalReconfig* the entry in *condExecutionCond* or *condExecutionCondSCG* with the matching *condReconfigId* value;

2\> if the *reconfigurationWithSync* was included in *spCellConfig* of an MCG; or

2\> if the *reconfigurationWithSync* was included in *spCellConfig* of an SCG and the CPA, CPC, or subsequent CPAC was configured:

3\> remove all the entries in the *condReconfigList* within the MCG and the SCG *VarConditionalReconfig* except for the entries in which *subsequentCondReconfig* is present, if any;

3\> remove all the entries within *VarConditionalReconfiguration* as specified in TS 36.331 \[10\], clause 5.3.5.9.6, if any;

3\> for each *measId* of the MCG *measConfig*, if configured, and for each *measId* of the SCG *measConfig*, if configured, if the associated *reportConfig* has a *reportType* set to *condTriggerConfig*:

4\> if the *reportConfigId* is not associated with any *measId* indicated by the *condExecutionCond* or the *condExecutionCondSCG* in an entry of *condReconfigList* in *VarConditionalReconfig* in which *subsequentCondReconfig* is included:

5\> remove the entry with the matching *reportConfigId* from the *reportConfigList* within the *VarMeasConfig*;

4\> if the associated *measObjectId* is only associated to a *reportConfig* with *reportType* set to *condTriggerConfig*; and

4\> if the *measObjectId* is not associated with any *measId* indicated by the *condExecutionCond* or the *condExecutionCondSCG* in an entry of *condReconfigList* in *VarConditionalReconfig* in which *subsequentCondReconfig* is included:

5\> remove the entry with the matching *measObjectId* from the *measObjectList* within the *VarMeasConfig*;

4\> remove the entry with the matching *measId* from the *measIdList* within the *VarMeasConfig*;

2\> if *reconfigurationWithSync* was included in *masterCellGroup* or *secondaryCellGroup*:

3\> if the UE initiated transmission of a *UEAssistanceInformation* message for the corresponding cell group during the last 1 second, and the UE is still configured to provide the concerned UE assistance information for the corresponding cell group; or

3\> if the *RRCReconfiguration* message is applied due to a conditional reconfiguration execution or an LTM cell switch procedure, and the UE is configured to provide UE assistance information for the corresponding cell group, and the UE has initiated transmission of a *UEAssistanceInformation* message for the corresponding cell group since it was configured to do so in accordance with 5.7.4.2:

4\> initiate transmission of a *UEAssistanceInformation* message for the corresponding cell group in accordance with clause 5.7.4.3 to provide the concerned UE assistance information;

4\> start or restart the prohibit timer (if exists) or the leave without response timer for the MUSIM associated with the concerned UE assistance information with the timer value set to the value in corresponding configuration;

3\> if *SIB12* is provided by the target PCell, and the UE initiated transmission of a *SidelinkUEInformationNR* message indicating a change of NR sidelink communication/discovery related parameters relevant in target PCell (i.e. change of *sl-RxInterestedFreqList* or *sl-TxResourceReqList*) during the last 1 second preceding reception of the *RRCReconfiguration* message including *reconfigurationWithSync* in *spCellConfig* of an MCG; or

3\> if the *RRCReconfiguration* message is applied due to a conditional reconfiguration execution and the UE is capable of NR sidelink communication/discovery and *SIB12* is provided by the target PCell, and the UE has initiated transmission of a *SidelinkUEInformationNR* message since it was configured to do so in accordance with 5.8.3.2:

4\> initiate transmission of the *SidelinkUEInformationNR* message in accordance with 5.8.3.3;

2\> if *reconfigurationWithSync* was included in *masterCellGroup*:

3\> if configured with application layer measurements and if application layer measurement report container has been received from upper layers for which the successful transmission of the message or at least one segment of the message has not been confirmed by lower layers:

4\> re-submit the *MeasurementReportAppLayer* message or all segments of the *MeasurementReportAppLayer* message to lower layers for transmission via SRB4;

2\> if *reconfigurationWithSync* was included in *masterCellGroup* and the target cell provides *SIB21*:

3\> if the UE initiated transmission of an *MBSInterestIndication* message during the last 1 second preceding reception of this *RRCReconfiguration* message; or

3\> if the *RRCReconfiguration* message is applied due to a conditional reconfiguration execution, and the UE has initiated transmission of an *MBSInterestIndication* message after having received this *RRCReconfiguration* message:

4\> initiate transmission of an *MBSInterestIndication* message in accordance with clause 5.9.4;

2\> the procedure ends.

> NOTE 3: The UE is only required to acquire broadcasted *SIB1* if the UE can acquire it without disrupting unicast or MBS multicast data reception, i.e. the broadcast and unicast/MBS multicast beams are quasi co-located.

NOTE 4: The UE sets the content of *UEAssistanceInformation* according to latest configuration (i.e. the configuration after applying the *RRCReconfiguration* message) and latest UE preference. The UE may include more than the concerned UE assistance information within the *UEAssistanceInformation* according to 5.7.4.2. Therefore, the content of *UEAssistanceInformation* message might not be the same as the content of the previous *UEAssistanceInformation* message.

#### 5.3.5.4 Secondary cell group release

The UE shall:

1\> as a result of SCG release triggered by E-UTRA (i.e. (NG)EN-DC case) or NR (i.e. NR-DC case):

2\> reset SCG MAC, if configured;

2\> for each RLC bearer that is part of the SCG configuration:

3\> perform RLC bearer release procedure as specified in 5.3.5.5.3;

2\> for each BH RLC channel that is part of the SCG configuration:

3\> perform BH RLC channel release procedure as specified in 5.3.5.5.10;

2\> release the SCG configuration;

2\> for all application layer measurement configurations that are part of the SCG configuration:

3\> inform upper layers about the release of the application layer measurement configurations;

3\> discard any application layer measurement reports which were not yet submitted to lower layers for transmission;

2\> remove all the entries within the SCG *VarConditionalReconfig*, if any;

2\> if SCG release was triggered by NR (i.e. NR-DC case):

3\> remove all the entries in the *condReconfigList* within the MCG *VarConditionalReconfig* for which the *RRCReconfiguration* within *condRRCReconfig* does not include the *masterCellGroup* with *reconfigurationWithSync* and for which *subsequentCondReconfig* is not present, if any;

2\> else (i.e. EN-DC case):

3\> perform *VarConditionalReconfiguration* CPC removal as specified in TS 36.331 \[10\] clause 5.3.5.9.7;

2\> stop timer T310 for the corresponding SpCell, if running;

2\> stop timer T312 for the corresponding SpCell, if running;

2\> stop timer T304 for the corresponding SpCell, if running.

NOTE: Release of cell group means only release of the lower layer configuration of the cell group but the *RadioBearerConfig* may not be released.

#### 5.3.5.5 Cell Group configuration

##### 5.3.5.5.1 General

The network configures the UE with Master Cell Group (MCG), and zero or one Secondary Cell Group (SCG). In (NG)EN-DC, the MCG is configured as specified in TS 36.331 \[10\], and for NE-DC, the SCG is configured as specified in TS 36.331 \[10\]. The network provides the configuration parameters for a cell group in the *CellGroupConfig* IE.

The UE performs the following actions based on a received *CellGroupConfig* IE:

1\> if the *CellGroupConfig* contains the *spCellConfig* with *reconfigurationWithSync*:

2\> perform Reconfiguration with sync according to 5.3.5.5.2;

2\> resume all suspended radio bearers except the SRBs for the source cell group, and resume SCG transmission for all radio bearers, and resume BH RLC channels and resume SCG transmission for BH RLC channels for IAB-MT, if suspended;

NOTE 1: If the SCG is deactivated, resuming SCG transmission for all radio bearers does not imply that PDCP PDUs can be transmitted or received on SCG RLC bearers.

1\> if the *CellGroupConfig* contains the *rlc-BearerToReleaseList or rlc-BearerToReleaseListExt*:

2\> perform RLC bearer release as specified in 5.3.5.5.3;

1\> if the *CellGroupConfig* contains the *rlc-BearerToAddModList*:

2\> perform the RLC bearer addition/modification as specified in 5.3.5.5.4;

1\> if the *CellGroupConfig* contains the *mac-CellGroupConfig*:

2\> configure the MAC entity of this cell group as specified in 5.3.5.5.5;

1\> if the *CellGroupConfig* contains the *sCellToReleaseList*:

2\> perform SCell release as specified in 5.3.5.5.8;

1\> if the *CellGroupConfig* contains the *spCellConfig*:

2\> configure the SpCell as specified in 5.3.5.5.7;

1\> if the *CellGroupConfig* contains the *sCellToAddModList*:

2\> perform SCell addition/modification as specified in 5.3.5.5.9;

1\> if the *CellGroupConfig* contains the *bh-RLC-ChannelToReleaseList*:

2\> perform BH RLC channel release as specified in 5.3.5.5.10;

1\> if the *CellGroupConfig* contains the *bh-RLC-ChannelToAddModList*:

2\> perform the BH RLC channel addition/modification as specified in 5.3.5.5.11;

1\> if the *CellGroupConfig* contains the *uu-RelayRLC-ChannelToReleaseList*:

2\> perform Uu Relay RLC channel release as specified in 5.3.5.5.12;

1\> if the *CellGroupConfig* contains the *uu-RelayRLC-ChannelToAddModList*:

2\> perform the Uu Relay RLC channel addition/modification as specified in 5.3.5.5.13;

1\> if the *CellGroupConfig* contains the *ncr-FwdConfig*:

2\> perform the NCR-Fwd configuration as specified in 5.3.5.5.14;

1\> if the CellGroupConfig contains the autonomousDenialParameters:

2\> consider itself to be allowed to deny any transmission in a particular UL slot if during the number of slots indicated by *autonomousDenialValidity*, preceding and including this particular slot, it autonomously denied fewer UL slots than indicated by *autonomousDenialSlots* within the same cell group;

NOTE 2: When counting the number of denied UL slots, the UE sums up the denied UL slots across all serving cells within the same cell group. When counting the number of slots indicated by *autonomousDenialValidity*, the UE sums up the UL slots across all serving cells within the same cell group.

NOTE 3: When multiple denied UL slots across all serving cells partially or fully overlap in the time domain, the number of denied UL slots across all serving cells is counted as one denied UL slot, based on the longest slot.

##### 5.3.5.5.2 Reconfiguration with sync

The UE shall perform the following actions to execute a reconfiguration with sync.

1\> if the AS security is not activated, perform the actions upon going to RRC_IDLE as specified in 5.3.11 with the release cause \'*other*\' upon which the procedure ends;

1\> stop timer T430 if running;

1\> if no DAPS bearer is configured:

2\> stop timer T310 for the corresponding SpCell, if running;

1\> if this procedure is executed for the MCG:

2\> if timer T316 is running;

3\> stop timer T316;

3\> if the UE supports RLF-Report for fast MCG recovery procedure:

4\> set the *elapsedTimeT316* in the *VarRLF-Report* to the value of the elapsed time of the timer T316;

4\> set the *pSCellId* to the global cell identity of the PSCell, if available, otherwise to the physical cell identity and carrier frequency of the PSCell;

3\> else:

4\> clear the information included in *VarRLF-Report*, if any;

2\> resume MCG transmission, if suspended.

1\> stop timer T312 for the corresponding SpCell, if running;

1\> if *sl-PathSwitchConfig* is included:

2\> consider the target L2 U2N Relay UE to be the one indicated by the *targetRelayUE-Identity* in the *sl-PathSwitchConfig*;

2\> start timer T420 for the corresponding target L2 U2N Relay UE with the timer value set to *t420*, as included in the *sl-PathSwitchConfig*;

2\> apply the value of the *newUE-Identity* as the C-RNTI;

2\> indicate to upper layer (to trigger the PC5 unicast link establishment) with the target L2 U2N Relay UE indicated by the *targetRelayUE-Identity*;

2\> apply the default configuration of SL-RLC1 as defined in 9.2.4 for SRB1;

1\> else (*sl-PathSwitchConfig* is not included):

2\> if this procedure is executed for the MCG or if this procedure is executed for an SCG not indicated as deactivated in the E-UTRA or NR RRC message in which the *RRCReconfiguration* message is embedded:

3\> start timer T304 for the corresponding SpCell with the timer value set to *t304*, as included in the *reconfigurationWithSync*;

2\> if the *frequencyInfoDL* is included:

3\> consider the target SpCell to be one on the SSB frequency indicated by the *frequencyInfoDL* with a physical cell identity indicated by the *physCellId*;

2\> else:

3\> consider the target SpCell to be one on the SSB frequency of the source SpCell with a physical cell identity indicated by the *physCellId*;

2\> start synchronising to the DL of the target SpCell;

2\> apply the specified BCCH configuration defined in 9.1.1.1 for the target SpCell;

2\> acquire the *MIB* of the target SpCell, which is scheduled as specified in TS 38.213 \[13\];

2\> if *NTN-Config* is configured for the target cell:

3\> start timer T430 with the timer value set to *ntn-UlSyncValidityDuration* from the subframe indicated by *epochTime*, according to the target cell *NTN-Config*;

NOTE 1: The UE should perform the reconfiguration with sync as soon as possible following the reception of the RRC message triggering the reconfiguration with sync, which could be before confirming successful reception (HARQ and ARQ) of this message.

NOTE 2: The UE may omit reading the *MIB* if the UE already has the required timing information, or the timing information is not needed for random access.

NOTE 2a: A UE with DAPS bearer does not monitor for system information updates in the source PCell.

2\> If any DAPS bearer is configured:

3\> create a MAC entity for the target cell group with the same configuration as the MAC entity for the source cell group;

3\> for each DAPS bearer:

4\> establish an RLC entity or entities for the target cell group, with the same configurations as for the source cell group;

4\> establish the logical channel for the target cell group, with the same configurations as for the source cell group;

NOTE 2b: In order to understand if a DAPS bearer is configured, the UE needs to check the presence of the field *daps-Config* within the *RadioBearerConfig* IE received in *radioBearerConfig* or *radioBearerConfig2*.

3\> for each SRB:

4\> establish an RLC entity for the target cell group, with the same configurations as for the source cell group;

4\> establish the logical channel for the target cell group, with the same configurations as for the source cell group;

3\> suspend SRBs for the source cell group;

NOTE 3: Void

3\> apply the value of the *newUE-Identity* as the C-RNTI in the target cell group;

3\> configure lower layers for the target SpCell in accordance with the received s*pCellConfigCommon*;

3\> configure lower layers for the target SpCell in accordance with any additional fields, not covered in the previous, if included in the received *reconfigurationWithSync.*

2\> else:

3\> reset the MAC entity of this cell group;

3\> consider the SCell(s) of this cell group, if configured, that are not included in the *SCellToAddModList* in the *RRCReconfiguration* message, to be in deactivated state;

3\> apply the value of the *newUE-Identity* as the C-RNTI for this cell group;

3\> configure lower layers in accordance with the received s*pCellConfigCommon*;

3\> if *rach-LessHO* is included:

4\> configure lower layers in accordance with *rach-LessHO* for the target SpCell;

3\> configure lower layers in accordance with any additional fields, not covered in the previous, if included in the received *reconfigurationWithSync.*

2\> if the UE is acting as L2 U2N Remote UE at the source side:

3\> indicate upper layer to trigger PC5 unicast link release.

Upon L2 U2N Relay UE receiving *reconfigurationWithSync*, it either indicates to upper layers (to trigger PC5 unicast link release) or sends *NotificationMessageSidelink* message to the connected L2 U2N Remote UE(s) in accordance with 5.8.9.10.

##### 5.3.5.5.3 RLC bearer release

The UE shall:

1\> for each *logicalChannelIdentity/LogicalChannelIdentityExt* value included in the *rlc-BearerToReleaseList/rlc-BearerToReleaseListExt* that is part of the current UE configuration within the same cell group (LCH release); or

1\> for each *logicalChannelIdentity* value that is to be released as the result of an SCG release according to 5.3.5.4:

2\> release the RLC entity or entities as specified in TS 38.322 \[4\], clause 5.1.3;

2\> release the corresponding logical channel.

##### 5.3.5.5.4 RLC bearer addition/modification

For each *RLC-BearerConfig* received in the *rlc-BearerToAddModList* IE the UE shall:

1\> if the UE\'s current configuration contains an RLC bearer with the received *logicalChannelIdentity/LogicalChannelIdentityExt* within the same cell group:

2\> if the RLC bearer is associated with an DAPS bearer, or

2\> if any DAPS bearer is configured and the RLC bearer is associated with an SRB:

3\> reconfigure the RLC entity or entities for the target cell group in accordance with the received *rlc-Config*;

3\> reconfigure the logical channel for the target cell group in accordance with the received *mac-LogicalChannelConfig*;

2\> else:

3\> if *reestablishRLC* is received:

4\> re-establish the RLC entity as specified in TS 38.322 \[4\];

3\> reconfigure the RLC entity or entities in accordance with the received *rlc-Config*;

3\> reconfigure the logical channel in accordance with the received *mac-LogicalChannelConfig*;

3\> if *servedMBS-RadioBearer* is received:

4\> associate this logical channel with the PDCP entity identified by *servedMBS-RadioBearer*;

NOTE 1: For DRB and SRB, the network does not re-associate an already configured logical channel with another radio bearer. Hence, *servedRadioBearer* is not present in this case. For MRB, the network does not re-associate an already configured logical channel with DRB or SRB or another MRB (i.e. MRB with another PDCP entity). Hence *multicastRLC-BearerConfig* is not present in this case. If a radio bearer is released and another is added with the same radio bearer identity, it is considered as a new (different) radio bearer. Hence, the network also releases the RLC bearer(s) associated with the released radio bearer.

NOTE 2: In DAPS handover, the UE may perform RLC entity re-establishment (if *reestablishRLC* is set) for an RLC bearer associated with a non-DAPS bearer when indication of successful completion of random access towards target cell is received from lower layers as specified in TS 38.321 \[3\].

1\> else (a logical channel with the given *logicalChannelIdentity/LogicalChannelIdentityExt* is not configured within the same cell group, including the case when full configuration option is used):

2\> if the *servedRadioBearer* associates the logical channel with an SRB and *rlc-Config* is not included:

3\> establish an RLC entity in accordance with the default configuration defined in 9.2 for the corresponding SRB;

2\> else:

3\> establish an RLC entity in accordance with the received *rlc-Config*;

2\> if the *servedRadioBearer* associates the logical channel with an SRB and if *mac-LogicalChannelConfig* is not included:

3\> configure this MAC entity with a logical channel in accordance to the default configuration defined in 9.2 for the corresponding SRB;

2\> else:

3\> configure this MAC entity with a logical channel in accordance to the received *mac-LogicalChannelConfig*;

2\> associate this logical channel with the PDCP entity identified by *servedRadioBearer* or *servedMBS-RadioBearer*.

##### 5.3.5.5.5 MAC entity configuration

The UE shall:

1\> if SCG MAC is not part of the current UE configuration (i.e. SCG establishment):

2\> create an SCG MAC entity;

1\> if any DAPS bearer is configured:

2\> reconfigure the MAC main configuration for the target cell group in accordance with the received *mac-CellGroupConfig* excluding *tag-ToReleaseList* and *tag-ToAddModList*;

1\> else:

2\> reconfigure the MAC main configuration of the cell group in accordance with the received *mac-CellGroupConfig* excluding *tag-ToReleaseList* and *tag-ToAddModList*;

1\> if the received *mac-CellGroupConfig* includes the *tag-ToReleaseList*:

2\> for each *TAG-Id* value included in the *tag-ToReleaseList* that is part of the current UE configuration:

3\> release the TAG indicated by *TAG-Id*;

1\> if the received *mac-CellGroupConfig* includes the *tag-ToAddModList*:

2\> for each *tag-Id* value included in *tag-ToAddModList* that is not part of the current UE configuration (TAG addition):

3\> add the TAG, corresponding to the *tag-Id*, in accordance with the received *timeAlignmentTimer*;

2\> for each *tag-Id* value included in *tag-ToAddModList* that is part of the current UE configuration (TAG modification):

3\> reconfigure the TAG, corresponding to the *tag-Id*, in accordance with the received *timeAlignmentTimer*.

##### 5.3.5.5.6 RLF Timers & Constants configuration

The UE shall:

1\> if the received *rlf-TimersAndConstants* is set to *release*:

2\> if any DAPS bearer is configured:

3\> use values for timers T301, T310, T311 and constants N310, N311 for the target cell group, as included in *ue-TimersAndConstants* received in *SIB1*;

2\> else:

3\> use values for timers T301, T310, T311 and constants N310, N311, as included in *ue-TimersAndConstants* received in *SIB1*;

1\> else:

2\> if any DAPS bearer is configured:

3\> configure the value of timers and constants for the target cell group in accordance with received *rlf-TimersAndConstants*;

2\> else:

3\> (re-)configure the value of timers and constants in accordance with received *rlf-TimersAndConstants*;

3\> stop timer T310 for this cell group, if running;

3\> stop timer T312 for this cell group, if running;

3\> reset the counters N310 and N311.

##### 5.3.5.5.7 SpCell Configuration

The UE shall:

1\> if the UE is acting as L2 U2N Remote UE and is not configured with MP:

2\> if the *SpCellConfig* contains the *rlf-TimersAndConstants* which is set to *setup*:

3\> use value for timers T311 as received in *rlf-TimersAndConstants*;

2\> else if *rlf-TimersAndConstants* is not configured for this cell group or *SpCellConfig* contains the *rlf-TimersAndConstants* which is set to *release*:

3\> use value for timers T311, as included in *ue-TimersAndConstants* received in *SIB1*;

1\> else

2\> if the *SpCellConfig* contains the *rlf-TimersAndConstants*:

3\> configure the RLF timers and constants for this cell group as specified in 5.3.5.5.6;

2\> else if *rlf-TimersAndConstants* is not configured for this cell group:

3\> if any DAPS bearer is configured:

4\> use values for timers T301, T310, T311 and constants N310, N311 for the target cell group, as included in *ue-TimersAndConstants* received in *SIB1*;

3\> else

4\> use values for timers T301, T310, T311 and constants N310, N311, as included in *ue-TimersAndConstants* received in *SIB1*;

2\> if the *SpCellConfig* contains *spCellConfigDedicated*:

3\> configure the SpCell in accordance with the *spCellConfigDedicated*;

3\> consider the bandwidth part indicated in *firstActiveUplinkBWP-Id*, if included in the *spCellConfigDedicated,* to be the active uplink bandwidth part;

3\> if the *firstActiveDownlinkBWP-Id* is included in the *spCellConfigDedicated*:

4\> if the *SpCellConfig* is included in an *RRCReconfiguration* message contained in an NR or E-UTRA RRC message indicating that the SCG is deactivated:

5\> consider the bandwidth part indicated in *firstActiveDownlinkBWP-Id* to be the bandwidth part for Radio Link Monitoring, Beam Failure Detection and measurements;

4\> else:

5\> consider the bandwith part indicated in *firstActiveDownlinkBWP-Id* to be the active downlink bandwidth part;

3\> if any of the reference signal(s) that are used for radio link monitoring are reconfigured by the received *spCellConfigDedicated*:

4\> stop timer T310 for the corresponding SpCell, if running;

4\> stop timer T312 for the corresponding SpCell, if running;

4\> reset the counters N310 and N311.

1\> if the *SpCellConfig* contains the *lowMobilityEvaluationConnected*:

2\> the UE may perform the evaluation of the low mobility criterion for this cell group as specified in 5.7.13.1;

1\> if the *SpCellConfig* contains the *goodServingCellEvaluationRLM*:

2\> the UE may perform the evaluation of the good serving cell quality criterion for this SpCell as specified in 5.7.13.2;

1\> if the *SpCellConfig* contains the *goodServingCellEvaluationBFD*:

2\> the UE may perform the evaluation of the good serving cell quality criterion for this serving cell as specified in 5.7.13.2;

##### 5.3.5.5.8 SCell Release

The UE shall:

1\> if the release is triggered by reception of the *sCellToReleaseList*:

2\> for each *sCellIndex* value included in the *sCellToReleaseList*:

3\> if the current UE configuration includes an SCell with value *sCellIndex*:

4\> release the SCell.

##### 5.3.5.5.9 SCell Addition/Modification

The UE shall:

1\> for each *sCellIndex* value included in the *sCellToAddModList* that is not part of the current UE configuration (SCell addition):

2\> add the SCell, corresponding to the *sCellIndex*, in accordance with the *sCellConfigCommon* and *sCellConfigDedicated*;

2\> if the *sCellState* is included:

3\> configure lower layers to consider the SCell to be in activated state;

2\> else:

3\> configure lower layers to consider the SCell to be in deactivated state;

2\> for each *measId* included in the *measIdList* within *VarMeasConfig*:

3\> if SCells are not applicable for the associated measurement; and

3\> if the concerned SCell is included in *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId*:

4\> remove the concerned SCell from *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

2\> if the *SCellConfig* contains the *goodServingCellEvaluationBFD*:

> 3\> the UE may perform the evaluation of the good serving cell quality criterion for this serving cell as specified in 5.7.13.2.

1\> for each *sCellIndex* value included in the *sCellToAddModList* that is part of the current UE configuration (SCell modification):

2\> modify the SCell configuration in accordance with the *sCellConfigDedicated*;

2\> if the *sCellToAddModList* was received in an *RRCReconfiguration* message including *reconfigurationWithSync,* or received in an *RRCResume* message, or received in an *RRCReconfiguration* message including *reconfigurationWithSync* embedded in an *RRCResume* message or embedded in an *RRCReconfiguration* message or embedded in an E-UTRA *RRCConnectionReconfiguration* message or embedded in an E-UTRA *RRCConnectionResume* message, or received in an *RRCReconfiguration* message embedded in an *RRCReconfiguration* message or embedded in an E-UTRA *RRCConnectionReconfiguration* message activating deactivated SCG:

3\> if the *sCellState* is included:

4\> configure lower layers to consider the SCell to be in activated state;

3\> else:

4\> configure lower layers to consider the SCell to be in deactivated state.

2\> if the *SCellConfig* contains the *goodServingCellEvaluationBFD*:

3\> the UE may perform the evaluation of the good serving cell quality criterion for this serving cell as specified in 5.7.13.2.

##### 5.3.5.5.10 BH RLC channel release

The IAB-node shall:

1\> for each *BH-RLC-ChannelID* value included in the *bh-RLC-ChannelToReleaseList* that is part of the current IAB-node configuration within the same cell group (LCH release); or

1\> for each *BH-RLC-ChannelID* value that is to be released as the result of an SCG release according to 5.3.5.4:

2\> release the RLC entity or entities as specified in TS 38.322 \[4\], clause 5.1.3;

2\> release the corresponding logical channel.

##### 5.3.5.5.11 BH RLC channel addition/modification

For each *BH-RLC-ChannelConfig* received in the *bh-RLC-ChannelToAddModList* IE the IAB-node shall:

1\> if the current configuration contains a BH RLC Channel with the received *bh-RLC-ChannelID* within the same cell group:

2\> if *reestablishRLC* is received:

3\> re-establish the RLC entity as specified in TS 38.322 \[4\];

2\> reconfigure the RLC entity or entities in accordance with the received *rlc-Config*;

2\> reconfigure the logical channel in accordance with the received *mac-LogicalChannelConfig*;

1\> else (a backhaul logical channel with the given *BH-RLC-ChannelID* was not configured before within the same cell group):

2\> establish an RLC entity in accordance with the received *rlc-Config*;

2\> configure this MAC entity with a logical channel in accordance to the received *mac-LogicalChannelConfig*.

##### 5.3.5.5.12 Uu Relay RLC channel release

The L2 U2N Relay UE or N3C relay UE shall:

1\> for each *Uu-RelayRLC-ChannelID* value included in the *uu-RelayRLC-ChannelToReleaseList* that is part of the current configuration within the same cell group (LCH release):

2\> release the RLC entity as specified in TS 38.322 \[4\], clause 5.1.3;

2\> release the corresponding logical channel.

##### 5.3.5.5.13 Uu Relay RLC channel addition/modification

For each *Uu-RelayRLC-ChannelConfig* received in the *uu-RelayRLC-ChannelToAddModList* the L2 U2N Relay UE or N3C relay UE shall:

1\> if the current configuration contains a Uu Relay RLC channel with the same *uu-RelayRLC-ChannelID* within the same cell group:

2\> if *reestablishRLC* is received:

3\> re-establish the RLC entity as specified in TS 38.322 \[4\];

2\> reconfigure the RLC entity in accordance with the received *rlc-Config*;

2\> reconfigure the logical channel in accordance with the received *mac-LogicalChannelConfig*;

1\> else (a logical channel with the given *uu-RelayRLC-ChannelID* was not configured before within the same cell group):

2\> establish an RLC entity in accordance with the received *rlc-Config*;

2\> configure this MAC entity with a logical channel in accordance to the received *mac-LogicalChannelConfig*.

##### 5.3.5.5.14 NCR-Fwd configuration

The NCR-MT shall:

1\> if *NCR-FwdConfig* is set to *setup*:

2\> if *NCR-FwdConfig* includes periodic forwarding resource configuration:

3\> indicate to NCR-Fwd to forward in accordance with the configured periodic forwarding resource set(s);

1\> else (*NCR-FwdConfig* is set to *release)*:

2\> release NCR-Fwd configuration;

2\> indicate to NCR-Fwd to cease forwarding.

#### 5.3.5.6 Radio Bearer configuration

##### 5.3.5.6.1 General

The UE shall perform the following actions based on a received *RadioBearerConfig* IE:

1\> if the *RadioBearerConfig* includes the *srb3-ToRelease,* *srb4-ToRelease* or *srb5-ToRelease*:

2\> perform the SRB release as specified in 5.3.5.6.2;

1\> if the *RadioBearerConfig* includes the *srb-ToAddModList* or if any DAPS bearer is configured:

2\> perform the SRB addition or reconfiguration as specified in 5.3.5.6.3;

1\> if the *RadioBearerConfig* includes the *drb-ToReleaseList*:

2\> perform DRB release as specified in 5.3.5.6.4;

1\> if the *RadioBearerConfig* includes the *drb-ToAddModList*:

2\> perform DRB addition or reconfiguration as specified in 5.3.5.6.5;

1\> if the *RadioBearerConfig* includes the *mrb-ToReleaseList*:

2\> perform multicast MRB release as specified in 5.3.5.6.6;

1\> if the *RadioBearerConfig* includes the *mrb-ToAddModList*:

2\> perform multicast MRB addition or reconfiguration as specified in 5.3.5.6.7;

1\> release all SDAP entities established for the PDU sessions, if any, that have no associated DRB as specified in TS 37.324 \[24\] clause 5.1.2, and indicate the release of the user plane resources for PDU Sessions associated with the released SDAP entities to upper layers;

1\> release all SDAP entities established for the MBS multicast sessions, if any, that have no associated multicast MRB as specified in TS 37.324 \[24\] clause 5.1.2, and indicate the release of user plane resources for these MBS multicast sessions to upper layers.

##### 5.3.5.6.2 SRB release

The UE shall:

1\> if *srb3-ToRelease* is included:

2\> release the PDCP entity and the *srb-Identity* of the SRB3;

1\> if *srb4-ToRelease* is included

2\> release the PDCP entity and the *srb-Identity* of the SRB4;

1\> if *srb5-ToRelease* is included:

2\> release the PDCP entity and the *srb-Identity* of the SRB5.

##### 5.3.5.6.3 SRB addition/modification

The UE shall:

1\> If any DAPS bearer is configured, for each SRB:

2\> establish a PDCP entity for the target cell group as specified in TS 38.323 \[5\], with the same configuration as the PDCP entity for the source cell group;

2\> if the *masterKeyUpdate* is received:

3\> configure the PDCP entity with the security algorithms according to securityConfig and apply the keys (K~RRCenc~ and K~RRCint~) associated with the master key (K~gNB~);

2\> else:

3\> configure the PDCP entity for the target cell group with state variables continuation as specified in TS 38.323 \[5\], and with the same security configuration as the PDCP entity for the source cell group;

1\> for each *srb-Identity* value included in the *srb-ToAddModList* that is not part of the current UE configuration (SRB establishment or reconfiguration from E-UTRA PDCP to NR PDCP):

2\> establish a PDCP entity;

2\> if AS security has been activated:

3\> if target RAT of handover is E-UTRA/5GC; or

3\> if the UE is connected to E-UTRA/5GC:

4\> if the UE is capable of E-UTRA/5GC, but not capable of NGEN-DC:

5\> configure the PDCP entity with the security algorithms and keys (K~RRCenc~ and K~RRCint~) configured/derived as specified in TS 36.331 \[10\];

4\> else (i.e., UE capable of NGEN-DC):

5\> configure the PDCP entity with the security algorithms according to *securityConfig* and apply the keys (K~RRCenc~ and K~RRCint~) associated with the master key (K~eNB~) or secondary key (S-K~gNB~) as indicated in *keyToUse*, if applicable;

3\> else (i.e., UE connected to NR or UE connected to E-UTRA/EPC):

4\> configure the PDCP entity with the security algorithms according to *securityConfig* and apply the keys (K~RRCenc~ and K~RRCint~) associated with the master key (K~eNB~/ K~gNB~) or secondary key (S-K~gNB~) as indicated in *keyToUse*, if applicable;

2\> if the current UE configuration as configured by E-UTRA in TS 36.331 \[10\] includes an SRB identified with the same *srb-Identity* value:

3\> associate the E-UTRA RLC entity and DCCH of this SRB with the NR PDCP entity;

3\> release the E-UTRA PDCP entity of this SRB;

2\> if the *pdcp-Config* is included:

3\> configure the PDCP entity in accordance with the received *pdcp-Config*;

2\> else:

3\> configure the PDCP entity in accordance with the default configuration defined in 9.2.1 for the corresponding SRB;

1\> if any DAPS bearer is configured, for each *srb-Identity* value included in the *srb-ToAddModList* that is part of the current UE configuration:

2\> if the *pdcp-Config* is included:

3\> reconfigure the PDCP entity for the target cell group in accordance with the received *pdcp-Config*;

1\> else, for each *srb-Identity* value included in the *srb-ToAddModList* that is part of the current UE configuration:

2\> if the *reestablishPDCP* is set:

3\> if target RAT of handover is E-UTRA/5GC; or

3\> if the UE is connected to E-UTRA/5GC:

4\> if the UE is capable of E-UTRA/5GC, but not capable of NGEN-DC:

5\> configure the PDCP entity to apply the integrity protection algorithm and K~RRCint~ key configured/derived as specified in TS 36.331 \[10\], i.e. the integrity protection configuration shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

5\> configure the PDCP entity to apply the ciphering algorithm and K~RRCenc~ key configured/derived as specified in TS 36.331 \[10\], i.e. the ciphering configuration shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

4\> else (i.e., a UE capable of NGEN-DC):

5\> configure the PDCP entity to apply the integrity protection algorithm and K~RRCint~ key associated with the master key (K~eNB~) or secondary key (S-K~gNB~), as indicated in *keyToUse*, i.e. the integrity protection configuration shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

5\> configure the PDCP entity to apply the ciphering algorithm and K~RRCenc~ key associated with the master key (K~eNB~) or secondary key (S-K~gNB~) as indicated in *keyToUse*, i.e. the ciphering configuration shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

3\> else (i.e., UE connected to NR or UE in EN-DC):

4\> configure the PDCP entity to apply the integrity protection algorithm and K~RRCint~ key associated with the master key (K~eNB~/K~gNB~) or secondary key (S-K~gNB~), as indicated in *keyToUse* , i.e. the integrity protection configuration shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

4\> configure the PDCP entity to apply the ciphering algorithm and K~RRCenc~ key associated with the master key (K~eNB~/K~gNB~) or secondary key (S-K~gNB~) as indicated in *keyToUse*, i.e. the ciphering configuration shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

3\> re-establish the PDCP entity of this SRB as specified in TS 38.323 \[5\];

2\> else, if the *discardOnPDCP* is set:

3\> trigger the PDCP entity to perform SDU discard as specified in TS 38.323 \[5\];

2\> if the *pdcp-Config* is included:

3\> reconfigure the PDCP entity in accordance with the received *pdcp-Config*.

##### 5.3.5.6.4 DRB release

The UE shall:

1\> for each *drb-Identity* value included in the *drb-ToReleaseList* that is part of the current UE configuration; or

1\> for each *drb-Identity* value that is to be released as the result of full configuration according to 5.3.5.11:

2\> release the PDCP entity and the *drb-Identity*;

2\> if SDAP entity associated with this DRB is configured:

3\> indicate the release of the DRB to SDAP entity associated with this DRB (TS 37.324 \[24\], clause 5.3.3);

2\> if the DRB is associated with an *eps-BearerIdentity*:

3\> if a new bearer is not added either with NR or E-UTRA with same *eps-BearerIdentity*:

4\> indicate the release of the DRB and the *eps-BearerIdentity* of the released DRB to upper layers.

NOTE 1: The UE does not consider the message as erroneous if the *drb-ToReleaseList* includes any *drb-Identity* value that is not part of the current UE configuration.

NOTE 2: Whether or not the RLC and MAC entities associated with this PDCP entity are reset or released is determined by the *CellGroupConfig*.

##### 5.3.5.6.5 DRB addition/modification

The UE shall:

1\> for each *drb-Identity* value included in the *drb-ToAddModList* that is not part of the current UE configuration (DRB establishment including the case when full configuration option is used):

2\> establish a PDCP entity and configure it in accordance with the received *pdcp-Config*;

2\> if the PDCP entity of this DRB is not configured with *cipheringDisabled:*

3\> if target RAT of handover is E-UTRA/5GC; or

3\> if the UE is connected to E-UTRA/5GC:

4\> if the UE is capable of E-UTRA/5GC but not capable of NGEN-DC:

5\> configure the PDCP entity with the ciphering algorithm and K~UPenc~ key configured/derived as specified in TS 36.331 \[10\];

4\> else (i.e., a UE capable of NGEN-DC):

5\> configure the PDCP entity with the ciphering algorithms according to *securityConfig* and apply the key (K~UPenc~) associated with the master key (K~eNB~) or secondary key (S-K~gNB~) as indicated in *keyToUse*, if applicable;

3\> else (i.e., UE connected to NR or UE connected to E-UTRA/EPC):

4\> configure the PDCP entity with the ciphering algorithms according to *securityConfig* and apply the K~UPenc~ key associated with the master key (K~eNB~/K~gNB~) or the secondary key (S-K~gNB~/S-K~eNB~) as indicated in keyToUse;

2\> if the PDCP entity of this DRB is configured with *integrityProtection*:

3\> configure the PDCP entity with the integrity protection algorithms according to *securityConfig* and apply the K~UPint~ key associated with the master (K~eNB~/K~gNB~) or the secondary key (S-K~gNB~) as indicated in *keyToUse*;

2\> if an *sdap-Config* is included:

3\> if an SDAP entity with the received *pdu-Session* does not exist:

4\> establish an SDAP entity as specified in TS 37.324 \[24\] clause 5.1.1;

4\> if an SDAP entity with the received *pdu-Session* did not exist prior to receiving this reconfiguration:

5\> indicate the establishment of the user plane resources for the *pdu-Session* to upper layers;

3\> configure the SDAP entity in accordance with the received *sdap-Config* as specified in TS 37.324 \[24\] and associate the DRB with the SDAP entity;

3\> for each QFI value added in *mappedQoS-FlowsToAdd*, if the QFI value is previously configured, the QFI value is released from the old DRB;

2\> if the DRB is associated with an *eps-BearerIdentity*:

3\> if the DRB was configured with the same *eps-BearerIdentity* either by NR or E-UTRA prior to receiving this reconfiguration:

4\> associate the established DRB with the corresponding *eps-BearerIdentity;*

3\> else:

4\> indicate the establishment of the DRB(s) and the *eps-BearerIdentity* of the established DRB(s) to upper layers;

1\> for each *drb-Identity* value included in the *drb-ToAddModList* that is part of the current UE configuration and configured as DAPS bearer:

2\> reconfigure the PDCP entity to configure DAPS with the ciphering function, integrity protection function and ROHC function of the target cell group as specified in TS 38.323 \[5\] and configure it in accordance with the received *pdcp-Config*;

2\> if the *masterKeyUpdate* is received:

3\> if the ciphering function of the target cell group PDCP entity is not configured with *cipheringDisabled:*

4\> configure the ciphering function of the target cell group PDCP entity with the ciphering algorithm according to *securityConfig* and apply the K~UPenc~ key associated with the master key (K~gNB~), as indicated in *keyToUse*, i.e. the ciphering configuration shall be applied to all subsequent PDCP PDUs received from the target cell group and sent to the target cell group by the UE;

3\> if the integrity protection function of the target cell group PDCP entity is configured with *integrityProtection*:

4\> configure the integrity protection function of the target cell group PDCP entity with the integrity protection algorithms according to *securityConfig* and apply the K~UPint~ key associated with the master key (K~gNB~) as indicated in *keyToUse*;

2\> else:

3\> configure the ciphering function and the integrity protection function of the target cell group PDCP entity with the same security configuration as the PDCP entity for the source cell group;

2\> if the *sdap-Config* is included and when indication of successful completion of random access towards target cell is received from lower layers as specified in \[3\]:

3\> reconfigure the SDAP entity in accordance with the received *sdap-Config* as specified in TS 37.324 \[24\];

3\> for each QFI value added in *mappedQoS-FlowsToAdd*, if the QFI value is previously configured, the QFI value is released from the old DRB;

1\> for each *drb-Identity* value included in the *drb-ToAddModList* that is part of the current UE configuration and not configured as DAPS bearer:

2\> if the *reestablishPDCP* is set:

3\> if target RAT of handover is E-UTRA/5GC; or

3\> if the UE is connected to E-UTRA/5GC:

4\> if the UE is capable of E-UTRA/5GC but not capable of NGEN-DC:

5\> if the PDCP entity of this DRB is not configured with *cipheringDisabled:*

6\> configure the PDCP entity with the ciphering algorithm and K~UPenc~ key configured/derived as specified in TS 36.331 \[10\], clause 5.4.2.3, i.e. the ciphering configuration shall be applied to all subsequent PDCP PDUs received and sent by the UE;

4\> else (i.e., a UE capable of NGEN-DC):

5\> if the PDCP entity of this DRB is not configured with *cipheringDisabled*:

6\> configure the PDCP entity with the ciphering algorithm and K~UPenc~ key associated with the master key (K~eNB~) or the secondary key (S-K~gNB~), as indicated in *keyToUse*, i.e. the ciphering configuration shall be applied to all subsequent PDCP PDUs received and sent by the UE;

3\> else (i.e., UE connected to NR or UE connected to E-UTRA/EPC (in EN-DC or capable of EN-DC)):

4\> if the PDCP entity of this DRB is not configured with *cipheringDisabled:*

5\> configure the PDCP entity with the ciphering algorithm and K~UPenc~ key associated with the master key (K~eNB~/ K~gNB~) or the secondary key (S-K~gNB~/S-K~eNB~), as indicated in *keyToUse*, i.e. the ciphering configuration shall be applied to all subsequent PDCP PDUs received and sent by the UE;

4\> if the PDCP entity of this DRB is configured with *integrityProtection*:

5\> configure the PDCP entity with the integrity protection algorithms according to *securityConfig* and apply the K~UPint~ key associated with the master key (K~eNB~/K~gNB~) or the secondary key (S-K~gNB~) as indicated in *keyToUse*;

3\> if *drb-ContinueROHC* is included in *pdcp-Config*:

4\> indicate to lower layer that *drb-ContinueROHC* is configured;

3\> if *drb-ContinueEHC-DL* is included in *pdcp-Config*:

4\> indicate to lower layer that *drb-ContinueEHC-DL* is configured;

3\> if *drb-ContinueEHC-UL* is included in *pdcp-Config*:

4\> indicate to lower layer that *drb-ContinueEHC-UL* is configured;

3\> if *drb-ContinueUDC* is included in *pdcp-Config*:

4\> indicate to lower layer that *drb-ContinueUDC* is configured;

3\> re-establish the PDCP entity of this DRB as specified in TS 38.323 \[5\], clause 5.1.2;

2\> else, if the *recoverPDCP* is set:

3\> trigger the PDCP entity of this DRB to perform data recovery as specified in TS 38.323 \[5\];

2\> if the *pdcp-Config* is included:

3\> reconfigure the PDCP entity in accordance with the received *pdcp-Config*.

2\> if the *sdap-Config* is included:

3\> reconfigure the SDAP entity in accordance with the received *sdap-Config* as specified in TS37.324 \[24\];

3\> for each QFI value added in *mappedQoS-FlowsToAdd*, if the QFI value is previously configured, the QFI value is released from the old DRB;

NOTE 1: Void.

NOTE 2: When determining whether a *drb-Identity* value is part of the current UE configuration, the UE does not distinguish which *RadioBearerConfig* and *DRB-ToAddModList* that DRB was originally configured in. To re-associate a DRB with a different key (K~eNB~ to S-K~gNB~, K~gNB~ to S-K~eNB~, K~gNB~ to S-K~gNB~, or vice versa), the network provides the *drb-Identity* value in the (target) *drb-ToAddModList* and sets the *reestablishPDCP* flag. The network does not list the *drb-Identity* in the (source) *drb-ToReleaseList*.

NOTE 3: When setting the *reestablishPDCP* flag for a radio bearer, the network ensures that the RLC receiver entities do not deliver old PDCP PDUs to the re-established PDCP entity. It does that e.g. by triggering a reconfiguration with sync of the cell group hosting the old RLC entity or by releasing the old RLC entity.

NOTE 4: In this specification, UE configuration refers to the parameters configured by NR RRC unless otherwise stated.

NOTE 5: Ciphering and integrity protection can be enabled or disabled for a DRB. The enabling/disabling of ciphering or integrity protection can be changed only by releasing and adding the DRB.

NOTE 6: In DAPS handover, the UE may perform PDCP entity re-establishment (if *reestablishPDCP* is set) or the PDCP data recovery (if *recoverPDCP* is set) for a non-DAPS bearer when indication of successful completion of random access towards target cell is received from lower layers as specified in TS 38.321 \[3\]. In this case, the UE suspends data transmission and reception for all non-DAPS bearers in the source MCG for duration of the DAPS handover.

##### 5.3.5.6.6 Multicast MRB release

The UE shall:

1\> for each *mrb-Identity* value included in the *mrb-ToReleaseList* that is part of the current UE configuration; or

1\> for each *mrb-Identity* value that is to be released as the result of full configuration according to 5.3.5.11:

2\> release the PDCP entity and the *mrb-Identity*;

NOTE 1: The UE does not consider the message as erroneous if the *mrb-ToReleaseList* includes any *mrb-Identity* value that is not part of the current UE configuration.

NOTE 2: Whether or not the RLC and MAC entities associated with this PDCP entity are reset or released is determined by the *CellGroupConfig*.

##### 5.3.5.6.7 Multicast MRB addition/modification

The UE shall for each element in the order of entry in the list *mrb-ToAddModList*:

1\> if *mrb-Identity* value included in the *mrb-ToAddModList* is part of the UE configuration:

2\> if *mrb-Identity* value included in the *mrb-ToAddModList* for which *mrb-IdentityNew* is included (i.e., multicast MRB ID change):

3\> update the *mrb-Identity* to the value *mrb-IdentityNew*;

2\> if the *reestablishPDCP* is set:

3\> if *drb-ContinueROHC* is included in *pdcp-Config*:

4\> indicate to lower layer that *drb-ContinueROHC* is configured;

3\> if *drb-ContinueEHC-DL* is included in *pdcp-Config*:

4\> indicate to lower layer that *drb-ContinueEHC-DL* is configured;

3\> re-establish the PDCP entity of this multicast MRB as specified in TS 38.323 \[5\], clause 5.1.2;

2\> else, if the *recoverPDCP* is set:

3\> trigger the PDCP entity of this MRB to perform data recovery as specified in TS 38.323 \[5\];

2\> if the *pdcp-Config* is included:

3\> reconfigure the PDCP entity in accordance with the received *pdcp-Config*;

1\> else if *mrb-Identity* value included in the *mrb-ToAddModList* is not part of the UE configuration (i.e., multicast MRB establishment including the case when full configuration option is used):

2\> establish a PDCP entity and configure it in accordance with the received *pdcp-Config*;

2\> associate the established multicast MRB with the corresponding *mbs-SessionId*;

2\> if an SDAP entity with the received *mbs-SessionId* does not exist:

3\> establish an SDAP entity as specified in TS 37.324 \[24\] clause 5.1.1;

3\> if an SDAP entity with the received *mbs-SessionId* did not exist prior to receiving this reconfiguration:

4\> indicate the establishment of the user plane resources for the *mbs-SessionId* to upper layers.

NOTE 1: When setting the *reestablishPDCP* flag for a radio bearer, the network ensures that the RLC receiver entities do not deliver old PDCP PDUs to the re-established PDCP entity. The network does that e.g. by triggering a reconfiguration with sync of the cell group hosting the old RLC entity or by releasing the old RLC entity.

NOTE 2: In this specification, UE configuration refers to the parameters configured by NR RRC unless otherwise stated.

NOTE 3: When updating the *mrb-Identity*, the network ensures new MRBs are listed at the end of the *mrb-ToAddModList* if they have the same MRB ID as in the existing UE configuration.

#### 5.3.5.7 AS Security key update

The UE shall:

1\> if UE is connected to E-UTRA/EPC or E-UTRA/5GC:

2\> upon reception of *sk-Counter* as specified in TS 36.331 \[10\]:

3\> update the S-K~gNB~ key based on the K~eNB~ key and using the received *sk-Counter* value, as specified in TS 33.401 \[30\] for EN-DC, or TS 33.501 \[11\] for NGEN-DC;

3\> derive the K~RRCenc~ and K~UPenc~ keys as specified in TS 33.401 \[30\] for EN-DC, or TS 33.501 \[11\] for NGEN-DC;

3\> derive the K~RRCint~ and K~UPint~ keys as specified in TS 33.401 \[30\] for EN-DC or TS 33.501 \[11\] for NGEN-DC.

1\> else if this procedure was initiated due to reception of the *masterKeyUpdate*:

2\> if the *nas-Container* is included in the received *masterKeyUpdate*:

3\> forward the *nas-Container* to the upper layers;

2\> if the *keySetChangeIndicator* is set to *true*:

3\> derive or update the K~gNB~ key based on the K~AMF~ key, as specified in TS 33.501 \[11\];

2\> else:

3\> derive or update the K~gNB~ key based on the current K~gNB~ key or the NH, using the *nextHopChainingCount* value indicated in the received *masterKeyUpdate*, as specified in TS 33.501 \[11\];

2\> store the *nextHopChainingCount* value;

2\> derive the keys associated with the K~gNB~ key as follows:

3\> if the *securityAlgorithmConfig* is included in *SecurityConfig*:

4\> derive the K~RRCenc~ and K~UPenc~ keys associated with the *cipheringAlgorithm* indicated in the *securityAlgorithmConfig,* as specified in TS 33.501 \[11\];

4\> derive the K~RRCint~ and K~UPint~ keys associated with the *integrityProtAlgorithm* indicated in the *securityAlgorithmConfig,* as specified in TS 33.501 \[11\];

3\> else:

4\> derive the K~RRCenc~ and K~UPenc~ keys associated with the current *cipheringAlgorithm,* as specified in TS 33.501 \[11\];

4\> derive the K~RRCint~ and K~UPint~ keys associated with the current *integrityProtAlgorithm,* as specified in TS 33.501 \[11\].

NOTE 1: Ciphering and integrity protection are optional to configure for the DRBs.

1\> else if this procedure was initiated due to reception of the *sk-Counter* (UE is in NE-DC, or NR-DC, or is configured with SN terminated bearer(s)) or if the procedure was initiated due to selection of an *sk-Counter* for conditional reconfiguration execution for subsequent CPAC (UE is in NR-DC):

2\> derive or update the secondary key (S-K~gNB~ or S-KeNB) based on the KgNB key and using the received or selected *sk-Counter* value, as specified in TS 33.501 \[11\];

2\> derive the K~RRCenc~ key and the K~UPenc~ key as specified in TS 33.501 \[11\] using the ciphering algorithms indicated in the *RadioBearerConfig* associated with the secondary key (S-K~gNB~ or S-KeNB) as indicated by *keyToUse*;

2\> derive the K~RRCint~ key and the K~UPint~ key as specified in TS 33.501 \[11\] using the integrity protection algorithms indicated in the *RadioBearerConfig* associated with the secondary key (S-K~gNB~ or S-KeNB) as indicated by *keyToUse*;

NOTE 2: If the UE has no radio bearer configured with *keyToUse* set to *secondary* and receives the *sk-Counter* without any *RadioBearerConfig* with *keyToUse* set to *secondary*, the UE does not consider it as an invalid reconfiguration.

#### 5.3.5.8 Reconfiguration failure

##### 5.3.5.8.1 Void

##### 5.3.5.8.2 Inability to comply with *RRCReconfiguration*

NOTE 00: The UE behaviour specified in this clause does not apply to the following, and the UE ignores, i.e. does not take an action on and does not store, the fields that it does not support or does not comprehend:

> \- The fields in *ServingCellConfigCommon* that are defined in Rel-16 and later.
>
> \- The fields of *searchSpaceMCCH* and s*earchSpaceMTCH* in *PDCCH-ConfigCommon* that are defined in Rel-17 and later.

The UE shall:

1\> if the UE is in (NG)EN-DC:

2\> if the UE is unable to comply with (part of) the configuration included in the *RRCReconfiguration* message received over SRB3;

3\> if the *RRCReconfiguration* message was received as part of *ConditionalReconfiguration*:

4\> continue using the configuration used prior to when the inability to comply with the *RRCReconfiguration* message was detected;

3\> else:

4\> continue using the configuration used prior to the reception of *RRCReconfiguration* message;

3\> if MCG transmission is not suspended:

4\> initiate the SCG failure information procedure as specified in clause 5.7.3 to report SCG reconfiguration error, upon which the connection reconfiguration procedure ends;

3\> else:

4\> initiate the connection re-establishment procedure as specified in TS 36.331 \[10\], clause 5.3.7, upon which the connection reconfiguration procedure ends;

2\> else, if the UE is unable to comply with (part of) the configuration included in the *RRCReconfiguration* message received over SRB1;

3\> if the *RRCReconfiguration* message was received as part of *ConditionalReconfiguration*:

4\> continue using the configuration used prior to when the inability to comply with the *RRCReconfiguration* message was detected;

3\> else:

4\> continue using the configuration used prior to the reception of *RRCReconfiguration* message;

3\> initiate the connection re-establishment procedure as specified in TS 36.331 \[10\], clause 5.3.7, upon which the connection reconfiguration procedure ends.

1\> else if *RRCReconfiguration* is received via NR (i.e., NR standalone, NE-DC, or NR-DC):

2\> if the UE is unable to comply with (part of) the configuration included in the *RRCReconfiguration* message received over SRB3;

NOTE 0: This case does not apply in NE-DC.

3\> if the *RRCReconfiguration* message was received as part of *ConditionalReconfiguration*; or,

3\> if the *RRCReconfiguration* message was received as part of *ltm-Config*:

4\> continue using the configuration used prior to when the inability to comply with the *RRCReconfiguration* message was detected;

3\> else:

4\> continue using the configuration used prior to the reception of *RRCReconfiguration* message;

3\> if MCG transmission is not suspended:

4\> initiate the SCG failure information procedure as specified in clause 5.7.3 to report SCG reconfiguration error, upon which the connection reconfiguration procedure ends;

3\> else:

4\> initiate the connection re-establishment procedure as specified in clause 5.3.7, upon which the connection reconfiguration procedure ends;

2\> else if the UE is unable to comply with (part of) the configuration included in the *RRCReconfiguration* message received over the SRB1 or if the upper layers indicate that the *nas-Container* is invalid:

NOTE 0a: The compliance also covers the SCG configuration carried within octet strings e.g. field *mrdc-SecondaryCellGroupConfig*. I.e. the failure behaviour defined also applies in case the UE cannot comply with the embedded SCG configuration or with the combination of (parts of) the MCG and SCG configurations.

NOTE 0b: The compliance also covers the V2X sidelink configuration carried within an octet string, e.g. field *sl-ConfigDedicatedEUTRA*. I.e. the failure behaviour defined also applies in case the UE cannot comply with the embedded V2X sidelink configuration.

3\> if the *RRCReconfiguration* message was received as part of *ConditionalReconfiguration*; or,

3\> if the *RRCReconfiguration* message was received as part of *ltm-Config*:

4\> continue using the configuration used prior to when the inability to comply with the *RRCReconfiguration* message was detected;

3\> else:

4\> continue using the configuration used prior to the reception of *RRCReconfiguration* message;

3\> if AS security has not been activated:

4\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'other\'

3\> else if AS security has been activated but SRB2 and at least one DRB or multicast MRB or, for IAB and NCR, SRB2, have not been setup:

4\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\';

3\> else:

4\> initiate the connection re-establishment procedure as specified in 5.3.7, upon which the reconfiguration procedure ends;

1\> else if *RRCReconfiguration* is received via other RAT (Handover to NR failure):

2\> if the UE is unable to comply with any part of the configuration included in the *RRCReconfiguration* message or if the upper layers indicate that the *nas-Container* is invalid:

3\> perform the actions defined for this failure case as defined in the specifications applicable for the other RAT.

NOTE 1: The UE may apply above failure handling also in case the *RRCReconfiguration* message causes a protocol error for which the generic error handling as defined in clause 10 specifies that the UE shall ignore the message.

NOTE 2: If the UE is unable to comply with part of the configuration, it does not apply any part of the configuration, i.e. there is no partial success/failure.

NOTE 3: It is up to UE implementation whether the compliance check for an *RRCReconfiguration* received as part of *ConditionalReconfiguration* is performed upon the reception of the message or upon CHO, CPA, CPC, and subsequent CPAC execution (when the message is required to be applied).

NOTE 4: It is up to UE implementation whether the compliance check for an *RRCReconfiguration* message received as part of an *LTM-Config* IE is performed upon the reception of the message or during an LTM cell switch procedure (when the message is required to be applied).

##### 5.3.5.8.3 T304 expiry (Reconfiguration with sync Failure) or T420 expiry (Path switch failure)

The UE shall:

1\> if T304 of the MCG expires; or

1\> if T420 expires; or,

1\> if the target L2 U2N Relay UE (i.e., the UE indicated by *targetRelayUE-Identity* in the received *RRCReconfiguration* message containing *reconfigurationWithSync* indicating path switch as specified in 5.3.5.5.2) changes its serving PCell before path switch:

2\> release dedicated preambles provided in *rach-ConfigDedicated* if configured;

2\> release dedicated msgA PUSCH resources provided in *rach-ConfigDedicated* if configured;

2\> if any DAPS bearer is configured, and radio link failure is not detected in the source PCell, according to clause 5.3.10.3:

3\> reset MAC for the target PCell and release the MAC configuration for the target PCell;

3\> for each DAPS bearer:

4\> release the RLC entity or entities as specified in TS 38.322 \[4\], clause 5.1.3, and the associated logical channel for the target PCell;

4\> reconfigure the PDCP entity to release DAPS as specified in TS 38.323 \[5\];

3\> for each SRB:

4\> if the *masterKeyUpdate* was not received:

5\> configure the PDCP entity for the source PCell with state variables continuation as specified in TS 38.323 \[5\];

4\> release the PDCP entity for the target PCell;

4\> release the RLC entity as specified in TS 38.322 \[4\], clause 5.1.3, and the associated logical channel for the target PCell;

4\> trigger the PDCP entity for the source PCell to perform SDU discard as specified in TS 38.323 \[5\];

4\> re-establish the RLC entity for the source PCell;

3\> release the physical channel configuration for the target PCell;

3\> discard the keys used in target PCell (the K~gNB~ key, the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key), if any;

3\> resume suspended SRBs in the source PCell;

3\> for each non-DAPS bearer:

4\> revert back to the UE configuration used for the DRB or multicast MRB in the source PCell, includes PDCP, RLC states variables, the security configuration and the data stored in transmission and reception buffers in PDCP and RLC entities ;

3\> revert back to the UE measurement configuration used in the source PCell;

3\> store the handover failure information in *VarRLF-Report* as described in the clause 5.3.10.5;

3\> initiate the failure information procedure as specified in clause 5.7.5 to report DAPS handover failure.

2\> else:

3\> revert back to the UE configuration used in the source PCell;

3\> if the associated T304 was not initiated upon cell selection performed while timer T311 was running, as defined in clause 5.3.7.3:

4\> store the handover failure information in *VarRLF-Report* as described in the clause 5.3.10.5;

3\> initiate the connection re-establishment procedure as specified in clause 5.3.7.

NOTE 1: In the context above, \"the UE configuration\" includes state variables and parameters of each radio bearer.

1\> else if T304 of a secondary cell group expires:

2\> if MCG transmission is not suspended:

3\> release dedicated preambles provided in *rach-ConfigDedicated,* if configured;

3\> release dedicated msgA PUSCH resources provided in *rach-ConfigDedicated*, if configured;

3\> initiate the SCG failure information procedure as specified in clause 5.7.3 to report SCG reconfiguration with sync failure, upon which the RRC reconfiguration procedure ends;

2\> else:

3\> if the UE is in NR-DC:

4\> initiate the connection re-establishment procedure as specified in clause 5.3.7;

3\> else (the UE is in (NG) EN-DC):

4\> initiate the connection re-establishment procedure as specified in TS 36.331 \[10\], clause 5.3.7;

1\> else if T304 expires when *RRCReconfiguration* is received via other RAT (HO to NR failure):

2\> reset MAC;

2\> perform the actions defined for this failure case as defined in the specifications applicable for the other RAT.

NOTE 2: In this clause, the term \'handover failure\' has been used to refer to \'reconfiguration with sync failure\'.

#### 5.3.5.9 Other configuration

The UE shall:

1\> if the received *otherConfig* includes the *delayBudgetReportingConfig*:

2\> if *delayBudgetReportingConfig* is set to *setup*:

3\> consider itself to be configured to send delay budget reports in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to send delay budget reports and stop timer T342, if running.

1\> if the received *otherConfig* includes the *overheatingAssistanceConfig*:

2\> if *overheatingAssistanceConfig* is set to *setup*:

3\> consider itself to be configured to provide overheating assistance information in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide overheating assistance information and stop timer T345, if running;

1\> if the received *otherConfig* includes the *idc-AssistanceConfig*:

2\> if *idc-AssistanceConfig* is set to *setup*:

3\> consider itself to be configured to provide IDC assistance information in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide IDC assistance information;

1\> if the received *otherConfig* includes the *drx-PreferenceConfig*:

2\> if *drx-PreferenceConfig* is set to *setup*:

3\> consider itself to be configured to provide its preference on DRX parameters for power saving for the cell group in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide its preference on DRX parameters for power saving for the cell group and stop timer T346a associated with the cell group, if running;

1\> if the received *otherConfig* includes the *maxBW-PreferenceConfig*:

2\> if *maxBW-PreferenceConfig* is set to *setup*:

3\> consider itself to be configured to provide its preference on the maximum aggregated bandwidth for power saving for the cell group in accordance with 5.7.4;

3\> if *otherConfig* includes *maxBW-PreferenceConfigFR2-2*:

4\> consider itself to be configured to provide its preference on the maximum aggregated bandwidth for FR2-2 for power saving for the cell group in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide its preference on the maximum aggregated bandwidth for power saving for the cell group and stop timer T346b associated with the cell group, if running;

1\> if the received *otherConfig* includes the *maxCC-PreferenceConfig*:

2\> if *maxCC-PreferenceConfig* is set to *setup*:

3\> consider itself to be configured to provide its preference on the maximum number of secondary component carriers for power saving for the cell group in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide its preference on the maximum number of secondary component carriers for power saving for the cell group and stop timer T346c associated with the cell group, if running;

1\> if the received *otherConfig* includes the *maxMIMO-LayerPreferenceConfig*:

2\> if *maxMIMO-LayerPreferenceConfig* is set to *setup*:

3\> consider itself to be configured to provide its preference on the maximum number of MIMO layers for power saving for the cell group in accordance with 5.7.4;

3\> if *otherConfig* includes *maxMIMO-LayerPreferenceConfigFR2-2*:

4\> consider itself to be configured to provide its preference on the maximum number of MIMO layers for FR2-2 for power saving for the cell group in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide its preference on the maximum number of MIMO layers for power saving for the cell group and stop timer T346d associated with the cell group, if running;

1\> if the received *otherConfig* includes the *minSchedulingOffsetPreferenceConfig*:

2\> if *minSchedulingOffsetPreferenceConfig* is set to *setup*:

3\> consider itself to be configured to provide its preference on the minimum scheduling offset for cross-slot scheduling for power saving for the cell group in accordance with 5.7.4;

3\> if *otherConfig* includes *minSchedulingOffsetPreferenceConfigExt*:

4\> consider itself to be configured to provide its preference on the minimum scheduling offset for 480 kHz SCS and/or 960 kHz SCS for cross-slot scheduling for power saving for the cell group in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide its preference on the minimum scheduling offset for cross-slot scheduling for power saving for the cell group and stop timer T346e associated with the cell group, if running;

1\> if the received *otherConfig* includes the *releasePreferenceConfig*:

2\> if *releasePreferenceConfig* is set to *setup*:

3\> consider itself to be configured to provide assistance information to transition out of RRC_CONNECTED in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide assistance information to transition out of RRC_CONNECTED and stop timer T346f, if running.

1\> if the received *otherConfig* includes the *obtainCommonLocation*:

2\> include available detailed location information for any subsequent measurement report or any subsequent RLF report, *SCGFailureInformation* and successful handover report;

NOTE 1: The UE is requested to attempt to have valid detailed location information available whenever sending a measurement report for which it is configured to include available detailed location information. The UE may not succeed e.g. because the user manually disabled the GPS hardware, due to no/poor satellite coverage. Further details, e.g. regarding when to activate GNSS, are up to UE implementation.

1\> if the received *otherConfig* includes the *btNameList*:

2\> if *btNameList* is set to *setup*, include available Bluetooth measurement results for any subsequent measurement report or any subsequent RLF report and SCGFailureInformation;

1\> if the received *otherConfig* includes the *wlanNameList*:

2\> if *wlanNameList* is set to *setup*, include available WLAN measurement results for any subsequent measurement report or any subsequent RLF report and SCGFailureInformation;

1\> if the received *otherConfig* includes the *sensorNameList*:

2\> if *sensorNameList* is set to *setup*, include available Sensor measurement results for any subsequent measurement report or any subsequent RLF report and SCGFailureInformation;

NOTE 2: The UE is requested to attempt to have valid Bluetooth measurements, WLAN measurements and Sensor measurements whenever sending a measurement report for which it is configured to include these measurements. The UE may not succeed e.g. because the user manually disabled the WLAN or Bluetooth or Sensor hardware. Further details, e.g. regarding when to activate WLAN or Bluetooth or Sensor, are up to UE implementation.

1\> if the received *otherConfig* includes the *sl-AssistanceConfigNR*:

2\> consider itself to be configured to provide configured grant assistance information for NR sidelink communication in accordance with 5.7.4;

1\> if the received *otherConfig* includes the *referenceTimePreferenceReporting*:

2\> consider itself to be configured to provide UE reference time assistance information in accordance with 5.7.4;

1\> else:

2\> consider itself not to be configured to provide UE reference time assistance information;

1\> if the received *otherConfig* includes the *successHO-Config*:

2\> consider itself to be configured to provide the successful handover information in accordance with 5.7.10.6;

1\> else:

2\> consider itself not to be configured to provide the successful handover information.

1\> if the received *otherConfig* includes the *successPSCell-Config*:

2\> if *thresholdPercentageT304-SCG* is included:

3\> consider itself to be configured by the target PSCell to provide the successful PSCell change or addition information in accordance with 5.7.10.7;

2\> else if *sn-InitiatedPSCellChange* is included:

3\> consider itself to be configured by the source PSCell to provide the successful PSCell change or addition information in accordance with 5.7.10.7;

2\> else:

3\> consider itself to be configured by the PCell to provide the successful PSCell change or addition information in accordance with 5.7.10.7;

1\> else:

2\> consider itself not to be configured to provide the successful PSCell change or addition information.

1\> if the received *otherConfig* includes the *ul-GapFR2-PreferenceConfig*:

2\> consider itself to be configured to provide its preference on FR2 UL gap in accordance with 5.7.4;

1\> else:

2\> consider itself not to be configured to provide its preference on FR2 UL gap;

1\> if the received *otherConfig* includes the *musim-GapAssistanceConfig*:

2\> if *musim-GapAssistanceConfig* is set to *setup*:

3\> consider itself to be configured to provide MUSIM assistance information for gap preference in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide MUSIM assistance information for gap preference and stop timer T346h, if running;

1\> if the received *otherConfig* includes the *musim-LeaveAssistanceConfig:*

2\> if *musim-LeaveAssistanceConfig* is set to *setup*:

3\> consider itself to be configured to provide MUSIM assistance information for leaving RRC_CONNECTED in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide MUSIM assistance information for leaving RRC_CONNECTED and stop timer T346g, if running.

1\> if the received *otherConfig* includes the *musim-GapPriorityAssistanceConfig*:

2\> consider itself to be configured to provide MUSIM assistance information for gap(s) priority in accordance with 5.7.4;

1\> else:

2\> consider itself not to be configured to provide MUSIM assistance information for gap(s) priority;

1\> if the received *otherConfig* includes the *musim-CapabilityRestrictionConfig*:

2\> if *musim-CapabilityRestrictionConfig* is set to *setup*:

3\> consider itself to be configured to provide MUSIM assistance information for capability restriction in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide MUSIM assistance information for capability restriction and stop timer T348 and T346n, if running;

1\> if the received *otherConfig* includes the *rlm-RelaxationReportingConfig*:

2\> if *rlm-RelaxationReportingConfig* is set to *setup*:

3\> consider itself to be configured to report the relaxation state of RLM measurements in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to report the relaxation state of RLM measurements and stop timer T346j associated with the cell group, if running;

1\> if the received *otherConfig* includes the *bfd-RelaxationReportingConfig*:

2\> if *bfd-RelaxationReportingConfig* is set to *setup*:

3\> consider itself to be configured to report the relaxation state of BFD measurements in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to report the relaxation state of BFD measurements and stop timer T346k associated with the cell group, if running;

1\> if the received *otherConfig* includes the *scg-DeactivationPreferenceConfig*:

2\> if the *scg-DeactivationPreferenceConfig* is set to *setup*:

3\> consider itself to be configured to provide its SCG deactivation preference in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide its SCG deactivation preference and stop timer T346i, if running.

1\> if the received *otherConfig* includes the *propDelayDiffReportConfig*:

2\> if the *propDelayDiffReportConfig* is set to *setup*:

3\> consider itself to be configured to provide service link propagation delay difference between serving cell and neighbour cell(s) in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide service link propagation delay difference between serving cell and neighbour cell(s).

1\> if the received *otherConfig* includes the *rrm-MeasRelaxationReportingConfig*:

2\> if the *rrm-MeasRelaxationReportingConfig* is set to *setup*:

3\> consider itself to be configured to report the fulfilment of the criterion for relaxing RRM measurements in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to report the fulfilment of the criterion for relaxing RRM measurements.

1\> if the received otherConfig includes the multiRx-PreferenceReportingConfigFR2:

2\> if the *multiRx-PreferenceReportingConfigFR2* is set to *setup*:

3\> consider itself to be configured to provide its preference on multi-Rx operation for FR2 in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide its preference on multi-Rx operation for FR2 and stop timer T346m, if running.

1\> if the received *otherConfig* includes the *uav-FlightPathAvailabilityConfig*:

2\> consider itself to be configured to indicate the availability of flight path information in accordance with 5.7.4;

1\> if the received *otherConfig* includes the *ul-TrafficInfoReportingConfig*:

2\> if *ul-TrafficInfoReportingConfig* is set to *setup*:

3\> consider itself to be configured to provide UL traffic information in accordance with 5.7.4;

2\> else:

3\> consider itself not to be configured to provide UL traffic information and stop all instances of timer T346x, if running.

#### 5.3.5.9a MUSIM gap configuration

The UE shall:

1\> if *musim-GapConfig* is set to *setup*:

2\> for each *musim-GapId* included in the received *musim-GapToReleaseList*:

3\> release the periodic MUSIM gap configuration associated with the *musim-GapId*;

2\> for each *MUSIM-Gap* included in the received *musim-GapToAddModList*:

3\> setup periodic MUSIM gap configuration indicated by the *MUSIM-Gap* in accordance with the received *musim-GapRepetitionAndOffset* (providing *musim-GapRepetition* and *Offset* value for the following condition) i.e. the first subframe of each periodic MUSIM gap occurs at an SFN and subframe of the NR PCell meeting the following condition:

SFN mod *T* = FLOOR(*Offset*/10);

subframe = *Offset* mod 10;

with *T* = *musim-GapRepetition*/10;

3\> set the MUSIM gap priority configuration indicated by *musim-GapPriorityToAddModList,* if configured, for each periodic MUSIM gap;

3\> set the *musim-GapKeep*, if all collided MUSIM gaps are configured to be kept;

NOTE: If network does not retain the relative priorities among MUSIM gaps, UE behaviour is not specified.

2\> if *musim-AperiodicGap* is included:

3\> setup aperiodic MUSIM gap configuration indicated by the *musim-AperiodicGap* in accordance with the received *musim-Starting-SFN-AndSubframe*, i.e. the first subframe of aperiodic MUSIM gap occurs at an SFN and subframe of the NR PCell meeting the following condition:

SFN = *starting-SFN*;

subframe = *startingSubframe*;

1\> else if *musim-GapConfig* is set to *release*:

2\> release the MUSIM gap configuration.

#### 5.3.5.10 MR-DC release

The UE shall:

1\> as a result of MR-DC release triggered by E-UTRA or NR:

2\> release SRB3, if established, as specified in 5.3.5.6.2;

2\> release SRB5, if established, as specified in 5.3.5.6.2;

2\> release *measConfig* associated with SCG;

2\> if the UE is configured with NR SCG:

3\> release the SCG configuration as specified in clause 5.3.5.4;

3\> release *otherConfig* associated with the SCG, if configured;

3\> release *successPSCell-Config* configured by the PCell in the *otherConfig*, if configured;

3\> stop timers T346a, T346b, T346c, T346d, T346e, T346j and T346k associated with the SCG, if running;

3\> release *bap-Config* associated with the SCG, if configured;

3\> release the BAP entity as specified in TS 38.340 \[47\], if there is no configured *bap-Config*;

3\> release *iab-IP-AddressConfigurationList* associated with the SCG, if configured;

2\> else if the UE is configured with E-UTRA SCG:

3\> release the SCG configuration as specified in TS 36.331 \[10\], clause 5.3.10.19 to release the E-UTRA SCG;

#### 5.3.5.11 Full configuration

The UE shall:

1\> release/ clear all current dedicated radio configurations except for the following:

- the MCG C-RNTI;

- the AS security configurations associated with the master key;

- the SRB1/SRB2 configurations and DRB/multicast MRB configurations as configured by *radioBearerConfig* or *radioBearerConfig2*.

NOTE 1: Radio configuration is not just the resource configuration but includes other configurations like *MeasConfig*. Radio configuration also includes the RLC bearer configurations as configured by *RLC-BearerConfig*, PC5 Relay RLC channel as configured by *SL-RLC-ChannelConfig*, and Uu Relay RLC channel as configured by *Uu-RelayRLC-ChannelConfig*. In case NR-DC or NE-DC is configured, this also includes the entire NR or E-UTRA SCG configuration which are released according to the MR-DC release procedure as specified in 5.3.5.10.

NOTE 1a: For NR sidelink communication/discovery, the radio configuration includes the sidelink RRC configuration received from the network, but does not include the sidelink RRC reconfiguration and sidelink UE capability received from other UEs via PC5-RRC. In addition, the UE considers the new NR sidelink configurations as full configuration, in case of state transition and change of system information used for NR sidelink communication/discovery.

NOTE 1b: To establish the RLC bearer of SRB(s) after release due to *fullConfig*, the network can include the *srb-Identity* within *srb-ToAddModList* (i.e. the UE applies RLC default configuration) and/or provide *rlc-BearerToAddModList* of concerned SRB(s) explicitly.

- the logged measurement configuration;

1\> if the *spCellConfig* in the *masterCellGroup* includes the *reconfigurationWithSync*:

2\> release/ clear all current common radio configurations;

2\> if *sl-PathSwitchConfig* was included in *reconfigurationWithSync*:

3\> use the default values specified in 9.2.3 for timer T311;

2\> else:

3\> use the default values specified in 9.2.3 for timers T310, T311 and constants N310, N311;

1\> else (full configuration after re-establishment or during RRC resume):

2\> if the UE is acting as L2 U2N Remote UE:

3\> use value for timer T311, as included in *ue-TimersAndConstants* received in *SIB1*

2\> else:

3\> use values for timers T301, T310, T311 and constants N310, N311, as included in *ue-TimersAndConstants* received in *SIB1*;

1\> if no *measConfigAppLayerId* is included:

2\> inform upper layers about the release of all application layer measurement configurations;

2\> discard any received application layer measurement report from upper layers;

2\> consider itself not to be configured to send application layer measurement report.

1\> if the UE is acting as L2 U2N Remote UE at the target side during reconfiguration with sync, or after re-establishment, or during RRC resume:

2\> apply the default configuration of SL-RLC1 as specified in clause 9.2.4 and associate it with the SRB1;

1\> else:

2\> apply the default L1 parameter values as specified in corresponding physical layer specifications except for the following:

- parameters for which values are provided in *SIB1*;

2\> apply the default MAC Cell Group configuration as specified in 9.2.2;

2\> for each *srb-Identity* value included in the *srb-ToAddModList* (SRB reconfiguration):

3\> establish an RLC entity for the corresponding SRB;

3\> apply the default SRB configuration defined in 9.2.1 for the corresponding SRB;

NOTE 2: This is to get the SRBs (SRB1 and SRB2 for reconfiguration with sync and SRB2 for resume and reconfiguration after re-establishment) to a known state from which the reconfiguration message can do further configuration.

1\> for each *pdu-Session* that is part of the current UE configuration:

2\> release the SDAP entity (clause 5.1.2 in TS 37.324 \[24\]);

2\> release each DRB associated to the *pdu-Session* as specified in 5.3.5.6.4;

NOTE 3: This will retain the *pdu-Session* but remove the DRBs including *drb-identity* of these bearers from the current UE configuration. Setup of the DRBs within the AS is described in clause 5.3.5.6.5 using the new configuration. The *pdu-Session* acts as the anchor for associating the released and re-setup DRB. In the AS the DRB re-setup is equivalent with a new DRB setup (including new PDCP and logical channel configurations).

1\> for each *mbs-SessionId* that is part of the current UE configuration and associated to a multicast MRB:

2\> release the SDAP entity (clause 5.1.2 in TS 37.324 \[24\]);

2\> release each multicast MRB associated to the *mbs-SessionId* as specified in 5.3.5.6.6;

NOTE 4: This will retain the *mbs-SessionId* but remove the multicast MRBs including *mrb-identity* of these bearers from the current UE configuration. Setup of the multicast MRBs within the AS is described in clause 5.3.5.6.7 using the new configuration. The *mbs-SessionId* acts as the anchor for associating the released and re-setup multicast MRB. In the AS the multicast MRB re-setup is equivalent with a new multicast MRB setup (including new PDCP and logical channel configurations).

1\> for each *pdu-Session* that is part of the current UE configuration but not added with same *pdu-Session* in the *drb-ToAddModList*:

2\> if the procedure was triggered due to reconfiguration with sync:

3\> indicate the release of the user plane resources for the *pdu-Session* to upper layers after successful reconfiguration with sync;

2\> else:

3\> indicate the release of the user plane resources for the *pdu-Session* to upper layers immediately;

1\> for each *mbs-SessionId* that is part of the current UE configuration but not added with the same *mbs-SessionId* in the *mrb-ToAddModList*:

2\> if the procedure was triggered due to reconfiguration with sync:

3\> indicate the release of the user plane resources for the *mbs-SessionId* to upper layers after successful reconfiguration with sync;

2\> else:

3\> indicate the release of the user plane resources for the *mbs-SessionId* to upper layers immediately.

#### 5.3.5.12 BAP configuration

The IAB-MT shall:

1\> if the *bap-Config* is set to *setup*:

2\> if no BAP entity is established:

3\> establish a BAP entity as specified in TS 38.340 \[47\];

2\> if *bap-Address* is included:

3\> configure the BAP entity to use the *bap-Address* as this node\'s BAP address;

2\> if *defaultUL-BAP-RoutingID* is included:

3\> configure the BAP entity to apply the default UL BAP routing ID according to the configuration;

2\> if *defaultUL-BH-RLC-Channel* is included

3\> configure the BAP entity to apply the default UL BH RLC channel according to the configuration;

2\> if *flowControlFeedbackType* is included:

3\> configure the BAP entity to apply the flow control feedback according to the configuration;

1\> if the *bap-Config* is set to *release*:

2\> release the concerned *bap-Config*;

2\> if there is no other configured *bap-Config* for the MCG or for the SCG

3\> release the BAP entity as specified in TS 38.340 \[47\].

#### 5.3.5.12a IAB Other Configuration

##### 5.3.5.12a.1 IP address management

###### 5.3.5.12a.1.1 IP Address Release

The IAB-MT shall:

1\> if the release is triggered by reception of the *iab-IP-AddressToReleaseList*:

2\> for each *iab-IP-AddressIndex* value included in *iab-IP-AddressToReleaseList*:

3\> release the corresponding *IAB-IP-AddressConfiguration*.

###### 5.3.5.12a.1.2 IP Address Addition/Modification

The IAB-MT shall:

1\> for each *iab-IP-AddressIndex* value included in the *iab-IP-AddressToAddModList* that is not part of the current IAB-MT configuration:

2\> add the IP address indicated in *iab-IP-Address*, corresponding to the *iab-IP-AddressIndex.*

2\> if added IP address is *iPv4-Address*:

3\> if *iab-IP-Usage* is set to *f1-C:*

4\> store the received IPv4 address for F1-C traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else if *iab-IP-Usage* is set to *f1-U*:

4\> store the received IPv4 address for F1-U traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else if *iab-IP-Usage* is set to *non-F1*:

4\> store the received IPv4 address for non-F1 traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else:

4\> store the received IPv4 address for all traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

2\> else if *iPv6-Address* is included:

3\> if *iab-IP-Usage* is set to *f1-C*:

4\> store the received IPv6 address for F1-C traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else if *iab-IP-Usage* is set to *f1-U*:

4\> store the received IPv6 address for F1-U traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else if *iab-IP-Usage* is set to *non-F1*:

4\> store the received IPv6 address for non-F1 traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else:

4\> store the received IPv6 address for all traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

2\> else if *iPv6-Prefix* is included in *iab-IP-AddressToAddModList*:

3\> if *iab-IP-Usage* is set to *f1-C*:

4\> store the received IPv6 address prefix for F1-C traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else if *iab-IP-Usage* is set to *f1-U*:

4\> store the received IPv6 address prefix for F1-U traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else if *iab-IP-Usage* is set to *non-F1*:

4\> store the received IPv6 address prefix for non-F1 traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

3\> else:

4\> store the received IPv6 address prefix for all traffic together with the IAB-donor-DU BAP address corresponding to the *iab-IP-AddressIndex*.

1\> for each *iab-IP-AddressIndex* value included in the *iab-IP-AddressToAddModList* that is part of the current IAB-MT configuration:

2\> modify the IP address configuration(s) in accordance with the *IAB-IP-AddressConfiguration* corresponding to the *iab-IP-AddressIndex.*

#### 5.3.5.13 Conditional Reconfiguration

##### 5.3.5.13.1 General

The network configures the UE with one or more candidate target SpCells in the conditional reconfiguration. The UE evaluates the condition of each configured candidate target SpCell. The UE applies the conditional reconfiguration associated with one of the target SpCells which fulfils associated execution condition.

The network can also configure the UE with one or more candidate target PCells associated with one or more candidate target PSCells. The UE evaluates the conditions for the candidate target PCells and the associated candidate target PSCells in parallel and applies a target configuration that include PCell and PSCell for which the associated execution conditions are fullfiled. If there are multiple candidate PSCells associated with one candidate target PCell, the network provides multiple conditional configurations for the same candidate target PCell, i.e., each configuration contains one MCG configuration (for the same candidate target PCell) and one SCG configuration (for one of the multiple associated candidate PSCells). For this case, the network may also provide a complementary CHO only configuration, i.e., there is execution condition only for candidate PCell.

The network provides the configuration parameters for the target SpCell(s) in the *condRRCReconfig*.

In NR-DC, the UE may receive two independent *conditionalReconfiguration*:

- a *conditionalReconfiguration* associated with MCG, that is included in the *RRCReconfiguration* message received via SRB1; and

- a *conditionalReconfiguration*, associated with SCG, that is included in the *RRCReconfiguration* message received via SRB3, or, alternatively, included within a *RRCReconfiguration* message embedded in a *RRCReconfiguration* message received via SRB1.

In this case:

- the UE maintains two independent *VarConditionalReconfig*, one associated with each *conditionalReconfiguration*;

- the UE independently performs all the procedures in clause 5.3.5.13 for each *conditionalReconfiguration* and the associated *VarConditionalReconfig*, unless explicitly stated otherwise;

- the UE performs the procedures in clause 5.5 for the *VarConditionalReconfig* associated with the same cell group like the *measConfig*.

In EN-DC, the *VarConditionalReconfig* is associated with the SCG.

In NE-DC and when no SCG is configured, the *VarConditionalReconfig* is associated with the MCG.

The UE performs the following actions based on a received *ConditionalReconfiguration* IE:

1\> if the *ConditionalReconfiguration* contains the *condReconfigToRemoveList*:

2\> perform conditional reconfiguration removal procedure as specified in 5.3.5.13.2;

1\> if the *ConditionalReconfiguration* contains the *condReconfigToAddModList*:

2\> perform conditional reconfiguration addition/modification as specified in 5.3.5.13.3;

1\> if the *ConditionalReconfiguration* contains the *scpac-ReferenceConfiguration*:

2\> perform subsequent CPAC reference configuration addition/removal as specified in 5.3.5.13.6;

1\> if the *ConditionalReconfiguration* contains the *sk-CounterConfiguration*:

2\> perform *sk-CounterList* addition/modification/removal as specified in 5.3.5.13.7;

1\> if the *ConditionalReconfiguration* contains the *servingSecurityCellSetId:*

2\> if the current *VarServingSecurityCellSetID* includes *servingSecurityCellSetId*:

3\> replace the *servingSecurityCellSetId* value within *VarServingSecurityCellSetID* with the received *servingSecurityCellSetID*;

2\> else:

3\> store the received *servingSecurityCellSetId* within *VarServingSecurityCellSetID*.

##### 5.3.5.13.2 Conditional reconfiguration removal

The UE shall:

1\> for each *condReconfigId* value included in the *condReconfigToRemoveList* that is part of the current UE conditional reconfiguration in *VarConditionalReconfig*:

2\> remove the entry with the matching *condReconfigId* from the *VarConditionalReconfig*;

NOTE 1: The UE does not consider the message as erroneous if the *condReconfigToRemoveList* includes any cond*ReconfigId* value that is not part of the current UE configuration.

NOTE 2: The UE does not consider the message as erroneous if the *condExecutionCondToReleaseList* includes any *condReconfigId* value that is not part of the current UE configuration.

##### 5.3.5.13.3 Conditional reconfiguration addition/modification

For each *condReconfigId* received in the *condReconfigToAddModList* IE the UE shall:

1\> if an entry with the matching *condReconfigId* exists in the *condReconfigToAddModList* within the *VarConditionalReconfig*:

2\> if the entry in *condReconfigToAddModList* includes an *condExecutionCond,* *condExecutionCondSCG*, or *condExecutionCondPSCell*;

3\> replace *condExecutionCond,* *condExecutionCondSCG*, or *condExecutionCondPSCell* within the *VarConditionalReconfig* with the value received for this *condReconfigId*;

2\> if the entry in *condReconfigToAddModList* includes *subsequentCondReconfig* containing *condExecutionCondToAddModList*:

3\> for each *condReconfigId* received in *condExecutionCondToAddModList*:

4\> if an entry with the matching *condReconfigId* exists in the *condExecutionCondToAddModList* within *VarConditionalReconfig*;

5\> replace the entry in *condExecutionCondToAddModList* within *VarConditionalReconfig* with the value received for this *condReconfigId*;

4\> else:

5\> add a new entry in *condExecutionCondToAddModList* within *VarConditionalReconfig* with the value received for this *condReconfigId*;

2\> if the entry in *condReconfigToAddModList* includes *subsequentCondReconfig* containing *condExecutionCondToReleaseList*:

3\> for each *condReconfigId* received in *condExecutionCondToReleaseList* that is part of current stored *condExecutionCondToAddModList* within *VarConditionalReconfig*:

4\> remove the entry in *condExecutionCondToAddModList* within *VarConditionalReconfig* with the value received for this *condReconfigId*;

2\> if the entry in *condReconfigToAddModList* includes an *securityCellSetId*;

3\> replace *securityCellSetId* within the *VarConditionalReconfig* with the value received for this *condReconfigId*;

NOTE: The UE should release the entry within *VarServingSecurityCellSetID* in case all the subsequent CPAC configurations are released.

2\> if the entry in *condReconfigToAddModList* includes an *condRRCReconfig*;

3\> replace *condRRCReconfig* within the *VarConditionalReconfig* with the value received for this *condReconfigId*;

1\> else:

2\> add a new entry for this *condReconfigId* within the *VarConditionalReconfig*;

1\> perform conditional reconfiguration evaluation as specified in 5.3.5.13.4;

##### 5.3.5.13.4 Conditional reconfiguration evaluation

The UE shall:

1\> for each *condReconfigId* within the *VarConditionalReconfig*:

2\> if the *RRCReconfiguration* within *condRRCReconfig* includes the *masterCellGroup* including the *reconfigurationWithSync*:

3\> if the associated *condExecutionCondPSCell* is configured:

4\> consider the cell which has a physical cell identity matching the value indicated in the *ServingCellConfigCommon* included in the *reconfigurationWithSync* within the *masterCellGroup* in the received *condRRCReconfig* to be applicable cell; and

4\> consider the cell which has a physical cell identity matching the value indicated in the *ServingCellConfigCommon* included in the *reconfigurationWithSync* within the *secondaryCellGroup* within the *nr-SCG* within the received *condRRCReconfig* to be applicable cell;

3\> else:

4\> consider the cell which has a physical cell identity matching the value indicated in the *ServingCellConfigCommon* included in the *reconfigurationWithSync* within the *masterCellGroup* in the received *condRRCReconfig* to be applicable cell;

2\> else if the *RRCReconfiguration* within *condRRCReconfig* includes the *secondaryCellGroup* including the *reconfigurationWithSync*:

3\> if the cell which has a physical cell identity matching the value indicated in the *ServingCellConfigCommon* included in the *reconfigurationWithSync* within the *secondaryCellGroup* within the received *condRRCReconfig* is not the PSCell:

4\> consider the cell to be applicable cell;

2\> if *condExecutionCondSCG* is configured:

3\> in the remainder of the procedure, consider each *measId* indicated in the *condExecutionCondSCG* as a *measId* in the *VarMeasConfig* associated with the SCG *measConfig*;

2\> if the *condExecutionCondPSCell* is configured:

3\> in the remainder of the procedure, consider each *measId* indicated in the *condExecutionCondPSCell* as a *measId* in the *VarMeasConfig* associated with the MCG *measConfig*;

2\> if *condExecutionCond* is configured:

3\> if it is configured via SRB3 or configured within *nr-SCG* or within *nr-SecondaryCellGroupConfig* (specified in TS 36.331\[10\]) via SRB1:

4\> in the remainder of the procedure, consider each *measId* indicated in the *condExecutionCond* as a *measId* in the *VarMeasConfig* associated with the SCG *measConfig*;

3\> else:

4\> in the remainder of the procedure, consider each *measId* indicated in the *condExecutionCond* as a *measId* in the *VarMeasConfig* associated with the MCG *measConfig*;

2\> for each *measId* included in the *measIdList* within *VarMeasConfig* indicated in the *condExecutionCond,* *condExecutionCondSCG,* or *condExecutionCondPSCell* associated to *condReconfigId:*

3\> if the *condTriggerConfig* is not configured with *nesEvent*:

4\> if the *condEventId* is associated with *condEventT1*, and if the entry condition applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cell; or

4\> if the *condEventId* is associated with *condEventD1*, and if the entry conditions applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cell during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*; or

4\> if the *condEventId* is associated with *condEventD2*, and if the entry conditions applicable for this event associated with the *condReconfigId*, i.e., the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cell during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*; or

4\> if the *condEventId* is associated with *condEventA3*, *condEventA4* or *condEventA5*, and if the entry condition(s) applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cells for all measurements after layer 3 filtering taken during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*:

5\> consider the event associated to that *measId* to be fulfilled;

4\> if the *measId* for this event associated with the *condReconfigId* has been modified; or

4\> if the *condEventId* is associated with *condEventT1*, and if the leaving condition applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cell; or

4\>if the *condEventId* is associated with *condEventD1*, and if the leaving condition(s) applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cell during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*; or

4\> if the *condEventId* is associated with *condEventD2*, and if the leaving condition(s) applicable for this event associated with the *condReconfigId*, i.e., the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cell during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*; or

4\> if the *condEventId* is associated with *condEventA3*, *condEventA4* or *condEventA5*, and if the leaving condition(s) applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cells for all measurements after layer 3 filtering taken during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*:

5\> consider the event associated to that *measId* to be not fulfilled;

3\> else:

4\> if NES mode indication is received from lower layers, indicating that the NES-specific CHO execution condition is enabled; and

4\> if the entry condition(s) applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cells for all measurements after layer 3 filtering taken during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*:

5\> consider the event associated to that *measId* to be fulfilled;

4\> if the *measId* for this event associated with the *condReconfigId* has been modified; or

4\> if NES mode indication is received from lower layers, indicating that the NES-specific CHO execution condition is disabled; or

4\> if the leaving condition(s) applicable for this event associated with the *condReconfigId*, i.e. the event corresponding with the *condEventId(s)* of the corresponding *condTriggerConfig* within *VarConditionalReconfig*, is fulfilled for the applicable cells for all measurements after layer 3 filtering taken during the corresponding *timeToTrigger* defined for this event within the *VarConditionalReconfig*:

5\> consider the event associated to that *measId* to be not fulfilled;

2\> if *condExecutionCondPSCell* is not configured:

3\> if event(s) associated to all *measId*(s) within *condTriggerConfig* for the applicable cell are fulfilled:

4\> consider the applicable cell, associated to that *condReconfigId*, as a triggered cell;

4\> initiate the conditional reconfiguration execution, as specified in 5.3.5.13.5;

2\> else:

3\> if event(s) associated to all *measId*(s), as indicated in the *condExecutionCond* and *condExecutionCondPSCell,* within *condTriggerConfig* for a target candidate cell within the stored *condRRCReconfig* are fulfilled:

4\> consider the target candidate PCell within the stored *condRRCReconfig*, associated to that *condReconfigId*, as a triggered PCell;

4\> consider the target candidate PSCell within the stored *condRRCReconfig*, associated to that *condReconfigId*, as a triggered PSCell;

4\> initiate the conditional reconfiguration execution, as specified in 5.3.5.13.5.

2\> if one of the events associated to the *measId*s within *condTriggerConfig* for the applicable cell within the stored *condRRCReconfig* is not configured with *nesEvent*, and the other event associated to the *measId*s within *condTriggerConfig* for the applicable cell within the stored *condRRCReconfig* is configured with *nesEvent*, and at least one of them is fulfilled:

3\> consider the applicable cell within the stored *condRRCReconfig*, associated to that *condReconfigId*, as a triggered cell;

3\> initiate the conditional reconfiguration execution, as specified in 5.3.5.13.5;

NOTE 1: Up to 2 *MeasId* can be configured for each *condReconfigId*, if *condExecutionCondPSCell* is not configured*.* The conditional reconfiguration event of the 2 *MeasId* may have the same or different event conditions, triggering quantity, time to trigger, and triggering threshold.

NOTE 2: Void.

NOTE 3: For CHO with candidate SCGs, up to 2 *MeasId* can be configured for *condExecutionCond* and up to 2 *MeasId* can be configured for *condExecutionCondPSCell* for each *condReconfigId*.

##### 5.3.5.13.4a Conditional reconfiguration evaluation of SN initiated inter-SN CPC for EN-DC

The UE shall:

1\> for each *condReconfigurationId* within the *VarConditionalReconfiguration* specified in TS 36.331\[10\]:

2\> for each *measId* included in the *measIdList* within *VarMeasConfig* indicated in the *CondReconfigExecCondSCG* contained in the *triggerConditionSN* associated to the *condReconfigurationId* as specified in TS 36.331\[10\]:

3\> if the entry condition(s) applicable for the event associated with that *measId*, is fulfilled for the applicable cells for all measurements after layer 3 filtering taken during the corresponding *timeToTrigger* defined for this event associated with that *measId*:

4\> consider this event to be fulfilled;

3\> if the *measId* for this event has been modified; or

3\> if the leaving condition(s) applicable for this event associated with that *measId*, is fulfilled for the applicable cells for all measurements after layer 3 filtering taken during the corresponding *timeToTrigger* defined for this event associated with that *measId*:

4\> consider this event associated to that *measId* to be not fulfilled;

2\> if trigger conditions for all events associated with the *measId(s)* indicated in the *CondReconfigExecCondSCG* contained in the *triggerConditionSN* as specified in TS 36.331\[10\]), are fulfilled:

3\> consider the target cell candidate within the *RRCReconfiguration* message contained in *nr-SecondaryCellGroupConfig* in the *RRCConnectionReconfiguration* message, as specified in TS 36.331\[10\], contained in the stored *condReconfigurationToApply*, associated to that *condReconfigurationId* as specified in TS 36.331\[10\]), clause 5.3.5.9.4, as a triggered cell;

3\> initiate the conditional reconfiguration execution, as specified in TS 36.331\[10\]), clause 5.3.5.9.5;

NOTE: Void.

##### 5.3.5.13.5 Conditional reconfiguration execution

The UE shall:

1\> if more than one pair of triggered PCell and associated triggered PSCell exist:

2\> select one of the triggered PCell(s) and the associated triggered PSCell(s) as the selected cells for conditional reconfiguration execution;

1\> else if only one pair of triggered PCell and associated triggered PSCell exists:

2\> consider the triggered PCell and the associated triggered PSCell as the selected cells for conditional reconfiguration execution;

1\> else if more than one triggered cell exists:

2\> select one of the triggered cells as the selected cell for conditional reconfiguration execution;

1\> else:

2\> consider the triggered cell as the selected cell for conditional reconfiguration execution;

1\> for the selected cell(s) of conditional reconfiguration execution:

2\> if the *subsequentCondReconfig* is included in the entry in *VarConditionalReconfig* containing the *RRCReconfiguration* message for the selected cell:

3\> perform the actions as specified in 5.3.5.13.8;

2\> else:

3\> apply the stored *condRRCReconfig* of the selected cell and perform the actions as specified in 5.3.5.3;

NOTE: If multiple NR cells are triggered in conditional reconfiguration execution, it is up to UE implementation which one to select, e.g. the UE considers beams and beam quality to select one of the triggered cells for execution.

##### 5.3.5.13.6 Subsequent CPAC reference configuration addition/removal

The UE shall:

1\> if the *scpac-ReferenceConfiguration* is set to *setup*:

2\> if *scpac-ReferenceConfiguration* exists within the *VarConditionalReconfig*:

3\> replace the *scpac-ReferenceConfiguration* within the *VarConditionalReconfig*;

2\> else:

3\> store the *scpac-ReferenceConfiguration* within the *VarConditionalReconfig*;

1\> else (if *scpac-ReferenceConfiguration* is set to *release)*:

2\> remove the *scpac-ReferenceConfiguration* within the *VarConditionalReconfig*;

##### 5.3.5.13.7 sk-Counter configuration addition/modification/removal

The UE shall:

1\> for each *securityCellSetId* received in the *sk-CounterConfigToAddModList* IE:

2\> if an entry with the matching *securityCellSetId* exists in the *sk-CounterConfigToAddModList* within the *VarConditionalReconfig*:

3\> replace the *sk-CounterList* within the *VarConditionalReconfig* with the *sk-CounterList* according to the received *securityCellSetId*;

2\> else:

3\> add a new entry for this *securityCellSetId* within the *VarConditionalReconfig*;

1\> for each *securityCellSetId* value included in the *sk-CounterConfigToRemoveList* that is part of the current *sk-CounterConfigToAddModList* in *VarConditionalReconfig*:

2\> remove the entry with the matching *securityCellSetId* from the *sk-CounterConfigToAddModList*;

##### 5.3.5.13.8 Subsequent CPAC execution

Upon the conditional reconfiguration execution for subsequent CPAC, the UE shall:

1\> if the selected subsequent CPAC candidate configuration is stored in MCG *VarConditionalReconfig*:

2\> release/clear all current dedicated radio configuration except for the following:

- the MCG C-RNTI;

- the AS security configurations associated with the master key and the secondary key;

- for each SRB/DRB in current UE configuration:

- keep the associated RLC, PDCP and SDAP entities, their state variables, buffers and timers;

- release all fields related to the SRB/DRB configuration except for *srb-Identity* and *drb-Identity*;

- the UE variables *VarConditionalReconfig* and *VarServingSecurityCellSetID.*

2\> release/clear all current common radio configuration;

1\> else:

2\> release/clear all current dedicated radio configuration associated with the SCG except for the following:

- the AS security configurations associated with the secondary key;

- for each SRB/DRB in current UE configuration which is using the secondary key:

- keep the associated RLC, PDCP and SDAP entities, their state variables, buffers and timers;

- release all fields related to the SRB/DRB configuration except for *srb-Identity* and *drb-Identity*;

- the UE variables *VarConditionalReconfig*.

2\> release/clear all current common radio configuration associated with the SCG;

1\> use the default values specified in 9.2.3 for timers T310, T311 and constants N310, N311 for the cell group for which the subsequent CPAC cell switch procedure is triggered;

1\> if the *securityCellSetId* is included in the entry in *VarConditionalReconfig* containing the *RRCReconfiguration* message:

2\> if *servingSecurityCellSetId* is not included within *VarServingSecurityCellSetID*; or

2\> if the value of the *securityCellSetId* is not equal to the value of *servingSecurityCellSetId* within *VarServingSecurityCellSetID*:

3\> consider the first *sk-Counter* value in the *sk-CounterList* associated with the *securityCellSetId* within the *VarConditionalReconfig* as the selected *sk-Counter* value, and perform security key update procedure as specified in 5.3.5.7;

3\> remove the selected *sk-Counter* value from the *sk-CounterList* associated with the *securityCellSetId* within the *VarConditionalReconfig*;

3\> if the current *VarServingSecurityCellSetID* includes *servingSecurityCellSetId*:

4\> replace the value of *servingSecurityCellSetId* within *VarServingSecurityCellSetID* with the value of *securityCellSetId* associated with the selected cell;

3\> else:

4\> store the *servingSecurityCellSetId* within *VarServingSecurityCellSetID* with the value of *securityCellSetId* associated with the selected cell;

1\> if the selected subsequent CPAC candidate configuration is stored in the SCG *VarConditionalReconfig*:

2\> for each *drb-Identity* value included in *RadioBearerConfig* associated with the secondary key (S-K~gNB~) as indicated by *keyToUse* that is part of the current UE configuration:

3\> trigger the PDCP entity of the AM DRB to perform PDCP data recovery as specified in TS 38.323 \[5\];

3\> re-establish the corresponding RLC entity as specified in TS 38.322 \[4\];

*Editor\'s Note: FFS how the L2 reset (PDCP re-establishment, PDCP recovery, and RLC re-establishment) is indicated by the network in case of subsequent CPAC.*

1\> else:

2\> for each *drb-Identity* value included in *RadioBearerConfig* that is part of the current UE configuration:

3\> if a different *keyToUse* value is configured*;* or

3\> if a new *sk-Counter* value has been selected due to the conditional reconfiguration execution for subsequent CPAC:

4\> trigger the PDCP entity of the bearer to perform PDCP reestablishment as specified in TS 38.323 \[5\];

3\> else:

4\> trigger the PDCP entity of the AM DRB to perform PDCP data recovery as specified in TS 38.323 \[5\];

4\> re-establish the corresponding RLC entity as specified in TS 38.322 \[4\];

1\> if *scpac-ConfigComplete* is not included within the *VarConditionalReconfig* for the selected cell:

2\> if the subsequent CPAC candidate cell configuration is stored in MCG *VarConditionalReconfig*:

3\> consider *scpac-ReferenceConfiguration* in MCG *VarConditionalReconfig* to be the current UE configuration;

2\> else:

3\> consider *scpac-ReferenceConfiguration* in SCG *VarConditionalReconfig* to be the current SCG configuration;

NOTE 1: When the UE considers the reference configuration to be the current UE configuration, the UE should store fields and configurations that are part of the reference configuration but should not execute any actions or procedures triggered by the reception of an *RRCReconfiguration* message which are described in clause 5.3.5.3.

1\> apply the stored *condRRCReconfig* of the selected cell(s) and perform the actions as specified in 5.3.5.3;

1\> release the radio bearer(s) and the associated logical channel(s) that are part of the current UE configuration but not part of the subsequent CPAC candidate configuration for the selected cell, or the subsequent CPAC reference configuration (in case the subsequent CPAC candidate configuration does not include *scpac-ConfigComplete*).

NOTE 2: When *scpac-ConfigComplete* is not included for the selected cell, before a subsequent CPAC execution, a UE implementation may generate and store an RRC reconfiguration message by applying the received subsequent CPAC candidate configuration on top of the subsequent CPAC reference configuration, and the stored RRC reconfiguration message is applied for subsequent CPAC execution.

#### 5.3.5.13a SCG activation

Upon initiating the procedure, the UE shall:

1\> if the UE is configured with an SCG after receiving the message for which this procedure is initiated:

2\> if the UE was configured with a deactivated SCG before receiving the message for which this procedure is initiated:

3\> consider the SCG to be activated;

3\> resume performing radio link monitoring on the SCG, if previously stopped;

3\> indicate to lower layers to resume beam failure detection on the PSCell, if previously stopped;

3\> indicate to lower layers that the SCG is activated.

#### 5.3.5.13b SCG deactivation

Upon initiating the procedure, the UE shall:

1\> consider the SCG to be deactivated;

1\> indicate to lower layers that the SCG is deactivated;

1\> if *bfd-and-RLM* is configured to *true*:

2\> perform radio link monitoring on the SCG;

2\> indicate to lower layers to perform beam failure detection on the PSCell;

1\> else:

2\> stop radio link monitoring on the SCG;

2\> indicate to lower layers to stop beam failure detection on the PSCell;

2\> stop timer T310 for this cell group, if running;

2\> stop timer T312 for this cell group, if running;

2\> reset the counters N310 and N311;

1\> if the UE was in RRC_CONNECTED and the SCG was activated before receiving the message for which this procedure is initiated:

2\> if SRB3 was configured before the reception of the *RRCReconfiguration* or of the *RRCConnectionReconfiguration* and SRB3 is not to be released according to any *RadioBearerConfig* included in the *RRCReconfiguration* or in the *RRCConnectionReconfiguration* as specified in TS 36.331\[10\]:

3\> trigger the PDCP entity of SRB3 to perform SDU discard as specified in TS 38.323 \[5\];

3\> re-establish the RLC entity of SRB3 as specified in TS 38.322 \[4\].

#### 5.3.5.13b1 SCG activation without SN message

Upon initiating the procedure, the UE shall:

1\> if the SCG was deactivated before the reception of the *RRCReconfiguration* message or the E-UTRA *RRCConnectionReconfiguration* message for which the procedure invoking this clause is executed:

2\> consider the SCG to be activated;

2\> indicate to lower layers that the SCG is activated;

2\> resume performing radio link monitoring on the SCG, if previously stopped;

2\> indicate to lower layers to resume beam failure detection on the PSCell, if previously stopped;

2\> if *bfd-and-RLM* was not configured to true before the reception of the *RRCReconfiguration* message or the E-UTRA *RRCConnectionReconfiguration* message for which the procedure invoking this clause is executed; or

2\> if lower layers indicate that a Random Access procedure is needed for SCG activation:

3\> initiate the Random Access procedure on the PSCell, as specified in TS 38.321 \[3\].

#### 5.3.5.13c FR2 UL gap configuration

The UE shall:

1\> if *ul-GapFR2-Config* is set to setup:

2\> if an FR2 UL gap configuration is already setup, release the FR2 UL gap configuration;

2\> setup the FR2 UL gap configuration indicated by the *ul-GapFR2-Config* in accordance with the received *gapOffset*, i.e., the first subframe of each gap occurs at an SFN and subframe meeting the following condition:

SFN mod T = FLOOR (*gapOffset*/10);

if the UGRP is larger than 5ms:

subframe = *gapOffset* mod 10;

else:

subframe = *gapOffset* or (*gapOffset* +5);

with T = CEIL(UGRP/10).

1\> else if *ul-GapFR2-Config* is set to release:

2\> release the FR2 UL gap configuration.

NOTE 1: For *ul-GapFR2-Config* configuration with synchronous CA, the SFN and subframe of a serving cell on FR2 frequency is used in the gap calculation. For *ul-GapFR2-Config* configuration with asynchronous CA, the SFN and subframe of a serving cell on FR2 frequency indicated by the *refFR2-ServCellAsyncCA* in *ul-GapFR2-Config* is used in the gap calculation.

#### 5.3.5.13d Application layer measurement configuration

The UE shall:

1\> if *measConfigAppLayerToReleaseList* is included in *appLayerMeasConfig* within *RRCReconfiguration* or *RRCResume*:

2\> for each *measConfigAppLayerId* value included in the *measConfigAppLayerToReleaseList*:

3\> forward the *measConfigAppLayerId* and inform upper layers about the release of the application layer measurement configuration including any RAN visible application layer measurement configuration;

3\> discard any application layer measurement report received from upper layers;

3\> if stored, release the application layer measurement configuration in UE variables *VarAppLayerIdleConfig* and *VarAppLayerPLMN-ListConfig*;

3\> consider itself not to be configured to send application layer measurement report for the *measConfigAppLayerId*.

1\> if *measConfigAppLayerToAddModList* is included in *appLayerMeasConfig* within *RRCReconfiguration* or *RRCResume*:

2\> for each *measConfigAppLayerId* value included in the *measConfigAppLayerToAddModList*:

3\> if *measConfigAppLayerContainer* is included for the corresponding *MeasConfigAppLayer* configuration:

4\> forward the *measConfigAppLayerContainer*, the *measConfigAppLayerId* and the *serviceType* to upper layers considering the *serviceType*;

3\> consider itself to be configured to send application layer measurement report for the *measConfigAppLayerId* in accordance with 5.7.16;

3\> forward the *transmissionOfSessionStartStop*, if configured, and *measConfigAppLayerId* to upper layers considering the *serviceType*;

3\> if *ran-VisibleParameters* is set to setup and the parameters have been received:

4\> forward the *measConfigAppLayerId,* the *ran-VisiblePeriodicity*, if configured, the *numberOfBufferLevelEntries*, if configured, and the *reportPlayoutDelayForMediaStartup*, if configured, to upper layers considering the *serviceType*;

3\> else if *ran-VisibleParameters* is set to release:

4\> forward the *measConfigAppLayerId* and inform upper layers about the release of the RAN visible application layer measurement configuration;

3\> if *pauseReporting* is set to *true*:

4\> if at least one segment, but not all segments, of a segmented *MeasurementReportAppLayer* message containing an application layer measurement report associated with the *measConfigAppLayerId* has been submitted to lower layers for transmission:

5\> submit the remaining segments of the *MeasurementReportAppLayer* message to lower layers for transmission;

4\> suspend submitting application layer measurement report containers to lower layers for the application layer measurement configuration associated with the *measConfigAppLayerId*;

4\> store any previously or subsequently received application layer measurement report containers associated with the *measConfigAppLayerId* for which no segment, or full message, has been submitted to lower layers for transmission;

4\> if the memory reserved for storing application layer measurement report containers becomes full while the reporting is paused and if the UE is configured with *appLayerMeasPriority*:

5\> discard reports in priority order where reports with the lowest priority are discarded first;

3\> else if *pauseReporting* is set to *false* and if transmission of application layer measurement report containers has previously been suspended for the application layer measurement configuration associated with the *measConfigAppLayerId*:

4\> submit stored application layer measurement report containers to lower layers, if any, for the application layer measurements configuration associated with the *measConfigAppLayerId;*

4\> resume submitting application layer measurement report containers to lower layers for the application layer measurement configuration associated with the *measConfigAppLayerId*;

3\> if *configForRRC-IdleInactive* is set to *true*:

4\> store the received *qoe-Reference*, *measConfigAppLayerId*, *serviceType*, *qoe-MeasurementType*, *qoe-AeaScope*, *mce-Id*, *configForRRC-IdleInactive*, *appLayerMeasPriority*, if included, in *VarAppLayerIdleConfig*;

4\> if the *qoe-AreaScope* includes *plmn-IdentityList*:

5\> set *plmn-IdentityList* in *VarAppLayerPLMN-ListConfig* to include the RPLMN as well as the PLMNs included in *plmn-IdentityList*;

4\> else:

5\> set *plmn-IdentityList* in *VarAppLayerPLMN-ListConfig* to include the RPLMN;

NOTE 1: The UE may discard reports when the memory reserved for storing application layer measurement report containers becomes full. If no *appLayerMeasPriority* is configured, older reports may be discarded first.

NOTE 2: The transmission of RAN visible application layer measurement reports and *appLayerSessionStatus* is not paused when *pauseReporting* is set to *true*.

NOTE 3: The UE may discard an application layer measurement configuration and associated unsent reports after 48 hours.

Editor\'s Note: FFS on when the 48 hours start for when the UE may discard application layer measurement configuration and reports.

#### 5.3.5.14 Sidelink dedicated configuration

Upon initiating the procedure, the UE shall:

1\> if *sl-FreqInfoToReleaseList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> for each entry included in the received *sl-FreqInfoToReleaseList* that is part of the current UE configuration:

3\> release the related configurations from the stored NR sidelink communication/discovery configurations;

1\> if *sl-FreqInfoToAddModList*/*sl-FreqInfoToAddModListExt* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> if configured to receive NR sidelink communication:

3\> use the resource pool(s) indicated by *sl-RxPool* for NR sidelink communication reception, as specified in 5.8.7;

2\> if configured to transmit NR sidelink communication:

3\> use the resource pool(s) indicated by *sl-TxPoolSelectedNormal*, *sl-TxPoolScheduling* or *sl-TxPoolExceptional* for NR sidelink communication transmission, as specified in 5.8.8;

2\> if configured to receive NR sidelink discovery:

3\> use the resource pool(s) indicated by *sl-DiscRxPool* or *sl-RxPool* for NR sidelink discovery reception, as specified in 5.8.13.2;

2\> if configured to transmit NR sidelink discovery:

3\> use the resource pool(s) indicated by *sl-DiscTxPoolSelected*, *sl-DiscTxPoolScheduling*, *sl-TxPoolSelectedNormal*, *sl-TxPoolScheduling* or *sl-TxPoolExceptional* for NR sidelink discovery transmission, as specified in 5.8.13.3;

2\> if configured to receive sidelink control information for SL-PRS measurement:

3\> use the resource pool(s) indicated by *sl-RxPool* and/or *sl-PRS-RxPool* for SL-PRS reception, as specified in 5.8.18.2;

2\> if configured to transmit SL-PRS:

3\> use the resource pool(s) indicated by *sl-PRS-TxPoolSelectedNormal*, *sl-PRS-TxPoolScheduling, sl-BWP-PRS-PoolConfig* or *sl-PRS-TxPoolExceptional* for SL-PRS transmission, as specified in 5.8.18.3;

2\> perform CBR measurement on the transmission resource pool(s) indicated by *sl-TxPoolSelectedNormal*, *sl-TxPoolScheduling*, *sl-PRS-TxPoolSelectedNormal*, *sl-PRS-TxPoolScheduling, sl-DiscTxPoolSelected, sl-DiscTxPoolScheduling*, *sl-TxPoolExceptional* or *sl-PRS-TxPoolExceptional* for NR sidelink communication/discovery/positioning transmission, as specified in 5.5.3;

2\> use the synchronization configuration parameters for NR sidelink communication/discovery/positioning on frequencies included in *sl-FreqInfoToAddModList*/*sl-FreqInfoToAddModListExt*, as specified in 5.8.5;

1\> if *sl-RadioBearerToReleaseList* or *sl-RLC-BearerToReleaseList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> perform sidelink DRB release as specified in 5.8.9.1a.1;

1\> if *sl-RLC-BearerToReleaseListSizeExt* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> perform additional sidelink RLC bearer release as specified in 5.8.9.1a.5;

1\> if *sl-RadioBearerToAddModList* or *sl-RLC-BearerToAddModList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> perform sidelink DRB addition/modification as specified in 5.8.9.1a.2;

1\> if *sl-RLC-BearerToAddModListSizeExt* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> perform additional sidelink RLC bearer addition/modification as specified in 5.8.9.1a.6;

1\> if *sl-ScheduledConfig* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> configure the MAC entity parameters, which are to be used for NR sidelink communication/discovery, in accordance with the received *sl-ScheduledConfig*;

1\> if *sl-UE-SelectedConfig* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> configure the parameters, which are to be used for NR sidelink communication/discovery, in accordance with the received *sl-UE-SelectedConfig*;

1\> if *sl-MeasConfigInfoToReleaseList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> for each *SL-DestinationIndex* included in the received *sl-MeasConfigInfoToReleaseList* that is part of the current UE configuration:

3\> remove the entry with the matching *SL-DestinationIndex* from the stored NR sidelink measurement configuration information;

1\> if *sl-MeasConfigInfoToAddModList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> for each *sl-DestinationIndex* included in the received *sl-MeasConfigInfoToAddModList* that is part of the current stored NR sidelink measurement configuration:

3\> reconfigure the entry according to the value received for this *sl-DestinationIndex* from the stored NR sidelink measurement configuration information;

2\> for each *sl-DestinationIndex* included in the received *sl-MeasConfigInfoToAddModList* that is not part of the current stored NR sidelink measurement configuration:

3\> add a new entry for this *sl-DestinationIndex* to the stored NR sidelink measurement configuration.

NOTE 1: The UE is expected to update the mapping between the Destination Layer-2 ID and the destination index for the stored NR sidelink measurement configuration after the UE updates the destination list and reports to the gNB.

1\> if *sl-DRX-ConfigUC-ToReleaseList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> for each *SL-DestinationIndex* included in the received *sl-DRX-ConfigUC-ToReleaseList* that is part of the current UE configuration:

3\> remove the entry with the matching *SL-DestinationIndex* from the stored NR sidelink DRX configuration information;

1\> if *sl-DRX-ConfigUC-ToAddModList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> for each *sl-DestinationIndex* included in the received *sl-DRX-ConfigUC-ToAddModList* that is part of the current stored NR sidelink DRX configuration:

3\> reconfigure the entry according to the value received for this *sl-DestinationIndex* from the stored NR sidelink DRX configuration information;

2\> for each *sl-DestinationIndex* included in the received *sl-DRX-ConfigUC-ToAddModList* that is not part of the current stored NR sidelink DRX configuration:

3\> add a new entry for this *sl-DestinationIndex* to the stored NR sidelink DRX configuration.

NOTE 2: The UE is expected to update the mapping between the Destination Layer-2 ID and the destination index for the stored NR sidelink DRX configuration after the UE updates the destination list and reports to the gNB.

1\> if *sl-RLC-ChannelToReleaseList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration*:

2\> perform PC5 Relay RLC channel release as specified in 5.8.9.7.1;

1\> if *sl-RLC-ChannelToAddModList* is included in *sl-ConfigDedicatedNR* within *RRCReconfiguration* or *RRCSetup*:

2\> perform PC5 Relay RLC channel addition/modification as specified in 5.8.9.7.2;

#### 5.3.5.15 L2 U2N or U2U Relay UE configuration

##### 5.3.5.15.1 General

The network configures the L2 U2N or U2U Relay UE with relay operation related configurations. For each connected L2 U2N or U2U Remote UE indicated in *sl-L2IdentityRemote*, the network provides the configuration parameters used for relaying.

The L2 U2N Relay UE shall:

1\> if *sl-L2RelayUE-Config* is set to setup:

2\> if the *sl-L2RelayUE-Config* contains the *sl-RemoteUE-ToReleaseList*:

3\> perform the L2 U2N Remote UE release as specified in 5.3.5.15.2;

2\> if the *sl-L2RelayUE-Config* contains the *sl-RemoteUE-ToAddModList*:

3\> perform the L2 U2N Remote UE addition/modification as specified in 5.3.5.15.3;

1\> else if *sl-L2RelayUE-Config* is set to *release*:

2\> release the relay operation related configurations.

The L2 U2U Relay UE shall:

1\> if *sl-L2RelayUE-Config* is set to setup:

2\> if the *sl-L2RelayUE-Config* contains the *sl-U2U-RemoteUE-ToReleaseList*:

3\> perform the L2 U2U Remote UE release as specified in 5.3.5.15.2;

2\> if the *sl-L2RelayUE-Config* contains the *sl-U2U-RemoteUE-ToAddModList*:

3\> perform the L2 U2U Remote UE addition/modification as specified in 5.3.5.15.3;

1\> else if *sl-L2RelayUE-Config* is set to release:

2\> release the related configurations.

##### 5.3.5.15.2 L2 U2N or U2U Remote UE Release

The L2 U2N Relay UE shall:

1\> if the release is triggered by reception of the *sl-RemoteUE-ToReleaseList*:

2\> for each *SL-DestinationIdentity* value included in the *sl-RemoteUE-ToReleaseList*:

3\> if the current UE has a PC5 RRC connection to a L2 U2N Remote UE with *SL-DestinationIdentity*:

4\> indicate upper layers to trigger PC5 unicast link release.

The L2 U2U Relay UE shall:

1\> if the release is triggered by reception of the *sl-U2U-RemoteUE-ToReleaseList*:

2\> for each *SL-DestinationIdentity* value included in the *sl-U2U-RemoteUE-ToReleaseList*:

3\> release the configuration associated with the L2 U2U Remote UE.

##### 5.3.5.15.3 L2 U2N or U2U Remote UE Addition/Modification

The L2 U2N Relay UE shall:

1\> if no SRAP entity has been established:

2\> establish a SRAP entity as specified in TS 38.351 \[66\];

1\> for each *sl-L2IdentityRemote* value included in the *sl-RemoteUE-ToAddModList* that is not part of the current UE configuration (L2 U2N Remote UE Addition):

2\> configure the parameters to SRAP entity in accordance with the *sl-SRAP-ConfigRelay*;

2\> if SRB1 is included in *sl-MappingToAddModList*, and *sl-EgressRLC-ChannelPC5* is configured:

3\> release SL-RLC1, if established;

3\> associate the PC5 Relay RLC channel as indicated by *sl-EgressRLC-ChannelPC5* with SRB1;

2\> else: (i.e. SRB1 is not included in *sl-MappingToAddModList*, or SRB1 is included in *sl-MappingToAddModList*, but *sl-EgressRLC-ChannelPC5* is not configured)

3\> if SL-RLC1 is not established:

4\> apply the default configuration of SL-RLC1 as specified in clause 9.2.4 and associate it with the SRB1;

1\> for each *sl-L2IdentityRemote* value included in the *sl-RemoteUE-ToAddModList* that is part of the current UE configuration (L2 U2N Remote UE modification):

2\> modify the configuration in accordance with the *sl-SRAP-ConfigRelay*;

The L2 U2U Relay UE shall:

1\> if no SRAP entity has been established:

2\> establish a SRAP entity as specified in TS 38.351 \[66\];

1\> for each target L2 U2U Remote UE indicated in *sl-L2IdentityRemote* value included in the *sl-U2U-RemoteUE-ToAddModList* that is not part of the current UE configuration (target L2 U2U Remote UE Addition):

2\> for each source L2 U2U Remote UE indicated in *sl-SourceUE-Identity* in accordance with one entry of the *sl-SourceRemoteUE-ToAddModList*, configure the parameters to SRAP entity in accordance with the *sl-SRAP-ConfigU2U*;

1\> for each target L2 U2U Remote UE indicated in *sl-L2IdentityRemote* value included in the *sl-U2U-RemoteUE-ToAddModList* that is part of the current UE configuration (target L2 U2U Remote UE modification):

2\> for each source L2 U2U Remote UE indicated in *sl-SourceUE-Identity* included in the *sl-SourceRemoteUE-ToReleaseList* (source L2 U2U Remote UE Release):

3\> release the configuration associated with the source L2 U2U Remote UE;

2\> for the source L2 U2U Remote UE indicated in *sl-SourceUE-Identity* included in the *sl-SourceRemoteUE-ToAddModList* that is not part of the current UE configuration (source L2 U2U Remote UE Addition):

3\> configure the parameters to SRAP entity in accordance with the *sl-SRAP-ConfigU2U*;

2\> for the source L2 U2U Remote UE indicated in *sl-SourceUE-Identity* included in the *sl-SourceRemoteUE-ToAddModList* that is part of the current UE configuration (source L2 U2U Remote UE modification):

3\> modify the configuration in accordance with the *sl-SRAP-ConfigU2U*;

#### 5.3.5.16 L2 U2N or U2U Remote UE configuration

The network configures the L2 U2N or U2U Remote UE with relay operation related configurations, e.g. SRAP configuration.

The L2 U2N Remote UE shall:

1\> if *sl-L2RemoteUE-Config* is set to *setup* or received from *RRCSetup* message:

2\> if the *sl-L2RemoteUE-Config* contains the *sl-SRAP-ConfigRemote*:

3\> if no SRAP entity has been established:

4\> establish a SRAP entity as specified in TS 38.351 \[66\];

3\> configure the parameters to SRAP entity in accordance with the *sl-SRAP-ConfigRemote*;

3\> if SRB1 is included in *sl-MappingToAddModList*, and *sl-EgressRLC-ChannelPC5* is configured:

4\> release SL-RLC1, if established;

4\> associate the PC5 Relay RLC channel as indicated by *sl-EgressRLC-ChannelPC5* with SRB1;

3\> else: (i.e. SRB1 is not included in *sl-MappingToAddModList*, or SRB1 is included in *sl-MappingToAddModList*, but *sl-EgressRLC-ChannelPC5* is not configured)

4\> if SL-RLC1 is not established:

5\> apply the default configuration of SL-RLC1 as specified in clause 9.2.4 and associate it with the SRB1;

2\> if the *sl-L2RemoteUE-Config* contains the *sl-UEIdentityRemote*:

3\> use the value of the *sl-UEIdentityRemote* as the C-RNTI in the PCell.

1\> else if *sl-L2RemoteUE-Config* is set to *release*:

2\> release the relay operation related configurations.

The L2 U2U Remote UE shall:

1\> if *sl-L2RemoteUE-Config* is set to setup:

2\> if the *sl-L2RemoteUE-Config* contains the *sl-U2U-RelayUE-ToReleaseList*:

3\> perform the L2 U2U Relay UE release as specified in 5.3.5.16.1;

2\> if the *sl-L2RemoteUE-Config* contains the *sl-U2U-RelayUE-ToAddModList*:

3\> perform the L2 U2U Relay UE addition/modification as specified in 5.3.5.16.2;

1\> else if *sl-L2RemoteUE-Config* is set to release:

2\> release the related configurations.

##### 5.3.5.16.1 L2 U2U Relay UE Release

The L2 U2U Relay UE shall:

1\> if the release is triggered by reception of the *sl-U2U-RelayUE-ToReleaseList*:

2\> for each SL-DestinationIdentity value included in the *sl-U2U-RelayUE-ToReleaseList*:

3\> release the configuration associated with the L2 U2U Relay UE.

##### 5.3.5.16.2 L2 U2U Relay UE Addition/Modification

The L2 U2U Remote UE shall:

1\> if no SRAP entity has been established:

2\> establish a SRAP entity as specified in TS 38.351 \[66\];

1\> for each L2 U2U Relay UE indicated in *sl-L2IdentityRelay* value included in the *sl-U2U-RelayUE-ToAddModList* that is not part of the current UE configuration (L2 U2U Relay UE Addition):

2\> for peer target L2 U2U Remote UE indicated in *sl-TargetUE-Identity* in accordance with one entry of the *SL-PeerRemoteUE-ToAddModList*, configure the parameters to SRAP entity in accordance with the *sl-SRAP-ConfigU2U*;

1\> for each L2 U2U Relay UE indicated in *sl-L2IdentityRelay* value included in the *sl-U2U-RelayUE-ToAddModList* that is part of the current UE configuration (L2 U2U Relay UE modification):

2\> for each peer target L2 U2U Remote UE included in the *sl-PeerRemoteUE-ToReleaseList* (peer target L2 U2U Remote UE Release):

3\> release the configuration associated with the peer target L2 U2U Remote UE;

2\> for the peer target L2 U2U Remote UE indicated in *sl-TargetUE-Identity* included in the *sl-PeerTargetRemoteUE-ToAddModList* that is not part of the current UE configuration (peer target L2 U2U Remote UE Addition):

3\> configure the parameters to SRAP entity in accordance with the *sl-SRAP-ConfigU2U*;

2\> for the peer target L2 U2U Remote UE indicated in *sl-TargetUE-Identity* included in the *sl-PeerTargetRemoteUE-ToAddModList* that is part of the current UE configuration (peer target L2 U2U Remote UE modification):

3\> modify the configuration in accordance with the *sl-SRAP-ConfigU2U*;

#### 5.3.5.17 MP configuration

##### 5.3.5.17.1 Introduction

In case of MP, a MP remote UE is configured with one direct path (i.e. MCG) and one indirect path. The MP remote UE connects to network on the direct path using NR Uu, and connects to network on the indirect path via a MP relay UE.

On indirect path, for the hop between the MP remote UE and the MP relay UE, when the MP remote UE connects to a L2 U2N Relay UE, i.e. the MP remote UE is acting as a L2 U2N Remote UE, the network provides the configuration of SL indirect path to the MP remote UE and the L2 U2N Relay UE as specified in 5.3.5.17.2; when the MP remote UE connects to a N3C relay UE using non-3GPP connection, the network provides the configuration of N3C indirect path to the MP remote UE and the N3C relay UE as specified in 5.3.5.17.3.

##### 5.3.5.17.2 Configuration of SL indirect path

###### 5.3.5.17.2.1 General

For SL indirect path:

- the L2 U2N Remote UE is provided with sidelink dedicated configuration as specified in 5.3.5.14, L2 U2N Remote UE configuration as specified in 5.3.5.16, and SL indirect path specific configuration as specified in 5.3.5.17.2.2;

- the L2 U2N Relay UE is provided with sidelink dedicated configuration as specified in 5.3.5.14, L2 U2N Relay UE configuration as specified in 5.3.5.15, as well as Uu Relay RLC channel configuration as specified in 5.3.5.5.12 and 5.3.5.5.13.

###### 5.3.5.17.2.2 SL indirect path specific configuration

The L2 U2N Remote UE shall:

1\> if *sl-IndirectPathAddChange* is set to setup:

2\> consider the UE indicated by the *sl-IndirectPathRelayUE-Identity* to be the (target) L2 U2N Relay UE and indicate to upper layer to trigger the PC5 unicast link establishment with the L2 U2N Relay UE;

2\> start timer T421 for the corresponding L2 U2N Relay UE with the timer value set to T421;

2\> indicate to upper layer (to trigger the PC5 unicast link release) with the source L2 U2N Relay UE in case of SL indirect path change (i.e. a new L2 U2N Relay UE is indicated via *sl-IndirectPathRelayUE-Identity*);

1\> else if *sl-IndirectPathAddChange* is set to release:

2\> consider the SL indirect path is released and release the corresponding configurations;

2\> indicate to upper layer (to trigger the PC5 unicast link release) with the L2 U2N Relay UE.

###### 5.3.5.17.2.3 T421 expiry (Indirect path addition/change failure)

The UE shall:

1\> if T421 expires; or

1\> if the (target) L2 U2N Relay UE (i.e., the UE indicated by *sl-IndirectPathRelayUE-Identity* in the received *sl-IndirectPathAddChange*) changes its serving PCell to a different cell from the target cell (i.e. the cell indicated by *sl-IndirectPathCellIdentity* in the received *sl-IndirectPathAddChange*) before path addition or change:

2\> if MCG transmission is not suspended:

3\> initiate the indirect path failure information procedure as specified in clause 5.7.3c to report indirect path addition/change failure;

2\> else:

3\> initiate the connection re-establishment procedure as specified in clause 5.3.7;

##### 5.3.5.17.3 Configuration of N3C indirect path

###### 5.3.5.17.3.1 General

For N3C indirect path,

- the N3C remote UE is provided with N3C indirect path configuration including relay UE identification as specified in 5.3.5.17.3.2;

- the N3C relay UE is provided with N3C indirect path configuration including bearer mapping configurations as specified in 5.3.5.17.3.4, as well as Uu Relay RLC channel configuration as specified in 5.3.5.5.12 and 5.3.5.5.13.

NOTE: The data transmission/reception between the N3C remote UE and the N3C relay UE via the non-3GPP connection is outside the scope of 3GPP.

###### 5.3.5.17.3.2 N3C remote UE configuration

The N3C remote UE shall:

1\> if *n3c-IndirectPathAddChange* is set to setup:

2\> consider the non-3GPP connection with the relay UE indicated by the *n3c-RelayIdentification* to be used for the N3C indirect path;

2\> consider the source non-3GPP connection is not to be used in case of N3C indirect path change (i.e. a new relay UE is indicated by the *n3c-RelayIdentification*);

1\> else if *n3c-IndirectPathAddChange* is set to release:

2\> consider the indirect path is not to be used and release the corresponding configuration.

Editor\'s Note: whether T421 is applicable to scenario 2.

###### 5.3.5.17.3.3 N3C relay UE configuration

The N3C relay UE shall:

1\> if *n3c-IndirectPathConfigRelay* is set to setup:

2\> if *n3c-MappingToReleaseList* is included:

3\> perform N3C bearer mapping release as specified in 5.3.5.17.3.4.1;

2\> if *n3c-MappingToAddModList* is included:

3\> perform N3C bearer mapping addition/modification as specified in 5.3.5.17.3.4.2;

1\> else if *n3c-IndirectPathConfigRelay* is set to release:

2\> consider the indirect path with the remote UE is released and release the corresponding configuration.

###### 5.3.5.17.3.4 Bearer mapping management on N3C indirect path

####### 5.3.5.17.3.4.1 Bearer mapping release

The UE shall:

1\> if the release is triggered by reception of *n3c-IndirectPathConfigRelay* set to *release*:

2\> for all configured *SL-RemoteUE-RB-Identity* value:

3\> release *n3c-RLC-ChannelUu* and *n3c-RemoteUE-RB-Identity*;

1\> else if the release is triggered by reception of the *n3c-MappingToReleaseList*:

2\> for each *SL-RemoteUE-RB-Identity* value included in *n3c-MappingToReleaseList*:

3\> release the corresponding *n3c-RLC-ChannelUu* and *n3c-RemoteUE-RB-Identity*;

####### 5.3.5.17.3.4.2 Bearer mapping addition and modification

The UE shall:

1\> for each *n3c-RemoteUE-RB-Identity* value included in the *n3c-MappingToAddModList* that is not part of the current UE configuration:

2\> associate the remote UE\'s RB indicated in *n3c-RemoteUE-RB-Identity* to the Uu RLC channel indicated in *n3c-RLC-ChannelUu*;

1\> for the *n3c-RemoteUE-RB-Identity* value included in the *n3c-MappingToAddModList* that is part of the current UE configuration:

2\> update the associated Uu RLC channel to the one indicated in *n3c-RLC-ChannelUu.*

#### 5.3.5.18 LTM configuration and execution

##### 5.3.5.18.1 LTM configuration

The network configures the UE with one or more LTM candidate configurations within the *LTM-Config* IE.

In NR-DC, the UE may receive two independent *ltm-Config:*

- an *ltm-Config* associated with the MCG that is included within an *RRCReconfiguration* message received via SRB1; and

- an *ltm-Config* associated with the SCG that is included within an *RRCReconfiguration* message either received via SRB3, or, alternatively, embedded in an *RRCReconfiguration* message received via SRB1.

In case the UE receives two independent *ltm-Config*:

- the UE maintains two independent *VarLTM-Config*, one associated with each *ltm-Config*;

- the UE maintains two independent *VarLTM-ServingCellNoResetID*, one associated with each *ltm-Config*;

- the UE maintains two independent *VarLTM-ServingCellUE-MeasuredTA-ID*, one associated with each *ltm-Config*;

- the UE independently performs all the procedures in clause 5.3.5.18 for each *ltm-Config* and the associated *VarLTM-Config, VarLTM-ServingCellNoResetID*, and *VarLTM-ServingCellUE-MeasuredTA-ID* unless explicitly stated otherwise.

The UE shall perform the following actions based on the received *LTM-Config* IE:

1\> if the received *LTM-Config* includes *ltm-ReferenceConfiguration* set to *setup:*

2\> if the current *VarLTM-Config* includes an *ltm-ReferenceConfiguration*:

3\> replace the *ltm-ReferenceConfiguration* value within *VarLTM-Config* with the received *ltm-ReferenceConfiguration*;

2\> else:

3\> store the received *ltm-ReferenceConfiguration* in *VarLTM-Config*;

1\> else (the received *LTM-Config* includes *ltm-ReferenceConfiguration* set to *release*):

2\> remove *ltm-ReferenceConfiguration* in *VarLTM-Config*;

1\> if the received *LTM-Config* includes *ltm-ServingCellNoResetID*:

2\> if the current *VarLTM-ServingCellNoResetID* includes an *ltm-ServingCellNoResetID*:

3\> replace the *ltm-ServingCellNoResetID* value within *VarLTM-ServingCellNoResetID* with the received *ltm-ServingCellNoResetID*;

2\> else:

3\> store the received *ltm-ServingCellNoResetID* in *VarLTM-ServingCellNoResetID*;

1\> if the received *LTM-Config* includes *ltm-ServingCellUE-MeasuredTA-ID*:

2\> if the current *VarLTM-ServingCellUE-MeasuredTA-ID* includes an *ltm-ServingCellUE-MeasuredTA-ID*:

3\> replace the *ltm-ServingCellUE-MeasuredTA-ID* value within *VarLTM-ServingCellUE-MeasuredTA-ID* with the received *ltm-ServingCellUE-MeasuredTA-ID*;

2\> else:

3\> store the received *ltm-ServingCellUE-MeasuredTA-ID* in *VarLTM-ServingCellUE-MeasuredTA-ID*;

1\> if the received *LTM-Config* includes *ltm-CSI-ResourceConfigToReleaseList:*

2\> perform the LTM CSI resource configuration release as specified in 5.3.5.18.4;

1\> if the received *LTM-Config* includes *ltm-CSI-ResourceConfigToAddModList*:

2\> perform the LTM CSI resource configuration addition or modification as specified in 5.3.5.18.5;

1\> if the received *LTM-Config* includes the *ltm-CandidateToReleaseList:*

2\> perform the LTM candidate configuration release as specified in 5.3.5.18.2;

1\> if the received *LTM-Config* includes the *ltm-CandidateToAddModList*:

2\> perform the LTM candidate configuration addition or modification as specified in 5.3.5.18.3.

##### 5.3.5.18.2 LTM candidate configuration release

The UE shall:

1\> for each *ltm-CandidateId* value included in the *ltm-CandidateToReleaseList* for which there is an entry in *ltm-CandidateList* in *VarLTM-Config*:

2\> remove the entry related to *LTM-Candidate* from *VarLTM-Config*.

##### 5.3.5.18.3 LTM candidate configuration addition/modification

The UE shall:

1\> for each *ltm-CandidateId* value in the *ltm-CandidateToAddModList*:

2\> if the current *VarLTM-Config* includes an *LTM-Candidate* with the *ltm-CandidateId* value:

3\> replace the *LTM-Candidate* within *VarLTM-Config* in accordance with the received *LTM-Candidate*;

2\> else:

3\> add the received *LTM-Candidate* to *VarLTM-Config*;

2\> if the received *LTM-Candidate* includes *ltm-DL-OrJointTCI-StateToReleaseList*:

3\> for each *tci-StateId* in the *ltm-DL-OrJointTCI-StateToReleaseList*:

4\> if the current *VarLTM-Config* includes a *CandidateTCI-State* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *tci-StateId* value:

5\> remove the entry related to *CandidateTCI-State* within the *LTM-Candidate* from *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *ltm-DL-OrJointTCI-StateToAddModList*:

3\> for each *tci-StateId* in the *ltm-DL-OrJointTCI-StateToAddModList*:

4\> if the current *VarLTM-Config* includes a *CandidateTCI-State* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *tci-StateId* value:

5\> replace the entry related to *CandidateTCI-State* within the *LTM-Candidate* from *VarLTM-Config*.

4\> else:

5\> add the received *CandidateTCI-State* within *LTM-Candidate* to *VarLTM-Config*;

2\> if the received *LTM-Candidate* includes *ltm-UL-TCI-StatesToReleaseList*:

3\> for each *tci-StateId* in the *ltm-UL-TCI-StatesToReleaseList*:

4\> if the current *VarLTM-Config* includes an *CandidateTCI-UL-State* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *tci-StateId* value:

5\> remove the entry related to *CandidateTCI-UL-State* within the *LTM-Candidate* from *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *ltm-UL-TCI-StatesToAddModList*:

3\> for each *tci-StateId* in the *ltm-UL-TCI-StatesToAddModList*:

4\> if the current *VarLTM-Config* includes an *CandidateTCI-UL-State* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *tci-StateId* value:

5\> replace the entry related to *CandidateTCI-UL-State* within the *LTM-Candidate* from *VarLTM-Config*.

4\> else:

5\> add the received *CandidateTCI-UL-State* within *LTM-Candidate* to *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *ltm-nzp-CSI-RS-ResourceToReleaseList*:

3\> for each *nzp-CSI-RS-ResourceId* in the *ltm-nzp-CSI-RS-ResourceToReleaseList*:

4\> if the current *VarLTM-Config* includes an *NZP-CSI-RS-Resource* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *nzp-CSI-RS-ResourceId* value:

5\> remove the entry related to *NZP-CSI-RS-Resource* within the *LTM-Candidate* from *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *ltm-nzp-CSI-RS-ResourceToAddModList*:

3\> for each *nzp-CSI-RS-ResourceId* in the *ltm-nzp-CSI-RS-ResourceToReleaseList*:

4\> if the current *VarLTM-Config* includes an *NZP-CSI-RS-Resource* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *nzp-CSI-RS-ResourceId* value:

5\> replace the entry related to *NZP-CSI-RS-Resource* within the *LTM-Candidate* from *VarLTM-Config*.

4\> else:

5\> add the received *NZP-CSI-RS-Resource* within *LTM-Candidate* to *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *ltm-nzp-CSI-RS-ResourceSetToReleaseList*:

3\> for each *nzp-CSI-RS-ResourceSetId* in the *ltm-nzp-CSI-RS-ResourceSetToReleaseList*:

4\> if the current *VarLTM-Config* includes an *NZP-CSI-RS-ResourceSet* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *nzp-CSI-RS-ResourceSetId* value:

5\> remove the entry related to *NZP-CSI-RS-ResourceSet* within the *LTM-Candidate* from *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *ltm-nzp-CSI-RS-ResourceSetToAddModList*:

3\> for each *nzp-CSI-RS-ResourceSetId* in the *ltm-nzp-CSI-RS-ResourceSetToReleaseList*:

4\> if the current *VarLTM-Config* includes an *NZP-CSI-RS-ResourceSet* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *nzp-CSI-RS-ResourceSetId* value:

5\> replace the entry related to *NZP-CSI-RS-ResourceSet* within the *LTM-Candidate* from *VarLTM-Config*.

4\> else:

5\> add the received *NZP-CSI-RS-ResourceSet* within *LTM-Candidate* to *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *pathlossReferenceRS-ToReleaseList*:

3\> for each *pathlossReferenceRS-Id* in the *pathlossReferenceRS-ToReleaseList*:

4\> if the current *VarLTM-Config* includes an *PathlossReferenceRS* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *pathlossReferenceRS-Id* value:

5\> remove the entry related to *PathlossReferenceRS* within the *LTM-Candidate* from *VarLTM-Config*.

2\> if the received *LTM-Candidate* includes *pathlossReferenceRS-ToAddModList*:

3\> for each *pathlossReferenceRS-Id* in the *pathlossReferenceRS-ToAddModList*:

4\> if the current *VarLTM-Config* includes an *PathlossReferenceRS* within an *LTM-Candidate* with the *ltm-CandidateId* value that is associated with the *pathlossReferenceRS-Id* value:

5\> replace the entry related to *PathlossReferenceRS* within the *LTM-Candidate* from *VarLTM-Config*.

4\> else:

5\> add the received *PathlossReferenceRS* within *LTM-Candidate* to *VarLTM-Config*.

2\> if the *LTM-Candidate* with the received *ltm-CandidateId* value includes *ltm-UE-MeasuredTA-ID*:

3\> if the value of *ltm-UE-MeasuredTA-ID* is equal to the value of *ltm-ServingCellUE-MeasuredTA-ID* within *VarLTM-ServingCellUE-MeasuredTA-ID*:

4\> inform lower layers that UE is configured with UE-based TA measurements if an LTM cell switch is executed for this LTM candidate configuration;

##### 5.3.5.18.4 LTM CSI resource configuration release

The UE shall:

1\> for each *ltm-CSI-ResourceConfigId* value included in the *ltm-CSI-ResourceConfigToReleaseList* for which there is an entry in *ltm-CSI-ResourceConfigList* in *VarLTM-Config*:

2\> remove the entry related to the *LTM-CSI-ResourceConfig* from *VarLTM-Config*.

##### 5.3.5.18.5 LTM CSI resource configuration addition/modification

The UE shall:

1\> for each *ltm-CSI-ResourceConfigId* value in the *ltm-CSI-ResourceConfigToAddModList*:

2\> if the current *VarLTM-Config* includes an *LTM-CSI-ResourceConfig* with the *ltm-CSI-ResourceConfigId* value:

3\> replace the *LTM-CSI-ResourceConfig* within *VarLTM-Config* in accordance with the received *LTM-CSI-ResourceConfig*;

2\> else:

3\> add the received *LTM-CSI-ResourceConfig* to *VarLTM-Config*.

##### 5.3.5.18.6 LTM cell switch execution

Upon the indication by lower layers that an LTM cell switch procedure is triggered, or upon performing LTM cell switch following cell selection performed while timer T311 was running, as specified in 5.3.7.3, the UE shall:

1\> release/clear all current dedicated radio configuration associated with the cell group for which the LTM cell switch procedure is triggered except for the following:

- the *logicalChannelIdentity* and *logicalChannelIdentityExt* of RLC bearers configured in *RLC-BearerConfig* and the associated RLC entities, their state variables, buffers, and timers;

- the UE variables *VarLTM-Config,* *VarLTM-ServingCellNoResetID*, and *VarLTM-ServingCellUE-MeasuredTA-ID*.

2\> if the LTM cell switch is triggered on the MCG:

- the MCG C-RNTI;

- the AS security configurations associated with the master key;

- for each SRB/DRB in current UE configuration which is using the master key:

- keep the associated PDCP and SDAP entities, their state variables, buffers and timers;

- release all fields related to the SRB/DRB configuration except for *srb-Identity* and *drb-Identity*;

2\> else, if the LTM cell switch is triggered on the SCG:

- the AS security configurations associated with the secondary key;

- for each SRB/DRB in current UE configuration which is using the secondary key:

- keep the associated PDCP and SDAP entities, their state variables, buffers and timers;

- release all fields related to the SRB/DRB configuration except for *srb-Identity* and *drb-Identity*;

1\> release/clear all current common radio configuration associated with the cell group for which the LTM cell switch procedure is triggered;

1\> use the default values specified in 9.2.3 for timers T310, T311 and constants N310, N311 associate to cell group for which the LTM cell switch procedure is triggered;

1\> if the value of field *ltm-NoResetID* contained within the *LTM-Candidate IE* in *VarLTM-Config* indicated by lower layers or for the selected cell in accordance with 5.3.7.3 is not equal to the value of *ltm-ServingCellNoResetID* within *VarLTM-ServingCellNoResetID*:

2\> for each *logicalChannelId* and *logicalChannelIdExt* that is part of the current UE configuration for the cell group for which the LTM cell switch procedure is triggered:

3\> after the end of this procedure, re-establish the corresponding RLC entity as specified in TS 38.322 \[4\], after applying the LTM configuration in *ltm-CandidateConfig* within *LTM-Candidate IE* in *VarLTM-Config*;

2\> for each *drb-Identity* value that is part of the current UE configuration:

3\> if this DRB is an AM DRB:

4\> after the end of this procedure, trigger the PDCP entity of this DRB to perform data recovery as specified in TS 38.323 \[5\], after applying the LTM configuration in *ltm-CandidateConfig* within *LTM-Candidate IE* in *VarLTM-Config*;

2\> replace the value of *ltm-ServingCellNoResetID* in *VarLTM-ServingCellNoResetID* with the value of *ltm-NoResetID* in the *LTM-Candidate* in *VarLTM-Config* indicated by lower layers or for the selected cell in accordance with 5.3.7.3;1\> if the *LTM-Candidate IE* in *VarLTM-Config* indicated by lower layers or for the selected cell in accordance with 5.3.7.3 contains the field *ltm-UE-MeasuredTA-ID*:

2\> replace the value of ltm-ServingCellUE-MeasuredTA-ID in VarLTM-ServingCellUE-MeasuredTA-ID with the value received within ltm-UE-MeasuredTA-ID;

1\> if *ltm-ConfigComplete* is not included within the *LTM-Candidate IE* in *VarLTM-Config* indicated by lower layers or for the selected cell in accordance with 5.3.7.3:

2\> consider *ltm-ReferenceConfiguration* in *VarLTM-Config*, associated with the cell group for which the LTM cell switch procedure is triggered, to be the current UE configuration for the fields and configurations which have been released and to be released by the actions above in this procedure;

NOTE 1: When the UE considers the reference configuration to be the current UE configuration, the UE should store fields and configurations that are part of the reference configuration but should not execute any actions or procedures triggered by the reception of an *RRCReconfiguration* message which are described in clause 5.3.5.3.

1\> if the LTM cell switch is triggered by an indication from lower layers:

2\> apply the *RRCReconfiguration* message in *ltm-CandidateConfig* within *LTM-Candidate IE* in *VarLTM-Config* identified by the LTM candidate configuration identity received from lower layers according to clause 5.3.5.3;

1\> else (LTM cell switch triggered upon cell selection performed while timer T311 was running):

2\> apply the *RRCReconfiguration* message in *ltm-CandidateConfig* within *LTM-Candidate IE* in *VarLTM-Config* related to the LTM candidate configuration identity for the selected cell (i.e., in accordance with 5.3.7.3) according to clause 5.3.5.3;

1\> release the radio bearer(s) and the logical channel(s) that are part of the current UE configuration but not part of the LTM candidate configuration either indicated by lower layers or for the selected cell in accordance with 5.3.7.3, or the LTM reference configuration (in case the LTM candidate configuration does not include *ltm-ConfigComplete*).

NOTE 2: When *ltm-ConfigComplete* is not included for an LTM candidate configuration, before an LTM cell switch is triggered a UE implementation may generate and store an RRC reconfiguration message by applying the received LTM candidate configuration on top of the LTM reference configuration, and the stored RRC reconfiguration message is applied when the LTM cell switch is triggered.

##### 5.3.5.18.7 LTM configuration release

For the cell group for which the LTM configuration release procedure is triggered, the UE shall:

1\> remove all entries within *VarLTM-ServingCellNoResetID*;

1\> remove the entry within *VarLTM-ServingCellUE-MeasuredTA-ID*;

1\> release from current UE configuration all entries of *ltm-CSI-ReportConfigToAddModList*.

1\> release *ltm-Config*;

#### 5.3.5.19 T348 expiry

The UE can apply the temporary UE capability restriction in accordance with the one indicated in the last transmission of the UEAssistanceInformation message including *musim-CapRestriction*, as specified in 5.7.4.3.

### 5.3.6 Counter check

#### 5.3.6.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: CounterCheck [ac];
u->n: CounterCheckResponse [ac];
|||;
~~~

Figure 5.3.6.1-1: Counter check procedure

The counter check procedure is used by the network to request the UE to verify the amount of data sent/ received on each DRB. More specifically, the UE is requested to check if, for each DRB, the most significant bits of the COUNT match with the values indicated by the network.

NOTE: The procedure enables the network to detect packet insertion by an intruder (a \'man in the middle\').

#### 5.3.6.2 Initiation

The network initiates the procedure by sending a *CounterCheck* message.

NOTE: The network may initiate the procedure when any of the COUNT values reaches a specific value.

#### 5.3.6.3 Reception of the *CounterCheck* message by the UE

Upon receiving the *CounterCheck* message, the UE shall:

1\> for each DRB that is established:

2\> if no COUNT exists for a given direction (uplink or downlink) because it is a uni-directional bearer configured only for the other direction:

3\> assume the COUNT value to be 0 for the unused direction;

2\> if the *drb-Identity* is not included in the *drb-CountMSB-InfoList*:

3\> include the DRB in the *drb-CountInfoList* in the *CounterCheckResponse* message by including the *drb-Identity*, the *count-Uplink* and the *count-Downlink* set to the value of TX_NEXT -- 1 and RX_NEXT -- 1 (specified in TS 38.323 \[5\]), respectively;

2\> else if, for at least one direction, the most significant bits of the COUNT are different from the value indicated in the *drb-CountMSB-InfoList*:

3\> include the DRB in the *drb-CountInfoList* in the *CounterCheckResponse* message by including the *drb-Identity*, the *count-Uplink* and the *count-Downlink* set to the value of TX_NEXT -- 1 and RX_NEXT -- 1 (specified in TS 38.323 \[5\]), respectively;

1\> for each DRB that is included in the *drb-CountMSB-InfoList* in the *CounterCheck* message that is not established:

2\> include the DRB in the *drb-CountInfoList* in the *CounterCheckResponse* message by including the *drb-Identity*, the *count-Uplink* and the *count-Downlink* with the most significant bits set identical to the corresponding values in the *drb-CountMSB-InfoList* and the least significant bits set to zero;

1\> submit the *CounterCheckResponse* message to lower layers for transmission upon which the procedure ends.

### 5.3.7 RRC connection re-establishment

#### 5.3.7.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCReestablishmentRequest [ac];
u<-n: RRCReestablishment [ac];
u->n: RRCReestablishmentComplete [ac];
|||;
~~~

Figure 5.3.7.1-1: RRC connection re-establishment, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCReestablishmentRequest [ac];
u<-n: RRCSetup [ac];
u->n: RRCSetupComplete [ac];
|||;
~~~

Figure 5.3.7.1-2: RRC re-establishment, fallback to RRC establishment, successful

The purpose of this procedure is to re-establish the RRC connection. A UE in RRC_CONNECTED, for which AS security has been activated with SRB2 and at least one DRB/multicast MRB setup or, for IAB and NCR, SRB2, may initiate the procedure in order to continue the RRC connection. The connection re-establishment succeeds if the network is able to find and verify a valid UE context or, if the UE context cannot be retrieved, and the network responds with an *RRCSetup* according to clause 5.3.3.4.

The network applies the procedure e.g as follows:

- When AS security has been activated and the network retrieves or verifies the UE context:

- to re-activate AS security without changing algorithms;

- to re-establish and resume the SRB1;

- When UE is re-establishing an RRC connection, and the network is not able to retrieve or verify the UE context:

- to discard the stored AS Context and release all RBs and BH RLC channels and Uu Relay RLC channels;

- to fallback to establish a new RRC connection.

If AS security has not been activated, the UE shall not initiate the procedure but instead moves to RRC_IDLE directly, with release cause \'other\'. If AS security has been activated, but SRB2 and at least one DRB or multicast MRB or, for IAB and NCR, SRB2, are not setup, the UE does not initiate the procedure but instead moves to RRC_IDLE directly, with release cause \'RRC connection failure\'.

#### 5.3.7.2 Initiation

The UE initiates the procedure when one of the following conditions is met:

1\> upon detecting radio link failure of the MCG and *t316* is not configured, in accordance with 5.3.10; or

1\> upon detecting radio link failure of the MCG while SCG transmission is suspended, in accordance with 5.3.10; or

1\> upon detecting radio link failure of the MCG while PSCell change or PSCell addition is ongoing, in accordance with 5.3.10; or

1\> upon detecting radio link failure of the MCG while the SCG is deactivated, in accordance with 5.3.10; or

1\> upon re-configuration with sync failure of the MCG, in accordance with clause 5.3.5.8.3; or

1\> upon mobility from NR failure, in accordance with clause 5.4.3.5; or

1\> upon integrity check failure indication from lower layers concerning SRB1 or SRB2, except if the integrity check failure is detected on the *RRCReestablishment* message; or

1\> upon an RRC connection reconfiguration failure, in accordance with clause 5.3.5.8.2; or

1\> upon detecting radio link failure for the SCG while MCG transmission is suspended, in accordance with clause 5.3.10.3 in NR-DC or in accordance with TS 36.331 \[10\] clause 5.3.11.3 in NE-DC; or

1\> upon reconfiguration with sync failure of the SCG while MCG transmission is suspended in accordance with clause 5.3.5.8.3; or

1\> upon SCG change failure while MCG transmission is suspended in accordance with TS 36.331 \[10\] clause 5.3.5.7a; or

1\> upon SCG configuration failure while MCG transmission is suspended in accordance with clause 5.3.5.8.2 in NR-DC or in accordance with TS 36.331 \[10\] clause 5.3.5.5 in NE-DC; or

1\> upon integrity check failure indication from SCG lower layers concerning SRB3 while MCG is suspended; or

1\> upon T316 expiry, in accordance with clause 5.7.3b.5; or

1\> upon detecting sidelink radio link failure by L2 U2N Remote UE in RRC_CONNECTED which is not configured with MP, in accordance with clause 5.8.9.3; or

1\> upon reception of *NotificationMessageSidelink* including *indicationType* by L2 U2N Remote UE in RRC_CONNECTED which is not configured with MP, in accordance with clause 5.8.9.10; or

1\> upon PC5 unicast link release for the serving L2 U2N Relay UE indicated by upper layer at L2 U2N Remote UE in RRC_CONNECTED which is not configured with MP while T301 is not running; or

1\> if MP is configured, upon detecting radio link failure of the MCG (i.e. direct path) in accordance with clause 5.3.10 while the transmission of indirect path is suspended as specified in 5.3.5.17; or

1\> if MP is configured, upon detecting sidelink radio link failure of SL indirect path by L2 U2N Remote UE, in accordance with clause 5.8.9.3, while MCG transmission (i.e. direct path) is suspended as specified in clause 5.7.3b; or

1\> if MP is configured, upon reception of *NotificationMessageSidelink* including *indicationType* in accordance with clause 5.8.9.10, while MCG transmission (i.e. direct path) is suspended as specified in clause 5.7.3b; or

1\> if MP is configured, upon PC5 unicast link release indicated by upper layer at L2 U2N Remote UE, while MCG transmission (i.e. direct path) is suspended as specified in clause 5.7.3b; or

1\> if MP is configured, upon detecting the failure of N3C indirect path by N3C remote UE in accordance with clause 5.7.3c, while MCG transmission (i.e. direct path) is suspended.

NOTE 0: It is up to UE implementation whether to initiate the procedure while T346g is running.

Upon initiation of the procedure, the UE shall:

1\> stop timer T310, if running;

1\> stop timer T312, if running;

1\> stop timer T304, if running;

1\> start timer T311;

1\> stop timer T316, if running;

1\> if UE is not configured with *attemptCondReconfig*; and

1\> if UE is not configured with *attemptLTM-Switch*:

2\> reset MAC;

2\> release *spCellConfig*, if configured;

2\> suspend all RBs, and BH RLC channels for IAB-MT, and Uu Relay RLC channels for L2 U2N Relay UE, except SRB0 and broadcast MRBs;

2\> release the MCG SCell(s), if configured;

2\> if MR-DC is configured:

3\> perform MR-DC release, as specified in clause 5.3.5.10;

2\> perform the LTM configuration release procedure for the MCG and the SCG as specified in clause 5.3.5.18.7;

2\> release *delayBudgetReportingConfig*, if configured and stop timer T342, if running;

2\> release *overheatingAssistanceConfig*, if configured and stop timer T345, if running;

2\> release *idc-AssistanceConfig*, if configured;

2\> release *btNameList*, if configured;

2\> release *wlanNameList*, if configured;

2\> release *sensorNameList*, if configured;

2\> release *drx-PreferenceConfig* for the MCG, if configured and stop timer T346a associated with the MCG, if running;

2\> release *maxBW-PreferenceConfig* for the MCG, if configured and stop timer T346b associated with the MCG, if running;

2\> release *maxCC-PreferenceConfig* for the MCG, if configured and stop timer T346c associated with the MCG, if running;

2\> release *maxMIMO-LayerPreferenceConfig* for the MCG, if configured and stop timer T346d associated with the MCG, if running;

2\> release *minSchedulingOffsetPreferenceConfig* for the MCG, if configured stop timer T346e associated with the MCG, if running;

2\> release *rlm-RelaxationReportingConfig* for the MCG, if configured and stop timer T346j associated with the MCG, if running;

2\> release *bfd-RelaxationReportingConfig* for the MCG, if configured and stop timer T346k associated with the MCG, if running;

2\> release *releasePreferenceConfig*, if configured stop timer T346f, if running;

2\> release *onDemandSIB-Request* if configured, and stop timer T350, if running;

2\> release *referenceTimePreferenceReporting*, if configured;

2\> release *sl-AssistanceConfigNR*, if configured;

2\> release *obtainCommonLocation*, if configured;

2\> release *musim-GapAssistanceConfig*, if configured and stop timer T346h, if running;

2\> release *musim-GapPriorityAssistanceConfig*, if configured;

2\> release *musim-LeaveAssistanceConfig*, if configured;

2\> release *musim-CapabilityRestrictionConfig*, if configured and stop timer T346n, if running;

2\> release *ul-GapFR2-PreferenceConfig*, if configured;

2\> release *scg-DeactivationPreferenceConfig*, if configured, and stop timer T346i, if running;

2\> release *propDelayDiffReportConfig*, if configured;

2\> release *rrm-MeasRelaxationReportingConfig*, if configured;

2\> release *maxBW-PreferenceConfigFR2-2*, if configured;

2\> release *maxMIMO-LayerPreferenceConfigFR2-2*, if configured;

2\> release *minSchedulingOffsetPreferenceConfigExt*, if configured;

2\> release *multiRx-PreferenceReportingConfigFR2*, if configured, and stop timer T440, if running;

2\> release *uav-FlightPathAvailabilityConfig*, if configured;

2\> release *ul-TrafficInfoReportingConfig*, if configured, and stop all instances of timer T346x, if running;

1\> release *successHO-Config*, if configured;

1\> release *successPSCell-Config* configured by the PCell, if configured;

1\> release *successPSCell-Config* configured by the PSCell, if configured;

1\> if any DAPS bearer is configured:

2\> reset the source MAC and release the source MAC configuration;

2\> for each DAPS bearer:

3\> release the RLC entity or entities as specified in TS 38.322 \[4\], clause 5.1.3, and the associated logical channel for the source SpCell;

3\> reconfigure the PDCP entity to release DAPS as specified in TS 38.323 \[5\];

2\> for each SRB:

3\> release the PDCP entity for the source SpCell;

3\> release the RLC entity as specified in TS 38.322 \[4\], clause 5.1.3, and the associated logical channel for the source SpCell;

2\> release the physical channel configuration for the source SpCell;

2\> discard the keys used in the source SpCell (the K~gNB~ key, the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key), if any;

1\> release *sl-L2RelayUE-Config*, if configured;

1\> release *sl-L2RemoteUE-Config*, if configured;

1\> release the SRAP entity, if configured;

1\> release *NCR-FwdConfig*, if configured;

1\> if the UE is NCR-MT:

2\> indicate to NCR-Fwd to cease forwarding;

1\> if SL indirect path is configured:

2\> release cell identity and relay UE ID configured in *sl-IndirectPathAddChange*;

2\> indicate upper layers to trigger PC5 unicast link release of the SL indirect path;

1\> if N3C indirect path is configured:

2\> release *n3c-IndirectPathAddChange*;

2\> consider the non-3GPP connection is not used;

1\> if the UE is acting as a N3C relay UE:

2\> release *n3c-IndirectPathConfigRelay*;

2\> consider the non-3GPP connection is not used;

1\> if the UE is acting as L2 U2N Remote UE and MP via L2 U2N Relay UE is not configured:

2\> if the PC5-RRC connection with the U2N Relay UE is determined to be released:

3\> indicate upper layers to trigger PC5 unicast link release;

3\> perform either cell selection in accordance with the cell selection process as specified in TS 38.304 \[20\], or relay selection as specified in clause 5.8.15.3, or both;

2\> else (i.e., maintain the PC5 RRC connection):

3\> consider the connected L2 U2N Relay UE as suitable and perform actions as specified in clause 5.3.7.3a;

NOTE 1: It is up to Remote UE implementation whether to release or keep the current PC5 unicast link.

1\> else:

2\> if the UE is capable of L2 U2N Remote UE:

3\> perform either cell selection as specified in TS 38.304 \[20\], or relay selection as specified in clause 5.8.15.3, or both;

2\> else:

3\> perform cell selection in accordance with the cell selection process as specified in TS 38.304 \[20\].

NOTE 2: For L2 U2N Remote UE, if both a suitable cell and a suitable relay are available, the UE can select either one based on its implementation.

#### 5.3.7.3 Actions following cell selection while T311 is running

Upon selecting a suitable NR cell, the UE shall:

1\> ensure having valid and up to date essential system information as specified in clause 5.2.2.2;

1\> stop timer T311;

1\> if T390 is running:

2\> stop timer T390 for all access categories;

2\> perform the actions as specified in 5.3.14.4;

1\> stop the relay (re)selection procedure, if ongoing;

1\> if the cell selection is triggered by detecting radio link failure of the MCG or re-configuration with sync failure of the MCG or mobility from NR failure, and

1\> if *attemptCondReconfig* is configured; and

1\> if the selected cell is not configured with *CondEventT1*, or the selected cell is configured with *CondEventT1* and leaving condition has not been fulfilled; and

1\> if the selected cell is one of the candidate cells for which the *reconfigurationWithSync* is included in the *masterCellGroup* in the MCG *VarConditionalReconfig* and the *condExecutionCondPSCell* is not configured for the corresponding *condReconfigId* in the MCG *VarConditionalReconfig*:

2\> if the UE supports RLF-Report for conditional handover, set the *choCellId* in the *VarRLF-Report* to the global cell identity, if available, otherwise to the physical cell identity and carrier frequency of the selected cell;

2\> apply the stored *condRRCReconfig* associated to the selected cell and perform actions as specified in 5.3.5.3;

NOTE 1: It is left to network implementation to how to avoid keystream reuse in case of CHO based recovery after a failed handover without key change.

1\> if the cell selection is triggered by detecting radio link failure of the MCG or re-configuration with sync failure of the MCG or mobility from NR failure; and

1\> if *attemptLTM-Switch* is configured; and

1\> if the selected cell is one of the LTM candidate cells in the *LTM-Candidate* IE within *VarLTM-Config* associated with the MCG:

2\> perform the LTM cell switch procedure for the selected LTM candidate cell according to the actions specified in 5.3.5.18.6;

1\> else:

2\> if UE is configured with *attemptCondReconfig*; or

2\> if UE is configured with *attemptLTM-Switch*:

3\> reset MAC;

3\> release *spCellConfig*, if configured;

3\> release the MCG SCell(s), if configured;

3\> release *delayBudgetReportingConfig*, if configured and stop timer T342, if running;

3\> release *overheatingAssistanceConfig* , if configured and stop timer T345, if running;

3\> if MR-DC is configured:

4\> perform MR-DC release, as specified in clause 5.3.5.10;

3\> release *idc-AssistanceConfig*, if configured;

3\> release *btNameList*, if configured;

3\> release *wlanNameList*, if configured;

3\> release *sensorNameList*, if configured;

3\> release *drx-PreferenceConfig* for the MCG, if configured and stop timer T346a associated with the MCG, if running;

3\> release *maxBW-PreferenceConfig* for the MCG, if configured and stop timer T346b associated with the MCG, if running;

3\> release *maxCC-PreferenceConfig* for the MCG, if configured and stop timer T346c associated with the MCG, if running;

3\> release *maxMIMO-LayerPreferenceConfig* for the MCG, if configured and stop timer T346d associated with the MCG, if running;

3\> release *minSchedulingOffsetPreferenceConfig* for the MCG, if configured and stop timer T346e associated with the MCG, if running;

3\> release *rlm-RelaxationReportingConfig* for the MCG, if configured and stop timer T346j associated with the MCG, if running;

3\> release *bfd-RelaxationReportingConfig* for the MCG, if configured and stop timer T346k associated with the MCG, if running;

3\> release *releasePreferenceConfig*, if configured and stop timer T346f, if running;

3\> release *onDemandSIB-Request* if configured, and stop timer T350, if running;

3\> release referenceTimePreferenceReporting, if configured;

3\> release *sl-AssistanceConfigNR*, if configured;

3\> release *obtainCommonLocation*, if configured;

3\> release *scg-DeactivationPreferenceConfig*, if configured, and stop timer T346i, if running;

3\> release *musim-GapAssistanceConfig*, if configured and stop timer T346h, if running;

3\> release *musim-GapPriorityAssistanceConfig*, if configured;

3\> release *musim-LeaveAssistanceConfig*, if configured;

3\> release *musim-CapabilityRestrictionConfig*, if configured and stop timer T346n, if running;

3\> release *propDelayDiffReportConfig*, if configured;

3\> release *ul-GapFR2-PreferenceConfig*, if configured;

3\> release *rrm-MeasRelaxationReportingConfig*, if configured;

3\> release *maxBW-PreferenceConfigFR2-2*, if configured;

3\> release *maxMIMO-LayerPreferenceConfigFR2-2*, if configured;

3\> release *minSchedulingOffsetPreferenceConfigExt*, if configured;

3\> release *uav-FlightPathAvailabilityConfig*, if configured;

3\> release *ul-TrafficInfoReportingConfig*, if configured, and stop all instances of timer T346x, if running;

3\> suspend all RBs, and BH RLC channels for the IAB-MT, except SRB0 and broadcast MRBs;

2\> remove all the entries within the MCG *VarConditionalReconfig*, if any;

2\> perform the LTM configuration release procedure for the MCG and the SCG as specified in clause 5.3.5.18.7;

2\> for each *measId*, if the associated *reportConfig* has a *reportType* set to *condTriggerConfig*:

3\> for the associated *reportConfigId*:

4\> remove the entry with the matching *reportConfigId* from the *reportConfigList* within the *VarMeasConfig*;

3\> if the associated *measObjectId* is only associated to a *reportConfig* with *reportType* set to *condTriggerConfig*:

4\> remove the entry with the matching *measObjectId* from the *measObjectList* within the *VarMeasConfig*;

3\> remove the entry with the matching *measId* from the *measIdList* within the *VarMeasConfig*;

2\> remove the *servingSecurityCellSetId* within the *VarServingSecurityCellSetID*, if any;

2\> release the PC5 RLC entity for SL-RLC0, if any;

2\> start timer T301;

2\> apply the default L1 parameter values as specified in corresponding physical layer specifications except for the parameters for which values are provided in *SIB1*;

2\> apply the default MAC Cell Group configuration as specified in 9.2.2;

2\> apply the CCCH configuration as specified in 9.1.1.2;

2\> apply the *timeAlignmentTimerCommon* included in *SIB1*;

2\> initiate transmission of the *RRCReestablishmentRequest* message in accordance with 5.3.7.4;

NOTE 2: This procedure applies also if the UE returns to the source PCell.

NOTE 3: A L2 U2N Relay UE may re-establish (e.g. via release and establish) the SL-RLC0 and SL-RLC1 of the connected L2 Remote UE(s).

Upon selecting an inter-RAT cell, the UE shall:

1\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\'.

#### 5.3.7.3a Actions following relay selection while T311 is running

Upon selecting a suitable L2 U2N Relay UE, the L2 U2N Remote UE shall:

1\> indicate to upper layer to trigger the PC5 unicast link establishment with the selected L2 U2N Relay UE, if a new L2 U2N Relay UE is selected;

1\> ensure having valid and up to date essential system information as specified in clause 5.2.2.2;

1\> stop timer T311;

1\> if T390 is running:

2\> stop timer T390 for all access categories;

2\> perform the actions as specified in 5.3.14.4;

1\> stop the cell selection procedure, if ongoing;

1\> start timer T301;

1\> release the RLC entity for SRB0, if any;

1\> establish a SRAP entity as specified in TS 38.351 \[66\], if no SRAP entity has been established;

1\> apply the specified configuration of SL-RLC0 as specified in 9.1.1.4;

1\> apply the SDAP configuration and PDCP configuration as specified in 9.1.1.2 for SRB0;

1\> initiate transmission of the *RRCReestablishmentRequest* message in accordance with 5.3.7.4.

#### 5.3.7.4 Actions related to transmission of *RRCReestablishmentRequest* message

The UE shall set the contents of *RRCReestablishmentRequest* message as follows:

1\> if the procedure was initiated due to radio link failure as specified in 5.3.10.3 or reconfiguration with sync failure as specified in 5.3.5.8.3; or

1\> if the procedure was initiated due to mobility from NR failure as specified in 5.4.3.5 and if *voiceFallbackIndication* is included in the *MobilityFromNRCommand* message:

2\> set the *reestablishmentCellId* in the *VarRLF-Report* to the global cell identity of the selected cell;

1\> set the *ue-Identity* as follows:

2\> set the *c-RNTI* to the C-RNTI used in the source PCell (reconfiguration with sync or mobility from NR failure) or used in the PCell in which the trigger for the re-establishment occurred (other cases);

2\> set the *physCellId* to the physical cell identity of the source PCell (reconfiguration with sync or mobility from NR failure) or of the PCell in which the trigger for the re-establishment occurred (other cases);

2\> set the *shortMAC-I* to the 16 least significant bits of the MAC-I calculated:

3\> over the ASN.1 encoded as per clause 8 (i.e., a multiple of 8 bits) *VarShortMAC-Input*;

3\> with the K~RRCint~ key and integrity protection algorithm that was used in the source PCell (reconfiguration with sync or mobility from NR failure) or of the PCell in which the trigger for the re-establishment occurred (other cases); and

3\> with all input bits for COUNT, BEARER and DIRECTION set to binary ones;

1\> set the *reestablishmentCause* as follows:

2\> if the re-establishment procedure was initiated due to reconfiguration failure as specified in 5.3.5.8.2:

3\> set the *reestablishmentCause* to the value *reconfigurationFailure*;

2\> else if the re-establishment procedure was initiated due to reconfiguration with sync failure as specified in 5.3.5.8.3 (intra-NR handover failure) or 5.4.3.5 (inter-RAT mobility from NR failure):

3\> set the *reestablishmentCause* to the value *handoverFailure*;

2\> else:

3\> set the *reestablishmentCause* to the value *otherFailure*;

1\> re-establish PDCP for SRB1;

1\> if the UE is acting as L2 U2N Remote UE:

2\> establish or re-establish (e.g. via release and add) SL RLC entity for SRB1;

2\> apply the default configuration of SL-RLC1 as defined in 9.2.4 for SRB1;

2\> apply the default configuration of PDCP as defined in 9.2.1 for SRB1;

2\> apply the default configuration of SRAP as defined in 9.2.5 for SRB1;

1\> else:

2\> re-establish RLC for SRB1;

2\> apply the default configuration defined in 9.2.1 for SRB1;

1\> configure lower layers to suspend integrity protection and ciphering for SRB1;

NOTE: Ciphering is not applied for the subsequent *RRCReestablishment* message used to resume the connection. An integrity check is performed by lower layers, but merely upon request from RRC.

1\> resume SRB1;

1\> if *ta-Report* or *ta-ReportATG* is configured with value *enabled* and the UE supports TA reporting:

2\> indicate TA report initiation to lower layers;

1\> submit the *RRCReestablishmentRequest* message to lower layers for transmission.

#### 5.3.7.5 Reception of the *RRCReestablishment* by the UE

The UE shall:

1\> stop timer T301;

1\> consider the current cell to be the PCell;

1\> update the K~gNB~ key based on the current K~gNB~ key or the NH*,* using the received *nextHopChainingCount* value, as specified in TS 33.501 \[11\];

1\> store the *nextHopChainingCount* value indicated in the *RRCReestablishment* message;

1\> derive the K~RRCenc~ and K~UPenc~ keys associated with the previously configured *cipheringAlgorithm,* as specified in TS 33.501 \[11\];

1\> derive the K~RRCint~ and K~UPint~ keys associated with the previously configured *integrityProtAlgorithm,* as specified in TS 33.501 \[11\].

1\> request lower layers to verify the integrity protection of the *RRCReestablishment* message, using the previously configured algorithm and the K~RRCint~ key;

1\> if the integrity protection check of the *RRCReestablishment* message fails:

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\', upon which the procedure ends;

1\> configure lower layers to resume integrity protection for SRB1 using the previously configured algorithm and the K~RRCint~ key immediately, i.e., integrity protection shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

1\> configure lower layers to resume ciphering for SRB1 using the previously configured algorithm and, the K~RRCenc~ key immediately, i.e., ciphering shall be applied to all subsequent messages received and sent by the UE, including the message used to indicate the successful completion of the procedure;

1\> release the measurement gap configuration indicated by the *measGapConfig*, if configured;

1\> release the MUSIM gap configuration indicated by the *musim-GapConfig*, if configured;

1\> release the FR2 UL gap configuration indicated by the *ul-GapFR2-Config*, if configured;

1\> perform the L2 U2N Remote UE configuration procedure in accordance with the received *sl-L2RemoteUE-Config* as specified in 5.3.5.16;

1\> set the content of *RRCReestablishmentComplete* message as follows:

2\> if the UE has logged measurements available for NR and if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*; or

2\> if the UE has logged measurements available for NR and if the current registered SNPN are included in *snpn-ConfigIDList* stored in *VarLogMeasReport*:

3\> include the *logMeasAvailable* in the *RRCReestablishmentComplete* message;

3\> if Bluetooth measurement results are included in the logged measurements the UE has available for NR:

4\> include the *logMeasAvailableBT* in the *RRCReestablishmentComplete* message;

3\> if WLAN measurement results are included in the logged measurements the UE has available for NR:

4\> include the *logMeasAvailableWLAN* in the *RRCReestablishmentComplete* message;

2\> if the *sigLoggedMeasType* in *VarLogMeasReport* is included; or

2\> if the UE is capable of reporting availability of signalling based logged MDT for inter-RAT (i.e. LTE to NR), and if the *sigLoggedMeasType* in *VarLogMeasReport* of TS 36.331 \[10\] is included:

3\> if T330 timer is running (associated to the logged measurement configuration for NR or for LTE):

4\> set *sigLogMeasConfigAvailable* to *true* in the *RRCReestablishmentComplete* message;

3\> else:

4\> if the UE has logged measurements:

5\> set *sigLogMeasConfigAvailable* to *false* in the *RRCReestablishmentComplete* message;

2\> if the UE has connection establishment failure or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the RPLMN is equal to *plmn-Identity* stored in *VarConnEstFailReport* or in at least one of the entries of *VarConnEstFailReportList*; or

2\> if the UE supports multiple CEF report and if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the registered SNPN identity is equal to *snpn-identity* stored in *VarConnEstFailReport* or any entry of *VarConnEstFailReportList*:

3\> include *connEstFailInfoAvailable* in the *RRCReestablishmentComplete* message;

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report*; or

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* of TS 36.331 \[10\] and if the UE is capable of cross-RAT RLF reporting and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report* of TS 36.331 \[10\]; or

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in *VarRLF-Report*:

3\> include *rlf-InfoAvailable* in the *RRCReestablishmentComplete* message;

2\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessHO-Report*; or

2\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessHO-Report*:

3\> include *successHO-InfoAvailable* in the *RRCReestablishmentComplete* message;

2\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessPSCell-Report*; or

2\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessPSCell-Report*:

3\> include *successPSCell-InfoAvailable* in the *RRCReestablishmentComplete* message;

2\> if the UE has flight path information available:

2\> if the UE has flight path information available:

3\>if the UE had not previously provided a flight path information since last entering RRC_CONNECTED state; or

3\> if at least one waypoint was not previously provided; or

3\> if at least one upcoming waypoint that was previously provided is being removed; or

3\> if *flightPathUpdateDistanceThr* is configured and for at least one waypoint, the 3D distance between the previously provided location and the new location is more than or equal to the distance threshold configured by *flightPathUpdateDistanceThr*; or

3\> if *flightPathUpdateTimeThr* is configured and for at least one waypoint, the timestamp was not previously provided but is now available, or the time between the previously provided timestamp and the new timestamp, if available, is more than or equal to the time threshold configured by *flightPathUpdateTimeThr*:

4\> include *flightPathInfoAvailable*;

NOTE: If neither *flightPathUpdateDistanceThr* nor *flightPathUpdateTimeThr* is configured, it is up to UE implementation whether to include *flightPathInfoAvailable*when updated flight path information is available.

1\> submit the *RRCReestablishmentComplete* message to lower layers for transmission;

1\> if *SIB21* is provided by the PCell:

2\> if the UE initiated transmission of an *MBSInterestIndication* message during the last 1 second preceding detection of radio link failure:

3\> initiate transmission of an *MBSInterestIndication* message in accordance with 5.9.4;

1\> the procedure ends.

#### 5.3.7.6 T311 expiry

Upon T311 expiry, the UE shall:

1\> if the procedure was initiated due to radio link failure or handover failure:

2\> set the *noSuitableCellFound* in the *VarRLF-Report* to *true*;

1\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\'.

#### 5.3.7.7 T301 expiry or selected cell/L2 U2N Relay UE no longer suitable

The UE shall:

1\> if timer T301 expires; or

1\> if the selected cell becomes no longer suitable according to the cell selection criteria as specified in TS 38.304 \[20\]; or

1\> if the (re)selected L2 U2N Relay UE becomes unsuitable; or

1\> upon reception of *NotificationMessageSidelink* indicating *relayUE-HO* or *relayUE-CellReselection*; or

1\> upon PC5 unicast link release indicated by upper layer at L2 U2N Remote UE:

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\'.

#### 5.3.7.8 Reception of the *RRCSetup* by the UE

The UE shall:

1\> perform the RRC connection establishment procedure as specified in 5.3.3.4.

### 5.3.8 RRC connection release

#### 5.3.8.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: RRCRelease [ac];
|||;
~~~

Figure 5.3.8.1-1: RRC connection release, successful

The purpose of this procedure is:

- to release the RRC connection, which includes the release of the established radio bearers (except for broadcast MRBs), BH RLC channels, Uu Relay RLC channels, PC5 Relay RLC channels as well as all radio resources; or

- to suspend the RRC connection only if SRB2 and at least one DRB or multicast MRB or, for IAB and NCR, SRB2, are setup, which includes the suspension of the established radio bearers (except for broadcast MRBs).

#### 5.3.8.2 Initiation

The network initiates the RRC connection release procedure to transit a UE in RRC_CONNECTED to RRC_IDLE; or to transit a UE in RRC_CONNECTED to RRC_INACTIVE only if SRB2 and at least one DRB or multicast MRB or, for IAB and NCR, SRB2, is setup in RRC_CONNECTED; or to transit a UE in RRC_INACTIVE back to RRC_INACTIVE when the UE tries to resume (for resuming a suspended RRC connection or for initiating SDT); or to transit a UE in RRC_INACTIVE to RRC_IDLE when the UE tries to resume (for resuming of a suspended RRC connection or for initiating SDT). The procedure can also be used to release and redirect a UE to another frequency.

#### 5.3.8.3 Reception of the *RRCRelease* by the UE

The UE shall:

1\> delay the following actions defined in this clause 60 ms from the moment the *RRCRelease* message was received or optionally when lower layers indicate that the receipt of the *RRCRelease* message has been successfully acknowledged, whichever is earlier;

NOTE 0: When the *RRCRelease* message is received on a HARQ process with disabled HARQ feedback, and when STATUS reporting, as defined in TS 38.322 \[4\], has not been triggered for a logical channel associated with the SRB1, the lower layers can be considered to have indicated that the receipt of the *RRCRelease* message has been successfully acknowledged.

1\> stop timer T380, if running;

1\> stop timer T320, if running;

1\> if timer T316 is running;

2\> stop timer T316;

2\> if the UE supports RLF-Report for fast MCG recovery procedure:

3\> set the *elapsedTimeT316* in the *VarRLF-Report* to the value of the elapsed time of the timer T316;

3\> set the *pSCellId* to the global cell identity of the PSCell, if available, otherwise to the physical cell identity and carrier frequency of the PSCell;

2\> else:

3\> clear the information included in *VarRLF-Report,* if any;

1\> stop timer T350, if running;

1\> stop timer T346g, if running;

1\> if the AS security is not activated:

2\> ignore any field included in *RRCRelease* message except *waitTime*;

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with the release cause \'other\' upon which the procedure ends;

1\> if the *RRCRelease* message includes *redirectedCarrierInfo* indicating redirection to *eutra*:

2\> if *cnType* is included:

3\> after the cell selection, indicate the available CN Type(s) and the received *cnType* to upper layers;

NOTE 1: Handling the case if the E-UTRA cell selected after the redirection does not support the core network type specified by the *cnType,* is up to UE implementation.

2\> if *voiceFallbackIndication* is included:

3\> consider the RRC connection release was for EPS fallback for IMS voice (see TS 23.502 \[43\]);

1\> if the *RRCRelease* message includes the *cellReselectionPriorities*:

2\> store the cell reselection priority information provided by the *cellReselectionPriorities*;

2\> if the *t320* is included:

3\> start timer T320, with the timer value set according to the value of *t320*;

1\> else:

2\> apply the cell reselection priority information broadcast in the system information;

1\> if *deprioritisationReq* is included and the UE supports RRC connection release with deprioritisation:

2\> start or restart timer T325 with the timer value set to the *deprioritisationTimer* signalled;

2\> store the *deprioritisationReq* until T325 expiry;

NOTE 1a: The UE stores the deprioritisation request irrespective of any cell reselection absolute priority assignments (by dedicated or common signalling) and regardless of RRC connections in NR or other RATs unless specified otherwise.

1\> if the *RRCRelease* includes the *measIdleConfig*:

2\> if T331 is running:

3\> stop timer T331;

3\> perform the actions as specified in 5.7.8.3;

2\> if the *measIdleConfig* is set to *setup*:

3\> store the received *measIdleDuration* in *VarMeasIdleConfig*;

3\> start timer T331 with the value set to *measIdleDuration*;

3\> if the *measIdleConfig* contains *measIdleCarrierListNR*:

4\> store the received *measIdleCarrierListNR* in *VarMeasIdleConfig*;

3\> if the *measIdleConfig* contains *measIdleCarrierListEUTRA*:

4\> store the received *measIdleCarrierListEUTRA* in *VarMeasIdleConfig*;

3\> if the *measIdleConfig* contains *validityAreaList*:

4\> store the received *validityAreaList* in *VarMeasIdleConfig*;

1\> if the *RRCRelease* includes *suspendConfig*:

2\> reset MAC and release the default MAC Cell Group configuration, if any;

2\> apply the received *suspendConfig* except the received *nextHopChainingCount*;

2\> if the *sdt-Config* is configured:

3\> for each of the DRB in the *sdt-DRB-List*:

4\> consider the DRB to be configured for SDT;

3\> if *sdt-SRB2-Indication* is configured:

4\> consider the SRB2 to be configured for SDT;

3\> for each RLC bearer (except those associated with broadcast MRBs) that is not suspended:

4\> re-establish the RLC entity as specified in TS 38.322 \[4\];

3\> for SRB2 (if it is resumed) and for SRB1:

4\> trigger the PDCP entity to perform SDU discard as specified in TS 38.323 \[5\];

3\> if *sdt-MAC-PHY-CG-Config* is configured:

4\> configure the PCell with the configured grant resources for SDT and instruct the MAC entity to start the *cg-SDT-TimeAlignmentTimer*;

2\> if *srs-PosRRC-Inactive* is configured:

3\> apply the configuration and instruct MAC to start the *inactivePosSRS-TimeAlignmentTimer*;

2\> if *srs-PosRRC-InactiveValidityAreaConfig* is configured:

3\> apply the configuration and instruct MAC to start the *inactivePosSRS-ValidityAreaTAT*;

NOTE 1b: The Network should provide full configuration to UE for SRS for Positioning in RRC_INACTIVE.

2\> perform the LTM configuration release procedure for the MCG and the SCG as specified in clause 5.3.5.18.7;

2\> remove all the entries within the MCG and the SCG *VarConditionalReconfig*, if any;

2\> remove the *servingSecurityCellSetId* within the *VarServingSecurityCellSetID*, if any;

2\> for each *measId* of the MCG *measConfig* and for each *measId* of the SCG *measConfig*, if configured, if the associated *reportConfig* has a *reportType* set to *condTriggerConfig*:

3\> for the associated *reportConfigId*:

4\> remove the entry with the matching *reportConfigId* from the *reportConfigList* within the *VarMeasConfig*;

3\> if the associated *measObjectId* is only associated to a *reportConfig* with *reportType* set to *condTriggerConfig*:

4\> remove the entry with the matching *measObjectId* from the *measObjectList* within the *VarMeasConfig*;

3\> remove the entry with the matching *measId* from the *measIdList* within the *VarMeasConfig*;

2\> for NCR-MT, if *NCR-FwdConfig* is configured:

3\> if the *NCR-FwdConfig* includes periodic forwarding resource configuration:

4\> indicate to NCR-Fwd to continue forwarding only in accordance with the configured periodic forwarding resource set(s);

3\> else:

4\> indicate to NCR-Fwd to cease forwarding;

2\> if the UE is acting as L2 U2N Remote UE and is not configured with MP:

3\> if the PC5-RRC connection with the U2N Relay UE is determined to be released:

4\> indicate upper layers to trigger PC5 unicast link release;

3\> else (i.e., maintain the PC5 RRC connection):

4\> establish or re-establish (e.g. via release and add) SL RLC entity for SRB1;

> 2\> else:

3\> re-establish RLC entities for SRB1;

2\> if the *RRCRelease* message with *suspendConfig* was received in response to an *RRCResumeRequest* or an *RRCResumeRequest1*:

3\> stop the timer T319 if running;

3\> in the stored UE Inactive AS context:

4\> replace the K~gNB~ and K~RRCint~ keys with the current K~gNB~ and K~RRCint~ keys;

4\> replace the *nextHopChainingCount* with the value of *nextHopChainingCount* received in the *RRCRelease* message*;*

4\> replace the *cellIdentity* with the *cellIdentity* of the cell the UE has received the *RRCRelease* message;

4\> if the *suspendConfig* contains the *sl-UEIdentityRemote* (i.e. the UE is a L2 U2N Remote UE):

5\> replace the C-RNTI with the value of the *sl-UEIdentityRemote*;

5\> replace the physical cell identity with the value of the *sl-PhysCellId* in *sl-ServingCellInfo* contained in the discovery message received from the connected L2 U2N Relay UE;

4\> else:

5\> replace the C-RNTI with the C-RNTI used in the cell (see TS 38.321 \[3\]) the UE has received the *RRCRelease* message;

5\> replace the physical cell identity with the physical cell identity of the cell the UE has received the *RRCRelease* message;

3\> replace the *nextHopChainingCount* with the value associated with the current K~gNB~;

3\> stop the timer T319a if running and consider SDT procedure is not ongoing;

2\> else:

3\> store in the UE Inactive AS Context the *nextHopChainingCount* received in the *RRCRelease* message*,* the current K~gNB~ and K~RRCint~ keys, the ROHC state, the EHC context(s), the UDC state, the stored QoS flow to DRB mapping rules, the application layer measurement configuration, the C-RNTI used in the source PCell, the *cellIdentity* and the physical cell identity of the source PCell, the *NCR-FwdConfig* (if configured), the *spCellConfigCommon* within *ReconfigurationWithSync* of the NR PSCell (if configured) and all other parameters configured except for:

- parameters within *ReconfigurationWithSync* of the PCell;

- parameters within *ReconfigurationWithSync* of the NR PSCell, if configured;

- parameters within *MobilityControlInfoSCG* of the E-UTRA PSCell, if configured;

- *servingCellConfigCommonSIB*;

- *sl-L2RelayUE-Config*, if configured;

- *sl-L2RemoteUE-Config*, if configured;

- *uav-Config*, if configured;

NOTE 1c: *suspendConfig* is not stored as part of UE Inactive AS Context, except for the fields explicitly specified.

3\> store any previously or subsequently received application layer measurement report containers for which no segment, or full message, has been submitted to lower layers for transmission;

3\> for each application layer measurement configuration for which *configForRRC-IdleInactive* is set to *true*:

4\> initiate the procedure in 5.5b.1.2;

NOTE 2: NR sidelink communication/discovery related configurations and logged measurement configuration are not stored as UE Inactive AS Context, when UE enters RRC_INACTIVE.

2\> suspend all SRB(s) and DRB(s), except SRB0 and broadcast MRBs;

2\> suspend all multicast MRB(s) associated with multicast session(s) not configured to receive in RRC_INACTIVE;

2\> indicate PDCP suspend to lower layers of all DRBs and multicast MRBs associated with multicast session(s) not configured to receive in RRC_INACTIVE;

2\> release Uu Relay RLC channel(s), if configured;

2\> release PC5 Relay RLC channel(s), if configured;

2\> release the SRAP entity, if configured;

NOTE 2a: A L2 U2N Relay UE may re-establish the SL-RLC0, SL-RLC1 and SRAP entity after release.

2\> if SL indirect path is configured:

3\> release cell identity and relay UE ID configured in *sl-IndirectPathAddChange*;

3\> indicate upper layers to trigger PC5 unicast link release of the SL indirect path;

2\> if N3C indirect path is configured:

3\> release *n3c-IndirectPathAddChange*;

3\> consider the non-3GPP connection is not used;

2\> if the UE is acting as a N3C relay UE:

3\> release *n3c-IndirectPathConfigRelay*;

3\> consider the non-3GPP connection is not used;

2\> if the *t380* is included:

3\> start timer T380, with the timer value set to *t380*;

2\> if the *RRCRelease* message is including the *waitTime*:

3\> start timer T302 with the value set to the *waitTime*;

3\> inform upper layers that access barring is applicable for all access categories except categories \'0\' and \'2\';

2\> if T390 is running:

3\> stop timer T390 for all access categories;

3\> perform the actions as specified in 5.3.14.4;

2\> indicate the suspension of the RRC connection to upper layers;

2\> if the UE is capable of L2 U2N Remote UE:

3\> enter RRC_INACTIVE, and perform either cell selection as specified in TS 38.304 \[20\], or relay selection as specified in clause 5.8.15.3, or both;

2\> else:

3\> enter RRC_INACTIVE and perform cell selection as specified in TS 38.304 \[20\];

2\> if the *suspendConfig* includes *resumeIndication*:

3\> perform the actions as if the UE received *Paging* message with the *ue-Identity* included in the *PagingRecord* matching the UE\'s stored *fullI-RNTI*, as specified in clause 5.3.2.3;

2\> if the *multicastConfigInactive* is configured:

3\> if the multicast PTM configuration is provided for a multicast session for which the UE is not indicated to stop monitoring the G-RNTI and the UE selects the same cell as the one on which it received *RRCRelease*:

4\> apply the multicast PTM configuration as specified in 5.10.3;

4\> monitor the Multicast MCCH-RNTI as specified in 5.10.2;

1\> else:

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with the release cause \'other\'.

NOTE 3: Whether to release the PC5 unicast link is left to L2 U2N Remote UE\'s implementation.

NOTE 4: It is left to UE implementation whether to stop T430, if running, when going to RRC_INACTIVE.

#### 5.3.8.4 T320 expiry

The UE shall:

1\> if T320 expires:

2\> if stored, discard the cell reselection priority information provided by the *cellReselectionPriorities* or inherited from another RAT;

2\> apply the cell reselection priority information broadcast in the system information.

#### 5.3.8.5 UE actions upon the expiry of *DataInactivityTimer*

Upon receiving the expiry of *DataInactivityTimer* from lower layers while in RRC_CONNECTED, the UE shall:

1\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\'.

#### 5.3.8.6 T346g expiry

The UE shall:

1\> if T346g expires:

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'other\'.

### 5.3.9 RRC connection release requested by upper layers

#### 5.3.9.1 General

The purpose of this procedure is to release the RRC connection. Access to the current PCell may be barred as a result of this procedure.

#### 5.3.9.2 Initiation

The UE initiates the procedure when upper layers request the release of the RRC connection as specified in TS 24.501 \[23\]. The UE shall not initiate the procedure for power saving purposes.

The UE shall:

1\> if the upper layers indicate barring of the PCell:

2\> treat the PCell used prior to entering RRC_IDLE as barred according to TS 38.304 \[20\];

1\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'other\'.

### 5.3.10 Radio link failure related actions

#### 5.3.10.1 Detection of physical layer problems in RRC_CONNECTED

The UE shall:

1\> if any DAPS bearer is configured, upon receiving N310 consecutive \"out-of-sync\" indications for the source SpCell from lower layers and T304 is running:

2\> start timer T310 for the source SpCell.

1\> upon receiving N310 consecutive \"out-of-sync\" indications for the SpCell from lower layers while neither T300, T301, T304, T311, T316 nor T319 are running:

2\> start timer T310 for the corresponding SpCell.

#### 5.3.10.2 Recovery of physical layer problems

Upon receiving N311 consecutive \"in-sync\" indications for the SpCell from lower layers while T310 is running, the UE shall:

1\> stop timer T310 for the corresponding SpCell.

1\> stop timer T312 for the corresponding SpCell, if running.

NOTE 1: In this case, the UE maintains the RRC connection without explicit signalling, i.e. the UE maintains the entire radio resource configuration.

NOTE 2: Periods in time where neither \"in-sync\" nor \"out-of-sync\" is reported by L1 do not affect the evaluation of the number of consecutive \"in-sync\" or \"out-of-sync\" indications.

#### 5.3.10.3 Detection of radio link failure

The UE shall:

1\> if any DAPS bearer is configured and T304 is running:

2\> upon T310 expiry in source SpCell; or

2\> upon random access problem indication from source MCG MAC; or

2\> upon indication from source MCG RLC that the maximum number of retransmissions has been reached; or

2\> upon consistent uplink LBT failure indication from source MCG MAC:

3\> consider radio link failure to be detected for the source MCG i.e. source RLF;

3\> suspend the transmission and reception of all DRBs and multicast MRBs in the source MCG;

3\> reset MAC for the source MCG;

3\> release the source connection.

1\> else:

2\> during a DAPS handover: the following only applies for the target PCell;

2\> upon T310 expiry in PCell; or

2\> upon T312 expiry in PCell; or

2\> upon random access problem indication from MCG MAC while neither T300, T301, T304, T311 nor T319 are running and SDT procedure is not ongoing; or

2\> upon indication from MCG RLC that the maximum number of retransmissions has been reached while SDT procedure is not ongoing; or

2\> if connected as an IAB-node, upon BH RLF indication received on BAP entity from the MCG; or

2\> upon consistent uplink LBT failure indication from MCG MAC while T304 is not running:

3\> if the indication is from MCG RLC and CA duplication is configured and activated for MCG, and for the corresponding logical channel *allowedServingCells* only includes SCell(s):

4\> initiate the failure information procedure as specified in 5.7.5 to report RLC failure.

3\> else:

4\> consider radio link failure to be detected for the MCG, i.e. MCG RLF;

4\> discard any segments of segmented RRC messages stored according to 5.7.6.3;

NOTE: Void.

4\> if AS security has not been activated:

5\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'other\';-

4\> else if AS security has been activated but SRB2 and at least one DRB or multicast MRB or, for IAB and NCR, SRB2, have not been setup:

5\> store the radio link failure information in the *VarRLF-Report* as described in clause 5.3.10.5;

5\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\';

4\> else:

5\> store the radio link failure information in the *VarRLF-Report* as described in clause 5.3.10.5;

5\> if T316 is configured; and

5\> if SCG transmission is not suspended; and

5\> if the SCG is not deactivated; and

5\> if neither PSCell change nor PSCell addition is ongoing (i.e. timer T304 for the NR PSCell is not running in case of NR-DC or timer T307 of the E-UTRA PSCell is not running as specified in TS 36.331 \[10\], clause 5.3.10.10, in NE-DC):

6\> initiate the MCG failure information procedure as specified in 5.7.3b to report MCG radio link failure.

5\> else:

6\> initiate the connection re-establishment procedure as specified in 5.3.7.

A L2/L3 U2N Relay UE shall:

1\> upon detecting radio link failure:

2\> either indicate to upper layers (to trigger PC5 unicast link release) or send *NotificationMessageSidelink* to the connected L2/L3 U2N Remote UE(s) in accordance with 5.8.9.10.

The UE shall:

1\> upon T310 expiry in PSCell; or

1\> upon T312 expiry in PSCell; or

1\> upon random access problem indication from SCG MAC; or

1\> upon indication from SCG RLC that the maximum number of retransmissions has been reached; or

1\> if connected as an IAB-node, upon BH RLF indication received on BAP entity from the SCG; or

1\> upon consistent uplink LBT failure indication from SCG MAC:

2\> if the indication is from SCG RLC and CA duplication is configured and activated for SCG, and for the corresponding logical channel *allowedServingCells* only includes SCell(s):

3\> initiate the failure information procedure as specified in 5.7.5 to report RLC failure.

2\> else:

3\> consider radio link failure to be detected for the SCG, i.e. SCG RLF;

3\> if the SCG is deactivated:

4\> stop radio link monitoring on the SCG;

4\> indicate to lower layers to stop beam failure detection on the PSCell;

3\> if MCG transmission is not suspended:

4\> initiate the SCG failure information procedure as specified in 5.7.3 to report SCG radio link failure.

3\> else:

4\> if the UE is in NR-DC:

5\> initiate the connection re-establishment procedure as specified in 5.3.7;

4\> else (the UE is in (NG)EN-DC):

5\> initiate the connection re-establishment procedure as specified in TS 36.331 \[10\], clause 5.3.7;

#### 5.3.10.4 RLF cause determination

The UE shall set the *rlf-Cause* in the *VarRLF-Report* as follows:

1\> if the UE declares radio link failure due to T310 expiry:

2\> set the *rlf-Cause* as *t310-Expiry*;

1\> else if the UE declares radio link failure due to the random access problem indication from MCG MAC:

2\> if the random access procedure was initiated for beam failure recovery:

3\> set the *rlf-Cause* as *beamFailureRecoveryFailure*;

2\> else:

3\> set the *rlf-Cause* as *randomAccessProblem*;

1\> else if the UE declares radio link failure due to the reaching of maximum number of retransmissions from the MCG RLC:

2\> set the *rlf-Cause* as *rlc-MaxNumRetx*;

1\> else if the UE declares radio link failure due to consistent uplink LBT failures:

2\> set the *rlf-Cause* as *lbtFailure*;

1\> else if the IAB-MT declares radio link failure due to the reception of a BH RLF indication on BAP entity:

2\> set the *rlf-Cause* as *bh-rlfRecoveryFailure*.

1\> else if the UE declares radio link failure due to T312 expiry:

2\> set the *rlf-Cause* as *t312-Expiry*;

#### 5.3.10.5 RLF report content determination

The UE shall determine the content in the *VarRLF-Report* as follows:

1\> clear the information included in *VarRLF-Report*, if any;

1\> if the UE is not in SNPN access mode, set the *plmn-IdentityList* to include the list of EPLMNs stored by the UE (i.e. includes the RPLMN);

1\> else if the UE is in SNPN access mode, set the *snpn-IdentityList* to include the list of equivalent SNPNs stored by the UE (i.e., registered SNPN);

1\> set the *measResultLastServCell* to include the cell level RSRP, RSRQ and the available SINR, of the source PCell (in case HO failure) or PCell (in case RLF) based on the available SSB and CSI-RS measurements collected up to the moment the UE detected failure;

1\> if *measRSSI-ReportConfig* is configured for the frequency of the source PCell (in case HO failure) or PCell (in case of RLF), set the *measResultLastServCell-RSSI* to the linear average of the available RSSI sample value(s) provided by lower layers for the frequency of the source PCell (in case HO failure) or PCell (in case of RLF) up to the moment the UE detected the failure;

1\> if the SS/PBCH block-based measurement quantities are available:

2\> set the *rsIndexResults* in *measResultLastServCell* to include all the available measurement quantities of the source PCell (in case HO failure) or PCell (in case RLF), ordered such that the highest SS/PBCH block RSRP is listed first if SS/PBCH block RSRP measurement results are available, otherwise the highest SS/PBCH block RSRQ is listed first if SS/PBCH block RSRQ measurement results are available, otherwise the highest SS/PBCH block SINR is listed first, based on the available SS/PBCH block based measurements collected up to the moment the UE detected failure;

1\> if the CSI-RS based measurement quantities are available:

2\> set the *rsIndexResults* in *measResultLastServCell* to include all the available measurement quantities of the source PCell (in case HO failure) or PCell (in case RLF), ordered such that the highest CSI-RS RSRP is listed first if CSI-RS RSRP measurement results are available, otherwise the highest CSI-RS RSRQ is listed first if CSI-RS RSRQ measurement results are available, otherwise the highest CSI-RS SINR is listed first, based on the available CSI-RS based measurements collected up to the moment the UE detected failure;

1\> for each of the configured *measObjectNR* in which measurements are available:

2\> if the SS/PBCH block-based measurement quantities are available:

3\> set the *measResultListNR* in *measResultNeighCells* to include all the available measurement quantities of the best measured cells, other than the source PCell (in case HO failure) or PCell (in case RLF), ordered such that the cell with highest SS/PBCH block RSRP is listed first if SS/PBCH block RSRP measurement results are available, otherwise the cell with highest SS/PBCH block RSRQ is listed first if SS/PBCH block RSRQ measurement results are available, otherwise the cell with highest SS/PBCH block SINR is listed first, based on the available SS/PBCH block based measurements collected up to the moment the UE detected failure;

4\> for each neighbour cell included, include the optional fields that are available;

NOTE 0a: For the neighboring cells included in *measResultListNR* in *measResultNeighCells* ordered based on the SS/PBCH block measurement quantities, UE also includes the CSI-RS based measurement quantities, if available.

2\> if the CSI-RS based measurement quantities are available:

3\> set the *measResultListNR* in *measResultNeighCells* to include all the available measurement quantities of the best measured cells, other than the source PCell (in case HO failure) or PCell (in case RLF), ordered such that the cell with highest CSI-RS RSRP is listed first if CSI-RS RSRP measurement results are available, otherwise the cell with highest CSI-RS RSRQ is listed first if CSI-RS RSRQ measurement results are available, otherwise the cell with highest CSI-RS SINR is listed first, based on the available CSI-RS based measurements collected up to the moment the UE detected radio link failure;

4\> for each neighbour cell included, include the optional fields that are available;

NOTE 0b: For ordering the neighboring cells based on the CSI-RS measurement quantities, UE includes measurements only for the cells not yet included in *measResultListNR* in *measResultNeighCells* to avoid overriding SS/PBCH block-based ordered measurements.

2\> for each neighbour cell, if any, included in *measResultListNR* in *measResultNeighCells*:

3\> if the UE supports RLF-Report for conditional handover and if the neighbour cell is one of the candidate cells for which the *reconfigurationWithSync* is included in the *masterCellGroup* in the MCG *VarConditionalReconfig* at the moment of the detected failure:

4\> set *choConfig* in *MeasResult2NR* to the execution condition for each *measId* within *condTriggerConfig* associated to the neighbour cell within the MCG *VarConditionalReconfig*;

4\> if the first entry of *choConfig* corresponds to a fulfilled execution condition at the moment of handover failure, or radio link failure; or

4\> if the second entry of *choConfig*, if available, corresponds to a fulfilled execution condition at the moment of handover failure, or radio link failure:

5\> set *firstTriggeredEvent* to the execution condition *condFirstEvent* corresponding to the first entry of *choConfig* or to the execution condition *condSecondEvent* corresponding to the second entry of *choConfig*, whichever execution condition was fulfilled first in time;

5\> set *timeBetweenEvents* to the elapsed time between the point in time of fullfilling the condition in *choConfig* that was fulfilled first in time, and the point in time of fullfilling the condition in *choConfig* that was fulfilled second in time, if both the first execution condition corresponding to the first entry and the second execution condition corresponding to the second entry in the *choConfig* were fullfilled;

1\> for each of the configured *measObjectNR* if *measRSSI-ReportConfig* is configured for the configured frequency:

2\> set the *measResultNeighFreq-RSSI* in the *measResultNeighFreqList-RSSI* to the linear average of the available RSSI sample value(s) provided by lower layers for the frequencies other than the frequency of the source PCell (in case HO failure) or of the PCell (in case RLF), up to the moment the UE detected failure;

1\> for each of the configured EUTRA frequencies in which measurements are available;

2\> set the *measResultListEUTRA* in *measResultNeighCells* to include the best measured cells ordered such that the cell with highest RSRP is listed first if RSRP measurement results are available, otherwise the cell with highest RSRQ is listed first, and based on measurements collected up to the moment the UE detected failure;

3\> for each neighbour cell included, include the optional fields that are available;

NOTE 1: The measured quantities are filtered by the L3 filter as configured in the mobility measurement configuration. The measurements are based on the time domain measurement resource restriction, if configured. Exclude-listed cells are not required to be reported.

1\> set the *c-RNTI* to the C-RNTI used in the source PCell (in case HO failure) or PCell (in case RLF);

1\> if the failure is detected due to reconfiguration with sync failure as described in 5.3.5.8.3, set the fields in *VarRLF-report* as follows:

2\> set the *connectionFailureType* to *hof*;

2\> if the UE supports RLF-Report for DAPS handover and if any DAPS bearer was configured while T304 was running:

3\> set *lastHO-Type* to *daps*;

3\> if radio link failure was detected in the source PCell, according to clause 5.3.10.3:

4\> set *timeConnSourceDAPS-Failure* to the time between the initiation of the DAPS handover execution and the radio link failure detected in the source PCell while T304 was running;

4\> set the *rlf-Cause* to the trigger for detecting the source radio link failure in accordance with clause 5.3.10.4;

2\> if the UE supports RLF-Report for conditional handover and if configuration of the conditional handover is available in the MCG *VarConditionalReconfig* at the moment of the handover failure:

3\> if the UE executed a conditional handover toward target PCell according to the *condRRCReconfig* of the target PCell:

4\> set *timeSinceCHO-Reconfig* to the time elapsed between the execution of the last *RRCReconfiguration* message including *reconfigurationWithSync* for the target PCell of the failed conditional handover, and the reception in the source PCell of the last *conditionalReconfiguration* including the *condRRCReconfig* of the target PCell of the failed conditional handover;

3\> else:

4\> set *timeSinceCHO-Reconfig* to the time elapsed between the execution of the last *RRCReconfiguration* message including *reconfigurationWithSync* for the target PCell of the failed handover, and the reception in the source PCell of the last *conditionalReconfiguration* including the *condRRCReconfig*;

3\> set *choCandidateCellList* to include the global cell identity, if available, and otherwise to the physical cell identity and carrier frequency of each of the candidate target cells for conditional handover included in *condRRCReconfig* within the MCG *VarConditionalReconfig* at the time of the failed handover, excluding the candidate target cells included in *measResultNeighCells*;

2\> if the UE supports RLF-Report for conditional handover and if the last executed *RRCReconfiguration* message including *reconfigurationWithSync* was concerning a conditional handover:

3\> set *lastHO-Type* to *cho*;

2\> set the *nrFailedPCellId* in *failedPCellId* to the global cell identity and tracking area code, if available, and otherwise to the physical cell identity and carrier frequency of the target PCell of the failed handover;

2\> include *nrPreviousCell* in *previousPCellId* and set it to the global cell identity and tracking area code of the PCell where the last *RRCReconfiguration* message including *reconfigurationWithSync* was received;

2\> set the *timeConnFailure* to the elapsed time since the execution of the last *RRCReconfiguration* message including the *reconfigurationWithSync*;

1\> else if the failure is detected due to Mobility from NR failure as described in 5.4.3.5, set the fields in *VarRLF-report* as follows:

2\> set the *connectionFailureType* to *hof*;

2\> if last *MobilityFromNRCommand* concerned a failed inter-RAT handover from NR to E-UTRA and if the UE supports Radio Link Failure Report for Inter-RAT MRO EUTRA (NR to EUTRA):

3\> set the *eutraFailedPCellId* in *failedPCellId* to the global cell identity and tracking area code, if available, and otherwise to the physical cell identity and carrier frequency of the target PCell of the failed handover;

2\> include *nrPreviousCell* in *previousPCellId* and set it to the global cell identity and tracking area code of the PCell where the last *MobilityFromNRCommand* message was received;

2\> set the *timeConnFailure* to the elapsed time since the initialization of the handover associated to the last *MobilityFromNRCommand* message;

2\> if *voiceFallbackIndication* is included in the last *MobilityFromNRCommand*:

3\> include the v*oiceFallbackHO;*

1\> else if the failure is detected due to radio link failure as described in 5.3.10.3, set the fields in *VarRLF-report* as follows:

2\> set the *connectionFailureType* to *rlf*;

2\> set the *rlf-Cause* to the trigger for detecting radio link failure in accordance with clause 5.3.10.4;

2\> set the *nrFailedPCellId* in *failedPCellId* to the global cell identity and the tracking area code, if available, and otherwise to the physical cell identity and carrier frequency of the PCell where radio link failure is detected;

2\> if an *RRCReconfiguration* message including the *reconfigurationWithSync* was received before the connection failure:

3\> if the last successfully executed *RRCReconfiguration* message including the *reconfigurationWithSync* concerned an intra NR handover and it was received while connected to the previous PCell to which the UE was connected before connecting to the PCell where radio link failure is detected; and

3\> if T311 was not running before entering the PCell in which the radio link failure was detected:

4\> include the *nrPreviousCell* in *previousPCellId* and set it to the global cell identity and the tracking area code of the PCell where the last executed *RRCReconfiguration* message including *reconfigurationWithSync* was received;

4\> if the last executed *RRCReconfiguration* message including *reconfigurationWithSync* was concerning a DAPS handover:

5\> set *lastHO-Type* to *daps*;

4\> else if the last executed *RRCReconfiguration* message including *reconfigurationWithSync* was concerning a conditional handover:

5\> set *lastHO-Type* to *cho*;

4\> set the *timeConnFailure* to the elapsed time since the execution of the last *RRCReconfiguration* message including the *reconfigurationWithSync*;

3\> else if the last *RRCReconfiguration* message including the *reconfigurationWithSync* concerned a handover to NR from E-UTRA and if the UE supports Radio Link Failure Report for Inter-RAT MRO EUTRA:

4\> include the *eutraPreviousCell* in *previousPCellId* and set it to the global cell identity and the tracking area code of the E-UTRA PCell where the last *RRCReconfiguration* message including *reconfigurationWithSync* was received embedded in E-UTRA RRC message *MobilityFromEUTRACommand* message as specified in TS 36.331 \[10\] clause 5.4.3.3;

4\> set the *timeConnFailure* to the elapsed time since reception of the last *RRCReconfiguration* message including the *reconfigurationWithSync* embedded in E-UTRA RRC message *MobilityFromEUTRACommand* message as specified in TS 36.331 \[10\] clause 5.4.3.3;

2\> if configuration of the conditional handover is available in the MCG *VarConditionalReconfig* at the moment of declaring the radio link failure:

3\> set *timeSinceCHO-Reconfig* to the time elapsed between the detection of the radio link failure, and the reception, in the source PCell, of the last *conditionalReconfiguration* including the *condRRCReconfig* message;

3\> set *choCandidateCellList* to include the global cell identity if available, and otherwise to the physical cell identity and carrier frequency of each of all the candidate target cells for conditional handover included in *condRRCReconfig* within the MCG *VarConditionalReconfig* at the time of radio link failure, excluding the candidate target cells included in *measResultNeighCells*;

1\> if *connectionFailureType* is *rlf* and the *rlf-Cause* is set to *randomAccessProblem* or *beamFailureRecoveryFailure*; or

1\> if *connectionFailureType* is *rlf* and the *rlf-Cause* is set to *lbtFailure* and the radio link failure is detected during the random access procedure; or

1\> if *connectionFailureType* is *hof* and if the failed handover is an intra-RAT handover:

2\> set the *ra-InformationCommon* to include the random-access related information as described in clause 5.7.10.5;

> 1\> if *connectionFailureType* is *rlf* and the *rlf-Cause* is set to *lbtFailure*, and the radio link failure is not detected during the random access procedure:
>
> 2\> set the *locationAndBandwidth* and *subcarrierSpacing* in *bwp-Info* associated to the UL BWP in which the consistent uplink LBT failure was detected;

1\> if the *rlf-Cause* is set to *t310-Expiry* or *t312-Expiry*:

2\> set the *ssbRLMConfigBitmap* and/or *csi-rsRLMConfigBitmap* in *measResultLastServCell* to include the radio link monitoring configuration of the last serving cell, if available;

1\> if the UE supports RLF-Report for fast MCG recovery procedure:

2\> if the fast MCG recovery procedure fails due to expiry of timer T316:

3\> set the *mcgRecoveryFailureCause* to *t316-expiry*;

2\> else if the SCG was deactivated before initiation of the fast MCG recovery procedure:

3\> set the *mcgRecoveryFailureCause* to *scgDeactivated*;

Editor´s note: The use of scgDeactivated cause.

2\> else if the UE detected SCG failure while the timer T316 was running or before initiation of the fast MCG recovery procedure:

3\> set the *pSCellId* to the global cell identity of the PSCell, if available, otherwise to the physical cell identity and carrier frequency of the PSCell;

3\> set the *scgFailureCause* value according to 5.7.3.5;

3\> set the *elapsedTimeSCGFailure* to the time elapsed between SCG failure and the MCG failure;

1\> if available, set the *locationInfo* as in 5.3.3.7.

The UE may discard the radio link failure information or handover failure information, i.e. release the UE variable *VarRLF-Report*, 48 hours after the radio link failure/handover failure is detected.

NOTE 2: In this clause, the term \'handover failure\' has been used to refer to \'reconfiguration with sync failure\'.

### 5.3.11 UE actions upon going to RRC_IDLE

The UE shall:

1\> reset MAC;

1\> if the UE is NCR-MT:

2\> indicate to NCR-Fwd to cease forwarding;

1\> set the variable *pendingRNA-Update* to *false*, if that is set to *true*;

1\> if going to RRC_IDLE was triggered by reception of the *RRCRelease* message including a *waitTime*:

2\> if T302 is running:

3\> stop timer T302;

2\> start timer T302 with the value set to the *waitTime*;

2\> inform upper layers that access barring is applicable for all access categories except categories \'0\' and \'2\'.

1\> else:

2\> if T302 is running:

3\> stop timer T302;

3\> perform the actions as specified in 5.3.14.4;

1\> if T390 is running:

2\> stop timer T390 for all access categories;

2\> perform the actions as specified in 5.3.14.4;

1\> if the UE is leaving RRC_INACTIVE:

2\> if going to RRC_IDLE was not triggered by reception of the *RRCRelease message*:

3\> if stored, discard the cell reselection priority information provided by the *cellReselectionPriorities*;

3\> stop the timer T320, if running;

2\> if T319a is running:

3\> stop timer T319a;

3\> consider SDT procedure is not ongoing;

1\> stop all timers that are running except T302, T320, T325, T330, T331, T400 and T430;

1\> discard the UE Inactive AS context, if any;

1\> release the *suspendConfig*, if configured;

1\> release the *uav-Config*, if configured;

1\> perform LTM configuration release procedure for the MCG and SCG as specified in clause 5.3.5.18.7;

1\> remove all the entries within the MCG and the SCG *VarConditionalReconfig*, if any;

1\> remove the *servingSecurityCellSetId* within the *VarServingSecurityCellSetID*, if any;

1\> for each *measId*, if the associated *reportConfig* has a *reportType* set to *condTriggerConfig*:

2\> for the associated *reportConfigId*:

3\> remove the entry with the matching *reportConfigId* from the *reportConfigList* within the *VarMeasConfig*;

2\> if the associated *measObjectId* is only associated to a *reportConfig* with *reportType* set to *condTriggerConfig*:

3\> remove the entry with the matching *measObjectId* from the *measObjectList* within the *VarMeasConfig*;

2\> remove the entry with the matching *measId* from the *measIdList* within the *VarMeasConfig*;

1\> discard the K~gNB~ key, the S-K~gNB~ key, the S-K~eNB~ key, the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key, if any;

1\> release all radio resources, including release of the RLC entity, the BAP entity, the MAC configuration and the associated PDCP entity and SDAP for all established RBs (except for broadcast MRBs), BH RLC channels, Uu Relay RLC channels, PC5 Relay RLC channels and SRAP entity;

NOTE 0: A L2 U2N Relay UE may re-establish the SL-RLC0, SL-RLC1 and SRAP entity after release.

1\> indicate the release of the RRC connection to upper layers together with the release cause;

1\> for each application layer measurement configuration for which *configForRRC-IdleInactive* is not set to *true*:

2\> inform upper layers about the release of all application layer measurement configurations;

2\> discard any application layer measurement reports which were not yet submitted to lower layers for transmission;

1\> for each application layer measurement configuration for which *configForRRC-IdleInactive* is set to *true*:

2\> initiate the procedure in 5.5b.1.2;

1\> discard any segments of segmented RRC messages stored according to 5.7.6.3;

1\> except if going to RRC_IDLE was triggered by inter-RAT cell reselection while the UE is in RRC_INACTIVE or RRC_IDLE or when selecting an inter-RAT cell while T311 was running or when selecting an E-UTRA cell for EPS fallback for IMS voice as specified in 5.4.3.5:

2\> if the UE is capable of L2 U2N Remote UE:

3\> enter RRC_IDLE, and perform either cell selection as specified in TS 38.304 \[20\], or relay selection as specified in clause 5.8.15.3, or both;

2\> else:

3\> enter RRC_IDLE and perform cell selection as specified in TS 38.304 \[20\];

NOTE 1: Whether to release the PC5 unicast link is left to L2 U2N Remote UE\'s implementation.

NOTE 2: It is left to UE implementation whether to stop T430, if running, when going to RRC_IDLE.

### 5.3.12 UE actions upon PUCCH/SRS release request

Upon receiving a PUCCH release request from lower layers, for all bandwidth parts of an indicated serving cell the UE shall:

1\> release PUCCH-CSI-Resources configured in *CSI-ReportConfig*;

1\> release *SchedulingRequestResourceConfig* instances configured in *PUCCH-Config*.

Upon receiving an SRS release request from lower layers, for all bandwidth parts of an indicated serving cell the UE shall:

1\> release *SRS-Resource* instances configured in *SRS-Config*.

Upon receiving a positioning SRS configuration for RRC_INACTIVE release request from lower layers, the UE shall:

1\> release the configured *srs-PosRRC-Inactive*.

### 5.3.13 RRC connection resume

#### 5.3.13.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCResumeRequest/RRCResumeRequest1 [ac];
u<-n: RRCResume [ac];
u->n: RRCResumeComplete [ac];
|||;
~~~

Figure 5.3.13.1-1: RRC connection resume, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCResumeRequest/RRCResumeRequest1 [ac];
u<-n: RRCSetup [ac];
u->n: RRCSetupComplete [ac];
|||;
~~~

Figure 5.3.13.1-2: RRC connection resume fallback to RRC connection establishment, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCResumeRequest/RRCResumeRequest1 [ac];
u<-n: RRCRelease [ac];
|||;
~~~

Figure 5.3.13.1-3: RRC connection resume followed by network release, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCResumeRequest/RRCResumeRequest1 [ac];
u<-n: RRCRelease with suspend configuration [ac];
|||;
~~~

Figure 5.3.13.1-4: RRC connection resume followed by network suspend, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: RRCResumeRequest/RRCResumeRequest1 [ac];
u<-n: RRCReject [ac];
|||;
~~~

Figure 5.3.13.1-5: RRC connection resume, network reject

The purpose of this procedure is to resume a suspended RRC connection, including resuming SRB(s), DRB(s) and multicast MRB(s) or perform an RNA update. This procedure is also used to initiate SDT in RRC_INACTIVE.

#### 5.3.13.1a Conditions for resuming RRC Connection for NR sidelink communication/discovery/V2X sidelink communication

For NR sidelink communication/discovery an RRC connection is resumed only in the following cases:

1\> if configured by upper layers to transmit NR sidelink communication and related data is available for transmission:

> 2\> if the frequency on which the UE is configured to transmit NR sidelink communication is included in *sl-FreqInfoList*/*sl-FreqInfoListSizeExt* within *SIB12* provided by the cell on which the UE camps; and if the valid version of *SIB12* does not include *sl-TxPoolSelectedNormal* for the concerned frequency;

1\> if configured by upper layers to transmit NR sidelink discovery and related data is available for transmission:

2\> if the UE is configured by upper layers to transmit NR sidelink L2 U2N relay discovery messages and *sl-L2U2N-Relay* is included in *SIB12*; or

2\> if the UE is configured by upper layers to transmit NR sidelink L3 U2N relay discovery messages and *sl-L3U2N-RelayDiscovery* is included in *SIB12*; or

2\> if the UE is configured by upper layers to transmit NR sidelink non-relay discovery messages and *sl-NonRelayDiscovery* is included in *SIB12*:

3\> if the frequency on which the UE is configured to transmit NR sidelink discovery is included in *sl-FreqInfoList*/*sl-FreqInfoListSizeExt* within *SIB12* provided by the cell on which the UE camps; and if the valid version of *SIB12* does not include *sl-DiscTxPoolSelected* or *sl-TxPoolSelectedNormal* for the concerned frequency;

For L2 U2N Relay UE in RRC_INACTIVE, an RRC connection establishment is resumed in the following cases:

1\> if any message is received from the L2 U2N Remote UE via SL-RLC0 as specified in 9.1.1.4 or SL-RLC1 as specified in 9.2.4; or

1\> if *RemoteUEInformationSidelink* containing the *connectionForMP* is received from a L2 U2N Remote UE as specified in 5.8.9.8.3;

For V2X sidelink communication an RRC connection resume is initiated only when the conditions specified for V2X sidelink communication in clause 5.3.3.1a of TS 36.331 \[10\] are met.

NOTE: Upper layers initiate an RRC connection resume (except if the RRC connection resume is initiated at the L2 U2N Relay UE upon reception of a message from a L2 U2N Remote UE via SL-RLC0 or SL-RLC1). The interaction with NAS is left to UE implementation.

#### 5.3.13.1b Conditions for initiating SDT

A UE in RRC_INACTIVE initiates the resume procedure for SDT when all of the following conditions are fulfilled:

1\> for the resume procedure initiated by the upper layers (i.e. mobile originated case):

2\> SIB1 includes sdt-ConfigCommon; and

2\> *sdt-Config* is configured; and

2\> all the pending data in UL is mapped to the radio bearers configured for SDT; and

2\> for an (e)RedCap UE when (e)RedCap-specific initial downlink BWP includes no CD-SSB, *ncd-SSB-RedCapInitialBWP-SDT* is configured; and

2\> lower layers indicate that conditions for initiating MO-SDT as specified in TS 38.321 \[3\] are fulfilled.

1\> for the resume procedure initiated in response to RAN paging (i.e. mobile terminated case):

2\> *mt-SDT* indication was included in the paging message for the UE\'s stored *fullI-RNTI*; and

2\> lower layers indicate that conditions for initiating MT-SDT as specified in TS 38.321 \[3\] are fulfilled.

NOTE: How the UE determines that all pending data in UL is mapped to radio bearers configured for SDT is left to UE implementation.

#### 5.3.13.1c Conditions for resuming RRC Connection for NR sidelink Positioning

For NR sidelink positioning an RRC connection is resumed only in the following cases:

1\> if SL-PRS transmission is triggered:

2\> if the frequency on which the UE is configured to transmit NR sidelink positioning is included in *sl-FreqInfoList* within *SIB25* provided by the cell on which the UE camps; and if the valid version of *SIB25* does not include *sl-PRS-TxPoolSelectedNormal* for the concerned frequency;

#### 5.3.13.1d RRC connection resume for multicast reception

In RRC_INACTIVE state, if configured with MBS multicast reception in RRC_INACTIVE, the UE shall:

1\> if the RRC connection resume procedure is triggered for multicast reception at reception of *SIB1*, as specified in 5.2.2.4.2; or

1\> if the PTM configuration is not available in the cell after cell selection or reselection for a multicast session that the UE has joined for which the UE is not indicated to stop monitoring the G-RNTI; or

1\> if *mbs-NeighbourCellList* acquired in the previous cell indicates that a multicast session that the UE has joined for which the UE is not indicated to stop monitoring the G-RNTI is not provided for RRC_INACTIVE in the current serving cell; or

1\> if the measured RSRP or RSRQ for serving cell as specified in TS 38.304 \[20\] is below the threshold indicated by *thresholdIndex* for a multicast session that the UE has joined:

2\> initiate RRC connection resume procedure in 5.3.13.2 with *resumeCause* set to *mt-Access*.

#### 5.3.13.2 Initiation

The UE initiates the procedure when upper layers or AS (when responding to RAN paging, upon triggering RNA updates while the UE is in RRC_INACTIVE, upon requesting multicast reception as specified in clause 5.3.13.1d, for NR sidelink communication/discovery/V2X sidelink communication as specified in clause 5.3.13.1a, for NR sidelink positioning as specified in clause 5.3.13.1c, for requesting configuration for SRS for positioning, for activation of preconfigured Positioning SRS in RRC_INACTIVE, upon receiving *RRCRelease* message including *resumeIndication*) requests the resume of a suspended RRC connection or requests the resume for initiating SDT as specified in clause 5.3.13.1b.

The UE shall ensure having valid and up to date essential system information as specified in clause 5.2.2.2 before initiating this procedure.

Upon initiation of the procedure, the UE shall:

1\> if the resumption of the RRC connection is triggered by response to NG-RAN paging; or

1\> if the resumption of the RRC connection is triggered by receiving *RRCRelease* message including *resumeIndication*; or

1\> if the resumption of the RRC connection is triggered by multicast reception request as specified in clause 5.3.13.1d:

2\> select \'0\' as the Access Category;

2\> perform the unified access control procedure as specified in 5.3.14 using the selected Access Category and one or more Access Identities provided by upper layers;

3\> if the access attempt is barred, the procedure ends;

1\> else if the resumption of the RRC connection is triggered by upper layers:

2\> if the upper layers provide an Access Category and one or more Access Identities:

3\> perform the unified access control procedure as specified in 5.3.14 using the Access Category and Access Identities provided by upper layers;

4\> if the access attempt is barred, the procedure ends;

2\> if the upper layers provide NSAG information and one or more S-NSSAI(s) triggering the access attempt (TS 23.501 \[32\] and TS 24.501 \[23\]):

3\> apply the NSAG with highest NSAG priority among the NSAGs that are included in *SIB1* (i.e., in *FeatureCombination* and/or in *RA-PrioritizationSliceInfo*), and that are associated with the S-NSSAI(s) triggering the access attempt, in the Random Access procedure (TS 38.321 \[3\], clause 5.1);

NOTE: If there are multiple NSAGs with the same highest NAS-provided NSAG priority identified for access attempt as above, it is left to UE implementation to select the NSAG to be applied in the Random Access procedure.

2\> if the resumption occurs after release with redirect with *mpsPriorityIndication*:

3\> set the *resumeCause* to *mps-PriorityAccess*;

2\> else:

3\> set the *resumeCause* in accordance with the information received from upper layers;

1\> else if the resumption of the RRC connection is triggered due to an RNA update as specified in 5.3.13.8:

2\> if an emergency service is ongoing:

NOTE 1: How the RRC layer in the UE is aware of an ongoing emergency service is up to UE implementation.

3\> select \'2\' as the Access Category;

3\> set the *resumeCause* to *emergency*;

2\> else:

3\> select \'8\' as the Access Category;

2\> perform the unified access control procedure as specified in 5.3.14 using the selected Access Category and one or more Access Identities to be applied as specified in TS 24.501 \[23\];

3\> if the access attempt is barred:

4\> set the variable *pendingRNA-Update* to *true*;

4\> the procedure ends;

1\> else if *srs-PosRRC-InactiveValidityAreaConfig* is configured and the resumption of the RRC connection is triggered due to cell reselection to a cell that is not included in *srs-PosConfigValidityArea* and there is an on-going SRS for positioning transmission:

2\> select \'8\' as the Access Category;

2\> set the *resumeCause* to *srs-PosConfigOrActivationReq*;

1\> else if *srs-PosRRC-InactiveValidityAreaConfig* is configured and the resumption of the RRC connection is triggered due to upper layers request for configuration or activation of preconfigured SRS for positioning when the UE is camped in one of the cells indicated in *srs-PosConfigValidityArea*:

2\> select \'8\' as the Access Category;

2\> set the *resumeCause* to *srs-PosConfigOrActivationReq*;

NOTE 2: In case the L2 U2N Relay UE initiates RRC connection resume triggered by reception of message from a L2 U2N Remote UE via SL-RLC0 or SL-RLC1 as specified in 5.3.13.1a, the L2 U2N Relay UE sets the *resumeCause* by implementation, but it can only set the *emergency*, *mps-PriorityAccess*, or *mcs-PriorityAccess* as *resumeCause*, if the same cause value in the message received from the L2 U2N Remote UE via SL-RLC0.

1\> if the UE is in NE-DC or NR-DC:

2\> if the UE does not support maintaining SCG configuration upon connection resumption:

3\> release the MR-DC related configurations (i.e., as specified in 5.3.5.10) from the UE Inactive AS context, if stored;

1\> if the UE does not support maintaining the MCG SCell configurations upon connection resumption:

2\> release the MCG SCell(s) from the UE Inactive AS context, if stored;

1\> if the UE is acting as L2 U2N Remote UE:

2\> establish a SRAP entity as specified in TS 38.351 \[66\], if no SRAP entity has been established;

2\> apply the default configuration of SL-RLC1 as defined in 9.2.4 for SRB1;

2\> apply the default PDCP configuration as defined in 9.2.1 for SRB1;

2\> apply the default configuration of SRAP as defined in 9.2.5 for SRB1;

1\> else:

2\> apply the default L1 parameter values as specified in corresponding physical layer specifications, except for the parameters for which values are provided in *SIB1*;

2\> apply the default SRB1 configuration as specified in 9.2.1;

2\> apply the default MAC Cell Group configuration as specified in 9.2.2;

1\> release *delayBudgetReportingConfig* from the UE Inactive AS context, if stored;

1\> stop timer T342, if running;

1\> release *overheatingAssistanceConfig* from the UE Inactive AS context, if stored;

1\> stop timer T345, if running;

1\> release *idc-AssistanceConfig* from the UE Inactive AS context, if stored;

1\> release *drx-PreferenceConfig* for all configured cell groups from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346a, if running;

1\> release *maxBW-PreferenceConfig* and *maxBW-PreferenceConfigFR2-2* for all configured cell groups from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346b, if running;

1\> release *maxCC-PreferenceConfig* for all configured cell groups from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346c, if running;

1\> release *maxMIMO-LayerPreferenceConfig* and *maxMIMO-LayerPreferenceConfigFR2-2* for all configured cell groups from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346d, if running;

1\> release *minSchedulingOffsetPreferenceConfig* and *minSchedulingOffsetPreferenceConfigExt* for all configured cell groups from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346e, if running;

1\> release *rlm-RelaxationReportingConfig* for all configured cell groups from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346j, if running;

1\> release *bfd-RelaxationReportingConfig* for all configured cell groups from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346k, if running;

1\> release *releasePreferenceConfig* from the UE Inactive AS context, if stored;

1\> release *wlanNameList* from the UE Inactive AS context, if stored;

1\> release *btNameList* from the UE Inactive AS context, if stored;

1\> release *sensorNameList* from the UE Inactive AS context, if stored;

1\> release *obtainCommonLocation* from the UE Inactive AS context, if stored;

1\> stop timer T346f, if running;

1\> stop timer T346i, if running;

1\> release *referenceTimePreferenceReporting* from the UE Inactive AS context, if stored;

1\> release *sl-AssistanceConfigNR* from the UE Inactive AS context, if stored;

1\> release *musim-GapAssistanceConfig* from the UE Inactive AS context, if stored and stop timer T346h, if running;

1\> release *musim-GapConfig* from the UE Inactive AS context, if stored;

1\> release *musim-GapPriorityAssistanceConfig* from the UE Inactive AS context, if stored;

1\> release *musim-LeaveAssistanceConfig* from the UE Inactive AS context, if stored;

1\> release *musim-CapabilityRestrictionConfig* from the UE Inactive AS context, if stored and stop timer T346n, if running;

1\> release *propDelayDiffReportConfig* from the UE Inactive AS context, if stored;

1\> release *ul-GapFR2-PreferenceConfig*, if configured;

1\> release *rrm-MeasRelaxationReportingConfig* from the UE Inactive AS context, if stored;

1\> release *multiRx-PreferenceReportingConfigFR2* if configured, and stop timer T440, if running;

1\> release *uav-FlightPathAvailabilityConfig* from the UE Inactive AS context, if stored;

1\> release *ul-TrafficInfoReportingConfig* from the UE Inactive AS context, if stored;

1\> stop all instances of timer T346x, if running;

1\> if the UE is acting as L2 U2N Remote UE:

2\> apply the specified configuration of SL-RLC0 used for the delivery of RRC message over SRB0 as specified in 9.1.1.4;

2\> apply the SDAP configuration and PDCP configuration as specified in 9.1.1.2 for SRB0;

1\> else:

2\> apply the CCCH configuration as specified in 9.1.1.2;

2\> apply the *timeAlignmentTimerCommon* included in *SIB1*;

1\> if *sdt-MAC-PHY-CG-Config* is configured:

2\> if the resume procedure is initiated in a cell that is different to the PCell in which the UE received the stored *sdt-MAC-PHY-CG-Config*:

3\> release the stored *sdt-MAC-PHY-CG-Config*;

3\> instruct the MAC entity to stop the *cg-SDT-TimeAlignmentTimer*, if it is running;

1\> if *ncd-SSB-RedCapInitialBWP-SDT* is configured:

2\> if the resume procedure is initiated in a cell that is different to the PCell in which the UE received the stored *ncd-SSB-RedCapInitialBWP-SDT*:

3\> release the stored *ncd-SSB-RedCapInitialBWP-SDT;*

1\> if conditions for initiating SDT in accordance with 5.3.13.1b are fulfilled:

2\> consider the resume procedure is initiated for SDT;

2\> start timer T319a when the lower layers first transmit the CCCH message;

2\> consider SDT procedure is ongoing;

1\> else:

2\> start timer T319;

2\> instruct the MAC entity to stop the *cg*-*SDT*-*TimeAlignmentTimer*, if it is running;

1\> if *ta-Report* or *ta-ReportATG* is configured with value *enabled* and the UE supports TA reporting:

2\> indicate TA report initiation to lower layers;

1\> set the variable *pendingRNA-Update* to *false*;

1\> release *successHO-Config* from the UE Inactive AS context, if stored;

1\> release *successPSCell-Config* configured by the PCell from the UE Inactive AS context, if stored;

1\> release *successPSCell-Config* configured by the PSCell from the UE Inactive AS context, if stored;

1\> initiate transmission of the *RRCResumeRequest* message or *RRCResumeRequest1* in accordance with 5.3.13.3.

#### 5.3.13.3 Actions related to transmission of *RRCResumeRequest* or *RRCResumeRequest1* message

The UE shall set the contents of *RRCResumeRequest* or *RRCResumeRequest1* message as follows:

1\> if field *useFullResumeID* is signalled in *SIB1*:

2\> select *RRCResumeRequest1* as the message to use;

2\> set the *resumeIdentity* to the stored *fullI-RNTI* value;

1\> else:

2\> select *RRCResumeRequest* as the message to use;

2\> set the *resumeIdentity* to the stored *shortI-RNTI* value;

1\> restore the RRC configuration, RoHC state, the EHC context(s), the UDC state, the stored QoS flow to DRB mapping rules and the K~gNB~ and K~RRCint~ keys from the stored UE Inactive AS context except for the following:

- masterCellGroup;

- mrdc-SecondaryCellGroup, if stored; and

- pdcp-Config;

1\> set the *resumeMAC-I* to the 16 least significant bits of the MAC-I calculated:

2\> over the ASN.1 encoded as per clause 8 (i.e., a multiple of 8 bits) *VarResumeMAC-Input*;

2\> with the K~RRCint~ key in the UE Inactive AS Context and the previously configured integrity protection algorithm; and

2\> with all input bits for COUNT, BEARER and DIRECTION set to binary ones;

1\> derive the K~gNB~ key based on the current K~gNB~ key or the NH, using the *nextHopChainingCount* value received in the previous *RRCRelease* message and stored in the UE Inactive AS Context, as specified in TS 33.501 \[11\];

1\> derive the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key;

1\> configure lower layers to apply integrity protection for all radio bearers except SRB0 and MRBs using the configured algorithm and the K~RRCint~ key and K~UPint~ key derived in this clause immediately, i.e., integrity protection shall be applied to all subsequent messages received and sent by the UE;

NOTE 1: Only DRBs with previously configured UP integrity protection shall resume integrity protection.

1\> configure lower layers to apply ciphering for all radio bearers except SRB0 and MRBs and to apply the configured ciphering algorithm, the K~RRCenc~ key and the K~UPenc~ key derived in this clause, i.e. the ciphering configuration shall be applied to all subsequent messages received and sent by the UE;

1\> re-establish PDCP entities for SRB1;

1\> resume SRB1;

1\> if the resume procedure is initiated for SDT:

2\> for each radio bearer that is configured for SDT and for SRB1:

3\> restore the *RLC-BearerConfig* associated with the RLC bearers of *masterCellGroup* and *pdcp-Config* from the UE Inactive AS context;

3\> if the radio bearer is a DRB configured with Ethernet Header Compression:

4\> indicate to lower layer that *ethernetHeaderCompression* is not configured;

3\> if the radio bearer is a DRB configured with UDC:

4\> indicate to lower layer that *uplinkDataCompression* is not configured;

3\> if the radio bearer is a DRB configured with ROHC function:

4\> if *sdt-DRB-ContinueROHC* is set to *cell* and the resume procedure is initiated in a cell that is the same as the PCell in which the UE received the previous *RRCRelease* message; or

4\> if *sdt-DRB-ContinueROHC* is set to *rna* and the resume procedure is initiated in a cell belonging to the same RNA as the PCell in which the UE received the previous *RRCRelease* message:

5\> indicate to lower layer that *drb-continueROHC* is configured;

4\> else:

5\> indicate to lower layer that *drb-continueROHC* is not configured;

3\> re-establish PDCP entity for the radio bearer that is configured for SDT without triggering PDCP status report;

2\> resume all the radio bearers that are configured for SDT;

1\> submit the selected message *RRCResumeRequest* or *RRCResumeRequest1* for transmission to lower layers.

NOTE 2: Only DRBs with previously configured UP ciphering shall resume ciphering.

NOTE 2a: Before the lower layers first transmit the *RRCResumeRequest* or *RRCResumeRequest1*, the UE may initiate a new resume procedure if other conditions for initiation of the resume procedure as specified in 5.3.13.2 are satisfied.

If lower layers indicate an integrity check failure while T319 is running or SDT procedure is ongoing, perform actions specified in 5.3.13.5.

If the UE is an (e)RedCap UE and the (e)RedCap-specific initial downlink BWP is not associated with CD-SSB, the UE may continue cell re-selection related measurements as well as cell re-selection evaluation, otherwise the UE shall continue cell re-selection related measurements as well as cell re-selection evaluation. If the conditions for cell re-selection are fulfilled, the UE shall perform cell re-selection as specified in 5.3.13.6.

NOTE 3: For L2 U2N Remote UE in RRC_INACTIVE, the cell (re)selection procedure as specified in TS 38.304 \[20\] and relay (re)selection procedure as specified in 5.8.15.3 are performed independently and it is up to UE implementation to select either a cell or a L2 U2N Relay UE.

#### 5.3.13.4 Reception of the *RRCResume* by the UE

The UE shall:

1\> stop timer T319, if running;

1\> stop timer T319a, if running and consider SDT procedure is not ongoing;

1\> stop timer T380, if running;

1\> if T331 is running:

2\> stop timer T331;

2\> perform the actions as specified in 5.7.8.3;

1\> if the *RRCResume* includes the *fullConfig*:

2\> perform the full configuration procedure as specified in 5.3.5.11;

1\> else:

2\> if the *RRCResume* does not include the *restoreMCG-SCells*:

3\> release the MCG SCell(s) from the UE Inactive AS context, if stored;

2\> if the *RRCResume* does not include the *restoreSCG*:

3\> release the MR-DC related configurations (i.e., as specified in 5.3.5.10) from the UE Inactive AS context, if stored;

2\> restore the *masterCellGroup, mrdc-SecondaryCellGroup*, if stored, and *pdcp-Config* from the UE Inactive AS context;

2\> configure lower layers to consider the restored MCG and SCG SCell(s) (if any) to be in deactivated state;

1\> discard the UE Inactive AS context;

1\> store the used *nextHopChainingCount* value associated to the current K~gNB~;

1\> if *sdt-MAC-PHY-CG-Config* is configured:

2\> instruct the MAC entity to stop the *cg-SDT-TimeAlignmentTimer*, if it is running;

2\> instruct the MAC entity to start the *timeAlignmentTimer* associated with the PTAG*,* if it is not running;

1\> if *srs-PosRRC-Inactive* is configured:

2\> instruct the MAC entity to stop *inactivePosSRS-TimeAlignmentTimer*, if it is running;

1\> if *srs-PosRRC-InactiveValidityAreaConfig* is configured:

2\> instruct the MAC entity to stop *inactivePosSRS-ValidityAreaTAT*, if it is running;

1\> release the *suspendConfig* except the *ran-NotificationAreaInfo*;

1\> if the *RRCResume* includes the *masterCellGroup*:

2\> perform the cell group configuration for the received *masterCellGroup* according to 5.3.5.5;

1\> if the *RRCResume* includes the *mrdc-SecondaryCellGroup:*

2\> if the received *mrdc-SecondaryCellGroup* is set to *nr-SCG*:

3\> perform the RRC reconfiguration according to 5.3.5.3 for the *RRCReconfiguration* message included in *nr-SCG*;

2\> if the received *mrdc-SecondaryCellGroup* is set to *eutra-SCG*:

3\> perform the RRC connection reconfiguration as specified in TS 36.331 \[10\], clause 5.3.5.3 for the *RRCConnectionReconfiguration* message included in *eutra-SCG*;

1\> if the *RRCResume* includes the *radioBearerConfig*:

2\> perform the radio bearer configuration according to 5.3.5.6;

1\> if the *RRCResume* message includes the *sk-Counter*:

2\> perform security key update procedure as specified in 5.3.5.7;

1\> if the *RRCResume* message includes the *radioBearerConfig2*:

2\> perform the radio bearer configuration according to 5.3.5.6;

1\> if the *RRCResume* message includes the *needForGapsConfigNR*:

2\> if *needForGapsConfigNR* is set to *setup*:

3\> consider itself to be configured to provide the measurement gap requirement information of NR target bands;

2\> else:

3\> consider itself not to be configured to provide the measurement gap requirement information of NR target bands;

1\> if the *RRCResume* message includes the *needForGapNCSG-ConfigNR*:

2\> if *needForGapNCSG-ConfigNR* is set to *setup*:

3\> consider itself to be configured to provide the measurement gap and NCSG requirement information of NR target bands;

2\> else:

3\> consider itself not to be configured to provide the measurement gap and NCSG requirement information of NR target bands;

1\> if the *RRCResume* message includes the *needForGapNCSG-ConfigEUTRA*:

2\> if *needForGapNCSG-ConfigEUTRA* is set to *setup*:

3\> consider itself to be configured to provide the measurement gap and NCSG requirement information of E‑UTRA target bands;

2\> else:

3\> consider itself not to be configured to provide the measurement gap and NCSG requirement information of E‑UTRA target bands;

1\> if *idleInactiveReportAllowed* is not included in the *RRCResume* message:

2\> for each application layer measurement configuration with *configforRRC-IdleInactive* set to *true*:

3\> forward the *measConfigAppLayerId* and inform upper layers about the release of the application layer measurement configuration;

3\> discard any application layer measurement reports which were not yet submitted to lower layers for transmission;

3\> release the application layer measurement configuration in UE variables *VarAppLayerIdleConfig* and *VarAppLayerPLMN-ListConfig*;

3\> consider itself not to be configured to send application layer measurement report for the *measConfigAppLayerId*;

1\> if the *RRCResume* message includes the *appLayerMeasConfig*:

2\> perform the application layer measurement configuration procedure as specified in 5.3.5.13d;

1\> if the *RRCResume* message includes the *sl-L2RemoteUE-Config* (i.e. the UE is a L2 U2N Remote UE):

2\> perform the L2 U2N Remote UE configuration procedure as specified in 5.3.5.16;

1\> if the *RRCResume* message includes the *sl-ConfigDedicatedNR*:

2\> perform the sidelink dedicated configuration procedure as specified in 5.3.5.14;

1\> resume SRB2 (if suspended), SRB3 (if configured), SRB4 (if configured), all DRBs (that are suspended) and multicast MRBs (that are suspended);

NOTE 1: If the SCG is deactivated, resuming SRB3 and all DRBs does not imply that PDCP or RRC PDUs can be transmitted or received on SCG RLC bearers.

1\> if stored, discard the cell reselection priority information provided by the *cellReselectionPriorities* or inherited from another RAT;

1\> stop timer T320, if running;

1\> if the *RRCResume* message includes the *measConfig*:

2\> perform the measurement configuration procedure as specified in 5.5.2;

1\> resume measurements if suspended;

1\> if T390 is running:

2\> stop timer T390 for all access categories;

2\> perform the actions as specified in 5.3.14.4;

1\> if T302 is running:

2\> stop timer T302;

2\> perform the actions as specified in 5.3.14.4;

1\> enter RRC_CONNECTED;

1\> indicate to upper layers that the suspended RRC connection has been resumed;

1\> stop the cell re-selection procedure;

1\> stop relay reselection procedure if any for L2 U2N Remote UE;

1\> consider the current cell to be the PCell;

1\> set the content of the of *RRCResumeComplete* message as follows:

2\> if the upper layer provides NAS PDU, set the *dedicatedNAS-Message* to include the information received from upper layers;

2\> if upper layers provides a PLMN:

3\> if the UE is either allowed or instructed to access the PLMN via a cell for which at least one CAG ID is broadcast:

4\> set the *selectedPLMN-Identity* from the *npn-IdentityInfoList*;

3\> else:

4\> set the *selectedPLMN-Identity* to the PLMN selected by upper layers from the *plmn-IdentityInfoList*;

2\> if the *masterCellGroup* contains the *reportUplinkTxDirectCurrent*:

3\> include the *uplinkTxDirectCurrentList* for each MCG serving cell with UL;

3\> include *uplinkDirectCurrentBWP-SUL* for each MCG serving cell configured with SUL carrier, if any, within the *uplinkTxDirectCurrentList*;

2\> if the *masterCellGroup* contains the *reportUplinkTxDirectCurrentTwoCarrier*:

3\> include in the *uplinkTxDirectCurrentTwoCarrierList* the list of uplink Tx DC locations for the configured uplink carrier aggregation in the MCG;

2\> if the *masterCellGroup* contains the *reportUplinkTxDirectCurrentMoreCarrier*:

3\> include in the *uplinkTxDirectCurrentMoreCarrierList* the list of uplink Tx DC locations for the configured uplink carrier aggregation in the MCG;

2\> if the UE has idle/inactive measurement information concerning cells other than the PCell available in *VarMeasIdleReport*:

3\> if the *idleModeMeasurementReq* is included in the *RRCResume* message:

4\> set the *measResultIdleEUTRA* in the *RRCResumeComplete* message to the value of *measReportIdleEUTRA* in the *VarMeasIdleReport,* if available;

4\> set the *measResultIdleNR* in the *RRCResumeComplete* message to the value of *measReportIdleNR* in the *VarMeasIdleReport*, if available;

4\> discard the *VarMeasIdleReport* upon successful delivery of the *RRCResumeComplete* message is confirmed by lower layers;

3\> else:

4\> if the SIB1 contains *idleModeMeasurementsNR* and the UE has NR idle/inactive measurement information concerning cells other than the PCell available in *VarMeasIdleReport*; or

4\> if the SIB1 contains *idleModeMeasurementsEUTRA* and the UE has E-UTRA idle/inactive measurement information available in *VarMeasIdleReport*:

5\> include the *idleMeasAvailable*;

2\> if the *RRCResume* message includes *mrdc-SecondaryCellGroup* set to *eutra-SCG*:

3\> include in the *eutra-SCG-Response* the E-UTRA *RRCConnectionReconfigurationComplete* message in accordance with TS 36.331 \[10\] clause 5.3.5.3;

2\> if the *RRCResume* message includes *mrdc-SecondaryCellGroup* set to *nr-SCG*:

3\> include in the *nr-SCG-Response* the SCG *RRCReconfigurationComplete* message;

2\> if the UE has logged measurements available for NR and if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*; or

2\> if the UE has logged measurements available for NR and if the current registered SNPN is included in *snpn-ConfigIDList* stored in *VarLogMeasReport*:

3\> include the *logMeasAvailable* in the *RRCResumeComplete* message*;*

3\> if Bluetooth measurement results are included in the logged measurements the UE has available for NR:

4\> include the *logMeasAvailableBT* in the *RRCResumeComplete* message;

3\> if WLAN measurement results are included in the logged measurements the UE has available for NR:

4\> include the *logMeasAvailableWLAN* in the *RRCResumeComplete* message;

2\> if the *sigLoggedMeasType* in *VarLogMeasReport* is included; or

2\> if the UE is capable of reporting availability of signalling based logged MDT for inter-RAT (i.e. LTE to NR), and if the *sigLoggedMeasType* in *VarLogMeasReport* of TS 36.331 \[10\] is included:

3\> if T330 timer is running (associated to the logged measurement configuration for NR or for LTE):

4\> set *sigLogMeasConfigAvailable* to *true* in the *RRCResumeComplete* message;

3\> else:

4\> if the UE has logged measurements:

5\> set *sigLogMeasConfigAvailable* to *false* in the *RRCResumeComplete* message;

2\> if the UE has connection establishment failure or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the RPLMN is equal to *plmn-Identity* stored in *VarConnEstFailReport* or in at least one of the entries of *VarConnEstFailReportList*; or

2\> if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the registered SNPN identity is equal to *snpn-identity* stored in *VarConnEstFailReport* or any entry of *VarConnEstFailReportList*:

3\> include *connEstFailInfoAvailable* in the *RRCResumeComplete* message;

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report*; or

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* of TS 36.331 \[10\] and if the UE is capable of cross-RAT RLF reporting and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report* of TS 36.331 \[10\]; or

2\> if the UE has radio link failure or handover failure information available in *VarRLF-Report* and if the current registered SNPN are included in *snpn-IdentityList* stored in *VarRLF-Report*; or

3\> include *rlf-InfoAvailable* in the *RRCResumeComplete* message;

2\> if the UE has successful PSCell change or addition related information available in *VarSuccessPSCell-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessPSCell-Report*; or

2\> if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessPSCell-Report*:

3\> include *successPSCell-InfoAvailable* in the *RRCResumeComplete* message;

2\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessHO-Report*; or

2\> if the UE has successful handover information available in *VarSuccessHO-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in the *VarSuccessHO-Report*:

3\> include *successHO-InfoAvailable* in the *RRCResumeComplete* message;

2\> if the UE supports storage of mobility history information and the UE has mobility history information available in *VarMobilityHistoryReport*:

3\> include the *mobilityHistoryAvail* in the *RRCResumeComplete* message;

2\> if *speedStateReselectionPars* is configured in the *SIB2*:

3\> include the *mobilityState* in the *RRCResumeComplete* message and set it to the mobility state (as specified in TS 38.304 \[20\]) of the UE just prior to entering RRC_CONNECTED state;

2\> if the UE is configured with at least one application layer measurement with *configForRRC-IdleInactive* set to *true*:

3\> for each application layer measurement configuration with *configForRRC-IdleInactive* set to *true*:

4\> if the RPLMN is not included in *plmn-IdentityList* in *VarAppLayerPLMN-ListConfig*:

5\> forward the *measConfigAppLayerId* and inform upper layers about the release of the application layer measurement configuration;

5\> discard any application layer measurement reports which were not yet submitted to lower layers for transmission;

5\> release the application layer measurement configuration in UE variables *VarAppLayerIdleConfig* and *VarAppLayerPLMN-ListConfig*;

5\> consider itself not to be configured to send application layer measurement report for the *measConfigAppLayerId*;

3\> if at least one stored application layer measurement configuration or application layer measurement report container has not been released:

4\> include *measConfigReportAppLayerAvailable* in the *RRCResumeComplete* message;

2\> if the UE is configured to provide the measurement gap requirement information of NR target bands:

3\> include the *NeedForGapsInfoNR* and set the contents as follows:

4\> include *intraFreq-needForGap* and set the gap requirement information of intra-frequency measurement for each NR serving cell;

4\> if *requestedTargetBandFilterNR* is configured, for each supported NR band that is also included in *requestedTargetBandFilterNR*, include an entry in *interFreq-needForGap* and set the gap requirement information for that band; otherwise, include an entry in *interFreq-needForGap* and set the corresponding gap requirement information for each supported NR band;

3\> if the *needForInterruptionConfigNR* is enabled:

4\> include the *needForInterruptionInfoNR* and set the contents as follows:

5\> include *intraFreq-needForInterruption* with the same number of entries, and listed in the same order, as in *intraFreq-needForGap*;

5\> for each entry in *intraFreq-needForInterruption*, include *interruptionIndication* and set the interruption requirement information if the corresponding entry in *intraFreq-needForGap* is set to *no-gap;*

5\> include *interFreq-needForInterruption* with the same number of entries, and listed in the same order, as in *interFreq-needForGap*;

5\> for each entry in *interFreq-needForInterruption*, include *interruptionIndication* and set the interruption requirement information if the corresponding entry in *interFreq-needForGap* is set to *no-gap*;

2\> if the UE is configured to provide the measurement gap and NCSG requirement information of NR target bands:

3\> include the *NeedForGapNCSG-InfoNR* and set the contents as follows:

4\> include *intraFreq-needForNCSG* and set the gap and NCSG requirement information of intra-frequency measurement for each NR serving cell;

4\> if *requestedTargetBandFilterNCSG-NR* is configured:

5\> for each supported NR band included in *requestedTargetBandFilterNCSG-NR*, include an entry in *interFreq-needForNCSG* and set the NCSG requirement information for that band;

4\> else:

5\> include an entry for each supported NR band in *interFreq-needForNCSG* and set the corresponding NCSG requirement information;

2\> if the UE is configured to provide the measurement gap and NCSG requirement information of E‑UTRA target bands:

3\> include the *NeedForGapNCSG-InfoEUTRA* and set the contents as follows:

4\> if *requestedTargetBandFilterNCSG-EUTRA* is configured:

5\> for each supported E-UTRA band included in *requestedTargetBandFilterNCSG-EUTRA*, include an entry in *needForNCSG-EUTRA* and set the NCSG requirement information for that band;

4\> else:

5\> include an entry for each supported E-UTRA band in *needForNCSG-EUTRA* and set the corresponding NCSG requirement information;

2\> if the SIB1 contains *musim-CapRestrictionAllowed* and the UE capability is restricted for MUSIM operation:

3\> if supported, include the *musim-CapRestrictionInd* in the *RRCResumeComplete* message upon determining it has temporary capability restriction;

2\> if the UE has flight path information available:

3\> include *flightPathInfoAvailable*;

1\> submit the *RRCResumeComplete* message to lower layers for transmission;

1\> the procedure ends.

NOTE 2: Network only configures at most one of *reportUplinkTxDirectCurrent, reportUplinkTxDirectCurrentTwoCarrier* or *reportUplinkTxDirectCurrentMoreCarrier* in one RRC message*.*

#### 5.3.13.5 Handling of failure to resume RRC Connection

The UE shall:

1\> if timer T319 expires:

2\> if the UE supports multiple CEF report:

3\> if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* and if the RPLMN is equal to *plmn-identity* stored in *VarConnEstFailReport*; and

3\> if the cell identity of current cell is not equal to the cell identity stored in *measResultFailedCell* in *VarConnEstFailReport* and if the *maxCEFReport-r17* has not been reached:

4\> append the *VarConnEstFailReport* as a new entry in the *VarConnEstFailReportList*;

2\> if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* and if the RPLMN is not equal to *plmn-identity* stored in *VarConnEstFailReport*; or

2\> if the cell identity of current cell is not equal to the cell identity stored in *measResultFailedCell* in *VarConnEstFailReport*:

3\> reset the *numberOfConnFail* to 0;

2\> if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReportList* and if the RPLMN is not equal to *plmn-identity* stored in any entry of *VarConnEstFailReportList*:

3\> clear the content included in *VarConnEstFailReportList*;

2\> clear the content included in *VarConnEstFailReport* except for the *numberOfConnFail*, if any;

2\> store the following connection resume failure information in the *VarConnEstFailReport* by setting its fields as follows:

3\> set the *plmn-Identity* to the PLMN selected by upper layers (see TS 24.501 \[23\]) from the PLMN(s) included in the *plmn-IdentityInfoList* in *SIB1*;

3\> set the *measResultFailedCell* to include the global cell identity, tracking area code, the cell level and SS/PBCH block level RSRP, and RSRQ, and SS/PBCH block indexes, of the failed cell based on the available SSB measurements collected up to the moment the UE detected connection resume failure;

3\> if available, set the *measResultNeighCells*, in order of decreasing ranking-criterion as used for cell re-selection, to include neighbouring cell measurements for at most the following number of neighbouring cells: 6 intra-frequency and 3 inter-frequency neighbours per frequency as well as 3 inter-RAT neighbours, per frequency/ set of frequencies per RAT and according to the following:

4\> for each neighbour cell included, include the optional fields that are available;

NOTE: The UE includes the latest results of the available measurements as used for cell reselection evaluation, which are performed in accordance with the performance requirements as specified in TS 38.133 \[14\].

3\> if available, set the *locationInfo* as in 5.3.3.7;

3\> set *perRAInfoList* to indicate the performed random access procedure related information as specified in 5.7.10.5;

3\> if *numberOfConnFail* is smaller than 8:

4\> increment the *numberOfConnFail* by 1;

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause \'RRC Resume failure\'.

1\> else if upon receiving integrity check failure indication from lower layers while T319 is running:

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause \'RRC Resume failure\'.

1\> else if indication from the MCG RLC that the maximum number of retransmissions has been reached is received while SDT procedure is ongoing; or

1\> if random access problem indication is received from MCG MAC while SDT procedure is ongoing; or

1\> if the lower layers indicate that *cg*-*SDT*-*TimeAlignmentTimer* or the *configuredGrantTimer* expired before receiving network response for the UL CG-SDT transmission with CCCH message while SDT procedure is ongoing; or

1\> if integrity check failure indication is received from lower layers while SDT procedure is ongoing; or

1\> if T319a expires:

2\> consider SDT procedure is not ongoing;

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause \'RRC Resume failure\'.

The UE may discard the connection resume failure or connection establishment failure information, i.e. release the UE variable *VarConnEstFailReport* and the UE variable *VarConnEstFailReportList*, 48 hours after the last connection resume failure is detected.

The L2 U2N Relay UE either indicates to upper layers (to trigger PC5 unicast link release) or sends *NotificationMessageSidelink* message to the connected L2 U2N Remote UE(s) in accordance with 5.8.9.10.

#### 5.3.13.6 Cell re-selection or cell selection or L2 U2N relay (re)selection while T390, T319 or T302 is running or SDT procedure is ongoing (UE in RRC_INACTIVE) or SRS transmission in RRC_INACTIVE is configured

The UE shall:

1\> if cell reselection occurs while T319 or T302 is running or while SDT procedure is ongoing; or

1\> if relay reselection occurs while T319 is running; or

1\> if cell changes due to relay reselection while T302 is running:

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause \'RRC Resume failure\';

1\> else if cell selection or reselection occurs while T390 is running, or cell change due to relay selection or reselection occurs while T390 is running:

2\> stop T390 for all access categories;

2\> perform the actions as specified in 5.3.14.4.

1\> else if cell reselection occurs when *srs-PosRRC-Inactive* is configured:

2\> indicate to the lower layer to stop *inactivePosSRS-TimeAlignmentTimer*;

2\> release the *srs-PosRRC-Inactive*.

1\> else if cell reselection occurs when *srs-PosRRC-InactiveValidityAreaConfig* is configured and if the cell is not included in the *srs-PosConfigValidityArea*:

2\> indicate to the lower layer to stop *inactivePosSRS-ValidityAreaTAT*;

1\> else if cell reselection occurs when *srs-PosRRC-InactiveValidityAreaConfig* is configured and if the cell is included in the *srs-PosRRC-InactiveValidityAreaConfig*:

2\> if *autonomousTA-AdjustmentEnabled* is configured;

3\> indicate to the lower layer to update Timing Advance and stored RSRP.

#### 5.3.13.7 Reception of the *RRCSetup* by the UE

The UE shall:

1\> perform the RRC connection setup procedure as specified in 5.3.3.4.

#### 5.3.13.8 RNA update

In RRC_INACTIVE state, the UE shall:

1\> if T380 expires; or

1\> if RNA Update is triggered at reception of SIB1, as specified in 5.2.2.4.2:

2\> if T319 is not running and SDT procedure is not ongoing:

3\> initiate RRC connection resume procedure in 5.3.13.2 with *resumeCause* set to *rna-Update*;

1\> if barring is alleviated for Access Category \'8\' or Access Category \'2\', as specified in 5.3.14.4:

2\> if upper layers do not request RRC the resumption of an RRC connection, and

2\> if the variable *pendingRNA-Update* is set to *true*:

3\> initiate RRC connection resume procedure in 5.3.13.2 with *resumeCause* value set to *rna-Update*.

If the UE in RRC_INACTIVE state fails to find a suitable cell and camps on the acceptable cell to obtain limited service as defined in TS 38.304 \[20\], the UE shall:

1\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause \'other\'.

NOTE: It is left to UE implementation how to behave when T380 expires while the UE is camped neither on a suitable nor on an acceptable cell.

#### 5.3.13.9 Reception of the *RRCRelease* by the UE

The UE shall:

1\> perform the actions as specified in 5.3.8.

#### 5.3.13.10 Reception of the *RRCReject* by the UE

The UE shall:

1\> perform the actions as specified in 5.3.15.

#### 5.3.13.11 Inability to comply with *RRCResume*

The UE shall:

1\> if the UE is unable to comply with (part of) the configuration included in the *RRCResume* message;

2\> perform the actions upon going to RRC_IDLE as specified in 5.3.11 with release cause ′RRC Resume failure′.

NOTE 1: The UE may apply above failure handling also in case the *RRCResume* message causes a protocol error for which the generic error handling as defined in 10 specifies that the UE shall ignore the message.

NOTE 2: If the UE is configured (i.e., via SIB1) to send MUSIM temporary capability restriction indication, and if the UE supports MUSIM temporary capability restriction, the UE does not apply above failure handling in case the UE is unable to apply part of the configuration included in *RRCResume* message due to UE temporary capability restriction for MUSIM operation. It is up to UE implementation how to apply *RRCResume* message. If UE does not go to RRC_IDLE in this case, UE still considers the received configuration in *RRCResume* message as the current configuration as the baseline for delta configuration for future reconfigurations. For other cases, if the UE is unable to comply with part of the configuration, it does not apply any part of the configuration, i.e. there is no partial success/failure.

#### 5.3.13.12 Inter RAT cell reselection

Upon reselecting to an inter-RAT cell, the UE shall:

1\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'other\'.

### 5.3.14 Unified Access Control

#### 5.3.14.1 General

The purpose of this procedure is to perform access barring check for an access attempt associated with a given Access Category and one or more Access Identities upon request from upper layers according to TS 24.501 \[23\] or the RRC layer. This procedure does not apply to IAB-MT and NCR-MT. This procedure does not apply to L2 U2N Relay UE initiating RRC connection establishment or RRC connection resume upon reception of any message from a L2 U2N remote UE via SL-RLC0 or SL-RLC1 in accordance to 5.3.3.1a or 5.3.13.1a.

After a PCell change in RRC_CONNECTED the UE shall defer access barring checks until it has obtained *SIB1* (as specified in 5.2.2.2) from the target cell.

#### 5.3.14.2 Initiation

Upon initiation of the procedure, the UE shall:

1\> if timer T390 is running for the Access Category:

2\> consider the access attempt as barred;

1\> else if timer T302 is running and the Access Category is neither \'2\' nor \'0\':

2\> consider the access attempt as barred;

1\> else:

2\> if the Access Category is \'0\':

3\> consider the access attempt as allowed;

2\> else:

3\> if *SIB1* includes *uac-BarringPerPLMN-List* that contains a *UAC-BarringPerPLMN* for the selected PLMN or SNPN:

4\> if the procedure in 5.2.2.4.2 for a selected PLMN resulted in use of information in *npn-IdentityInfoList* and *UAC-BarringPerPLMN* has an entry with the *plmn-IdentityIndex* corresponding to used information in this list:

5\> select the *UAC-BarringPerPLMN* entry with the *plmn-IdentityIndex* corresponding to used information in the *npn-IdentityInfoList*;

4\> else:

5\> select the *UAC-BarringPerPLMN* entry with the *plmn-IdentityIndex* corresponding to the selected PLMN and the *PLMN-IdentityInfo, if any,* or the selected SNPN and the *npn-IdentityInfoList*;

3\> if any *UAC-BarringPerPLMN* entry is selected:

4\> in the remainder of this procedure, use the selected *UAC-BarringPerPLMN* entry (i.e. presence or absence of access barring parameters in this entry) irrespective of the *uac-BarringForCommon* included in *SIB1*;

3\> else if SIB1 includes *uac-BarringForCommon*:

4\> in the remainder of this procedure use the *uac-BarringForCommon* (i.e. presence or absence of these parameters) included in *SIB1*;

3\> else:

4\> consider the access attempt as allowed;

3\> if *uac-BarringForCommon* is applicable or the *uac-ACBarringListType* indicates that *uac-ExplicitACBarringList* is used:

4\> if the corresponding *UAC-BarringPerCatList* contains a *UAC-BarringPerCat* entry corresponding to the Access Category:

5\> select the *UAC-BarringPerCat* entry;

5\> if the *uac-BarringInfoSetList* contains a *UAC-BarringInfoSet* entry corresponding to the selected *uac-barringInfoSetIndex* in the *UAC-BarringPerCat*:

6\> select the *UAC-BarringInfoSet* entry;

6\> perform access barring check for the Access Category as specified in 5.3.14.5, using the selected *UAC-BarringInfoSet* as \"UAC barring parameter\";

5\> else:

6\> consider the access attempt as allowed;

4\> else:

5\> consider the access attempt as allowed;

3\> else if the *uac-ACBarringListType* indicates that *uac-ImplicitACBarringList* is used:

4\> select the *uac-BarringInfoSetIndex* corresponding to the Access Category in the *uac-ImplicitACBarringList*;

4\> if the *uac-BarringInfoSetList* contains the *UAC-BarringInfoSet* entry corresponding to the selected *uac-BarringInfoSetIndex*:

5\> select the *UAC-BarringInfoSet* entry;

5\> perform access barring check for the Access Category as specified in 5.3.14.5, using the selected *UAC-BarringInfoSet* as \"UAC barring parameter\";

4\> else:

5\> consider the access attempt as allowed;

3\> else:

4\> consider the access attempt as allowed;

1\> if the access barring check was requested by upper layers:

2\> if the access attempt is considered as barred:

3\> if timer T302 is running:

4\> if timer T390 is running for Access Category \'2\':

5\> inform the upper layer that access barring is applicable for all access categories except categories \'0\', upon which the procedure ends;

4\> else

5\> inform the upper layer that access barring is applicable for all access categories except categories \'0\' and \'2\', upon which the procedure ends;

3\> else:

4\> inform upper layers that the access attempt for the Access Category is barred, upon which the procedure ends;

2\> else:

3\> inform upper layers that the access attempt for the Access Category is allowed, upon which the procedure ends;

1\> else:

2\> the procedure ends.

#### 5.3.14.3 Void

#### 5.3.14.4 T302, T390 expiry or stop (Barring alleviation)

The UE shall:

1\> if timer T302 expires or is stopped:

2\> for each Access Category for which T390 is not running:

3\> consider the barring for this Access Category to be alleviated:

1\> else if timer T390 corresponding to an Access Category other than \'2\' expires or is stopped, and if timer T302 is not running:

2\> consider the barring for this Access Category to be alleviated;

1\> else if timer T390 corresponding to the Access Category \'2\' expires or is stopped:

2\> consider the barring for this Access Category to be alleviated;

1\> when barring for an Access Category is considered being alleviated:

2\> if the Access Category was informed to upper layers as barred:

3\> inform upper layers about barring alleviation for the Access Category.

2\> else if the Access Category is Access Category \'0\':

3\> perform actions specified in 5.3.13.1d;

2\> if barring is alleviated for Access Category \'8\'; or

2\> if barring is alleviated for Access Category \'2\':

3\> perform actions specified in 5.3.13.8;

#### 5.3.14.5 Access barring check

The UE shall:

1\> if one or more Access Identities equal to 1, 2, 11, 12, 13, 14, or 15 are indicated according to TS 24.501 \[23\], and

1\> if for at least one of these Access Identities the corresponding bit in the *uac-BarringForAccessIdentity* contained in \"UAC barring parameter\" is set to *zero*:

2\> consider the access attempt as allowed;

1\> else:

2\> if the establishment of the RRC connection is the result of release with redirect with *mpsPriorityIndication* (either in NR or E-UTRAN)*;* and

2\> if the bit corresponding to Access Identity 1 in the *uac-BarringForAccessIdentity* contained in the \"UAC barring parameter\" is set to *zero:*

3\> consider the access attempt as allowed;

2\> else if Access Identity 3 is indicated:

3\> draw a random number \'*rand*\' uniformly distributed in the range: $0 \leq rand < 1$;

3\> if \'*rand*\' is lower than the value indicated by *uac-BarringFactorForAI3* included in \"UAC barring parameter\":

4\> consider the access attempt as allowed;

3\> else:

4\> consider the access attempt as barred;

2\> else:

3\> draw a random number \'*rand*\' uniformly distributed in the range: $0 \leq rand < 1$;

3\> if \'*rand*\' is lower than the value indicated by *uac-BarringFactor* included in \"UAC barring parameter\":

4\> consider the access attempt as allowed;

3\> else:

4\> consider the access attempt as barred;

1\> if the access attempt is considered as barred:

2\> draw a random number \'*rand*\' that is uniformly distributed in the range $0 \leq rand < 1$;

2\> start timer T390 for the Access Category with the timer value calculated as follows, using the *uac-BarringTime* included in \"UAC barring parameter\":

$$T390 = (0.7 + 0.6 * rand) * uac-BarringTime.$$

### 5.3.15 RRC connection reject

#### 5.3.15.1 Initiation

The UE initiates the procedure upon the reception of *RRCReject* when the UE tries to establish or resume an RRC connection.

#### 5.3.15.2 Reception of the *RRCReject* by the UE

The UE shall:

1\> stop timer T300, if running;

1\> stop timer T319, if running;

1\> stop timer T319a, if running and consider SDT procedure is not ongoing;

1\> stop timer T302, if running;

1\> reset MAC and release the default MAC Cell Group configuration;

1\> if *waitTime* is configured in the *RRCReject*:

2\> start timer T302, with the timer value set to the *waitTime*;

1\> if *RRCReject* is received in response to a request from upper layers:

2\> inform the upper layer that access barring is applicable for all access categories except categories \'0\' and \'2\';

1\> if *RRCReject* is received in response to an *RRCSetupRequest*:

2\> inform upper layers about the failure to setup the RRC connection, upon which the procedure ends;

1\> else if *RRCReject* is received in response to an *RRCResumeRequest* or an *RRCResumeRequest1*:

2\> if resume is triggered by upper layers:

3\> inform upper layers about the failure to resume the RRC connection;

2\> if resume is triggered due to an RNA update; or

2\> if resume is triggered for SDT and T380 has expired:

3\> set the variable *pendingRNA-Update* to *true*;

2\> discard the current K~gNB~ key, the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key derived in accordance with 5.3.13.3;

2\> if resume is triggered for SDT:

3\> for SRB2, if it is resumed and for SRB1:

4\> trigger the PDCP entity to perform SDU discard as specified in TS 38.323 \[5\];

4\> re-establish the RLC entity as specified in TS 38.322 \[4\];

3\> for each DRB that is not suspended:

4\> indicate PDCP suspend to lower layers;

4\> re-establish the RLC entity as specified in TS 38.322 \[4\];

2\> suspend SRB1 and the radio bearers configured for SDT, if any;

2\> the procedure ends.

Upon L2 U2N Relay UE receives *RRCReject*, it either indicates to upper layers (to trigger PC5 unicast link release) or sends *NotificationMessageSidelink* message to the connected L2 U2N Remote UE(s) in accordance with 5.8.9.10.

The RRC_INACTIVE UE shall continue to monitor paging while the timer T302 is running.

NOTE: If timer T331 is running, the UE continues to perform idle/inactive measurements according to 5.7.8.

## 5.4 Inter-RAT mobility

### 5.4.1 Introduction

Network controlled inter-RAT mobility between NR and E-UTRA, where E-UTRA can be connected to either EPC or 5GC, and from NR to UTRA-FDD is supported.

### 5.4.2 Handover to NR

#### 5.4.2.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: RRCReconfiguration (sent via other RAT)[ac];
u->n: RRCReconfigurationComplete [ac];
|||;
~~~

Figure 5.4.2.1-1: Handover to NR, successful

The purpose of this procedure is to, under the control of the network, transfer a connection between the UE and another Radio Access Network (e.g. E-UTRAN) to NR.

The handover to NR procedure applies when SRBs, possibly in combination with DRBs, are established in another RAT. Handover from E-UTRA to NR applies only after integrity has been activated in E-UTRA.

#### 5.4.2.2 Initiation

The RAN using another RAT initiates the handover to NR procedure, in accordance with the specifications applicable for the other RAT, by sending the *RRCReconfiguration* message via the radio access technology from which the inter-RAT handover is performed.

The network applies the procedure as follows:

- to activate ciphering, possibly using NULL algorithm, if not yet activated in the other RAT;

- to re-establish SRBs and one or more DRBs;

#### 5.4.2.3 Reception of the *RRCReconfiguration* by the UE

The UE shall:

1\> apply the default L1 parameter values as specified in corresponding physical layer specifications except for the parameters for which values are provided in *SIB1*;

1\> apply the default MAC Cell Group configuration as specified in 9.2.2;

1\> perform RRC reconfiguration procedure as specified in 5.3.5;

NOTE: If the UE is connected to 5GC of the source E-UTRA cell, the delta configuration for PDCP and SDAP can be used for intra-system inter-RAT handover. For other cases, source RAT configuration is not considered when the UE applies the reconfiguration message of target RAT.

Editor\'s Note: FFS whether to capture the agreement that all LTE QoE configurations are released at handover to NR in LTE specification or NR specification.

### 5.4.3 Mobility from NR

#### 5.4.3.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: MobilityFromNRCommand[ac];
|||;
~~~

Figure 5.4.3.1-1: Mobility from NR, successful

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: MobilityFromNRCommand[ac];
u<=>n: RRC connection re-establishment[au];
|||;
~~~

Figure 5.4.3.1-2: Mobility from NR, failure

The purpose of this procedure is to move a UE in RRC_CONNECTED to a cell using other RAT, e.g. E-UTRA, UTRA-FDD. The mobility from NR procedure covers the following type of mobility:

- handover, i.e. the *MobilityFromNRCommand* message includes radio resources that have been allocated for the UE in the target cell;

#### 5.4.3.2 Initiation

The network initiates the mobility from NR procedure to a UE in RRC_CONNECTED, possibly in response to a *MeasurementReport* or an *MCGFailureInformation* message, by sending a *MobilityFromNRCommand* message. The network applies the procedure as follows:

- the procedure is initiated only when AS security has been activated, and SRB2 with at least one DRB or multicast MRB are setup and not suspended;

- the procedure is not initiated if any DAPS bearer is configured;

#### 5.4.3.3 Reception of the *MobilityFromNRCommand* by the UE

The UE shall:

1\> stop timer T310, if running;

1\> stop timer T312, if running;

1\> if T316 is running:

2\> stop timer T316;

2\> if the UE supports RLF-Report for fast MCG recovery procedure:

3\> set the *elapsedTimeT316* in the *VarRLF-Report* to the value of the elapsed time of the timer T316;

3\> set the *pSCellId* to the global cell identity of the PSCell, if available, otherwise to the physical cell identity and carrier frequency of the PSCell;

2\> else:

3\> clear the information included in *VarRLF-Report*, if any;

1\> if T390 is running:

2\> stop timer T390 for all access categories;

2\> perform the actions as specified in 5.3.14.4;

1\> inform upper layers about the release of all application layer measurement configurations;

1\> discard any application layer measurement reports which were not yet submitted to lower layers for transmission;

1\> if the *targetRAT-Type* is set to *eutra*:

2\> consider inter-RAT mobility as initiated towards E-UTRA;

2\> forward the *nas-SecurityParamFromNR* to the upper layers, if included;

1\> else if the *targetRAT-Type* is set to *utra-fdd*:

2\> consider inter-RAT mobility as initiated towards UTRA-FDD;

2\> forward the *nas-SecurityParamFromNR* to the upper layers, if included;

1\> if *successHO-Config* is configured:

2\> consider itself to be configured to provide the successful handover information for inter-RAT handover in accordance with 5.7.10.6;

1\> else:

2\> consider itself not to be configured to provide the successful handover information for inter-RAT handover.

1\> access the target cell indicated in the inter-RAT message in accordance with the specifications of the target RAT.

#### 5.4.3.4 Successful completion of the mobility from NR

Upon successfully completing the handover, at the source side the UE shall:

1\> reset MAC;

1\> stop all timers that are running except T325, T330 and T400;

1\> release *ran-NotificationAreaInfo*, if stored;

1\> release the AS security context including the K~RRCenc~ key, the K~RRCint~ key, the K~UPint~ key and the K~UPenc~ key, if stored;

1\> release all radio resources, including release of the RLC entity and the MAC configuration;

1\> release the associated PDCP entity and SDAP entity for all established RBs;

NOTE : PDCP and SDAP configured by the source RAT prior to the handover that are reconfigured and re-used by target RAT when delta signalling (i.e., during inter-RAT intra-system handover when *fullConfig* is not present) is used, are not released as part of this procedure.

1\> if the UE was configured with *successHO-Config* when connected to the source PCell and the *targetRAT-Type* is set to *eutra*:

2\> perform the actions for the successful handover report determination as specified in clause 5.7.10.6.

1\> if the *targetRAT-Type* is set to *eutra* and the *nas-SecurityParamFromNR* is included: or

1\> if the *targetRAT-Type* is set to *utra-fdd*:

2\> indicate the release of the RRC connection to upper layers together with the release cause \'other\'.

#### 5.4.3.5 Mobility from NR failure

The UE shall:

1\> if the UE does not succeed in establishing the connection to the target radio access technology:

2\> if the *targetRAT-Type* in the received *MobilityFromNRCommand* is set to *eutra* and the UE supports Radio Link Failure Report for Inter-RAT MRO EUTRA:

3\> store handover failure information in *VarRLF-Report* according to 5.3.10.5;

2\> if *voiceFallbackIndication* is included in the *MobilityFromNRCommand* message; or

2\> if the mobility from NR procedure is for emergency services fallback as specified in TS 23.502 \[43\]:

3\> attempt to select an E-UTRA cell:

4\> if a suitable E-UTRA cell is selected; or

4\> if no suitable E-UTRA cell is available and an acceptable E-UTRA cell supporting emergency call is selected when the UE has an ongoing emergency call:

5\> perform the actions upon going to RRC_IDLE as specified in 5.3.11, with release cause \'RRC connection failure\';

4\> else:

5\> revert back to the configuration used in the source PCell;

5\> initiate the connection re-establishment procedure as specified in clause 5.3.7;

NOTE: It is left to UE implementation to determine whether the mobility from NR procedure is for emergency services fallback as specified in TS 23.502 \[43\].

2\> else:

3\> revert back to the configuration used in the source PCell;

3\> initiate the connection re-establishment procedure as specified in clause 5.3.7;

1\> else if the UE is unable to comply with any part of the configuration included in the *MobilityFromNRCommand* message; or

1\> if there is a protocol error in the inter RAT information included in the *MobilityFromNRCommand* message, causing the UE to fail the procedure according to the specifications applicable for the target RAT:

2\> if the *targetRAT-Type* in the received *MobilityFromNRCommand* is set to *eutra* and the UE supports Radio Link Failure Report for Inter-RAT MRO EUTRA:

3\> store handover failure information in *VarRLF-Report* according to 5.3.10.5;

2\> revert back to the configuration used in the source PCell;

2\> initiate the connection re-establishment procedure as specified in clause 5.3.7.

## 5.5 Measurements

### 5.5.1 Introduction

The network may configure an RRC_CONNECTED UE to perform measurements. The network may configure the UE to report them in accordance with the measurement configuration or perform conditional reconfiguration evaluation in accordance with the conditional reconfiguration. The measurement configuration is provided by means of dedicated signalling i.e. using the *RRCReconfiguration* or *RRCResume.*

The network may configure the UE to perform the following types of measurements:

- NR measurements;

- Inter-RAT measurements of E-UTRA frequencies;

- Inter-RAT measurements of UTRA-FDD frequencies;

- NR sidelink measurements of L2 U2N Relay UEs.

The network may configure the UE to report the following measurement information based on SS/PBCH block(s):

- Measurement results per SS/PBCH block;

- Measurement results per cell based on SS/PBCH block(s);

- SS/PBCH block(s) indexes.

The network may configure the UE to report the following measurement information based on CSI-RS resources:

- Measurement results per CSI-RS resource;

- Measurement results per cell based on CSI-RS resource(s);

- CSI-RS resource measurement identifiers.

The network may configure the UE to perform the following types of measurements for NR sidelink and V2X sidelink:

- CBR measurements.

The network may configure the UE to report the following CLI measurement information based on SRS resources:

- Measurement results per SRS resource;

- SRS resource(s) indexes.

The network may configure the UE to report the following CLI measurement information based on CLI-RSSI resources:

- Measurement results per CLI-RSSI resource;

- CLI-RSSI resource(s) indexes.

The network may configure the UE to report the following Rx-Tx time difference measurement information based on CSI-RS for tracking or PRS:

- UE Rx-Tx time difference measurement result.

The measurement configuration includes the following parameters:

**1. Measurement objects:** A list of objects on which the UE shall perform the measurements.

- For intra-frequency and inter-frequency measurements a measurement object indicates the frequency/time location and subcarrier spacing of reference signals to be measured. Associated with this measurement object, the network may configure a list of cell specific offsets, a list of \'exclude-listed\' cells and a list of \'allow-listed\' cells. Exclude-listed cells are not applicable in event evaluation or measurement reporting. Allow-listed cells are the only ones applicable in event evaluation or measurement reporting.

- The *measObjectId* of the MO which corresponds to each serving cell is indicated by *servingCellMO* within the serving cell configuration.

- For inter-RAT E-UTRA measurements a measurement object is a single E-UTRA carrier frequency. Associated with this E-UTRA carrier frequency, the network can configure a list of cell specific offsets and a list of \'exclude-listed\' cells. Exclude-listed cells are not applicable in event evaluation or measurement reporting.

- For inter-RAT UTRA-FDD measurements a measurement object is a set of cells on a single UTRA-FDD carrier frequency.

- For NR sidelink measurements of L2 U2N Relay UEs, a measurement object is a single NR sidelink frequency to be measured.

- For CBR measurement of NR sidelink communication, a measurement object is a set of transmission resource pool(s) on a single carrier frequency for NR sidelink communication.

- For CBR measurement of NR sidelink discovery, a measurement object is a set of discovery dedicated resource pool(s) or transmission resource pool(s) also used for NR sidelink discovery on a single carrier frequency for NR sidelink discovery.

- For CBR measurement of NR sidelink positioning, a measurement object is a set of positioning dedicated resource pool(s) or transmission resource pool(s) also used for NR sidelink positioning on a single carrier frequency for NR sidelink positioning.

- For CLI measurements a measurement object indicates the frequency/time location of SRS resources and/or CLI-RSSI resources, and subcarrier spacing of SRS resources to be measured.

**2. Reporting configurations:** A list of reporting configurations where there can be one or multiple reporting configurations per measurement object. Each measurement reporting configuration consists of the following:

- Reporting criterion: The criterion that triggers the UE to send a measurement report. This can either be periodical or a single event description.

- RS type: The RS that the UE uses for beam and cell measurement results (SS/PBCH block or CSI-RS).

- Reporting format: The quantities per cell and per beam that the UE includes in the measurement report (e.g. RSRP) and other associated information such as the maximum number of cells and the maximum number beams per cell to report.

In case of conditional reconfiguration, each configuration consists of the following:

- Execution criteria: The criteria the UE uses for conditional reconfiguration execution.

- RS type: The RS that the UE uses for obtaining beam and cell measurement results (SS/PBCH block-based or CSI-RS-based), used for evaluating conditional reconfiguration execution condition.

**3. Measurement identities:** For measurement reporting, a list of measurement identities where each measurement identity links one measurement object with one reporting configuration. By configuring multiple measurement identities, it is possible to link more than one measurement object to the same reporting configuration, as well as to link more than one reporting configuration to the same measurement object. The measurement identity is also included in the measurement report that triggered the reporting, serving as a reference to the network. For conditional reconfiguration triggering, one measurement identity links to exactly one conditional reconfiguration trigger configuration. And up to 2 measurement identities can be linked to one conditional reconfiguration execution condition.

**4. Quantity configurations:** The quantity configuration defines the measurement filtering configuration used for all event evaluation and related reporting, and for periodical reporting of that measurement. For NR measurements, the network may configure up to 2 quantity configurations with a reference in the NR measurement object to the configuration that is to be used. In each configuration, different filter coefficients can be configured for different measurement quantities, for different RS types, and for measurements per cell and per beam.

**5. Measurement gaps:** Periods that the UE may use to perform measurements.

**6. Effective measurement window:** Periods that the UE may use to perform inter RAT measurements.

A UE in RRC_CONNECTED maintains a measurement object list, a reporting configuration list, and a measurement identities list according to signalling and procedures in this specification. The measurement object list possibly includes NR measurement object(s), CLI measurement object(s), inter-RAT objects, and L2 U2N Relay objects. Similarly, the reporting configuration list includes NR, inter-RAT, and L2 U2N Relay reporting configurations. Any measurement object can be linked to any reporting configuration of the same RAT type. Some reporting configurations may not be linked to a measurement object. Likewise, some measurement objects may not be linked to a reporting configuration.

The measurement procedures distinguish the following types of cells:

1\. The NR serving cell(s) -- these are the SpCell and one or more SCells.

2\. Listed cells -- these are cells listed within the measurement object(s).

3\. Detected cells -- these are cells that are not listed within the measurement object(s) but are detected by the UE on the SSB frequency(ies) and subcarrier spacing(s) indicated by the measurement object(s).

For NR measurement object(s), the UE measures and reports on the serving cell(s)/serving Relay UE (for L2 U2N Remote UE), listed cells and/or detected cells. For inter-RAT measurements object(s) of E-UTRA, the UE measures and reports on listed cells and detected cells and, for RSSI and channel occupancy measurements, the UE measures and reports on the configured resources on the indicated frequency. For inter-RAT measurements object(s) of UTRA-FDD, the UE measures and reports on listed cells. For CLI measurement object(s), the UE measures and reports on configured measurement resources (i.e. SRS resources and/or CLI-RSSI resources). For L2 U2N Relay object(s), the UE measures and reports on the serving NR cell(s), as well as the discovered L2 U2N Relay UEs.

Whenever the procedural specification, other than contained in clause 5.5.2, refers to a field it concerns a field included in the *VarMeasConfig* unless explicitly stated otherwise i.e. only the measurement configuration procedure covers the direct UE action related to the received *measConfig*.

In NR-DC, the UE may receive two independent *measConfig*:

- a *measConfig*, associated with MCG, that is included in the *RRCReconfiguration* message received via SRB1; and

- a *measConfig*, associated with SCG, that is included in the *RRCReconfiguration* message received via SRB3, or, alternatively, included within a *RRCReconfiguration* message embedded in a *RRCReconfiguration* message received via SRB1.

In this case, the UE maintains two independent *VarMeasConfig* and *VarMeasReportList*, one associated with each *measConfig*, and independently performs all the procedures in clause 5.5 for each *measConfig* and the associated *VarMeasConfig* and *VarMeasReportList*, unless explicitly stated otherwise.

The configurations related to CBR measurements are only included in the *measConfig* associated with MCG.

The configurations related to Rx-Tx time difference measurement are only included in the *measConfig* associated with MCG.

### 5.5.2 Measurement configuration

#### 5.5.2.1 General

The network applies the procedure as follows:

- to ensure that, whenever the UE has a *measConfig* associated with a CG, it includes a *measObject* for the SpCell and for each NR SCell of the CG to be measured;

- to configure at most one measurement identity across all CGs using a reporting configuration with the *reportType* set to *reportCGI;*

- to configure at most one measurement identity per the node hosting PDCP entity using a reporting configuration with the *ul-DelayValueConfig;*

- to configure at most one measurement identity per the node hosting PDCP entity using a reporting configuration with the *ul-ExcessDelayConfig;*

- to ensure that, in the *measConfig* associated with a CG:

- for all SSB based measurements there is at most one measurement object with the same *ssbFrequency*;

*-* an *smtc1* included in any measurement object with the same *ssbFrequency* has the same value and that an *smtc2* included in any measurement object with the same *ssbFrequency* has the same value and that an *smtc3list* included in any measurement object with the same *ssbFrequency* has the same value and that an *smtc4list* included in any measurement object with the same *ssbFrequency* has the same value;

- to ensure that all measurement objects configured in this specification and in TS 36.331 \[10\] with the same *ssbFrequency* have the same *ssbSubcarrierSpacing*;

- to ensure that, if a measurement object associated with the MCG has the same *ssbFrequency* as a measurement object associated with the SCG:

- for that *ssbFrequency*, the measurement window according to the *smtc1* configured by the MCG includes the measurement window according to the *smtc1* configured by the SCG, or vice-versa, with an accuracy of the maximum receive timing difference specified in TS 38.133 \[14\].

- if both measurement objects are used for RSSI measurements, bits in *measurementSlots* in both objects corresponding to the same slot are set to the same value. Also, the *endSymbol* is the same in both objects.

- to ensure that, if a measurement object has the same *ssbFrequency* as a measurement object configured in TS 36.331 \[10\]:

- for that *ssbFrequency*, the measurement window according to the *smtc* configured in TS 36.331 \[10\] includes the measurement window according to the *smtc1* configured in TS 38.331, or vice-versa, with an accuracy of the maximum receive timing difference specified in TS 38.133 \[14\].

- if both measurement objects are used for RSSI measurements, bits in *measurementSlots* in both objects corresponding to the same slot are set to the same value. Also, the *endSymbol* is the same in both objects.

- when the UE is in NE-DC, NR-DC, or NR standalone, to configure at most one measurement identity across all CGs using a reporting configuration with the *reportType* set to *reportSFTD*;

For CSI-RS resources, the network applies the procedure as follows:

> \- to ensure that all CSI-RS resources configured in each measurement object have the same center frequency, (*startPRB*+floor(*nrofPRBs*/2))

- to ensure that the total number of CSI-RS resources configured in each measurement object does not exceed the maximum number specified in TS 38.214 \[19\].

The UE shall:

1\> if the received *measConfig* includes the *measObjectToRemoveList*:

2\> perform the measurement object removal procedure as specified in 5.5.2.4;

1\> if the received *measConfig* includes the *measObjectToAddModList*:

2\> perform the measurement object addition/modification procedure as specified in 5.5.2.5;

1\> if the received *measConfig* includes the *reportConfigToRemoveList*:

2\> perform the reporting configuration removal procedure as specified in 5.5.2.6;

1\> if the received *measConfig* includes the *reportConfigToAddModList*:

2\> perform the reporting configuration addition/modification procedure as specified in 5.5.2.7;

1\> if the received *measConfig* includes the *quantityConfig*:

2\> perform the quantity configuration procedure as specified in 5.5.2.8;

1\> if the received *measConfig* includes the *measIdToRemoveList*:

2\> perform the measurement identity removal procedure as specified in 5.5.2.2;

1\> if the received *measConfig* includes the *measIdToAddModList*:

2\> perform the measurement identity addition/modification procedure as specified in 5.5.2.3;

1\> if the received *measConfig* includes the *measGapConfig*:

2\> perform the measurement gap configuration procedure as specified in 5.5.2.9;

1\> if the received *measConfig* includes the *measGapSharingConfig*:

2\> perform the measurement gap sharing configuration procedure as specified in 5.5.2.11;

1\> if the received *measConfig* includes the *s-MeasureConfig*:

2\> if *s-MeasureConfig* is set to *ssb-RSRP*, set parameter *ssb-RSRP* of *s-MeasureConfig* within *VarMeasConfig* to the threshold value of the RSRP indicated by the received value of *s-MeasureConfig* which is derived as specified in 6.3.2*;*

2\> else, set parameter *csi-RSRP* of *s-MeasureConfig* within *VarMeasConfig* to the threshold value of the RSRP indicated by the received value of *s-MeasureConfig* which is derived as specified in 6.3.2.

1\> if the received *measConfig* includes the *effectiveMeasWindowConfig*:

2\> perform the effective measurement window configuration as specified in 5.5.2.12;

#### 5.5.2.2 Measurement identity removal

The UE shall:

1\> for each *measId* included in the received *measIdToRemoveList* that is part of the current UE configuration in *VarMeasConfig*:

2\> remove the entry with the matching *measId* from the *measIdList* within the *VarMeasConfig*;

2\> remove the measurement reporting entry for this *measId* from the *VarMeasReportList*, if included;

2\> stop the periodical reporting timer or timer T321 or timer T322, whichever one is running, and reset the associated information (e.g. *timeToTrigger*) for this *measId*.

2\> if the *reportType* is set to *reportOnActivation* in the *reportConfig* associated with this *measId*:

3\> indicate to lower layer to disable the measurement reporting for fast unknown SCell activation.

NOTE: The UE does not consider the message as erroneous if the *measIdToRemoveList* includes any *measId* value that is not part of the current UE configuration.

#### 5.5.2.3 Measurement identity addition/modification

The network applies the procedure as follows:

- configure a *measId* only if the corresponding measurement object, the corresponding reporting configuration and the corresponding quantity configuration, are configured.

The UE shall:

1\> for each *measId* included in the received *measIdToAddModList*:

2\> if an entry with the matching *measId* exists in the *measIdList* within the *VarMeasConfig*:

3\> replace the entry with the value received for this *measId*;

2\> else:

3\> add a new entry for this *measId* to the *measIdList* within the *VarMeasConfig*;

2\> remove the measurement reporting entry for this *measId* from the *VarMeasReportList*, if included;

2\> stop the periodical reporting timer or timer T321 or timer T322, whichever one is running, and reset the associated information (e.g. *timeToTrigger*) for this *measId*;

NOTE 1: If the *measId* associated with *reportConfig* for conditional reconfiguration is modified, the conditions are considered to be not fulfilled as specified in 5.3.5.13.4.

2\> if the *reportType* is set to *reportCGI* in the *reportConfig* associated with this *measId*:

3\> if the *measObject* associated with this *measId* concerns E-UTRA:

4\> if the *useAutonomousGaps* is included in the *reportConfig* associated with this *measId*:

5\> start timer T321 with the timer value set to 200 ms for this *measId*;

4\> else:

5\> start timer T321 with the timer value set to 1 second for this *measId*;

3\> if the *measObject* associated with this *measId* concerns NR:

4\> if the *measObject* associated with this *measId* concerns FR1:

5\> if the *useAutonomousGaps* is included in the *reportConfig* associated with this *measId*:

6\> if the UE is an (e)RedCap UE with 1 Rx branch

7\> start timer T321 with the timer value set to 3 seconds for this *measId*;

6\> else

7\> start timer T321 with the timer value set to 2 seconds for this *measId*;

5\> else:

6\> start timer T321 with the timer value set to 2 seconds for this *measId*;

4\> if the *measObject* associated with this *measId* concerns FR2:

5\> if the *useAutonomousGaps* is included in the *reportConfig* associated with this *measId*:

6\> if the UE is a RedCap UE with 1 Rx branch

7\> start timer T321 with the timer value set to 6 seconds for this *measId*;

6\> else

7\> start timer T321 with the timer value set to 5 seconds for this *measId*;

5\> else:

6\> start timer T321 with the timer value set to 16 seconds for this *measId*.

2\> if the *reportType* is set to *reportSFTD* in the *reportConfigNR* associated with this *measId* and the *drx-SFTD-NeighMeas* is included:

3\> if the *measObject* associated with this *measId* concerns FR1:

4\> start timer T322 with the timer value set to 3 seconds for this *measId*;

3\> if the *measObject* associated with this *measId* concerns FR2:

4\> start timer T322 with the timer value set to 24 seconds for this *measId*.

2\> if the *reportType* is set to *reportOnActivation* in the *reportConfig* associated with this *measId*:

3\> indicate to lower layer to enable the measurement reporting for fast unknown SCell activation.

#### 5.5.2.4 Measurement object removal

The UE shall:

1\> for each *measObjectId* included in the received *measObjectToRemoveList* that is part of *measObjectList* in *VarMeasConfig*:

2\> remove the entry with the matching *measObjectId* from the *measObjectList* within the *VarMeasConfig*;

2\> remove all *measId* associated with this *measObjectId* from the *measIdList* within the *VarMeasConfig*, if any;

2\> if a *measId* is removed from the *measIdList*:

3\> remove the measurement reporting entry for this *measId* from the *VarMeasReportList*, if included;

3\> stop the periodical reporting timer or timer T321 or timer T322, whichever is running, and reset the associated information (e.g. *timeToTrigger*) for this *measId*.

NOTE: The UE does not consider the message as erroneous if the *measObjectToRemoveList* includes any *measObjectId* value that is not part of the current UE configuration.

#### 5.5.2.5 Measurement object addition/modification

The UE shall:

1\> for each *measObjectId* included in the received *measObjectToAddModList*:

2\> if an entry with the matching *measObjectId* exists in the *measObjectList* within the *VarMeasConfig*, for this entry:

3\> reconfigure the entry with the value received for this *measObject*, except for the fields *cellsToAddModList*, *excludedCellsToAddModList*, *allowedCellsToAddModList*, *cellsToRemoveList*, *excludedCellsToRemoveList*, *allowedCellsToRemoveList*, *tx-PoolMeasToRemoveList*, *tx-PoolMeasToAddModList*, *ssb-PositionQCL-CellsToRemoveList*, *ssb-PositionQCL-CellsToAddModList, cca-CellsToRemoveList*, and *cca-CellsToAddModList*;

3\> if the received *measObject* includes the *cellsToRemoveList*:

4\> for each *physCellId* included in the *cellsToRemoveList*:

5\> remove the entry with the matching *physCellId* from the *cellsToAddModList*;

3\> if the received *measObject* includes the *cellsToAddModList*:

4\> for each *physCellId* value included in the *cellsToAddModList*:

5\> if an entry with the matching *physCellId* exists in the *cellsToAddModList*:

6\> replace the entry with the value received for this *physCellId*;

5\> else:

6\> add a new entry for the received *physCellId* to the *cellsToAddModList*;

3\> if the received *measObject* includes the *excludedCellsToRemoveList*:

4\> for each *pci-RangeIndex* included in the *excludedCellsToRemoveList*:

5\> remove the entry with the matching *pci-RangeIndex* from the *excludedCellsToAddModList*;

NOTE 1: For each *pci-RangeIndex* included in the *excludedCellsToRemoveList* that concerns overlapping ranges of cells, a cell is removed from the exclude-list of cells only if all PCI ranges containing it are removed.

3\> if the received *measObject* includes the *excludedCellsToAddModList*:

4\> for each *pci-RangeIndex* included in the *excludedCellsToAddModList*:

5\> if an entry with the matching *pci-RangeIndex* is included in the *excludedCellsToAddModList*:

6\> replace the entry with the value received for this *pci-RangeIndex*;

5\> else:

6\> add a new entry for the received *pci-RangeIndex* to the *excludedCellsToAddModList*;

3\> if the received *measObject* includes the *allowedCellsToRemoveList*:

4\> for each *pci-RangeIndex* included in the *allowedCellsToRemoveList*:

5\> remove the entry with the matching *pci-RangeIndex* from the *allowedCellsToAddModList*;

NOTE2: For each *pci-RangeIndex* included in the *allowedCellsToRemoveList* that concerns overlapping ranges of cells, a cell is removed from the allow-list of cells only if all PCI ranges containing it are removed.

3\> if the received *measObject* includes the *allowedCellsToAddModList*:

4\> for each *pci-RangeIndex* included in the *allowedCellsToAddModList*:

5\> if an entry with the matching *pci-RangeIndex* is included in the *allowedCellsToAddModList*:

6\> replace the entry with the value received for this *pci-RangeIndex*;

5\> else:

6\> add a new entry for the received *pci-RangeIndex* to the *allowedCellsToAddModList*

3\> for each *measId* associated with this *measObjectId* in the *measIdList* within the *VarMeasConfig*, if any:

4\> if the UE does not support Uplink PDCP delay measurements upon MO update; or

4\> if the UE supports Uplink PDCP delay measurements upon MO update and if *ul-DelayValueConfig* or *ul-ExcessDelayConfig* is not configured for the associated *reportConfig*:

5\> remove the measurement reporting entry for this *measId* from the *VarMeasReportList*, if included;

5\> stop the periodical reporting timer or timer T321 or timer T322, whichever one is running, and reset the associated information (e.g. *timeToTrigger*) for this *measId*;

3\> if the received *measObject* includes the *tx-PoolMeasToRemoveList*:

4\> for each transmission resource pool indicated in *tx-PoolMeasToRemoveList*:

5\> remove the entry with the matching identity of the transmission resource pool from the *tx-PoolMeasToAddModList*;

3\> if the received *measObject* includes the *tx-PoolMeasToAddModList*:

4\> for each transmission resource pool indicated in *tx-PoolMeasToAddModList*:

5\> if an entry with the matching identity of the transmission resource pool exists in the *tx-PoolMeasToAddModList*:

6\> replace the entry with the value received for this transmission resource pool;

5\> else:

6\> add a new entry for the received identity of the transmission resource pool to the *tx-PoolMeasToAddModList*;

3\> if the received *measObject* includes the *ssb-PositionQCL-CellsToRemoveList*:

4\> for each *physCellId* included in the *ssb-PositionQCL-CellsToRemoveList*:

5\> remove the entry with the matching *physCellId* from the *ssb-PositionQCL-CellsToAddModList*;

3\> if the received *measObject* includes the *ssb-PositionQCL-CellsToAddModList*:

4\> for each *physCellId* included in the *ssb-PositionQCL-CellsToAddModList*:

5\> if an entry with the matching *physCellId* exists in the *ssb-PositionQCL-CellsToAddModList*:

6\> replace the entry with the value received for this *physCellId*;

5\> else:

6\> add a new entry for the received *physCellId* to the *ssb-PositionQCL-CellsToAddModList*;

3\> if the received *measObject* includes the *cca-CellsToRemoveList*:

4\> for each *physCellId* included in the *cca-CellsToRemoveList*:

5\> remove the entry with the matching *physCellId* from the *cca-CellsToAddModList*;

3\> if the received *measObject* includes the *cca-CellsToAddModList*:

4\> for each *physCellId* included in the *cca-CellsToAddModList*:

5\> if an entry with the matching *physCellId* exists in the *cca-CellsToAddModList*:

6\> replace the entry with the value received for this *physCellId*;

5\> else:

6\> add a new entry for the received *physCellId* to the *cca-CellsToAddModList*;

2\> else:

3\> add a new entry for the received *measObject* to the *measObjectList* within *VarMeasConfig*.

#### 5.5.2.6 Reporting configuration removal

The UE shall:

1\> for each *reportConfigId* included in the received *reportConfigToRemoveList* that is part of the current UE configuration in *VarMeasConfig*:

2\> remove the entry with the matching *reportConfigId* from the *reportConfigList* within the *VarMeasConfig*;

2\> remove all *measId* associated with the *reportConfigId* from the *measIdList* within the *VarMeasConfig*, if any;

2\> if a *measId* is removed from the *measIdList*:

3\> remove the measurement reporting entry for this *measId* from the *VarMeasReportList*, if included;

3\> stop the periodical reporting timer or timer T321 or timer T322, whichever one is running, and reset the associated information (e.g. *timeToTrigger*) for this *measId*.

NOTE: The UE does not consider the message as erroneous if the *reportConfigToRemoveList* includes any *reportConfigId* value that is not part of the current UE configuration.

#### 5.5.2.7 Reporting configuration addition/modification

The UE shall:

1\> for each *reportConfigId* included in the received *reportConfigToAddModList*:

2\> if an entry with the matching *reportConfigId* exists in the *reportConfigList* within the *VarMeasConfig*, for this entry:

3\> reconfigure the entry with the value received for this *reportConfig*;

3\> for each *measId* associated with this *reportConfigId* included in the *measIdList* within the *VarMeasConfig*, if any:

4\> remove the measurement reporting entry for this *measId* from the *VarMeasReportList*, if included;

4\> stop the periodical reporting timer or timer T321 or timer T322, whichever one is running, and reset the associated information (e.g. *timeToTrigger*) for this *measId*;

2\> else:

3\> add a new entry for the received *reportConfig* to the *reportConfigList* within the *VarMeasConfig*.

#### 5.5.2.8 Quantity configuration

The UE shall:

1\> for each RAT for which the received *quantityConfig* includes parameter(s):

2\> set the corresponding parameter(s) in *quantityConfig* within *VarMeasConfig* to the value of the received *quantityConfig* parameter(s);

1\> for each *measId* included in the *measIdList* within *VarMeasConfig*:

2\> remove the measurement reporting entry for this *measId* from the *VarMeasReportList*, if included;

2\> stop the periodical reporting timer or timer T321 or timer T322, whichever one is running, and reset the associated information (e.g. *timeToTrigger*) for this *measId*.

#### 5.5.2.9 Measurement gap configuration

The UE shall:

1\> if *gapFR1* is set to *setup*:

2\> if an FR1 measurement gap configuration configured by *gapFR1* is already setup, release the FR1 measurement gap configuration;

2\> setup the FR1 measurement gap configuration indicated by the *gapFR1* in accordance with the received *gapOffset*, i.e., the first subframe of each gap occurs at an SFN and subframe meeting the following condition:

SFN mod *T* = FLOOR(*gapOffset*/10);

subframe = *gapOffset* mod 10;

with *T* = MGRP/10 as defined in TS 38.133 \[14\];

2\> apply the specified timing advance *mgta* to the gap occurrences calculated above (i.e. the UE starts the measurement *mgta* ms before the gap subframe occurrences);

1\> else if *gapFR1* is set to *release*:

2\> release the FR1 measurement gap configuration configured by *gapFR1*;

1\> if *gapFR2* is set to *setup*:

2\> if an FR2 measurement gap configuration configured by *gapFR2* is already setup, release the FR2 measurement gap configuration;

2\> setup the FR2 measurement gap configuration indicated by the *gapFR2* in accordance with the received *gapOffset*, i.e., the first subframe of each gap occurs at an SFN and subframe meeting the following condition:

SFN mod *T* = FLOOR(*gapOffset*/10);

subframe = *gapOffset* mod 10;

with *T* = MGRP/10 as defined in TS 38.133 \[14\];

2\> apply the specified timing advance *mgta* to the gap occurrences calculated above (i.e. the UE starts the measurement *mgta* ms before the gap subframe occurrences);

1\> else if *gapFR2* is set to *release*:

2\> release the FR2 measurement gap configuration configured by *gapFR2*;

1\> if *gapUE* is set to *setup*:

2\> if a per UE measurement gap configuration configured by *gapUE* is already setup, release the per UE measurement gap configuration;

2\> setup the per UE measurement gap configuration indicated by the *gapUE* in accordance with the received *gapOffset*, i.e., the first subframe of each gap occurs at an SFN and subframe meeting the following condition:

SFN mod *T* = FLOOR(*gapOffset*/10);

subframe = *gapOffset* mod 10;

with *T* = MGRP/10 as defined in TS 38.133 \[14\];

2\> apply the specified timing advance *mgta* to the gap occurrences calculated above (i.e. the UE starts the measurement *mgta* ms before the gap subframe occurrences);

1\> else if *gapUE* is set to *release*:

2\> release the per UE measurement gap configuration configured by *gapUE*.

1\> for each *measGapId* included in the received *gapToReleaseList*:

2\> release the measurement gap configuration associated with the *measGapId*;

1\> for each *measPosPreConfigGapId* included in the received *posMeasGapPreConfigToReleaseList*:

2\> release the measurement gap configuration associated with the *measPosPreConfigGapId*;

1\> for each *GapConfig* received in *gapToAddModList*:

2\> setup measurement gap configuration indicated by the *GapConfig* in accordance with the received *gapOffset*, i.e., the first subframe of each gap occurs at an SFN and subframe meeting the following condition:

SFN mod *T* = FLOOR(*gapOffset*/10);

subframe = *gapOffset* mod 10;

with *T* = MGRP/10 as defined in TS 38.133 \[14\];

2\> apply the specified timing advance *mgta* to the gap occurrences calculated above (i.e. the UE starts the measurement *mgta* ms before the gap subframe occurrences);

2\> apply the measurement gap as per UE measurement gap, FR1 measurement gap, or FR2 measurement gap according to the *gapType* indicated by the *GapConfig*;

2\> associate the measurement gap with the *measGapId* indicated by the *GapConfig*;

2\> if *gapSharing* in the *GapConfig* is present:

3\> setup the gap sharing configuration for the measurement gap in accordance with the received *gapSharing* as defined in TS 38.133 \[14\];

2\> else:

3\> release the gap sharing configuration (if configured) for the measurement gap;

1\> for each *PosGapConfig* received in *PosMeasGapPreConfigToAddModList*:

2\> if a measurement gap configuration associated with the *measPosPreConfigGapId* indicated by the *PosGapConfig* is already setup:

3\> release the measurement gap configuration;

2\> setup measurement gap configuration indicated by the *PosGapConfig* in accordance with the received *gapOffset*, i.e., the first subframe of each gap occurs at an SFN and subframe meeting the following condition:

SFN mod *T* = FLOOR(*gapOffset*/10);

subframe = *gapOffset* mod 10;

with *T* = MGRP/10 as defined in TS 38.133 \[14\];

2\> apply the specified timing advance *mgta* to the gap occurrences calculated above (i.e. the UE starts the measurement *mgta* ms before the gap subframe occurrences);

2\> configure the measurement gap as indicated by *gapType*;

1\> for each FR1, FR2, and per UE measurement gap that is setup:

2\> if the measurement gap is configured by *GapConfig* and *preConfigInd-r17* in the corresponding *GapConfig* is present:

3\> determine whether the measurement gap is activated or not according to TS 38.133 \[14\];

2\> else if the measurement gap is configured by *PosGapConfig*:

3\> consider the measurement gap to be deactivated;

2\> else:

3\> consider the measurement gap to be activated.

NOTE 1: For FR2 gap configuration with synchronous CA, for the UE in NE-DC or NR-DC, the SFN and subframe of the serving cell indicated by the *refServCellIndicator* is used in the gap calculation. Otherwise, the SFN and subframe of a serving cell on FR2 frequency is used in the gap calculation

NOTE 2: For FR1 gap or per UE gap configuration, for the UE in NE-DC or NR-DC, the SFN and subframe of the serving cell indicated by the *refServCellIndicator* in is used in the gap calculation. Otherwise, the SFN and subframe of the PCell is used in the gap calculation.

> NOTE 3: For FR2 gap configuration with asynchronous CA, for the UE in NE-DC or NR-DC, the SFN and subframe of the serving cell indicated by the *refServCellIndicator* and *refFR2ServCellAsyncCA* is used in the gap calculation. Otherwise, the SFN and subframe of a serving cell on FR2 frequency indicated by the *refFR2ServCellAsyncCA* is used in the gap calculation

#### 5.5.2.10 Reference signal measurement timing configuration

The UE shall setup the first SS/PBCH block measurement timing configuration (SMTC) in accordance with the received *periodicityAndOffset* parameter (providing *Periodicity* and *Offset* value for the following condition) in the *smtc1* configuration. The first subframe of each SMTC occasion occurs at an SFN and subframe of the NR SpCell meeting the following condition:

SFN mod *T* = (FLOOR (*Offset*/10));

if the *Periodicity* is larger than *sf5*:

subframe = *Offset* mod 10;

else:

subframe = *Offset* or (*Offset* +5);

with *T* = CEIL(*Periodicity*/10).

If *smtc2* is present, for cells indicated in the *pci-List* parameter in *smtc2* in the same *MeasObjectNR*, the UE shall setup an additional SS/PBCH block measurement timing configuration (SMTC) in accordance with the received *periodicity* parameter in the *smtc2* configuration and use the *Offset* (derived from parameter *periodicityAndOffset*) and *duration* parameter from the *smtc1* configuration. The first subframe of each SMTC occasion occurs at an SFN and subframe of the NR SpCell meeting the above condition.

If *smtc2-LP* is present, for cells indicated in the *pci-List* parameter in *smtc2-LP* in the same frequency (for intra frequency cell reselection) or different frequency (for inter frequency cell reselection), the UE shall setup an additional SS/PBCH block measurement timing configuration (SMTC) in accordance with the received *periodicity* parameter in the *smtc2-LP* configuration and use the *Offset* (derived from parameter *periodicityAndOffset*) and *duration* parameter from the *smtc* configuration for that frequency. The first subframe of each SMTC occasion occurs at an SFN and subframe of the NR SpCell or serving cell (for cell reselection) meeting the above condition.

If *smtc3list* is present, for cells indicated in the *pci-List* parameter in each *SSB-MTC3* element of the list in the same *MeasObjectNR*, the IAB-MT shall setup an additional SS block measurement timing configuration in accordance with the received *periodicityAndOffset* parameter (using same condition as *smtc1* to identify the SFN and the subframe for SMTC occasion) in each SSB-MTC3 configuration and use the duration and *ssb-ToMeasure* parameters from each SSB-MTC3 configuration.

If *smtc4list* is present, for cells indicated in the *pci-List* parameter in each *SSB-MTC4* element of the list in the same *MeasObjectNR*, the UE shall setup an additional SS/PBCH block measurement timing configuration (SMTC) in accordance with the received *offset* parameter in each *SSB-MTC4* configuration and use the *duration* parameter and *periodicity* (derived from parameter *periodicityAndOffset*) from the *smtc1* configuration. The first subframe of each SMTC occasion occurs at an SFN and subframe of the NR SpCell meeting the above condition.

On the indicated *ssbFrequency*, the UE shall not consider SS/PBCH block transmission in subframes outside the SMTC occasion for RRM measurements based on SS/PBCH blocks and for RRM measurements based on CSI-RS except for SFTD measurement (see TS 38.133 \[14\], clause 9.3.8).

#### 5.5.2.10a RSSI measurement timing configuration

The UE shall setup the RSSI measurement timing configuration (RMTC) in accordance with the received *rmtc-Periodicity* and, if configured, with *rmtc-SubframeOffset* i.e. the first symbol of each RMTC occasion occurs at first symbol of an SFN and subframe of the NR SpCell meeting the following condition:

SFN mod *T* = FLOOR(*rmtc-SubframeOffset*/10);

subframe = *rmtc-SubframeOffset* mod 10;

with *T* = *rmtc-Periodicity*/10;

On the frequency configured by *rmtc-Frequency*, the UE shall not consider RSSI measurements outside the configured RMTC occasion which lasts for *measDurationSymbols* for RSSI and channel occupancy measurements.

The UE derives the RSSI measurement duration from a combination of *measDurationSymbols* and *ref-SCS-CP*. At least for RSSI measurement confined within the active DL BWP, the UE performs RSSI measurement using the numerology of the active DL BWP during the derived measurement duration. Otherwise, the numerology used by the UE for measurements is up to UE implementation. If configured, the UE performs RSSI measurements on a bandwidth in accordance with the received *rmtc-Bandwidth*. If configured, the UE performs RSSI measurements according to the TCI state configured by *tci-StateId* in the reference BWP configured by *ref-BWPId* of the reference serving cell configured by *ref-ServCellId* (see TS 38.133 \[14\], clause 9.2A.7 and clause 9.3A.8).If the UE has no serving cell in FR2-2 and configured with inter-frequency RSSI measurement in FR2-2, it is up to the UE implementation how to determine the spatial domain filter for the inter-frequency RSSI measurement in FR2-2.

#### 5.5.2.11 Measurement gap sharing configuration

The UE shall:

1\> if *gapSharingFR1* is set to *setup*:

2\> if an FR1 measurement gap sharing configuration configured by *gapSharingFR1* is already setup:

3\> release the FR1 measurement gap sharing configuration configured by *gapSharingFR1*;

2\> setup the FR1 measurement gap sharing configuration indicated by the *measGapSharingConfig* in accordance with the received *gapSharingFR1* as defined in TS 38.133 \[14\];

1\> else if *gapSharingFR1* is set to *release*:

2\> release the FR1 measurement gap sharing configuration configured by *gapSharingFR1*;

1\> if *gapSharingFR2* is set to *setup*:

2\> if an FR2 measurement gap sharing configuration configured by *gapSharingFR2* is already setup:

3\> release the FR2 measurement gap sharing configuration configured by *gapSharingFR2*;

2\> setup the FR2 measurement gap sharing configuration indicated by the *measGapSharingConfig* in accordance with the received *gapSharingFR2* as defined in TS 38.133 \[14\];

1\> else if *gapSharingFR2* is set to *release*:

2\> release the FR2 measurement gap sharing configuration configured by *gapSharingFR2*.

1\> if *gapSharingUE* is set to *setup*:

2\> if a per UE measurement gap sharing configuration configured by *gapSharingUE* is already setup:

3\> release the per UE measurement gap sharing configuration configured by *gapSharingUE*;

2\> setup the per UE measurement gap sharing configuration indicated by the *measGapSharingConfig* in accordance with the received *gapSharingUE* as defined in TS 38.133 \[14\];

1\> else if *gapSharingUE* is set to *release*:

2\> release the per UE measurement gap sharing configuration configured by *gapSharingUE*.

#### 5.5.2.12 Effective measurement window configuration

The UE shall:

1\> if effectiveMeasWindowConfig is set to setup:

2\> if an effective measurement window configuration is already setup:

3\> release the effective measurement window configuration;

2\> setup an effective measurement window configuration indicated by the *effectiveMeasWindowConfig* in accordance with the received *windowOffsetPeriodicity* (providing *periodicity* and *offset* for the following condition), i.e., the first subframe of each window occurs at an SFN and subframe meeting the following condition:

SFN mod *T* = FLOOR(*offset*/10);

subframe = *offset* mod 10;

with *T* = *periodicity*/10;

1\> else if effectiveMeasWindowConfig is set to release:

2\> release the effective measurement window configuration;

NOTE: The SFN and subframe of the PCell is used in the effective measurement window calculation.

### 5.5.3 Performing measurements

#### 5.5.3.1 General

An RRC_CONNECTED UE shall derive cell measurement results by measuring one or multiple beams associated per cell as configured by the network, as described in 5.5.3.3. For all cell measurement results, except for RSSI, and CLI measurement results in RRC_CONNECTED, the UE applies the layer 3 filtering as specified in 5.5.3.2, before using the measured results for evaluation of reporting criteria, measurement reporting or the criteria to trigger conditional reconfiguration execution. For cell measurements, the network can configure RSRP, RSRQ, SINR, RSCP or EcN0 as trigger quantity. For CLI measurements, the network can configure SRS-RSRP or CLI-RSSI as trigger quantity. For cell and beam measurements, reporting quantities can be any combination of quantities (i.e. only RSRP; only RSRQ; only SINR; RSRP and RSRQ; RSRP and SINR; RSRQ and SINR; RSRP, RSRQ and SINR; only RSCP; only EcN0; RSCP and EcN0), irrespective of the trigger quantity, and for CLI measurements, reporting quantities can be either SRS-RSRP or CLI-RSSI. For conditional reconfiguration execution, the network can configure up to 2 quantities, both using same RS type. The UE does not apply the layer 3 filtering as specified in 5.5.3.2 to derive the CBR measurements. The UE does not apply the layer 3 filtering as specified in 5.5.3.2 to derive the Rx-Tx time difference measurements.s

The network may also configure the UE to report measurement information per beam (which can either be measurement results per beam with respective beam identifier(s) or only beam identifier(s)), derived as described in 5.5.3.3a. If beam measurement information is configured to be included in measurement reports, the UE applies the layer 3 beam filtering as specified in 5.5.3.2. On the other hand, the exact L1 filtering of beam measurements used to derive cell measurement results is implementation dependent.

The UE shall:

1\> whenever the UE has a *measConfig*, perform RSRP and RSRQ measurements for each serving cell for which *servingCellMO* is configured as follows:

2\> if the *reportConfig* associated with at least one *measId* included in the *measIdList* within *VarMeasConfig* contains an *rsType* set to *ssb* and *ssb-ConfigMobility* is configured in the *measObject* indicated by the *servingCellMO*:

3\> if the *reportConfig* associated with at least one *measId* included in the *measIdList* within *VarMeasConfig* contains a *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport* and contains an *rsType* set to *ssb*:

4\> derive layer 3 filtered RSRP and RSRQ per beam for the serving cell based on SS/PBCH block, as described in 5.5.3.3a;

3\> derive serving cell measurement results based on SS/PBCH block, as described in 5.5.3.3;

2\> if the *reportConfig* associated with at least one *measId* included in the *measIdList* within *VarMeasConfig* contains an *rsType* set to *csi-rs* and *CSI-RS-ResourceConfigMobility* is configured in the *measObject* indicated by the *servingCellMO*:

3\> if the *reportConfig* associated with at least one *measId* included in the *measIdList* within *VarMeasConfig* contains a *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport* and contains an *rsType* set to *csi-rs*:

4\> derive layer 3 filtered RSRP and RSRQ per beam for the serving cell based on CSI-RS, as described in 5.5.3.3a;

3\> derive serving cell measurement results based on CSI-RS, as described in 5.5.3.3;

1\> for each serving cell for which *servingCellMO* is configured, if the *reportConfig* associated with at least one *measId* included in the *measIdList* within *VarMeasConfig* contains SINR as trigger quantity and/or reporting quantity:

2\> if the *reportConfig* contains *rsType* set to *ssb* and *ssb-ConfigMobility* is configured in the *servingCellMO*:

3\> if the *reportConfig*contains a *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport*:

4\> derive layer 3 filtered SINR per beam for the serving cell based on SS/PBCH block, as described in 5.5.3.3a;

3\> derive serving cell SINR based on SS/PBCH block, as described in 5.5.3.3;

2\> if the *reportConfig* contains *rsType* set to *csi-rs* and *CSI-RS-ResourceConfigMobility* is configured in the *servingCellMO*:

3\> if the *reportConfig*contains a *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport*:

4\> derive layer 3 filtered SINR per beam for the serving cell based on CSI-RS, as described in 5.5.3.3a;

3\> derive serving cell SINR based on CSI-RS, as described in 5.5.3.3;

1\> for each *measId* included in the *measIdList* within *VarMeasConfig*:

2\> if the *reportType* for the associated *reportConfig* is set to *reportCGI* and timer T321 is running:

3\> if *useAutonomousGaps* is configured for the associated *reportConfig*:

4\> perform the corresponding measurements on the frequency and RAT indicated in the associated *measObject* using autonomous gaps as necessary;

3\> else:

4\> perform the corresponding measurements on the frequency and RAT indicated in the associated *measObject* using available idle periods;

3\> if the cell indicated by *reportCGI* field for the associated *measObject* is an NR cell and that indicated cell is broadcasting *SIB1* (see TS 38.213 \[13\], clause 13):

4\> try to acquire *SIB1* in the concerned cell;

3\> if the cell indicated by *reportCGI* field is an E-UTRA cell:

4\> try to acquire *SystemInformationBlockType1* in the concerned cell;

2\> if the *ul-DelayValueConfig* is configured for the associated *reportConfig*:

3\> ignore the *measObject;*

3\> for each of the configured DRBs*,* configure the PDCP layer to perform corresponding average UL PDCP packet delay measurement per DRB;

2\> if the *ul-ExcessDelayConfig* is configured for the associated *reportConfig*:

3\> ignore the *measObject;*

3\> for each of the configured DRBs*,* configure the PDCP layer to perform corresponding UL PDCP Excess Packet Delay delay measurement according to the configured threshold per DRB;

2\> if the *reportType* for the associated *reportConfig* is *periodical*, *eventTriggered*; or

2\> if the *reportType* for the associated *reportConfig* is *condTriggerConfig,* the *measId* is within the MCG *VarMeasConfig* and is indicated in the *condExecutionCond* or in the *condExecutionCondPSCell* associated to a *condReconfigId* in the MCG *VarConditionalReconfig* (for CHO, CPA or MN-initiated inter-SN CPC in NR-DC); or

2\> if the *reportType* for the associated *reportConfig* is *condTriggerConfig*, the *measId* is within the SCG *VarMeasConfig* and is indicated in the *condExecutionCond* associated to a *condReconfigId* in the SCG *VarConditionalReconfig* (for intra-SN CPC); or

2\> if the *reportType* for the associated *reportConfig* is *condTriggerConfig*, the *measId* is within the SCG *VarMeasConfig* and is indicated in the *condExecutionCondSCG* associated to a *condReconfigId* in the MCG *VarConditionalReconfig* (for SN-initiated inter-SN CPC in NR-DC); or

2\> if the *reportType* for the associated *reportConfig* is *condTriggerConfig*, the *measId* is within the SCG *VarMeasConfig* and is indicated in the *triggerConditionSN* associated to a *condReconfigurationId* in *VarConditionalReconfiguration* as specified in TS 36.331 \[10\] (for SN-initiated inter-SN CPC in EN-DC):

3\> if a measurement gap configuration is setup, or

3\> if the UE does not require measurement gaps to perform the concerned measurements:

4\> if *s-MeasureConfig* is not configured, or

4\> if *s-MeasureConfig* is set to *ssb-RSRP* and the NR SpCell RSRP based on SS/PBCH block, after layer 3 filtering, is lower than *ssb-RSRP,* or

4\> if *s-MeasureConfig* is set to *csi-RSRP* and the NR SpCell RSRP based on CSI-RS, after layer 3 filtering, is lower than *csi-RSRP*:

5\> if the *measObject* is associated to NR and the *rsType* is set to *csi-rs*:

6\> if reportQuantityRS-Indexes and maxNrofRS-IndexesToReport for the associated reportConfig are configured:

7\> derive layer 3 filtered beam measurements only based on CSI-RS for each measurement quantity indicated in *reportQuantityRS-Indexes*, as described in 5.5.3.3a;

6\> derive cell measurement results based on CSI-RS for the trigger quantity and each measurement quantity indicated in *reportQuantityCell* using parameters from the associated *measObject*, as described in 5.5.3.3;

5\> if the *measObject* is associated to NR and the *rsType* is set to *ssb*:

6\> if reportQuantityRS-Indexes and maxNrofRS-IndexesToReport for the associated reportConfig are configured:

7\> derive layer 3 beam measurements only based on SS/PBCH block for each measurement quantity indicated in *reportQuantityRS-Indexes*, as described in 5.5.3.3a;

6\> derive cell measurement results based on SS/PBCH block for the trigger quantity and each measurement quantity indicated in *reportQuantityCell* using parameters from the associated *measObject*, as described in 5.5.3.3;

5\> if the *measObject* is associated to E-UTRA:

6\> perform the corresponding measurements associated to neighbouring cells on the frequencies indicated in the concerned *measObject*, as described in 5.5.3.2;

5\> if the measObject is associated to UTRA-FDD:

6\> perform the corresponding measurements associated to neighbouring cells on the frequencies indicated in the concerned *measObject*, as described in 5.5.3.2;

5\> if the measObject is associated to L2 U2N Relay UE:

6\> perform the corresponding measurements associated to candidate Relay UEs on the frequencies indicated in the concerned *measObject*, as described in 5.5.3.4;

4\> if the *measRSSI-ReportConfig* is configured in the associated *reportConfig*:

5\> perform the RSSI and channel occupancy measurements on the frequency configured by *rmtc-Frequency* in the associated *measObject*;

NOTE 0: The network avoids configuring UEs supporting only CHO and/or Rel-16 CPC with measurements not referred to by any execution condition.

2\> if the *reportType* for the associated *reportConfig* is set to *reportSFTD* and the *numberOfReportsSent* as defined within the *VarMeasReportList* for this *measId* is less than one:

3\> if the *reportSFTD-Meas* is set to *true:*

4\> if the *measObject* is associated to E-UTRA:

5\> perform SFTD measurements between the PCell and the E-UTRA PSCell;

5\> if the *reportRSRP* is set to *true*;

6\> perform RSRP measurements for the E-UTRA PSCell;

4\> else if the *measObject* is associated to NR:

5\> perform SFTD measurements between the PCell and the NR PSCell;

5\> if the *reportRSRP* is set to *true*;

6\> perform RSRP measurements for the NR PSCell based on SSB;

3\> else if the *reportSFTD-NeighMeas* is included*:*

4\> if the *measObject* is associated to NR:

5\> if the *drx-SFTD-NeighMeas* is included:

6\> perform SFTD measurements between the PCell and the NR neighbouring cell(s) detected based on parameters in the associated *measObject* using available idle periods;

5\> else:

6\> perform SFTD measurements between the PCell and the NR neighbouring cell(s) detected based on parameters in the associated *measObject*;

5\> if the *reportRSRP* is set to *true*:

6\> perform RSRP measurements based on SSB for the NR neighbouring cell(s) detected based on parameters in the associated *measObject*;

2\> if the *reportType* for the associated *reportConfig* is *cli-Periodical* or *cli-EventTriggered*:

3\> perform the corresponding measurements associated to CLI measurement resources indicated in the concerned *measObjectCLI*;

2\> perform the evaluation of reporting criteria as specified in 5.5.4, except if *reportConfig* is *condTriggerConfig*.

The UE acting as a L2 U2N Remote UE whenever configured with *measConfig* shall:

1\> perform the corresponding measurements associated to the serving L2 U2N Relay UE, as described in 5.5.3.4;

NOTE 1: The evaluation of conditional reconfiguration execution criteria is specified in 5.3.5.13.

The UE capable of Rx-Tx time difference measurement when configured with *measObjectRxTxDiff* shall:

1\> perform the corresponding Rx-Tx time difference measurements associated with downlink reference signals indicated in the concerned *measObjectRxTxDiff*.

The UE capable of CBR measurement when configured to transmit NR sidelink communication/discovery/positioning shall:

1\> If the frequency used for NR sidelink communication/discovery/positioning is included in *sl-FreqInfoToAddModList*/*sl-FreqInfoToAddModListExt* in *sl-ConfigDedicatedNR* within *RRCReconfiguration* message or included in *sl-ConfigCommonNR* within *SIB12* or included in *sl-PosConfigCommonNR* within *SIB23*:

2\> if the UE is in RRC_IDLE or in RRC_INACTIVE:

3\> if configured with NR sidelink communication and the cell chosen for NR sidelink communication provides *SIB12* which includes *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* for the concerned frequency; or

3\> if configured with NR sidelink discovery and the cell chosen for NR sidelink discovery provides *SIB12* which includes *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* but does not include *sl-DiscTxPoolSelected* for the concerned frequency:

4\> perform CBR measurement on pool(s) in *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* for the concerned frequency in *SIB12*;

3\> if configured with NR sidelink discovery and the cell chosen for NR sidelink discovery provides *SIB12* which includes *sl-DiscTxPoolSelected* for the concerned frequency:

4\> perform CBR measurement on pools in *sl-DiscTxPoolSelected* and *sl-TxPoolExceptional* for the concerned frequency in *SIB12*;

3\> if configured with NR sidelink positioning and the cell chosen for NR sidelink positioning provides *SIB23* which includes *sl-PRS-TxPoolSelectedNormal* or *sl-PRS-TxPoolExceptional* for the concerned frequency:

4\> perform CBR measurement on pool(s) in *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* for the concerned frequency in *SIB23*;

2\> if the UE is in RRC_CONNECTED:

3\> if *tx-PoolMeasToAddModList* is included in *VarMeasConfig*:

4\> perform CBR measurements on each transmission resource pool indicated in the *tx-PoolMeasToAddModList*;

3\> if *sl-DiscTxPoolSelected*, *sl-TxPoolSelectedNormal*, *sl-TxPoolScheduling* or *sl-TxPoolExceptional* is included in *sl-ConfigDedicatedNR* for the concerned frequency within *RRCReconfiguration*:

4\> perform CBR measurement on pool(s) in *sl-DiscTxPoolSelected*, *sl-TxPoolSelectedNormal*, *sl-TxPoolScheduling* and *sl-TxPoolExceptional* if included in *sl-ConfigDedicatedNR* for the concerned frequency within *RRCReconfiguration*;

3\> else:

4\> if configured with NR sidelink communication and the cell chosen for NR sidelink communication provides *SIB12* which includes *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* for the concerned frequency; or

4\> if configured with NR sidelink discovery and the cell chosen for NR sidelink discovery provides *SIB12* which includes *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* but does not provide *sl-DiscTxPoolSelected* for the concerned frequency:

5\> perform CBR measurement on pool(s) in *sl-TxPoolSelectedNormal* or *sl-TxPoolExceptional* for the concerned frequency in *SIB12*;

4\> if configured with NR sidelink discovery and the cell chosen for NR sidelink discovery provides *SIB12* which includes *sl-DiscTxPoolSelected* for the concerned frequency:

5\> perform CBR measurement on pools in *sl-DiscTxPoolSelected* and *sl-TxPoolExceptional* for the concerned frequency in *SIB12*;

4\> if configured with NR sidelink positioning and the cell chosen for NR sidelink positioning provides *SIB23* which includes *sl-PRS-TxPoolSelectedNormal* or *sl-PRS-TxPoolExceptional* for the concerned frequency:

5\> perform CBR measurement on pool(s) in *sl-PRS-TxPoolSelectedNormal* or *sl-PRS-TxPoolExceptional* for the concerned frequency in *SIB23*

1\> else:

2\> if configured with NR sidelink communication and *sl-TxPoolSelectedNormal* is included in *SidelinkPreconfigNR* for the concerned frequency; or

2\> if configured with NR sidelink discovery and *sl-TxPoolSelectedNormal* is included in *SidelinkPreconfigNR* but *sl-DiscTxPoolSelected* is not included in *SidelinkPreconfigNR* for the concerned frequency:

3\> perform CBR measurement on pool(s) in *sl-TxPoolSelectedNormal* in *SidelinkPreconfigNR* for the concerned frequency.

2\> if configured with NR sidelink discovery and *sl-DiscTxPoolSelected* is included in *SidelinkPreconfigNR* for the concerned frequency:

> 3\> perform CBR measurement on pools in *sl-DiscTxPoolSelected* if included in *SidelinkPreconfigNR*.

2\> if configured with NR sidelink communication/positioning and *sl-PRS-TxPoolSelectedNormal* is included in *SL-PosPreconfigurationNR* for the concerned frequency:

> 3\> perform CBR measurement on pool(s) in *sl-PRS-TxPoolSelectedNormal* in *SidelinkPreconfigNR* for the concerned frequency.

NOTE 2: In case the configurations for NR sidelink communication and CBR measurement are acquired via the E-UTRA, configurations for NR sidelink communication in *SIB12*, *sl-ConfigDedicatedNR* within *RRCReconfiguration* used in this clause are provided by the configurations in *SystemInformationBlockType28*, *sl-ConfigDedicatedForNR* within *RRCConnectionReconfiguration* as specified in TS 36.331\[10\], respectively.

NOTE 3: If a UE that is configured by upper layers to transmit V2X sidelink communication is configured by NR with transmission resource pool(s) and the measurement objects concerning V2X sidelink communication (i.e. by *sl-ConfigDedicatedEUTRA-Info*), it shall perform CBR measurement as specified in clause 5.5.3 of TS 36.331 \[10\], based on the transmission resource pool(s) and the measurement object(s) concerning V2X sidelink communication configured by NR.

NOTE 4: For V2X sidelink communication, each of the CBR measurement results is associated with a resource pool, as indicated by the *poolReportId* (see TS 36.331 \[10\]), that refers to a pool as included in *sl-ConfigDedicatedEUTRA-Info* or *SIB13*.

#### 5.5.3.2 Layer 3 filtering

The UE shall:

1\> for each cell measurement quantity, each beam measurement quantity, each sidelink measurement quantity as needed in clause 5.8.10, for each CLI measurement quantity that the UE performs measurements according to 5.5.3.1, for each candidate L2 U2N Relay UE measurement quantity according to 5.5.3.4, for evaluating the detected NR sidelink U2N Relay UEs according to 5.8.15.3, for evaluating the SyncRef UE according to 5.8.5 and 5.8.6, and for evaluating the detected NR sidelink U2U Relay UEs according to 5.8.17.4:

2\> filter the measured result, before using for evaluation of reporting criteria, for measurement reporting, for U2N/U2U Relay (re)selection evaluation or for evaluating the SyncRef UE, by the following formula:

***F*~n~ = (1 -- *a*)\**F*~n-1~ + *a*\**M*~n~**

where

***M~n~*** is the latest received measurement result from the physical layer;

***F~n~*** is the updated filtered measurement result, that is used for evaluation of reporting criteria, for measurement reporting, for U2N/U2U Relay (re)selection evaluation or for evaluating the SyncRef UE;

***F~n-1~*** is the old filtered measurement result, where ***F~0~*** is set to ***M~1~*** when the first measurement result from the physical layer is received; and for *MeasObjectNR*, ***a*** = 1/2^(***ki***/4)^, where ***k~i~*** is the *filterCoefficient* for the corresponding measurement quantity of the i:th *QuantityConfigNR* in *quantityConfigNR-List*, and *i* is indicated by *quantityConfigIndex* in *MeasObjectNR*; for other measurements, ***a*** = 1/2^(***k***/4)^, where ***k*** is the *filterCoefficient* for the corresponding measurement quantity received by the *quantityConfig*; for UTRA-FDD, a = 1/2^(k/4),^ where k is the filterCoefficient for the corresponding measurement quantity received by *quantityConfigUTRA-FDD* in the *QuantityConfig*;

2\> adapt the filter such that the time characteristics of the filter are preserved at different input rates, observing that the *filterCoefficient k* assumes a sample rate equal to X ms; The value of X is equivalent to one intra-frequency L1 measurement period as defined in TS 38.133 \[14\] assuming non-DRX operation, and depends on frequency range.

NOTE 1: If ***k*** is set to 0, no layer 3 filtering is applicable.

NOTE 2: The filtering is performed in the same domain as used for evaluation of reporting criteria, for measurement reporting, for U2N Relay (re)selection evaluation or for evaluating the SyncRef UE, i.e., logarithmic filtering for logarithmic measurements.

NOTE 3: The filter input rate is implementation dependent, to fulfil the performance requirements set in TS 38.133 \[14\]. For further details about the physical layer measurements, see TS 38.133 \[14\].

NOTE 4: For CLI-RSSI measurement, it is up to UE implementation whether to reset filtering upon BWP switch.

NOTE 5: For SSB measurements when multiple altitude range-based *ssb-ToMeasure* are configured, it is up to UE implementation whether to reset filtering upon entering a different altitude range.

#### 5.5.3.3 Derivation of cell measurement results

The network may configure the UE in RRC_CONNECTED to derive RSRP, RSRQ and SINR measurement results per cell associated to NR measurement objects based on parameters configured in the *measObject* (e.g. maximum number of beams to be averaged and beam consolidation thresholds) and in the *reportConfig* (*rsType* to be measured, SS/PBCH block or CSI-RS).

The network may configure the UE in RRC_IDLE or in RRC_INACTIVE to derive RSRP and RSRQ measurement results per cell associated to NR carriers based on parameters configured in *measIdleCarrierListNR* within *VarMeasIdleConfig* for measurements performed according to 5.7.8.2a.

The UE shall:

1\> for each cell measurement quantity to be derived based on SS/PBCH block:

2\> if *nrofSS-BlocksToAverage* is not configured in the associated *measObject* in RRC_CONNECTED or in the associated entry in *measIdleCarrierListNR* within *VarMeasIdleConfig* in RRC_IDLE/RRC_INACTIVE; or

2\> if *absThreshSS-BlocksConsolidation* is not configured in the associated *measObject* in RRC_CONNECTED or in the associated entry in *measIdleCarrierListNR* within *VarMeasIdleConfig* in RRC_IDLE/RRC_INACTIVE; or

2\> if the highest beam measurement quantity value is below or equal to *absThreshSS-BlocksConsolidation*:

3\> derive each cell measurement quantity based on SS/PBCH block as the highest beam measurement quantity value, where each beam measurement quantity is described in TS 38.215 \[9\];

2\> else:

3\> derive each cell measurement quantity based on SS/PBCH block as the linear power scale average of the highest beam measurement quantity values above *absThreshSS-BlocksConsolidation* where the total number of averaged beams shall not exceed *nrofSS-BlocksToAverage*, and where each beam measurement quantity is described in TS 38.215 \[9\];

2\> if in RRC_CONNECTED, apply layer 3 cell filtering as described in 5.5.3.2;

1\> for each cell measurement quantity to be derived based on CSI-RS:

2\> consider a CSI-RS resource to be applicable for deriving cell measurements when the concerned CSI-RS resource is included in the *csi-rs-CellMobility* including the *physCellId* of the cell in the*CSI-RS-ResourceConfigMobility* in the associated *measObject*;

2\> if *nrofCSI-RS-ResourcesToAverage* in the associated *measObject* is not configured; or

2\> if *absThreshCSI-RS-Consolidation* in the associated *measObject* is not configured; or

2\> if the highest beam measurement quantity value is below or equal to *absThreshCSI-RS-Consolidation*:

3\> derive each cell measurement quantity based on applicable CSI-RS resources for the cell as the highest beam measurement quantity value, where each beam measurement quantity is described in TS 38.215 \[9\];

2\> else:

3\> derive each cell measurement quantity based on CSI-RS as the linear power scale average of the highest beam measurement quantity values above *absThreshCSI-RS-Consolidation* where the total number of averaged beams shall not exceed *nrofCSI-RS-ResourcesToAverage*;

2\> apply layer 3 cell filtering as described in 5.5.3.2.

#### 5.5.3.3a Derivation of layer 3 beam filtered measurement

The UE shall:

1\> for each layer 3 beam filtered measurement quantity to be derived based on SS/PBCH block;

2\> derive each configured beam measurement quantity based on SS/PBCH block as described in TS 38.215\[9\], and apply layer 3 beam filtering as described in 5.5.3.2;

1\> for each layer 3 beam filtered measurement quantity to be derived based on CSI-RS;

2\> derive each configured beam measurement quantity based on CSI-RS as described in TS 38.215 \[9\], and apply layer 3 beam filtering as described in 5.5.3.2.

#### 5.5.3.4 Derivation of L2 U2N Relay UE measurement results

A UE may be configured by network to derive NR sidelink measurement results of serving L2 U2N Relay UE or candidate L2 U2N Relay UEs associated to the measurement objects configured in the *measObjectRelay*.

The UE shall:

1\> for each L2 U2N Relay UE measurement quantity to be derived:

2\> derive the corresponding measurement quantity based on PSSCH/PSCCH DMRS as described in TS 38.215 \[9\];

2\> apply layer 3 filtering as described in 5.5.3.2;

### 5.5.4 Measurement report triggering

#### 5.5.4.1 General

If AS security has been activated successfully, the UE shall:

1\> for each *measId* included in the *measIdList* within *VarMeasConfig*:

2\> if the corresponding *reportConfig* includes a *reportType* set to *eventTriggered* or *periodical*:

3\> if the corresponding *measObject* concerns NR:

4\> if the corresponding *reportConfig* includes *measRSSI-ReportConfig*:

5\> consider the resource indicated by the *rmtc-Config* on the associated frequency to be applicable;

4\> if the *eventA1* or *eventA2* is configured in the corresponding *reportConfig*:

5\> consider only the serving cell to be applicable;

4\> if the *eventA3* or *eventA5* or *eventA3H1* or *eventA3H2* or *eventA5H1* or *eventA5H2* is configured in the corresponding *reportConfig*:

5\> if a serving cell is associated with a *measObjectNR* and neighbours are associated with another *measObjectNR*, consider any serving cell associated with the other *measObjectNR* to be a neighbouring cell as well;

4\> if the *eventX2* is configured in the corresponding *reportConfig*:

5\> consider only the serving L2 U2N Relay UE to be applicable;

4\> if corresponding *reportConfig* includes *reportType* set to *periodical*; or

4\> for measurement events other than *eventA1,* *eventA2, eventD1*, *eventX2*, *eventH1* or *eventH2*:

5\> if *useAllowedCellList* is set to *true*:

6\> consider any neighbouring cell detected based on parameters in the associated *measObjectNR* to be applicable when the concerned cell is included in the *allowedCellsToAddModList* defined within the *VarMeasConfig* for this *measId*;

5\> else:

6\> consider any neighbouring cell detected based on parameters in the associated *measObjectNR* to be applicable when the concerned cell is not included in the *excludedCellsToAddModList* defined within the *VarMeasConfig* for this *measId*;

4\> if the *eventH1* or *eventH2* is configured in the corresponding *reportConfig*:

5\> for all the events of the same *eventID* for which *simulMultiTriggerSingleMeasReport* is set to *true* and the entry condition applicable for the event has been satisfied:

6\> consider only the event with the smallest value between the altitude of the UE and the corresponding altitude threshold to be applicable;

4\> else if the *eventA3H1* or *eventA3H2* or *eventA4H1* or *eventA4H2* or *eventA5H1* or *eventA5H2* is configured in the corresponding *reportConfig*:

5\> for all the events of the same type associated with the same *measObjectNR* for which *simulMultiTriggerSingleMeasReport* is set to *true* and the entry conditions applicable for the event has been satisfied:

6\> consider only the event with the smallest value between the altitude of the UE and the corresponding altitude threshold to be applicable;

3\> else if the corresponding *measObject* concerns E-UTRA:

4\> if *eventB1* or *eventB2* is configured in the corresponding *reportConfig*:

5\> consider a serving cell, if any, on the associated E-UTRA frequency as neighbour cell;

4\> consider any neighbouring cell detected on the associated frequency to be applicable when the concerned cell is not included in the *excludedCellsToAddModListEUTRAN* defined within the *VarMeasConfig* for this *measId*;

3\> else if the corresponding *measObject* concerns UTRA-FDD:

4\> if *eventB1-UTRA-FDD* or *eventB2-UTRA-FDD* is configured in the corresponding *reportConfig*; or

4\> if corresponding *reportConfig* includes *reportType* set to *periodical*:

5\> consider a neighbouring cell on the associated frequency to be applicable when the concerned cell is included in the *cellsToAddModList* defined within the *VarMeasConfig* for this *measId*;

3\> else if the corresponding *measObject* concerns L2 U2N Relay UE:

4\> if *eventY1-Relay* or *eventY2-Relay* or *eventZ1-Relay* is configured in the corresponding *reportConfig*; or

4\> if corresponding *reportConfig* includes *reportType* set to *periodical*:

5\> consider any L2 U2N Relay UE fulfilling upper layer criteria detected on the associated frequency to be applicable for this *measId*;

2\> else if the corresponding *reportConfig* includes a *reportType* set to *reportCGI*:

3\> consider the cell detected on the associated *measObject* which has a physical cell identity matching the value of the *cellForWhichToReportCGI* included in the corresponding *reportConfig* within the *VarMeasConfig* to be applicable;

2\> else if the corresponding *reportConfig* includes a *reportType* set to *reportSFTD*:

3\> if the corresponding *measObject* concerns NR:

4\> if the *reportSFTD-Meas* is set to *true*:

5\> consider the NR PSCell to be applicable;

4\> else if the *reportSFTD-NeighMeas* is included:

5\> if *cellsForWhichToReportSFTD* is configured in the corresponding *reportConfig*:

6\> consider any NR neighbouring cell detected on the associated *measObjectNR* which has a physical cell identity that is included in the *cellsForWhichToReportSFTD* to be applicable;

5\> else:

6\> consider up to 3 strongest NR neighbouring cells detected based on parameters in the associated *measObjectNR* to be applicable when the concerned cells are not included in the *excludedCellsToAddModList* defined within the *VarMeasConfig* for this *measId*;

3\> else if the corresponding *measObject* concerns E-UTRA:

4\> if the *reportSFTD-Meas* is set to *true*:

5\> consider the E-UTRA PSCell to be applicable;

2\> else if the corresponding *reportConfig* includes a *reportType* set to *cli-Periodical or cli-EventTriggered*:

3\> consider all CLI measurement resources included in the corresponding *measObject* to be applicable;

2\> else if the corresponding *reportConfig* includes a *reportType* set to *rxTxPeriodical*:

3\> consider all Rx-Tx time difference measurement resources included in the corresponding *measObject* to be applicable;

2\> if the corresponding *reportConfig* concerns the reporting for NR sidelink communication/discovery (i.e. *reportConfigNR-SL*):

3\> consider the transmission resource pools indicated by the *tx-PoolMeasToAddModList* defined within the *VarMeasConfig* for this *measId* to be applicable;

2\> if the *reportType* is set to *eventTriggered*, and if the corresponding *reportConfig* does not include *numberOfTriggeringCells*, and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable cells for all measurements after layer 3 filtering taken during *timeToTrigger* defined for this event within the *VarMeasConfig*, while the *VarMeasReportList* does not include a measurement reporting entry for this *measId* (a first cell triggers the event):

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned cell(s) in the *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> if *useT312* is set to *true* in *reportConfig* for this event:

4\> if T310 for the corresponding SpCell is running; and

4\> if T312 is not running for corresponding SpCell:

5\> start timer T312 for the corresponding SpCell with the value of T312 configured in the corresponding *measObjectNR*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> else if the *reportType* is set to *eventTriggered*, and if the corresponding *reportConfig* does not include *numberOfTriggeringCells*, and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable cells not included in the *cellsTriggeredList* for all measurements after layer 3 filtering taken during *timeToTrigger* defined for this event within the *VarMeasConfig* (a subsequent cell triggers the event):

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned cell(s) in the *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> if *useT312* is set to *true* in *reportConfig* for this event:

4\> if T310 for the corresponding SpCell is running; and

4\> if T312 is not running for corresponding SpCell:

5\> start timer T312 for the corresponding SpCell with the value of T312 configured in the corresponding *measObjectNR*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> if the *reportType* is set to *eventTriggered*, and if the corresponding *reportConfig* includes *numberOfTriggeringCells*, and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable cells for all measurements after layer 3 filtering taken during *timeToTrigger* defined for this event within the *VarMeasConfig*:

3\> if the *VarMeasReportList* does not include a measurement reporting entry for this *measId* (a first cell triggers the event):

4\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> if the number of cell(s) in the *cellsTriggeredList* is larger than or equal to *numberOfTriggeringCells*:

4\> include the concerned cell(s) in the *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> else:

4\> include the concerned cell(s) in the *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

4\> if the number of cell(s) in the *cellsTriggeredList* is larger than or equal to *numberOfTriggeringCells*:

5\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

5\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> if the *reportType* is set to *eventTriggered* and if the leaving condition applicable for this event is fulfilled for one or more of the cells included in the *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId* for all measurements after layer 3 filtering taken during *timeToTrigger* defined within the *VarMeasConfig* for this event:

3\> remove the concerned cell(s) in the *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> if *reportOnLeave* is set to *true* for the corresponding reporting configuration:

4\> if the corresponding *reportConfig* does not include *numberOfTriggeringCells*; or

4\> if the corresponding *reportConfig* includes *numberOfTriggeringCells* and a measurement report was previously sent to the network for at least one of the concerned cell(s):

5\> initiate the measurement reporting procedure, as specified in 5.5.5;

3\> if the *cellsTriggeredList* defined within the *VarMeasReportList* for this *measId* is empty:

4\> remove the measurement reporting entry within the *VarMeasReportList* for this *measId*;

4\> stop the periodical reporting timer for this *measId*, if running;

2\> if the *reportType* is set to *eventTriggered* and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable L2 U2N Relay UEs for all measurements after layer 3 filtering taken during *timeToTrigger* defined for this event within the *VarMeasConfig*, while the *VarMeasReportList* does not include a measurement reporting entry for this *measId* (a first L2 U2N Relay UE triggers the event):

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned L2 U2N Relay UE(s) in the *relaysTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> else if the *reportType* is set to *eventTriggered* and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable L2 U2N Relay UEs not included in the *relaysTriggeredList* for all measurements after layer 3 filtering taken during *timeToTrigger* defined for this event within the *VarMeasConfig* (a subsequent L2 U2N Relay UE triggers the event):

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned L2 U2N Relay UE(s) in the *relaysTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> else if the *reportType* is set to *eventTriggered* and if the leaving condition applicable for this event is fulfilled for one or more of the L2 U2N Relay UEs included in the *relaysTriggeredList* defined within the *VarMeasReportList* for this *measId* for all measurements after layer 3 filtering taken during *timeToTrigger* defined within the *VarMeasConfig* for this event:

3\> remove the concerned L2 U2N Relay UE(s) in the *relaysTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> if *reportOnLeave* is set to *true* for the corresponding reporting configuration:

4\> initiate the measurement reporting procedure, as specified in 5.5.5;

3\> if the *relaysTriggeredList* defined within the *VarMeasReportList* for this *measId* is empty:

4\> remove the measurement reporting entry within the *VarMeasReportList* for this *measId*;

4\> stop the periodical reporting timer for this *measId*, if running;

2\> else if the *reportType* is set to *eventTriggered* and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable transmission resource pools for all measurements taken during *timeToTrigger* defined for this event within the *VarMeasConfig*, while the *VarMeasReportList* does not include an measurement reporting entry for this *measId* (a first transmission resource pool triggers the event):

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned transmission resource pool(s) in the *poolsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> else if the *reportType* is set to *eventTriggered* and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable transmission resource pools not included in the *poolsTriggeredList* for all measurements taken during *timeToTrigger* defined for this event within the *VarMeasConfig* (a subsequent transmission resource pool triggers the event):

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned transmission resource pool(s) in the *poolsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> if the *reportType* is set to *eventTriggered* and if the leaving condition applicable for this event is fulfilled for one or more applicable transmission resource pools included in the *poolsTriggeredList* defined within the *VarMeasReportList* for this *measId* for all measurements taken during *timeToTrigger* defined within the *VarMeasConfig* for this event:

3\> remove the concerned transmission resource pool(s) in the *poolsTriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> if the *poolsTriggeredList* defined within the *VarMeasReportList* for this *measId* is empty:

4\> remove the measurement reporting entry within the *VarMeasReportList* for this *measId*;

4\> stop the periodical reporting timer for this *measId*, if running

2\> else if the *reportType* is set to *eventTriggered* and if the *eventId* is set to *eventD1* or *eventH1* or *eventH2* and if the entering condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled during *timeToTrigger* defined for this event within the *VarMeasConfig*, while the *VarMeasReportList* does not include a measurement reporting entry for this *measId*:

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> else if the *reportType* is set to *eventTriggered* and if the *eventId* is set to *eventD1* or *eventH1* or *eventH2* and if the leaving condition applicable for this event is fulfilled for the associated *VarMeasReport* within the *VarMeasReportList* for this *measId* during *timeToTrigger* defined within the *VarMeasConfig* for this event:

3\> if *reportOnLeave* is set to *true* for the corresponding reporting configuration:

4\> initiate the measurement reporting procedure, as specified in 5.5.5;

3\> remove the measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> stop the periodical reporting timer for this *measId*, if running;

NOTE 1: Void.

2\> if *reportType* is set to *periodical* and if a (first) measurement result is available:

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> if the corresponding *reportConfig* includes *measRSSI-ReportConfig*:

4\> initiate the measurement reporting procedure as specified in 5.5.5 immediately when RSSI sample values are reported by the physical layer after the first L1 measurement duration;

3\> else if the corresponding *reportConfig* includes the *ul-DelayValueConfig*:

4\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after a first measurement result is provided from lower layers of the associated DRB identity;

3\> else if the corresponding *reportConfig* includes the *ul-ExcessDelayConfig*:

4\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after a first measurement result is provided from lower layers of the associated DRB identity(ies) according to the configured threshold per DRB identity(ies);

3\> else if the *reportAmount* exceeds 1:

4\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after the quantity to be reported becomes available for the NR SpCell or for the serving L2 U2N Relay UE (if the UE is a L2 U2N Remote UE);

3\> else (i.e. the *reportAmount* is equal to 1):

4\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after the quantity to be reported becomes available for the NR SpCell and for the strongest cell among the applicable cells, or for the NR SpCell and for the strongest L2 U2N Relay UEs among the applicable L2 U2N Relay UEs; or initiate the measurement reporting procedure, as specified in 5.5.5, immediately after the quantity to be reported becomes available for the serving L2 U2N Relay UE and for the strongest cell among the applicable cells, or for the serving L2 U2N Relay UE and for the strongest L2 U2N Relay UEs among the applicable L2 U2N Relay UEs (if the UE is a L2 U2N Remote UE);

2\> if, in case the corresponding *reportConfig* concerns the reporting for NR sidelink communication/discovery, *reportType* is set to *periodical* and if a (first) measurement result is available:

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after the quantity to be reported becomes available for the NR SpCell and CBR measurement results become available;

2\> if the *reportType* is set to *cli-EventTriggered* and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more applicable CLI measurement resources for all measurements after layer 3 filtering taken during *timeToTrigger* defined for this event within the *VarMeasConfig*, while the *VarMeasReportList* does not include a measurement reporting entry for this *measId* (a first CLI measurement resource triggers the event):

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned CLI measurement resource(s) in the *cli-TriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> else if the *reportType* is set to *cli-EventTriggered* and if the entry condition applicable for this event, i.e. the event corresponding with the *eventId* of the corresponding *reportConfig* within *VarMeasConfig*, is fulfilled for one or more CLI measurement resources not included in the *cli-TriggeredList* for all measurements after layer 3 filtering taken during *timeToTrigger* defined for this event within the *VarMeasConfig* (a subsequent CLI measurement resource triggers the event):

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> include the concerned CLI measurement resource(s) in the *cli-TriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> if the *reportType* is set to *cli-EventTriggered* and if the leaving condition applicable for this event is fulfilled for one or more of the CLI measurement resources included in the *cli-TriggeredList* defined within the *VarMeasReportList* for this *measId* for all measurements after layer 3 filtering taken during *timeToTrigger* defined within the *VarMeasConfig* for this event:

3\> remove the concerned CLI measurement resource(s) in the *cli-TriggeredList* defined within the *VarMeasReportList* for this *measId*;

3\> if *reportOnLeave* is set to *true* for the corresponding reporting configuration:

4\> initiate the measurement reporting procedure, as specified in 5.5.5;

3\> if the *cli-TriggeredList* defined within the *VarMeasReportList* for this *measId* is empty:

4\> remove the measurement reporting entry within the *VarMeasReportList* for this *measId*;

4\> stop the periodical reporting timer for this measId, if running;

2\> if *reportType* is set to *cli-Periodical* and if a (first) measurement result is available:

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after the quantity to be reported becomes available for at least one CLI measurement resource;

2\> if *reportType* is set to *rxTxPeriodical* and if a (first) measurement result is available:

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> upon expiry of the periodical reporting timer for this *measId*:

3\> initiate the measurement reporting procedure, as specified in 5.5.5.

2\> if the corresponding *reportConfig* includes a *reportType* is set to *reportSFTD*:

3\> if the corresponding *measObject* concerns NR:

4\> if the *drx-SFTD-NeighMeas* is included:

5\> if the quantity to be reported becomes available for each requested pair of PCell and NR cell:

6\> stop timer T322;

6\> initiate the measurement reporting procedure, as specified in 5.5.5;

4\> else

5\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after the quantity to be reported becomes available for each requested pair of PCell and NR cell or the maximal measurement reporting delay as specified in TS 38.133 \[14\];

3\> else if the corresponding *measObject* concerns E-UTRA:

4\> initiate the measurement reporting procedure, as specified in 5.5.5, immediately after the quantity to be reported becomes available for the pair of PCell and E-UTRA PSCell or the maximal measurement reporting delay as specified in TS 38.133 \[14\];

2\> if *reportType* is set to *reportCGI*:

3\> if the UE acquired the *SIB1* or *SystemInformationBlockType1* for the requested cell; or

3\> if the UE detects that the requested NR cell is not transmitting *SIB1* (see TS 38.213 \[13\], clause 13):

4\> stop timer T321;

4\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

4\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

4\> initiate the measurement reporting procedure, as specified in 5.5.5;

2\> upon the expiry of T321 for this *measId*:

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*;

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

3\> initiate the measurement reporting procedure, as specified in 5.5.5.

2\> upon the expiry of T322 for this *measId*:

3\> initiate the measurement reporting procedure, as specified in 5.5.5.

If AS security has been activated successfully and if SCell activation(s) indication is received from lower layer, the UE shall:

1\> if *reportType* is set to *reportOnActivation* for any *measId* included in the *measIdList* within *VarMeasConfig*:

2\> if the activated SCell(s) fulfills the measurement requirement as specified in TS 38.133 \[14\]:

3\> include a measurement reporting entry within the *VarMeasReportList* for this *measId*:

3\> set the *numberOfReportsSent* defined within the *VarMeasReportList* for this *measId* to 0;

4\> initiate the measurement reporting procedure, as specified in 5.5.5.

#### 5.5.4.2 Event A1 (Serving becomes better than threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition A1-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A1-2, as specified below, is fulfilled;

1\> for this measurement, consider the NR serving cell corresponding to the associated *measObjectNR* associated with this event.

Inequality A1-1 (Entering condition)

$$Ms - Hys > Thresh$$

Inequality A1-2 (Leaving condition)

$$Ms + Hys < Thresh$$

The variables in the formula are defined as follows:

***Ms*** is the measurement result of the serving cell, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *a1-Threshold* as defined within *reportConfigNR* for this event).

***Ms*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Hys*** is expressed in dB.

***Thresh*** is expressed in the same unit as ***Ms***.

#### 5.5.4.3 Event A2 (Serving becomes worse than threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition A2-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A2-2, as specified below, is fulfilled;

1\> for this measurement, consider the serving cell indicated by the *measObjectNR* associated to this event.

NOTE: If the serving cell indicated by the *measObjectNR* associated to this event is not detectable, then the UE should consider for the value of *Ms* the lowest value of the value range of the measurement quantity as the serving cell measurement.

Inequality A2-1 (Entering condition)

$$Ms + Hys < Thresh$$

Inequality A2-2 (Leaving condition)

$$Ms - Hys > Thresh$$

The variables in the formula are defined as follows:

***Ms*** is the measurement result of the serving cell, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *a2-Threshold* as defined within *reportConfigNR* for this event).

***Ms*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Hys*** is expressed in dB.

***Thresh*** is expressed in the same unit as ***Ms***.

#### 5.5.4.4 Event A3 (Neighbour becomes offset better than SpCell)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition A3-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A3-2, as specified below, is fulfilled;

1\> use the SpCell for *Mp*, *Ofp and Ocp*.

NOTE 1: The cell(s) that triggers the event has reference signals indicated in the *measObjectNR* associated to this event which may be different from the NR SpCell *measObjectNR*.

Inequality A3-1 (Entering condition)

$$Mn + Ofn + Ocn - Hys > Mp + Ofp + Ocp + Off$$

Inequality A3-2 (Leaving condition)

$$Mn + Ofn + Ocn + Hys < Mp + Ofp + Ocp + Off$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the reference signal of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the cell specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the frequency of the neighbour cell, or *cellIndividualOffset* as defined within *reportConfigNR*), and set to zero if not configured for the neighbour cell.

***Mp*** is the measurement result of the SpCell, not taking into account any offsets.

***Ofp*** is the measurement object specific offset of the SpCell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the SpCell).

***Ocp*** is the cell specific offset of the SpCell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the SpCell), and is set to zero if not configured for the SpCell.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR* for this event).

***Off*** is the offset parameter for this event (i.e. *a3-Offset* as defined within *reportConfigNR* for this event).

***Mn, Mp*** are expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn***, ***Ocn***, ***Ofp***, ***Ocp***, ***Hys***, ***Off*** are expressed in dB.

NOTE 2: The definition of Event A3 also applies to CondEvent A3.

#### 5.5.4.5 Event A4 (Neighbour becomes better than threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition A4-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A4-2, as specified below, is fulfilled.

Inequality A4-1 (Entering condition)

$$Mn + Ofn + Ocn - Hys > Thresh$$

Inequality A4-2 (Leaving condition)

$$Mn + Ofn + Ocn + Hys < Thresh$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the neighbouring cell or the measurement result of serving PSCell (i.e., in case it is configured as candidate PSCell for CondEvent A4 evaluation) for CHO with candidate SCG(s) case, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the measurement object specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the neighbour cell, or *cellIndividualOffset* as defined within *reportConfigNR*), and set to zero if not configured for the neighbour cell.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *a4-Threshold* as defined within *reportConfigNR* for this event).

***Mn*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh*** is expressed in the same unit as ***Mn***.

NOTE: The definition of Event A4 also applies to CondEvent A4.

#### 5.5.4.6 Event A5 (SpCell becomes worse than threshold1 and neighbour becomes better than threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition A5-1 and condition A5-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A5-3 or condition A5-4, i.e. at least one of the two, as specified below, is fulfilled;

1\> use the SpCell for *Mp*.

NOTE 1: The parameters of the reference signal(s) of the cell(s) that triggers the event are indicated in the *measObjectNR* associated to the event which may be different from the *measObjectNR* of the NR SpCell.

Inequality A5-1 (Entering condition 1)

$$Mp + Hys < Thresh1$$

Inequality A5-2 (Entering condition 2)

$$Mn + Ofn + Ocn - Hys > Thresh2$$

Inequality A5-3 (Leaving condition 1)

$$Mp - Hys > Thresh1$$

Inequality A5-4 (Leaving condition 2)

$$Mn + Ofn + Ocn + Hys < Thresh2$$

The variables in the formula are defined as follows:

***Mp*** is the measurement result of the NR SpCell, not taking into account any offsets.

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the cell specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the neighbour cell, or *cellIndividualOffset* as defined within *reportConfigNR*), and set to zero if not configured for the neighbour cell.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. *a5-Threshold1* as defined within *reportConfigNR* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *a5-Threshold2* as defined within *reportConfigNR* for this event).

***Mn, Mp*** are expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh1***is expressed in the same unit as ***Mp***.

***Thresh2*** is expressed in the same unit as ***Mn***.

NOTE 2: The definition of Event A5 also applies to CondEvent A5.

#### 5.5.4.7 Event A6 (Neighbour becomes offset better than SCell)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition A6-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A6-2, as specified below, is fulfilled;

1\> for this measurement, consider the (secondary) cell corresponding to the *measObjectNR* associated to this event to be the serving cell.

NOTE: The reference signal(s) of the neighbour(s) and the reference signal(s) of the SCell are both indicated in the associated *measObjectNR*.

Inequality A6-1 (Entering condition)

$$Mn + Ocn - Hys > Ms + Ocs + Off$$

Inequality A6-2 (Leaving condition)

$$Mn + Ocn + Hys < Ms + Ocs + Off$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ocn*** is the cell specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within the associated *measObjectNR*), and set to zero if not configured for the neighbour cell.

***Ms*** is the measurement result of the serving cell, not taking into account any offsets.

***Ocs*** is the cell specific offset of the serving cell (i.e. *cellIndividualOffset* as defined within the associated *measObjectNR*, or *cellIndividualOffset* as defined within *reportConfigNR*), and is set to zero if not configured for the serving cell.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR* for this event).

***Off*** is the offset parameter for this event (i.e. *a6-Offset* as defined within *reportConfigNR* for this event).

***Mn, Ms*** are expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ocn, Ocs, Hys, Off*** are expressed in dB.

#### 5.5.4.8 Event B1 (Inter RAT neighbour becomes better than threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition B1-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition B1-2, as specified below, is fulfilled.

Inequality B1-1 (Entering condition)

$$Mn + Ofn + Ocn - Hys > Thresh$$

Inequality B1-2 (Leaving condition)

$$Mn + Ofn + Ocn + Hys < Thresh$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the inter-RAT neighbour cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the frequency of the inter-RAT neighbour cell (i.e. *eutra-Q-OffsetRange* as defined within the *measObjectEUTRA* corresponding to the frequency of the neighbour inter-RAT cell, *utra-FDD-Q-OffsetRange* as defined within the *measObjectUTRA-FDD* corresponding to the frequency of the neighbour inter-RAT cell).

***Ocn*** is the cell specific offset of the inter-RAT neighbour cell (i.e. *cellIndividualOffset* as defined within the *measObjectEUTRA* corresponding to the neighbour inter-RAT cell, or *cellIndividualOffset* as defined within *reportConfigInterRAT*), and set to zero if not configured for the neighbour cell.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigInterRAT* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *b1-ThresholdEUTRA* as defined within *reportConfigInterRAT* for this event, *b1-ThresholdUTRA-FDD* as defined for UTRA-FDD within *reportConfigInterRAT* for this event).

***Mn*** is expressed in dBm or in dB, depending on the measurement quantity of the inter-RAT neighbour cell.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh*** is expressed in the same unit as ***Mn***.

#### 5.5.4.9 Event B2 (PCell becomes worse than threshold1 and inter RAT neighbour becomes better than threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition B2-1 and condition B2-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition B2-3 or condition B2-4, i.e. at least one of the two, as specified below, is fulfilled;

Inequality B2-1 (Entering condition 1)

$$Mp + Hys < Thresh1$$

Inequality B2-2 (Entering condition 2)

$$Mn + Ofn + Ocn - Hys > Thresh2$$

Inequality B2-3 (Leaving condition 1)

$$Mp - Hys > Thresh1$$

Inequality B2-4 (Leaving condition 2)

$$Mn + Ofn + Ocn + Hys < Thresh2$$

The variables in the formula are defined as follows:

***Mp*** is the measurement result of the PCell, not taking into account any offsets.

***Mn*** is the measurement result of the inter-RAT neighbour cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the frequency of the inter-RAT neighbour cell (i.e. *eutra-Q-OffsetRange* as defined within the *measObjectEUTRA* corresponding to the frequency of the inter-RAT neighbour cell, *utra-FDD-Q-OffsetRange* as defined within the *measObjectUTRA-FDD* corresponding to the frequency of the neighbour inter-RAT cell).

***Ocn*** is the cell specific offset of the inter-RAT neighbour cell (i.e. *cellIndividualOffset* as defined within the *measObjectEUTRA* corresponding to the neighbour inter-RAT cell, or *cellIndividualOffset* as defined within *reportConfigInterRAT*), and set to zero if not configured for the neighbour cell.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigInterRAT* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. b2*-Threshold1* as defined within *reportConfigInterRAT* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *b2-Threshold2EUTRA* as defined within *reportConfigInterRAT* for this event, *b2-Threshold2UTRA-FDD* as defined for UTRA-FDD within *reportConfigInterRAT* for this event).

***Mp*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and SINR.

***Mn*** is expressed in dBm or dB, depending on the measurement quantity of the inter-RAT neighbour cell.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mp***.

***Thresh2*** is expressed in the same unit as ***Mn***.

#### 5.5.4.10 Event I1 (Interference becomes higher than threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition I1-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition I1-2, as specified below, is fulfilled.

Inequality I1-1 (Entering condition)

$$Mi - Hys > Thresh$$

Inequality I1-2 (Leaving condition)

$$Mi + Hys < Thresh$$

The variables in the formula are defined as follows:

***Mi*** is the measurement result of the interference, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *i1-Threshold* as defined within *reportConfigNR* for this event).

***Mi, Thresh*** are expressed in dBm.

***Hys*** is expressed in dB.

#### 5.5.4.11 Event C1 (The NR sidelink channel busy ratio is above a threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition C1-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition C1-2, as specified below, is fulfilled;

Inequality C1-1 (Entering condition)

$$Ms - Hys > Thresh$$

Inequality C1-2 (Leaving condition)

$$Ms - Hys > Thresh$$

The variables in the formula are defined as follows:

***Ms*** is the measurement result of channel busy ratio of the transmission resource pool, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR-SL* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *c1-Threshold* as defined within *reportConfigNR-SL* for this event).

***Ms*** is expressed in decimal from 0 to 1 in steps of 0.01.

***Hys*** is expressed is in the same unit as ***Ms***.

***Thresh*** is expressed in the same unit as ***Ms***.

#### 5.5.4.12 Event C2 (The NR sidelink channel busy ratio is below a threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition C2-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition C2-2, as specified below, is fulfilled;

Inequality C2-1 (Entering condition)

$$Ms + Hys < Thresh$$

Inequality C2-2 (Leaving condition)

$$Ms - Hys > Thresh1$$

The variables in the formula are defined as follows:

***Ms*** is the measurement result of channel busy ratio of the transmission resource pool, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigNR-SL* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *c2-Threshold* as defined within *reportConfigNR-SL* for this event).

***Ms*** is expressed in decimal from 0 to 1 in steps of 0.01.

***Hys*** is expressed is in the same unit as ***Ms***.

***Thresh*** is expressed in the same unit as ***Ms***.

#### 5.5.4.13 Void

#### 5.5.4.14 Void

#### 5.5.4.15 Event D1 (Distance between UE and referenceLocation1 is above threshold1 and distance between UE and referenceLocation2 is below threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition D1-1 and condition D1-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition D1-3 or condition D1-4, i.e. at least one of the two, as specified below, are fulfilled;

Inequality D1-1 (Entering condition 1)

Inequality D1-2 (Entering condition 2)

Inequality D1-3 (Leaving condition 1)

Inequality D1-4 (Leaving condition 2)

The variables in the formula are defined as follows:

***Ml1*** is the distance between UE and a reference location for this event (i.e. *referenceLocation1* as defined within *reportConfigNR* for this event), not taking into account any offsets.

***Ml2*** is the distance between UE and a reference location for this event (i.e. *referenceLocation2* as defined within *reportConfigNR* for this event), not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresisLocation* as defined within *reportConfigNR* for this event).

***Thresh1*** is the threshold for this event defined as a distance, configured with parameter *distanceThreshFromReference1,* from a reference location configured with parameter *referenceLocation1* within *reportConfigNR* for this event.

***Thresh2*** is the threshold for this event defined as a distance, configured with parameter *distanceThreshFromReference2,* from a reference location configured with parameter *referenceLocation2* within *reportConfigNR* for this event.

***Ml1*** is expressed in meters.

***Ml2*** is expressed in the same unit as ***Ml1***.

***Hys*** is expressed in the same unit as ***Ml1.***

***Thresh1*** is expressed in the same unit as ***Ml1***.

***Thresh2*** is expressed in the same unit as ***Ml1***.

NOTE: The definition of Event D1 also applies to CondEvent D1.

#### 5.5.4.15a CondEvent D2 (Distance between UE and a moving referenceLocation1 is above threshold1 and distance between UE and a moving referenceLocation2 is below threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition D2-1 and condition D2-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition D2-3 or condition D2-4, i.e. at least one of the two, as specified below, are fulfilled;

Inequality D2-1 (Entering condition 1)

$$Ml1 - Hys > Thresh1$$

Inequality D2-2 (Entering condition 2)

$$Ml2 + Hys < Thresh2$$

Inequality D2-3 (Leaving condition 1)

$$Ml1 + Hys < Thresh1$$

Inequality D2-4 (Leaving condition 2)

$$Ml2 - Hys > Thresh2$$

The variables in the formula are defined as follows:

***Ml1*** is the distance between UE and a moving reference location for this event, not taking into account any offsets. The moving reference location is determined based on *referenceLocation1* as defined within *reportConfigNR* for this event and the corresponding epoch time and satellite ephemeris.

***Ml2*** is the distance between UE and a moving reference location for this event, not taking into account any offsets. The moving reference location is determined based on *referenceLocation2* as defined within *reportConfigNR* for this event and the corresponding epoch time and satellite ephemeris

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresisLocation* as defined within *reportConfigNR* for this event).

***Thresh1*** is the threshold for this event defined as a distance, configured with parameter *distanceThreshFromReference1,* from a moving reference location configured with parameter *referenceLocation1* within *reportConfigNR* for this event.

***Thresh2*** is the threshold for this event defined as a distance, configured with parameter *distanceThreshFromReference2,* from a moving reference location configured with parameter *referenceLocation2* within *reportConfigNR* for this event.

***Ml1*** is expressed in meters.

***Ml2*** is expressed in the same unit as ***Ml1***.

***Hys*** is expressed in the same unit as ***Ml1.***

***Thresh1*** is expressed in the same unit as ***Ml1***.

***Thresh2*** is expressed in the same unit as ***Ml1***.

Editor\'s Note: FFS whether location-based conditional handover (*condEventD2*) applies only to moving cells or a combination of moving and quasi-Earth fixed cells for the choice of source and target cells.

#### 5.5.4.16 CondEvent T1 (Time measured at UE is within a duration from threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition T1-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition T1-2, as specified below, is fulfilled;

Inequality T1-1 (Entering condition)

Inequality T1-2 (Leaving condition)

The variables in the formula are defined as follows:

***Mt*** is the time measured at UE.

***Thresh1*** is the threshold parameter for this event (i.e. *t1-Threshold* as defined within *reportConfigNR* for this event).

***Duration*** is the duration parameter for this event (i.e. *duration* as defined within *reportConfigNR* for this event).

***Mt*** is expressed in *ms*.

***Thresh1*** is expressed in the same unit as ***Mt***.

***Duration*** is expressed in the same unit as ***Mt***.

#### 5.5.4.17 Event X1 (Serving L2 U2N Relay UE becomes worse than threshold1 and NR Cell becomes better than threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition X1-1 and condition X1-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition X1-3 or condition X1-4, i.e. at least one of the two, as specified below, is fulfilled;

Inequality X1-1 (Entering condition 1)

$$Mr + Hys < Thresh1$$

Inequality X1-2 (Entering condition 2)

$$Mn + Ofn + Ocn - Hys > Thresh2$$

Inequality X1-3 (Leaving condition 1)

$$Mr - Hys > Thresh1$$

Inequality X1-4 (Leaving condition 2)

$$Mn + Ofn + Ocn + Hys < Thresh2$$

The variables in the formula are defined as follows:

***Mr*** is the measurement result of the serving L2 U2N Relay UE, not taking into account any offsets.

***Mn*** is the measurement result of the NR cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the reference signal of the NR cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the NR cell).

***Ocn*** is the cell specific offset of the NR cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the frequency of the NR cell, or *cellIndividualOffset* as defined within *reportConfigNR*), and set to zero if not configured for the cell.

***Hys*** is the hysteresis parameter for this event.

***Thresh1*** is the threshold parameter for this event (i.e. *x1-Threshold1-Relay* as defined within *reportConfigNR* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *x1-Threshold2* as defined within *reportConfigNR* for this event).

***Mr*** is expressed in dBm.

***Mn*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mr***.

***Thresh2*** is expressed in the same unit as ***Mn***.

#### 5.5.4.18 Event X2 (Serving L2 U2N Relay UE becomes worse than threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition X2-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition X2-2, as specified below, is fulfilled;

Inequality X2-1 (Entering condition)

$$Mr + Hys < Thresh$$

Inequality X2-2 (Leaving condition)

$$Mr - Hys > Thresh$$

The variables in the formula are defined as follows:

***Mr*** is the measurement result of the serving L2 U2N Relay UE, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event.

***Thresh*** is the threshold parameter for this event (i.e. *x2-Threshold-Relay* as defined within *reportConfigNR* for this event).

***Mr*** is expressed in dBm.

***Hys*** are expressed in dB.

***Thresh*** is expressed in the same unit as ***Mr***.

#### 5.5.4.19 Event Y1 (PCell becomes worse than threshold1 and candidate L2 U2N Relay UE becomes better than threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition Y1-1 and condition Y1-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition Y1-3 or condition Y1-4, i.e. at least one of the two, as specified below, is fulfilled;

Inequality Y1-1 (Entering condition 1)

$$Mp + Hys < Thresh1$$

Inequality Y1-2 (Entering condition 2)

$$Mr - Hys > Thresh2$$

Inequality Y1-3 (Leaving condition 1)

$$Mp - Hys > Thresh1$$

Inequality Y1-4 (Leaving condition 2)

$$Mr + Hys < Thresh2$$

The variables in the formula are defined as follows:

***Mp*** is the measurement result of the PCell, not taking into account any offsets.

***Mr*** is the measurement result of the candidate L2 U2N Relay UE, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigInterRAT* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. *y1-Threshold1* as defined within *reportConfigInterRAT* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *y1-Threshold2-Relay* as defined within *reportConfigInterRAT* for this event).

***Mp*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and SINR.

***Mr*** is expressed in dBm or dB, depending on the measurement quantity of candidate L2 U2N Relay UE.

***Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mp***.

***Thresh2*** is expressed in the same unit as ***Mr***.

#### 5.5.4.20 Event Y2 (Candidate L2 U2N Relay UE becomes better than threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition Y2-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition Y2-2, as specified below, is fulfilled;

Inequality Y2-1 (Entering condition)

$$Mr - Hys > Thresh$$

Inequality Y2-2 (Leaving condition)

$$Mr + Hys < Thresh$$

The variables in the formula are defined as follows:

***Mr*** is the measurement result of the candidate L2 U2N Relay UE, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigInterRAT* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *y2-Threshold-Relay* as defined within *reportConfigInterRAT* for this event).

***Mr*** is expressed in dBm or dB, depending on the measurement quantity of candidate L2 U2N Relay UE.

***Hys*** are expressed in dB.

***Thresh*** is expressed in the same unit as ***Mr***.

#### 5.5.4.20b Event Z1 (Serving L2 U2N Relay UE becomes worse than threshold1 and Candidate L2 U2N Relay UE becomes better than threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition Z1-1 and condition Z1-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition Z1-3 or condition Z1-4, i.e. at least one of the two, as specified below, is fulfilled;

Inequality Z1-1 (Entering condition 1)

$$Mr + Hys < Thresh1$$

Inequality Z1-2 (Entering condition 2)

$$Mn - Hys > Thresh2$$

Inequality Z1-3 (Leaving condition 1)

$$Mr - Hys > Thresh1$$

Inequality Z1-4 (Leaving condition 2)

$$Mn + Hys < Thresh2$$

The variables in the formula are defined as follows:

***Mr*** is the measurement result of the serving L2 U2N Relay UE, not taking into account any offsets.

***Mn*** is the measurement result of the candidate L2 U2N Relay UE, not taking into account any offsets.

***Hys*** is the hysteresis parameter for this event (i.e. *hysteresis* as defined within *reportConfigInterRAT* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. *sl-rsrp* in *z1-Threshold1-Relay* as defined within *reportConfigInterRAT* if the UE measures SL-RSRP, or *sd-rsrp* in *z1-Threshold1-Relay* as defined within *reportConfigInterRAT* if the UE measures SD-RSRP for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *z1-Threshold2-Relay* as defined within *reportConfigInterRAT* for this event).

***Mr*** is expressed in dBm or dB, depending on the measurement quantity of serving L2 U2N Relay UE.

***Mn*** is expressed in dBm or dB, depending on the measurement quantity of candidate L2 U2N Relay UE.

***Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mr***.

***Thresh2*** is expressed in the same unit as ***Mn.***

#### 5.5.4.21 Event H1 (The Aerial UE altitude becomes higher than a threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition H1-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition H1-2, as specified below, is fulfilled;

Inequality H1-1 (Entering condition)

$$Ms - Hys > Thresh$$

Inequality H1-2 (Leaving condition)

$$Ms + Hys < Thresh$$

The variables in the formula are defined as follows:

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys*** is the hysteresis parameter for this event (i.e. *h1-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *h1-Threshold* as defined within *reportConfigNR* for this event).

***Ms, Hys, Thresh*** are expressed in meters.

#### 5.5.4.22 Event H2 (The Aerial UE altitude becomes lower than a threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when condition H2-1, as specified below, is fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition H2-2, as specified below, is fulfilled;

Inequality H2-1 (Entering condition)

$$Ms + Hys < Thresh$$

Inequality H2-2 (Leaving condition)

$$Ms - Hys > Thresh$$

The variables in the formula are defined as follows:

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys*** is the hysteresis parameter for this event (i.e. *h2-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *h2-Threshold* as defined within *reportConfigNR* for this event).

***Ms, Hys, Thresh*** are expressed in meters.

#### 5.5.4.23 Event A3H1 (Neighbour becomes offset better than SpCell and the Aerial UE altitude becomes higher than a threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition A3H1-1 and condition A3H1-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A3H1-3 or condition A3H1-4, i.e. at least one of the two, as specified below, is fulfilled;

1\> use the SpCell for *Mp*, *Ofp and Ocp*.

NOTE 1: The cell(s) that triggers the event has reference signals indicated in the *measObjectNR* associated to this event which may be different from the NR SpCell *measObjectNR*.

Inequality A3H1-1 (Entering condition 1)

$$Mn + Ofn + Ocn - Hys1 > Mp + Ofp + Ocp + Off$$

Inequality A3H1-2 (Entering condition 2)

$$Ms - Hys2 > Thresh$$

Inequality A3H1-3 (Leaving condition 1)

$$Mn + Ofn + Ocn + Hys1 < Mp + Ofp + Ocp + Off$$

Inequality A3H1-4 (Leaving condition 2)

$$Ms + Hys2 < Thresh$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the reference signal of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the cell specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the frequency of the neighbour cell), and set to zero if not configured for the neighbour cell.

***Mp*** is the measurement result of the SpCell, not taking into account any offsets.

***Ofp*** is the measurement object specific offset of the SpCell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the SpCell).

***Ocp*** is the cell specific offset of the SpCell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the SpCell), and is set to zero if not configured for the SpCell.

***Hys1*** is the hysteresis parameter for this event (i.e. *a3-Hysteresis* as defined within *reportConfigNR* for this event).

***Off*** is the offset parameter for this event (i.e. *a3-Offset* as defined within *reportConfigNR* for this event).

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys2*** is the hysteresis parameter for this event (i.e. *h1-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *h1-Threshold* as defined within *reportConfigNR* for this event).

***Mn, Mp*** are expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn***, ***Ocn***, ***Hys1***, ***Ofp***, ***Ocp***, ***Off*** are expressed in dB.

***Ms, Hys2, Thresh*** are expressed in meters.

#### 5.5.4.24 Event A3H2 (Neighbour becomes offset better than SpCell and the Aerial UE altitude becomes lower than a threshold)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition A3H2-1 and condition A3H2-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A3H2-3 or condition A3H2-4, i.e. at least one of the two, as specified below, is fulfilled;

1\> use the SpCell for *Mp*, *Ofp and Ocp*.

NOTE: The cell(s) that triggers the event has reference signals indicated in the *measObjectNR* associated to this event which may be different from the NR SpCell *measObjectNR*.

Inequality A3H2-1 (Entering condition 1)

$$Mn + Ofn + Ocn - Hys1 > Mp + Ofp + Ocp + Off$$

Inequality A3H2-2 (Entering condition 2)

$$Ms + Hys2 < Thresh$$

Inequality A3H2-3 (Leaving condition 1)

$$Mn + Ofn + Ocn + Hys1 < Mp + Ofp + Ocp + Off$$

Inequality A3H1-4 (Leaving condition 2)

$$Ms - Hys > Thresh$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the reference signal of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the cell specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the frequency of the neighbour cell), and set to zero if not configured for the neighbour cell.

***Mp*** is the measurement result of the SpCell, not taking into account any offsets.

***Ofp*** is the measurement object specific offset of the SpCell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the SpCell).

***Ocp*** is the cell specific offset of the SpCell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the SpCell), and is set to zero if not configured for the SpCell.

***Hys1*** is the hysteresis parameter for this event (i.e. *a3-Hysteresis* as defined within *reportConfigNR* for this event).

***Off*** is the offset parameter for this event (i.e. *a3-Offset* as defined within *reportConfigNR* for this event).

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys2*** is the hysteresis parameter for this event (i.e. *h2-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh*** is the threshold parameter for this event (i.e. *h2-Threshold* as defined within *reportConfigNR* for this event).

***Mn, Mp*** are expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn***, ***Ocn***, ***Hys1***, ***Ofp***, ***Ocp***, ***Off*** are expressed in dB.

***Ms, Hys2, Thresh*** are expressed in meters.

#### 5.5.4.25 Event A4H1 (Neighbour becomes better than threshold1 and the Aerial UE altitude becomes higher than a threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition A4H1-1 and condition A4H1-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A4H1-3 or condition A4H1-4, i.e. at least one of the two, as specified below, is fulfilled.

Inequality A4H1-1 (Entering condition 1)

$$Mn + Ofn + Ocn - Hys1 > Thresh1$$

Inequality A4H1-2 (Entering condition 2)

$$Ms - Hys2 > Thresh2$$

Inequality A4H1-3 (Leaving condition 1)

$$Mn + Ofn + Ocn + Hys1 < Thresh1$$

Inequality A4H1-4 (Leaving condition 2)

$$Ms + Hys2 < Thresh2$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the measurement object specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the neighbour cell), and set to zero if not configured for the neighbour cell.

***Hys1*** is the hysteresis parameter for this event (i.e. *a4-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. *a4-Threshold* as defined within *reportConfigNR* for this event).

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys2*** is the hysteresis parameter for this event (i.e. *h1-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *h1-Threshold* as defined within *reportConfigNR* for this event).

***Mn*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mn***.

***Ms, Hys2, Thresh2*** are expressed in meters.

#### 5.5.4.26 Event A4H2 (Neighbour becomes better than threshold1 and the Aerial UE altitude becomes lower than a threshold2)

The UE shall:

1\> consider the entering condition for this event to be satisfied when both condition A4H2-1 and condition A4H2-2, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A4H2-3 or condition A4H2-4, i.e. at least one of the two, as specified below, is fulfilled.

Inequality A4H2-1 (Entering condition 1)

$$Mn + Ofn + Ocn - Hys1 > Thresh1$$

Inequality A4H2-2 (Entering condition 2)

$$Ms + Hys2 < Thresh2$$

Inequality A4H2-3 (Leaving condition 1)

$$Mn + Ofn + Ocn + Hys1 < Thresh1$$

Inequality A4H2-4 (Leaving condition 2)

$$Ms - Hys2 > Thresh2$$

The variables in the formula are defined as follows:

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the measurement object specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the neighbour cell), and set to zero if not configured for the neighbour cell.

***Hys1*** is the hysteresis parameter for this event (i.e. *a4-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. *a4-Threshold* as defined within *reportConfigNR* for this event).

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys2*** is the hysteresis parameter for this event (i.e. *h2-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *h2-Threshold* as defined within *reportConfigNR* for this event).

***Mn*** is expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mn***.

***Ms, Hys2, Thresh2*** are expressed in meters.

#### 5.5.4.27 Event A5H1 (SpCell becomes worse than threshold1 and neighbour becomes better than threshold2 and the Aerial UE altitude becomes higher than a threshold3)

The UE shall:

1\> consider the entering condition for this event to be satisfied when all of condition A5H1-1 and condition A5H1-2 and condition A5H1-3, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A5H1-4 or condition A5H1-5 or condition A5H1-6, i.e. at least one of the three, as specified below, is fulfilled;

1\> use the SpCell for *Mp*.

NOTE: The parameters of the reference signal(s) of the cell(s) that triggers the event are indicated in the *measObjectNR* associated to the event which may be different from the *measObjectNR* of the NR SpCell.

Inequality A5H1-1 (Entering condition 1)

$$Mp + Hys1 < Thresh1$$

Inequality A5H1-2 (Entering condition 2)

$$Mn + Ofn + Ocn - Hys1 > Thresh2$$

Inequality A5H1-3 (Entering condition 3)

$$Ms - Hys2 > Thresh3$$

Inequality A5H1-4 (Leaving condition 1)

$$Mp - Hys1 > Thresh1$$

Inequality A5H1-5 (Leaving condition 2)

$$Mn + Ofn + Ocn + Hys1 < Thresh2$$

Inequality A5H1-6 (Leaving condition 3)

$$Ms + Hys2 < Thresh3$$

The variables in the formula are defined as follows:

***Mp*** is the measurement result of the NR SpCell, not taking into account any offsets.

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the cell specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the neighbour cell), and set to zero if not configured for the neighbour cell.

***Hys1*** is the hysteresis parameter for this event (i.e. *a5-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. *a5-Threshold1* as defined within *reportConfigNR* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *a5-Threshold2* as defined within *reportConfigNR* for this event).

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys2*** is the hysteresis parameter for this event (i.e. *h1-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh3*** is the threshold parameter for this event (i.e. *h1-Threshold* as defined within *reportConfigNR* for this event).

***Mn, Mp*** are expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mp***.

***Thresh2*** is expressed in the same unit as ***Mn***.

***Ms, Hys2, Thresh3*** are expressed in meters.

#### 5.5.4.28 Event A5H2 (SpCell becomes worse than threshold1 and neighbour becomes better than threshold2 and the Aerial UE altitude becomes lower than a threshold3)

The UE shall:

1\> consider the entering condition for this event to be satisfied when all of condition A5H2-1 and condition A5H2-2 and condition A5H2-3, as specified below, are fulfilled;

1\> consider the leaving condition for this event to be satisfied when condition A5H2-4 or condition A5H2-5 or condition A5H2-6, i.e. at least one of the three, as specified below, is fulfilled;

1\> use the SpCell for *Mp*.

NOTE: The parameters of the reference signal(s) of the cell(s) that triggers the event are indicated in the *measObjectNR* associated to the event which may be different from the *measObjectNR* of the NR SpCell.

Inequality A5H2-1 (Entering condition 1)

$$Mp + Hys1 < Thresh1$$

Inequality A5H2-2 (Entering condition 2)

$$Mn + Ofn + Ocn - Hys1 > Thresh2$$

Inequality A5H2-3 (Entering condition 3)

$$Ms + Hys2 < Thresh3$$

Inequality A5H2-4 (Leaving condition 1)

$$Mp - Hys1 > Thresh1$$

Inequality A5H2-5 (Leaving condition 2)

$$Mn + Ofn + Ocn + Hys1 < Thresh2$$

Inequality A5H2-6 (Leaving condition 3)

$$Ms - Hys2 > Thresh3$$

The variables in the formula are defined as follows:

***Mp*** is the measurement result of the NR SpCell, not taking into account any offsets.

***Mn*** is the measurement result of the neighbouring cell, not taking into account any offsets.

***Ofn*** is the measurement object specific offset of the neighbour cell (i.e. *offsetMO* as defined within *measObjectNR* corresponding to the neighbour cell).

***Ocn*** is the cell specific offset of the neighbour cell (i.e. *cellIndividualOffset* as defined within *measObjectNR* corresponding to the neighbour cell), and set to zero if not configured for the neighbour cell.

***Hys1*** is the hysteresis parameter for this event (i.e. *a5-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh1*** is the threshold parameter for this event (i.e. *a5-Threshold1* as defined within *reportConfigNR* for this event).

***Thresh2*** is the threshold parameter for this event (i.e. *a5-Threshold2* as defined within *reportConfigNR* for this event).

***Ms*** is the Aerial UE altitude relative to the sea level.

***Hys2*** is the hysteresis parameter for this event (i.e. *h2-Hysteresis* as defined within *reportConfigNR* for this event).

***Thresh3*** is the threshold parameter for this event (i.e. *h2-Threshold* as defined within *reportConfigNR* for this event).

***Mn, Mp*** are expressed in dBm in case of RSRP, or in dB in case of RSRQ and RS-SINR.

***Ofn, Ocn, Hys*** are expressed in dB.

***Thresh1*** is expressed in the same unit as ***Mp***.

***Thresh2*** is expressed in the same unit as ***Mn***.

***Ms, Hys2, Thresh3*** are expressed in meters.

### 5.5.5 Measurement reporting

#### 5.5.5.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: MeasurementReport [ac];
|||;
~~~

Figure 5.5.5.1-1: Measurement reporting

The purpose of this procedure is to transfer measurement results from the UE to the network. The UE shall initiate this procedure only after successful AS security activation.

For the *measId* for which the measurement reporting procedure was triggered, the UE shall set the *measResults* within the *MeasurementReport* message as follows:

1\> set the *measId* to the measurement identity that triggered the measurement reporting;

1\> for each serving cell configured with *servingCellMO*:

2\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting includes *rsType*:

3\> if the serving cell measurements based on the *rsType* included in the *reportConfig* that triggered the measurement report are available:

4\> set the *measResultServingCell* within *measResultServingMOList* to include RSRP, RSRQ and the available SINR of the serving cell, derived based on the *rsType* included in the *reportConfig* that triggered the measurement report;

2\> else:

3\> if SSB based serving cell measurements are available:

4\> set the *measResultServingCell* within *measResultServingMOList* to include RSRP, RSRQ and the available SINR of the serving cell, derived based on SSB;

3\> else if CSI-RS based serving cell measurements are available:

4\> set the *measResultServingCell* within *measResultServingMOList* to include RSRP, RSRQ and the available SINR of the serving cell, derived based on CSI-RS;

1\> set the *servCellId* within *measResultServingMOList* to include each NR serving cell that is configured with *servingCellMO*, if any;

1\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting includes *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport*:

2\> for each serving cell configured with *servingCellMO*, include beam measurement information according to the associated *reportConfig* as described in 5.5.5.2;

1\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting includes *reportAddNeighMeas*:

2\> for each *measObjectId* referenced in the *measIdList* which is also referenced with *servingCellMO*, other than the *measObjectId* corresponding with the *measId* that triggered the measurement reporting:

3\> if the *measObjectNR* indicated by the *servingCellMO* includes the RS resource configuration corresponding to the *rsType* indicated in the *reportConfig*:

4\> set the *measResultBestNeighCell* within *measResultServingMOList* to include the *physCellId* and the available measurement quantities based on the *reportQuantityCell* and *rsType* indicated in *reportConfig* of the non-serving cell corresponding to the concerned *measObjectNR* with the highest measured RSRP if RSRP measurement results are available for cells corresponding to this *measObjectNR*, otherwise with the highest measured RSRQ if RSRQ measurement results are available for cells corresponding to this *measObjectNR*, otherwise with the highest measured SINR;

4\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting includes *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport:*

5\> for each best non-serving cell included in the measurement report:

6\> include beam measurement information according to the associated *reportConfig* as described in 5.5.5.2;

1\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting is set to *eventTriggered* and *eventID* is set to *eventA3*, or *eventA4*, or *eventA5*, or *eventB1*, or *eventB2,* or *eventA3H1,* or *eventA3H2,* or *eventA4H1,* or *eventA4H2,* or *eventA5H1,* or *eventA5H2*:

2\> if the UE is in NE-DC and the measurement configuration that triggered this measurement report is associated with the MCG:

3\> set the *measResultServFreqListEUTRA-SCG* to include an entry for each E-UTRA SCG serving frequency with the following:

4\> include *carrierFreq* of the E-UTRA serving frequency;

4\> set the *measResultServingCell* to include the available measurement quantities that the UE is configured to measure by the measurement configuration associated with the SCG;

4\> if *reportConfig* associated with the *measId* that triggered the measurement reporting includes *reportAddNeighMeas*:

5\> set the *measResultServFreqListEUTRA-SCG* to include within *measResultBestNeighCell* the quantities of the best non-serving cell, based on RSRP, on the concerned serving frequency;

1\> if *reportConfig* associated with the *measId* that triggered the measurement reporting is set to *eventTriggered* and *eventID* is set to *eventA3*, or *eventA4*, or *eventA5,* or *eventA3H1,* or *eventA3H2,* or *eventA4H1,* or *eventA4H2,* or *eventA5H1,* or *eventA5H2*:

2\> if the UE is in NR-DC and the measurement configuration that triggered this measurement report is associated with the MCG:

3\> set the *measResultServFreqListNR-SCG* to include for each NR SCG serving cell that is configured with *servingCellMO*, if any, the following:

4\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting includes *rsType*:

5\> if the serving cell measurements based on the *rsType* included in the *reportConfig* that triggered the measurement report are available according to the measurement configuration associated with the SCG:

6\> set the *measResultServingCell* within *measResultServFreqListNR-SCG* to include RSRP, RSRQ and the available SINR of the serving cell, derived based on the *rsType* included in the *reportConfig* that triggered the measurement report;

4\> else:

5\> if SSB based serving cell measurements are available according to the measurement configuration associated with the SCG:

6\> set the *measResultServingCell* within *measResultServFreqListNR-SCG* to include RSRP, RSRQ and the available SINR of the serving cell, derived based on SSB;

5\> else if CSI-RS based serving cell measurements are available according to the measurement configuration associated with the SCG:

6\> set the *measResultServingCell* within *measResultServFreqListNR-SCG* to include RSRP, RSRQ and the available SINR of the serving cell, derived based on CSI-RS;

4\> if results for the serving cell derived based on SSB are included:

5\> include the *ssbFrequency* to the value indicated by ssbFrequency as included in the *MeasObjectNR* of the serving cell;

4\> if results for the serving cell derived based on CSI-RS are included:

5\> include the *refFreqCSI-RS* to the value indicated by *refFreqCSI-RS* as included in the *MeasObjectNR* of the serving cell;

4\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting includes *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport*:

5\> for each serving cell configured with *servingCellMO*, include beam measurement information according to the associated *reportConfig* as described in 5.5.5.2, where availability is considered according to the measurement configuration associated with the SCG;

4\> if *reportConfig* associated with the *measId* that triggered the measurement reporting includes *reportAddNeighMeas*:

5\> if the *measObjectNR* indicated by the *servingCellMO* includes the RS resource configuration corresponding to the *rsType* indicated in the *reportConfig*:

6\> set the *measResultNeighCellListNR* within *measResultServFreqListNR-SCG* to include one entry with the *physCellId* and the available measurement quantities based on the *reportQuantityCell* and *rsType* indicated in *reportConfig* of the non-serving cell corresponding to the concerned *measObjectNR* with the highest measured RSRP if RSRP measurement results are available for cells corresponding to this *measObjectNR*, otherwise with the highest measured RSRQ if RSRQ measurement results are available for cells corresponding to this *measObjectNR*, otherwise with the highest measured SINR, where availability is considered according to the measurement configuration associated with the SCG;

7\> if the *reportConfig* associated with the *measId* that triggered the measurement reporting includes *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport:*

8\> for each best non-serving cell included in the measurement report:

9\> include beam measurement information according to the associated *reportConfig* as described in 5.5.5.2, where availability is considered according to the measurement configuration associated with the SCG;

1\> if the *measRSSI-ReportConfig* is configured within the corresponding *reportConfig* for this *measId*:

2\> set the *rssi-Result* to the linear average of sample value(s) provided by lower layers in the *reportInterval;*

2\> set the *channelOccupancy* to the rounded percentage of sample values which are beyond the *channelOccupancyThreshold* within all the sample values in the *reportInterval;*

1\> if the UE is acting as L2 U2N Remote UE:

2\> set the *sl-MeasResultServingRelay* in accordance with the following:

3\> set the *cellIdentity* to include the *cellAccessRelatedInfo* contained in the discovery message received from the serving L2 U2N Relay UE;

3\> set the *sl-RelayUE-Identity* to include the Source L2 ID of the serving L2 U2N Relay;

3\> if the measurement of serving L2 U2N Relay UE is based on SL-RSRP:

4\> set the *sl-MeasResult* to include the SL-RSRP of the serving L2 U2N Relay UE;

4\> set the *sl-MeasQuantity* to SL-RSRP, if supported by the UE;

3\> else:

4\> set the *sl-MeasResult* to include the SD-RSRP of the serving L2 U2N Relay UE;

4\> set the *sl-MeasQuantity* to SD-RSRP, if supported by the UE;

NOTE 1: In case of no data transmission from L2 U2N Relay UE to L2 U2N Remote UE, it is left to UE implementation whether to use SL-RSRP or SD-RSRP when setting the *sl-MeasResultServingRelay* of the serving L2 U2N Relay UE.

1\> if there is at least one applicable neighbouring cell or candidate L2 U2N Relay UE to report:

2\> if the *reportType* is set to *eventTriggered* or *periodical*:

3\> if the measurement report concerns the candidate L2 U2N Relay UE:

4\> set the *sl-MeasResultsCandRelay* in *measResultNeighCells* to include the best candidate L2 U2N Relay UEs up to *maxNrofRelayMeas* in accordance with the following:

5\> if the *reportType* is set to *eventTriggered*:

6\> include the L2 U2N Relay UEs included in the *relaysTriggeredList* as defined within the *VarMeasReportList* for this *measId*;

5\> else:

6\> include the applicable L2 U2N Relay UEs for which the new measurement results became available since the last periodical reporting or since the measurement was initiated or reset;

5\> for each L2 U2N Relay UE that is included in the *sl-MeasResultsCandRelay*:

6\> set the *cellIdentity* to include the *cellAccessRelatedInfo* contained in the discovery message received from the concerned L2 U2N Relay UE;

6\> set the *sl-RelayUE-Identity* to include the Source L2 ID of the concerned L2 U2N Relay UE;

6\> set the *sl-MeasResult* to include the SD-RSRP of the concerned L2 U2N Relay UE;

5\> for each included L2 U2N Relay UE, include the layer 3 filtered measured results in accordance with the *reportConfig* for this *measId*, ordered as follows:

6\> set the *sl-MeasResult* to include the quantity(ies) indicated in the *reportQuantityRelay* within the concerned *reportConfigRelay* in decreasing order of the sorting quantity, determined as specified in 5.5.5.3, i.e. the best L2 U2N Relay UE is included first;

3\> else:

4\> set the *measResultNeighCells* to include the best neighbouring cells up to *maxReportCells* in accordance with the following:

5\> if the *reportType* is set to *eventTriggered* and *eventId* is not set to *eventD1* or *eventH1* or *eventH2*:

6\> include the cells included in the *cellsTriggeredList* as defined within the *VarMeasReportList* for this *measId*;

5\> else:

6\> include the applicable cells for which the new measurement results became available since the last periodical reporting or since the measurement was initiated or reset;

5\> for each cell that is included in the *measResultNeighCells*, include the *physCellId*;

5\> if the reportType is set to eventTriggered or periodical:

6\> for each included cell, include the layer 3 filtered measured results in accordance with the *reportConfig* for this *measId*, ordered as follows:

7\> if the *measObject* associated with this *measId* concerns NR:

8\> if *rsType* in the associated *reportConfig* is set to *ssb*:

9\> set *resultsSSB-Cell* within the *measResult* to include the SS/PBCH block based quantity(ies) indicated in the *reportQuantityCell* within the concerned *reportConfig*, in decreasing order of the sorting quantity, determined as specified in 5.5.5.3, i.e. the best cell is included first;

9\> if *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport* are configured, include beam measurement information as described in 5.5.5.2;

8\> else if *rsType* in the associated *reportConfig* is set to *csi-rs*:

9\> set *resultsCSI-RS-Cell* within the *measResult* to include the CSI-RS based quantity(ies) indicated in the *reportQuantityCell* within the concerned *reportConfig*, in decreasing order of the sorting quantity, determined as specified in 5.5.5.3, i.e. the best cell is included first;

9\> if *reportQuantityRS-Indexes* and *maxNrofRS-IndexesToReport* are configured, include beam measurement information as described in 5.5.5.2;

7\> if the *measObject* associated with this *measId* concerns E-UTRA:

8\> set the *measResult* to include the quantity(ies) indicated in the *reportQuantity* within the concerned *reportConfigInterRAT* in decreasing order of the sorting quantity, determined as specified in 5.5.5.3, i.e. the best cell is included first;

7\> if the *measObject* associated with this *measId* concerns UTRA-FDD and if *ReportConfigInterRAT* includes the *reportQuantityUTRA-FDD*:

8\> set the *measResult* to include the quantity(ies) indicated in the *reportQuantityUTRA-FDD* within the concerned *reportConfigInterRAT* in decreasing order of the sorting quantity, determined as specified in 5.5.5.3, i.e. the best cell is included first;

2\> else:

3\> if the cell indicated by *cellForWhichToReportCGI* is an NR cell:

4\> if *plmn-IdentityInfoList* of the *cgi-Info* for the concerned cell has been obtained:

5\> include the *plmn-IdentityInfoList* including *plmn-IdentityList*, *trackingAreaCode* (if available), *trackingAreaList* (if available)*, ranac* (if available), *cellIdentity* and *cellReservedForOperatorUse* for each entry of the *plmn-IdentityInfoList*;

5\> include *frequencyBandList* if available;

5\> for each *PLMN-IdentityInfo* in *plmn-IdentityInfoList*:

6\> if the *gNB-ID-Length* is broadcast:

7\> include *gNB-ID-Length*;

4\> if *nr-CGI-Reporting-NPN* is supported by the UE and *npn-IdentityInfoList* of the *cgi-Info* for the concerned cell has been obtained:

5\> include the *npn-IdentityInfoList* including *npn-IdentityList*, *trackingAreaCode*, *ranac* (if available), *cellIdentity* and *cellReservedForOperatorUse* for each entry of the *npn-IdentityInfoList*;

5\> for each *NPN-IdentityInfo* in *NPN-IdentityInfoList*:

6\> if the *gNB-ID-Length* is broadcast:

7\> include *gNB-ID-Length*;

5\> include *cellReservedForOtherUse* if available;

4\> else if *MIB* indicates the *SIB1* is not broadcast:

5\> include the *noSIB1* including the *ssb-SubcarrierOffset* and *pdcch-ConfigSIB1* obtained from *MIB* of the concerned cell;

3\> if the cell indicated by *cellForWhichToReportCGI* is an E-UTRA cell:

4\> if all mandatory fields of the *cgi-Info-EPC* for the concerned cell have been obtained:

5\> include in the *cgi-Info-EPC* the fields broadcasted in E-UTRA *SystemInformationBlockType1* associated to EPC;

4\> if the UE is E-UTRA/5GC capable and all mandatory fields of the *cgi-Info-5GC* for the concerned cell have been obtained:

5\> include in the *cgi-Info-5GC* the fields broadcasted in E-UTRA *SystemInformationBlockType1* associated to 5GC;

4\> if the mandatory present fields of the *cgi-Info* for the cell indicated by the *cellForWhichToReportCGI* in the associated *measObject* have been obtained:

5\> include the *freqBandIndicator*;

5\> if the cell broadcasts the *multiBandInfoList*, include the *multiBandInfoList*;

5\> if the cell broadcasts the *freqBandIndicatorPriority*, include the *freqBandIndicatorPriority*;

1\> if the corresponding *measObject* concerns NR:

2\> if the *reportSFTD-Meas* is set to *true* within the corresponding *reportConfigNR* for this *measId*:

3\> set the *measResultSFTD-NR* in accordance with the following:

4\> set *sfn-OffsetResult* and *frameBoundaryOffsetResult* to the measurement results provided by lower layers;

4\> if the *reportRSRP* is set to *true*;

5\> set *rsrp-Result* to the RSRP of the NR PSCell derived based on SSB;

2\> else if the *reportSFTD-NeighMeas* is included within the corresponding *reportConfigNR* for this *measId*:

3\> for each applicable cell which measurement results are available, include an entry in the *measResultCellListSFTD-NR* and set the contents as follows:

4\> set *physCellId* to the physical cell identity of the concerned NR neighbour cell.

4\> set *sfn-OffsetResult* and *frameBoundaryOffsetResult* to the measurement results provided by lower layers;

4\> if the *reportRSRP* is set to *true*:

5\> set *rsrp-Result* to the RSRP of the concerned cell derived based on SSB;

1\> else if the corresponding *measObject* concerns E-UTRA:

2\> if the *reportSFTD-Meas* is set to *true* within the corresponding *reportConfigInterRAT* for this *measId*:

3\> set the *measResultSFTD-EUTRA* in accordance with the following:

4\> set *sfn-OffsetResult* and *frameBoundaryOffsetResult* to the measurement results provided by lower layers;

4\> if the *reportRSRP* is set to *true*;

5\> set *rsrpResult-EUTRA* to the RSRP of the EUTRA PSCell;

1\> if average uplink PDCP delay values are available:

2\> set the *ul-PDCP-DelayValueResultList* to include the corresponding average uplink PDCP delay values;

1\> if PDCP excess delay measurements are available:

2\> set the *ul-PDCP-ExcessDelayResultList* to include the corresponding PDCP excess delay measurements;

1\> if the *includeCommonLocationInfo* is configured in the corresponding *reportConfig* for this *measId* and detailed location information that has not been reported is available, set the content of *commonLocationInfo* of the *locationInfo* as follows:

2\> include the *locationTimestamp*;

2\> include the *locationCoordinate*, if available;

2\> include the *velocityEstimate*, if available;

2\> include the *locationError*, if available;

2\> include the *locationSource*, if available;

2\> if available, include the *gnss-TOD-msec*,

1\> if the *coarseLocationRequest* is set to *true* in the corresponding *reportConfig* for this *measId*:

2\> include *coarseLocationInfo,* if available;

1\> if the *includeWLAN-Meas* is configured in the corresponding *reportConfig* for this *measId*, set the *wlan-LocationInfo* of the *locationInfo* in the *measResults* as follows:

2\> if available, include the *LogMeasResultWLAN*, in order of decreasing RSSI for WLAN APs;

1\> if the *includeBT-Meas* is configured in the corresponding *reportConfig* for this *measId*, set the *BT-LocationInfo* of the *locationInfo* in the *measResults* as follows:

2\> if available, include the *LogMeasResultBT*, in order of decreasing RSSI for Bluetooth beacons;

1\> if the *includeSensor-Meas* is configured in the corresponding *reportConfig* for this *measId*, set the *sensor-LocationInfo* of the *locationInfo* in the *measResults* as follows:

2\> if available, include the *sensor-MeasurementInformation*;

2\> if available, include the *sensor-MotionInformation*;

1\> if the *includeAltitudeUE* is configured in the corresponding *reportConfig* for this *measId*:

2\> set the *altitudeUE* to include the altitude of the UE;

1\> if there is at least one applicable transmission resource pool for NR sidelink communication/discovery (for *measResultsSL*):

2\> set the *measResultsListSL* to include the CBR measurement results in accordance with the following:

3\> if the *reportType* is set to *eventTriggered*:

4\> include the transmission resource pools included in the *poolsTriggeredList* as defined within the *VarMeasReportList* for this *measId*;

3\> else:

4\> include the applicable transmission resource pools for which the new measurement results became available since the last periodical reporting or since the measurement was initiated or reset;

3\> if the corresponding *measObject* concerns NR sidelink communication/discovery, then for each transmission resource pool to be reported:

4\> set the *sl-poolReportIdentity* to the identity of this transmission resource pool;

4\> set the *sl-CBR-ResultsNR* to the CBR measurement results on PSSCH and PSCCH of this transmission resource pool provided by lower layers, if available;

NOTE 1: Void.

1\> if there is at least one applicable CLI measurement resource to report:

2\> if the *reportType* is set to *cli-EventTriggered* or *cli-Periodical*:

3\> set the *measResultCLI* to include the most interfering SRS resources or most interfering CLI-RSSI resources up to *maxReportCLI* in accordance with the following:

4\> if the *reportType* is set to *cli-EventTriggered*:

5\> if trigger quantity is set to *srs-RSRP* i.e. *i1-Threshold* is set to *srs-RSRP*:

6\> include the SRS resource included in the *cli-TriggeredList* as defined within the *VarMeasReportList* for this *measId*;

5\> if trigger quantity is set to *cli-RSSI* i.e. *i1-Threshold* is set to *cli-RSSI*:

6\> include the CLI-RSSI resource included in the *cli-TriggeredList* as defined within the *VarMeasReportList* for this *measId*;

4\> else:

5\> if *reportQuantityCLI* is set to *srs-rsrp*:

6\> include the applicable SRS resources for which the new measurement results became available since the last periodical reporting or since the measurement was initiated or reset;

5\> else:

6\> include the applicable CLI-RSSI resources for which the new measurement results became available since the last periodical reporting or since the measurement was initiated or reset;

4\> for each SRS resource that is included in the *measResultCLI*:

5\> include the *srs-ResourceId*;

5\> set *srs-RSRP-Result* to include the layer 3 filtered measured results in decreasing order, i.e. the most interfering SRS resource is included first;

4\> for each CLI-RSSI resource that is included in the *measResultCLI*:

5\> include the *rssi-ResourceId*;

5\> set *cli-RSSI-Result* to include the layer 3 filtered measured results in decreasing order, i.e. the most interfering CLI-RSSI resource is included first;

1\> if there is at least one applicable UE Rx-Tx time difference measurement to report:

2\> set *measResultRxTxTimeDiff* to the latest measurement result;

1\> increment the *numberOfReportsSent* as defined within the *VarMeasReportList* for this *measId* by 1;

1\> stop the periodical reporting timer, if running;

1\> if the *numberOfReportsSent* as defined within the *VarMeasReportList* for this *measId* is less than the *reportAmount* as defined within the corresponding *reportConfig* for this *measId*:

2\> start the periodical reporting timer with the value of *reportInterval* as defined within the corresponding *reportConfig* for this *measId*;

1\> else:

2\> if the *reportType* is set to *periodical* or *cli-Periodical* or *rxTxPeriodical*:

3\> remove the entry within the *VarMeasReportList* for this *measId*;

3\> remove this *measId* from the *measIdList* within *VarMeasConfig*;

1\> if the measurement reporting was configured by a *sl-ConfigDedicatedNR* received within the *RRCConnectionReconfiguration*:

2\> submit the *MeasurementReport* message to lower layers for transmission via SRB1, embedded in E-UTRA RRC message *ULInformationTransferIRAT* as specified TS 36.331 \[10\], clause 5.6.28;

1\> else if the UE is in (NG)EN-DC:

2\> if SRB3 is configured and the SCG is not deactivated:

3\> submit the *MeasurementReport* message via SRB3 to lower layers for transmission, upon which the procedure ends;

2\> else:

3\> submit the *MeasurementReport* message via E-UTRA embedded in E-UTRA RRC message *ULInformationTransferMRDC* as specified in TS 36.331 \[10\].

1\> else if the UE is in NR-DC:

2\> if the measurement configuration that triggered this measurement report is associated with the SCG:

3\> if SRB3 is configured and the SCG is not deactivated:

4\> submit the *MeasurementReport* message via SRB3 to lower layers for transmission, upon which the procedure ends;

3\> else:

4\> submit the *MeasurementReport* message via SRB1 embedded in NR RRC message *ULInformationTransferMRDC* as specified in 5.7.2a.3;

2\> else:

3\> submit the *MeasurementReport* message via SRB1 to lower layers for transmission, upon which the procedure ends;

1\> else:

2\> submit the *MeasurementReport* message to lower layers for transmission, upon which the procedure ends.

#### 5.5.5.2 Reporting of beam measurement information

For beam measurement information to be included in a measurement report the UE shall:

1\> if *reportType* is set to *eventTriggered* or *reportOnScellActivation*:

2\> consider the trigger quantity as the sorting quantity if available, otherwise RSRP as sorting quantity if available, otherwise RSRQ as sorting quantity if available, otherwise SINR as sorting quantity;

1\> if *reportType* is set to *periodical*:

2\> if a single reporting quantity is set to *true* in *reportQuantityRS-Indexes*;

3\> consider the configured single quantity as the sorting quantity;

2\> else:

3\> if *rsrp* is set to *true*;

4\> consider RSRP as the sorting quantity;

3\> else:

4\> consider RSRQ as the sorting quantity;

1\> set *rsIndexResults* to include up to *maxNrofRS-IndexesToReport* SS/PBCH block indexes or CSI-RS indexes in order of decreasing sorting quantity as follows:

2\> if the measurement information to be included is based on SS/PBCH block:

3\> include within *resultsSSB-Indexes* the index associated to the best beam for that SS/PBCH block sorting quantity and if *absThreshSS-BlocksConsolidation* is included in the *VarMeasConfig* for the *measObject* associated to the cell for which beams are to be reported, the remaining beams whose sorting quantity is above *absThreshSS-BlocksConsolidation*;

3\> if *includeBeamMeasurements* is set to *true*, include the SS/PBCH based measurement results for the quantities in *reportQuantityRS-Indexes* for each SS/PBCH block index;

2\> else if the beam measurement information to be included is based on CSI-RS:

3\> include within *resultsCSI-RS-Indexes* the index associated to the best beam for that CSI-RS sorting quantity and, if *absThreshCSI-RS-Consolidation* is included in the *VarMeasConfig* for the *measObject* associated to the cell for which beams are to be reported, the remaining beams whose sorting quantity is above *absThreshCSI-RS-Consolidation*;

3\> if *includeBeamMeasurements* is set to *true*, include the CSI-RS based measurement results for the quantities in *reportQuantityRS-Indexes* for each CSI-RS index.

#### 5.5.5.3 Sorting of cell measurement results

The UE shall determine the sorting quantity according to parameters of the *reportConfig* associated with the *measId* that triggered the reporting:

1\> if the *reportType* is set to *eventTriggered*:

2\> for an NR cell, consider the quantity used in the *aN-Threshold* (for *eventA1*, *eventA2*, *eventA4, eventA4H1* and *eventA4H2*) or in the *a5-Threshold2* (for *eventA5, eventA5H1* and *eventA5H2*) or in the *aN-Offset* (for *eventA3, eventA3H1, eventA3H2* and *eventA6*) or in the *x1-Threshold2* (for *eventX1*) as the sorting quantity;

2\> for an E-UTRA cell, consider the quantity used in the *bN-ThresholdEUTRA* as the sorting quantity;

2\> for an UTRA-FDD cell, consider the quantity used in the *bN-ThresholdUTRA-FDD* as the sorting quantity;

2\> for a candidate L2 U2N Relay UE, consider the *y1-Threshold2-Relay* (for *eventY1-Relay*) or *y2-Threshold-Relay* (*for eventY2-Relay*) or *z1-Threshold2-Relay* (for *eventZ1*) as the sorting quantity;

1\> if the *reportType* is set to *periodical*:

2\> determine the sorting quantity according to *reportQuantityCell* for an NR cell, and according to *reportQuantity* for an E-UTRA cell, as below:

3\> if a single quantity is set to *true*:

4\> consider this quantity as the sorting quantity;

3\> else:

4\> if *rsrp* is set to *true*;

5\> consider RSRP as the sorting quantity;

4\> else:

5\> consider RSRQ as the sorting quantity;

2\> determine the sorting quantity according to *reportQuantityUTRA-FDD* for UTRA-FDD cell, as below:

3\> if a single quantity is set to *true*:

4\> consider this quantity as the sorting quantity;

3\> else:

4\> consider RSCP as the sorting quantity.

2\> for a candidate L2 U2N Relay UE, consider the *reportQuantityRelay* as the sorting quantity;

### 5.5.6 Location measurement indication

#### 5.5.6.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: LocationMeasurementIndication [ac];
|||;
~~~

Figure 5.5.6.1-1: Location measurement indication

The purpose of this procedure is to indicate to the network that the UE is going to start/stop location related measurements towards E-UTRA or NR which require measurement gaps or start/stop detection of subframe and slot timing towards E-UTRA (*eutra-FineTimingDetection)* which requires measurement gaps. UE shall initiate this procedure only after successful AS security activation.

NOTE: It is a network decision to configure the measurement gap.

#### 5.5.6.2 Initiation

The UE shall:

1\> if and only if upper layers indicate to start performing location measurements towards E-UTRA or NR or start subframe and slot timing detection towards E-UTRA, and the UE requires measurement gaps for these operations while measurement gaps are either not configured or not sufficient:

2\> if preconfigured measurement gaps for positioning and *posMG-Request* are configured and the UE considers that at least one of the preconfigured measurement gaps for positioning is sufficient for the location measurement when activated:

3\> trigger the lower layers to initiate the measurement gap activation request using UL MAC CE as specified in TS 38.321 \[3\];

2\> else:

3\> initiate the procedure to indicate start as specified in clause 5.5.6.3;

NOTE 1: The UE verifies the measurement gap situation only upon receiving the indication from upper layers. If at this point in time sufficient gaps are available, the UE does not initiate the procedure. Unless it receives a new indication from upper layers, the UE is only allowed to further repeat the procedure in the same PCell once per frequency of the target RAT if the provided measurement gaps are insufficient.

NOTE 1a: When indication is received from upper layers for performing location measurement and there is pre-configured measurement gap configured (not preconfigured measurement gap for positioning), the UE considers this preconfigured measurement gap to be not sufficient if the measurement gap is not considered to be always activated according to clause 9.1.7.2 of TS 38.133 \[14\].

1\> if and only if upper layers indicate to stop performing location measurements towards E-UTRA or NR or stop subframe and slot timing detection towards E-UTRA:

2\> if there is no activated preconfigured measurement gap for positioning:

3\> if there is previously triggered UL MAC CE transmission for the measurement gap activation for positioning:

4\> indicate to the lower layers to cancel the triggered UL MAC CE transmission for the measurement gap activation as specified in TS 38.321 \[3\];

2\> else if there is activated preconfigured measurement gap for positioning:

3\> trigger the lower layers to deactivate all the activated measurement gap(s) for positioning as specified in TS 38.321 \[3\].

2\> if there is configured measurement gap used for positioning and the measurement gap is not the activated preconfigured measurement gap for positioning:

3\> initiate the procedure to indicate stop as specified in 5.5.6.3.

NOTE 2: The UE may initiate the procedure to indicate stop even if it did not previously initiate the procedure to indicate start.

#### 5.5.6.3 Actions related to transmission of *LocationMeasurementIndication* message

The UE shall set the contents of *LocationMeasurementIndication* message as follows:

1\> if the procedure is initiated to indicate start of location related measurements:

2\> if the procedure is initiated for RSTD measurements towards E-UTRA:

3\> set the *measurementIndication* to the *eutra-RSTD* according to the information received from upper layers;

2\> else if the procedure is initiated for positioning measurement towards NR:

3\> set the *measurementIndication* to the *nr-PRS-Measurement* according to the information received from upper layers;

1\> else if the procedure is initiated to indicate stop of location related measurements:

2\> set the *measurementIndication* to the value *release*;

1\> if the procedure is initiated to indicate start of subframe and slot timing detection towards E-UTRA:

2\> set the *measurementIndication* to the value *eutra-FineTimingDetection*;

1\> else if the procedure is initiated to indicate stop of subframe and slot timing detection towards E-UTRA:

2\> set the *measurementIndication* to the value *release*;

1\> submit the *LocationMeasurementIndication* message to lower layers for transmission, upon which the procedure ends.

## 5.5a Logged Measurements

### 5.5a.1 Logged Measurement Configuration

#### 5.5a.1.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
n->u: \iLoggedMeasurementConfiguration\i [ac];
|||;
~~~

Figure 5.5a.1.1-1: Logged measurement configuration

The purpose of this procedure is to configure the UE to perform logging of measurement results while in RRC_IDLE and RRC_INACTIVE. The procedure applies to logged measurements capable UEs that are in RRC_CONNECTED.

NOTE: NG-RAN may retrieve stored logged measurement information by means of the UE information procedure.

#### 5.5a.1.2 Initiation

NG-RAN initiates the logged measurement configuration procedure to UE in RRC_CONNECTED by sending the *LoggedMeasurementConfiguration* message.

#### 5.5a.1.3 Reception of the *LoggedMeasurementConfiguration* by the UE

Upon receiving the *LoggedMeasurementConfiguration* message the UE shall:

1\> discard the logged measurement configuration as well as the logged measurement information as specified in 5.5a.2;

1\> store the received *loggingDuration*, *reportType* and *areaConfiguration*, if included, in *VarLogMeasConfig*;

1\> If the UE is registered in SNPN:

2\> if the *LoggedMeasurementConfiguration* message includes *snpn-ConfigList*:

3\> set the *snpn-ConfigIDList* in *VarLogMeasReport* to include the current registered SNPN ID as well as SNPN IDs in *snpn-ConfigList*;

2\> else:

3\> set the *snpn-ConfigIDList* in *VarLogMeasReport* to include the current registered SNPN ID;

1\> else if the *LoggedMeasurementConfiguration* message includes *plmn-IdentityList*:

2\> set *plmn-IdentityList* in *VarLogMeasReport* to include the RPLMN as well as the PLMNs included in *plmn-IdentityList*;

1\> else:

2\> set *plmn-IdentityList* in *VarLogMeasReport* to include the RPLMN;

1\> store the received *absoluteTimeInfo*, *traceReference,* *traceRecordingSessionRef*, and *tce-Id* in *VarLogMeasReport*;

1\> store the received *bt-NameList*, if included, in *VarLogMeasConfig*;

1\> store the received *wlan-NameList*, if included, in *VarLogMeasConfig*;

1\> store the received *sensor-NameList*, if included, in *VarLogMeasConfig*;

1\> start timer T330 with the timer value set to the *loggingDuration*;

1\> store the received *sigLoggedMeasType,* if included, in *VarLogMeasReport*;

1\> store the received *earlyMeasIndication,* if included, in *VarLogMeasConfig*;

#### 5.5a.1.4 T330 expiry

Upon expiry of T330 the UE shall:

1\> release *VarLogMeasConfig*;

The UE is allowed to discard stored logged measurements, i.e. to release *VarLogMeasReport*, 48 hours after T330 expiry.

### 5.5a.2 Release of Logged Measurement Configuration

#### 5.5a.2.1 General

The purpose of this procedure is to release the logged measurement configuration as well as the logged measurement information.

#### 5.5a.2.2 Initiation

The UE shall initiate the procedure upon receiving a logged measurement configuration in same or another RAT. The UE shall also initiate the procedure upon power off or upon deregistration.

The UE shall:

1\> stop timer T330, if running;

1\> if stored, discard the logged measurement configuration as well as the logged measurement information, i.e. release the UE variables *VarLogMeasConfig* and *VarLogMeasReport*.

### 5.5a.3 Measurements logging

#### 5.5a.3.1 General

This procedure specifies the logging of available measurements by a UE in RRC_IDLE and RRC_INACTIVE that has a logged measurement configuration. The actual process of logging within the UE, takes place in RRC_IDLE state could continue in RRC_INACTIVE state or vice versa.

#### 5.5a.3.2 Initiation

While T330 is running and SDT procedure is not ongoing, the UE shall:

1\> if measurement logging is suspended:

> 2\> if during the last logging interval the IDC problems detected by the UE is resolved, resume measurement logging;

1\> if not suspended, perform the logging in accordance with the following:

2\> if the *reportType* is set to *periodical* in the *VarLogMeasConfig*:

3\> if the UE is in any cell selection state (as specified in TS 38.304 \[20\]):

4\> perform the logging at regular time intervals, as defined by the *loggingInterval* in the *VarLogMeasConfig*;

3\> if the UE is in camped normally state on an NR cell and if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*; or

3\> if the UE is in camped normally state on an NR cell and if the registered SNPN is included in *snpn-ConfigIDList* stored in *VarLogMeasReport*:

4\> if *areaConfiguration* is not included in *VarLogMeasConfig*; or

4\> if the serving cell is part of the area indicated by *areaConfig* in *areaConfiguration* in *VarLogMeasConfig*; or

4\> if the serving cell is part of the area indicated by *cag-ConfigList* in *areaConfiguration* in *VarLogMeasConfig*; or

4\> if the serving cell is part of the area indicated by *snpn-ConfigList* in *areaConfiguration* in *VarLogMeasConfig*:

5\> perform the logging at regular time intervals, as defined by the *loggingInterval* in the *VarLogMeasConfig*;

2\> else if the *reportType* is set to *eventTriggered*, and *eventType* is set to *outOfCoverage*:

3\> perform the logging at regular time intervals as defined by the *loggingInterval* in *VarLogMeasConfig* only when the UE is in any cell selection state;

3\> upon transition from any cell selection state to camped normally state in NR:

4\> if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*, or if the registered SNPN is included in *snpn-ConfigIDList* stored in *VarLogMeasReport*; and

4\> if *areaConfiguration* is not included in *VarLogMeasConfig* or if the current camping cell is part of the area indicated by *areaConfig* of *areaConfiguration* in *VarLogMeasConfig*, or if the current camping cell is part of the area indicated by *cag-ConfigList* of *areaConfiguration* in *VarLogMeasConfig,* or if the current camping cell is part of the area indicated by *snpn-ConfigList* of *areaConfiguration* in *VarLogMeasConfig*:

5\> perform the logging;

2\> else if the *reportType* is set to *eventTriggered* and *eventType* is set to *eventL1*:

3\> if the UE is in camped normally state on an NR cell and if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*; or

3\> if the UE is in camped normally state on an NR cell and if the registered SNPN is included in *snpn-ConfigIDList* stored in *VarLogMeasReport*:

4\> if *areaConfiguration* is not included in *VarLogMeasConfig*; or

4\> if the serving cell is part of the area indicated by *areaConfig* in *areaConfiguration* in *VarLogMeasConfig*; or

4\> if the current serving cell is part of the area indicated by *cag-ConfigList* of *areaConfiguration* in *VarLogMeasConfig,* or if the current camping cell is part of the area indicated by *snpn-ConfigList* of *areaConfiguration* in *VarLogMeasConfig*;

5\> perform the logging at regular time intervals as defined by the *loggingInterval* in *VarLogMeasConfig* only when the conditions indicated by the *eventL1* are met;

2\> when performing the logging:

3\> if *InterFreqTargetInfo* is configured and if the UE detected IDC problems on at least one of the frequencies included in *InterFreqTargetInfo* or any inter-RAT frequency during the last logging interval, or

3\> if *InterFreqTargetInfo* is not configured and if the UE detected IDC problems during the last logging interval:

4\> if *measResultServingCell* in the *VarLogMeasReport* is not empty:

5\> include *inDeviceCoexDetected*;

5\> suspend measurement logging from the next logging interval;

4\> else:

5\> suspend measurement logging;

3\> set the *relativeTimeStamp* to indicate the elapsed time since the moment at which the logged measurement configuration was received;

3\> if location information became available during the last logging interval, set the content of the *locationInfo* as in 5.3.3.7:

3\> if the UE is in any cell selection state (as specified in TS 38.304 \[20\]):

4\> set *anyCellSelectionDetected* to indicate the detection of no suitable or no acceptable cell found;

4\> if the *reportType* is set to *eventTriggered* in the *VarLogMeasConfig*; and

4\> if the RPLMN at the time of entering the any cell selection state is included in *plmn-IdentityList* stored in *VarLogMeasReport*; and

4\> if *areaConfiguration* is not included in *VarLogMeasConfig* or if the last suitable cell that the UE was camping on is part of the area indicated by *areaConfig* of *areaConfiguration* in *VarLogMeasConfig*, or if last suitable cell that the UE was camping on is part of the area indicated by *cag-ConfigList* of *areaConfiguration* in *VarLogMeasConfig,* or if last suitable cell that the UE was camping on is part of the area indicated by *snpn-ConfigList* of *areaConfiguration* in *VarLogMeasConfig*:

5\> set the *servCellIdentity* to indicate global cell identity of the last suitable cell that the UE was camping on;

5\> set the *measResultServingCell* to include the quantities of the last suitable cell the UE was camping on;

4\> else if the *reportType* is set to *periodical* in the *VarLogMeasConfig*:

5\> set the *servCellIdentity* to indicate global cell identity of the last logged cell that the UE was camping on;

5\> set the *measResultServingCell* to include the quantities of the last logged cell the UE was camping on;

3\> else:

4\> set the *servCellIdentity* to indicate global cell identity of the cell the UE is camping on;

Editor´s note: Including list of equivalent SNPN IDs in MDT report is FFS.

4\> set the *measResultServingCell* to include the quantities of the cell the UE is camping on;

3\> if available, set the *measResultNeighCells*, in order of decreasing ranking-criterion as used for cell re-selection, to include measurements of neighbouring cell that became available during the last logging interval and according to the following:

4\> include measurement results for at most 6 neighbouring cells on the NR serving frequency and for at most 3 cells per NR neighbouring frequency and for the NR neighbouring frequencies in accordance with the following:

5\> if *interFreqTargetInfo* is included in *VarLogMeasConfig*:

6\> if *earlyMeasIndication* is included in *VarLogMeasConfig*;

7\> include measurement results for NR neighbouring frequencies that are included in both *interFreqTargetInfo* and either in *measIdleCarrierListNR* (within the *VarMeasIdleConfig*) or *SIB4*;

6\> else:

7\> include measurement results for NR neighbouring frequencies that are included in both *interFreqTargetInfo* and *SIB4*;

5\> else:

6\> if *earlyMeasIndication* is included in *VarLogMeasConfig*;

7\> include measurement results for NR neighbouring frequencies that are included in either *measIdleCarrierListNR* (within the *VarMeasIdleConfig*) or *SIB4*;

6\> else:

7\> include measurement results for NR neighbouring frequencies that are included in *SIB4*;

4\> include measurement results for at most 3 neighbours per inter-RAT frequency in accordance with the following:

5\> if *earlyMeasIndication* is included in *VarLogMeasConfig*:

6\> include measurement results for inter-RAT neighbouring frequencies that are included in either *measIdleCarrierListEUTRA* (within the *VarMeasIdleConfig*) or *SIB5*;

5\> else:

6\> include measurement results for inter-RAT frequencies that are included in *SIB5*;

4\> for each neighbour cell included, include the optional fields that are available;

NOTE 1: The UE includes the latest results of the available measurements as used for cell reselection evaluation in RRC_IDLE or RRC_INACTIVE, which are performed in accordance with the performance requirements as specified in TS 38.133 \[14\].

NOTE 2: For logging the measurements on frequencies (indicated in *measIdleCarrierListNR/ measIdleCarrierListEUTRA*) in the logged measurement, the *qualityThreshold* in *measIdleConfig* should not be applied, and how the UE logs the measurements on the frequencies is left to the UE implementation.

2\> when the memory reserved for the logged measurement information becomes full, stop timer T330 and perform the same actions as performed upon expiry of T330, as specified in 5.5a.1.4.

## 5.5b Application Layer Measurements in RRC_IDLE/RRC_INACTIVE

### 5.5b.1 Area handling and storing of Application Layer Measurement reports in RRC_IDLE/RRC_INACTIVE

#### 5.5b.1.1 General

This procedure specifies the area handling and storing of application layer measurement report containers by a UE in RRC_IDLE and RRC_INACTIVE that has a configuration for application layer measurements in RRC_IDLE and/or RRC_INACTIVE.

#### 5.5b.1.2 Initiation

While in RRC_INACTIVE and RRC_IDLE state, the UE shall:

1\> store any previously or subsequently received application layer measurement report containers associated with the *measConfigAppLayerId* for which no segment, or full message, has been submitted to lower layers for transmission;

1\> if the memory reserved for storing application layer measurement report containers becomes full:

2\> if the UE is configured with *appLayerMeasPriority*:

3\> discard reports in priority order where reports with the lowest priority are discarded first;

2\> else if no *appLayerMeasPriority* is configured:

3\> discard reports in the order they were received, where older reports may be discarded first;

1\> if the current cell when the UE transits from RRC_CONNECTED state to RRC_INACTIVE or RRC_IDLE state is part of the area indicated by *qoe-AreaScope*:

> 2\> inform upper layers of being inside the area;

1\> if the current cell when the UE transits from RRC_CONNECTED state to RRC_INACTIVE or RRC_IDLE state is not part of the area indicated by *qoe-AreaScope*:

2\> inform upper layers of being outside the area.

1\> if a new current cell is part of the area indicated by *qoe-AreaScope* and the previous cell was not part of the area indicated by *qoe-AreaScope*:

> 2\> inform upper layers of being inside the area;

1\> if a new current cell is not part of the area indicated by *qoe-AreaScope* and the previous cell was part of the area indicated by *qoe-AreaScope*:

2\> inform upper layers of being outside the area.

## 5.6 UE capabilities

### 5.6.1 UE capability transfer

#### 5.6.1.1 General

This clause describes how the UE compiles and transfers its UE capability information upon receiving a UECapabilityEnquiry from the network.

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: UECapabilityEnquiry [ac];
u->n: UECapabilityInformation [ac];
|||;
~~~

Figure 5.6.1.1-1: UE capability transfer

#### 5.6.1.2 Initiation

The network initiates the procedure to a UE in RRC_CONNECTED when it needs (additional) UE radio access capability information. The network should retrieve UE capabilities only after AS security activation. Network does not forward UE capabilities that were retrieved before AS security activation to the CN.

#### 5.6.1.3 Reception of the *UECapabilityEnquiry* by the UE

The UE shall set the contents of *UECapabilityInformation* message as follows:

1\> if the *ue-CapabilityRAT-RequestList* contains a *UE-CapabilityRAT-Request* with *rat-Type* set to *nr*:

2\> include in the *ue-CapabilityRAT-ContainerList* a *UE-CapabilityRAT-Container* of the type *UE-NR-Capability* and with the *rat-Type* set to *nr*;

2\> include the *supportedBandCombinationList, featureSets* and *featureSetCombinations* as specified in clause 5.6.1.4;

1\> if the *ue-CapabilityRAT-RequestLis*t contains a *UE-CapabilityRAT-Request* with *rat-Type* set to *eutra-nr*:

2\> if the UE supports (NG)EN-DC or NE-DC:

3\> include in the *ue-CapabilityRAT-ContainerList* a *UE-CapabilityRAT-Container* of the type *UE-MRDC-Capability* and with the *rat-Type* set to *eutra-nr*;

3\> include the *supportedBandCombinationList* and *featureSetCombinations* as specified in clause 5.6.1.4;

1\> if the *ue-CapabilityRAT-RequestList* contains a *UE-CapabilityRAT-Request* with *rat-Type* set to *eutra*:

2\> if the UE supports E-UTRA:

3\> include in the *ue-CapabilityRAT-ContainerList* a *ue-CapabilityRAT-Container* of the type *UE-EUTRA-Capability* associated with the terrestrial network and with the *rat-Type* set to *eutra* as specified in TS 36.331 \[10\], clause 5.6.3.3, according to the *capabilityRequestFilter*, if received;

1\> if the *ue-CapabilityRAT-RequestList* contains a *UE-CapabilityRAT-Request* with *rat-Type* set to *utra-fdd*:

2\> if the UE supports UTRA-FDD:

3\> include the UE radio access capabilities for UTRA-FDD within a *ue-CapabilityRAT-Container* and with the *rat-Type* set to *utra-fdd*;

1\> if the RRC message segmentation is enabled based on the field *rrc-SegAllowed* received, and the encoded RRC message is larger than the maximum supported size of a PDCP SDU specified in TS 38.323 \[5\]:

2\> initiate the UL message segment transfer procedure as specified in clause 5.7.7;

1\> else:

2\> submit the *UECapabilityInformation* message to lower layers for transmission, upon which the procedure ends.

#### 5.6.1.4 Setting band combinations, feature set combinations and feature sets supported by the UE

The UE invokes the procedures in this clause if the NR or E-UTRA network requests UE capabilities for *nr*, *eutra-nr* or *eutra*. This procedure is invoked once per requested *rat-Type* (see clause 5.6.1.3 for capability enquiry by the NR network; see TS 36.331 \[10\], clause 5.6.3.3 for capability enquiry by the E-UTRA network). The UE shall ensure that the feature set IDs are consistent across feature sets, feature set combinations and band combinations in all three UE capability containers that the network queries with the same fields with the same values, i.e. *UE-CapabilityRequestFilterNR,* *UE-CapabilityRequestFilterCommon* and fields in *UECapabilityEnquiry* message (i.e. *requestedFreqBandsNR-MRDC, requestedCapabilityNR, eutra-nr-only* flag, and *requestedCapabilityCommon*) as defined in TS 36.331, where applicable.

NOTE 1: Capability enquiry without *frequencyBandListFilter* is not supported.

NOTE 2: In (NG)EN-DC, the gNB needs the capabilities for RAT types *nr* and *eutra-nr* and it uses the *featureSets* in the *UE-NR-Capability* together with the *featureSetCombinations* in the *UE-MRDC-Capability* to determine the NR UE capabilities for the supported MRDC band combinations. Similarly, the eNB needs the capabilities for RAT types *eutra* and *eutra-nr* and it uses the *featureSetsEUTRA* in the *UE-EUTRA-Capability* together with the *featureSetCombinations* in the *UE-MRDC-Capability* to determine the E-UTRA UE capabilities for the supported MRDC band combinations. Hence, the IDs used in the *featureSets* must match the IDs referred to in *featureSetCombinations* across all three containers. The requirement on consistency implies that there are no undefined feature sets and feature set combinations.

NOTE 3: If the UE cannot include all feature sets and feature set combinations due to message size or list size constraints, it is up to UE implementation which feature sets and feature set combinations it prioritizes.

The UE shall:

1\> if the UE is an eRedCap UE, the UE may in the remainder of this procedure assume *frequencyBandListFilter* to be the filter containing all the supported bands of the UE;

1\> compile a list of \"candidate band combinations\" according to the filter criteria in *capabilityRequestFilterCommon* (if included), only consisting of bands included in *frequencyBandListFilter*, and prioritized in the order of *frequencyBandListFilter* (i.e. first include band combinations containing the first-listed band, then include remaining band combinations containing the second-listed band, and so on), where for each band in the band combination, the parameters of the band do not exceed *maxBandwidthRequestedDL*, *maxBandwidthRequestedUL*, *maxCarriersRequestedDL*, *maxCarriersRequestedUL*, *ca-BandwidthClassDL-EUTRA* or *ca-BandwidthClassUL-EUTRA*, whichever are received;

1\> for each band combination included in the list of \"candidate band combinations\":

2\> if the network (E-UTRA) included the *eutra-nr-only* field, or

2\> if the requested *rat-Type* is *eutra*:

3\> remove the NR-only band combination from the list of \"candidate band combinations\";

NOTE 4: The (E-UTRA) network may request capabilities for *nr* but indicate with the *eutra-nr-only* flag that the UE shall not include any NR band combinations in the *UE-NR-Capability*. In this case the procedural text above removes all NR-only band combinations from the candidate list and thereby also avoids inclusion of corresponding feature set combinations and feature sets below.

2\> if it is regarded as a fallback band combination with the same capabilities of another band combination included in the list of \"candidate band combinations\", and

2\> if this fallback band combination is generated by releasing at least one SCell or uplink configuration of SCell or SUL according to TS 38.306 \[26\]:

3\> remove the band combination from the list of \"candidate band combinations\";

NOTE 5: Even if the network requests (only) capabilities for *nr*, it may include E-UTRA band numbers in the *frequencyBandListFilter* to ensure that the UE includes all necessary feature sets needed for subsequently requested *eutra-nr* capabilities. At this point of the procedure the list of \"candidate band combinations\" contains all NR- and/or E-UTRA-NR band combinations that match the filter (*frequencyBandListFilter*) provided by the NW and that match the *eutra-nr-only* flag (if RAT-Type *nr* is requested by E-UTRA). In the following, this candidate list is used to derive the band combinations, feature set combinations and feature sets to be reported in the requested capability container.

1\> if the requested *rat-Type* is *nr*:

2\> include into *supportedBandCombinationList* as many NR-only band combinations as possible from the list of \"candidate band combinations\", starting from the first entry;

3\> if *srs-SwitchingTimeRequest* is received:

4\> if SRS carrier switching is supported;

5\> include *srs-SwitchingTimesListNR* and *srs-SwitchingAffectedBandsListNR* for each band combination;

4\> set *srs-SwitchingTimeRequested* to *true*;

2\> include, into *featureSetCombinations*, the feature set combinations referenced from the supported band combinations as included in *supportedBandCombinationList* according to the previous;

2\> compile a list of \"candidate feature set combinations\" referenced from the list of \"candidate band combinations\" excluding entries (rows in feature set combinations) with same or lower capabilities;

2\> if *uplinkTxSwitchRequest* is received:

3\> include into *supportedBandCombinationList-UplinkTxSwitch* as many NR-only band combinations that supported UL TX switching as possible from the list of \"candidate band combinations\", starting from the first entry;

4\> if *srs-SwitchingTimeRequest* is received:

5\> if SRS carrier switching is supported;

6\> include *srs-SwitchingTimesListNR* and *srs-SwitchingAffectedBandsListNR* for each band combination;

5\> set *srs-SwitchingTimeRequested* to *true*;

3\> include, into *featureSetCombinations*, the feature set combinations referenced from the supported band combinations as included in s*upportedBandCombinationList-UplinkTxSwitch* according to the previous;

NOTE 6: This list of \"candidate feature set combinations\" contains the feature set combinations used for NR-only as well as E-UTRA-NR band combinations. It is used to derive a list of NR feature sets referred to from the feature set combinations in the *UE-NR-Capability* and from the feature set combinations in a *UE-MRDC-Capability* container.

2\> if *sidelinkRequest* is received:

3\> for a sidelink band combination the UE included in *supportedBandCombinationListSidelinkEUTRA-NR*, *supportedBandCombinationListSL-RelayDiscovery, supportedBandCombinationListSL-U2U-RelayDiscovery* or *supportedBandCombinationListSL-NonRelayDiscovery*:

4\> if the UE supports partial sensing for a band of the sidelink band combination, include the partial sensing capabilities for the band using the *sl-TransmissionMode2-PartialSensing-r17*;

3\> set *sidelinkRequested* to *true*;

2\> include into *featureSets* the feature sets referenced from the \"candidate feature set combinations\" and may exclude the feature sets with the parameters that exceed any of *maxBandwidthRequestedDL*, *maxBandwidthRequestedUL*, *maxCarriersRequestedDL* or *maxCarriersRequestedUL*, whichever are received;

1\> else, if the requested *rat-Type* is *eutra-nr*:

2\> include into *supportedBandCombinationList* and/or *supportedBandCombinationListNEDC-Only* as many E-UTRA-NR band combinations as possible from the list of \"candidate band combinations\", starting from the first entry;

3\> if *srs-SwitchingTimeRequest* is received:

4\> if SRS carrier switching is supported;

5\> include *srs-SwitchingTimesListNR*, *srs-SwitchingTimesListEUTRA* and *srs-SwitchingAffectedBandsListNR* for each band combination;

4\> set *srs-SwitchingTimeRequested* to *true*;

2\> include, into *featureSetCombinations*, the feature set combinations referenced from the supported band combinations as included in *supportedBandCombinationList* according to the previous;

2\> if *uplinkTxSwitchRequest* is received:

3\> include into *supportedBandCombinationList-UplinkTxSwitch* as many E-UTRA-NR band combinations that supported UL TX switching as possible from the list of \"candidate band combinations\", starting from the first entry;

4\> if *srs-SwitchingTimeRequest* is received:

5\> if SRS carrier switching is supported;

6\> include *srs-SwitchingTimesListNR*, *srs-SwitchingTimesListEUTRA* and *srs-SwitchingAffectedBandsListNR* for each band combination;

5\> set *srs-SwitchingTimeRequested* to *true*;

3\> include, into *featureSetCombinations*, the feature set combinations referenced from the supported band combinations as included in *supportedBandCombinationList-UplinkTxSwitch* according to the previous;

1\> else (if the requested *rat-Type* is *eutra*):

2\> compile a list of \"candidate feature set combinations\" referenced from the list of \"candidate band combinations\" excluding entries (rows in feature set combinations) with same or lower capabilities;

NOTE 7: This list of \"candidate feature set combinations\" contains the feature set combinations used for E-UTRA-NR band combinations. It is used to derive a list of E-UTRA feature sets referred to from the feature set combinations in a *UE-MRDC-Capability* container.

2\> include into *featureSetsEUTRA* (in the *UE-EUTRA-Capability*) the feature sets referenced from the \"candidate feature set combinations\" and may exclude the feature sets with the parameters that exceed *ca-BandwidthClassDL-EUTRA* or *ca-BandwidthClassUL-EUTRA*, whichever are received;

1\> if the UE is an eRedCap UE and the UE assumes *frequencyBandListFilter* to be the filter containing all the supported bands of the UE:

2\> include all the supported bands of the UE in the field *appliedFreqBandListFilter*;

1\> else:

2\> include the received *frequencyBandListFilter* in the field *appliedFreqBandListFilter* of the requested UE capability, except if the requested *rat-Type* is *nr* and the network included the *eutra-nr-only* field;

1\> if the network included *ue-CapabilityEnquiryExt*:

2\> include the received *ue-CapabilityEnquiryExt* in the field *receivedFilters*;

#### 5.6.1.5 Void

## 5.7 Other

### 5.7.1 DL information transfer

#### 5.7.1.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: DLInformationTransfer [ac];
|||;
~~~

Figure 5.7.1.1-1: DL information transfer

The purpose of this procedure is to transfer NAS dedicated information from NG-RAN to a UE in RRC_CONNECTED or to a UE in RRC_INACTIVE during SDT, or to transfer F1-C related information from IAB Donor-CU to IAB-DU via the collocated IAB-MT in RRC_CONNECTED.

#### 5.7.1.2 Initiation

The network initiates the DL information transfer procedure whenever there is a need to transfer NAS dedicated information, or F1-C related information to an IAB-node. The network initiates the DL information transfer procedure by sending the *DLInformationTransfer* message.

#### 5.7.1.3 Reception of the *DLInformationTransfer* by the UE

Upon receiving *DLInformationTransfer* message, the UE shall:

1\> if *dedicatedNAS-Message* is included:

2\> forward *dedicatedNAS-Message* to upper layers.

1\> if *referenceTimeInfo* is included:

2\> calculate the reference time based on the *time*, *referenceSFN* and *timeInfoType* if it is included;

2\> calculate the uncertainty of the reference time based on the *uncertainty*, if *uncertainty* is included;

2\> inform upper layers of the reference time and, if *uncertainty* is included, of the uncertainty;

2\> ignore all further *referenceTimeInfo* received in *SIB9*, if any.

1\> if *sib9Fallback* is included:

2\> apply *referenceTimeInfo* in SIB9.

1\> if *rxTxTimeDiff-gNB* is included:

2\> calculate the propagation delay based on the UE Rx-Tx time difference measurement and the received Rx-Tx time difference measurement at the gNB;

2\> inform upper layers of the propagation delay.

1\> if *ta-PDC* is set to *activate*:

2\> inform upper layers of the propagation delay determined by the accumulated Timing Advance commands.

1\> if *clockQualityDetailsLevel* is included:

2\> if *eventID-TSS* is included:

3\> if *VarEventID* has an entry with a *storedEventID* value:

4\> replace the *storedEventID* value within *VarEventID* with the *eventID-TSS* value received with *clockQualityDetailsLevel;*

3\> else:

4\> add a new entry of *storedEventID* within the *VarEventID* with a value set as the one of *eventID-TSS* value received with *clockQualityDetailsLevel;*

2\> if the *VarGnbID* has an entry with a *storedGnbID* value:

3\> replace the *storedGnbID* value within *VarGnbID* with the gNB identity value received within *SIB1*;

2\> else:

3\> add a new entry of *storedGnbID* within the *VarGnbID* with the gNB identity value received within *SIB1.*

2\> forward *clockQualityDetailsLevel* to upper layers.

Upon receiving *DLInformationTransfer* message, the IAB-MT shall:

1\> if *dedicatedInfoF1c* is included:

2\> forward *dedicatedInfoF1c* to the collocated IAB-DU.

### 5.7.1a DL information transfer for MR-DC

#### 5.7.1a.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
n->u: DLInformationTransferMRDC [ac];
|||;
~~~

Figure 5.7.1a.1-1: DL information transfer MR-DC

The purpose of this procedure is to transfer RRC messages from the network to the UE over SRB3 (e.g. an NR RRC reconfiguration message including *reconfigurationWithSync*, an E-UTRA RRC connection reconfiguration message including *mobilityControlInfo*, an RRC connection release message, a *MobilityFromNRCommand* message, or a *MobilityFromEUTRACommand* message) during fast MCG link recovery.

#### 5.7.1a.2 Initiation

The network initiates this procedure whenever there is a need to transfer an RRC message during fast MCG link recovery.

#### 5.7.1a.3 Actions related to reception of *DLInformationTransferMRDC* message

Upon receiving the *DLInformationTransferMRDC*, the UE shall:

1\> if the *RRCReconfiguration* message is included in *dl-DCCH-MessageNR*:

2\> perform the RRC reconfiguration procedure according to 5.3.5.3;

1\> else if the *RRCRelease* message is included in *dl-DCCH-MessageNR*:

2\> perform the RRC release procedure according to 5.3.8;

1\> else if the *MobilityFromNRCommand* message is included in the *dl-DCCH-MessageNR*:

2\> perform the mobility from NR procedure according to 5.4.3.3;

1\> else if the E-UTRA *RRCConnectionReconfiguration* message is included in *dl-DCCH-MessageEUTRA*:

2\> perform the RRC connection reconfiguration procedure as specified in TS 36.331 \[10\], clause 5.3.5.4;

1\> else if the E-UTRA *RRCConnectionRelease* message is included in *dl-DCCH-MessageEUTRA*:

2\> perform the RRC connection release as specified in TS 36.331 \[10\], clause 5.3.8;

1\> else if the *MobilityFromEUTRACommand* message is included in the *dl-DCCH-MessageEUTRA*:

2\> perform the mobility from E-UTRA procedure as specified in TS 36.331 \[10\], clause 5.4.3.3;

### 5.7.2 UL information transfer

#### 5.7.2.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: ULInformationTransfer [ac];
|||;
~~~

Figure 5.7.2.1-1: UL information transfer

The purpose of this procedure is to transfer NAS dedicated information from the UE to the network in RRC_CONNECTED or in RRC_INACTIVE during SDT, or to transfer F1-C related information from IAB-DU to IAB Donor-CU via the collocated IAB-MT in RRC_CONNECTED.

#### 5.7.2.2 Initiation

A UE in RRC_CONNECTED or a UE in RRC_INACTIVE during SDT initiates the UL information transfer procedure whenever there is a need to transfer NAS dedicated information. The UE initiates the UL information transfer procedure by sending the ULInformationTransfer message. In addition, an IAB-MT in RRC_CONNECTED initiates the UL information transfer procedure whenever there is a need to transfer F1-C related information. When F1-C related information has to be transferred, the IAB-MT shall initiate the procedure only if SRB2 or split SRB2 is established.

#### 5.7.2.3 Actions related to transmission of *ULInformationTransfer* message

The UE shall set the contents of the *ULInformationTransfer* message as follows:

1\> if the upper layer provides NAS PDU:

2\> set the *dedicatedNAS-Message* to include the information received from upper layers;

1\> for the IAB-MT, if there is a need to transfer F1-C related information:

2\> include the *dedicatedInfoF1c*;

1\> submit the *ULInformationTransfer* message to lower layers for transmission, upon which the procedure ends.

#### 5.7.2.4 Failure to deliver *ULInformationTransfer* message

The UE shall:

1\> if AS security is not started and radio link failure occurs before the successful delivery of *ULInformationTransfer* messages has been confirmed by lower layers; or

1\> if PDCP re-establishment or release/addition (e.g due to key refresh upon PCell or PSCell change, or RRC connection re-establishment, or failure of resume procedure initiated for SDT) occurs on an SRB on which *ULInformationTransfer* messages were submitted for transmission but successful delivery of these messages was not confirmed by lower layers:

2\> inform upper layers about the possible failure to deliver the information contained in the concerned *ULInformationTransfer* messages, unless the messages only include *dedicatedInfoF1c*.

### 5.7.2a UL information transfer for MR-DC

#### 5.7.2a.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: ULInformationTransferMRDC [ac];
|||;
~~~

Figure 5.7.2a.1-1: UL information transfer MR-DC

The purpose of this procedure is to transfer MR-DC dedicated information from the UE to the network e.g. the NR or E-UTRA RRC *MeasurementReport,* *FailureInformation, UEAssistanceInformation, RRCReconfigurationComplete,* *MCGFailureInformation*, or *IABOtherInformation* message.

#### 5.7.2a.2 Initiation

A UE in RRC_CONNECTED initiates the UL information transfer for MR-DC procedure whenever there is a need to transfer MR-DC dedicated information. I.e. the procedure is not used during an RRC connection reconfiguration involving NR or E-UTRA connection reconfiguration, in which case the MR DC information is piggybacked to the *RRCReconfigurationComplete* message, except in the case the UE executes an intra-SN CPC.

#### 5.7.2a.3 Actions related to transmission of *ULInformationTransferMRDC* message

The UE shall set the contents of the *ULInformationTransferMRDC* message as follows:

1\> if there is a need to transfer MR-DC dedicated information related to NR:

2\> set the *ul-DCCH-MessageNR* to include the NR MR-DC dedicated information to be transferred (e.g., NR RRC *MeasurementReport,* *UEAssistanceInformation*, *FailureInformation, RRCReconfigurationComplete,* *MCGFailureInformation*, or *IABOtherInformation* message);

1\> else if there is a need to transfer MR-DC dedicated information related to E-UTRA:

2\> set the *ul-DCCH-MessageEUTRA* to include the E-UTRA MR-DC dedicated information to be transferred (e.g., E-UTRA RRC *MeasurementReport,* or *MCGFailureInformation* message);

1\> submit the *ULInformationTransferMRDC* message to lower layers for transmission, upon which the procedure ends.

### 5.7.2b UL transfer of IRAT information

#### 5.7.2b.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: NR;

|||;
u->n: \iULInformationTransferIRAT\i [ac];
|||;
~~~

Figure 5.7.2b.1-1: UL transfer of IRAT information

The purpose of this procedure is to transfer from the UE to NR MCG dedicated information terminated at the NR MCG but specified by another RAT e.g. the E-UTRA *MeasurementReport* message, the E-UTRA *SidelinkUEInformation* message or the E-UTRA *UEAssistanceInformation* message. The specific information transferred in this message is set in accordance with:

- the procedure specified in 5.6.10 of TS 36.331 \[10\] for E-UTRA *UEAssistanceInformation* message;

- the procedure specified in 5.10.2 of TS 36.331 \[10\] for E-UTRA *SidelinkUEInformation* message;

- the procedure specified in 5.5.5 of TS 36.331 \[10\] for E-UTRA *MeasurementReport* Message.

#### 5.7.2b.2 Initiation

A UE in RRC_CONNECTED initiates the UL information transfer procedure whenever there is a need to transfer dedicated inter-RAT information as specified in TS 36.331 \[10\].

#### 5.7.2b.3 Actions related to transmission of *ULInformationTransferIRAT* message

The UE shall set the contents of the *ULInformationTransferIRAT* message as follows:

1\> if there is a need to transfer dedicated LTE information related to V2X sidelink communications:

2\> set the *ul-DCCH-MessageEUTRA* to include the V2X sidelink communication information to be transferred (e.g. the E-UTRA RRC *MeasurementReport* message, the E-UTRA RRC *SidelinkUEInformation* message, or the E-UTRA RRC *UEAssistanceInformation* message);

1\> submit the *ULInformationTransferIRAT* message to lower layers for transmission, upon which the procedure ends;

### 5.7.3 SCG failure information

#### 5.7.3.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<=>n: RRC reconfiguration[au];
u->n: SCGFailureInformation [ac];
|||;
~~~

Figure 5.7.3.1-1: SCG failure information

The purpose of this procedure is to inform E-UTRAN or NR MN about an SCG failure the UE has experienced i.e. SCG radio link failure, beam failure of the PSCell while the SCG is deactivated, failure of SCG reconfiguration with sync, SCG configuration failure for RRC message on SRB3, SCG integrity check failure, and consistent uplink LBT failures on PSCell for operation with shared spectrum channel access.

#### 5.7.3.2 Initiation

A UE initiates the procedure to report SCG failures when neither MCG nor SCG transmission is suspended and when one of the following conditions is met:

1\> upon detecting radio link failure for the SCG, in accordance with clause 5.3.10.3;

1\> upon detecting beam failure of the PSCell while the SCG is deactivated, in accordance with TS 38.321\[3\];

1\> upon reconfiguration with sync failure of the SCG, in accordance with clause 5.3.5.8.3;

1\> upon SCG configuration failure, in accordance with clause 5.3.5.8.2;

1\> upon integrity check failure indication from SCG lower layers concerning SRB3.

Upon initiating the procedure, the UE shall:

1\> if the procedure was not initiated due to beam failure of the PSCell while the SCG is deactivated:

2\> suspend SCG transmission for all SRBs, DRBs and, if any, BH RLC channels;

2\> reset SCG MAC;

1\> stop T304 for the SCG, if running;

1\> stop conditional reconfiguration evaluation for CPC, CPA, or subsequent CPAC, if configured;

1\> stop conditional reconfiguration evaluation for each CHO configuration that includes *condExecutionCondPSCell*, if configured;

1\> if the UE is in (NG)EN-DC:

2\> initiate transmission of the *SCGFailureInformationNR* message as specified in TS 36.331 \[10\], clause 5.6.13a.

1\> else:

2\> initiate transmission of the *SCGFailureInformation* message in accordance with 5.7.3.5.

#### 5.7.3.3 Failure type determination for (NG)EN-DC

The UE shall set the SCG failure type as follows:

1\> if the UE initiates transmission of the *SCGFailureInformationNR* message due to T310 expiry:

2\> set the *failureType* as t310-Expiry;

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message due to T312 expiry:

2\> set the *failureType* as any value and set the *failureType-v1610* as t312-Expiry;

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message to provide reconfiguration with sync failure information for an SCG:

2\> set the *failureType* as *synchReconfigFailureSCG*;

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message to provide random access problem indication from SCG MAC:

2\> if the random access procedure was initiated for beam failure recovery:

3\> set the *failureType* as *randomAccessProblem* and set the *failureType-v1610* as *beamFailureRecoveryFailure*;

2\> else:

3\> set the *failureType* as *randomAccessProblem*;

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message to provide indication from SCG RLC that the maximum number of retransmissions has been reached:

2\> set the *failureType* as *rlc-MaxNumRetx*;

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message due to SRB3 integrity check failure:

2\> set the *failureType* as *srb3-IntegrityFailure*;

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message due to Reconfiguration failure of NR RRC reconfiguration message:

2\> set the *failureType* as *scg-reconfigFailure*;

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message due to consistent uplink LBT failures:

2\> set the *failureType* as any value and set the *failureType-v1610* as *scg-lbtFailure*;

1\> else if connected as an IAB-node and the *SCGFailureInformationNR* is initiated due to the reception of a BH RLF indication on BAP entity from the SCG:

2\> set the *failureType* as any value and set *failureType-v1610* as *bh-RLF*.

1\> else if the UE initiates transmission of the *SCGFailureInformationNR* message due to beam failure of the PSCell while the SCG is deactivated:

2\> set the *failureType* as any value and set *failureType-v1610* as *beamFailure*.

#### 5.7.3.4 Setting the contents of *MeasResultSCG-Failure*

The UE shall set the contents of the *MeasResultSCG-Failure* as follows:

1\> for each *MeasObjectNR* configured on NR SCG for which a *measId* is configured and measurement results are available:

2\> include an entry in *measResultPerMOList*;

2\> if there is a *measId* configured with the *MeasObjectNR* and a *reportConfig* which has *rsType* set to *ssb*:

3\> set *ssbFrequency* to the value indicated by *ssbFrequency* as included in the *MeasObjectNR*;

2\> if there is a *measId* configured with the *MeasObjectNR* and a *reportConfig* which has *rsType* set to *csi-rs*:

3\> set *refFreqCSI-RS* to the value indicated by *refFreqCSI-RS* as included in the associated measurement object;

2\> if a serving cell is associated with the *MeasObjectNR*:

3\> set *measResultServingCell* to include the available quantities of the concerned cell and in accordance with the performance requirements in TS 38.133 \[14\];

2\> set the *measResultNeighCellList* to include the best measured cells, ordered such that the best cell is listed first, and based on measurements collected up to the moment the UE detected the failure, and set its fields as follows;

3\> ordering the cells with sorting as follows:

4\> based on SS/PBCH block if SS/PBCH block measurement results are available and otherwise based on CSI-RS;

4\> using RSRP if RSRP measurement results are available, otherwise using RSRQ if RSRQ measurement results are available, otherwise using SINR;

3\> for each neighbour cell included:

4\> include the optional fields that are available.

NOTE: The measured quantities are filtered by the L3 filter as configured in the mobility measurement configuration. The measurements are based on the time domain measurement resource restriction, if configured. Exclude-listed cells are not required to be reported.

1\> if available, set the *locationInfo* as in 5.3.3.7 according to the *otherConfig* associated with the NR SCG.

#### 5.7.3.5 Actions related to transmission of *SCGFailureInformation* message

The UE shall set the contents of the *SCGFailureInformation* message as follows:

1\> if the UE initiates transmission of the *SCGFailureInformation* message due to T310 expiry:

2\> set the *failureType* as *t310-Expiry*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message due to T312 expiry:

2\> set the *failureType* as *other* and set the *failureType-v1610* as *t312-Expiry*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message to provide reconfiguration with sync failure information for an SCG:

2\> set the *failureType* as *synchReconfigFailureSCG*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message to provide random access problem indication from SCG MAC:

2\> if the random access procedure was initiated for beam failure recovery:

3\> set the *failureType* as *other* and set the *failureType-v1610* as *beamFailureRecoveryFailure*;

2\> else:

3\> set the *failureTyp*e as *randomAccessProblem*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message to provide indication from SCG RLC that the maximum number of retransmissions has been reached:

2\> set the *failureType* as *rlc-MaxNumRetx*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message due to SRB3 IP check failure:

2\> set the *failureType* as *srb3-IntegrityFailure*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message due to Reconfiguration failure of NR RRC reconfiguration message:

2\> set the *failureType* as *scg-reconfigFailure*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message due to consistent uplink LBT failures:

2\> set the *failureType* as *other* and set the *failureType-v1610* as *scg-lbtFailure*;

1\> else if connected as an IAB-node and the *SCGFailureInformation* is initiated due to the reception of a BH RLF indication on BAP entity from the SCG:

2\> set the *failureType* as *other* and set *failureType-v1610* as *bh-RLF*;

1\> else if the UE initiates transmission of the *SCGFailureInformation* message due to beam failure of the PSCell while the SCG is deactivated:

2\> set the *failureType* as *other* and set *failureType-v1610* as *beamFailure;*

1\> include and set *MeasResultSCG*-Failure in accordance with 5.7.3.4;

1\> for each *MeasObjectNR* configured by a *MeasConfig* associated with the MCG, and for which measurement results are available:

2\> include an entry in *measResultFreqList*;

2\> if there is a *measId* configured with the *MeasObjectNR* and a *reportConfig* which has *rsType* set to *ssb*:

3\> set *ssbFrequency* in *measResultFreqList* to the value indicated by *ssbFrequency* as included in the *MeasObjectNR*;

2\> if there is a *measId* configured with the *MeasObjectNR* and a *reportConfig* which has *rsType* set to *csi-rs*:

3\> set *refFreqCSI-RS* in *measResultFreqList* to the value indicated by *refFreqCSI-RS* as included in the associated measurement object;

2\> if a serving cell is associated with the *MeasObjectNR*:

3\> set *measResultServingCell* in *measResultFreqList* to include the available quantities of the concerned cell and in accordance with the performance requirements in TS 38.133 \[14\];

2\> set the *measResultNeighCellList* in *measResultFreqList* to include the best measured cells, ordered such that the best cell is listed first, and based on measurements collected up to the moment the UE detected the failure, and set its fields as follows;

3\> ordering the cells with sorting as follows:

4\> based on SS/PBCH block if SS/PBCH block measurement results are available and otherwise based on CSI-RS;

4\> using RSRP if RSRP measurement results are available, otherwise using RSRQ if RSRQ measurement results are available, otherwise using SINR;

3\> if the UE supports SCG failure information for mobility robustness optimization for conditional PSCell change or addition, for each neighbour cell, if any, included in *measResultListNR* in *measResultFreqList*:

4\> if the neighbour cell is one of the candidate cells for which the *reconfigurationWithSync* is included in the *secondaryCellGroup* in the MCG *VarConditionalReconfig* (for CPA or inter-SN CPC in NR-DC) or SCG *VarConditionalReconfig* (for intra-SN CPC) at the moment of the detected SCG failure (radio link failure at PSCell or PSCell change or addition failure):

5\> if the first entry of *choConfig* corresponds to a fulfilled execution condition at the moment of SCG failure; or

5\> if the second entry of *choConfig*, if available, corresponds to a fulfilled execution condition at the moment of SCG failure:

6\> set *firstTriggeredEvent* to the execution condition *condFirstEvent* corresponding to the first entry of *choConfig* or to the execution condition *condSecondEvent* corresponding to the second entry of *choConfig*, whichever execution condition was fulfilled first in time;

6\> set *timeBetweenEvents* to the elapsed time between the point in time of fulfilling the condition in *choConfig* that was fulfilled first in time, and the point in time of fulfilling the condition in *choConfig* that was fulfilled second in time, if both the first execution condition corresponding to the first entry and the second execution condition corresponding to the second entry in the *choConfig* were fulfilled;

3\> for each neighbour cell included:

4\> include the optional fields that are available.

NOTE 1: The measured quantities are filtered by the L3 filter as configured in the mobility measurement configuration. The measurements are based on the time domain measurement resource restriction, if configured. Exclude-listed cells are not required to be reported.

NOTE 2: Field *measResultSCG-Failure* is used to report available results for NR frequencies the UE is configured to measure by SCG RRC signalling.

1\> if available, set the *locationInfo* as in 5.3.3.7 according to the *otherConfig* associated with the NR MCG.

1\> if the UE supports SCG failure for mobility robustness optimization:

2\> if the *failureType* is set to *synchReconfigFailureSCG*; or

2\> if the *failureType* is set to *randomAccessProblem* and the SCG failure was declared while T304 was running:

3\> set *perRAInfoList* to indicate the performed random access procedure related information as specified in 5.7.10.5.

3\> set the *failedPSCellId* to the physical cell identity and carrier frequency of the target PSCell of the failed PSCell change;

3\> set the *previousPSCellId* to the physical cell identity and carrier frequency of the source PSCell associated to the last received *RRCReconfiguration* message including *reconfigurationWithSync* for the SCG, if available;

3\> set the *timeSCGFailure* to the elapsed time since the last execution of *RRCReconfiguration* message including the *reconfigurationWithSync* for the SCG until declaring the SCG failure;

2\> else:

3\> set the *failedPSCellId* to the physical cell identity and carrier frequency of the PSCell in which the SCG failure was declared;

3\> if the last *RRCReconfiguration* message including the *reconfigurationWithSync* for the SCG was received to enter the PSCell in which the SCG failure was declared:

4\> set the *timeSCGFailure* to the elapsed time since the last execution of *RRCReconfiguration* message including the *reconfigurationWithSync* for the SCG until declaring the SCG failure;

4\> set the *previousPSCellId* to the physical cell identity and carrier frequency of the source PSCell associated to the last received *RRCReconfiguration* message including *reconfigurationWithSync* for the SCG;

1\> release *successPSCell-Config* configured by the source PSCell, if available.

The UE shall submit the *SCGFailureInformation* message to lower layers for transmission.

### 5.7.3a EUTRA SCG failure information

#### 5.7.3a.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<=>n: RRC reconfiguration[au];
u->n: SCGFailureInformationEUTRA [ac];
|||;
~~~

Figure 5.7.3a.1-1: EUTRA SCG failure information

The purpose of this procedure is to inform NR MN about an SCG failure on E-UTRA SN the UE has experienced (e.g. SCG radio link failure, SCG change failure), as specified in TS 36.331 \[10\] clause 5.6.13.2.

#### 5.7.3a.2 Initiation

A UE initiates the procedure to report EUTRA SCG failures when neither NR MCG nor EUTRA SCG transmission is suspended and in accordance with TS 36.331 \[10\] clause 5.6.13.2. Actions the UE shall perform upon initiating the procedure, other than related to the transmission of the *SCGFailureInformationEUTRA* message are specified in TS 36.331 \[10\] clause 5.6.13.2.

#### 5.7.3a.3 Actions related to transmission of *SCGFailureInformationEUTRA* message

The UE shall set the contents of the *SCGFailureInformationEUTRA* message as follows:

1\> include *failureType* within *failureReportSCG-EUTRA* and set it to indicate the SCG failure in accordance with TS 36.331 \[10\] clause 5.6.13.4;

1\> include and set *measResultSCG-FailureMRDC* in accordance with TS 36.331 \[10\] clause 5.6.13.5;

1\> for each EUTRA frequency the UE is configured to measure by *measConfig* for which measurement results are available:

2\> set the *measResultFreqListMRDC* to include the best measured cells, ordered such that the best cell is listed first using RSRP to order if RSRP measurement results are available for cells on this frequency, otherwise using RSRQ to order if RSRQ measurement results are available for cells on this frequency, otherwise using SINR to order, and based on measurements collected up to the moment the UE detected the failure, and for each cell that is included, include the optional fields that are available;

NOTE: Field *measResultSCG-FailureMRDC* is used to report available results for E-UTRAN frequencies the UE is configured to measure by E-UTRA RRC signalling.

1\> if available, set the *locationInfo* as in 5.3.3.7.:

The UE shall submit the *SCGFailureInformationEUTRA* message to lower layers for transmission.

### 5.7.3b MCG failure information

#### 5.7.3b.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<=>n: RRC reconfiguration[au];
u->n: \iMCGFailureInformation\i [ac];
|||;
~~~

Figure 5.7.3b.1-1: MCG failure information

The purpose of this procedure is to inform the network about an MCG failure the UE has experienced i.e. MCG radio link failure. A UE in RRC_CONNECTED, for which AS security has been activated with SRB2 and at least one DRB or multicast MRB setup or, for IAB, SRB2, may initiate the fast MCG link recovery procedure in order to continue the RRC connection without re-establishment.

#### 5.7.3b.2 Initiation

In case of MR-DC, a UE configured with split SRB1 or SRB3 initiates the procedure to report MCG failures when neither MCG nor SCG transmission is suspended, the SCG is not deactivated, *t316* is configured, and when the following condition is met; or

In case of MP, a MP remote UE configured with split SRB1 initiates the procedure to report direct path failures when neither MCG (i.e. direct path) nor indirect path transmission is suspended, *t316* is configured, and when the following condition is met:

1\> upon detecting radio link failure of the MCG, in accordance with 5.3.10.3, while T316 is not running.

Upon initiating the procedure, the UE shall:

1\> stop timer T310 for the PCell, if running;

1\> stop timer T312 for the PCell, if running;

1\> suspend MCG transmission for all SRBs, DRBs, multicast MRBs, except SRB0, and, if any, BH RLC channels;

1\> reset MCG MAC;

1\> stop conditional reconfiguration evaluation for CHO, if configured;

1\> stop conditional reconfiguration evaluation for CPC or subsequent CPAC, if configured;

1\> initiate transmission of the *MCGFailureInformation* message in accordance with 5.7.3b.4.

NOTE: The handling of any outstanding UL RRC messages during the initiation of the fast MCG link recovery is left to UE implementation.

#### 5.7.3b.3 Failure type determination

The UE shall set the MCG failure type as follows:

1\> if the UE initiates transmission of the *MCGFailureInformation* message due to T310 expiry:

2\> set the *failureType* as *t310-Expiry*;

1\> else if the UE initiates transmission of the *MCGFailureInformation* message due to T312 expiry:

2\> set the *failureType* as *t312-Expiry*;

1\> else if the UE initiates transmission of the *MCGFailureInformation* message to provide random access problem indication from MCG MAC:

2\> if the random access procedure was initiated for beam failure recovery:

3\> set the *failureType* as *beamFailureRecoveryFailure*;

2\> else:

3\> set the *failureType* as *randomAccessProblem*;

1\> else if the UE initiates transmission of the *MCGFailureInformation* message to provide indication from MCG RLC that the maximum number of retransmissions has been reached:

2\> set the *failureType* as *rlc-MaxNumRetx*:

1\> else if the UE initiates transmission of the *MCGFailureInformation* message due to consistent uplink LBT failures on the MCG:

2\> set the *failureType* as *lbt-Failure*;

1\> else if connected as an IAB-node and the *MCGFailureInformation* message is initiated due to the reception of a BH RLF indication on BAP entity from the MCG:

2\> set the *failureType* as *bh-RLF*.

#### 5.7.3b.4 Actions related to transmission of *MCGFailureInformation* message

The UE shall set the contents of the *MCGFailureInformation* message as follows:

1\> include and set *failureType* in accordance with 5.7.3b.3;

1\> for each *MeasObjectNR* configured by a *measConfig* associated with the MCG, and for which measurement results are available:

2\> include an entry in *measResultFreqList*;

2\> if there is a *measId* configured with the *MeasObjectNR* and a *reportConfig* which has *rsType* set to *ssb*:

3\> set *ssbFrequency* in *measResultFreqList* to the value indicated by *ssbFrequency* as included in the *MeasObjectNR*;

2\> if there is a *measId* configured with the *MeasObjectNR* and a *reportConfig* which has *rsType* set to *csi-rs*:

3\> set *refFreqCSI-RS* in *measResultFreqList* to the value indicated by *refFreqCSI-RS* as included in the associated measurement object;

2\> if a serving cell is associated with the *MeasObjectNR*:

3\> set *measResultServingCell* in *measResultFreqList* to include the available quantities of the concerned cell and in accordance with the performance requirements in TS 38.133 \[14\];

2\> set the *measResultNeighCellList* in *measResultFreqList* to include the best measured cells, ordered such that the best cell is listed first, and based on measurements collected up to the moment the UE detected the failure, and set its fields as follows;

3\> ordering the cells with sorting as follows:

4\> based on SS/PBCH block if SS/PBCH block measurement results are available and otherwise based on CSI-RS;

4\> using RSRP if RSRP measurement results are available, otherwise using RSRQ if RSRQ measurement results are available, otherwise using SINR;

3\> for each neighbour cell included:

4\> include the optional fields that are available.

1\> for each EUTRA frequency the UE is configured to measure by *measConfig* for which measurement results are available:

2\> set the *measResultFreqListEUTRA* to include the best measured cells, ordered such that the best cell is listed first using RSRP to order the cells if RSRP measurement results are available for cells on this frequency, otherwise using RSRQ to order the cells if RSRQ measurement results are available for cells on this frequency, otherwise using SINR to order the cells, based on measurements collected up to the moment the UE detected the failure, and for each cell that is included, include the optional fields that are available;

1\> for each UTRA-FDD frequency the UE is configured to measure by *measConfig* for which measurement results are available:

2\> set the *measResultFreqListUTRA-FDD* to include the best measured cells, ordered such that the best cell is listed first using RSCP to order the cells if RSCP measurement results are available for cells on this frequency, otherwise using EcN0 to order the cells, based on measurements collected up to the moment the UE detected the failure, and for each cell that is included, include the optional fields that are available;

1\> if the UE is in NR-DC:

2\> include and set *measResultSCG* in accordance with 5.7.3.4;

1\> if the UE is in NE-DC:

2\> include and set *measResultSCG*-*EUTRA* in accordance with TS 36.331 \[10\] clause 5.6.13.5;

NOTE 1: The measured quantities are filtered by the L3 filter as configured in the mobility measurement configuration. The measurements are based on the time domain measurement resource restriction, if configured. Exclude-listed cells are not required to be reported.

NOTE 2: Field *measResultSCG-Failure* is used to report available results for NR frequencies the UE is configured to measure by SCG RRC signalling.

NOTE 3: Field *measResultSCG-EUTRA* is used to report available results for E-UTRAN frequencies the UE is configured to measure by E-UTRA RRC signalling.

1\> if SRB1 is configured as split SRB and *pdcp-Duplication* is not configured:

2\> if the *primaryPath* for the PDCP entity of SRB1 refers to the MCG:

3\> set the *primaryPath* to refer to the SCG.

The UE shall:

1\> start timer T316;

1\> if SRB1 is configured as split SRB:

2\> submit the *MCGFailureInformation* message to lower layers for transmission via SRB1, upon which the procedure ends;

1\> else (i.e. SRB3 configured):

2\> submit the *MCGFailureInformation* message to lower layers for transmission embedded in NR RRC message *ULInformationTransferMRDC* via SRB3 as specified in 5.7.2a.3.

#### 5.7.3b.5 T316 expiry

The UE shall:

1\> if T316 expires:

2\> initiate the connection re-establishment procedure as specified in 5.3.7.

### 5.7.3c Indirect path failure information

#### 5.7.3c.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<=>n: RRC reconfiguration[au];
u->n: IndirectPathFailureInformation [ac];
|||;
~~~

Figure 5.7.3c.1-1: Indirect path failure information

The purpose of this procedure is to inform NR RAN about an indirect path failure the MP remote UE has experienced.

#### 5.7.3c.2 Initiation

In case of MP, a MP remote UE initiates the procedure to report indirect path failures when neither MCG nor indirect path transmission is suspended and when one of the following conditions is met:

1\> upon detecting a SL indirect path failure resulting from sidelink radio link failure on the PC5 unicast link or receiption of *NotificationMessageSidelink* from the L2 U2N Relay UE indicating Uu failure, or indirect path addition/change failure in accordance with 5.3.5.17.2.3; or

1\> upon detecting a N3C indirect path failure, including N3C connection failure or Uu failure of the relay UE with N3C indirect path;

Upon initiating the procedure, the UE shall:

1\> if the procedure was initiated to report SL indirect path failure:

2\> reset the sidelink specific MAC of this destination;

2\> stop T421 if running;

1\> suspend indirect path transmission for all SRBs and DRBs;

1\> initiate transmission of the *IndirectPathFailureInformation* message in accordance with 5.7.3c.4;

#### 5.7.3c.3 Failure type determination

The L2 U2N Remote UE configured with SL indirect path shall set the indirect path failure type as follows:

1\> if the UE initiates transmission of the *IndirectPathFailureInformation* message due to T421 expiry in accordance with clause 5.3.5.16.1.3:

2\> set the *failureTypeIndirectPath* as *t421-Expiry*;

1\> else if the UE initiates transmission of the *IndirectPathFailureInformation* message due to reception of the *NotificationMessageSidelink* including *indicationType*, in accordance with clause 5.8.9.10.4:

2\> set the *failureTypeIndirectPath* as the value in *indicationType* received from *NotificationMessageSidelink*;

1\> else if the UE initiates transmission of the *IndirectPathFailureInformation* message due to sidelink radio link failure in accordance with clause 5.8.9.3:

2\> set the *failureTypeIndirectPath* as *sl-Failure*;

1\> if the target L2 U2N Relay UE (i.e., the UE indicated by *sl-IndirectPathRelayUE-Identity* in the received *sl-IndirectPathAddChange*) changes its serving PCell to a different cell from the target cell (i.e. the cell indicated by *sl-IndirectPathCellIdentity* in the received *sl-IndirectPathAddChange*) before path addition or change:

2\> set the *failureTypeIndirectPath* as *indirectPathAddChangeFailure*;

The N3C remote UE shall set the indirect path failure type as follows:

1\> if the UE initiates transmission of the *IndirectPathFailureInformation* message due to N3C connection failure:

2\> set the *failureTypeIndirectPath* as *n3c-Failure*;

1\> else if the UE initiates transmission of the *IndirectPathFailureInformation* message due to Uu radio link failure on N3C indirect path:

2\> set the *failureTypeIndirectPath* as *relayUE-Uu-RLF*;

NOTE: it is out of 3GPP scope how the remote UE detects N3C connection failure, or how the relay UE indicates Uu RLF to the remote UE on the N3C connection.

#### 5.7.3c.4 Actions related to transmission of *IndirectPathFailureInformation* message

The UE shall set the contents of the *IndirectPathFailureInformation* message as follows:

1\> set the *failureTypeIndirectPath* in accordance with 5.7.3c.3;

1\> if the procedure was initiated to report SL indirect path failure:

2\> set the *sl-MeasResultServingRelay* to include the measurement result for serving L2 U2N Relay UE if available;

2\> for each *measObjectRelay* included *MeasConfig*, and for which measurement results are available:

3\> include an entry in *sl-MeasResultsCandRelay*;

1\> else if the procedure was initiated to report N3C indirect path failure;

2\> include *n3c-relayUE-InfoList* to report relay UE information with non-3GPP connection(s) if available;

1\> submit the *IndirectPathFailureInformation* message to lower layers for transmission.

### 5.7.4 UE Assistance Information

#### 5.7.4.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=No, hgap];

u: UE;
n: Network;

|||;
u<=>n: RRC Reconfiguration[au];
u->n: UEAssistanceInformation [ac];
|||;
~~~

Figure 5.7.4.1-1: UE Assistance Information

The purpose of this procedure is for the UE to inform the network of:

- its delay budget report carrying desired increment/decrement in the connected mode DRX cycle length, or;

- its overheating assistance information, or;

- its IDC assistance information, or;

- its preference on DRX parameters for power saving, or;

- its preference on the maximum aggregated bandwidth for power saving, or;

- its preference on the maximum number of secondary component carriers for power saving, or;

- its preference on the maximum number of MIMO layers for power saving, or;

- its preference on the minimum scheduling offset for cross-slot scheduling for power saving, or;

- its preference on the RRC state, or;

- configured grant assistance information for NR sidelink communication, or;

- its preference in being provisioned with reference time information, or;

- its preference for FR2 UL gap, or;

- its preference to transition out of RRC_CONNECTED state for MUSIM operation, or;

- its preference on the MUSIM gaps, or;

- its preference on the MUSIM gap priority, or;

- its preference on the MUSIM temporary capability restriction, or;

- its relaxation state for RLM measurements, or;

- its relaxation state for BFD measurements, or;

- availability of data and/or signalling mapped to radio bearers which are not configured for SDT, or;

- its preference for the SCG to be deactivated, or;

- availability of uplink data to transmit for a DRB for which there is no MCG RLC bearer while the SCG is deactivated, or;

- change of its fulfilment status for RRM measurement relaxation criterion, or;

- service link (specified in TS 38.300 \[2\]) propagation delay difference between serving cell and neighbour cell(s); or

- its preference on multi-Rx operation for FR2; or

- availability of flight path information for Aerial UE operation; or

- UL traffic information, or;

- the information of the relay UE(s) with which it connects via a non-3GPP connection for MP, or;

- configured grant assistance information for NR sidelink positioning.

#### 5.7.4.2 Initiation

A UE capable of providing delay budget report in RRC_CONNECTED may initiate the procedure in several cases, including upon being configured to provide delay budget report and upon change of delay budget preference.

A UE capable of providing overheating assistance information in RRC_CONNECTED may initiate the procedure if it was configured to do so, upon detecting internal overheating, or upon detecting that it is no longer experiencing an overheating condition.

A UE capable of providing IDC assistance information in RRC_CONNECTED may initiate the procedure if it was configured to do so, upon detecting IDC problem if the UE did not transmit an IDC assistance information since it was configured to provide IDC indications, or upon change of IDC problem information.

A UE capable of providing its preference on DRX parameters of a cell group for power saving in RRC_CONNECTED may initiate the procedure in several cases, if it was configured to do so, including upon having a preference on DRX parameters and upon change of its preference on DRX parameters.

A UE capable of providing its preference on the maximum aggregated bandwidth of a cell group for power saving in RRC_CONNECTED may initiate the procedure in several cases, if it was configured to do so, including upon having a maximum aggregated bandwidth preference and upon change of its maximum aggregated bandwidth preference.

A UE capable of providing its preference on the maximum number of secondary component carriers of a cell group for power saving in RRC_CONNECTED may initiate the procedure in several cases, if it was configured to do so, including upon having a maximum number of secondary component carriers preference and upon change of its maximum number of secondary component carriers preference.

A UE capable of providing its preference on the maximum number of MIMO layers of a cell group for power saving in RRC_CONNECTED may initiate the procedure in several cases, if it was configured to do so, including upon having a maximum number of MIMO layers preference and upon change of its maximum number of MIMO layers preference.

A UE capable of providing its preference on the minimum scheduling offset for cross-slot scheduling of a cell group for power saving in RRC_CONNECTED may initiate the procedure in several cases, if it was configured to do so, including upon having a minimum scheduling offset preference and upon change of its minimum scheduling offset preference.

A UE capable of providing assistance information to transition out of RRC_CONNECTED state may initiate the procedure if it was configured to do so, upon determining that it prefers to transition out of RRC_CONNECTED state, or upon change of its preferred RRC state.

A UE capable of providing configured grant assistance information for NR sidelink communication in RRC_CONNECTED may initiate the procedure in several cases, including upon being configured to provide traffic pattern information and upon change of traffic patterns.

A UE capable of providing an indication of its preference in being provisioned with reference time information may initiate the procedure upon being configured to provide this indication, or if it was configured to provide this indication and upon change of its preference.

A UE capable of providing an indication of its preference in FR2 UL gap may initiate the procedure if it was configured to do so, upon detecting the need of FR2 UL gap activation/deactivation.

A UE capable of providing MUSIM assistance information for gap preference may initiate the procedure if it was configured to do so, upon determining it needs the gaps, or upon change of the gap preference information.

A UE capable of providing MUSIM assistance information for gap priority preference may initiate the procedure if it was configured to do so, upon determining it has gap priority preference information.

A UE capable of providing MUSIM assistance information for leave indication may initiate the procedure if it was configured to do so upon determining that it needs to leave RRC_CONNECTED state.

A UE capable of providing MUSIM assistance information for temporary capability restriction may initiate the procedure if it was configured to do so, upon determining it has temporary capability restriction or upon determining the removal of the capability restriction.

A UE capable of relaxing its RLM measurements of a cell group in RRC_CONNECTED state shall initiate the procedure for providing an indication of its relaxation state for RLM measurements upon being configured to do so, and upon change of its relaxation state for RLM measurements in RRC_CONNECTED state.

A UE capable of relaxing its BFD measurements in serving cells of a cell group in RRC_CONNECTED shall initiate the procedure for providing an indication of its relaxation state for BFD measurements upon being configured to do so, and upon change of its relaxation state for BFD measurements in RRC_CONNECTED state.

A UE capable of SDT initiates this procedure when data and/or signalling mapped to radio bearers that are not configured for SDT becomes available during SDT (i.e. while SDT procedure is ongoing).

A UE capable of providing its preference for SCG deactivation may initiate the procedure if it was configured to do so, upon determining that it prefers or does no more prefer the SCG to be deactivated.

A UE that has uplink data to transmit for a DRB for which there is no MCG RLC bearer while the SCG is deactivated shall initiate the procedure.

A UE capable of providing an indication of fulfilment of the RRM measurement relaxation criterion in connected mode may initiate the procedure if it was configured to do so, upon change of its fulfilment status for RRM measurement relaxation criterion for connected mode.

A UE capable of providing service link propagation delay difference between serving cell and neighbour cell(s) shall initiate the procedure upon being configured to do so, and upon determining that service link propagation delay difference between serving cell and a neighbour cell has changed more than *threshPropDelayDiff* compared with the last reported value.

A UE capable of providing an indication of its preference on multi-Rx operation for FR2 may initiate the procedure if it was configured to do so, upon detecting having a preference on multi-Rx operation for FR2 and upon change of its preference on multi-Rx operation for FR2.

A UE capable of indicating the availability of flight path information may initiate the procedure, if it was configured to do so, upon determining that an initial or updated flight path information is available.

A UE capable of providing UL traffic information shall initiate the procedure when the information is available upon being configured to do so, and upon change of UL traffic information.

A UE capable of N3C remote UE operation initiates the procedure upon being configured to report relay UE information on the available non-3GPP connection(s), and upon change of its available non-3GPP connection(s).

A UE capable of providing configured grant assistance information including SL-PRS transmission periodicity and priority for NR sidelink positioning in RRC_CONNECTED may initiate the procedure.

*Editor\'s Note: FFS the details of configured grant assistance information.*

Upon initiating the procedure, the UE shall:

1\> if configured to provide delay budget report:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *delayBudgetReport* since it was configured to provide delay budget report; or

2\> if the current delay budget is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *delayBudgetReport* and timer T342 is not running:

3\> start or restart timer T342 with the timer value set to the *delayBudgetReportingProhibitTimer*;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide a delay budget report;

1\> if configured to provide overheating assistance information:

2\> if the overheating condition has been detected and T345 is not running; or

2\> if the current overheating assistance information is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *overheatingAssistance* and timer T345 is not running:

> 3\> start timer T345 with the timer value set to the *overheatingIndicationProhibitTimer*;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide overheating assistance information;

1\> if configured to provide IDC assistance information based on *candidateServingFreqListNR* included in *idc-AssistanceConfig* of a cell group:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *idc-Assistance* since it was configured to provide IDC assistance information:

> 3\> if on one or more frequencies included in *candidateServingFreqListNR*, the UE is experiencing IDC problems that it cannot solve by itself; or
>
> 3\> if on one or more supported UL CA or NR-DC combination comprising of carrier frequencies included in *candidateServingFreqListNR*, the UE is experiencing IDC problems that it cannot solve by itself:

4\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide IDC assistance information;

2\> else if the current *idc-Assistance* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide IDC assistance information;

1\> if configured to provide IDC assistance information based on *idc-FDM-AssistanceConfig* included in *idc-AssistanceConfig* of a cell group:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *idc-FDM-Assistance* since it was configured to provide IDC assistance information:

3\> if on one or more frequency ranges included in *candidateServingFreqRangeListNR*, the UE is experiencing IDC problems that it cannot solve by itself; or

3\> if on one or more supported UL CA or NR-DC combination comprising of frequency ranges included in *candidateServingFreqRangeListNR*, the UE is experiencing IDC problems that it cannot solve by itself:

4\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide IDC assistance information;

2\> else if the current *idc-FDM-Assistance* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide IDC assistance information;

1\> if configured to provide IDC assistance information based on *idc-TDM-AssistanceConfig* included in *idc-AssistanceConfig* of a cell group:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *idc-TDM-Assistance* since it was configured to provide IDC assistance information:

3\> if on one or more frequencies included in *candidateServingFreqListNR* or frequency ranges included in *candidateServingFreqRangeListNR*, the UE is experiencing IDC problems that it cannot solve by itself; or

3\> if on one or more supported UL CA or NR-DC combination comprising of carrier frequencies included in *candidateServingFreqListNR* or frequency ranges included in *candidateServingFreqRangeListNR*, the UE is experiencing IDC problems that it cannot solve by itself:

4\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide IDC assistance information;

2\> else if the current *idc-TDM-Assistance* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide IDC assistance information;

NOTE 1: The term \"IDC problems\" refers to interference issues applicable across several subframes/slots where not necessarily all the subframes/slots are affected.

NOTE 2: For the frequencies on which a serving cell or serving cells is configured that is activated, IDC problems consist of interference issues that the UE cannot solve by itself, during either active data exchange or upcoming data activity which is expected in up to a few hundred milliseconds.\
For frequencies on which a SCell or SCells is configured that is deactivated, reporting IDC problems indicates an anticipation that the activation of the SCell or SCells would result in interference issues that the UE would not be able to solve by itself.\
For a non-serving frequency, reporting IDC problems indicates an anticipation that if the non-serving frequency or frequencies became a serving frequency or serving frequencies then this would result in interference issues that the UE would not be able to solve by itself.

1\> if configured to provide its preference on DRX parameters of a cell group for power saving:

2\> if the UE has a preference on DRX parameters of the cell group and the UE did not transmit a *UEAssistanceInformation* message with *drx-Preference* for the cell group since it was configured to provide its preference on DRX parameters of the cell group for power saving; or

2\> if the current *drx-Preference* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *drx-Preference* for the cell group and timer T346a associated with the cell group is not running:

3\> start the timer T346a with the timer value set to the *drx-PreferenceProhibitTimer* of the cell group;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *drx-Preference*;

1\> if configured to provide its preference on the maximum aggregated bandwidth of a cell group for power saving:

2\> if the UE has a preference on the maximum aggregated bandwidth of the cell group and the UE did not transmit a *UEAssistanceInformation* message with *maxBW-Preference* and/or *maxBW-PreferenceFR2-2* for the cell group since it was configured to provide its preference on the maximum aggregated bandwidth of the cell group for power saving; or

2\> if the current *maxBW-Preference* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *maxBW-Preference* and/or *maxBW-PreferenceFR2-2*for the cell group and timer T346b associated with the cell group is not running:

3\> start the timer T346b with the timer value set to the *maxBW-PreferenceProhibitTimer* of the cell group;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *maxBW-Preference* and/or *maxBW-PreferenceFR2-2*;

1\> if configured to provide its preference on the maximum number of secondary component carriers of a cell group for power saving:

2\> if the UE has a preference on the maximum number of secondary component carriers of the cell group and the UE did not transmit a *UEAssistanceInformation* message with *maxCC-Preference* for the cell group since it was configured to provide its preference on the maximum number of secondary component carriers of the cell group for power saving; or

2\> if the current *maxCC-Preference* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *maxCC-Preference* for the cell group and timer T346c associated with the cell group is not running:

3\> start the timer T346c with the timer value set to the *maxCC-PreferenceProhibitTimer* of the cell group;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *maxCC-Preference*;

1\> if configured to provide its preference on the maximum number of MIMO layers of a cell group for power saving:

2\> if the UE has a preference on the maximum number of MIMO layers of the cell group and the UE did not transmit a *UEAssistanceInformation* message with *maxMIMO-LayerPreference* and/or *maxMIMO-LayerPreferenceFR2-2* for the cell group since it was configured to provide its preference on the maximum number of MIMO layers of the cell group for power saving; or

2\> if the current *maxMIMO-LayerPreference* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *maxMIMO-LayerPreference* and/or *maxMIMO-LayerPreferenceFR2-2* for the cell group and timer T346d associated with the cell group is not running:

3\> start the timer T346d with the timer value set to the *maxMIMO-LayerPreferenceProhibitTimer* of the cell group;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *maxMIMO-LayerPreference* and/or *maxMIMO-LayerPreferenceFR2-2*;

1\> if configured to provide its preference on the minimum scheduling offset for cross-slot scheduling of a cell group for power saving:

2\> if the UE has a preference on the minimum scheduling offset for cross-slot scheduling of the cell group and the UE did not transmit a *UEAssistanceInformation* message with *minSchedulingOffsetPreference* and/or *minSchedulingOffsetPreferenceExt* for the cell group since it was configured to provide its preference on the minimum scheduling offset for cross-slot scheduling of the cell group for power saving; or

2\> if the current *minSchedulingOffsetPreference* and/or *minSchedulingOffsetPreferenceExt* information for the cell group is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *minSchedulingOffsetPreference* and/or *minSchedulingOffsetPreferenceExt* for the cell group and timer T346e associated with the cell group is not running:

3\> start the timer T346e with the timer value set to the *minSchedulingOffsetPreferenceProhibitTimer* of the cell group;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *minSchedulingOffsetPreference* and/or *minSchedulingOffsetPreferenceExt*;

1\> if configured to provide its release preference and timer T346f is not running:

2\> if the UE determines that it would prefer to transition out of RRC_CONNECTED state; or

2\> if the UE is configured with *connectedReporting* and the UE determines that it would prefer to revert an earlier indication to transition out of RRC_CONNECTED state:

3\> start timer T346f with the timer value set to the *releasePreferenceProhibitTimer*;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the release preference;

1\> if configured to provide configured grant assistance information for NR sidelink communication:

2\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide configured grant assistance information for NR sidelink communication;

1\> if configured to provide preference in being provisioned with reference time information:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *referenceTimeInfoPreference* since it was configured to provide preference; or

2\> if the UE\'s preference changed from the last time UE initiated transmission of the *UEAssistanceInformation* message including *referenceTimeInfoPreference*:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide preference in being provisioned with reference time information.

1\> if configured to provide its preference on FR2 UL gap:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *ul-GapFR2-Preference* since it was configured to provide its preference on FR2 UL gap information:

3\> if the UE has a preference on FR2 UL gap activation/deactivation:

4\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide FR2 UL gap preference;

2\> else if the current FR2 UL gap preference is different from the one indicated in the last transmission of the *UEAssistanceInformation* message:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide FR2 UL gap preference.

1\> if configured to provide MUSIM assistance information for leaving RRC_CONNECTED:

2\> if the UE needs to leave RRC_CONNECTED state and the timer T346g is not running:

3\> initiate transmission of the UEAssistanceInformation message in accordance with 5.7.4.3 to provide MUSIM assistance information for leaving RRC_CONNECTED;

3\> start the timer T346g with the timer value set to the *musim-LeaveWithoutResponseTimer*;

1\> if configured to provide MUSIM assistance information for gap preference:

2\> if the UE has a preference on the MUSIM gap(s) and the UE did not transmit a *UEAssistanceInformation* message with *musim-GapPreferenceList* since it was configured to provide MUSIM assistance information for gap preference; or

2\> if the current *musim-GapPreferenceList* is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *musim-GapPreferenceList* and the timer T346h is not running:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *musim-GapPreferenceList*;

3\> start or restart the timer T346h with the timer value set to the *musim-GapProhibitTimer*.

NOTE 3: The UE does not need to initiate transmission of the *UEAssistanceInformation* message if the difference between the current *musim-GapPreferenceList* and the last transmission of the *UEAssistanceInformation* message including *musim-GapPreferenceList* is only due to removal of an ended aperiodic gap.

1\> if configured to provide MUSIM assistance information for gap priority preference:

2\> if the UE has a preference on the MUSIM gap(s) priority and the UE did not transmit a *UEAssistanceInformation* message with *musim-GapPriorityPreferenceList* since it was configured to provide MUSIM assistance information for gap priority preference; or

2\> if the current *musim-GapPriorityPreferenceList* is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *musim-GapPriorityPreferenceList* and the timer T346h is not running:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the *musim-GapPriorityPreferenceList*;

3\> start or restart the timer T346h with the timer value set to the *musim-GapProhibitTimer*.

1\> if configured to provide MUSIM assistance information for temporary capability restriction:

2\> if the UE has temporary capability restriction on the current configuration and timer T348 is not running:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *musim-Cell-SCG-ToRelease and/or musim-CellToAffectList*;

3\> start the timer T348 with the timer value set to the *musim-WaitTimer*.

2\> if the UE has temporary capability restriction on the current band(s) or combination(s) of bands and the UE did not transmit a *UEAssistanceInformation* message with *musim-AffectedBandsList* and/or *musim-AvoidedBandsList* since it was configured to provide MUSIM assistance information for temporary capability restriction; or

2\> if the current *musim-AffectedBandsList* and/or *musim-AvoidedBandsList* is different from the one indicated in the last transmission of the *UEAssistanceInformation* message including *musim-CapRestriction* and timer T346n is not running:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *musim-AffectedBandsList* and/or *musim-AvoidedBandsList*;

3\> start the timer T346n with the timer value set to the *musim-ProhibitTimer*.

2\> if the UE has a preference on the measurement gap requirement information and the UE did not transmit a *UEAssistanceInformation* message with measurement gap requirement information or *RRCReconfigurationComplete* message or *RRCResumeComplete* message with measurement gap requirement information since it was configured to provide its preference on the measurement gap requirement information for MUSIM; or

2\> if the current *musim-NeedForGapsInfoNR* is different from the one indicated in the last transmission of the *UEAssistanceInformation* message or *RRCReconfigurationComplete* message or *RRCResumeComplete* message including *musim-CapRestriction* to provide the *needForGapsInfoNR* for the measurement gap requirement of NR target bands:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the current *musim-NeedForGapsInfoNR*;

Editor\'s Note: FFS whether UE should start a timer, e.g., Timer T348.

1\> if configured to provide the relaxation state of RLM measurements of a cell group and RLM measurement of the cell group is not stopped:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *rlm-MeasRelaxationState* since it was configured to provide the relaxation state of RLM measurements for the cell group; or

2\> if the relaxation state of RLM measurements for the cell group is currently different from the relaxation state reported in the last transmission of the *UEAssistanceInformation* message including *rlm-MeasRelaxationState* of the cell group and timer T346j associated with the cell group is not running:

3\> start timer T346j with the timer value set to the *rlm-RelaxtionReportingProhibitTimer*;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the relaxation state of RLM measurements of the cell group;

1\> if configured to provide the relaxation state of BFD measurements of serving cells of a cell group and BFD measurement of the cell group is not stopped:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *bfd-MeasRelaxationState* since it was configured to provide the relaxation state of BFD measurements for the cell group; or

2\> if the relaxation state of BFD measurements in any serving cell of the cell group is currently different from the relaxation state reported in the last transmission of the *UEAssistanceInformation* message including *bfd-MeasRelaxationState* of the cell group and timer T346k associated with the cell group is not running:

3\> start timer T346k with the timer value set to the *bfd-RelaxtionReportingProhibitTimer*;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the relaxation state of BFD measurements of serving cells of the cell group.

1\> if data and/or signalling mapped to radio bearers not configured for SDT becomes available during SDT (i.e. while SDT procedure is ongoing):

2\> if the UE did not transmit a *UEAssistanceInformation* message with *nonSDT-DataIndication* since the initiation of the current resume procedure for SDT:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide *nonSDT-DataIndication*.

1\> if configured to provide its preference for SCG deactivation and timer T346i is not running;

2\> if the UE prefers the SCG to be deactivated and did not transmit a *UEAssistanceInformation* message with *scg-DeactivationPreference* since it was configured to provide its SCG deactivation preference; or

2\> if the UE preference for SCG deactivation is different from the last indicated *scg-DeactivationPreference*:

3\> start timer T346i with the timer value set to the *scg-DeactivationPreferenceProhibitTimer*;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the UE preference for SCG deactivation;

1\> if the SCG is deactivated, and,

1\> the UE has uplink data to send for an SCG RLC entity while the UE previously did not have any uplink data to send for any SCG RLC entity:

2\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to indicate that the UE has uplink data to send for a DRB whose *DRB-Identity* is not included in any *RLC-BearerConfig* in the *CellGroupConfig* associated with the MCG.

1\> if configured to send indications of RRM measurement relaxation criterion fulfilment:

2\> if the criterion in 5.7.4.4 is met for a period of T~SearchDeltaP-StationaryConnected~:

3\> if the UE did not transmit a *UEAssistanceInformation* message with *rrm-MeasRelaxationFulfilment* as *true* since it was configured to provide indications of RRM measurement relaxation criterion fulfilment; or

3\> the last *UEAssistanceInformation* message indicated the criterion in 5.7.4.4 is not fulfilled with *rrm-MeasRelaxationFulfilment* as *false*:

4\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to indicate that the criterion for RRM measurement relaxation for connected mode is fulfilled;

2\> else:

3\> if the last *UEAssistanceInformation* message indicated fulfilment of the criterion in 5.7.4.4 with *rrm-MeasRelaxationFulfilment* as *true*:

4\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to indicate that the criterion for RRM measurement relaxation for connected mode is not fulfilled.

1\> if configured to provide service link propagation delay difference between serving cell and neighbour cell(s);

2\> if the UE did not transmit a *UEAssistanceInformation* message with *propagationDelayDifference* since it was configured to provide service link propagation delay difference between serving cell and neighbour cell(s); or

2\> for any neighbour cell in *neighCellInfoList*, if the service link propagation delay difference between serving cell and the neighbour cell has changed more than *threshPropDelayDiff* since the last transmission of the *UEAssistanceInformation* message including *propagationDelayDifference*:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide service link propagation delay difference between serving cell and each neighbour cell included in the *neighCellInfoList*;

1\> if configured to provide its preference for multi-Rx operation and timer T440 is not running;

2\> if the UE has a preference on multi-Rx operation for FR2 and did not transmit a *UEAssistanceInformation* message with *multiRx-PreferenceFR2* since it was configured to provide its preference on multi-Rx operation; or

2\> if the UE has a different preference on multi-Rx operation for FR2 from the last indicated *multiRx-PreferenceFR2*:

3\> start timer T440 with the timer value set to the *multiRx-PreferenceReportingConfigFR2ProhibitTimer*;

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide the UE preference for multi-Rx operation for FR2.

1\> if configured to indicate the availability of flight path information and the UE has flight path information available:

2\> if the UE had not previously provided a flight path information since last entering RRC_CONNECTED state; or

2\> if at least one waypoint was not previously provided; or

2\> if at least one upcoming waypoint that was previously provided is being removed; or

2\> if *flightPathUpdateDistanceThr* is configured and for at least one waypoint, the 3D distance between the previously provided location and the new location is more than or equal to the distance threshold configured by *flightPathUpdateDistanceThr*; or

2\> if *flightPathUpdateTimeThr* is configured and for at least one waypoint, the timestamp was not previously provided but is now available, or the time between the previously provided timestamp and the new timestamp, if available, is more than or equal to the time threshold configured by *flightPathUpdateTimeThr*:
2\> if *flightPathUpdateTimeThr* is configured and for at least one waypoint, the timestamp was not previously provided but is now available, or the time between the previously provided timestamp and the new timestamp, if available, is more than or equal to the time threshold configured by *flightPathUpdateTimeThr*:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to indicate the availability of flight path information;

NOTE 4: If neither *flightPathUpdateDistanceThr* nor *flightPathUpdateTimeThr* is configured, it is up to UE implementation whether to initiate transmission of the *UEAssistanceInformation* message when updated flight path information is available.

1\> if configured to provide UL traffic information:

2\> if the UE did not transmit a *UEAssistanceInformation* message with *ul-TrafficInfo* since it was configured to provide UL traffic information; or

2\> if UL traffic information included in the previous *UEAssistanceInformation* has changed since the last transmission of the *UEAssistanceInformation* message containing *ul-TrafficInfo* for at least one QoS flow for which timer T346x is not running:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide UL traffic information.

NOTE 5: The UE only considers *burstArrivalTime* to have changed when it changes relative to the periodicity of the Data Burst arrival.

1\> if configured to report relay UE information with non-3GPP connection(s);

2\> if the UE did not transmit a *UEAssistanceInformation* message with *n3c-relayUE-InfoList* since it was configured to report available relay UE information with non-3GPP connection(s); or

2\> if the UE has new available non-3GPP conection(s); or

2\> if the non-3GPP connection(s) with the reported relay UE(s) is not available:

3\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to report relay UE information with non-3GPP connection(s) included in the *n3c-relayUE-InfoList*;

1\> if configured to provide configured grant assistance information for NR sidelink positioning:

2\> initiate transmission of the *UEAssistanceInformation* message in accordance with 5.7.4.3 to provide configured grant assistance information for NR sidelink positioning;

#### 5.7.4.3 Actions related to transmission of *UEAssistanceInformation* message

The UE shall set the contents of the *UEAssistanceInformation* message as follows:

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide a delay budget report according to 5.7.4.2 or 5.3.5.3;

2\> set *delayBudgetReport* to *type1* according to a desired value;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide overheating assistance information according to 5.7.4.2 or 5.3.5.3;

2\> if the UE experiences internal overheating:

3\> if the UE prefers to temporarily reduce the number of maximum secondary component carriers:

4\> include *reducedMaxCCs* in the *OverheatingAssistance* IE;

4\> set *reducedCCsDL* to the number of maximum SCells the UE prefers to be temporarily configured in downlink;

4\> set *reducedCCsUL* to the number of maximum SCells the UE prefers to be temporarily configured in uplink;

3\> if the UE prefers to temporarily reduce maximum aggregated bandwidth of FR1:

4\> include *reducedMaxBW-FR1* in the *OverheatingAssistance* IE;

4\> set *reducedBW-DL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all downlink carriers of FR1;

4\> set *reducedBW-UL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all uplink carriers of FR1;

3\> if the UE prefers to temporarily reduce maximum aggregated bandwidth of FR2-1:

4\> include *reducedMaxBW-FR2* in the *OverheatingAssistance* IE;

4\> set *reducedBW-DL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all downlink carriers of FR2-1;

4\> set *reducedBW-UL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all uplink carriers of FR2-1;

3\> if the UE prefers to temporarily reduce maximum aggregated bandwidth of FR2-2:

4\> include *reducedMaxBW-FR2-2* in the *OverheatingAssistance IE*;

4\> set *reducedBW-FR2-2-DL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all downlink carriers of FR2-2;

4\> set *reducedBW-FR2-2-UL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all uplink carriers of FR2-2;

3\> if the UE prefers to temporarily reduce the number of maximum MIMO layers of each serving cell operating on FR1:

4\> include *reducedMaxMIMO-LayersFR1* in the *OverheatingAssistance* IE;

4\> set *reducedMIMO-LayersFR1-DL* to the number of maximum MIMO layers of each serving cell operating on FR1 the UE prefers to be temporarily configured in downlink;

4\> set *reducedMIMO-LayersFR1-UL* to the number of maximum MIMO layers of each serving cell operating on FR1 the UE prefers to be temporarily configured in uplink;

3\> if the UE prefers to temporarily reduce the number of maximum MIMO layers of each serving cell operating on FR2-1:

4\> include *reducedMaxMIMO-LayersFR2* in the *OverheatingAssistance* IE;

4\> set *reducedMIMO-LayersFR2-DL* to the number of maximum MIMO layers of each serving cell operating on FR2-1 the UE prefers to be temporarily configured in downlink;

4\> set *reducedMIMO-LayersFR2-UL* to the number of maximum MIMO layers of each serving cell operating on FR2-1 the UE prefers to be temporarily configured in uplink;

3\> if the UE prefers to temporarily reduce the number of maximum MIMO layers of each serving cell operating on FR2-2:

4\> include *reducedMaxMIMO-LayersFR2-2* in the *OverheatingAssistance IE*;

4\> set *reducedMIMO-LayersFR2-2-DL* to the number of maximum MIMO layers of each serving cell operating on FR2 the UE prefers to be temporarily configured in downlink;

4\> set *reducedMIMO-LayersFR2-2-UL* to the number of maximum MIMO layers of each serving cell operating on FR2 the UE prefers to be temporarily configured in uplink;

2\> else (if the UE no longer experiences an overheating condition):

3\> do not include *reducedMaxCCs*, *reducedMaxBW-FR1*, *reducedMaxBW-FR2*, *reducedMaxBW-FR2-2*, *reducedMaxMIMO-LayersFR1,* *reducedMaxMIMO-LayersFR2* or *reducedMaxMIMO-LayersFR2-2* in *OverheatingAssistance* IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide IDC assistance information according to 5.7.4.2 or 5.3.5.3:

2\> if there is at least one carrier frequency included in *candidateServingFreqListNR*, the UE is experiencing IDC problems that it cannot solve by itself:

3\> include the field *affectedCarrierFreqList* with an entry for each affected carrier frequency included in *candidateServingFreqListNR*;

3\> for each carrier frequency included in the field *affectedCarrierFreqList*, include *interferenceDirection* and set it accordingly;

2\> if there is at least one supported UL CA or NR-DC combination comprising of carrier frequencies included in *candidateServingFreqListNR*, the UE is experiencing IDC problems that it cannot solve by itself:

3\> include *victimSystemType* for each UL CA or NR-DC combination included in *affectedCarrierFreqCombList*;

3\> if the UE sets *victimSystemType* to *wlan* or *bluetooth*:

4\> include *affectedCarrierFreqCombList* with an entry for each supported UL CA combination comprising of carrier frequencies included in *candidateServingFreqListNR*, that is affected by IDC problems;

3\> else:

4\> optionally include *affectedCarrierFreqCombList* with an entry for each supported UL CA or NR-DC combination comprising of carrier frequencies included in *candidateServingFreqListNR*, that is affected by IDC problems;

2\> if there is at least one affected frequency range overlapping with one candidate frequency range included in *candidateServingFreqRangeListNR*, and the center frequency of the affected frequency range is within the candidate frequency range included in *candidateServingFreqRangeListNR*, the UE is experiencing IDC problems that it cannot solve by itself:

3\> include the field *affectedCarrierFreqRangeList* with an entry for each affected frequency range;

3\> for each affected frequency range included in the field *affectedCarrierFreqRangeList*, include *centerFreq* and *affectedBandwidth*;

3\> for each affected frequency range included in the field *affectedCarrierFreqRangeList*, include *interferenceDirection* and optionally *victimSystemType*, and set it accordingly;

2\> if there is at least one supported UL CA or NR-DC combinations comprising of candidate frequency ranges included in *candidateServingFreqRangeListNR*, and each affected frequency range in the UL CA or NR-DC combination overlapping with one candidate frequency range included in *candidateServingFreqRangeListNR*, and the center frequency of the affected frequency range is within the candidate frequency range included in *candidateServingFreqRangeListNR*, the UE is experiencing IDC problems that it cannot solve by itself:

3\> include the field *affectedCarrierFreqRangeCombList* with an entry for each supported UL CA or NR-DC combination comprising of frequency ranges that is affected by IDC problems;

3\> for each affected frequency range included in the field *affectedCarrierFreqRangeCombList*, include *centerFreq* and *affectedBandwidth*;

3\> for each UL CA or NR-DC combination included in the field *affectedCarrierFreqRangeCombList*, include *interferenceDirection* and optionally *victimSystemType*, and set it accordingly;

2\> if there is at least one candidate carrier frequency included in *candidateServingFreqListNR* or candidate frequency range included in *candidateServingFreqRangeListNR* or one supported UL CA or NR-DC combination comprising of candidate carrier frequencies included in *candidateServingFreqListNR* or candidate frequency ranges included in *candidateServingFreqRangeListNR*, the UE is experiencing IDC problems that it cannot solve by itself, and *affectedCarrierFreqList* or *affectedCarrierFreqCombList* or *affectedCarrierFreqRangeList* or *affectedCarrierFreqRangeCombList* is included, and *idc-TDM-AssistanceConfig* is set to *setup*:

3\> include Time Domain Multiplexing (TDM) based assistance information as indicated by *idc-TDM-Assistance* that could be used to resolve the IDC problems;

NOTE 1: When sending an *UEAssistanceInformation* message to inform the IDC problems, the UE includes all IDC assistance information (rather than providing e.g. the changed part(s) of the IDC assistance information).

NOTE 2: Upon not anymore experiencing a particular IDC problem that the UE previously reported, the UE provides an IDC indication with the modified contents of the *UEAssistanceInformation* message (e.g. by not including the IDC assistance information in the *idc-Assistance*, *idc-FDM-Assistance* and *idc-TDM-Assistance* fields).

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *drx-Preference* of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *drx-Preference* in the *UEAssistanceInformation* message;

2\> if the UE has a preference on DRX parameters for the cell group:

3\> if the UE has a preference for the long DRX cycle:

4\> include *preferredDRX-LongCycle* in the *DRX-Preference* IE and set it to the preferred value;

3\> if the UE has a preference for the DRX inactivity timer:

4\> include *preferredDRX-InactivityTimer* in the *DRX-Preference* IE and set it to the preferred value;

3\> if the UE has a preference for the short DRX cycle:

4\> include *preferredDRX-ShortCycle* in the *DRX-Preference* IE and set it to the preferred value;

3\> if the UE has a preference for the short DRX timer:

4\> include *preferredDRX-ShortCycleTimer* in the *DRX-Preference* IE and set it to the preferred value;

2\> else (if the UE has no preference on DRX parameters for the cell group):

3\> do not include *preferredDRX-LongCycle, preferredDRX-InactivityTimer, preferredDRX-ShortCycle* and *preferredDRX-ShortCycleTimer* in the *DRX-Preference* IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *maxBW-Preference* of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *maxBW-Preference* in the *UEAssistanceInformation* message;

2\> if the UE has a preference on the maximum aggregated bandwidth for the cell group:

3\> if the UE prefers to reduce the maximum aggregated bandwidth of FR1:

4\> include *reducedMaxBW-FR1* in the *MaxBW-Preference* IE;

4\> set *reducedBW-DL* to the maximum aggregated bandwidth the UE desires to have configured across all downlink carriers of FR1 in the cell group;

4\> set *reducedBW-UL* to the maximum aggregated bandwidth the UE desires to have configured across all uplink carriers of FR1 in the cell group;

3\> if the UE prefers to reduce the maximum aggregated bandwidth of FR2-1:

4\> include *reducedMaxBW-FR2* in the *MaxBW-Preference* IE;

4\> set *reducedBW-DL* to the maximum aggregated bandwidth the UE desires to have configured across all downlink carriers of FR2-1 in the cell group;

4\> set *reducedBW-UL* to the maximum aggregated bandwidth the UE desires to have configured across all uplink carriers of FR2-1 in the cell group;

2\> else (if the UE has no preference on the maximum aggregated bandwidth for the cell group):

3\> do not include *reducedMaxBW-FR1* and *reducedMaxBW-FR2* in the *MaxBW-Preference* IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *maxBW-PreferenceFR2-2* of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *maxBW-PreferenceFR2-2* in the *UEAssistanceInformation* message;

3\> if the UE prefers to reduce the maximum aggregated bandwidth of FR2-2:

4\> include *reducedMaxBW-FR2-2* in the M*axBW-PreferenceFR2-2* IE;

4\> set *reducedBW-FR2-2-DL* to the maximum aggregated bandwidth the UE desires to have configured across all downlink carriers of FR2-2 in the cell group;

4\> set *reducedBW-FR2-2-UL* to the maximum aggregated bandwidth the UE desires to have configured across all uplink carriers of FR2-2 in the cell group;

2\> else (if the UE has no preference on the maximum aggregated bandwidth for the cell group):

3\> do not include *reducedMaxBW-FR2-2* in the *MaxBW-PreferenceFR2-2* IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *maxCC-Preference* of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *maxCC-Preference* in the *UEAssistanceInformation* message;

2\> if the UE has a preference on the maximum number of secondary component carriers for the cell group:

3\> include *reducedMaxCCs* in the *MaxCC-Preference* IE;

3\> set *reducedCCsDL* to the number of maximum SCells the UE desires to have configured in downlink in the cell group;

3\> set *reducedCCsUL* to the number of maximum SCells the UE desires to have configured in uplink in the cell group;

2\> else (if the UE has no preference on the maximum number of secondary component carriers for the cell group):

3\> do not include *reducedMaxCCs* in the *MaxCC-Preference* IE;

NOTE 3: The UE can implicitly indicate a preference for NR SCG release by reporting the maximum aggregated bandwidth preference for power saving of the cell group, if configured, as zero for both FR1 and FR2, and by reporting the maximum number of secondary component carriers for power saving of the cell group, if configured, as zero for both uplink and downlink.

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *maxMIMO-LayerPreference* of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *maxMIMO-LayerPreference* in the *UEAssistanceInformation* message;

2\> if the UE has a preference on the maximum number of MIMO layers for the cell group:

3\> if the UE prefers to reduce the number of maximum MIMO layers of each serving cell operating on FR1:

4\> include *reducedMaxMIMO-LayersFR1* in the *MaxMIMO-LayerPreference* IE;

4\> set *reducedMIMO-LayersFR1-DL* to the preferred maximum number of downlink MIMO layers of each BWP of each FR1 serving cell that the UE operates on in the cell group;

4\> set *reducedMIMO-LayersFR1-UL* to the preferred maximum number of uplink MIMO layers of each FR1 serving cell that the UE operates on in the cell group;

3\> if the UE prefers to reduce the number of maximum MIMO layers of each serving cell operating on FR2-1:

4\> include *reducedMaxMIMO-LayersFR2* in the *MaxMIMO-LayerPreference* IE;

4\> set *reducedMIMO-LayersFR2-DL* to the preferred maximum number of downlink MIMO layers of each BWP of each FR2-1 serving cell that the UE operates on in the cell group;

4\> set *reducedMIMO-LayersFR2-UL* to the preferred maximum number of uplink MIMO layers of each FR2-1 serving cell that the UE operates on in the cell group;

2\> else (if the UE has no preference on the maximum number of MIMO layers for the cell group):

3\> do not include *reducedMaxMIMO-LayersFR1* and *reducedMaxMIMO-LayersFR2* in the *MaxMIMO-LayerPreference* IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *maxMIMO LayerPreferenceFR2* 2 of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *maxMIMO-LayerPreferenceFR2-2* in the *UEAssistanceInformation* message;

2\> if the UE has a preference on the maximum number of MIMO layers for the cell group for FR2-2:

3\> if the UE prefers to reduce the number of maximum MIMO layers of each serving cell operating on FR2 2:

4\> include *reducedMaxMIMO-LayersFR2-2* in the *MaxMIMO-LayerPreferenceFR2 2* IE;

4\> set *reducedMIMO-LayersFR2-2-DL* to the preferred maximum number of downlink MIMO layers of each BWP of each FR2-2 serving cell that the UE operates on in the cell group;

4\> set *reducedMIMO-LayersFR2-2-UL* to the preferred maximum number of uplink MIMO layers of each FR2-2 serving cell that the UE operates on in the cell group;

2\> else (if the UE has no preference on the maximum number of MIMO layers for the cell group):

3\> do not include reducedMaxMIMO-LayersFR2-2 in the *MaxMIMO-LayerPreferenceFR2-*2 IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *minSchedulingOffsetPreference* of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *minSchedulingOffsetPreference* in the *UEAssistanceInformation* message;

2\> if the UE has a preference on the minimum scheduling offset for cross-slot scheduling for the cell group:

3\> if the UE has a preference for the value of K~0~ (TS 38.214 \[19\], clause 5.1.2.1) for cross-slot scheduling with 15 kHz SCS:

4\> include *preferredK0-SCS-15kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~0~;

3\> if the UE has a preference for the value of K~0~ for cross-slot scheduling with 30 kHz SCS:

4\> include *preferredK0-SCS-30kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~0~;

3\> if the UE has a preference for the value of K~0~ for cross-slot scheduling with 60 kHz SCS:

4\> include *preferredK0-SCS-60kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~0~;

3\> if the UE has a preference for the value of K~0~ for cross-slot scheduling with 120 kHz SCS:

4\> include *preferredK0-SCS-120kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~0~;

3\> if the UE has a preference for the value of K~2~ (TS 38.214 \[19\], clause 6.1.2.1) for cross-slot scheduling with 15 kHz SCS:

4\> include *preferredK2-SCS-15kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~2~;

3\> if the UE has a preference for the value of K~2~ for cross-slot scheduling with 30 kHz SCS:

4\> include *preferredK2-SCS-30kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~2~;

3\> if the UE has a preference for the value of K~2~ for cross-slot scheduling with 60 kHz SCS:

4\> include *preferredK2-SCS-60kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~2~;

3\> if the UE has a preference for the value of K~2~ for cross-slot scheduling with 120 kHz SCS:

4\> include *preferredK2-SCS-120kHz* in the *MinSchedulingOffsetPreference* IE and set it to the desired value of *K*~2~;

2\> else (if the UE has no preference on the minimum scheduling offset for cross-slot scheduling for the cell group):

3\> do not include *preferredK0* and *preferredK2* in the *MinSchedulingOffsetPreference* IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide *minSchedulingOffsetPreferenceExt* of a cell group for power saving according to 5.7.4.2 or 5.3.5.3:

2\> include *minSchedulingOffsetPreferenceExt* in the *UEAssistanceInformation* message;

2\> if the UE has a preference on the minimum scheduling offset for cross-slot scheduling for the cell group for FR2-2:

3\> include *minSchedulingOffsetPreferenceExt* in the *UEAssistanceInformation* message;

4\> if the UE has a preference for the value of K~0~ (TS 38.214 \[19\], clause 5.1.2.1) for cross-slot scheduling with 480 kHz SCS:

5\> include *preferredK0-SCS-480kHz* in the *minSchedulingOffsetPreferenceExt* IE and set it to the desired value of K~0~;

4\> if the UE has a preference for the value of K~0~ for cross-slot scheduling with 960 kHz SCS:

5\> include *preferredK0-SCS-960kHz* in the *minSchedulingOffsetPreferenceExt* IE and set it to the desired value of K~0~;

4\> if the UE has a preference for the value of K~2~ for cross-slot scheduling with 480 kHz SCS:

5\> include *preferredK2-SCS-480kHz* in the *minSchedulingOffsetPreferenceExt* IE and set it to the desired value of K~2~;

4\> if the UE has a preference for the value of K~2~ for cross-slot scheduling with 960 kHz SCS:

5\> include *preferredK2-SCS-960kHz* in the *minSchedulingOffsetPreferenceExt* IE and set it to the desired value of K~2~;

3\> else (if the UE has no preference on the minimum scheduling offset for cross-slot scheduling for the cell group):

4\> do not include *preferredK0* and *preferredK2* in the *minSchedulingOffsetPreferenceExt* IE;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide a release preference according to 5.7.4.2 or 5.3.5.3:

2\> include *releasePreference* in the *UEAssistanceInformation* message;

2\> set *preferredRRC-State* to the desired RRC state on transmission of the *UEAssistanceInformation* message;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide an indication of preference in being provisioned with reference time information according to 5.7.4.2 or 5.3.5.3:

2\> if the UE has a preference in being provisioned with reference time information:

3\> set *referenceTimeInfoPreference* to *true*;

2\> else:

3\> set *referenceTimeInfoPreference* to *false*.

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide preference on FR2 UL gap according to 5.7.4.2 or 5.3.5.3:

2\> if the UE has a preference for FR2 UL gap configuration:

3\> set *ul-GapFR2-PatternPreference* to the preferred FR2 UL gap pattern;

2\> else (if the UE has no preference for the FR2 UL gap configuration):

3\> do not include *ul-GapFR2-PatternPreference* in the *UL-GapFR2-Preference* IE.

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide MUSIM assistance information according to 5.7.4.2 or 5.3.5.3:

2\> if the UE has a preference for MUSIM periodic gap(s):

3\> include *musim-GapPreferenceList* with an entry for each periodic gap the UE prefers to be configured;

4\> set *musim-GapLength* and *musim-GapRepetitionAndOffset* in the *musim-GapInfo* IE to the values of the length and the repetition/offset of the gap(s), respectively, the UE prefers to be configured with;

2\> if the UE has a preference for MUSIM aperiodic gap:

3\> include the field *musim-GapPreferenceList*, with one entry for the aperiodic gap the UE prefers to be configured;

4\> include *musim-GapLength* in the *musim-GapInfo* IE and set it to the values of the length of the gap the UE prefers to be configured with;

4\> optionally include *musim-Starting-SFN-AndSubframe* in the *musim-GapInfo* IE and set it to the starting SFN/subframe of the gap the UE prefers to be configured with;

2\> if the UE has no longer preference for the periodic/aperiodic gaps:

3\> do not include *musim-GapPreferenceList* in the *musim-Assistance* IE;

2\> if UE has a preference to leave RRC_CONNECTED state:

3\> set *musim-PreferredRRC-State* to the preferred RRC state.

2\> if UE has a preference for MUSIM gap priority:

3\> include the *musim-GapPriorityPreferenceList* the UE prefers to be configured;

3\> if the UE has preference to keep all collided MUSIM gaps for periodic MUSIM gap(s):

4\> include the *musim-GapKeep*;

2\> if UE has a preference for temporary capability restriction:

3\> if UE has a preference for serving cell(s) and/or SCG to be released:

4\> include the *musim-Cell-SCG-ToRelease*;

5\> set *musim-CellToRelease* to include the serving cell(s) the UE prefers to be released;

5\> set scg-ReleasePreference to *scgReleasePreferred* if the UE prefers the SCG to be released;

3\> if UE has a preference to indicate the serving cells:

4\> include the *musim-CellToAffectList* the UE prefers to be configured;

5\> include the *musim-ServCellIndex* and the *musim-MIMO-Layers-DL*/ *musim-MIMO-Layers-UL/ musim-SupportedBandwidth-DL/ musim-SupportedBandwidth-UL for* the corresponding serving cell;

3\> if UE has a preference to indicate the maximum number of CCs:

4\> include the *musim-capabilityRestricted* for the corresponding *musim-MaxCC* the UE prefers to be configured;

5\> include the the *musim-MaxCC-DL/ musim-MaxCC-UL* for the corresponding maximum number of CCs;

3\> if UE has a preference to indicate band(s) and/or combination(s) of bands with capabilities restricted which comprise of the band(s) that is/are indicated in *musim-CandidateBandList*:

4\> include the *musim-AffectededBandCombList* the UE prefer to be configured with capabilities restricted;

5\> include the *bandEntryIndex* for each band for each band or each band of the combination(s) for which capabilities are restricted;

5\> include the *musim-CapabilityRestricted* for the corresponding band(s) or bands of the combination(s);

3\> if UE has a preference to indicate band(s) and/or combination(s) of bands to be avoided which comprise of band(s) that is indicated in *musim-CandidateBandList*:

4\> include the *musim-AvoidedBandsList* the UE prefers not to be configured;

5\> include the *bandEntryIndex* for each band or each band of the combination(s) to be avoided;

3\> if UE has a preference for measurement gap requirement:

4\> include the *musim-NeedForGapsInfoNR* to provide the measurement gap requirement information from the *requestedTargetBandFilterNR-r16* of *NeedForGapsConfigNR* configuration in RRCResume message or *RRCReconfiguration* message of NR target bands the UE prefer to be configured;

2\> if the UE has no longer preference for temporary capability restriction:

3\> do not include the corresponding temporary capability restriction preference in the *musim-CapRestriction* in the *musim-Assistance* *IE*;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide the relaxation state of RLM measurements of a cell group according to 5.7.4.2:

2\> if the UE performs RLM measurement relaxation on the cell group according to TS 38.133 \[14\]:

3\> set the *rlm-MeasRelaxationState* to *true*;

2\> else:

3\> set the *rlm-MeasRelaxationState* to *false*;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide the relaxation state of BFD measurements of a cell group:

2\> for each serving cell of the cell group:

3\> if the UE performs BFD measurement relaxation on this serving cell according to TS 38.133 \[14\]:

4\> set the n-th bit of *bfd-MeasRelaxationState* to \'1\', where n is equal to the *servCellIndex* value + 1 of the serving cell;

3\> else:

4\> set the n-th bit of *bfd-MeasRelaxationState* to \'0\', where n is equal to the *servCellIndex* value + 1 of the serving cell.

1\> if transmission of the *UEAssistanceInformation* message is initiated to indicate availability of data mapped to radio bearers not configured for SDT according to 5.7.4.2:

2\> include the *nonSDT-DataIndication* in the *UEAssistanceInformation* message;

2\> include and set the *resumeCause* according to the information received from the upper layers, if provided.

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide an indication of preference for SCG deactivation according to 5.7.4.2:

2\> include *scg-DeactivationPreference* in the *UEAssistanceInformation* message;

2\> set the *scg-DeactivationPreference* to *scgDeactivationPreferred* if the UE prefers the SCG to be deactivated, otherwise set it to *noPreference*;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide an indication that the UE has uplink data related to a deactivated SCG according to 5.7.4.2:

2\> include *uplinkData* in the *UEAssistanceInformation* message.

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide an indication about whether the criterion for RRM relaxation for connected mode is fulfilled or not fulfilled:

2\> if the criterion for RRM measurement relaxation for connected mode is fulfilled:

3\> set the *rrm-MeasRelaxationFulfilment* to *true*;

2\> else:

3\> set the *rrm-MeasRelaxationFulfilment* to *false*.

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide the service link propagation delay difference between serving cell and neighbour cell(s) according to 5.7.4.2;

2\> include the *propagationDelayDifference* for each neighbour cell in the *neighCellInfoList*;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide preference on multi-Rx operation for FR2 according to 5.7.4.2:

2\> if the UE has a preference for not operating on multi-Rx (i.e. not supporting simultaneous reception with different QCL-typeD) for FR2:

3\> set *multiRx-PreferenceFR2* to the preferred multi-Rx operation for FR2;

2\> else (if the UE has the preference for operating on multi-Rx for FR2):

3\> not include *multiRx-PreferenceFR2*.

1\> if transmission of the *UEAssistanceInformation* message is initiated to indicate the availability of flight path information according to 5.7.4.2 or 5.3.5.3;

2\> include the *flightPathInfoAvailable*;

1\> if transmission of the *UEAssistanceInformation* message is initiated to provide UL traffic information according to 5.7.4.2:

2\> for each PDU session for which the UE intends to provide UL traffic information in this *UEAssistanceInformation* message:

3\> set *pdu-SessionID* to the value of the concerned PDU session ID;

3\> for each QoS flow of this PDU session for which timer T346x is not running and for which the UE intends to provide UL traffic information in this *UEAssistanceInformation* message:

4\> start timer T346x associated to this QoS flow with the timer value set to the value of *ul-TrafficInfoProhibitTimer*;

4\> set *qfi* to the value of the concerned QFI;

4\> if the jitter range measurement is available; and

4\> if the UE did not provide jitter range since it was configured to provide UL traffic information, or if the measured jitter range has changed since the last transmission of the *UEAssistanceInformation* message containing *jitterRange*:

5\> set *jitterRange* to the latest measured value of the jitter range;

4\> if the burst arrival time measurement is available; and

4\> if the UE did not provide burst arrival time since it was configured to provide UL traffic information, or if the measured burst arrival time has changed since the last transmission of the *UEAssistanceInformation* message containing *burstArrivalTime*:

5\> set *burstArrivalTime* to the latest measured value of the burst arrival time;

4\> if the traffic periodicity measurement is available; and

4\> if the UE did not provide traffic periodicity since it was configured to provide UL traffic information, or if the measured traffic periodicity has changed since the last transmission of the *UEAssistanceInformation* message containing *trafficPeriodicity*:

5\> set *trafficPeriodicity* to the latest measured value of the traffic periodicity;

4\> if the UE did not provide *pduSetIdentification* since it was configured to provide UL traffic information, or if the information previously provided in *pduSetIdentification* has changed since the last transmission of the *UEAssistanceInformation* message containing *pduSetIdentification*:

5\> if the UE is able to identify PDU Set related information for the QoS flow:

6\> set *pduSetIdentification* to *true*;

5\> else:

6\> set *pduSetIdentification* to *false*.

1\> if transmission of the *UEAssistanceInformation* message is initiated to report relay UE information with non-3GPP connection(s) according to 5.7.4.2:

2\> include *n3c-relayUE-InfoList* in the *UEAssistanceInformation* message;

The UE shall set the contents of the *UEAssistanceInformation* message for configured grant assistance information for NR sidelink communication or NR sidelink positioning:

1\> if configured to provide configured grant assistance information for NR sidelink communication or NR sidelink positioning:

2\> include the *sl-UE-AssistanceInformationNR*;

NOTE 4: It is up to UE implementation when and how to trigger configured grant assistance information for NR sidelink communication.

The UE shall:

1\> if the procedure was triggered to provide configured grant assistance information for NR sidelink communication by an NR *RRCReconfiguration* message that was embedded within an E-UTRA *RRCConnectionReconfiguration*:

2\> submit the *UEAssistanceInformation* to lower layers via SRB1, embedded in E-UTRA RRC message *ULInformationTransferIRAT* as specified in TS 36.331 \[10\], clause 5.6.28;

1\> else if the procedure was triggered to provide UE preference for SCG deactivation or to indicate that the UE with a deactivate SCG has uplink data to send on a DRB for which there is no MCG RLC bearer:

2\> submit the *UEAssistanceInformation* via SRB1 to lower layers for transmission;

1\> else if the UE is in (NG)EN-DC:

2\> if SRB3 is configured and the SCG is not deactivated:

3\> submit the *UEAssistanceInformation* message via SRB3 to lower layers for transmission;

2\> else:

3\> submit the *UEAssistanceInformation* message via the E-UTRA MCG embedded in E-UTRA RRC message *ULInformationTransferMRDC* as specified in TS 36.331 \[10\].

1\> else if the UE is in NR-DC:

2\> if the UE assistance configuration that triggered this UE assistance information is associated with the SCG:

3\> if SRB3 is configured and the SCG is not deactivated:

4\> submit the *UEAssistanceInformation* message via SRB3 to lower layers for transmission;

3\> else:

4\> submit the *UEAssistanceInformation* message via the NR MCG embedded in NR RRC message *ULInformationTransferMRDC* as specified in 5.7.2a.3;

2\> else:

3\> submit the *UEAssistanceInformation* message via SRB1 to lower layers for transmission;

1\> else:

2\> submit the *UEAssistanceInformation* message to lower layers for transmission.

1\> if the procedure was triggered to provide configured grant assistance information for NR sidelink positioning:

2\> submit the *UEAssistanceInformation* to lower layers via SRB1.

#### 5.7.4.3a Setting the contents of *OverheatingAssistance* IE

The UE shall set the contents of *OverheatingAssistance* IE if initiated to provide overheating assistance indication for SCG in (NG)EN-DC according to clause 5.6.10.3 as specified in TS 36.331 \[10\]:

1\> if the UE prefers to temporarily reduce the number of maximum secondary component carriers for SCG:

2\> include *reducedMaxCCs* in the *OverheatingAssistance* IE;

2\> set *reducedCCsDL* to the number of maximum SCells of the SCG the UE prefers to be temporarily configured in downlink;

2\> set *reducedCCsUL* to the number of maximum SCells of the SCG the UE prefers to be temporarily configured in uplink;

1\> if the UE prefers to temporarily reduce maximum aggregated bandwidth of FR1 for SCG:

2\> include *reducedMaxBW-FR1* in the *OverheatingAssistance* IE;

2\> set *reducedBW-FR1-DL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all downlink carriers of FR1 of the SCG;

2\> set *reducedBW-FR1-UL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all uplink carriers of FR1 of the SCG;

1\> if the UE prefers to temporarily reduce maximum aggregated bandwidth of FR2-1 for SCG:

2\> include *reducedMaxBW-FR2* in the *OverheatingAssistance* IE;

2\> set *reducedBW-FR2-DL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all downlink carriers of FR2-1 of the SCG;

2\> set *reducedBW-FR2-UL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all uplink carriers of FR2-1 of the SCG;

1\> if the UE prefers to temporarily reduce maximum aggregated bandwidth of FR2-2 for SCG:

2\> include *reducedMaxBW-FR2-2* in the *OverheatingAssistance* IE;

2\> set *reducedBW-FR2-2-DL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all downlink carriers of FR2-2 of the SCG;

2\> set *reducedBW-FR2-2-UL* to the maximum aggregated bandwidth the UE prefers to be temporarily configured across all uplink carriers of FR2-2 of the SCG;

1\> if the UE prefers to temporarily reduce the number of maximum MIMO layers of each serving cell operating on FR1 for SCG:

2\> include *reducedMaxMIMO-LayersFR1* in the *OverheatingAssistance* IE;

2\> set *reducedMIMO-LayersFR1-DL* to the number of maximum MIMO layers of each serving cell operating on FR1 of the SCG the UE prefers to be temporarily configured in downlink;

2\> set *reducedMIMO-LayersFR1-UL* to the number of maximum MIMO layers of each serving cell operating on FR1 of the SCG the UE prefers to be temporarily configured in uplink;

1\> if the UE prefers to temporarily reduce the number of maximum MIMO layers of each serving cell operating on FR2-1 for SCG:

2\> include *reducedMaxMIMO-LayersFR2* in the *OverheatingAssistance* IE;

2\> set *reducedMIMO-LayersFR2-DL* to the number of maximum MIMO layers of each serving cell operating on FR2-1 of the SCG the UE prefers to be temporarily configured in downlink;

2\> set *reducedMIMO-LayersFR2-UL* to the number of maximum MIMO layers of each serving cell operating on FR2-1 of the SCG the UE prefers to be temporarily configured in uplink;

1\> if the UE prefers to temporarily reduce the number of maximum MIMO layers of each serving cell operating on FR2-2 for SCG:

2\> include *reducedMaxMIMO-LayersFR2-2* in the *OverheatingAssistance* IE;

2\> set *reducedMIMO-LayersFR2-2-DL* to the number of maximum MIMO layers of each serving cell operating on FR2-2 of the SCG the UE prefers to be temporarily configured in downlink;

2\> set *reducedMIMO-LayersFR2-2-UL* to the number of maximum MIMO layers of each serving cell operating on FR2-2 of the SCG the UE prefers to be temporarily configured in uplink;

#### 5.7.4.4 Relaxed measurement criterion for a stationary (e)RedCap UE

The relaxed measurement criterion for a stationary UE is met when:

- $(SS-RSRP_RefStationaryConnected - SS-RSRP) < S_SearchDeltaP-StationaryConnected$,

Where:

- SS-RSRP = current L3 RSRP measurement of the PCell based on SSB (dB).

- $SS-RSRP_RefStationaryConnected = reference SS-RSRP value of the PCell (dB)$, set as follows:

- at the end of RRC reconfiguration procedure as specified in 5.3.5.3, when *rrm-MeasRelaxationReportingConfig* is included in the *RRCReconfiguration* message; or

- after MAC successfully completes a Random Access procedure after applying a *reconfigurationWithSync* in *spCellConfig* while stationary criterion is configured; or

- if $(SS-RSRP - SS-RSRP_RefStationaryConnected) > 0$; or

- if the relaxed measurement criterion has not been met for T~SearchDeltaP-StationaryConnected~:

- UE shall set the value of SS-RSRP~RefStationaryConnected~ to the current SS-RSRP value of the serving cell.

### 5.7.4a Void

### 5.7.5 Failure information

#### 5.7.5.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: FailureInformation [ac];
|||;
~~~

Figure 5.7.5.1-1: Failure information

The purpose of this procedure is to inform the network about a failure detected by the UE.

#### 5.7.5.2 Initiation

A UE initiates the procedure when there is a need inform the network about a failure detected by the UE. In particular, the UE initiates the procedure when the following condition is met:

1\> upon detecting failure for an RLC bearer, in accordance with 5.3.10.3;

1\> upon detecting DAPS handover failure, in accordance with 5.3.5.8.3;

Upon initiating the procedure, the UE shall:

1\> initiate transmission of the *FailureInformation* message as specified in 5.7.5.3;

#### 5.7.5.3 Actions related to transmission of *FailureInformation* message

The UE shall:

1\> if initiated to provide RLC failure information, set *FailureInfoRLC-Bearer* as follows:

2\> set *logicalChannelIdentity* to the logical channel identity of the failing RLC bearer;

2\> set *cellGroupId* to the cell group identity of the failing RLC bearer;

2\> set the *failureType* as *rlc-failure*;

1\> if initiated to provide DAPS failure information, set *FailureInfoDAPS* as follows:

2\> set the *failureType* as *daps-failure*;

1\> if used to inform the network about a failure for an MCG RLC bearer or DAPS failure information:

2\> submit the *FailureInformation* message to lower layers for transmission via SRB1;

1\> else if used to inform the network about a failure for an SCG RLC bearer:

2\> if SRB3 is configured;

3\> submit the *FailureInformation* message to lower layers for transmission via SRB3;

2\> else;

3\> if the UE is in (NG)EN-DC:

4\> submit the *FailureInformation* message via E-UTRA SRB1 embedded in E-UTRA RRC message *ULInformationTransferMRDC* as specified in TS 36.331 \[10\].

3\> else if the UE is in NR-DC:

4\> submit the *FailureInformation* message via SRB1 embedded in NR RRC message *ULInformationTransferMRDC* as specified in clause 5.7.2a.3.

### 5.7.6 DL message segment transfer

#### 5.7.6.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u<-n: DLDedicatedMessageSegment [ac];
|||;
~~~

Figure 5.7.6.1-1: DL message segment transfer

The purpose of this procedure is to transfer segments of DL DCCH messages from the network to the UE.

NOTE: The segmentation of DL DCCH message is only applicable to *RRCReconfiguration* and *RRCResume* messages in this release.

#### 5.7.6.2 Initiation

The network initiates the DL Dedicated Message Segment transfer procedure whenever the encoded RRC message PDU exceeds the maximum PDCP SDU size. The network initiates the DL Dedicated Message Segment transfer procedure by sending the *DLDedicatedMessageSegment* message.

#### 5.7.6.3 Reception of *DLDedicatedMessageSegment* by the UE

Upon receiving *DLDedicatedMessageSegment* message, the UE shall:

1\> store the segment included in *rrc-MessageSegmentContainer*;

1\> if all segments of the message have been received:

2\> assemble the message from the received segments and process the message according to 5.3.5.3 for the *RRCReconfiguration* message or 5.3.13.4 for the *RRCResume* message;

2\> discard all segments.

### 5.7.7 UL message segment transfer

#### 5.7.7.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
u->n: ULDedicatedMessageSegment [ac];
|||;
~~~

Figure 5.7.7.1-1: UL message segment transfer

The purpose of this procedure is to transfer segments of UL DCCH messages from UE to a NG-RAN in RRC_CONNECTED.

NOTE: The segmentation of UL DCCH message is only applicable to *UECapabilityInformation* and *MeasurementReportAppLayer* in this release.

#### 5.7.7.2 Initiation

A UE capable of UL RRC message segmentation in RRC_CONNECTED will initiate the procedure when the following conditions are met:

1\> if the RRC message segmentation is enabled based on the field *rrc-SegAllowed*, *rrc-SegAllowedSRB4* or *rrc-SegAllowedSRB5* received, and

1\> if the encoded RRC message is larger than the maximum supported size of a PDCP SDU specified in TS 38.323 \[5\];

Upon initiating the procedure, the UE shall:

1\> initiate transmission of the *ULDedicatedMessageSegment* message as specified in 5.7.7.3;

#### 5.7.7.3 Actions related to transmission of *ULDedicatedMessageSegment* message

The UE shall segment the encoded RRC PDU based on the maximum supported size of a PDCP SDU specified in TS 38.323 \[5\]. UE shall minimize the number of segments and set the contents of the *ULDedicatedMessageSegment* messages as follows:

1\> For each new UL DCCH message, set the *segmentNumber* to 0 for the first message segment and increment the *segmentNumber* for each subsequent RRC message segment;

1\> set *rrc-MessageSegmentContainer* to include the segment of the UL DCCH message corresponding to the *segmentNumber*;

1\> if the segment included in the *rrc-MessageSegmentContainer* is the last segment of the UL DCCH message:

2\> set the *rrc-MessageSegmentType* to *lastSegment*;

1\> else:

2\> set the *rrc-MessageSegmentType* to *notLastSegment*;

1\> submit all the *ULDedicatedMessageSegment* messages generated for the segmented RRC message to lower layers for transmission in ascending order based on the *segmentNumber*, upon which the procedure ends.

### 5.7.8 Idle/inactive Measurements

#### 5.7.8.1 General

This procedure specifies the measurements to be performed and stored by a UE in RRC_IDLE and RRC_INACTIVE when it has an idle/inactive measurement configuration.

#### 5.7.8.1a Measurement configuration

The purpose of this procedure is to update the idle/inactive measurement configuration.

The UE initiates this procedure while T331 is running and SDT procedure is not ongoing and one of the following conditions is met:

1\> upon selecting a cell when entering RRC_IDLE or RRC-INACTIVE from RRC_CONNECTED or RRC_INACTIVE; or

1\> upon update of system information (*SIB4*, or *SIB11*), e.g. due to intra-RAT cell (re)selection;

While in RRC_IDLE or RRC_INACTIVE, and T331 is running, the UE shall:

1\> if *VarMeasIdleConfig* includes neither a *measIdleCarrierListEUTRA* nor a *measIdleCarrierListNR* received from the *RRCRelease* message:

2\> if the UE supports *idleInactiveEUTRA-MeasReport*:

3\> if the SIB11 includes the *measIdleConfigSIB* and contains *measIdleCarrierListEUTRA*:

4\> store or replace the *measIdleCarrierListEUTRA* of *measIdleConfigSIB* of SIB11 within *VarMeasIdleConfig*;

3\> else:

4\> remove the *measIdleCarrierListEUTRA* in *VarMeasIdleConfig*, if stored;

2\> if the UE supports *idleInactiveNR-MeasReport*:

3\> if *SIB11* includes the *measIdleConfigSIB* and contains *measIdleCarrierListNR*:

4\> store or replace the *measIdleCarrierListNR* of *measIdleConfigSIB* of *SIB11* within *VarMeasIdleConfig*;

3\> else:

4\> remove the *measIdleCarrierListNR* in *VarMeasIdleConfig*, if stored;

1\> for each entry in the *measIdleCarrierListNR* within *VarMeasIdleConfig* that does not contain an *ssb-MeasConfig* received from the *RRCRelease* message:

2\> if there is an entry in *measIdleCarrierListNR* in *measIdleConfigSIB* of *SIB11* that has the same carrier frequency and subcarrier spacing as the entry in the *measIdleCarrierListNR* within *VarMeasIdleConfig* and that contains *ssb-MeasConfig*:

3\> delete the *ssb-MeasConfig* of the corresponding entry in the *measIdleCarrierListNR* within *VarMeasIdleConfig*;

3\> store the SSB measurement configuration from *SIB11* into *nrofSS-BlocksToAverage*, *absThreshSS-BlocksConsolidation*, *smtc*, *ssb-ToMeasure*, *deriveSSB-IndexFromCell*, and *ss-RSSI-Measurement* within *ssb-MeasConfig* of the corresponding entry in the *measIdleCarrierListNR* within *VarMeasIdleConfig*;

2\> else if there is an entry in *interFreqCarrierFreqList* of *SIB4* with the same carrier frequency and subcarrier spacing as the entry in *measIdleCarrierListNR* within *VarMeasIdleConfig*:

3\> delete the *ssb-MeasConfig* of the corresponding entry in the *measIdleCarrierListNR* within *VarMeasIdleConfig*;

3\> store the SSB measurement configuration from *SIB4* into *nrofSS-BlocksToAverage*, *absThreshSS-BlocksConsolidation*, *smtc*, *ssb-ToMeasure*, *deriveSSB-IndexFromCell*, and *ss-RSSI-Measurement* within *ssb-MeasConfig* of the corresponding entry in the *measIdleCarrierListNR* within *VarMeasIdleConfig*;

2\> else:

3\> remove the *ssb-MeasConfig* of the corresponding entry in the *measIdleCarrierListNR* within *VarMeasIdleConfig*, if stored;

1\> perform measurements according to 5.7.8.2a.

#### 5.7.8.2 Void

#### 5.7.8.2a Performing measurements

When performing measurements on NR carriers according to this clause, the UE shall derive the cell quality as specified in 5.5.3.3 and consider the beam quality to be the value of the measurement results of the concerned beam, where each result is averaged as described in TS 38.215 \[9\].

While in RRC_IDLE or RRC_INACTIVE, and T331 is running and SDT procedure is not ongoing, the UE shall:

1\> perform the measurements in accordance with the following:

2\> if the *VarMeasIdleConfig* includes the *measIdleCarrierListEUTRA* and the *SIB1* contains *idleModeMeasurementsEUTRA*:

3\> for each entry in *measIdleCarrierListEUTRA* within *VarMeasIdleConfig*:

4\> if UE supports NE-DC between the serving carrier and the carrier frequency indicated by *carrierFreqEUTRA* within the corresponding entry:

5\> perform measurements in the carrier frequency and bandwidth indicated by *carrierFreqEUTRA* and *allowedMeasBandwidth* within the corresponding entry;

5\> if the *reportQuantitiesEUTRA* is set to *rsrq*:

6\> consider RSRQ as the sorting quantity;

5\> else:

6\> consider RSRP as the sorting quantity;

5\> if the *measCellListEUTRA* is included:

6\> consider cells identified by each entry within the *measCellListEUTRA* to be applicable for idle/inactive mode measurement reporting;

5\> else:

6\> consider up to *maxCellMeasIdle* strongest identified cells, according to the sorting quantity, to be applicable for idle/inactive measurement reporting;

5\> for all cells applicable for idle/inactive measurement reporting, derive measurement results for the measurement quantities indicated by *reportQuantitiesEUTRA;*

5\> store the derived measurement results as indicated by *reportQuantitiesEUTRA* within the *measReportIdleEUTRA* in *VarMeasIdleReport* in decreasing order of the sorting quantity, i.e. the best cell is included first, as follows:

6\> if *qualityThresholdEUTRA* is configured:

7\> include the measurement results from the cells applicable for idle/inactive measurement reporting whose RSRP/RSRQ measurement results are above the value(s) provided in *qualityThresholdEUTRA;*

6\> else:

7\> include the measurement results from all cells applicable for idle/inactive measurement reporting;

2\> if the *VarMeasIdleConfig* includes the *measIdleCarrierListNR* and the SIB1 contains *idleModeMeasurementsNR*:

3\> for each entry in *measIdleCarrierListNR* within *VarMeasIdleConfig* that contains *ssb-MeasConfig*:

4\> if UE supports carrier aggregation or NR-DC between serving carrier and the carrier frequency and subcarrier spacing indicated by *carrierFreq* and *ssbSubCarrierSpacing* within the corresponding entry:

5\> perform measurements in the carrier frequency and subcarrier spacing indicated by *carrierFreq* and *ssbSubCarrierSpacing* within the corresponding entry;

5\> if the *reportQuantities* is set to rsrq:

6\> consider RSRQ as the cell sorting quantity;

5\> else:

6\> consider RSRP as the cell sorting quantity;

5\> if the *measCellListNR* is included:

6\> consider cells identified by each entry within the *measCellListNR* to be applicable for idle/inactive measurement reporting;

5\> else:

6\> consider up to *maxCellMeasIdle* strongest identified cells, according to the sorting quantity, to be applicable for idle/inactive measurement reporting;

5\> for all cells applicable for idle/inactive measurement reporting, derive cell measurement results for the measurement quantities indicated by *reportQuantities;*

5\> store the derived cell measurement results as indicated by *reportQuantities* for cells applicable for idle/inactive measurement reporting within *measResultsPerCarrierListIdleNR* in the *measReportIdleNR* in *VarMeasIdleReport* in decreasing order of the cell sorting quantity, i.e. the best cell is included first, as follows:

6\> if *qualityThreshold* is configured:

7\> include the measurement results from the cells applicable for idle/inactive measurement reporting whose RSRP/RSRQ measurement results are above the value(s) provided in *qualityThreshold;*

6\> else:

7\> include the measurement results from all cells applicable for idle/inactive measurement reporting;

5\> if *beamMeasConfigIdle* is included in the associated entry in *measIdleCarrierListNR* and if UE supports *idleInactiveNR-MeasBeamReport* for the FR of the carrier frequency indicated by *carrierFreq* within the associated entry, for each cell in the measurement results:

6\> derive beam measurements based on SS/PBCH block for each measurement quantity indicated in *reportQuantityRS-Indexes*, as described in TS 38.215 \[9\];

6\> if the *reportQuantityRS-Indexes* is set to rsrq:

7\> consider RSRQ as the beam sorting quantity;

6\> else:

7\> consider RSRP as the beam sorting quantity;

6\> set *resultsSSB-Indexes* to include up to *maxNrofRS-IndexesToReport* SS/PBCH block indexes in order of decreasing beam sorting quantity as follows:

7\> include the index associated to the best beam for the sorting quantity and if *absThreshSS-BlocksConsolidation* is included, the remaining beams whose sorting quantity is above *absThreshSS-BlocksConsolidation*;

6\> if the *includeBeamMeasurements* is set to *true*:

7\> include the beam measurement results as indicated by *reportQuantityRS*-*Indexes*;

2\> if, as a result of the procedure in this clause, the UE performs measurements in one or more carrier frequency indicated by *measIdleCarrierListNR* or *measIdleCarrierListEUTRA*:

3\> store the cell measurement results for RSRP and RSRQ for the serving cell within *measResultServingCell* in the measReportIdleNR in *VarMeasIdleReport*.

3\> if the *VarMeasIdleConfig* includes the *measIdleCarrierListNR* and it contains an entry with *carrierFreq* set to the value of the serving frequency:

4\> if *beamMeasConfigIdle* is included in that entry, and if the UE supports *idleInactiveNR- MeasBeamReport* for the FR of the serving cell:

5\> derive beam measurements based on SS/PBCH block for each measurement quantity indicated in *reportQuantityRS-Indexes*, as described in TS 38.215 \[9\];

5\> if the *reportQuantityRS-Indexes* is set to rsrq:

6\> consider RSRQ as the beam sorting quantity;

5\> else:

6\> consider RSRP as the beam sorting quantity;

5\> set *resultsSSB-Indexes* to include up to *maxNrofRS-IndexesToReport* SS/PBCH block indexes in order of decreasing beam sorting quantity as follows:

6\> include the index associated to the best beam for the sorting quantity and if *absThreshSS-BlocksConsolidation* is included in *SIB2* of serving cell, the remaining beams whose sorting quantity is above *absThreshSS-BlocksConsolidation*;

5\> if the *includeBeamMeasurements* is set to true:

6\> include the beam measurement results as indicated by *reportQuantityRS-Indexes*;

NOTE 1: How the UE performs idle/inactive measurements is up to UE implementation as long as the requirements in TS 38.133 \[14\] are met for measurement reporting.

NOTE 2: The UE is not required to perform idle/inactive measurements on a given carrier if the SSB configuration of that carrier provided via dedicated signaling is different from the SSB configuration broadcasted in the serving cell, if any.

NOTE 3: How the UE prioritizes which frequencies to measure or report (in case it is configured with more frequencies than it can measure or report) is left to UE implementation.

NOTE 4: When *idleModeMeasVoiceFallback* is included in SIB5, UE may decide to measure and report idle/inactive measurements for EUTRA carrier frequencies included in SIB5 even if it does not support NE-DC between the serving carrier and the EUTRA carrier frequencies.

#### 5.7.8.3 T331 expiry or stop

The UE shall:

1\> if T331 expires or is stopped:

2\> release the *VarMeasIdleConfig*.

NOTE: It is up to UE implementation whether to continue idle/inactive measurements according to SIB11 and SIB4 configurations or according to E-UTRA SIB5 and E-UTRA SIB24 configurations as specified in TS 36.331 \[10\] upon inter-RAT cell reselection to E-UTRA, after T331 has expired or stopped.

#### 5.7.8.4 Cell re-selection or cell selection while T331 is running

The UE shall:

1\> if intra-RAT cell selection or reselection occurs while T331 is running:

2\> if *validityAreaList* is configured in *VarMeasIdleConfig*:

3\> if the serving frequency does not match with the *carrierFreq* of an entry in the *validityAreaList*; or

3\> if the serving frequency matches with the *carrierFreq* of an entry in the *validityAreaList*, the *validityCellList* is included in that entry, and the physical cell identity of the serving cell does not match with any entry in *validityCellList*:

4\> stop timer T331;

4\> perform the actions as specified in 5.7.8.3, upon which the procedure ends.

1\> else if inter-RAT cell selection or reselection occurs while T331 is running:

2\> stop timer T331;

2\> perform the actions as specified in 5.7.8.3;

### 5.7.9 Mobility history information

#### 5.7.9.1 General

This procedure specifies how the mobility history information is stored by the UE, covering RRC_IDLE, RRC_INACTIVE and RRC_CONNECTED and released by the UE upon deregistration.

#### 5.7.9.2 Initiation

If the UE supports storage of mobility history information, the UE shall:

1\> If the UE supports PSCell mobility history information and upon addition of a PSCell:

2\> include an entry in *visitedPSCellInfoList* in variable *VarMobilityHistoryReport* possibly after performing the following, if necessary:

3\> if *visitedPSCellInfoListReport* is available in the *visitedCellInfoList* in variable *VarMobilityHistoryReport*:

4\> for the oldest PCell entry in *visitedCellInfoList* including *visitedPSCellInfoListReport*;

5\> remove the oldest entry in the *visitedPSCellInfoListReport*;

3\> else:

4\> remove the oldest entry in *visitedPSCellInfoList* in variable *VarMobilityHistoryReport*;

2\> for the included entry:

3\> set the field *timeSpent* of the entry according to following:

4\> if this is the first PSCell entry for the current PCell since entering the current PCell in RRC_CONNECTED:

5\> include the entry as the time spent with no PSCell since entering the current PCell in RRC_CONNECTED;

4\> else:

5\> include the time spent with no PSCell since last PSCell release since entering the current PCell in RRC_CONNECTED;

1\> If the UE supports PSCell mobility history information and upon change, or release of a PSCell while being connected to the current PCell:

2\> include an entry in *visitedPSCellInfoList* of the variable *VarMobilityHistoryReport* possibly after performing the following, if necessary:

3\> if *visitedPSCellInfoListReport* is available in the *visitedCellInfoList* in variable *VarMobilityHistoryReport*:

4\> for the oldest PCell entry in *visitedCellInfoList* including *visitedPSCellInfoListReport*;

5\> remove the oldest entry in the *visitedPSCellInfoListReport*;

3\> else:

4\> remove the oldest entry in *visitedPSCellInfoList* in variable *VarMobilityHistoryReport*;

2\> for the included entry:

3\> if the global cell identity of the previous PSCell is available:

4\> include the global cell identity of that cell in the field *visitedCellId* of the entry;

3\> else:

4\> include the physical cell identity and carrier frequency of that cell in the field *visitedCellId* of the entry;

3\> set the field *timeSpent* of the entry as the time spent in the previous PSCell while being connected to the current PCell;

1\> Upon change of suitable cell, consisting of PCell in RRC_CONNECTED (for NR or E-UTRA cell) or serving cell in RRC_INACTIVE (for NR cell) or in RRC_IDLE (for NR or E-UTRA cell), to another NR or E-UTRA cell, or when entering any cell selection\' state from \'camped normally\' state in NR or LTE or when entering \'any cell selection\' state from a suitable cell in RRC_CONNECTED state in NR or LTE:

2\> include an entry in *visitedCellInfoList* of the variable *VarMobilityHistoryReport* possibly after removing the oldest entry, if necessary, according to following*:*

3\> if the global cell identity of the previous PCell/serving cell is available:

4\> include the global cell identity of that cell in the field *visitedCellId* of the entry;

3\> else:

4\> include the physical cell identity and carrier frequency of that cell in the field *visitedCellId* of the entry;

3\> set the field *timeSpent* of the entry as the time spent in the previous PCell/serving cell;

3\> if the UE supports PSCell mobility history information and if the UE continues to be connected to the same PSCell during the change of the PCell in RRC_CONNECTED; or

3\> if the UE supports PSCell mobility history information and if the UE changes PSCell at the same time as the change of the PCell in RRC_CONNECTED; or

3\> if the UE supports PSCell mobility history information and if the PSCell is released at the same time as the change of the PCell in RRC_CONNECTED:

> 4\> include an entry in *visitedPSCellInfoList* of the variable *VarMobilityHistoryReport* possibly after performing the following, if necessary:

5\> if *visitedPSCellInfoListReport* is available in the *visitedCellInfoList* in variable *VarMobilityHistoryReport*:

6\> for the oldest PCell entry in *visitedCellInfoList* including *visitedPSCellInfoListReport*;

7\> remove the oldest entry in the *visitedPSCellInfoListReport*;

5\> else:

6\> remove the oldest entry in *visitedPSCellInfoList* in variable *VarMobilityHistoryReport*;

> 4\> for the included entry:

5\> if the global cell identity of the PSCell (in case the UE continues to be connected to the same PSCell) or the previous PSCell (in case the UE changes PSCell, or in case PSCell is released) is available:

> 6\> include the global cell identity of that cell in the field *visitedCellId* of the entry;

5\> else:

6\> include the physical cell identity and carrier frequency of that cell in the field *visitedCellId* of the entry;

5\> set the field *timeSpent* of the entry as the time spent in the PSCell, while being connected to previous PCell;

3\> if the UE supports PSCell mobility history information and if the UE was not configured with a PSCell at the time of change of PCell in RRC_CONNECTED:

4\> include an entry in *visitedPSCellInfoList* after performing the following, if necessary;

5\> if *visitedPSCellInfoListReport* is available in the *visitedCellInfoList* in variable *VarMobilityHistoryReport*:

6\> for the oldest PCell entry in *visitedCellInfoList* including *visitedPSCellInfoListReport*;

7\> remove the oldest entry in the *visitedPSCellInfoListReport*;

5\> else:

6\> remove the oldest entry in *visitedPSCellInfoList* in variable *VarMobilityHistoryReport*;

4\> for the included entry:

5\> set the field *timeSpent* of the entry as the time without PSCell according to the following:

> 6\> if the UE experienced a PSCell release since entering the previous PCell in RRC_CONNECTED:
>
> 7\> include the time spent with no PSCell since last PSCell release since entering the previous PCell in RRC_CONNECTED;

6\> else:

7\> include the time spent with no PSCell since entering the previous PCell in RRC_CONNECTED;

3\> if the UE supports PSCell mobility history information and if *visitedPSCellInfoList* exists in *VarMobilityHistoryReport*:

> 4\> include *visitedPSCellInfoList* in *VarMobilityHistoryReport* in the *visitedPSCellInfoListReport* within the entry of the *visitedCellInfoList* associated to the latest PCell entry;
>
> 4\> remove *visitedPSCellInfoList* from the variable *VarMobilityHistoryReport*;

1\> if the UE supports PSCell mobility history information and upon entering \'camped normally\' state in NR (in RRC_IDLE or RRC_INACTIVE) or E-UTRA (in RRC_IDLE) while previously in RRC_CONNECTED state NR or LTE while not connected to a PSCell:

2\> include an entry in *visitedPSCellInfoList* after performing the following, if necessary;

3\> if *visitedPSCellInfoListReport* is available in the *visitedCellInfoList* in variable *VarMobilityHistoryReport*:

4\> for the oldest PCell entry in *visitedCellInfoList* including *visitedPSCellInfoListReport*;

5\> remove the oldest entry in the *visitedPSCellInfoListReport*;

3\> else:

4\> remove the oldest entry in *visitedPSCellInfoList* in variable *VarMobilityHistoryReport*;

2\> for the included entry:

3\> set the field *timeSpent* of the entry as the time without PSCell according to the following:

4\> if the UE experienced a PSCell release since entering the current PCell in RRC_CONNECTED:

5\> include the time spent with no PSCell since last PSCell release after entering the current PCell in RRC_CONNECTED;

4\> else:

5\> include the time spent with no PSCell since entering the current PCell in RRC_CONNECTED;

1\> upon entering \'camped normally\' state in NR (in RRC_IDLE or RRC_INACTIVE) or E-UTRA (in RRC_IDLE) while previously in \'any cell selection\' state or \'camped on any cell\' state in NR or LTE:

2\> include an entry in variable *VarMobilityHistoryReport* possibly after removing the oldest entry, if necessary, according to following:

3\> set the field *timeSpent* of the entry as the time spent in \'any cell selection\' state and/or \'camped on any cell\' state in NR or LTE.

#### 5.7.9.3 Release of Mobility History Information

If the UE supports storage of mobility history information, the UE shall:

1\> if stored, discard the mobility history information, i.e. release the UE variable *VarMobilityHistoryReport* upon deregistration from the network.

### 5.7.10 UE Information

#### 5.7.10.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

u: UE;
n: Network;

|||;
n->u: UEInformationRequest [ac];
u->n: UEInformationResponse [ac];
|||;
~~~

Figure 5.7.10.1-1: UE information procedure

The UE information procedure is used by the network to request the UE to report information.

#### 5.7.10.2 Initiation

The network initiates the procedure by sending the *UEInformationRequest* message. The network should initiate this procedure only after successful security activation.

#### 5.7.10.3 Reception of the *UEInformationRequest* message

Upon receiving the *UEInformationRequest* message, the UE shall, only after successful security activation:

1\> if the *idleModeMeasurementReq* is included in the *UEInformationRequest* and the UE has stored *VarMeasIdleReport* that contains measurement information concerning cells other than the PCell:

2\> set the *measResultIdleEUTRA* in the *UEInformationResponse* message to the value of *measReportIdleEUTRA* in the *VarMeasIdleReport, if available*;

2\> set the *measResultIdleNR* in the *UEInformationResponse* message to the value of *measReportIdleNR* in the *VarMeasIdleReport*, if available;

2\> discard the *VarMeasIdleReport* upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

1\> if the *logMeasReportReq* is present and if the RPLMN is included in *plmn-IdentityList* stored in *VarLogMeasReport*, or if the current registered SNPN is included in *snpn-ConfigIDList* stored in *VarLogMeasReport*:

2\> if *VarLogMeasReport* includes one or more logged measurement entries, set the contents of the *logMeasReport* in the *UEInformationResponse* message as follows:

3\> include the *absoluteTimeStamp* and set it to the value of *absoluteTimeInfo* in the *VarLogMeasReport*;

3\> include the *traceReference* and set it to the value of *traceReference* in the *VarLogMeasReport*;

3\> include the *traceRecordingSessionRef* and set it to the value of *traceRecordingSessionRef* in the *VarLogMeasReport;*

3\> include the *tce-Id* and set it to the value of *tce-Id* in the *VarLogMeasReport*;

3\> include the *logMeasInfoList* and set it to include one or more entries from the *VarLogMeasReport* starting from the entries logged first, and for each entry of the *logMeasInfoList* that is included, include all information stored in the corresponding *logMeasInfoList* entry in *VarLogMeasReport*;

3\> if the *VarLogMeasReport* includes one or more additional logged measurement entries that are not included in the *logMeasInfoList* within the *UEInformationResponse* message:

4\> include the *logMeasAvailable*;

4\> if *bt-LocationInfo* is included in *locationInfo* of one or more of the additional logged measurement entries in *VarLogMeasReport* that are not included in the *logMeasInfoList* within the *UEInformationResponse* message:

5\> include the *logMeasAvailableBT*;

4\> if *wlan-LocationInfo* is included in *locationInfo* of one or more of the additional logged measurement entries in *VarLogMeasReport* that are not included in the *logMeasInfoList* within the *UEInformationResponse* message:

5\> include the *logMeasAvailableWLAN*;

1\> if *ra-ReportReq* is set to *true* and the UE has random access related information available in *VarRA-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarRA-Report*; or

1\> if *ra-ReportReq* is set to *true* and the UE has random access related information available in *VarRA-Report* and if the registered SNPN is included in *snpn-IdentityList* stored in *VarRA-Report*:

2\> set the *ra-ReportList* in the *UEInformationResponse* message to the value of *ra-ReportList* in *VarRA-Report*;

2\> discard the *ra-ReportList* from *VarRA-Report* upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

1\> if *rlf-ReportReq* is set to *true*:

2\> if the UE has radio link failure information or handover failure information available in *VarRLF-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report*; or

2\> if the UE has radio link failure information or handover failure information available in *VarRLF-Report* and if the current registered SNPN is included in *snpn-IdentityList* stored in *VarRLF-Report*:

3\> set *timeSinceFailure* in *VarRLF-Report* to the time that elapsed since the last radio link failure or handover failure in NR;

3\> set the *rlf-Report* in the *UEInformationResponse* message to the value of *rlf-Report* in *VarRLF-Report*;

3\> discard the *rlf-Report* from *VarRLF-Report* upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

2\> else if the UE is capable of cross-RAT RLF reporting as defined in TS 38.306 \[26\] and has radio link failure information or handover failure information available in *VarRLF-Report* of TS 36.331 \[10\] and if the RPLMN is included in *plmn-IdentityList* stored in *VarRLF-Report* of TS 36.331 \[10\]:

3\> set *timeSinceFailure* in *VarRLF-Report* of TS 36.331 \[10\] to the time that elapsed since the last radio link failure or handover failure in EUTRA;

3\> set failedPCellId-EUTRA in the *rlf-Report* in the *UEInformationResponse* message to indicate the PCell in which RLF was detected or the source PCell of the failed handover in the *VarRLF-Report* of TS 36.331 \[10\];

3\> set the *measResult-RLF-Report-EUTRA* in the *rlf-Report* in the *UEInformationResponse* message to the value of *rlf-Report* in *VarRLF-Report* of TS 36.331 \[10\];

3\> discard the *rlf-Report* from *VarRLF-Report* of TS 36.331 \[10\] upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

1\> if *connEstFailReportReq* is set to *true* and the UE has connection establishment failure or connection resume failure information in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the RPLMN is equal to *plmn-Identity* stored in *VarConnEstFailReport* or in at least one of the entries of *VarConnEstFailReportList*:

1\> if *connEstFailReportReq* is set to *true* and if the UE has connection establishment failure information or connection resume failure information available in *VarConnEstFailReport* or *VarConnEstFailReportList* and if the registered SNPN identity is equal to *snpn-identity* stored in *VarConnEstFailReport* or any entry of *VarConnEstFailReportList*:

2\> set *timeSinceFailure* in *VarConnEstFailReport* to the time that elapsed since the last connection establishment failure or connection resume failure in NR;

2\> set the *connEstFailReport* in the *UEInformationResponse* message to the value of *connEstFailReport* in *VarConnEstFailReport*;

2\> if the UE supports multiple CEF report:

3\> for each *connEstFailReport* in the *connEstFailReportList* in *VarConnEstFailReportList*:

4\> set *timeSinceFailure* to the time that elapsed since the associated connection establishment failure or connection resume failure in NR;

2\> for each *connEstFailReport* in the *connEstFailReportList* in the *UEInformationResponse* message, set the value to the value of *connEstFailReport* in *VarConnEstFailReport* in *VarConnEstFailReportList*;

2\> discard the *connEstFailReport* from *VarConnEstFailReport* and *VarConnEstFailReportList* upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

1\> if the *mobilityHistoryReportReq* is set to *true*:

2\> include the *mobilityHistoryReport* and set it to include *visitedCellInfoList* from *VarMobilityHistoryReport*;

2\> include in the *mobilityHistoryReport* an entry for the current PCell, possibly after removing the oldest entry if required, and set its fields as follows:

3\> set *visitedCellId* to the global cell identity or the physical cell identity and carrier frequency of the current PCell:

3\> set field *timeSpent* to the time spent in the current PCell;

3\> if the UE supports PSCell mobility history information and if *visitedPSCellInfoList* is present in *VarMobilityHistoryReport*:

4\> for the newest entry of the PCell in the *mobilityHistoryReport*, include *visitedPSCellInfoList* from *VarMobilityHistoryReport*;

4\> if the UE is configured with a PSCell:

5\> for the newest entry of the PCell in the *mobilityHistoryReport*, include the current PSCell information in the *visitedPSCellInfoListReport,* possibly after removing the oldest PSCell entry of a PCell in the *mobilityHistoryReport*, if required, and set its fields as follows:

6\> set *visitedCellId* to the global cell identity or the physical cell identity and carrier frequency of the current PSCell:

6\> set field *timeSpent* to the time spent in the current PSCell while being connected to the current PCell;

4\> else:

5\> for the newest entry of the PCell in the *mobilityHistoryReport*, include a new entry in the *visitedPSCellInfoListReport,* possibly after removing the oldest PSCell entry of a PCell in the *mobilityHistoryReport*, if required, and set its fields as follows:

6\> set field *timeSpent* to the time spent without PSCell in the current PCell since last PSCell release since connected to the current PCell in RRC_CONNECTED;

3\> else if the UE supports PSCell mobility history information:

4\> if the UE is configured with a PSCell:

5\> for the newest entry of the PCell in the *mobilityHistoryReport*, include the current PSCell information in the *visitedPSCellInfoListReport,* possibly after removing the oldest PSCell entry of a PCell in the *mobilityHistoryReport*, if required, and set its fields as follows:

6\> set *visitedCellId* to the global cell identity or the physical cell identity and carrier frequency of the current PSCell:

6\> set field *timeSpent* to the time spent in the current PSCell while being connected to the current PCell;

4\> else:

5\> for the newest entry of the PCell in the *mobilityHistoryReport*, include a new entry in the *visitedPSCellInfoListReport,* possibly after removing the oldest PSCell entry of a PCell in the *mobilityHistoryReport*, if required, and set its fields as follows:

6\> set field *timeSpent* to the time spent without PSCell in the current PCell since connected to the current PCell in RRC_CONNECTED;

1\> if the *successHO-ReportReq* is set to *true* and if the UE has successful handover related information available in *VarSuccessHO-Report* and if the RPLMN is included in the *plmn-IdentityList* stored in *VarSuccessHO-Report*; or

1\> if the *successHO-ReportReq* is set to *true* and if the UE has successful handover related information available in *VarSuccessHO-Report* and if the current registered SNPN is included in *snpn-IdentityList* if stored in the *VarSuccessHO-Report*:

2\> if the *successHO-Report* in the *VarSuccessHO-Report* concerns a DAPS handover and if a PDCP PDU has been received from the source cell of the concerned HO and a non-duplicated PDCP PDU has been received from the target cell of the concerned HO:

3\> set *upInterruptionTimeAtHO* in *VarSuccessHO-Report* to include the time elapsed between the time of arrival of the last PDCP PDU received from the source cell of the concerned handover and the time of arrival of the first non-duplicate PDCP PDU received from the target cell of the concerned handover, as measured at the time of arrival of the first non-duplicate PDCP PDU received from the target cell;

2\> if the *successHO-Report* in the *VarSuccessHO-Report* concerns a *mobilityFromNRCommand*:

3\> set *timeSinceSHR* in *VarSuccessHO-Report* to the time that elapsed since the execution of the associated *mobilityFromNRCommand*;

2\> set the *successHO-Report* in the *UEInformationResponse* message to the value of *successHO-Report* in the *VarSuccessHO-Report*, if available;

2\> discard the *VarSuccessHO-Report* upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

1\> if the *successPSCell-ReportReq* is set to *true* and if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the RPLMN is included in *plmn-IdentityList* stored in *VarSuccessPSCell-Report*; or

1\> if the *successPSCell-ReportReq* is set to *true* and if the UE has successful PSCell change or addition information available in *VarSuccessPSCell-Report* and if the current registered SNPN is included in *snpn-IdentityList* if stored in the *VarSuccessPSCell-Report*:

2\> set the *successPSCell-Report* in the *UEInformationResponse* message to the value of *successPSCell-Report* in the *VarSuccessPSCell-Report*;

2\> discard the *VarSuccessPSCell-Report* upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

1\> if the *coarseLocationRequest* is set to *true*:

2\> include *coarseLocationInfo,* if available;

1\> if the *flightPathInfoReq* is included in the *UEInformationRequest* and the UE has flight path information available, set the *flightPathInfoReport* in the *UEInformationResponse* message as follows:

2\> include the list of up to *maxWayPointNumber* waypoints along the flight path;

2\> if the *includeTimeStamp* is set to *true*, for each included waypoint:

3\> if available, set the field *timestamp* to the time when UE intends to arrive at the waypoint;

1\> if the *logMeasReport* is included in the *UEInformationResponse*:

2\> submit the *UEInformationResponse* message to lower layers for transmission via SRB2;

2\> discard the logged measurement entries included in the *logMeasInfoList* from *VarLogMeasReport* upon successful delivery of the *UEInformationResponse* message confirmed by lower layers;

1\> else:

2\> submit the *UEInformationResponse* message to lower layers for transmission via SRB1.

#### 5.7.10.4 Actions for the Random Access report determination

Upon successfully performing random-access procedure initialized with 4-step or 2-step RA type, or upon failed or successfully completed on-demand system information acquisition procedure in RRC_IDLE or RRC_INACTIVE state, or upon failed or successfully completed RA-SDT operation as specified in clause 5.3.13.5, the UE shall:

1\> if the RPLMN or the PLMN selected by upper layers (see TS24.501 \[23\]) from the PLMN(s) included in the *plmn-IdentityList* in *SIB1* is not included in *plmn-IdentityList* stored in a non-empty *VarRA-Report*; or

1\> if the registered SNPN or the SNPN selected by upper layers (see TS24.501 \[23\]) from the list of SNPN(s) included in the *NPN-IdentityInfoList* in *SIB1*is not included in *plmn-IdentityList* stored in a non-empty *VarRA-Report*:

2\> clear the information included in *VarRA-Report*;

1\> if the UE is not in SNPN access mode and if the number of *RA-Report* entries stored in the *ra-ReportList* in *VarRA-Report* is less than *maxRAReport*:

2\> if the number of PLMN entries in *plmn-IdentityList* stored in *VarRA-Report* is less than *maxPLMN*; or

2\> if the number of PLMN entries in *plmn-IdentityList* stored in *VarRA-Report* is equal to *maxPLMN* and the list of EPLMNs is subset of or equal to the *plmn-IdentityList* stored in *VarRA-Report*:

3\> append the following contents associated to the successfully completed random-access procedure or the failed or successfully completed on-demand system information acquisition procedure as a new entry in the *VarRA-Report*:

4\> if the list of EPLMNs has been stored by the UE:

5\> set the *plmn-IdentityList* to include the list of EPLMNs stored by the UE (i.e. includes the RPLMN) without exceeding the limit of *maxPLMN*;

4\> else:

5\> set the *plmn-Identity*, in *plmn-IdentityList*, to the PLMN selected by upper layers (see TS 24.501 \[23\]) from the PLMN(s) included in the *plmn-IdentityInfoList* in SIB1;

4\> set the *cellId* to the global cell identity and the tracking area code, if available, otherwise to the physical cell identity and carrier frequency of the cell in which the corresponding random-access preamble was transmitted;

4\> if the UE supports spCell ID indication:

5\> if the corresponding random-access procedure was performed on an SCell of MCG:

6\> set the *spCellId* to the global cell identity of the PCell;

5\> if the corresponding random-access procedure was performed on an SCell of SCG:

6\> set the *spCellId* to the global cell identity of the PSCell, if available, otherwise, set the *spCellId* to the global cell identity of the PCell;

5\> if the corresponding random-access procedure was performed on PSCell:

6\> if the *cellId* is not set to the global cell identity of the PSCell, set the *spCellId* to the global cell identity of the PCell;

4\> set the *raPurpose* to include the purpose of triggering the random-access procedure;

4\> set the *ra-InformationCommon* as specified in clause 5.7.10.5.

1\> if the UE is in SNPN access mode and if the number of *RA-Report* entries stored in the *ra-ReportList* in *VarRA-Report* is less than *maxRAReport*:

2\> if the number of SNPN identity entries in *snpn-IdentityList* stored in *VarRA-Report* is less than *maxNPN*; or

2\> if the number of SNPN identity entries in *snpn-IdentityList* stored in *VarRA-Report* is equal to *maxNPN* and the list of equivalent SNPN(s) is subset of or equal to the *snpn-IdentityList* stored in *VarRA-Report*:

3\> append the following contents associated to the successfully completed random-access procedure or the failed or successfully completed on-demand system information acquisition procedure as a new entry in the *VarRA-Report*:

4\> if the list of equivalent SNPN(s) has been stored by the UE:

5\> set the *snpn-IdentityList* to include the list of equivalent SNPN(s) stored by the UE (i.e. includes the registered SNPN) without exceeding the limit of *maxNPN*;

4\> else:

5\> set the *snpn-Identity*, in *snpn-IdentityList*, to the SNPN identity selected by upper layers (see TS 24.501 \[23\]) from the SNPN identities included in the *NPN-IdentityInfoList* in SIB1;

4\> set the *cellId* to the global cell identity and the tracking area code, if available, otherwise to the physical cell identity and carrier frequency of the cell in which the corresponding random-access preamble was transmitted;

4\> if the UE supports spCell ID indication:

5\> if the corresponding random-access procedure was performed on an SCell of MCG:

6\> set the *spCellId* to the global cell identity of the PCell;

5\> if the corresponding random-access procedure was performed on an SCell of SCG:

6\> set the *spCellId* to the global cell identity of the PSCell, if available, otherwise, set the *spCellId* to the global cell identity of the PCell;

5\> if the corresponding random-access procedure was performed on PSCell:

6\> if the *cellId* is not set to the global cell identity of the PSCell, set the *spCellId* to the global cell identity of the PCell;

4\> set the *raPurpose* to include the purpose of triggering the random-access procedure;

4\> set the *ra-InformationCommon* as specified in clause 5.7.10.5.

The UE may discard the random access report information, i.e. release the UE variable *VarRA-Report*, 48 hours after the last successful random access procedure or the failed or successfully completed on-demand system information acquisition procedure or the failed or successfully completed RA-SDT procedure related information is added to the *VarRA-Report*.

NOTE 1: Void.

#### 5.7.10.5 RA information determination

The UE shall, for the last successfully completed or last failed random-access procedure, set the content in *ra-InformationCommon* as follows:

1\> set the *absoluteFrequencyPointA* to indicate the absolute frequency of the reference resource block associated to the random-access resources used in the random-access procedure;

1\> set the *locationAndBandwidth* and *subcarrierSpacing* associated to the UL BWP of the random-access resources used in the random-access procedure;

1\> if contention based random-access resources are used in the random-access procedure:

2\> set the *msgA_RO-FrequencyStart* and *msgA-RO-FDM* and *msgA-SubcarrierSpacing* associated to the 2 step random- access resources if used in the random-access procedure;

2\> if *msgA-SubcarrierSpacing* associated to the 2 step random-access resources used in the random-access procedure is available:

3\> set the *msgA-SubcarrierSpacing* associated to the 2 step random-access resources used in the random-access procedure;

2\> else if only 2 step random-access resources are available in the UL BWP used in the random-access procedure:

3\> set the *msgA-SCS-From-prach-ConfigurationIndex* to the subcarrier spacing as derived from the *msgA-PRACH-ConfigurationIndex* used in the 2-step random-access procedure;

2\> else:

3\> set the *msg1-SubcarrierSpacing* associated to the 4 step random-access resources used in the random-access procedure;

2\> set the *msg1-FrequencyStart* associated to the 4 step random-access resources if used in the random-access procedure, and if its value is different from the value of *msgA-RO-FrequencyStart* if it is included in the *ra-InformationCommon*;

2\> set the *msg1-FDM* associated to the 4 step random-access resources if used in the random-access procedure, and if its value is different from the value of *msgA-RO-FDMCFRA* if it is included in the *ra-InformationCommon;*

2\> if *msg1-SubcarrierSpacing* associated to the 4 step random-access resources used in the random-access procedure is available, and if its value is different from the value of *msgA-SubcarrierSpacing* if it is included in the *ra-InformationCommon*:

3\> set the *msg1-SubcarrierSpacing* associated to the 4 step random-access resources used in the random-access procedure;

2\> else:

3\> set the *msg1-SCS-From-prach-ConfigurationIndex* to the subcarrier spacing as derived from the *prach-ConfigurationIndex* used in the 4-step random-access procedure, and if its value is different from the value of *msgA-SCS-From-prach-ConfigurationIndex* if it is included in the *ra-InformationCommon*;

1\> if contention free random-access resources are used in the random-access procedure:

2\> set the *msg1-FrequencyStartCFRA* and *msg1-FDMCFRA* associated to the 4 step random-access resources if used in the random-access procedure;

2\> if *msg1-SubcarrierSpacing* associated to the 4 step random-access resources used in the random-access procedure is available:

3\> set the *msg1-SubcarrierSpacingCFRA* associated to the 4 step random-access resources used in the random-access procedure;

2\> else:

3\> set the *msg1-SCS-From-prach-ConfigurationIndexCFRA* to the subcarrier spacing as derived from the *prach-ConfigurationIndex* used in the 4 step random-access procedure;

2\> set the *msgA-RO-FrequencyStartCFRA* and *msgA-RO-FDMCFRA* associated to the 2 step contention free random access resources if used in the random-access procedure;

2\> set the *msgA-MCS*, the *nrofPRBs-PerMsgA-PO*, the *msgA-PUSCH-TimeDomainAllocation*, the *frequencyStartMsgA-PUSCH*, the *nrofMsgA-PO-FDM* associated to the 2 step random-access resources if used in the random-access procedure;

2\> if *msgA-SubcarrierSpacing* associated to the 2 step random-access resources used in the random-access procedure is available:

3\> set the *msgA-SubcarrierSpacing* associated to the 2 step random-access resources used in the random-access procedure;

2\> else if only 2 step random-access resources are available in the UL BWP used in the random-access procedure:

3\> set the *msgA-SCS-From-prach-ConfigurationIndex* to the subcarrier spacing as derived from the *msgA-PRACH-ConfigurationIndex* used in the 2-step random-access procedure;

2\> else:

3\> set the *msg1-SubcarrierSpacing* associated to the 4 step random-access resources used in the random-access procedure;

1\> if the random access procedure is initialized with *RA_TYPE* set to *2-stepRA* as described in TS 38.321 \[3\]:

2\> set the *dlPathlossRSRP* to the measeured RSRP of the DL pathloss reference obtained at the time of *RA_Type* selection stage of the initialization of the RA procedure as captured in TS 38.321 \[3\];

2\> if the configuration for the random access *msgA-TransMax* was configured in *RACH-ConfigDedicated* for this random access procedure, and *raPurpose* is set to *reconfigurationWithSync*:

3\> set *msgA-TransMax* to the value of *msgA-TransMax* in *RACH-ConfigDedicated*;

2\> else if *msgA-TransMax* was configured in *RACH-ConfigCommonTwoStepRA*:

3\> set *msgA-TransMax* to the value of *msgA-TransMax* in *RACH-ConfigCommonTwoStepRA*;

2\> set the *msgA-PUSCH-PayloadSize* to the size of the overall payload available in the UE buffer at the time of initiating the 2 step RA procedure;

1\> if the purpose of the random access procedure is to request on-demand system information (i.e., if the *raPurpose* is set to *requestForOtherSI* or *msg3RequestForOtherSI*):

2\> set the *intendedSIBs* to indicate the SIB(s) the UE wanted to receive as a result of the SI request;

2\> set the *ssbsForSI-Acquisition* to indicate the SSB(s) used to receive the SI message;

2\> if the on-demand system information acquisition was successful:

3\> set the *onDemandSISuccess* to *true*;

1\> if one or more of the features including RedCap and/or Slicing and/or SDT and/or MSG3 repetition are applicable for this random-access procedure as specified in clause 5.1.1b of TS 38.321\[3\]:

2\> set the *triggeredFeatureCombination* to indicate all the features triggering this random-access procedure as below:

3\> if this random-access procedure is triggered by RedCap, includes *redCap*;

3\> if this random-access procedure is triggered by SDT, includes *smallData*;

3\> if this random-access procedure is triggered by Msg3 repetition, includes *msg3-Repetitions*;

3\> if this random-access procedure is triggered by slicing, set *nsag* to the NSAG ID applied in the random-access procedure and set the *triggered-S-NSSAI-List* to include all the *S-NSSAI(s)* associated to the slices triggering the access attempt in the random-access procedure;

2\> if the value of used feature or combination of features is different from the *triggeredFeatureCombination*:

3\> set the *usedFeatureCombination* to indicate one or more features of *FeatureCombination* associated to the random-access resource used in the random-access procedure as below:

4\> if RedCap is part of the used *FeatureCombination*, include *redCap*;

4\> if SDT is part of the used *FeatureCombination*, include *smallData*;

4\> if Msg3 repetition is part of the used *FeatureCombination*, include *msg3-Repetitions*;

4\> if NSAG(s) is part of the used *FeatureCombination*, set *NSAG-List* to include the *NSAG-ID(s)* configured for the used *FeatureCombination*;

1\> if the random-access procedure is initiated for SDT and the SDT transmission was failed:

3\> include the *sdt-Failed*;

1\> set the parameters associated to the successive random-access attempts associated to the selected beam in the *perRAInfoList* as follows:

2\> if the random-access resource used is associated to a SS/PBCH block, set the associated random-access parameters for the successive random-access attempts associated to the same SS/PBCH block for one or more random-access attempts as follows:

3\> set the *ssb-Index* to include the SS/PBCH block index associated to the used random-access resource;

3\> set the *numberOfPreamblesSentOnSSB* to indicate the number of successive random-access attempts associated to the SS/PBCH block;

3\> if all preamble transmissions for the successive random-access attempts associated to this SS/PBCH block were blocked by LBT:

4\> include *allPreamblesBlocked*;

3\> else:

4\> if LBT failure indication was received from lower layers for the last random-access preamble transmission attempt in the SS/PBCH block associated to the *ssb-Index*, before changing the SS/PBCH block for random access preamble transmission:

5\> include *lbt-Detected*;

3\> for each random-access attempt performed on the random-access resource, except the random-access attempts for which LBT failure indication was received from lower layers, include the following parameters in the chronological order of the random-access attempt:

4\> if the random-access attempt is performed on the contention based random-access resource and if *raPurpose* is not equal to \'*requestForOtherSI*\', include *contentionDetected* as follows:

5\> if contention resolution was not successful as specified in TS 38.321 \[6\] for the transmitted preamble:

6\> set the *contentionDetected* to *true*;

5\> else:

6\> set the *contentionDetected* to *false*;

4\> if the random access attempt is a 2-step random access attempt:

5\> if fallback from 2-step random access to 4-step random access occurred during the random access attempt:

6\> set *fallbackToFourStepRA* to *true*;

4\> if the random-access attempt is performed on the contention based random-access resource; or

4\> if the random-access attempt is performed on the contention free random-access resource and if the random-access procedure was initiated due to the PDCCH ordering:

5\> if the random access attempt is a 4-step random access attempt and the SS/PBCH block RSRP of the SS/PBCH block corresponding to the random-access resource used in the random-access attempt is above *rsrp-ThresholdSSB*; or

5\> if the random access attempt is a 2-step random access attempt and the SS/PBCH block RSRP of the SS/PBCH block corresponding to the random-access resource used in the random-access attempt is above *msgA-RSRP-ThresholdSSB*:

6\> set the *dlRSRPAboveThreshold* to *true*;

5\> else:

6\> set the *dlRSRPAboveThreshold* to *false*;

2\> else if the random-access resource used is associated to a CSI-RS, set the associated random-access parameters for the successive random-access attempts associated to the same CSI-RS for one or more random-access attempts as follows:

3\> set the *csi-RS-Index* to include the CSI-RS index associated to the used random-access resource;

3\> set the *numberOfPreamblesSentOnCSI-RS* to indicate the number of successive random-access attempts associated to the CSI-RS;

3\> if all preamble transmissions for the successive random-access attempts associated to this CSI-RS were blocked by LBT:

4\> include *allPreamblesBlocked*;

3\> else:

4\> if LBT failure indication was received from lower layers for the last random-access preamble transmission attempt in the CSI-RS associated to the *csi-RS-Index*, before changing the CSI-RS for random access preamble transmission:

5\> include *lbt-Detected;*

1\> if at least one LBT failure indication has been received from lower layers during the random-access procedure:

2\> set the *numberOfLBTFailures* to indicate the total number of random-access attempts for which LBT failure indications have been received from lower layers in the random-access procedure.

The UE shall, for all the BWPs in which consistent LBT failures are triggered and not cancelled at the moment of successful RA completion or for all the BWPs in which consistent LBT failures are detected prior the RLF/HOF, set the below parameters in *attemptedBWP-InfoList* in the chronological order of BWP selection:

1\> set the *locationAndBandwidth* and *subcarrierSpacing* associated to the UL BWP.

NOTE 1: Void.

NOTE 2: If *allPreamblesBlocked* is included, it is left to UE implementation how to set the *numberOfPreamblesSentOnSSB-r16*, *numberOfPreamblesSentOnCSI-RS-r16* and the *perRAAttemptInfoList-r16*.

#### 5.7.10.6 Actions for the successful handover report determination

The UE shall for the PCell:

1\> if the procedure is triggered due to successful completion of reconfiguration with sync, and if the ratio between the value of the elapsed time of the timer T304 and the configured value of the timer T304, included in the last applied *RRCReconfiguration* message including the *reconfigurationWithSync*, is greater than *thresholdPercentageT304* if included in the *successHO-Config* received before executing the last reconfiguration with sync; or

1\> if the procedure is triggered due to successful completion of reconfiguration with sync, and if the ratio between the value of the elapsed time of the timer T310 and the configured value of the timer T310, configured while the UE was connected to the source PCell before executing the last reconfiguration with sync, is greater than *thresholdPercentageT310* included in the *successHO-Config* if configured by the source PCell before executing the last reconfiguration with sync; or

1\> if the procedure is triggered due to successful completion of reconfiguration with sync, and if the T312 associated to the measurement identity of the target cell was running at the time of initiating the execution of the reconfiguration with sync procedure and if the ratio between the value of the elapsed time of the timer T312 and the configured value of the timer T312, configured while the UE was connected to the source PCell before executing the last reconfiguration with sync, is greater than *thresholdPercentageT312* included in the s*uccessHO-Config* if configured by the source PCell before executing the last reconfiguration with sync; or

1\> if the procedure is triggered due to successful completion of reconfiguration with sync, and if *sourceDAPS-FailureReporting* is included in the *successHO-Config* before executing the last reconfiguration with sync and is set to *true* and if the last executed handover was a DAPS handover and if an RLF occurred at the source PCell during the DAPS handover while T304 was running; or:

1\> if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA*,* and if the ratio between the value of the elapsed time of the timer T310 and the configured value of the timer T310, configured while the UE was connected to the source PCell before executing the last Mobility from NR to E-UTRA, is greater than *thresholdPercentageT310* included in the *successHO-Config* if configured by the source PCell before executing the last Mobility from NR to E-UTRA; or

1\> if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA, and if the T312 associated to the measurement identity of the target cell was running at the time of initiating the execution of the Mobility from NR to E-UTRA and if the ratio between the value of the elapsed time of the timer T312 and the configured value of the timer T312, configured while the UE was connected to the source PCell before executing the last Mobility from NR to E-UTRA, is greater than *thresholdPercentageT312* included in the s*uccessHO-Config* if configured by the source PCell before executing the last Mobility from NR to E-UTRA:

2\> store the successful handover information in *VarSuccessHO-Report* and determine the content in *VarSuccessHO-Report* as follows:

3\> clear the information included in *VarSuccessHO-Report*, if any;

3\> if the UE is not in SNPN access mode, set the *plmn-IdentityList* to include the list of EPLMNs stored by the UE (i.e., includes the RPLMN);

3\> else if the UE is in SNPN access mode, set the *snpn-IdentityList* to include the list of equivalent SNPNs stored by the UE (i.e., includes the registered SNPN), if available;

3\> set the *c-RNTI* to the C-RNTI assigned by the target PCell of the handover;

3\> if the procedure is triggered due to successful completion of reconfiguration with sync, for the source PCell in which the last *RRCReconfiguration* message including *reconfigurationWithSync* was applied; or

3\> if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA, for the source PCell in which the last *MobilityFromNRCommand* concerning an inter-RAT handover from NR to E-UTRA was applied:

4\> set the *sourcePCellID* in *sourceCellInfo* to the global cell identity and tracking area code, if available, of the source PCell;

4\> set the *sourceCellMeas* in *sourceCellInfo* to include the cell level RSRP, RSRQ and the available SINR, of the source PCell based on the available SSB and CSI-RS measurements collected up to the moment the UE sends *RRCReconfigurationComplete* message if the procedure is triggered due to successful completion of reconfiguration with sync, or up to the moment the UE sends the EUTRA *RRCConnectionReconfigurationComplete* message if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA;

4\> set the *rsIndexResults* in *sourceCellMeas* to include all the available SSB and CSI-RS measurement quantities of the source PCell collected up to the moment the UE sends *RRCReconfigurationComplete* message if the procedure is triggered due to successful completion of reconfiguration with sync, or up to the moment the UE sends the EUTRA *RRCConnectionReconfigurationComplete* message if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA;

4\> if the last executed handover was a DAPS handover and if an RLF occurred at the source PCell during the DAPS handover while T304 was running:

5\> set the *rlf-InSourceDAPS* in *sourceCellInfo* to *true*;

3\> if the procedure is triggered due to successful completion of reconfiguration with sync, for the target PCell indicated in the last applied *RRCReconfiguration* message including *reconfigurationWithSync*:

4\> set the *targetPCellID* in *targetCellInfo* to the global cell identity and tracking area code, if available, of the target PCell;

4\> set the *targetCellMeas* in *targetCellInfo* to include the cell level RSRP, RSRQ and the available SINR, of the target PCell based on the available SSB and CSI-RS measurements collected up to the moment the UE sends *RRCReconfigurationComplete* message;

4\> set the *rsIndexResults* in *targetCellMeas* to include all the available SSB and CSI-RS measurement quantities of the target PCell collected up to the moment the UE sends *RRCReconfigurationComplete* message;

4\> if the last applied *RRCReconfiguration* message including *reconfigurationWithSync* was included in the stored *condRRCReconfig*:

5\> set the *timeSinceCHO-Reconfig* to the time elapsed between the initiation of the execution of conditional reconfiguration for the target PCell and the reception of the last *conditionalReconfiguration* including the *condRRCReconfig* of the target PCell in the source PCell;

3\> if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA, for the target PCell indicated in the last applied *MobilityFromNRCommand* concerning an inter-RAT handover from NR to E-UTRA:

4\> set the *targetPCellId* in *eutraTargetCellInfo* to the global cell identity and tracking area code, if available, of the target PCell;

4\> set the *targetCellMeas* in *eutraTargetCellInfo* to include the cell level RSRP, RSRQ and the available SINR, of the target PCell based on the available measurements collected up to the moment the UE sends *RRCConnectionReconfigurationComplete* message;

3\> if the procedure is triggered due to successful completion of reconfiguration with sync and if the ratio between the value of the elapsed time of the timer T304 and the configured value of the T304 timer, included in the last applied *RRCReconfiguration* message including the *reconfigurationWithSync*, is greater than *thresholdPercentageT304* if included in the *successHO-Config* received before executing the last reconfiguration with sync:

4\> set *t304-cause* in *shr-Cause* to *true*;

4\> set the *ra-InformationCommon* to include the random-access related information associated to the random access procedure in the target PCell, as specified in clause 5.7.10.5;

3\> if the ratio between the value of the elapsed time of the timer T310 and the configured value of the T310 timer, configured while the UE was connected to the source PCell before executing the last reconfiguration with sync or the last Mobility from NR to E-UTRA, is greater than *thresholdPercentageT310* included in the *successHO-Config* if configured by the source PCell before executing the last reconfiguration with sync or Mobility from NR to E-UTRA:

4\> set *t310-cause* in *shr-Cause* to *true*;

3\> if the T312 associated to the measurement identity of the target cell was running at the time of initiating the execution of the reconfiguration with sync procedure or Mobility from NR to E-UTRA, and if the ratio between the value of the elapsed time of the timer T312 and the configured value of the T312 timer, configured while the UE was connected to the source PCell before executing the last reconfiguration with sync or Mobility from NR to E-UTRA, is greater than *thresholdPercentageT312* included in the s*uccessHO-Config* if configured by the source PCell before executing the last reconfiguration with sync, or Mobility from NR to E-UTRA:

4\> set *t312-cause* in *shr-Cause* to *true*;

3\> if the procedure is triggered due to successful completion of reconfiguration with sync and if *sourceDAPS-FailureReporting* included in the *successHO-Config* if configured by the source PCell before executing the last reconfiguration with sync is set to *true*, and if the last executed handover was a DAPS handover and if an RLF occurred at the source PCell during the DAPS handover while T304 was running:

4\> set *sourceDAPS-Failure* in *shr-Cause* to *true*;

3\> if the procedure is triggered due to successful completion of reconfiguration with sync, for each of the *measObjectNR*, configured by the source PCell, in which the last *RRCReconfiguration* message including *reconfigurationWithSync* was applied;or:

3\> if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA, for each of the *measObjectNR*, configured by the source PCell, in which the last *MobilityFromNRCommand* concerning an inter-RAT handover from NR to E-UTRA was applied:

4\> if *measRSSI-ReportConfig* is configured for the frequency of the source PCell:

5\> if the procedure is triggered due to successful completion of reconfiguration with sync:

6\> set the *measResultServCell-RSSI* to the linear average of the available RSSI sample value(s) provided by lower layers for the frequency of the source PCell up to the moment the UE sends the *RRCReconfigurationComplete* message

5\> else if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA:

6\> set the *measResultServCell-RSSI* to the linear average of the available RSSI sample value(s) provided by lower layers for the frequency of the source PCell up to the moment the UE sends the EUTRA *RRCConnectionReconfigurationComplete* message;

4\> for each of the configured *measObjectNR* if *measRSSI-ReportConfig* is configured for the configured frequency:

5\> if the procedure is triggered due to successful completion of reconfiguration with sync:

6\> set the *measResultNeighFreq-RSSI* in the *measResultNeighFreqList-RSSI* to the linear average of the available RSSI sample value(s) provided by lower layers for the associated neighbouring frequency up to the moment the UE sends the *RRCReconfigurationComplete* message;

5\> else if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA:

6\> set the *measResultNeighFreq-RSSI* in the *measResultNeighFreqList-RSSI* to the linear average of the available RSSI sample value(s) provided by lower layers for the associated neighbouring frequency up to the moment the UE sends the EUTRA *RRCConnectionReconfigurationComplete* message;

4\> if measurements are available for the *measObjectNR*:

5\> if the SS/PBCH block-based measurement quantities are available:

6\> set the *measResultListNR* in *measResultNeighCells* to include all the available measurement quantities of the best measured cells, other than the source PCell or target PCell, ordered such that the cell with highest SS/PBCH block RSRP is listed first if SS/PBCH block RSRP measurement results are available, otherwise the cell with highest SS/PBCH block RSRQ is listed first if SS/PBCH block RSRQ measurement results are available, otherwise the cell with highest SS/PBCH block SINR is listed first, based on the available SS/PBCH block based measurements collected up to the moment the UE sends the *RRCReconfigurationComplete* message if the procedure is triggered due to successful completion of reconfiguration with sync, or up to the moment the UE sends the EUTRA *RRCConnectionReconfigurationComplete* message if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA;

6\> for each neighbour cell included, include the optional fields that are available;

NOTE 1: For the neighboring cells set included in *measResultListNR* in *measResultNeighCells* ordered based on the SS/PBCH block measurement quantities, the UE includes also the CSI-RS based measurement quantities, if available.

5\> if the CSI-RS measurement quantities are available:

6\> set the *measResultListNR* in *measResultNeighCells* to include all the available measurement quantities of the best measured cells, other than the source PCell and target PCell, ordered such that the cell with highest CSI-RS RSRP is listed first if CSI-RS RSRP measurement results are available, otherwise the cell with highest CSI-RS RSRQ is listed first if CSI-RS RSRQ measurement results are available, otherwise the cell with highest CSI-RS SINR is listed first, based on the available CSI-RS based measurements collected up to the moment the UE sends the *RRCReconfigurationComplete* message if the procedure is triggered due to successful completion of reconfiguration with sync, or up to the moment the UE sends the EUTRA *RRCConnectionReconfigurationComplete* message if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA;

6\> for each neighbour cell included, include the optional fields that are available;

NOTE 2: For the neighboring cells set ordered based on the CSI-RS measurement quantities, the UE includes measurements only for the cells not yet included in *measResultListNR* in *measResultNeighCells* to avoid overriding SS/PBCH block-based ordered measurements.

3\> if the procedure is triggered due to successful completion of reconfiguration with sync, for each of the *measObjectEUTRA*, configured by the source PCell in which the last *RRCReconfiguration* message including *reconfigurationWithSync* was applied; or:

3\> if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA, for each of the *measObjectEUTRA*, configured by the source PCell in which the last *MobilityFromNRCommand* concerning an inter-RAT handover from NR to E-UTRA was applied:

4\> if measurements are available for the *measObjectEUTRA*:

5\> set the *measResultListEUTRA* in *measResultNeighCells* to include the best measured cells ordered such that the cell with highest RSRP is listed first if RSRP measurement results are available, otherwise the cell with highest RSRQ is listed first, based on measurements collected up to the moment the UE sends the *RRCReconfigurationComplete* message if the procedure is triggered due to successful completion of reconfiguration with sync, or up to the moment the UE sends the EUTRA *RRCConnectionReconfigurationComplete* message if the procedure is triggered due to successful completion of Mobility from NR to E-UTRA;

5\> for each neighbour cell included, include the optional fields that are available;

3\> for each of the neighbour cells included in *measResultNeighCells*:

4\> if the cell was a candidate target cell included in the *condRRCReconfig* within the *conditionalReconfiguration* configured by the source PCell, in which the last *RRCReconfiguration* message including *reconfigurationWithSync* was applied:

5\> set the *choCandidate* to *true* in *measResultNR*;

3\> if available, set the *locationInfo* as in 5.3.3.7;

1\> release *successHO-Config* configured by the source PCell and *thresholdPercentageT304* if configured by the target PCell.

The UE may discard the successful handover information, i.e., release the UE variable *VarSuccessHO-Report*, 48 hours after the last successful handover information is added to the *VarSuccessHO-Report*.

#### 5.7.10.7 Actions for the successful PSCell change or addition report determination

The UE shall for the PSCell:

1\> if the ratio between the value of the elapsed time of the timer T304 and the configured value of the timer T304, included in the last applied *RRCReconfiguration* message for the SCG including the *reconfigurationWithSync*, is greater than *thresholdPercentageT304-SCG* if included in the *successPSCell-Config* received before executing the last reconfiguration with sync for the SCG; or

1\> if *sn-InitiatedPSCellChange* is configured in the *RRCReconfiguration* including the last applied *RRCReconfiguration* with *reconfigurationWithSync* for the SCG and if the ratio between the value of the elapsed time of the timer T310 and the configured value of the timer T310, configured while the UE was connected to the source PSCell before executing the last reconfiguration with sync for the SCG, is greater than *thresholdPercentageT310-SCG* included in the *successPSCell-Config* if configured by the source PSCell before executing the last reconfiguration with sync; or

1\> if *sn-InitiatedPSCellChange* is configured in the *RRCReconfiguration* including the last applied *RRCReconfiguration* with *reconfigurationWithSync* for the SCG and if the T312 associated to the measurement identity of the target PSCell was running at the time of initiating the execution of the reconfiguration with sync procedure for the SCG and if the ratio between the value of the elapsed time of the timer T312 and the configured value of the timer T312, configured while the UE was connected to the source PSCell before executing the last reconfiguration with sync, is greater than *thresholdPercentageT312-SCG* included in the s*uccessPSCell-Config* if configured by the source PSCell before executing the last reconfiguration with sync:

1\> if *sn-InitiatedPSCellChange* is not configured in the *RRCReconfiguration* including the last applied *RRCReconfiguration* with *reconfigurationWithSync* for the SCG and if the ratio between the value of the elapsed time of the timer T310 and the configured value of the timer T310, configured while the UE was connected to the source PSCell before executing the last reconfiguration with sync for the SCG, is greater than *thresholdPercentageT310-SCG* included in the *successPSCell-Config* if configured by the PCell before executing the last reconfiguration with sync; or

1\> if *sn-InitiatedPSCellChange* is not configured in the *RRCReconfiguration* including the last applied *RRCReconfiguration* with *reconfigurationWithSync* for the SCG and if the T312 associated to the measurement identity of the target PSCell was running at the time of initiating the execution of the reconfiguration with sync procedure for the SCG and if the ratio between the value of the elapsed time of the timer T312 and the configured value of the timer T312, configured while the UE was connected to the source PSCell before executing the last reconfiguration with sync, is greater than *thresholdPercentageT312-SCG* included in the s*uccessPSCell-Config* if configured by the PCell before executing the last reconfiguration with sync:

2\> clear the information included in *VarSuccessPSCell-Report*, if any;

2\> store the successful PSCell change or addition information in *VarSuccessPSCell-Report* and determine the content in *VarSuccessPSCell-Report* as follows:

3\> if the UE is not in SNPN access mode, set the *plmn-IdentityList* to include the list of EPLMNs stored by the UE (i.e., includes the RPLMN);

3\> else if the UE is in SNPN access mode, set the *snpn-IdentityList* to include the list of equivalent SNPNs stored by the UE (i.e., includes the registered SNPN), if available;

3\> set the *pCellId* to the global cell identity and tracking area code, if available, of the PCell;

3\> for the source PSCell (if available) in which the last *RRCReconfiguration* message for the SCG including *reconfigurationWithSync* was applied:

4\> set the *sourcePSCellId* in *sourcePSCellInfo* to the global cell identity and tracking area code, of the source PSCell;

4\> set the *sourcePSCellMeas* in *sourcePSCellInfo* to include the cell level RSRP, RSRQ and the available SINR, of the source PSCell based on the available SSB and CSI-RS measurements collected up to the moment the UE successfully completed the random access procedure for the SCG;

4\> set the *rsIndexResults* in *sourceCellMeas* to include all the available SSB and CSI-RS measurement quantities of the source PSCell collected up to the moment the UE successfully completed the random access procedure for the SCG;

3\> for the target PSCell indicated in the last applied *RRCReconfiguration* message for the SCG including *reconfigurationWithSync*:

4\> set the *targetPSCellID* in *targetPSCellInfo* to the global cell identity and tracking area code, if available, and otherwise to the physical cell identity and carrier frequency of the target PSCell;

4\> set the *targetPSCellMeas* in *targetPSCellInfo* to include the cell level RSRP, RSRQ and the available SINR, of the target PSCell based on the available SSB and CSI-RS measurements collected up to the moment the UE successfully completed the random access procedure for the SCG;

4\> set the *rsIndexResults* in *targetCellMeas* to include all the available SSB and CSI-RS measurement quantities of the target PSCell collected up to the moment the UE successfully completed the random access procedure for the SCG;

4\> if the last applied *RRCReconfiguration* message for the SCG including *reconfigurationWithSync* was included in the stored *condRRCReconfig*:

5\> set the *timeSinceCPAC-Reconfig* to the time elapsed between the initiation of the execution of conditional reconfiguration for the target PSCell and the reception of the last *conditionalReconfiguration* for the SCG including the *condRRCReconfig* of the target PSCell;

3\> if the ratio between the value of the elapsed time of the timer T304 and the configured value of the T304 timer, included in the last applied *RRCReconfiguration* message for the SCG including the *reconfigurationWithSync*, is greater than *thresholdPercentageT304-SCG* if included in the *successPSCell-Config* received before executing the last reconfiguration with sync for the SCG:

4\> set *t304-cause* in *spr-Cause* to *true*;

4\> set the *ra-InformationCommon* to include the random-access related information associated to the random access procedure in the target PSCell, as specified in clause 5.7.10.5;

3\> if the ratio between the value of the elapsed time of the timer T310 and the configured value of the timer T310, configured while the UE was connected to the source PSCell before executing the last reconfiguration with sync for the SCG, is greater than *thresholdPercentageT310-SCG* included in the *successPSCell-Config* if configured before executing the last reconfiguration with sync:

4\> set *t310-cause* in *spr-Cause* to *true*;

3\> if the T312 associated to the measurement identity of the target PSCell was running at the time of initiating the execution of the reconfiguration with sync procedure for the SCG and if the ratio between the value of the elapsed time of the timer T312 and the configured value of the timer T312, configured while the UE was connected to the source PSCell before executing the last reconfiguration with sync, is greater than *thresholdPercentageT312-SCG* included in the s*uccessPSCell-Config* if configured before executing the last reconfiguration with sync:

4\> set *t312-cause* in *spr-Cause* to *true*;

3\> if *sn-InitiatedPSCellChange* is configured in the *RRCReconfiguration* including the last applied *RRCReconfiguration* with *reconfigurationWithSync* for the SCG:

4\> consider all *measObjectNR* configured by the the source PSCell;

3\> else:

4\> consider all *measObjectNR* configured by the the PCell;

3\> for each of the *measObjectNR*:

4\> if measurements are available for the *measObjectNR*:

5\> if the SS/PBCH block-based measurement quantities are available:

6\> include in the *measResultListNR* in *measResultNeighCells* all the available measurement quantities of the best measured cells, other than the source PCell or target PCell, ordered such that the cell with highest SS/PBCH block RSRP is listed first if SS/PBCH block RSRP measurement results are available, otherwise the cell with highest SS/PBCH block RSRQ is listed first if SS/PBCH block RSRQ measurement results are available, otherwise the cell with highest SS/PBCH block SINR is listed first, based on the available SS/PBCH block based measurements collected up to the moment the UE successfully completed the random access procedure;

6\> for each neighbour cell included, include the optional fields that are available (including the CSI-RS based measurement quantities, if available);

5\> if the CSI-RS measurement quantities are available for the cells not yet included in *measResultListNR* in *measResultNeighCells*:

6\> include in the *measResultListNR* in *measResultNeighCells* all the available measurement quantities of the best measured cells, other than the source PCell and target PCell, ordered such that the cell with highest CSI-RS RSRP is listed first if CSI-RS RSRP measurement results are available, otherwise the cell with highest CSI-RS RSRQ is listed first if CSI-RS RSRQ measurement results are available, otherwise the cell with highest CSI-RS SINR is listed first, based on the available CSI-RS based measurements collected up to the moment the UE successfully completed the random access procedure;

6\> for each neighbour cell included, include the optional fields that are available;

3\> for each of the neighbour cells included in *measResultNeighCells*:

4\> if the cell was a candidate target cell included in the *condRRCReconfig* within the *conditionalReconfiguration*, in which the last *RRCReconfiguration* message for the SCG including *reconfigurationWithSync* was applied:

5\> set the *choCandidate* to *true* in *measResultNR*;

3\> include *sn-InitiatedPSCellChange* if *sn-InitiatedPSCellChange* is included in the *RRCReconfiguration* including the applied *RRCReconfiguration* message with *reconfigurationWithSync* for the SCG;

3\> if *sn-InitiatedPSCellChange* is configured in the *RRCReconfiguration* including the last applied *RRCReconfiguration* with *reconfigurationWithSync* for the SCG:

4\> if available, set the *locationInfo* as in 5.3.3.7 7 according to the *otherConfig* associated with the source PSCell;

3\> else:

4\> if available, set the *locationInfo* as in 5.3.3.7 7 according to the *otherConfig* associated with the PCell;

1\> release *successPSCell-Config* configured by the source PSCell if available and *thresholdPercentageT304* if configured by the target PSCell.

The UE may discard the successful PSCell change or addition information, i.e., release the UE variable *VarSuccessPSCell-Report*, 48 hours after the last successful PSCell change or addition information is added to the *VarSuccessPSCell-Report* or upon detaching from the network.

### 5.7.11 Void

### 5.7.12 IAB Other Information

#### 5.7.12.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=no, hgap];

i: IAB-MT;
n: Network;

|||;
i->n: IABOtherInformation [ac];
|||;
~~~

Figure 5.7.12.1-1: IAB Other Information procedure

The IAB Other Information procedure is used by IAB-MT to request the IAB-donor-CU to allocate IP address or inform the IAB-donor-CU of the IP address for the collocated IAB-DU.

#### 5.7.12.2 Initiation

Upon initiation of the procedure, the IAB-MT shall:

1\> initiate transmission of the *IABOtherInformation* message in accordance with 5.7.12.3;

#### 5.7.12.3 Actions related to transmission of *IABOtherInformation* message

The IAB-MT shall set the contents of *IABOtherInformation* message as follows:

1\> if the procedure is used to request IP addresses:

2\> if IPv4 addresses are requested:

3\> set the *iab-IPv4-AddressNumReq* to the number of IPv4 addresses requested per specific usage;

2\> if IPv6 addresses or IPv6 address prefixes are requested:

3\> if IPv6 addresses are requested:

4\> set the *iab-IPv6-AddressNumReq* to the number of IPv6 addresses requested per specific usage;

3\> else if IPv6 address prefixes are requested:

4\> set the *iab-IPv6-AddressPrefixReq* to *true* per specific usage;

1\> if the procedure is used to report IP addresses:

2\> if IPv4 addresses are reported:

3\> include *iPv4-Address* in *iab-IPv4-AddressReport*, and for each IP address included:

4\> if IPv4 addresses are used for F1-C traffic:

5\> include these addresses in *f1-C-Traffic-IP-Address*.

4\> if IPv4 addresses are used for F1-U traffic:

5\> include these addresses in *f1-U-Traffic-IP-Address*.

4\> if IPv4 address are used for non-F1 traffic:

5\> include these addresses in *non-f1-Traffic-IP-Address*.

4\> if IPv4 addresses are used for all traffic:

5\> include these addresses in *all-Traffic-IAB-IP-Address*.

2\> if IPv6 addresses or IPv6 address prefixes are reported:

3\> if IPv6 addresses are reported:

4\> include *iPv6-Address* in *iab-IPv6-AddressReport*, and for each IP address included;

5\> if IPv6 addresses are used for F1-C traffic:

6\> include these addresses in *f1-C-Traffic-IP-Address*.

5\> if IPv6 addresses are used for F1-U traffic:

6\> include these addresses in *f1-U-Traffic-IP-Address*.

5\> if IPv6 addresses are used for non-F1 traffic:

6\> include these addresses in *non-f1-Traffic-IP-Address*.

5\> if IPv6 addresses are used for all traffic:

6\> include these addresses in *all-Traffic-IAB-IP-Address*.

3\> else if IPv6 address prefixes are reported:

4\> include these *iPv6-Prefix* in *iab-IPv6-PrefixReport*, and for each IP address prefix included;

5\> if this IPv6 address prefix is used for F1-C traffic:

6\> include this prefix in *f1-C-Traffic-IP-Address*.

5\> if this IPv6 address prefix is used for F1-U traffic:

6\> include this prefix in *f1-U-Traffic-IP-Address*.

5\> if this IPv6 address prefix is used for non-F1 traffic:

6\> include this prefix in *non-f1-Traffic-IP-Address*.

5\> if this IPv6 address prefix is used for all traffic:

6\> include this prefix in *all-Traffic-IAB-IP-Address.*

1\> if the IAB-MT is in (NG)EN-DC, or

1\> if the IAB-MT is in NR-DC and the IAB Other Information procedure is towards the IAB-donor-CU in the SN:

2\> if SRB3 is configured:

3\> submit the *IABOtherInformation* message via SRB3 to lower layers for transmission;

2\> else if the IAB-MT is in (NG)EN-DC:

3\> submit the *IABOtherInformation* message via the E-UTRA MCG embedded in E-UTRA RRC message *ULInformationTransferMRDC* as specified in TS 36.331 \[10\];

2\> else:

3\> submit the *IABOtherInformation* message via the NR MCG embedded in NR RRC message *ULInformationTransferMRDC* as specified in clause 5.7.2a.3;

1\> else:

2\> submit the *IABOtherInformation* message to lower layers for transmission.

### 5.7.13 RLM/BFD relaxation

In case both low mobility criterion and good serving cell criterion are configured for RLM/BFD relaxation, the UE is allowed to perform RLM and/or BFD relaxation according to requirements specified in TS 38.133 \[14\] when both relaxed measurement criterion for low mobility and relaxed measurement criterion for good serving cell quality are met.

In case only the good serving cell quality criterion is configured for RLM/BFD relaxation, the UE is allowed to perform RLM and/or BFD relaxation according to requirements specified in TS 38.133 \[14\] when the relaxed measurement criterion for good serving cell quality is met.

#### 5.7.13.1 Relaxed measurement criterion for low mobility

The relaxed measurement criterion for UE with low mobility in RRC_CONNECTED is fulfilled when:

- $(SS-RSRP_Ref - SS-RSRP) < S_SearchDeltaP-Connected$,

Where:

- SS-RSRP = current L3 RSRP measurement of the SpCell based on SSB (dB).

- SS-RSRP~Ref~ = reference L3 RSRP measurement of the SpCell based on SSB (dB), set as follows:

- After receiving low mobility criterion configuration, or

- After MAC of the CG successfully completes a Random Access procedure after applying a *reconfigurationWithSync* in *spCellConfig* of the CG while low mobility criterion is configured, or

- If $(SS-RSRP - SS-RSRP_Ref) > 0$, or

- If the relaxed measurement criterion has not been met for $T_SearchDeltaP-Connected$:

- The UE shall set the value of $SS-RSRP_Ref$ to the current SS-RSRP value of the SpCell.

#### 5.7.13.2 Relaxed measurement criterion for good serving cell quality

The relaxed measurement criterion of good serving cell quality for RLM is fulfilled when the downlink radio link quality on the configured RLM-RS resource is evaluated to be better than the threshold Q~in~+XdB, wherein

- Q~in~ is specified in clause 8.1 of TS 38.133 \[14\].

- X is the parameter *offset* in *goodServingCellEvaluationRLM* for the evaluated serving cell.

The relaxed measurement criterion of good serving cell quality for BFD is fulfilled when the downlink radio link quality on the configured BFD-RS resource is evaluated to be better than the threshold Q~in~+XdB, wherein

- Q ~in~ is specified in clause 8.1 of TS 38.133 \[14\].

- X is the parameter *offset* in *goodServingCellEvaluationBFD* for the evaluated serving cell.

### 5.7.14 UE Positioning Assistance Information

#### 5.7.14.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=No, hgap];

u: UE;
n: Network;

|||;
u<=>n: RRC Reconfiguration[au];
u->n: UEPositioningAssistanceInfo[ac];
|||;
~~~

Figure 5.7.14.1-1: UE Positioning Assistance Information procedure

The UE Positioning Assistance Information procedure is used by UE to report the UE Positioning Assistance Information. The UE reports the association between SRS resources for positioning and the UE Tx TEG ID as defined in TS 38.305 \[73\].

#### 5.7.14.2 Initiation

A UE capable of providing the association between SRS resource for positioning and UE Tx TEG ID in RRC_CONNECTED may initiate the procedure upon being configured to provide this association information.

Upon initiation of the procedure, the UE shall:

1\> initiate transmission of the *UEPositioningAssistanceInfo* message in accordance with 5.7.14.3 to provide the association.

#### 5.7.14.3 Actions related to transmission of *UEPositioningAssistanceInfo* message

The UE shall set the contents of the *UEPositioningAssistanceInfo* message as follows:

1\> if *ue-TxTEG-RequestUL-TDOA-Config* in *RRCReconfiguration* message is configured with *periodicReporting*:

2\> for all the association changes store *ue-TxTEG-Association* corresponding to each *ue-TxTEG-ID* with *nr-TimeStamp*;

2\> include the results in *ue-TxTEG-AssociationList* in the *UEPositioningAssistanceInfo* message on expiry of each configured period;

2\> optionally include one *ue-TxTEG-TimingErrorMarginValue* for each *UEPositioningAssistanceInfo* message;

1\> else if *ue-TxTEG-RequestUL-TDOA-Config* in *RRCReconfiguration* message is configured with *oneShot*:

2\> identify the *ue-TxTEG-Association* corresponding to each *ue-TxTEG-ID* with *nr-TimeStamp*;

2\> include the results in *ue-TxTEG-AssociationList* in the *UEPositioningAssistanceInfo* message only one time;

2\> optionally include one *ue-TxTEG-TimingErrorMarginValue* for each *UEPositioningAssistanceInfo* message.

The UE shall submit the *UEPositioningAssistanceInfo* message to lower layers for transmission.

### 5.7.15 Void

5.7.16 Application layer measurement reporting

5.7.16.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=No, hgap];

u: UE;
n: Network;

|||;
u<=>n: RRC Reconfiguration[au];
u->n: MeasurementReportAppLayer[ac];
|||;
~~~

Figure 5.7.16.1-1: Application layer measurement reporting

The purpose of this procedure is to send application layer measurement reports to the network.

5.7.16.2 Initiation

A UE capable of application layer measurement reporting in RRC_CONNECTED may initiate the procedure when configured with application layer measurement, i.e. when *appLayerMeasConfig* and SRB4 and/or SRB5 have been configured by the network.

Upon initiating the procedure, the UE shall:

1\> for each *measConfigAppLayerId* received from upper layers:

2\> if the UE AS has received application layer measurement report container from upper layers which has not been transmitted; and

2\> if the application layer measurement reporting has not been suspended for the *measConfigAppLayerId* associated with the application layer measurement report container according to clause 5.3.5.13d:

3\> set the *measReportAppLayerContainer* in the *MeasurementReportAppLayer* message to the received value in the application layer measurement report container;

2\> set the *measConfigAppLayerId* in the *MeasurementReportAppLayer* message to the value of the *measConfigAppLayerId* received together with application layer measurement report information;

2\> if session start or stop information has been received from upper layers for the *measConfigAppLayerId*:

3\> set the *appLayerSessionStatus* in the *MeasurementReportAppLayer* message to the received value of session start or stop information;

2\> if *reportingSRB* and *ran-VisibleReportingSRB* are different for the *measConfigAppLayerId*:

3\> include *measReportAppLayerContainer* and *appLayerSessionStatus* in a different *MeasurementReportAppLayer* message than *ran-VisibleMeasurements*;

2\> if RAN visible application layer measurement report has been received from upper layers:

3\> for each *appLayerBufferLevel* value in the received RAN visible application layer measurement report:

4\> set the *appLayerBufferLevel* values in the *appLayerBufferLevelList* in the *MeasurementReportAppLayer* message to the buffer level values received from the upper layer in the order with the first *appLayerBufferLevel* value set to the newest received buffer level value, the second *appLayerBufferLevel* value set to the second newest received buffer level value, and so on until all the buffer level values received from the upper layer have been assigned or the maximum number of values have been set according to *appLayerBufferLevel*, if configured;

3\> set the *playoutDelayForMediaStartup* in the *MeasurementReportAppLayer* message to the received value of playout delay for media startup in the RAN visible application layer measurement report, if any;

3\> for each PDU session ID value indicated in the received RAN visible application layer measurement report, if any:

> 4\> set the *PDU-SessionID* in the *pdu-SessionIdList* in the *MeasurementReportAppLayer* message to the indicated PDU session ID value;

4\> for each QoS Flow ID value indicated in the received RAN visible application layer measurement report associated with the PDU Session ID, if any:

5\> set the *QFI* associated with the PDU session ID to the indicated QoS Flow ID value.

1\> for each stored application layer measurement configuration with *configforRRC-IdleInactive* set to *true* and for which *appLayerIdleInactiveConfig* has not been transmitted since the UE entered RRC_CONNECTED*:*

2\> set the parameters in *appLayerIdleInactiveConfig* in the *MeasurementReportAppLayer* message to the values stored in the UE variable *VarAppLayerIdleConfig*;

1\> for each encoded *MeasurementReportAppLayer* message generated above:

2\> if *reportingSRB* or *ran-VisibleReportingSRB* are not configured:

3\> if the encoded RRC message is larger than the maximum supported size of one PDCP SDU specified in TS 38.323 \[5\]:

4\> if the RRC message segmentation is enabled based on the field *rrc-SegAllowed* received in *appLayerMeasConfig*:

5\> initiate the UL message segment transfer procedure as specified in clause 5.7.7;

4\> else:

5\> discard the RRC message;

3\> else:

4\> submit the *MeasurementReportAppLayer* message to lower layers for transmission.

2\> else if *reportingSRB* or *ran-VisibleReportingSRB* are configured:

3\> if the encoded RRC message is larger than the maximum supported size of one PDCP SDU specified in TS 38.323 \[5\]:

4\> if the RRC message segmentation is enabled based on the field *rrc-SegAllowedSRB4* received in *appLayerMeasConfig* and the *reportingSRB* is SRB4; or

4\> if the RRC message segmentation is enabled based on the field *rrc-SegAllowedSRB5* received in *appLayerMeasConfig* and the *reportingSRB* is SRB5:

5\> initiate the UL message segment transfer procedure as specified in clause 5.7.7 via the SRB indicated in the field *reportingSRB* in *MeasConfigAppLayer*;

4\> else:

5\> discard the RRC message;

3\> else:

4\> submit the *MeasurementReportAppLayer* message to lower layers for transmission via the SRB indicated in the field *reportingSRB* or, if different from *reportingSRB*, *ran-VisibleReportingSRB* in *MeasConfigAppLayer* upon which the procedure ends.

Editor\'s Note: FFS on if it needs to be specified what the UE transmits when returning to RRC_CONNECTED.

NOTE 1: If the SRB indicated by *reportingSRB* is not available, the UE may store application layer measurement report containers until the SRB is available. The UE may discard reports when the memory reserved for storing application layer measurement report containers becomes full. Reports with lower *appLayerMeasPriority* are discarded first. If no *appLayerMeasPriority* is configured, older reports may be discarded first.

NOTE 2: If the SRB indicated by *ran-VisibleReportingSRB* is not available, the UE discards RAN visible application layer measurement reports.

### 5.7.17 Derivation of pathloss reference for TA validation of SRS for Positioning transmission and CG-SDT in RRC_INACTIVE

Upon request from lower layer for pathloss reference derivation for TA validation for SRS for Positioning transmission or CG-SDT in RRC_INACTIVE, the UE shall:

1\> acquire *SIB2,* if stored version is invalid;

1\> if *nrofSS-BlocksToAverage* or *absThreshSS-BlocksConsolidation* is not present or if a*bsThreshSS-BlocksConsolidation* is present and the highest beam measurement quantity value is below or equal to *absThreshSS-BlocksConsolidation*:

2\> derive the downlink pathloss reference RSRP for TA validation as the highest beam measurement quantity value, where each beam measurement quantity is described in TS 38.215 \[24\];

1\> else:

2\> derive the downlink pathloss reference RSRP for TA validation as the linear average of the power values of up to *nrofSS-BlocksToAverage* of the highest beam measurement quantity values above *absThreshSS-BlocksConsolidation*, where each beam measurement quantity is described in TS 38.215 \[24\].

### 5.7.18 Actions for SRS for Positioning transmission in RRC_INACTIVE in a Validity Area

The UE may be configured or preconfigured with SRS for Positioning in a validity area defined by group of cells. There can be multiple preconfigured SRS for positioning that can be configured to UE where each preconfiguration belongs to different validity area. For each validity area, the UE is preconfigured with only one SRS for positioning configuration. For non-preconfigured SRS for positioning, only one validity area is configured.

When the UE is (pre)configured to transmit SRS for positioning in a validity area, the UE shall:

1\> if the RS in *spatialRelationInfoPos* cannot be accurately measured:

2\> suspend the transmission of the SRS for positioning resource and monitor the configured RS;

2\> if the UE determines that RS in *spatialRelationInfoPos* being accurately measured:

3\> resume the SRS transmission.

The UE releases the (pre)configured SRS for positioning with validity area upon receiving *RRCRelease* message with the indication to release the (pre)configuration.

### 5.7.19 Satellite switch with re-synchronization in RRC_CONNECTED

The UE shall:

1\> stop timer T430 if running;

1\> inform lower layers that UL synchronisation is lost due to satellite switch with re-synchronization;

1\> start re-synchronising to the DL of the SpCell served by the satellite indicated by *ntn-Config* in *SatSwitchWithReSync*;

1\> start timer T430 with the timer value set to *ntn-UlSyncValidityDuration* from the subframe indicated by *epochTime* in *ntn-Config* in *SatSwitchWithReSync*;

1\> inform lower layers when UL synchronisation is obtained.

Editor\'s Note: FFS whether in the soft-switch scenario a UE can obtain DL synchronization from the target satellite without losing UL synchronization to the source satellite.

## 5.8 Sidelink

### 5.8.1 General

NR sidelink communication consists of unicast, groupcast and broadcast. For unicast, the PC5-RRC connection is a logical connection between a pair of a Source Layer-2 ID and a Destination Layer-2 ID in the AS. The PC5-RRC signalling, as specified in clause 5.8.9, can be initiated after its corresponding PC5 unicast link establishment (TS 23.287 \[55\]). The PC5-RRC connection and the corresponding sidelink SRBs and sidelink DRB(s) are released when the PC5 unicast link is released as indicated by upper layers.

For each PC5-RRC connection of unicast, one sidelink SRB (i.e. SL-SRB0) is used to transmit the PC5-S message(s) before the PC5-S security has been established. One sidelink SRB (i.e. SL-SRB1) is used to transmit the PC5-S messages to establish the PC5-S security. One sidelink SRB (i.e. SL-SRB2) is used to transmit the PC5-S messages after the PC5-S security has been established, which is protected. One sidelink SRB (i.e. SL-SRB3) is used to transmit the PC5-RRC signalling, which is protected and only sent after the PC5-S security has been established. One sidelink SRB (i.e. SL-SRB4) is used to transmit/receive the NR sidelink discovery messages.

For unicast of NR sidelink communication, AS security comprises of integrity protection of PC5 signalling (SL-SRB1, SL-SRB2 and SL-SRB3) and user data (SL-DRBs), and it further comprises of ciphering of PC5 signaling (SL-SRB1 only for the Direct Link Security Mode Complete message as specified in TS 24.587 \[57\] for V2X service or TS 24.554 \[72\] for Proximity-services, SL-SRB2 and SL-SRB3) and user data (SL-DRBs). The ciphering and integrity protection algorithms and parameters for a PC5 unicast link are exchanged by PC5-S messages in the upper layers as specified in TS 33.536 \[60\], and applied to the corresponding PC5-RRC connection in the AS. Once AS security is activated for a PC5 unicast link in the upper layers as specified in TS 33.536 \[60\], all messages on SL-SRB2 and SL-SRB3 and/or user data on SL-DRBs of the corresponding PC5-RRC connection are integrity protected and/or ciphered by the PDCP.

For unicast of NR sidelink communication, if the change of the key is indicated by the upper layers as specified in TS 24.587 \[57\] or TS 24.554 \[72\], UE re-establishes the PDCP entity of the SL-SRB1, SL-SRB2, SL-SRB3 and SL-DRBs on the corresponding PC5-RRC connection.

NOTE 1: In case the configurations for NR sidelink communication are acquired via the E-UTRA, the configurations for NR sidelink communication in *SIB12* and *sl-ConfigDedicatedNR* within *RRCReconfiguration* used in clause 5.8 are provided by the configurations in *SystemInformationBlockType28* and *sl-ConfigDedicatedForNR* within *RRCConnectionReconfiguration* as specified in TS 36.331 \[10\], respectively.

NOTE 2: In this release, there is one-to-one correspondence between the PC5-RRC connection and the PC5 unicast link as specified in TS 38.300\[2\].

NOTE 3: All SL-DRBs related to the same PC5-RRC connection have the same activation/deactivation setting for ciphering and the same activation/deactivation setting for integrity protection as specified in TS 33.536 \[60\].

NOTE 4: When integrity check failure concerning SL-SRB1 for a specific destination is detected, the UE sends an indication to the upper layers \[57\].

NOTE 5: The selection of NULL algorithms means that the PC5 messages are considered protected for the purposes of being allowed to be sent or received.

### 5.8.2 Conditions for NR sidelink communication/discovery/positioning operation

The UE shall perform NR sidelink communication/positioning operation only if the conditions defined in this clause are met:

1\> if the UE\'s serving cell is suitable (RRC_IDLE or RRC_INACTIVE or RRC_CONNECTED); and if either the selected cell on the frequency used for NR sidelink communication/discovery/positioning operation belongs to the registered or equivalent PLMN as specified in TS 24.587 \[57\] or TS 24.554 \[72\] or the UE is out of coverage on the frequency used for NR sidelink communication/discovery/positioning operation as defined in TS 38.304 \[20\] and TS 36.304 \[27\]; or

1\> if the UE\'s serving cell (RRC_IDLE or RRC_CONNECTED) fulfils the conditions to support NR sidelink communication/discovery/positioning in limited service state as specified in TS 23.287 \[55\]; and if either the serving cell is on the frequency used for NR sidelink communication/discovery/positioning operation or the UE is out of coverage on the frequency used for NR sidelink communication/discovery/positioning operation as defined in TS 38.304 \[20\] and TS 36.304 \[27\]; or

1\> if the UE has no serving cell (RRC_IDLE).

### 5.8.3 Sidelink UE information for NR sidelink communication/discovery/positioning

#### 5.8.3.1 General

~~~ mscgen
hscale="auto";
defstyle hgap [text.gap.left=20, text.gap.right=20];
defstyle entity [text.font.face="Arial", text.size.normal=14, text.wrap=no, text.bold=yes];
defstyle b2 [text.font.face="Arial", text.size.normal=13, vspacing=7, text.wrap=no, hgap];
defstyle ac [text.font.face="Times", text.size.normal=15, text.italic=yes, vspacing=5, arrow.type=sharp, hgap];
defstyle au [text.font.face="Arial", text.size.normal=13, vspacing=5, hgap];
defstyle n1 [text.font.face="Arial", text.size.normal=13, vspacing=5, weak, text.italic=No, hgap];

u: UE;
n: Network;

|||;
n->u: SIB12/XX acquisition[au];
u->n: SidelinkUEInformationNR[ac];
|||;
~~~

Figure 5.8.3.1-1: Sidelink UE information for NR sidelink communication/discovery

The purpose of this procedure is to inform the network that the UE:

- is interested or no longer interested to receive or transmit NR sidelink communication/discovery/positioning,

- is requesting assignment or release of transmission resource for NR sidelink communication/discovery/positioning,

- is reporting QoS parameters and QoS profile(s) related to NR sidelink communication,

- is reporting mapped frequency(ies) for each QoS flow related to NR sidelink communication,

- is reporting associated Tx Profile for each QoS flow related to NR sidelink communication,

- is reporting that a sidelink radio link failure, sidelink RRC reconfiguration failure or a sidelink carrier failure has been detected,

- is reporting the sidelink UE capability information of the associated peer UE for unicast communication,

- is reporting the RLC mode information of the sidelink data radio bearer(s) received from the associated peer UE for unicast communication,

- is reporting the accepted sidelink DRX configuration received from the associated peer UE for NR sidelink unicast reception,

- is reporting the sidelink DRX assistance information received from the associated peer UE for NR sidelink unicast transmission, when the UE is configured with *sl-ScheduledConfig*,

- is reporting, for NR sidelink groupcast transmission, the sidelink DRX on/off indication for the associated Destination Layer-2 ID, when the UE is configured with *sl-ScheduledConfig*,

- is reporting, for NR sidelink groupcast or broadcast reception, the Destination Layer-2 ID and QoS profile(s) associated with its interested services to which sidelink DRX is applied,

- is reporting DRX configuration reject information from its associated peer UE for NR sidelink unicast transmission, when the UE is configured with *sl-ScheduledConfig*,

- is reporting parameters related to U2N relay operation,

- is reporting parameters related to U2U relay operation.

#### 5.8.3.2 Initiation

A UE capable of NR sidelink communication or NR sidelink discovery or NR sidelink U2N relay operation or NR sidelink U2U relay operation or NR sidelink positioning that is in RRC_CONNECTED may initiate the procedure to indicate it is (interested in) receiving or transmitting NR sidelink communication or NR sidelink discovery or NR sidelink U2N relay operation or NR sidelink U2U relay operation or SL-PRS transmission/reception in several cases including upon successful connection establishment or resuming, upon change of interest, upon changing QoS profile(s), upon receiving *UECapabilityInformationSidelink* from the associated peer UE, upon RLC mode information updated from the associated peer UE or upon change to a PCell providing *SIB12* including *sl-ConfigCommonNR,* or upon change to a PCell providing *SIB23* including *sl-PosConfigCommonNR*. A UE capable of NR sidelink communication may initiate the procedure to request assignment of dedicated sidelink DRB configuration and transmission resources for NR sidelink communication transmission. A UE capable of NR sidelink communication may initiate the procedure to report to the network that a sidelink radio link failure, sidelink RRC reconfiguration failure or sidelink carrier failure has been declared. A UE capable of NR sidelink discovery may initiate the procedure to request assignment of dedicated resources for NR sidelink discovery transmission or NR sidelink discovery reception. A UE capable of U2N relay operation may initiate the procedure to report/update parameters for acting as U2N Relay UE or U2N Remote UE (including L2 Remote UE\'s source L2 ID). A UE capable of U2U relay operation may initiate the procedure to report/update parameters for acting as U2U Relay UE or U2U Remote UE. A UE capable of NR sidelink positioning may initiate the procedure to request it is interested or no longer interested in either transmitting SL-PRS or receiving sidelink control information for SL-PRS.

A UE capable of NR sidelink operation that is in RRC_CONNECTED may initiate the procedure to report the sidelink DRX configuration received from the associated peer UE for NR sidelink unicast reception, upon accepting the sidelink DRX configuration from the associated peer UE. A UE capable of NR sidelink communication that is configured with *sl-ScheduledConfig* and is performing sidelink unicast transmission may initiate the procedure to report the sidelink DRX assistance information or the sidelink DRX configuration reject information received from the associated peer UE, upon receiving either of them from the associated peer UE. A UE capable of NR sidelink communication that is configured with *sl-ScheduledConfig* and is performing sidelink groupcast transmission may initiate the procedure to report the sidelink DRX on/off indication for the associated Destination Layer-2 ID.

A UE capable of NR sidelink operation that is in RRC_CONNECTED may initiate the procedure to report the Destination Layer-2 ID and QoS profile(s) associated with its interested service(s) that sidelink DRX is applied, for NR sidelink groupcast or broadcast reception.

Upon initiating this procedure, the UE shall:

1\> if *SIB12* including *sl-ConfigCommonNR* is provided by the PCell:

2\> ensure having a valid version of *SIB12* for the PCell;

2\> if configured by upper layers to receive NR sidelink communication on the frequency included in *sl-FreqInfoList*/*sl-FreqInfoListSizeExt* in *SIB12* of the PCell:

3\> if the UE did not transmit a *SidelinkUEInformationNR* message since last entering RRC_CONNECTED state; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell not providing *SIB12* including *sl-ConfigCommonNR*; or

3\> if the last transmission of the *SidelinkUEInformationNR* message did not include *sl-RxInterestedFreqList*; or if the frequency configured by upper layers to receive NR sidelink communication on has changed since the last transmission of the *SidelinkUEInformationNR* message:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate the NR sidelink communication reception frequency of interest in accordance with 5.8.3.3;

2\> else:

3\> if the last transmission of the *SidelinkUEInformationNR* message included *sl-RxInterestedFreqList*:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate it is no longer interested in NR sidelink communication reception in accordance with 5.8.3.3;

2\> if configured by upper layers to transmit non-relay NR sidelink communication on the frequency included in *sl-FreqInfoList*/*sl-FreqInfoListSizeExt* in *SIB12* of the PCell; or

2\> if configured by upper layer to transmit NR sidelink L3 U2U relay communication on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including \[*FFS gNB capability indication*\]:

3\> if the UE did not transmit a *SidelinkUEInformationNR* message since last entering RRC_CONNECTED state; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell not providing *SIB12* including *sl-ConfigCommonNR*; or

3\> if the last transmission of the *SidelinkUEInformationNR* message did not include *sl-TxResourceReqList*; or if the information carried by the *sl-TxResourceReqList* has changed since the last transmission of the *SidelinkUEInformationNR* message:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate the NR sidelink communication transmission resources required by the UE in accordance with 5.8.3.3;

2\> else:

3\> if the last transmission of the *SidelinkUEInformationNR* message included *sl-TxResourceReqList*:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate it no longer requires NR sidelink communication transmission resources in accordance with 5.8.3.3;

2\> if configured by upper layer to receive NR sidelink non-relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including *sl-NonRelayDiscovery*:

3\> if the UE did not transmit a *SidelinkUEInformationNR* message since last entering RRC_CONNECTED state; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell not providing *SIB12* including *sl-ConfigCommonNR* or connected to a PCell providing *SIB12* but not including *sl-NonRelayDiscovery*; or

3\> if the last transmission of the *SidelinkUEInformationNR* message did not include *sl-RxInterestedFreqListDisc*; or if the frequency configured by upper layers to receive NR sidelink non-relay discovery messages on has changed since the last transmission of the *SidelinkUEInformationNR* message:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate the NR sidelink discovery reception frequency of interest in accordance with 5.8.3.3;

2\> else:

3\> if the last transmission of the *SidelinkUEInformationNR* message included *sl-RxInterestedFreqListDisc*:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate it is no longer interested in NR sidelink non-relay discovery messages reception in accordance with 5.8.3.3;

2\> if configured by upper layer to receive NR sidelink L2 U2N relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including *sl-L2U2N-Relay*; or if configured by upper layer to receive NR sidelink L3 U2N relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including *sl-L3U2N-RelayDiscovery*;

2\> or if configured by upper layer to receive NR sidelink U2U relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including \[*FFS gNB capability indication*\]:

3\> if the UE did not transmit a *SidelinkUEInformationNR* message since last entering RRC_CONNECTED state; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell not providing *SIB12* including *sl-ConfigCommonNR*; or connected to a PCell providing *SIB12* but not including *sl-L2U2N-Relay* in case of L2 U2N relay operation; or connected to a PCell providing *SIB12* but not including *sl-L3U2N-RelayDiscovery* in case of L3 U2N relay operation; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell providing *SIB12* but not including \[*FFS gNB capability indication*\] in case of U2U relay operation; or

3\> if the last transmission of the *SidelinkUEInformationNR* message did not include *sl-RxInterestedFreqListDisc*; or if the frequency configured by upper layers to receive NR sidelink discovery messages on has changed since the last transmission of the *SidelinkUEInformationNR* message:

4\> if the UE is capable of U2N Relay UE, and if *SIB12* includes *sl-RelayUE-ConfigCommon*; or

4\> if the UE is selecting a U2N Relay UE / has a selected U2N Relay UE, and if *SIB12* includes *sl-RemoteUE-ConfigCommon*; or

4\> if the UE is capable of U2U Relay UE, and if *SIB12* includes *sl-RelayUE-ConfigCommonU2U*; or

4\> if the UE is selecting a U2U Relay UE / has a selected U2U Relay UE, and if *SIB12* includes *sl-RemoteUE-ConfigCommonU2U*:

5\> initiate transmission of the *SidelinkUEInformationNR* message to indicate the NR relay sidelink discovery reception frequency of interest in accordance with 5.8.3.3;

2\> else:

3\> if the last transmission of the *SidelinkUEInformationNR* message included *sl-RxInterestedFreqListDisc*:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate it is no longer interested in NR relay sidelink discovery messages reception in accordance with 5.8.3.3;

2\> if configured by upper layer to transmit NR sidelink non-relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including *sl-NonRelayDiscovery*:

3\> if the UE did not transmit a *SidelinkUEInformationNR* message since last entering RRC_CONNECTED state; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell not providing *SIB12* including *sl-ConfigCommonNR* or connected to a PCell providing *SIB12* but not including *sl-NonRelayDiscovery*; or

3\> if the last transmission of the *SidelinkUEInformationNR* message did not include *sl-TxResourceReqListDisc*; or if the information carried by the *sl-TxResourceReqListDisc* has changed since the last transmission of the *SidelinkUEInformationNR* message:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate the NR sidelink non-relay discovery messages resources required by the UE in accordance with 5.8.3.3;

2\> else:

3\> if the last transmission of the *SidelinkUEInformationNR* message included *sl-TxResourceReqListDisc*:

4\> initiate transmission of the *SidelinkUEInformationNR* message to indicate it no longer requires NR sidelink non-relay discovery messages resources in accordance with 5.8.3.3;

2\> if configured by upper layer to transmit NR sidelink L2 U2N relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including *sl-L2U2N-Relay*; or if configured by upper layer to transmit NR sidelink L3 U2N relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including *sl-L3U2N-RelayDiscovery*; or

2\> if configured by upper layer to transmit NR sidelink U2U relay discovery messages on the frequency included in *sl-FreqInfoList* in *SIB12* of the PCell including \[*FFS gNB capability indication*\]:

3\> if the UE did not transmit a *SidelinkUEInformationNR* message since last entering RRC_CONNECTED state; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell not providing *SIB12* including *sl-ConfigCommonNR*; or connected to a PCell providing *SIB12* but not including *sl-L2U2N-Relay* in case of L2 U2N relay operation; or connected to a PCell providing *SIB12* but not including *sl-L3U2N-RelayDiscovery* in case of L3 U2N relay operation; or

3\> if since the last time the UE transmitted a *SidelinkUEInformationNR* message the UE connected to a PCell providing *SIB12* but not including \[*FFS gNB capability indication*\] in case of U2U relay operation; or

3\> if the last transmission of the *SidelinkUEInformationNR* message did not include *sl-TxResourceReqListDisc*; or if the information carried by the *sl-TxResourceReqListDisc* has changed since the last transmission of the *SidelinkUEInformationNR* message:

4\> if the UE is capable of U2N Relay UE, and if *SIB12* includes *sl-RelayUE-ConfigCommon*, and if the U2N Relay UE threshold conditions