#include "LibSip_Interface.hh"
#include "LibSip_SIPTypesAndValues.hh"

#include "sip_layer_factory.hh"

#include "loggers.hh"

#include "converter.hh"

sip_layer::sip_layer(const std::string & p_type, const std::string & p_param) : t_layer<LibSip__Interface::SipPort>(p_type), _params(), _codec_request(), _codec_response(), _codec_register(), _codec_invite(), _codec_subscribe(), _codec_message(), _codec_options() {
  loggers::get_instance().log(">>> sip_layer::sip_layer: %s, %s", to_string().c_str(), p_param.c_str());
  // Setup parameters
  params::convert(_params, p_param);
}

void sip_layer::sendMsg(const LibSip__SIPTypesAndValues::REGISTER__Request& p_sip_message, params& p_param) {
  loggers::get_instance().log_msg(">>> sip_layer::sendMsg: ", p_sip_message);

  // Encode SipMessage
  OCTETSTRING data;
  _codec_register.encode(p_sip_message, data);
  send_data(data, _params);
}

void sip_layer::sendMsg(const LibSip__SIPTypesAndValues::INVITE__Request& p_sip_message, params& p_param) {
  loggers::get_instance().log_msg(">>> sip_layer::sendMsg: ", p_sip_message);

  // Encode SipMessage
  OCTETSTRING data;
  _codec_invite.encode(p_sip_message, data);
  send_data(data, _params);
}

void sip_layer::sendMsg(const LibSip__SIPTypesAndValues::SUBSCRIBE__Request& p_sip_message, params& p_param) {
  loggers::get_instance().log_msg(">>> sip_layer::sendMsg: ", p_sip_message);

  // Encode SipMessage
  OCTETSTRING data;
  _codec_subscribe.encode(p_sip_message, data);
  send_data(data, _params);
}

void sip_layer::sendMsg(const LibSip__SIPTypesAndValues::MESSAGE__Request& p_sip_message, params& p_param) {
  loggers::get_instance().log_msg(">>> sip_layer::sendMsg: ", p_sip_message);

  // Encode SipMessage
  OCTETSTRING data;
  _codec_message.encode(p_sip_message, data);
  send_data(data, _params);
}

void sip_layer::sendMsg(const LibSip__SIPTypesAndValues::OPTIONS__Request& p_sip_message, params& p_param) {
  loggers::get_instance().log_msg(">>> sip_layer::sendMsg: ", p_sip_message);

  // Encode SipMessage
  OCTETSTRING data;
  _codec_options.encode(p_sip_message, data);
  send_data(data, _params);
}

void sip_layer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> sip_layer::send_data: ", data);

  send_to_all_layers(data, p_params);
}

void sip_layer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> sip_layer::receive_data: ", data);

  // Decode SIP message
  if (data[0].get_octet() == 'S') { // Assume it is a responce
    LibSip__SIPTypesAndValues::Response sip_response;
    if (_codec_response.decode(data, sip_response) == -1) {
      loggers::get_instance().warning("sip_layer::receive_data: Failed to decode response data");
      return;
    }
    // Pass it to the ports
    to_all_upper_ports(sip_response, p_params);
  } else { // Assume it is a request
    LibSip__SIPTypesAndValues::Request sip_request;
    if (_codec_request.decode(data, sip_request) == -1) {
      loggers::get_instance().warning("sip_layer::receive_data: Failed to decode request data");
      return;
    }
    // Pass it to the ports
    to_all_upper_ports(sip_request, p_params);
  }
}

sip_layer_factory sip_layer_factory::_f;

