#pragma once

#include "codec.hh"
#include "params.hh"

#include "sip_codec_headers.hh"
#include "sip_codec_message_body.hh"

#include "osipparser2/osip_parser.h"
#include "osipparser2/sdp_message.h"

class Base_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibSip__SIPTypesAndValues {
  class Response;
  class StatusLine;
  class MessageHeader;
  class Payload;
}

class sip_codec_response: public codec <
  LibSip__SIPTypesAndValues::Response,
  LibSip__SIPTypesAndValues::Response>,
                          sip_codec_headers, sip_codec_message_body

{
public:
  explicit sip_codec_response() : codec<LibSip__SIPTypesAndValues::Response, LibSip__SIPTypesAndValues::Response>() { };
  virtual ~sip_codec_response() { };

  virtual int encode (const LibSip__SIPTypesAndValues::Response& msg, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, LibSip__SIPTypesAndValues::Response& msg, params* p_params = NULL);
private:
  int encode_response(const LibSip__SIPTypesAndValues::Response& p_response, osip_message_t* p_sip_message);
  int encode_status_line(const LibSip__SIPTypesAndValues::StatusLine& p_status_line, osip_message_t* p_sip_message);
  int encode_response_headers(const LibSip__SIPTypesAndValues::MessageHeader& p_msg_header, osip_message_t* p_sip_message);
  int encode_response_payload(const LibSip__SIPTypesAndValues::Payload& p_payload, osip_message_t* p_sip_message);

private:
  void decode_status_line(const osip_message_t* p_sip_message, LibSip__SIPTypesAndValues::Response& msg);
  void decode_response_headers(const osip_message_t* p_sip_message, LibSip__SIPTypesAndValues::Response& msg);
  void decode_payload(const osip_message_t* p_sip_message, LibSip__SIPTypesAndValues::Response& p_response);

}; // End of class sip_codec_response
