#pragma once

#include "codec.hh"
#include "params.hh"

#include "sip_codec_headers.hh"
#include "sip_codec_message_body.hh"

#include "osipparser2/osip_parser.h"
#include "osipparser2/sdp_message.h"

class Base_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibSip__SIPTypesAndValues {
  class Request;
  class RequestLine;
  class MessageHeader;
  class Payload;
}

class sip_codec_request: public codec <
  LibSip__SIPTypesAndValues::Request,
  LibSip__SIPTypesAndValues::Request>,
                         sip_codec_headers, sip_codec_message_body
{
public:
  explicit sip_codec_request() : codec<LibSip__SIPTypesAndValues::Request, LibSip__SIPTypesAndValues::Request>() { };
  virtual ~sip_codec_request() { };

  virtual int encode (const LibSip__SIPTypesAndValues::Request& msg, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, LibSip__SIPTypesAndValues::Request& msg, params* p_params = NULL);
private:
  int encode_request(const LibSip__SIPTypesAndValues::Request& p_request, osip_message_t* p_sip_message);
  int encode_request_line(const LibSip__SIPTypesAndValues::RequestLine& p_request_line, osip_message_t* p_sip_message);
  int encode_request_headers(const LibSip__SIPTypesAndValues::MessageHeader& p_msg_header, osip_message_t* p_sip_message);
  int encode_request_payload(const LibSip__SIPTypesAndValues::Payload& p_payload, osip_message_t* p_sip_message);

private:
  void decode_payload(const osip_message_t* p_sip_message, LibSip__SIPTypesAndValues::Request& p_request);
  void decode_request_line(const osip_message_t* p_sip_message, LibSip__SIPTypesAndValues::Request& msg);
  void decode_request_headers(const osip_message_t* p_sip_message, LibSip__SIPTypesAndValues::Request& msg);

}; // End of class sip_codec_request
