#include "SipPort.hh"
#include "sip_layer_factory.hh"
#include "loggers.hh"

namespace LibSip__Interface {

  SipPort::SipPort(const char *par_port_name): SipPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(nullptr), _time_key("SipPort::outgoing_send") {
    // Nothing to do
  } // End of constructor

  SipPort::~SipPort() {
    loggers::get_instance().log(">>> SipPort::~SipPort");

    if (_layer != nullptr) {
      delete _layer;
    }
  } // End of destructor

  void SipPort::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("SipPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void SipPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void SipPort::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void SipPort::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void SipPort::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void SipPort::Handle_Timeout(double time_since_last_call) {}*/

  void SipPort::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> SipPort::user_map: %s", system_port);
    // Build layer stack
    params::iterator it = _cfg_params.find(std::string("params"));
    if (it != _cfg_params.end()) {
      loggers::get_instance().log("SipPort::user_map: %s", it->second.c_str());
      // Setup parameters
      params::convert(_layer_params, it->second); // TODO This _layer_params seems to be useless
      // Create layer
      _layer = layer_stack_builder::get_instance()->create_layer_stack(it->second.c_str());
      if (static_cast<sip_layer *>(_layer) == nullptr) {
        loggers::get_instance().error("SipPort::user_map: Invalid stack configuration: %s", it->second.c_str());
      }
      static_cast<sip_layer *>(_layer)->add_upper_port(this);

    } else {
      loggers::get_instance().error("SipPort::user_map: No layers defined in configuration file");
    }
  } // End of user_map method

  void SipPort::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> SipPort::user_unmap: %s", system_port);

    // Reset layers
    if (_layer != nullptr) {
      delete _layer;
      _layer = nullptr;
    }
  } // End of user_unmap method

  void SipPort::user_start()
  {
    loggers::get_instance().log(">>> SipPort::user_start");

  } // End of user_start method

  void SipPort::user_stop()
  {
    loggers::get_instance().log(">>> SipPort::user_stop");

  } // End of user_stop method

  void SipPort::receiveMsg (const LibSip__SIPTypesAndValues::Request& p_ind, const params& p_params) {
    loggers::get_instance().log_msg(">>> SipPort::receive_msg: ", p_ind);
    
    // Sanity check
    if (!p_ind.is_bound()) {
      return;
    }

    if (p_ind.requestLine().method() == LibSip__SIPTypesAndValues::Method::INVITE__E) {
      incoming_message(LibSip__SIPTypesAndValues::INVITE__Request(p_ind.requestLine(), p_ind.msgHeader(), p_ind.messageBody(), p_ind.payload()));
    } else if (p_ind.requestLine().method() == LibSip__SIPTypesAndValues::Method::NOTIFY__E) {
      incoming_message(LibSip__SIPTypesAndValues::NOTIFY__Request(p_ind.requestLine(), p_ind.msgHeader(), p_ind.messageBody(), p_ind.payload()));
    } else if (p_ind.requestLine().method() == LibSip__SIPTypesAndValues::Method::BYE__E) {
      incoming_message(LibSip__SIPTypesAndValues::BYE__Request(p_ind.requestLine(), p_ind.msgHeader(), p_ind.messageBody(), p_ind.payload()));
    } else {
      incoming_message(p_ind);
    }
  } // End of method receiveMsg
  
  void SipPort::receiveMsg (const LibSip__SIPTypesAndValues::Response& p_ind, const params& p_params) {
    loggers::get_instance().log_msg(">>> SipPort::receive_msg: ", p_ind);
    
    // Sanity check
    if (!p_ind.is_bound()) {
      return;
    }
    
    incoming_message(p_ind);
  } // End of method receiveMsg
  
  void SipPort::outgoing_send(const LibSip__SIPTypesAndValues::INVITE__Request& send_par, const Address4SIP *destination_address)
  {
    loggers::get_instance().log_msg(">>> SipPort::outgoing_send: ", send_par);
    loggers::get_instance().log(">>> SipPort::outgoing_send: %s", destination_address);

    float duration;
    loggers::get_instance().set_start_time(_time_key);
    params params;
    static_cast<sip_layer*>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  } // End of outgoing_send
  
  void SipPort::outgoing_send(const LibSip__SIPTypesAndValues::REGISTER__Request& send_par, const Address4SIP *destination_address) {
    loggers::get_instance().log_msg(">>> SipPort::outgoing_send: ", send_par);
    loggers::get_instance().log(">>> SipPort::outgoing_send: %s", destination_address);

    float duration;
    loggers::get_instance().set_start_time(_time_key);
    params params;
    static_cast<sip_layer*>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }
  
  void SipPort::outgoing_send(const LibSip__SIPTypesAndValues::SUBSCRIBE__Request& send_par, const Address4SIP *destination_address) {
    loggers::get_instance().log_msg(">>> SipPort::outgoing_send: ", send_par);
    loggers::get_instance().log(">>> SipPort::outgoing_send: %s", destination_address);

    float duration;
    loggers::get_instance().set_start_time(_time_key);
    params params;
    static_cast<sip_layer*>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }
  
  void SipPort::outgoing_send(const LibSip__SIPTypesAndValues::MESSAGE__Request& send_par, const Address4SIP *destination_address) {
    loggers::get_instance().log_msg(">>> SipPort::outgoing_send: ", send_par);
    loggers::get_instance().log(">>> SipPort::outgoing_send: %s", destination_address);

    float duration;
    loggers::get_instance().set_start_time(_time_key);
    params params;
    static_cast<sip_layer*>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }
  
  void SipPort::outgoing_send(const LibSip__SIPTypesAndValues::OPTIONS__Request& send_par, const Address4SIP *destination_address) {
    loggers::get_instance().log_msg(">>> SipPort::outgoing_send: ", send_par);
    loggers::get_instance().log(">>> SipPort::outgoing_send: %s", destination_address);

    float duration;
    loggers::get_instance().set_start_time(_time_key);
    params params;
    static_cast<sip_layer*>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }
  
}

