
#include "LibSip_EncdecDeclarations.hh"
#include "LibSip_XMLTypes.hh"

#include "sip_codec_register_request.hh"
#include "sip_codec_invite_request.hh"
#include "sip_codec_bye_request.hh"
#include "sip_codec_subscribe_request.hh"
#include "sip_codec_message_body.hh"
#include "sip_codec_response.hh"

#include "loggers.hh"

namespace LibSip__EncdecDeclarations {

  BITSTRING fx__enc__Request(const LibSip__SIPTypesAndValues::Request& p) {
    loggers::get_instance().log_msg(">>> fx__enc__Request: ", p);

    float duration;
    std::string tag("fx__enc__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    sip_codec_request codec;
    if (codec.encode(p, os) == -1) {
      loggers::get_instance().warning("fx__enc__Request -1 result code was returned");
      return int2bit(0, 1);
    }
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  BITSTRING fx__enc__REGISTER__Request(const LibSip__SIPTypesAndValues::REGISTER__Request& p) {
    loggers::get_instance().log_msg(">>> fx__enc__REGISTER__Request: ", p);

    float duration;
    std::string tag("fx__enc__REGISTER__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    sip_codec_register_request codec;
    if (codec.encode(p, os) == -1) {
      loggers::get_instance().warning("fx__enc__REGISTER__Request: -1 result code was returned");
      return int2bit(0, 1);
    }
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  BITSTRING fx__enc__INVITE__Request(const LibSip__SIPTypesAndValues::INVITE__Request& p) {
    loggers::get_instance().log_msg(">>> fx__enc__INVITE__Request: ", p);

    float duration;
    std::string tag("fx__enc__INVITE__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    sip_codec_invite_request codec;
    if (codec.encode(p, os) == -1) {
      loggers::get_instance().warning("fx__enc__INVITE__Request: -1 result code was returned");
      return int2bit(0, 1);
    }
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  BITSTRING fx__enc__OPTIONS__Request(const LibSip__SIPTypesAndValues::OPTIONS__Request& p) { return BITSTRING(); }

  BITSTRING fx__enc__BYE__Request(const LibSip__SIPTypesAndValues::BYE__Request& p) {
    loggers::get_instance().log_msg(">>> fx__enc__BYE__Request: ", p);

    float duration;
    std::string tag("fx__enc__BYE__Request");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    sip_codec_bye_request codec;
    if (codec.encode(p, os) == -1) {
      loggers::get_instance().warning("fx__enc__BYE__Request: -1 result code was returned");
      return int2bit(0, 1);
    }
    loggers::get_instance().set_stop_time(tag, duration);

    return oct2bit(os);
  }

  BITSTRING fx__enc__CANCEL__Request(const LibSip__SIPTypesAndValues::CANCEL__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__ACK__Request(const LibSip__SIPTypesAndValues::ACK__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__PRACK__Request(const LibSip__SIPTypesAndValues::PRACK__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__NOTIFY__Request(const LibSip__SIPTypesAndValues::NOTIFY__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__SUBSCRIBE__Request(const LibSip__SIPTypesAndValues::SUBSCRIBE__Request& p) {
        loggers::get_instance().log_msg(">>> fx__enc__SUBSCRIBE__Request: ", p);

        float duration;
        std::string tag("fx__enc__SUBSCRIBE__Request");
        loggers::get_instance().set_start_time(tag);

        OCTETSTRING os;
        sip_codec_subscribe_request codec;
        if (codec.encode(p, os) == -1) {
          loggers::get_instance().warning("fx__enc__SUBSCRIBE__Request: -1 result code was returned");
          return int2bit(0, 1);
        }
        loggers::get_instance().set_stop_time(tag, duration);

        return oct2bit(os);
  }

  BITSTRING fx__enc__PUBLISH__Request(const LibSip__SIPTypesAndValues::PUBLISH__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__UPDATE__Request(const LibSip__SIPTypesAndValues::UPDATE__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__REFER__Request(const LibSip__SIPTypesAndValues::REFER__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__MESSAGE__Request(const LibSip__SIPTypesAndValues::MESSAGE__Request& p) { return BITSTRING(); }
  BITSTRING fx__enc__INFO__Request(const LibSip__SIPTypesAndValues::INFO__Request& p) { return BITSTRING(); }
  
  BITSTRING fx__enc__Response(const LibSip__SIPTypesAndValues::Response& p) {
    loggers::get_instance().log_msg(">>> fx__enc__Response: ", p);

    float duration;
    std::string tag("fx__enc__Response");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    sip_codec_response codec;
    if (codec.encode(p, os) == -1) {
      loggers::get_instance().warning("fx__enc__Response: -1 result code was returned");
      return int2bit(0, 1);
    }
    loggers::get_instance().set_stop_time(tag, duration);
    
    return oct2bit(os);
  }
  
  BITSTRING fx__enc__Raw(const CHARSTRING& p) { return BITSTRING(); }
  BITSTRING fx__enc__SMS(const LibSip__SimpleMsgSummaryTypes::SimpleMsgSummary& pdu) { return BITSTRING(); }

  BITSTRING fx__enc__MessageBody(const LibSip__MessageBodyTypes::MessageBody& pdu) {
    loggers::get_instance().log_msg(">>> fx__enc__MessageBody: ", pdu);

    float duration;
    std::string tag("fx__enc__MessageBody");
    loggers::get_instance().set_start_time(tag);

    OCTETSTRING os;
    sip_codec_message_body codec;
    if (codec.encode(pdu, os) == -1) {
      loggers::get_instance().warning("fx__enc__MessageBody: -1 result code was returned");
      return int2bit(0, 1);
    }
    loggers::get_instance().set_stop_time(tag, duration);

    return oct2bit(os);
  }
  
  INTEGER fx__dec__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::Request& p) {
    loggers::get_instance().log_msg(">>> fx__dec__Request: ", pdu);

    OCTETSTRING os = bit2oct(pdu);
    sip_codec_request codec;
    codec.decode(os, p);

    return 0;
  }

  INTEGER fx__dec__REGISTER__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::REGISTER__Request& p) {
    loggers::get_instance().log_msg(">>> fx__dec__REGISTER__Request: ", pdu);

    OCTETSTRING os = bit2oct(pdu);
    sip_codec_register_request codec;
    codec.decode(os, p);

    return 0;
  }

  INTEGER fx__dec__INVITE__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::INVITE__Request& p) {
    loggers::get_instance().log_msg(">>> fx__dec__INVITE__Request: ", pdu);

    OCTETSTRING os = bit2oct(pdu);
    sip_codec_invite_request codec;
    codec.decode(os, p);

    return 0;
  }
  
  INTEGER fx__dec__OPTIONS__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::OPTIONS__Request& p) { return INTEGER(0); }

  INTEGER fx__dec__BYE__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::BYE__Request& p) {
    loggers::get_instance().log_msg(">>> fx__dec__BYE__Request: ", pdu);

    OCTETSTRING os = bit2oct(pdu);
    sip_codec_bye_request codec;
    codec.decode(os, p);

    return 0;
  }

  INTEGER fx__dec__CANCEL__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::CANCEL__Request& p) { return INTEGER(0); }
  INTEGER fx__dec__ACK__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::ACK__Request& p) { return INTEGER(0); }
  INTEGER fx__dec__PRACK__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::PRACK__Request& p) { return INTEGER(0); }
  INTEGER fx__dec__NOTIFY__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::NOTIFY__Request& p) { return INTEGER(0); }

  INTEGER fx__dec__SUBSCRIBE__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::SUBSCRIBE__Request& p) {
    loggers::get_instance().log_msg(">>> fx__dec__SUBSCRIBE__Request: ", pdu);

    OCTETSTRING os = bit2oct(pdu);
    sip_codec_subscribe_request codec;
    codec.decode(os, p);

    return 0;
  }

  INTEGER fx__dec__PUBLISH__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::PUBLISH__Request& p) { return INTEGER(0); }
  INTEGER fx__dec__UPDATE__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::UPDATE__Request& p) { return INTEGER(0); }
  INTEGER fx__dec__REFER__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::REFER__Request& p) { return INTEGER(0); }
  INTEGER fx__dec__MESSAGE__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::MESSAGE__Request& p) { return INTEGER(0); }
  INTEGER fx__dec__INFO__Request(BITSTRING& pdu, LibSip__SIPTypesAndValues::INFO__Request& p) { return INTEGER(0); }
  
  INTEGER fx__dec__Response(BITSTRING& pdu, LibSip__SIPTypesAndValues::Response& p) {
    loggers::get_instance().log_msg(">>> fx__dec__Response: ", pdu);

    OCTETSTRING os = bit2oct(pdu);
    sip_codec_response codec;
    codec.decode(os, p);

    return 0;
  }
  
  INTEGER fx__dec__SMS(BITSTRING& pdu, LibSip__SimpleMsgSummaryTypes::SimpleMsgSummary& p) { return INTEGER(0); }

  INTEGER fx__dec__MessageBody(BITSTRING& pdu, LibSip__MessageBodyTypes::MessageBody& p) {
    loggers::get_instance().log_msg(">>> fx__dec__MessageBody: ", pdu);

    OCTETSTRING os = bit2oct(pdu);
    sip_codec_message_body codec;
    codec.decode(os, p);

    return 0;
  }
} // End of namespace LibSip__EncdecDeclarations
