# NG112

## Introduction
This repositories contains the test specifications and test adapter code
to test compliance to ETSI TS 103 479 (V1.1.1: “Emergency Communications (EMTEL); Core elements for network independent access to emergency services”.

## Contact information
Email at cti_support at etsi dot org

## License
Unless specified otherwise, the content of this repository and the files contained are released under the ETSI Software License.
See the attached LICENSE file or visit
https://forge.etsi.org/etsi-software-license

## Standard links
- ETSI TS 103 650-1, Part 1: Test Purposes - Available soon
- ETSI TS 103 650-2, Part 2: Test Suite - Available soon
- ETSI TS 103 479, Core elements for network independent access to emergency services - Available soon
- Next Generation 112 Long Term Definition, accessible [here](https://eena.org/wp-content/uploads/2018/11/Next-Generation-112-Long-Term-Definition-Standard-For-Emergency-Services.pdf)

## RFC links
- RFC 5222 - LoST: A Location-to-Service Translation Protocol, accessible [here](https://tools.ietf.org/html/rfc5222)
- RFC 5985 - HELD, accessible [here](https://tools.ietf.org/html/rfc5985)
- RFC 6155 - Use of Device Identity in HTTP-Enabled Location Delivery (HELD), accessible [here](https://tools.ietf.org/html/rfc6155)
- RFC 3863 - Presence Information Data Format (PIDF), accessible [here](https://tools.ietf.org/html/rfc3863)
- RFC 4119 - A Presence-based GEOPRIV Location Object Format, accessible [here](https://tools.ietf.org/html/rfc4119)
- RFC 5139 - Revised Civic Location Format for Presence Information Data Format Location Object (PIDF-LO), accessible [here](https://tools.ietf.org/html/rfc5139)
- RFC 7459 - Representation of Uncertainty and Confidence in the Presence Information Data Format Location Object (PIDF-LO), accessible [here](https://tools.ietf.org/html/rfc7459)

NOTE All draft can be found in the 'IETF XML Registry', accessible [here](https://www.iana.org/assignments/xml-registry/xml-registry.xhtml)

## Installation

The ETSI Emergency Communications project builds and tests regularly on the following platforms:

  - Linux (Ubuntu)

Note: The [OpenSSL](https://www.openssl.org) version > 1.1.x is also required.

### How to do it?

They are two different methods:
- Using [Vagrant](https://www.vagrantup.com/)
- Using [Docker](https://www.docker.com/)

How to choose one of these methods is depending of your host system.

NOTE: In all case, if you want to setup an continuous integration process (e.g. Jenkins), Docker is the best choice. 


#### The host system is Windows
The both methods require a virtual machine. You can use either VirtualBox or WMware.
In this case, the easiest way is to use Vagrant.


#### The host system is Linux
Vagrant requires a virtual machine. You can use either VirtualBox or WMware.
Docker does not need a virtual machine, so it is the more efficant way.


### Using Vagrant

Pre-requisites on your host machine:
- Install [Virtualbox](https://www.virtualbox.org/manual/ch01.html)
- Install [Vagrant](https://www.vagrantup.com/intro/getting-started/)
- Install Vagrant plugin vagrant-vbguest
- Credentials to access [ETSI forge](https://forge.etsi.org/gitlab/users/sign_in)
    - Set the environment variable USERNAME to your ETSI EOL account user name
    - Set the environment variable PASSWORD to your ETSI EOL account password

Procedure:
- On your host machine, open a command line session (PuTTY, DOS window...)
- From the ETSI Emergency Communications project, clone the Vagrant folder
- In the file Vagrantfile, modify the tag config.vm.provision replacing <username> & <password> strings by your ETSI credentials
- In the Vagrant folder, execute the following commands:

```sh
$ vagrant up --provider virtualbox --provision
...
```

NOTE The creation and the installations will take some time to achieve
- Stop vagrant virtual machine

```sh
$ vagrant halt
...
```

- Update the file 'Vagrantfile' to match with your networks configuration
- Re-start the vagrant virtual machine and log to to the machine

```sh
$ vagrant up
...
$ vagrant ssh
```

- Switch to the next clause (Usage)

NOTE The user password is vagrant.


### Using Docker

Pre-requisites on your host machine:
- Install Virtualbox
- Install Docker

Procedure for a Windows host machine:
- On your host machine, open a the Docker Quickstart Terminal
- On your host machine, clone the ETSI EEmergency Communications project. NOTE that only Docker folder and .jenkins.sh script file are required
- From the ETSI Emergency Communications project root directory, execute the following commands:

```sh
$ ./.jenkins.sh
...
```

NOTE The creation and the installations will take some time to achieve
- Start the container

```sh
$ ./docker/run-container.sh
...
```

- Switch to the next clause (Usage)


### From scratch

Pre-requisites:
- Install Virtualbox

Procedure:
- Install a new Linux Virtual machine (Mint, Debian...)
- Update your system with the latest version of kernel and security packages
- Install the following packages (According to the Linux chosen, the package naming can be different)
    autoconf
    bison
    build-essential
    cmake
    curl
    dos2unix
    doxygen
    emacs
    expect
    flex
    g++:latest
    gcc:latest
    graphviz
    gdb 
    git-core
    gnutls-bin
    libglib2.0-dev
    libpcap-dev
    libgcrypt-dev
    libncurses5-dev
    libssl-dev
    libtool-bin
    libtool
    libwireshark-dev
    libxml2-dev
    lsof
    ntp
    pkg-config
    qt5-default
    qtmultimedia5-dev
    libqt5svg5-dev
    subversion
    sudo
    sshpass
    tcpdump
    texlive-font-utils
    tshark
    valgrind
    vim
    vsftpd
    xutils-dev 
    tree
    tzdata
    unzip
    wget
    xsltproc
- In your home directory, create the following folders: 
    - $HOME/frameworks, 
    - $HOME/dev
    - $HOME/lib
- In $HOME/frameworks, build the following package:
    - Eclipse IDE for C/C++ Developers, according the procedure specified [here](https://www.eclipse.org/cdt/)
    - TITAN, according the procedure specified [here](https://github.com/eclipse/titan.core)
    - Import the TITAN plugin into your Eclipse IDE, according the procedure specified [here](https://github.com/eclipse/titan.core)
- Clone the ETSI Emergency Communications project into $HOME/dev folder

```sh
$ git clone 
```

- Update your default environment with the content of the script $HOME/dev/STF549_Ng112/scripts/devenv.bash.ubuntu
- Switch to the next clause (Usage)


## Usage

This clause describes how to compile and execute an Abstract Test Suite.
The procedures below illustrate how to run the CAM test suite. The same procedures will apply for any other ETSI Emergency Communications test suite.


Pre-requisites:
- Your machine is installed following one of the installation method describes in the previous clause
- Your are logged as 'etsi' or 'vagrant' user

Procedure using Eclipse TITAN:
- Start eclipse using a new workspace, (e.g. with the name workspace_titan)
- Download and follow the steps to install Eclipse plugins for TITAN, accessible [here]{https://www.eclipse.org/downloads/download.php?file=/titan/Eclipse_installationguide.pdf}
- Open the workspace_titan
- Create a new TITAN project (e.g. STF549_Ng112)
<TODO>

Procedure in TITAN command line:
- Open several SSH session (PuTTY...)
- Change to the directory ~/dev/STF549_Ng112/src/AtsNg112/objs
- Build the test suite AtsNg112

```sh
$ ../bin/ng112_generate_makefile.bash
...
```

- Edit the file ../etc/AtsNg112.cfg
- Update the following fields:
    - system.httpPort.params
    - Caller.SIPP.params
    - Ecrf.SIPP.params
    - CallTaker.SIPP.params

- To run the test suitem, execute the following command:

```sh
$ ../bin/run-all.bash
...
```

- The log files are located in ../logs folder. You can edit them using any editor or using the Eclipse TITAN log plugins


## How to Report a Bug

The ETSI Emergency Communications project is under constant development, so it is possible that you will
encounter a bug while using it. Please report bugs at cti_support at etsi dot org.
