/* a_x509a.c */
/* Written by Dr Stephen N Henson (shenson@bigfoot.com) for the OpenSSL
 * project 1999.
 */
/* ====================================================================
 * Copyright (c) 1999 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    licensing@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

#include <stdio.h>
#include "cryptlib.h"
#include <openssl/evp.h>
#include <openssl/asn1_mac.h>
#include <openssl/x509.h>

/* X509_CERT_AUX routines. These are used to encode additional
 * user modifiable data about a certificate. This data is
 * appended to the X509 encoding when the *_X509_AUX routines
 * are used. This means that the "traditional" X509 routines
 * will simply ignore the extra data. 
 */

static X509_CERT_AUX *aux_get(X509 *x);

X509_CERT_AUX *d2i_X509_CERT_AUX(X509_CERT_AUX **a, unsigned char **pp, long length)
{
	M_ASN1_D2I_vars(a, X509_CERT_AUX *, X509_CERT_AUX_new);
	
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();

	M_ASN1_D2I_get_opt(ret->trust, d2i_ASN1_BIT_STRING,
							V_ASN1_BIT_STRING);
	M_ASN1_D2I_get_IMP_opt(ret->reject, d2i_ASN1_BIT_STRING,0,
							V_ASN1_BIT_STRING);

	M_ASN1_D2I_get_seq_opt_type(ASN1_OBJECT, ret->othertrust,
					d2i_ASN1_OBJECT, ASN1_OBJECT_free);
	M_ASN1_D2I_get_IMP_set_opt_type(ASN1_OBJECT, ret->otherreject,
					d2i_ASN1_OBJECT, ASN1_OBJECT_free, 1);
	M_ASN1_D2I_get_opt(ret->alias, d2i_ASN1_UTF8STRING, V_ASN1_UTF8STRING);
	M_ASN1_D2I_get_opt(ret->other, d2i_ASN1_TYPE, V_ASN1_SEQUENCE);

	M_ASN1_D2I_Finish(a, X509_CERT_AUX_free, ASN1_F_D2I_X509_CERT_AUX);
}

X509_CERT_AUX *X509_CERT_AUX_new()
{
	X509_CERT_AUX *ret = NULL;
	ASN1_CTX c;
	M_ASN1_New_Malloc(ret, X509_CERT_AUX);
	ret->trust = NULL;
	ret->reject = NULL;
	ret->othertrust = NULL;
	ret->otherreject = NULL;
	ret->alias = NULL;
	ret->other = NULL;
	return(ret);
	M_ASN1_New_Error(ASN1_F_X509_CERT_AUX_NEW);
}

void X509_CERT_AUX_free(X509_CERT_AUX *a)
{
	if(a == NULL) return;
	ASN1_BIT_STRING_free(a->trust);
	ASN1_BIT_STRING_free(a->reject);
	sk_ASN1_OBJECT_pop_free(a->othertrust, ASN1_OBJECT_free);
	sk_ASN1_OBJECT_pop_free(a->otherreject, ASN1_OBJECT_free);
	ASN1_UTF8STRING_free(a->alias);
	ASN1_TYPE_free(a->other);
	Free((char *)a);
}

int i2d_X509_CERT_AUX(X509_CERT_AUX *a, unsigned char **pp)
{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len(a->trust, i2d_ASN1_BIT_STRING);	
	M_ASN1_I2D_len_IMP_opt(a->reject, i2d_ASN1_BIT_STRING);

	M_ASN1_I2D_len_SEQUENCE_opt_type(ASN1_OBJECT, a->othertrust, i2d_ASN1_OBJECT);
	M_ASN1_I2D_len_IMP_SEQUENCE_opt_type(ASN1_OBJECT, a->otherreject, i2d_ASN1_OBJECT, 1);

	M_ASN1_I2D_len(a->alias, i2d_ASN1_UTF8STRING);
	M_ASN1_I2D_len(a->other, i2d_ASN1_TYPE);

	M_ASN1_I2D_seq_total();

	M_ASN1_I2D_put(a->trust, i2d_ASN1_BIT_STRING);	
	M_ASN1_I2D_put_IMP_opt(a->reject, i2d_ASN1_BIT_STRING, 0);

	M_ASN1_I2D_put_SEQUENCE_opt_type(ASN1_OBJECT, a->othertrust, i2d_ASN1_OBJECT);
	M_ASN1_I2D_put_IMP_SEQUENCE_opt_type(ASN1_OBJECT, a->otherreject, i2d_ASN1_OBJECT, 1);

	M_ASN1_I2D_put(a->alias, i2d_ASN1_UTF8STRING);
	M_ASN1_I2D_put(a->other, i2d_ASN1_TYPE);

	M_ASN1_I2D_finish();
}

static X509_CERT_AUX *aux_get(X509 *x)
{
	if(!x) return NULL;
	if(!x->aux && !(x->aux = X509_CERT_AUX_new())) return NULL;
	return x->aux;
}

int X509_alias_set(X509 *x, unsigned char *name, int len)
{
	X509_CERT_AUX *aux;
	if(!(aux = aux_get(x))) return 0;
	if(!aux->alias && !(aux->alias = ASN1_UTF8STRING_new())) return 0;
	return ASN1_STRING_set(aux->alias, name, len);
}

unsigned char *X509_alias_get(X509 *x, int *len)
{
	if(!x->aux || !x->aux->alias) return NULL;
	if(len) *len = x->aux->alias->length;
	return x->aux->alias->data;
}

int X509_trust_set_bit(X509 *x, int bit, int value)
{
	X509_CERT_AUX *aux;
	if(bit == -1) {
		if(x->aux && x->aux->trust) {
			ASN1_BIT_STRING_free(x->aux->trust);
			x->aux->trust = NULL;
		}
		return 1;
	}
	if(!(aux = aux_get(x))) return 0;
	if(!aux->trust && !(aux->trust = ASN1_BIT_STRING_new())) return 0;
	return ASN1_BIT_STRING_set_bit(aux->trust, bit, value);
}

int X509_reject_set_bit(X509 *x, int bit, int value)
{
	X509_CERT_AUX *aux;
	if(bit == -1) {
		if(x->aux && x->aux->reject) {
			ASN1_BIT_STRING_free(x->aux->reject);
			x->aux->reject = NULL;
		}
		return 1;
	}
	if(!(aux = aux_get(x))) return 0;
	if(!aux->reject && !(aux->reject = ASN1_BIT_STRING_new())) return 0;
	return ASN1_BIT_STRING_set_bit(aux->reject, bit, value);
}

int X509_add_trust_object(X509 *x, ASN1_OBJECT *obj)
{
	X509_CERT_AUX *aux;
	if(!(aux = aux_get(x))) return 0;
	if(!aux->othertrust
		&& !(aux->othertrust = sk_ASN1_OBJECT_new_null())) return 0;
	return sk_ASN1_OBJECT_push(aux->othertrust, obj);
}

int X509_add_reject_object(X509 *x, ASN1_OBJECT *obj)
{
	X509_CERT_AUX *aux;
	if(!(aux = aux_get(x))) return 0;
	if(!aux->otherreject
		&& !(aux->otherreject = sk_ASN1_OBJECT_new_null())) return 0;
	return sk_ASN1_OBJECT_push(aux->otherreject, obj);
}

